/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.variable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.variable.VariableType;
import org.flowable.engine.impl.variable.VariableTypes;

public class DefaultVariableTypes
implements VariableTypes,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<VariableType> typesList = new ArrayList<VariableType>();
    private final Map<String, VariableType> typesMap = new HashMap<String, VariableType>();

    @Override
    public DefaultVariableTypes addType(VariableType type) {
        return this.addType(type, this.typesList.size());
    }

    @Override
    public DefaultVariableTypes addType(VariableType type, int index) {
        this.typesList.add(index, type);
        this.typesMap.put(type.getTypeName(), type);
        return this;
    }

    public void setTypesList(List<VariableType> typesList) {
        this.typesList.clear();
        this.typesList.addAll(typesList);
        this.typesMap.clear();
        for (VariableType type : typesList) {
            this.typesMap.put(type.getTypeName(), type);
        }
    }

    @Override
    public VariableType getVariableType(String typeName) {
        return this.typesMap.get(typeName);
    }

    @Override
    public VariableType findVariableType(Object value) {
        for (VariableType type : this.typesList) {
            if (!type.isAbleToStore(value)) continue;
            return type;
        }
        throw new FlowableException("couldn't find a variable type that is able to serialize " + value);
    }

    @Override
    public int getTypeIndex(VariableType type) {
        return this.typesList.indexOf(type);
    }

    @Override
    public int getTypeIndex(String typeName) {
        VariableType type = this.typesMap.get(typeName);
        if (type != null) {
            return this.getTypeIndex(type);
        }
        return -1;
    }

    @Override
    public VariableTypes removeType(VariableType type) {
        this.typesList.remove(type);
        this.typesMap.remove(type.getTypeName());
        return this;
    }
}

