/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricTaskInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class TaskCreatedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "task-created";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity historicActivityInstanceEntity;
        String activityId;
        String executionId = this.getStringFromJson(historicalData, "executionId");
        return !StringUtils.isNotEmpty((CharSequence)executionId) || !StringUtils.isNotEmpty((CharSequence)(activityId = this.getStringFromJson(historicalData, "activityId"))) || (historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId)) != null;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity historicActivityInstanceEntity;
        String activityId;
        HistoricTaskInstanceEntityManager historicTaskInstanceEntityManager = CommandContextUtil.getHistoricTaskInstanceEntityManager(commandContext);
        String taskId = this.getStringFromJson(historicalData, "id");
        String executionId = this.getStringFromJson(historicalData, "executionId");
        HistoricTaskInstanceEntity historicTaskInstance = (HistoricTaskInstanceEntity)historicTaskInstanceEntityManager.findById(taskId);
        if (historicTaskInstance == null) {
            historicTaskInstance = (HistoricTaskInstanceEntity)historicTaskInstanceEntityManager.create();
            historicTaskInstance.setId(taskId);
            historicTaskInstance.setProcessDefinitionId(this.getStringFromJson(historicalData, "processDefinitionId"));
            historicTaskInstance.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
            historicTaskInstance.setExecutionId(executionId);
            historicTaskInstance.setName(this.getStringFromJson(historicalData, "name"));
            historicTaskInstance.setParentTaskId(this.getStringFromJson(historicalData, "parentTaskId"));
            historicTaskInstance.setDescription(this.getStringFromJson(historicalData, "description"));
            historicTaskInstance.setOwner(this.getStringFromJson(historicalData, "owner"));
            historicTaskInstance.setAssignee(this.getStringFromJson(historicalData, "assignee"));
            historicTaskInstance.setStartTime(this.getDateFromJson(historicalData, "startTime"));
            historicTaskInstance.setTaskDefinitionKey(this.getStringFromJson(historicalData, "taskDefinitionKey"));
            historicTaskInstance.setPriority(this.getIntegerFromJson(historicalData, "priority"));
            historicTaskInstance.setDueDate(this.getDateFromJson(historicalData, "dueDate"));
            historicTaskInstance.setCategory(this.getStringFromJson(historicalData, "category"));
            historicTaskInstance.setTenantId(this.getStringFromJson(historicalData, "tenantId"));
            historicTaskInstance.setLastUpdateTime(this.getDateFromJson(historicalData, "__timeStamp"));
            historicTaskInstanceEntityManager.insert(historicTaskInstance);
        }
        if (StringUtils.isNotEmpty((CharSequence)executionId) && StringUtils.isNotEmpty((CharSequence)(activityId = this.getStringFromJson(historicalData, "activityId"))) && (historicActivityInstanceEntity = this.findHistoricActivityInstance(commandContext, executionId, activityId)) != null) {
            historicActivityInstanceEntity.setTaskId(taskId);
        }
    }
}

