/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsProcessInstanceHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ProcessInstancePropertyChangedHistoryJsonTransformer
extends AbstractNeedsProcessInstanceHistoryJsonTransformer {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_BUSINESS_KEY = "businessKey";

    @Override
    public String getType() {
        return "process-instance-property-changed";
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String processInstanceId = this.getStringFromJson(historicalData, "processInstanceId");
        String property = this.getStringFromJson(historicalData, "property");
        if (StringUtils.isNotEmpty((CharSequence)processInstanceId) && StringUtils.isNotEmpty((CharSequence)property)) {
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)CommandContextUtil.getHistoricProcessInstanceEntityManager(commandContext).findById(processInstanceId);
            if (PROPERTY_NAME.equals(property)) {
                historicProcessInstance.setName(this.getStringFromJson(historicalData, PROPERTY_NAME));
            } else if (PROPERTY_BUSINESS_KEY.equals(property)) {
                historicProcessInstance.setBusinessKey(this.getStringFromJson(historicalData, PROPERTY_BUSINESS_KEY));
            }
        }
    }
}

