/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Date;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class ActivityFullHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    @Override
    public String getType() {
        return "activity-full";
    }

    @Override
    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        return true;
    }

    @Override
    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntityManager historicActivityInstanceEntityManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricActivityInstanceEntityManager();
        HistoricActivityInstanceEntity historicActivityInstanceEntity = (HistoricActivityInstanceEntity)historicActivityInstanceEntityManager.create();
        historicActivityInstanceEntity.setId(CommandContextUtil.getProcessEngineConfiguration(commandContext).getIdGenerator().getNextId());
        historicActivityInstanceEntity.setProcessDefinitionId(this.getStringFromJson(historicalData, "processDefinitionId"));
        historicActivityInstanceEntity.setProcessInstanceId(this.getStringFromJson(historicalData, "processInstanceId"));
        historicActivityInstanceEntity.setExecutionId(this.getStringFromJson(historicalData, "executionId"));
        historicActivityInstanceEntity.setActivityId(this.getStringFromJson(historicalData, "activityId"));
        historicActivityInstanceEntity.setActivityName(this.getStringFromJson(historicalData, "activityName"));
        historicActivityInstanceEntity.setActivityType(this.getStringFromJson(historicalData, "activityType"));
        historicActivityInstanceEntity.setStartTime(this.getDateFromJson(historicalData, "startTime"));
        historicActivityInstanceEntity.setTenantId(this.getStringFromJson(historicalData, "tenantId"));
        Date endTime = this.getDateFromJson(historicalData, "endTime");
        historicActivityInstanceEntity.setEndTime(endTime);
        historicActivityInstanceEntity.setDeleteReason(this.getStringFromJson(historicalData, "deleteReason"));
        Date startTime = historicActivityInstanceEntity.getStartTime();
        if (startTime != null && endTime != null) {
            historicActivityInstanceEntity.setDurationInMillis(endTime.getTime() - startTime.getTime());
        }
        historicActivityInstanceEntityManager.insert(historicActivityInstanceEntity);
        this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_CREATED, historicActivityInstanceEntity));
        this.dispatchEvent(commandContext, (FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstanceEntity));
    }
}

