/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableWrongDbException;
import org.flowable.engine.common.impl.db.DbSchemaManager;
import org.flowable.engine.common.impl.db.DbSqlSession;
import org.flowable.engine.common.impl.db.DbSqlSessionFactory;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.common.impl.util.IoUtil;
import org.flowable.engine.common.impl.util.ReflectUtil;
import org.flowable.engine.impl.db.FlowableVersion;
import org.flowable.engine.impl.db.upgrade.DbUpgradeStep;
import org.flowable.engine.impl.persistence.entity.PropertyEntity;
import org.flowable.engine.impl.persistence.entity.PropertyEntityImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDbSchemaManager
implements DbSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDbSchemaManager.class);
    protected static final Pattern CLEAN_VERSION_REGEX = Pattern.compile("\\d\\.\\d*");
    protected static final String LAST_V5_VERSION = "5.99.0.0";
    protected static final List<FlowableVersion> FLOWABLE_VERSIONS = new ArrayList<FlowableVersion>();
    public static String[] JDBC_METADATA_TABLE_TYPES;

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"6.1.1.0".equals(dbVersion)) {
                throw new FlowableWrongDbException("6.1.1.0", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (errorMessage != null) {
                throw new FlowableException("Flowable database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new FlowableException("no flowable tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in flowable.cfg.xml for automatic schema creation", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlowableException("couldn't get db schema version", (Throwable)e);
        }
        LOGGER.debug("flowable db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        String selectSchemaVersionStatement = dbSqlSession.getDbSqlSessionFactory().mapStatement("org.flowable.engine.impl.persistence.entity.PropertyEntityImpl.selectDbSchemaVersion");
        return (String)dbSqlSession.getSqlSession().selectOne(selectSchemaVersionStatement);
    }

    public void dbSchemaCreate() {
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"6.1.1.0".equals(dbVersion)) {
                throw new FlowableWrongDbException("6.1.1.0", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
    }

    public void dbSchemaDrop() {
        this.executeMandatorySchemaResource("drop", "engine");
        if (CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    public String dbSchemaUpdate() {
        String feedback = null;
        boolean isUpgradeNeeded = false;
        int matchingVersionIndex = -1;
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        if (this.isEngineTablePresent()) {
            PropertyEntity dbVersionProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntityImpl.class, "schema.version");
            String dbVersion = dbVersionProperty.getValue();
            matchingVersionIndex = this.findMatchingVersionIndex(dbVersion);
            if (matchingVersionIndex < 0 && dbVersion != null && dbVersion.startsWith("5.")) {
                matchingVersionIndex = this.findMatchingVersionIndex(LAST_V5_VERSION);
            }
            if (matchingVersionIndex < 0) {
                throw new FlowableException("Could not update Flowable database schema: unknown version from database: '" + dbVersion + "'");
            }
            boolean bl = isUpgradeNeeded = matchingVersionIndex != FLOWABLE_VERSIONS.size() - 1;
            if (isUpgradeNeeded) {
                PropertyEntity dbHistoryProperty;
                dbVersionProperty.setValue("6.1.1.0");
                if ("5.0".equals(dbVersion)) {
                    dbHistoryProperty = (PropertyEntity)CommandContextUtil.getPropertyEntityManager().create();
                    dbHistoryProperty.setName("schema.history");
                    dbHistoryProperty.setValue("create(5.0)");
                    dbSqlSession.insert((Entity)dbHistoryProperty);
                } else {
                    dbHistoryProperty = (PropertyEntity)dbSqlSession.selectById(PropertyEntity.class, "schema.history");
                }
                String dbHistoryValue = dbHistoryProperty.getValue() + " upgrade(" + dbVersion + "->" + "6.1.1.0" + ")";
                dbHistoryProperty.setValue(dbHistoryValue);
                this.dbSchemaUpgrade("engine", matchingVersionIndex);
                feedback = "upgraded Flowable from " + dbVersion + " to " + "6.1.1.0";
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (this.isHistoryTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("history", matchingVersionIndex);
            }
        } else if (dbSqlSession.getDbSqlSessionFactory().isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        return feedback;
    }

    protected int findMatchingVersionIndex(String dbVersion) {
        int index = 0;
        int matchingVersionIndex = -1;
        while (matchingVersionIndex < 0 && index < FLOWABLE_VERSIONS.size()) {
            if (FLOWABLE_VERSIONS.get(index).matches(dbVersion)) {
                matchingVersionIndex = index;
                continue;
            }
            ++index;
        }
        return matchingVersionIndex;
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        String databaseType;
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        DbSqlSessionFactory dbSqlSessionFactory = dbSqlSession.getDbSqlSessionFactory();
        if (!dbSqlSession.getDbSqlSessionFactory().isTablePrefixIsSchema()) {
            tableName = this.prependDatabaseTablePrefix(tableName);
        }
        Connection connection = null;
        connection = dbSqlSession.getSqlSession().getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String catalog = dbSqlSession.getConnectionMetadataDefaultCatalog();
        if (dbSqlSessionFactory.getDatabaseCatalog() != null && dbSqlSessionFactory.getDatabaseCatalog().length() > 0) {
            catalog = dbSqlSessionFactory.getDatabaseCatalog();
        }
        String schema = dbSqlSession.getConnectionMetadataDefaultSchema();
        if (dbSqlSessionFactory.getDatabaseSchema() != null && dbSqlSessionFactory.getDatabaseSchema().length() > 0) {
            schema = dbSqlSessionFactory.getDatabaseSchema();
        }
        if ("postgres".equals(databaseType = dbSqlSessionFactory.getDatabaseType())) {
            tableName = tableName.toLowerCase();
        }
        if (schema != null && "oracle".equals(databaseType)) {
            schema = schema.toUpperCase();
        }
        if (catalog != null && catalog.length() == 0) {
            catalog = null;
        }
        try {
            tables = databaseMetaData.getTables(catalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                try {
                    tables.close();
                }
                catch (Exception e) {
                    LOGGER.error("Error closing meta data tables", (Throwable)e);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FlowableException("couldn't check if tables are already present using metadata: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            tables.close();
        }
        catch (Exception e) {
            LOGGER.error("Error closing meta data tables", (Throwable)e);
        }
        return bl;
    }

    protected boolean isUpgradeNeeded(String versionInDatabase) {
        if ("6.1.1.0".equals(versionInDatabase)) {
            return false;
        }
        String cleanDbVersion = this.getCleanVersion(versionInDatabase);
        String[] cleanDbVersionSplitted = cleanDbVersion.split("\\.");
        int dbMajorVersion = Integer.valueOf(cleanDbVersionSplitted[0]);
        int dbMinorVersion = Integer.valueOf(cleanDbVersionSplitted[1]);
        String cleanEngineVersion = this.getCleanVersion("6.1.1.0");
        String[] cleanEngineVersionSplitted = cleanEngineVersion.split("\\.");
        int engineMajorVersion = Integer.valueOf(cleanEngineVersionSplitted[0]);
        int engineMinorVersion = Integer.valueOf(cleanEngineVersionSplitted[1]);
        if (dbMajorVersion > engineMajorVersion || dbMajorVersion <= engineMajorVersion && dbMinorVersion > engineMinorVersion) {
            throw new FlowableException("Version of flowable database (" + versionInDatabase + ") is more recent than the engine (" + "6.1.1.0" + ")");
        }
        if (cleanDbVersion.compareTo(cleanEngineVersion) == 0) {
            LOGGER.warn("Engine-version is the same, but not an exact match: {} vs. {}. Not performing database-upgrade.", (Object)versionInDatabase, (Object)"6.1.1.0");
            return false;
        }
        return true;
    }

    protected String getCleanVersion(String versionString) {
        Matcher matcher = CLEAN_VERSION_REGEX.matcher(versionString);
        if (!matcher.find()) {
            throw new FlowableException("Illegal format for version: " + versionString);
        }
        String cleanString = matcher.group();
        try {
            Double.parseDouble(cleanString);
            return cleanString;
        }
        catch (NumberFormatException nfe) {
            throw new FlowableException("Illegal format for version: " + versionString);
        }
    }

    protected String prependDatabaseTablePrefix(String tableName) {
        return CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().getDatabaseTablePrefix() + tableName;
    }

    protected void dbSchemaUpgrade(String component, int currentDatabaseVersionsIndex) {
        FlowableVersion version = FLOWABLE_VERSIONS.get(currentDatabaseVersionsIndex);
        String dbVersion = version.getMainVersion();
        LOGGER.info("upgrading flowable {} schema from {} to {}", new Object[]{component, dbVersion, "6.1.1.0"});
        for (int i = currentDatabaseVersionsIndex + 1; i < FLOWABLE_VERSIONS.size(); ++i) {
            String nextVersion = FLOWABLE_VERSIONS.get(i).getMainVersion();
            if (nextVersion.endsWith("-SNAPSHOT")) {
                nextVersion = nextVersion.substring(0, nextVersion.length() - "-SNAPSHOT".length());
            }
            dbVersion = dbVersion.replace(".", "");
            nextVersion = nextVersion.replace(".", "");
            LOGGER.info("Upgrade needed: {} -> {}. Looking for schema update resource for component '{}'", new Object[]{dbVersion, nextVersion, component});
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep." + dbVersion + ".to." + nextVersion, component), true);
            dbVersion = nextVersion;
        }
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = CommandContextUtil.getDbSqlSession().getDbSqlSessionFactory().getDatabaseType();
        return "org/flowable/db/" + directory + "/flowable." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream((String)resourceName);
            if (inputStream == null) {
                if (!isOptional) throw new FlowableException("resource '" + resourceName + "' is not available");
                LOGGER.info("no schema resource {} for {}", (Object)resourceName, (Object)operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        finally {
            IoUtil.closeSilently((InputStream)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        LOGGER.info("performing {} on {} with resource {}", new Object[]{operation, component, resourceName});
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        DbSqlSession dbSqlSession = CommandContextUtil.getDbSqlSession();
        try {
            Connection connection = dbSqlSession.getSqlSession().getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream((InputStream)inputStream, (String)resourceName);
            String ddlStatements = new String(bytes);
            try {
                if (dbSqlSession.getDbSqlSessionFactory().isMysql()) {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    int majorVersion = databaseMetaData.getDatabaseMajorVersion();
                    int minorVersion = databaseMetaData.getDatabaseMinorVersion();
                    LOGGER.info("Found MySQL: majorVersion={} minorVersion={}", (Object)majorVersion, (Object)minorVersion);
                    if (majorVersion <= 5 && minorVersion < 6) {
                        ddlStatements = this.updateDdlForMySqlVersionLowerThan56(ddlStatements);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.info("Could not get database metadata", (Throwable)e);
            }
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            boolean inOraclePlsqlBlock = false;
            while (line != null) {
                if (line.startsWith("# ")) {
                    LOGGER.debug(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    LOGGER.debug(line.substring(3));
                } else {
                    if (line.startsWith("execute java ")) {
                        String upgradestepClassName = line.substring(13).trim();
                        DbUpgradeStep dbUpgradeStep = null;
                        try {
                            dbUpgradeStep = (DbUpgradeStep)ReflectUtil.instantiate((String)upgradestepClassName);
                        }
                        catch (FlowableException e) {
                            throw new FlowableException("database update java class '" + upgradestepClassName + "' can't be instantiated: " + e.getMessage(), (Throwable)e);
                        }
                        try {
                            LOGGER.debug("executing upgrade step java class {}", (Object)upgradestepClassName);
                            dbUpgradeStep.execute();
                        }
                        catch (Exception e) {
                            throw new FlowableException("error while executing database update java class '" + upgradestepClassName + "': " + e.getMessage(), (Throwable)e);
                        }
                    }
                    if (line.length() > 0) {
                        if (dbSqlSession.getDbSqlSessionFactory().isOracle() && line.startsWith("begin")) {
                            inOraclePlsqlBlock = true;
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        } else if (line.endsWith(";") && !inOraclePlsqlBlock || line.startsWith("/") && inOraclePlsqlBlock) {
                            if (inOraclePlsqlBlock) {
                                inOraclePlsqlBlock = false;
                            } else {
                                sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                            }
                            Statement jdbcStatement = connection.createStatement();
                            try {
                                LOGGER.debug("SQL: {}", (Object)sqlStatement);
                                jdbcStatement.execute(sqlStatement);
                                jdbcStatement.close();
                            }
                            catch (Exception e) {
                                if (exception == null) {
                                    exception = e;
                                    exceptionSqlStatement = sqlStatement;
                                }
                                LOGGER.error("problem during schema {}, statement {}", new Object[]{operation, sqlStatement, e});
                            }
                            finally {
                                sqlStatement = null;
                            }
                        } else {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        }
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            LOGGER.debug("flowable db schema {} for component {} successful", (Object)operation, (Object)component);
        }
        catch (Exception e) {
            throw new FlowableException("couldn't " + operation + " db schema: " + exceptionSqlStatement, (Throwable)e);
        }
    }

    protected String updateDdlForMySqlVersionLowerThan56(String ddlStatements) {
        return ddlStatements.replace("timestamp(3)", "timestamp").replace("datetime(3)", "datetime").replace("TIMESTAMP(3)", "TIMESTAMP").replace("DATETIME(3)", "DATETIME");
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsProcessEngineBuild() {
        String databaseSchemaUpdate = CommandContextUtil.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        LOGGER.debug("Executing performSchemaOperationsProcessEngineBuild with setting {}", (Object)databaseSchemaUpdate);
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.dbSchemaUpdate();
        }
    }

    public void performSchemaOperationsProcessEngineClose() {
        String databaseSchemaUpdate = CommandContextUtil.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("create-drop".equals(databaseSchemaUpdate)) {
            this.dbSchemaDrop();
        }
    }

    static {
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.7"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.8"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.9"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.10"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.11"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.12", Arrays.asList("5.12.1", "5.12T")));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.13"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.14"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.15"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.15.1"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.16"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.16.1"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.16.2-SNAPSHOT"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.16.2"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.16.3.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.16.4.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.17.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.17.0.1"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.17.0.2"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.18.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.18.0.1"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.20.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.20.0.1"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.20.0.2"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.21.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.22.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.23.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("5.24.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion(LAST_V5_VERSION));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.0.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.0.0.1"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.0.0.2"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.0.0.3"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.0.0.4"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.0.0.5"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.0.1.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.1.0.0"));
        FLOWABLE_VERSIONS.add(new FlowableVersion("6.1.1.0"));
        JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};
    }
}

