/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.context;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.flowable.engine.impl.persistence.deploy.ProcessDefinitionInfoCacheObject;
import org.flowable.engine.impl.util.CommandContextUtil;

public class BpmnOverrideContext {
    protected static ThreadLocal<Map<String, ObjectNode>> bpmnOverrideContextThreadLocal = new ThreadLocal();
    protected static ResourceBundle.Control resourceBundleControl = new ResourceBundleControl();

    public static ObjectNode getBpmnOverrideElementProperties(String id, String processDefinitionId) {
        ObjectNode definitionInfoNode = BpmnOverrideContext.getProcessDefinitionInfoNode(processDefinitionId);
        ObjectNode elementProperties = null;
        if (definitionInfoNode != null) {
            elementProperties = CommandContextUtil.getProcessEngineConfiguration().getDynamicBpmnService().getBpmnElementProperties(id, definitionInfoNode);
        }
        return elementProperties;
    }

    public static ObjectNode getLocalizationElementProperties(String language, String id, String processDefinitionId, boolean useFallback) {
        ObjectNode definitionInfoNode = BpmnOverrideContext.getProcessDefinitionInfoNode(processDefinitionId);
        ObjectNode localizationProperties = null;
        if (definitionInfoNode != null) {
            if (!useFallback) {
                localizationProperties = CommandContextUtil.getProcessEngineConfiguration().getDynamicBpmnService().getLocalizationElementProperties(language, id, definitionInfoNode);
            } else {
                LinkedHashSet<Locale> candidateLocales = new LinkedHashSet<Locale>();
                candidateLocales.addAll(resourceBundleControl.getCandidateLocales(id, Locale.forLanguageTag(language)));
                for (Locale locale : candidateLocales) {
                    localizationProperties = CommandContextUtil.getProcessEngineConfiguration().getDynamicBpmnService().getLocalizationElementProperties(locale.toLanguageTag(), id, definitionInfoNode);
                    if (localizationProperties == null) continue;
                    break;
                }
            }
        }
        return localizationProperties;
    }

    public static void removeBpmnOverrideContext() {
        bpmnOverrideContextThreadLocal.remove();
    }

    protected static ObjectNode getProcessDefinitionInfoNode(String processDefinitionId) {
        Map<String, ObjectNode> bpmnOverrideMap = BpmnOverrideContext.getBpmnOverrideContext();
        if (!bpmnOverrideMap.containsKey(processDefinitionId)) {
            ProcessDefinitionInfoCacheObject cacheObject = CommandContextUtil.getProcessEngineConfiguration().getDeploymentManager().getProcessDefinitionInfoCache().get(processDefinitionId);
            BpmnOverrideContext.addBpmnOverrideElement(processDefinitionId, cacheObject.getInfoNode());
        }
        return BpmnOverrideContext.getBpmnOverrideContext().get(processDefinitionId);
    }

    protected static Map<String, ObjectNode> getBpmnOverrideContext() {
        Map<String, ObjectNode> bpmnOverrideMap = bpmnOverrideContextThreadLocal.get();
        if (bpmnOverrideMap == null) {
            bpmnOverrideMap = new HashMap<String, ObjectNode>();
        }
        return bpmnOverrideMap;
    }

    protected static void addBpmnOverrideElement(String id, ObjectNode infoNode) {
        Map<String, ObjectNode> bpmnOverrideMap = bpmnOverrideContextThreadLocal.get();
        if (bpmnOverrideMap == null) {
            bpmnOverrideMap = new HashMap<String, ObjectNode>();
            bpmnOverrideContextThreadLocal.set(bpmnOverrideMap);
        }
        bpmnOverrideMap.put(id, infoNode);
    }

    public static class ResourceBundleControl
    extends ResourceBundle.Control {
        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            return super.getCandidateLocales(baseName, locale);
        }
    }
}

