/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.VariableInstance;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class GetTasksLocalVariablesCmd
implements Command<List<VariableInstance>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected Set<String> taskIds;

    public GetTasksLocalVariablesCmd(Set<String> taskIds) {
        this.taskIds = taskIds;
    }

    public List<VariableInstance> execute(CommandContext commandContext) {
        if (this.taskIds == null) {
            throw new FlowableIllegalArgumentException("taskIds is null");
        }
        if (this.taskIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of taskIds is empty");
        }
        ArrayList<VariableInstance> instances = new ArrayList<VariableInstance>();
        List<VariableInstanceEntity> entities = CommandContextUtil.getVariableInstanceEntityManager(commandContext).findVariableInstancesByTaskIds(this.taskIds);
        for (VariableInstanceEntity entity : entities) {
            entity.getValue();
            instances.add(entity);
        }
        return instances;
    }
}

