/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.task.IdentityLink;

public class GetIdentityLinksForProcessDefinitionCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public GetIdentityLinksForProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public List<IdentityLink> execute(CommandContext commandContext) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)CommandContextUtil.getProcessDefinitionEntityManager(commandContext).findById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find process definition with id " + this.processDefinitionId, ProcessDefinition.class);
        }
        List<IdentityLink> identityLinks = processDefinition.getIdentityLinks();
        return identityLinks;
    }
}

