/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.flowable.bpmn.model.AdhocSubProcess;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class GetEnabledActivitiesForAdhocSubProcessCmd
implements Command<List<FlowNode>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;

    public GetEnabledActivitiesForAdhocSubProcessCmd(String executionId) {
        this.executionId = executionId;
    }

    public List<FlowNode> execute(CommandContext commandContext) {
        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.executionId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("No execution found for id '" + this.executionId + "'", ExecutionEntity.class);
        }
        if (!(execution.getCurrentFlowElement() instanceof AdhocSubProcess)) {
            throw new FlowableException("The current flow element of the requested execution is not an ad-hoc sub process");
        }
        ArrayList<FlowNode> enabledFlowNodes = new ArrayList<FlowNode>();
        AdhocSubProcess adhocSubProcess = (AdhocSubProcess)execution.getCurrentFlowElement();
        if (adhocSubProcess.hasSequentialOrdering() && execution.getExecutions().size() > 0) {
            return enabledFlowNodes;
        }
        for (FlowElement flowElement : adhocSubProcess.getFlowElements()) {
            FlowNode flowNode;
            if (!(flowElement instanceof FlowNode) || (flowNode = (FlowNode)flowElement).getIncomingFlows().size() != 0) continue;
            enabledFlowNodes.add(flowNode);
        }
        return enabledFlowNodes;
    }
}

