/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.ProcessDefinitionQueryImpl;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;

public class ChangeDeploymentTenantIdCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String newTenantId;

    public ChangeDeploymentTenantIdCmd(String deploymentId, String newTenantId) {
        this.deploymentId = deploymentId;
        this.newTenantId = newTenantId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("deploymentId is null");
        }
        DeploymentEntity deployment = (DeploymentEntity)CommandContextUtil.getDeploymentEntityManager(commandContext).findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find deployment with id " + this.deploymentId, Deployment.class);
        }
        if (Flowable5Util.isFlowable5Deployment((Deployment)deployment, commandContext)) {
            CommandContextUtil.getProcessEngineConfiguration(commandContext).getFlowable5CompatibilityHandler().changeDeploymentTenantId(this.deploymentId, this.newTenantId);
            return null;
        }
        String oldTenantId = deployment.getTenantId();
        deployment.setTenantId(this.newTenantId);
        CommandContextUtil.getProcessDefinitionEntityManager(commandContext).updateProcessDefinitionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        CommandContextUtil.getExecutionEntityManager(commandContext).updateExecutionTenantIdForDeployment(this.deploymentId, this.newTenantId);
        CommandContextUtil.getTaskEntityManager(commandContext).updateTaskTenantIdForDeployment(this.deploymentId, this.newTenantId);
        CommandContextUtil.getJobEntityManager(commandContext).updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        CommandContextUtil.getTimerJobEntityManager(commandContext).updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        CommandContextUtil.getSuspendedJobEntityManager(commandContext).updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        CommandContextUtil.getDeadLetterJobEntityManager(commandContext).updateJobTenantIdForDeployment(this.deploymentId, this.newTenantId);
        CommandContextUtil.getEventSubscriptionEntityManager(commandContext).updateEventSubscriptionTenantId(oldTenantId, this.newTenantId);
        List processDefinitions = new ProcessDefinitionQueryImpl().deploymentId(this.deploymentId).list();
        for (ProcessDefinition processDefinition : processDefinitions) {
            CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessDefinitionCache().remove(processDefinition.getId());
        }
        CommandContextUtil.getProcessEngineConfiguration(commandContext).getProcessDefinitionCache().clear();
        return null;
    }
}

