/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.calendar;

import java.util.Date;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.runtime.ClockReader;
import org.flowable.engine.impl.calendar.BusinessCalendarImpl;
import org.flowable.engine.impl.calendar.CronExpression;
import org.flowable.engine.impl.calendar.DurationHelper;

public class CycleBusinessCalendar
extends BusinessCalendarImpl {
    public static String NAME = "cycle";

    public CycleBusinessCalendar(ClockReader clockReader) {
        super(clockReader);
    }

    @Override
    public Date resolveDuedate(String duedateDescription, int maxIterations) {
        try {
            if (duedateDescription != null && duedateDescription.startsWith("R")) {
                return new DurationHelper(duedateDescription, maxIterations, this.clockReader).getDateAfter();
            }
            CronExpression ce = new CronExpression(duedateDescription, this.clockReader);
            return ce.getTimeAfter(this.clockReader.getCurrentTime());
        }
        catch (Exception e) {
            throw new FlowableException("Failed to parse cron expression: " + duedateDescription, (Throwable)e);
        }
    }

    @Override
    public Boolean validateDuedate(String duedateDescription, int maxIterations, Date endDate, Date newTimer) {
        if (endDate != null) {
            return super.validateDuedate(duedateDescription, maxIterations, endDate, newTimer);
        }
        try {
            if (duedateDescription != null && duedateDescription.startsWith("R")) {
                return new DurationHelper(duedateDescription, maxIterations, this.clockReader).isValidDate(newTimer);
            }
            return true;
        }
        catch (Exception e) {
            throw new FlowableException("Failed to parse cron expression: " + duedateDescription, (Throwable)e);
        }
    }
}

