/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.flowable.engine.impl.delegate.event.FlowableEngineEvent;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;

public class SignalThrowingEventListener
extends BaseDelegateEventListener {
    protected String signalName;
    protected boolean processInstanceScope = true;

    public void onEvent(FlowableEvent event) {
        if (this.isValidEvent(event) && event instanceof FlowableEngineEvent) {
            FlowableEngineEvent engineEvent = (FlowableEngineEvent)event;
            if (engineEvent.getProcessInstanceId() == null && this.processInstanceScope) {
                throw new FlowableIllegalArgumentException("Cannot throw process-instance scoped signal, since the dispatched event is not part of an ongoing process instance");
            }
            CommandContext commandContext = Context.getCommandContext();
            EventSubscriptionEntityManager eventSubscriptionEntityManager = CommandContextUtil.getEventSubscriptionEntityManager(commandContext);
            List<SignalEventSubscriptionEntity> subscriptionEntities = null;
            if (this.processInstanceScope) {
                subscriptionEntities = eventSubscriptionEntityManager.findSignalEventSubscriptionsByProcessInstanceAndEventName(engineEvent.getProcessInstanceId(), this.signalName);
            } else {
                String tenantId = null;
                if (engineEvent.getProcessDefinitionId() != null) {
                    ProcessDefinition processDefinition = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDeploymentManager().findDeployedProcessDefinitionById(engineEvent.getProcessDefinitionId());
                    tenantId = processDefinition.getTenantId();
                }
                subscriptionEntities = eventSubscriptionEntityManager.findSignalEventSubscriptionsByEventName(this.signalName, tenantId);
            }
            for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : subscriptionEntities) {
                eventSubscriptionEntityManager.eventReceived(signalEventSubscriptionEntity, null, false);
            }
        }
    }

    public void setSignalName(String signalName) {
        this.signalName = signalName;
    }

    public void setProcessInstanceScope(boolean processInstanceScope) {
        this.processInstanceScope = processInstanceScope;
    }

    public boolean isFailOnException() {
        return true;
    }
}

