/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.common.impl.interceptor.CommandExecutor;
import org.flowable.engine.impl.AbstractQuery;
import org.flowable.engine.impl.JobQueryProperty;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.DeadLetterJobQuery;
import org.flowable.engine.runtime.Job;

public class DeadLetterJobQueryImpl
extends AbstractQuery<DeadLetterJobQuery, Job>
implements DeadLetterJobQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String processInstanceId;
    protected String executionId;
    protected String handlerType;
    protected String processDefinitionId;
    protected boolean executable;
    protected boolean onlyTimers;
    protected boolean onlyMessages;
    protected Date duedateHigherThan;
    protected Date duedateLowerThan;
    protected Date duedateHigherThanOrEqual;
    protected Date duedateLowerThanOrEqual;
    protected boolean withException;
    protected String exceptionMessage;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;

    public DeadLetterJobQueryImpl() {
    }

    public DeadLetterJobQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public DeadLetterJobQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public DeadLetterJobQueryImpl jobId(String jobId) {
        if (jobId == null) {
            throw new FlowableIllegalArgumentException("Provided job id is null");
        }
        this.id = jobId;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("Provided process instance id is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl processDefinitionId(String processDefinitionId) {
        if (processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Provided process definition id is null");
        }
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Provided execution id is null");
        }
        this.executionId = executionId;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl handlerType(String handlerType) {
        if (handlerType == null) {
            throw new FlowableIllegalArgumentException("Provided handlerType is null");
        }
        this.handlerType = handlerType;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl executable() {
        this.executable = true;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl timers() {
        if (this.onlyMessages) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyTimers = true;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl messages() {
        if (this.onlyTimers) {
            throw new FlowableIllegalArgumentException("Cannot combine onlyTimers() with onlyMessages() in the same query");
        }
        this.onlyMessages = true;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl duedateHigherThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateHigherThan = date;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl duedateLowerThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateLowerThan = date;
        return this;
    }

    public DeadLetterJobQueryImpl duedateHigherThen(Date date) {
        return this.duedateHigherThan(date);
    }

    public DeadLetterJobQueryImpl duedateHigherThenOrEquals(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateHigherThanOrEqual = date;
        return this;
    }

    public DeadLetterJobQueryImpl duedateLowerThen(Date date) {
        return this.duedateLowerThan(date);
    }

    public DeadLetterJobQueryImpl duedateLowerThenOrEquals(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.duedateLowerThanOrEqual = date;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl withException() {
        this.withException = true;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl exceptionMessage(String exceptionMessage) {
        if (exceptionMessage == null) {
            throw new FlowableIllegalArgumentException("Provided exception message is null");
        }
        this.exceptionMessage = exceptionMessage;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl jobTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Provided tentant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl jobTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided tentant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public DeadLetterJobQueryImpl jobWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public DeadLetterJobQuery orderByJobDuedate() {
        return (DeadLetterJobQuery)this.orderBy(JobQueryProperty.DUEDATE);
    }

    @Override
    public DeadLetterJobQuery orderByExecutionId() {
        return (DeadLetterJobQuery)this.orderBy(JobQueryProperty.EXECUTION_ID);
    }

    @Override
    public DeadLetterJobQuery orderByJobId() {
        return (DeadLetterJobQuery)this.orderBy(JobQueryProperty.JOB_ID);
    }

    @Override
    public DeadLetterJobQuery orderByProcessInstanceId() {
        return (DeadLetterJobQuery)this.orderBy(JobQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public DeadLetterJobQuery orderByJobRetries() {
        return (DeadLetterJobQuery)this.orderBy(JobQueryProperty.RETRIES);
    }

    @Override
    public DeadLetterJobQuery orderByTenantId() {
        return (DeadLetterJobQuery)this.orderBy(JobQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getDeadLetterJobEntityManager(commandContext).findJobCountByQueryCriteria(this);
    }

    @Override
    public List<Job> executeList(CommandContext commandContext) {
        this.checkQueryOk();
        return CommandContextUtil.getDeadLetterJobEntityManager(commandContext).findJobsByQueryCriteria(this);
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public boolean getExecutable() {
        return this.executable;
    }

    public Date getNow() {
        return CommandContextUtil.getProcessEngineConfiguration().getClock().getCurrentTime();
    }

    public boolean isWithException() {
        return this.withException;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public static long getSerialversionuid() {
        return 1L;
    }

    public String getId() {
        return this.id;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public boolean isOnlyTimers() {
        return this.onlyTimers;
    }

    public boolean isOnlyMessages() {
        return this.onlyMessages;
    }

    public Date getDuedateHigherThan() {
        return this.duedateHigherThan;
    }

    public Date getDuedateLowerThan() {
        return this.duedateLowerThan;
    }

    public Date getDuedateHigherThanOrEqual() {
        return this.duedateHigherThanOrEqual;
    }

    public Date getDuedateLowerThanOrEqual() {
        return this.duedateLowerThanOrEqual;
    }
}

