/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;
import org.flowable.common.engine.impl.scripting.ScriptTrace;
import org.flowable.common.engine.impl.scripting.ScriptTraceEnhancer;

public class DefaultScriptTrace
implements ScriptTrace,
ScriptTraceEnhancer.ScriptTraceContext {
    protected Duration duration;
    protected ScriptEngineRequest request;
    protected Throwable exception;
    protected Map<String, String> traceTags = new LinkedHashMap<String, String>();

    public DefaultScriptTrace(Duration duration, ScriptEngineRequest request, Throwable caughtException) {
        this.duration = duration;
        this.request = request;
        this.exception = caughtException;
    }

    public static DefaultScriptTrace successTrace(Duration duration, ScriptEngineRequest request) {
        return new DefaultScriptTrace(duration, request, null);
    }

    public static DefaultScriptTrace errorTrace(Duration duration, ScriptEngineRequest request, Throwable caughtException) {
        return new DefaultScriptTrace(duration, request, caughtException);
    }

    @Override
    public ScriptTraceEnhancer.ScriptTraceContext addTraceTag(String tag, String value) {
        this.traceTags.put(tag, value);
        return this;
    }

    @Override
    public ScriptEngineRequest getRequest() {
        return this.request;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public Map<String, String> getTraceTags() {
        return this.traceTags;
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    public String toString() {
        return new StringJoiner(", ", DefaultScriptTrace.class.getSimpleName() + "[", "]").add("duration=" + this.duration).add("request=" + this.request).add("exception=" + this.exception).add("traceTags=" + this.traceTags).toString();
    }
}

