/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.interceptor;

import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.cfg.TransactionContextFactory;
import org.flowable.common.engine.impl.cfg.TransactionPropagation;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.TransactionCommandContextCloseListener;

public class TransactionContextInterceptor
extends AbstractCommandInterceptor {
    protected TransactionContextFactory transactionContextFactory;

    public TransactionContextInterceptor() {
    }

    public TransactionContextInterceptor(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext commandContext = Context.getCommandContext();
        boolean openTransaction = !config.getTransactionPropagation().equals((Object)TransactionPropagation.NOT_SUPPORTED) && this.transactionContextFactory != null && !commandContext.isReused();
        boolean isContextSet = false;
        try {
            if (openTransaction) {
                TransactionContext transactionContext = this.transactionContextFactory.openTransactionContext(commandContext);
                Context.setTransactionContext(transactionContext);
                isContextSet = true;
                commandContext.addCloseListener(new TransactionCommandContextCloseListener(transactionContext));
            }
            T t = this.next.execute(config, command);
            return t;
        }
        finally {
            if (openTransaction && isContextSet) {
                Context.removeTransactionContext();
            }
        }
    }

    public TransactionContextFactory getTransactionContextFactory() {
        return this.transactionContextFactory;
    }

    public void setTransactionContextFactory(TransactionContextFactory transactionContextFactory) {
        this.transactionContextFactory = transactionContextFactory;
    }
}

