/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.javax.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.List;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELResolver;
import org.flowable.engine.common.impl.javax.el.PropertyNotFoundException;
import org.flowable.engine.common.impl.javax.el.PropertyNotWritableException;

public class ListELResolver
extends ELResolver {
    private final boolean readOnly;

    public ListELResolver() {
        this(false);
    }

    public ListELResolver(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return ListELResolver.isResolvable(base) ? Integer.class : null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Class<Object> result = null;
        if (ListELResolver.isResolvable(base)) {
            ListELResolver.toIndex((List)base, property);
            result = Object.class;
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        Object result = null;
        if (ListELResolver.isResolvable(base)) {
            int index = ListELResolver.toIndex(null, property);
            List list = (List)base;
            result = index < 0 || index >= list.size() ? null : list.get(index);
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (ListELResolver.isResolvable(base)) {
            ListELResolver.toIndex((List)base, property);
            context.setPropertyResolved(true);
        }
        return this.readOnly;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (ListELResolver.isResolvable(base)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            List list = (List)base;
            int index = ListELResolver.toIndex(list, property);
            try {
                list.set(index, value);
            }
            catch (UnsupportedOperationException e) {
                throw new PropertyNotWritableException(e);
            }
            catch (ArrayStoreException e) {
                throw new IllegalArgumentException(e);
            }
            context.setPropertyResolved(true);
        }
    }

    private static final boolean isResolvable(Object base) {
        return base instanceof List;
    }

    private static final int toIndex(List<?> base, Object property) {
        int index = 0;
        if (property instanceof Number) {
            index = ((Number)property).intValue();
        } else if (property instanceof String) {
            try {
                index = Integer.valueOf((String)property);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Cannot parse list index: " + property);
            }
        } else if (property instanceof Character) {
            index = ((Character)property).charValue();
        } else if (property instanceof Boolean) {
            index = (Boolean)property != false ? 1 : 0;
        } else {
            throw new IllegalArgumentException("Cannot coerce property to list index: " + property);
        }
        if (base != null && (index < 0 || index >= base.size())) {
            throw new PropertyNotFoundException("List index out of bounds: " + index);
        }
        return index;
    }
}

