/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.common.impl.transaction;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.flowable.engine.common.impl.transaction.ConnectionHolder;
import org.flowable.engine.common.impl.transaction.TransactionContextHolder;

public class TransactionContextAwareDataSource
implements DataSource {
    protected DataSource dataSource;

    public TransactionContextAwareDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection;
        if (TransactionContextHolder.isTransactionContextActive() && (connection = ConnectionHolder.get()) != null) {
            return connection;
        }
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection;
        if (TransactionContextHolder.isTransactionContextActive() && (connection = ConnectionHolder.get()) != null) {
            return connection;
        }
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }
}

