/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.converter.util.DmnXMLUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnExtensionElement;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.RuleInputClauseContainer;
import org.flowable.dmn.model.UnaryTests;

public class InputEntryParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "inputEntry";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parseChildElement(XMLStreamReader xtr, DmnElement parentElement, Decision decision) throws Exception {
        if (!(parentElement instanceof DecisionRule)) {
            return;
        }
        DecisionRule rule = (DecisionRule)parentElement;
        UnaryTests inputEntry = new UnaryTests();
        inputEntry.setId(xtr.getAttributeValue(null, "id"));
        InputClause inputClause = null;
        DecisionTable decisionTable = (DecisionTable)decision.getExpression();
        if (decisionTable.getInputs() != null && decisionTable.getInputs().get(rule.getInputEntries().size()) != null) {
            inputClause = (InputClause)decisionTable.getInputs().get(rule.getInputEntries().size());
        }
        if (inputClause == null) {
            LOGGER.warn("Error determine output clause for position: {}", (Object)decisionTable.getInputs());
        }
        boolean readyWithInputEntry = false;
        try {
            block2: while (!readyWithInputEntry && xtr.hasNext()) {
                xtr.next();
                if (xtr.isStartElement() && "text".equalsIgnoreCase(xtr.getLocalName())) {
                    inputEntry.setText(xtr.getElementText());
                    continue;
                }
                if (!xtr.isStartElement() || !"extensionElements".equals(xtr.getLocalName())) {
                    if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                    readyWithInputEntry = true;
                    continue;
                }
                while (xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement()) {
                        DmnExtensionElement extensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                        this.migrateExtensionElement(extensionElement, inputClause);
                        inputEntry.addExtensionElement(extensionElement);
                        continue;
                    }
                    if (!xtr.isEndElement() || !"extensionElements".equals(xtr.getLocalName())) continue;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing input entry", (Throwable)e);
        }
        RuleInputClauseContainer ruleInputClauseContainer = new RuleInputClauseContainer();
        ruleInputClauseContainer.setInputClause(inputClause);
        ruleInputClauseContainer.setInputEntry(inputEntry);
        rule.addInputEntry(ruleInputClauseContainer);
    }

    protected void migrateExtensionElement(DmnExtensionElement extensionElement, InputClause inputClause) {
        if (extensionElement == null || extensionElement.getElementText() == null || extensionElement.getName() == null || inputClause == null || inputClause.getInputExpression() == null) {
            return;
        }
        if (!"operator".equals(extensionElement.getName())) {
            return;
        }
        String elementText = extensionElement.getElementText();
        String typeRef = inputClause.getInputExpression().getTypeRef();
        String newElementText = null;
        if ("collection".equalsIgnoreCase(typeRef)) {
            switch (elementText) {
                case "IN": {
                    newElementText = "ALL OF";
                    break;
                }
                case "NOT IN": {
                    newElementText = "NONE OF";
                    break;
                }
                case "ANY": {
                    newElementText = "ANY OF";
                    break;
                }
                case "NOT ANY": {
                    newElementText = "NOT ALL OF";
                }
            }
        } else {
            switch (elementText) {
                case "IN": {
                    newElementText = "IS IN";
                    break;
                }
                case "NOT IN": {
                    newElementText = "IS NOT IN";
                    break;
                }
                case "ANY": {
                    newElementText = "IS IN";
                    break;
                }
                case "NOT ANY": {
                    newElementText = "IS NOT IN";
                }
            }
        }
        if (newElementText != null) {
            extensionElement.setElementText(newElementText);
        }
    }
}

