/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.xml.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.converter.util.DmnXMLUtil;
import org.flowable.dmn.model.AuthorityRequirement;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.InformationItem;
import org.flowable.dmn.model.InformationRequirement;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.InputData;
import org.flowable.dmn.model.ItemDefinition;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.xml.constants.DmnXMLConstants;
import org.flowable.dmn.xml.converter.ConversionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDmnXMLConverter
implements DmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseDmnXMLConverter.class);
    private int elementCounter;

    public void convertToDmnModel(XMLStreamReader xtr, ConversionHelper conversionHelper) throws Exception {
        DmnElement parsedElement = this.convertXMLToElement(xtr, conversionHelper);
        Optional<DecisionTable> decisionTable = null;
        if (conversionHelper.getCurrentDecision() != null && conversionHelper.getCurrentDecision().getExpression() != null) {
            DecisionTable decisionTableExpression = (DecisionTable)conversionHelper.getCurrentDecision().getExpression();
            decisionTable = Optional.of(decisionTableExpression);
        }
        if (parsedElement instanceof InputClause) {
            decisionTable.ifPresent(dt -> {
                InputClause inputClause = (InputClause)parsedElement;
                inputClause.setInputNumber(this.elementCounter);
                dt.addInput(inputClause);
                ++this.elementCounter;
            });
        } else if (parsedElement instanceof OutputClause) {
            decisionTable.ifPresent(dt -> {
                OutputClause outputClause = (OutputClause)parsedElement;
                outputClause.setOutputNumber(this.elementCounter);
                dt.addOutput(outputClause);
                ++this.elementCounter;
            });
        } else if (parsedElement instanceof DecisionRule) {
            decisionTable.ifPresent(dt -> {
                DecisionRule decisionRule = (DecisionRule)parsedElement;
                decisionRule.setRuleNumber(this.elementCounter);
                dt.addRule(decisionRule);
                ++this.elementCounter;
            });
        } else if (parsedElement instanceof ItemDefinition) {
            conversionHelper.getDmnDefinition().addItemDefinition((ItemDefinition)parsedElement);
        } else if (parsedElement instanceof InputData) {
            InputData inputData = (InputData)parsedElement;
            if (inputData.getVariable() != null) {
                conversionHelper.getDmnDefinition().addInputData(inputData);
            }
        } else if (parsedElement instanceof InformationRequirement) {
            InformationRequirement informationRequirement = (InformationRequirement)parsedElement;
            if (informationRequirement.getRequiredDecision() != null) {
                conversionHelper.getCurrentDecision().addRequiredDecision(informationRequirement);
            } else if (informationRequirement.getRequiredInput() != null) {
                conversionHelper.getCurrentDecision().addRequiredInput(informationRequirement);
            }
        } else if (parsedElement instanceof AuthorityRequirement) {
            AuthorityRequirement authorityRequirement = (AuthorityRequirement)parsedElement;
            conversionHelper.getCurrentDecision().addAuthorityRequirement(authorityRequirement);
        } else if (parsedElement instanceof InformationItem) {
            if (conversionHelper.getCurrentDecision().getVariable() == null) {
                conversionHelper.getCurrentDecision().setVariable((InformationItem)parsedElement);
            }
        } else if (parsedElement instanceof DecisionService) {
            DecisionService decisionService = (DecisionService)parsedElement;
            decisionService.setDmnDefinition(conversionHelper.getDmnDefinition());
            conversionHelper.getDmnDefinition().addDecisionService(decisionService);
        }
    }

    public void convertToXML(XMLStreamWriter xtw, DmnElement baseElement, DmnDefinition model) throws Exception {
        xtw.writeStartElement(this.getXMLElementName());
        this.writeDefaultAttribute("id", baseElement.getId(), xtw);
        this.writeAdditionalAttributes(baseElement, model, xtw);
        this.writeAdditionalChildElements(baseElement, model, xtw);
        xtw.writeEndElement();
    }

    protected abstract DmnElement convertXMLToElement(XMLStreamReader var1, ConversionHelper var2) throws Exception;

    protected abstract String getXMLElementName();

    protected abstract void writeAdditionalAttributes(DmnElement var1, DmnDefinition var2, XMLStreamWriter var3) throws Exception;

    protected abstract void writeAdditionalChildElements(DmnElement var1, DmnDefinition var2, XMLStreamWriter var3) throws Exception;

    protected void parseChildElements(String elementName, DmnElement parentElement, Decision decision, XMLStreamReader xtr) throws Exception {
        this.parseChildElements(elementName, parentElement, null, decision, xtr);
    }

    protected void parseChildElements(String elementName, DmnElement parentElement, Map<String, BaseChildElementParser> additionalParsers, Decision decision, XMLStreamReader xtr) throws Exception {
        HashMap<String, BaseChildElementParser> childParsers = new HashMap<String, BaseChildElementParser>();
        if (additionalParsers != null) {
            childParsers.putAll(additionalParsers);
        }
        DmnXMLUtil.parseChildElements(elementName, parentElement, xtr, childParsers, decision);
    }

    protected void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        DmnXMLUtil.writeDefaultAttribute(attributeName, value, xtw);
    }

    protected void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        DmnXMLUtil.writeQualifiedAttribute(attributeName, value, xtw);
    }

    protected void initializeElementCounter() {
        this.elementCounter = 1;
    }
}

