/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.xml.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.converter.util.DmnXMLUtil;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.DecisionTable;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.InputClause;
import org.flowable.dmn.model.ItemDefinition;
import org.flowable.dmn.model.OutputClause;
import org.flowable.dmn.xml.constants.DmnXMLConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDmnXMLConverter
implements DmnXMLConstants {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseDmnXMLConverter.class);
    private int elementCounter;

    public void convertToDmnModel(XMLStreamReader xtr, DmnDefinition model, DecisionTable decisionTable) throws Exception {
        DmnElement parsedElement = this.convertXMLToElement(xtr, model, decisionTable);
        if (parsedElement instanceof InputClause) {
            InputClause inputClause = (InputClause)parsedElement;
            inputClause.setInputNumber(this.elementCounter);
            decisionTable.addInput(inputClause);
            ++this.elementCounter;
        } else if (parsedElement instanceof OutputClause) {
            OutputClause outputClause = (OutputClause)parsedElement;
            outputClause.setOutputNumber(this.elementCounter);
            decisionTable.addOutput(outputClause);
            ++this.elementCounter;
        } else if (parsedElement instanceof DecisionRule) {
            DecisionRule decisionRule = (DecisionRule)parsedElement;
            decisionRule.setRuleNumber(this.elementCounter);
            decisionTable.addRule(decisionRule);
            ++this.elementCounter;
        } else if (parsedElement instanceof ItemDefinition) {
            model.addItemDefinition((ItemDefinition)parsedElement);
        }
    }

    public void convertToXML(XMLStreamWriter xtw, DmnElement baseElement, DmnDefinition model) throws Exception {
        xtw.writeStartElement(this.getXMLElementName());
        this.writeDefaultAttribute("id", baseElement.getId(), xtw);
        this.writeAdditionalAttributes(baseElement, model, xtw);
        this.writeAdditionalChildElements(baseElement, model, xtw);
        xtw.writeEndElement();
    }

    protected abstract Class<? extends DmnElement> getDmnElementType();

    protected abstract DmnElement convertXMLToElement(XMLStreamReader var1, DmnDefinition var2, DecisionTable var3) throws Exception;

    protected abstract String getXMLElementName();

    protected abstract void writeAdditionalAttributes(DmnElement var1, DmnDefinition var2, XMLStreamWriter var3) throws Exception;

    protected abstract void writeAdditionalChildElements(DmnElement var1, DmnDefinition var2, XMLStreamWriter var3) throws Exception;

    protected void parseChildElements(String elementName, DmnElement parentElement, DecisionTable decisionTable, XMLStreamReader xtr) throws Exception {
        this.parseChildElements(elementName, parentElement, null, decisionTable, xtr);
    }

    protected void parseChildElements(String elementName, DmnElement parentElement, Map<String, BaseChildElementParser> additionalParsers, DecisionTable decisionTable, XMLStreamReader xtr) throws Exception {
        HashMap<String, BaseChildElementParser> childParsers = new HashMap<String, BaseChildElementParser>();
        if (additionalParsers != null) {
            childParsers.putAll(additionalParsers);
        }
        DmnXMLUtil.parseChildElements(elementName, parentElement, xtr, childParsers, decisionTable);
    }

    protected void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        DmnXMLUtil.writeDefaultAttribute(attributeName, value, xtw);
    }

    protected void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        DmnXMLUtil.writeQualifiedAttribute(attributeName, value, xtw);
    }

    protected void initializeElementCounter() {
        this.elementCounter = 1;
    }
}

