/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.spring;

import java.net.URL;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.dmn.engine.DmnEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringDmnConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringDmnConfigurationHelper.class);

    public static DmnEngine buildDmnEngine(URL resource) {
        LOGGER.debug("==== BUILDING SPRING APPLICATION CONTEXT AND DMN ENGINE =========================================");
        try (GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});){
            Map beansOfType = applicationContext.getBeansOfType(DmnEngine.class);
            if (beansOfType == null || beansOfType.isEmpty()) {
                throw new FlowableException("no " + DmnEngine.class.getName() + " defined in the application context " + resource.toString());
            }
            DmnEngine dmnEngine = (DmnEngine)beansOfType.values().iterator().next();
            LOGGER.debug("==== SPRING DMN ENGINE CREATED ==================================================================");
            DmnEngine dmnEngine2 = dmnEngine;
            return dmnEngine2;
        }
    }
}

