/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.ExecuteDecisionContext;
import org.flowable.dmn.engine.impl.ExecuteDecisionBuilderImpl;
import org.flowable.dmn.engine.impl.cmd.AbstractExecuteDecisionCmd;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.DmnElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateDecisionCmd
extends AbstractExecuteDecisionCmd
implements Command<Void> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateDecisionCmd.class);

    public EvaluateDecisionCmd(ExecuteDecisionBuilderImpl decisionBuilder) {
        super(decisionBuilder);
    }

    public EvaluateDecisionCmd(String decisionKey, Map<String, Object> variables) {
        super(decisionKey, variables);
    }

    public EvaluateDecisionCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables) {
        this(decisionKey, variables);
        this.executeDecisionContext.setParentDeploymentId(parentDeploymentId);
    }

    public EvaluateDecisionCmd(String decisionKey, String parentDeploymentId, Map<String, Object> variables, String tenantId) {
        this(decisionKey, parentDeploymentId, variables);
        this.executeDecisionContext.setTenantId(tenantId);
    }

    public EvaluateDecisionCmd(ExecuteDecisionContext executeDecisionContext) {
        super(executeDecisionContext);
    }

    public Void execute(CommandContext commandContext) {
        if (this.executeDecisionContext.getDecisionKey() == null) {
            throw new FlowableIllegalArgumentException("decisionKey is null");
        }
        DmnDefinition definition = this.resolveDefinition();
        this.execute(commandContext, definition);
        return null;
    }

    @Override
    protected void execute(CommandContext commandContext, DmnDefinition definition) {
        DecisionService decisionService = definition.getDecisionServiceById(this.executeDecisionContext.getDecisionKey());
        if (decisionService != null) {
            this.executeDecisionContext.setDmnElement((DmnElement)decisionService);
            CommandContextUtil.getAgenda(commandContext).planExecuteDecisionServiceOperation(this.executeDecisionContext, decisionService);
        } else {
            Decision decision = definition.getDecisionById(this.executeDecisionContext.getDecisionKey());
            this.executeDecisionContext.setDmnElement((DmnElement)decision);
            CommandContextUtil.getAgenda(commandContext).planExecuteDecisionOperation(this.executeDecisionContext, decision);
        }
    }
}

