/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.cmd;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.BooleanUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.ExecuteDecisionContext;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.persistence.entity.HistoricDecisionExecutionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.HistoricDecisionExecutionEntityManager;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;

public class PersistHistoricDecisionExecutionCmd
implements Command<Void> {
    protected ExecuteDecisionContext executeDecisionContext;

    public PersistHistoricDecisionExecutionCmd(ExecuteDecisionContext executeDecisionContext) {
        this.executeDecisionContext = executeDecisionContext;
    }

    public Void execute(CommandContext commandContext) {
        if (this.executeDecisionContext == null) {
            throw new FlowableIllegalArgumentException("ExecuteDecisionContext is null");
        }
        DmnEngineConfiguration engineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
        if (engineConfiguration.isHistoryEnabled()) {
            ObjectMapper objectMapper;
            HistoricDecisionExecutionEntityManager historicDecisionExecutionEntityManager = engineConfiguration.getHistoricDecisionExecutionEntityManager();
            HistoricDecisionExecutionEntity decisionExecutionEntity = (HistoricDecisionExecutionEntity)historicDecisionExecutionEntityManager.create();
            decisionExecutionEntity.setDecisionDefinitionId(this.executeDecisionContext.getDecisionId());
            decisionExecutionEntity.setDeploymentId(this.executeDecisionContext.getDeploymentId());
            decisionExecutionEntity.setStartTime(this.executeDecisionContext.getDecisionExecution().getStartTime());
            decisionExecutionEntity.setEndTime(this.executeDecisionContext.getDecisionExecution().getEndTime());
            decisionExecutionEntity.setInstanceId(this.executeDecisionContext.getInstanceId());
            decisionExecutionEntity.setExecutionId(this.executeDecisionContext.getExecutionId());
            decisionExecutionEntity.setActivityId(this.executeDecisionContext.getActivityId());
            decisionExecutionEntity.setScopeType(this.executeDecisionContext.getScopeType());
            decisionExecutionEntity.setTenantId(this.executeDecisionContext.getTenantId());
            Boolean failed = this.executeDecisionContext.getDecisionExecution().isFailed();
            if (BooleanUtils.isTrue((Boolean)failed)) {
                decisionExecutionEntity.setFailed(failed);
            }
            if ((objectMapper = engineConfiguration.getObjectMapper()) == null) {
                objectMapper = new ObjectMapper();
            }
            try {
                decisionExecutionEntity.setExecutionJson(objectMapper.writeValueAsString((Object)this.executeDecisionContext.getDecisionExecution()));
            }
            catch (Exception e) {
                throw new FlowableException("Error writing execution json", (Throwable)e);
            }
            historicDecisionExecutionEntityManager.insert(decisionExecutionEntity);
        }
        return null;
    }
}

