/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class DateRestVariableConverter
implements RestVariableConverter {
    protected ISO8601DateFormat isoFormatter = new ISO8601DateFormat();

    @Override
    public String getRestTypeName() {
        return "date";
    }

    @Override
    public Class<?> getVariableType() {
        return Date.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof String)) {
                throw new FlowableIllegalArgumentException("Converter can only convert string to date");
            }
            try {
                return this.isoFormatter.parse((String)result.getValue());
            }
            catch (ParseException e) {
                throw new FlowableIllegalArgumentException("The given variable value is not a date: '" + result.getValue() + "'", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Date)) {
                throw new FlowableIllegalArgumentException("Converter can only convert booleans");
            }
            result.setValue(this.isoFormatter.format(variableValue));
        } else {
            result.setValue(null);
        }
    }
}

