/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.spring;

import java.net.URL;
import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngine;
import org.flowable.common.engine.api.FlowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class SpringCmmnConfigurationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringCmmnConfigurationHelper.class);

    public static CmmnEngine buildCmmnEngine(URL resource) {
        LOGGER.debug("==== BUILDING SPRING APPLICATION CONTEXT AND CMMN ENGINE =========================================");
        try (GenericXmlApplicationContext applicationContext = new GenericXmlApplicationContext(new Resource[]{new UrlResource(resource)});){
            Map beansOfType = applicationContext.getBeansOfType(CmmnEngine.class);
            if (beansOfType == null || beansOfType.isEmpty()) {
                throw new FlowableException("no " + CmmnEngine.class.getName() + " defined in the application context " + resource);
            }
            CmmnEngine cmmnEngine = (CmmnEngine)beansOfType.values().iterator().next();
            LOGGER.debug("==== SPRING CMMN ENGINE CREATED ==================================================================");
            CmmnEngine cmmnEngine2 = cmmnEngine;
            return cmmnEngine2;
        }
    }
}

