/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.AbstractEventListenerJsonConverter;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.VariableEventListener;

public class VariableEventListenerJsonConverter
extends AbstractEventListenerJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        VariableEventListenerJsonConverter.fillJsonTypes(convertersToCmmnMap);
        VariableEventListenerJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap) {
        convertersToCmmnMap.put("VariableEventListener", VariableEventListenerJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(VariableEventListener.class, VariableEventListenerJsonConverter.class);
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
        PlanItem planItem = (PlanItem)baseElement;
        VariableEventListener variableEventListener = (VariableEventListener)planItem.getPlanItemDefinition();
        this.convertCommonElementToJson(elementNode, propertiesNode, baseElement);
        if (StringUtils.isNotEmpty((CharSequence)variableEventListener.getVariableName())) {
            propertiesNode.put("variablelistenervariablename", variableEventListener.getVariableName());
        }
        if (StringUtils.isNotEmpty((CharSequence)variableEventListener.getVariableChangeType())) {
            propertiesNode.put("variablelistenervariablechangetype", variableEventListener.getVariableChangeType());
        }
    }

    @Override
    protected BaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        VariableEventListener variableEventListener = new VariableEventListener();
        this.convertCommonJsonToElement(elementNode, (EventListener)variableEventListener);
        String variableName = this.getPropertyValueAsString("variablelistenervariablename", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)variableName)) {
            variableEventListener.setVariableName(variableName);
            String variableChangeType = this.getPropertyValueAsString("variablelistenervariablechangetype", elementNode);
            if (StringUtils.isNotEmpty((CharSequence)variableChangeType)) {
                variableEventListener.setVariableChangeType(variableChangeType);
            }
        }
        return variableEventListener;
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "VariableEventListener";
    }
}

