/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;

public class JobUtil {
    public static JobEntity createJob(CaseInstanceEntity caseInstance, BaseElement baseElement, String jobHandlerType, CmmnEngineConfiguration cmmnEngineConfiguration) {
        JobEntity job = JobUtil.createJob((VariableContainer)caseInstance, baseElement, jobHandlerType, cmmnEngineConfiguration);
        job.setScopeId(caseInstance.getId());
        job.setScopeDefinitionId(caseInstance.getCaseDefinitionId());
        return job;
    }

    public static JobEntity createJob(PlanItemInstanceEntity planItemInstance, BaseElement baseElement, String jobHandlerType, CmmnEngineConfiguration cmmnEngineConfiguration) {
        JobEntity job = JobUtil.createJob((VariableContainer)planItemInstance, baseElement, jobHandlerType, cmmnEngineConfiguration);
        job.setScopeId(planItemInstance.getCaseInstanceId());
        job.setSubScopeId(planItemInstance.getId());
        job.setScopeDefinitionId(planItemInstance.getCaseDefinitionId());
        return job;
    }

    protected static JobEntity createJob(VariableContainer variableContainer, BaseElement baseElement, String jobHandlerType, CmmnEngineConfiguration cmmnEngineConfiguration) {
        Expression categoryExpression;
        Object categoryValue;
        ExtensionElement jobCategoryElement;
        List jobCategoryElements;
        JobService jobService = cmmnEngineConfiguration.getJobServiceConfiguration().getJobService();
        JobEntity job = jobService.createJob();
        job.setJobHandlerType(jobHandlerType);
        job.setScopeType("cmmn");
        job.setElementId(baseElement.getId());
        if (baseElement instanceof CaseElement) {
            job.setElementName(((CaseElement)baseElement).getName());
        }
        if ((jobCategoryElements = (List)baseElement.getExtensionElements().get("jobCategory")) != null && jobCategoryElements.size() > 0 && StringUtils.isNotEmpty((CharSequence)(jobCategoryElement = (ExtensionElement)jobCategoryElements.get(0)).getElementText()) && (categoryValue = (categoryExpression = cmmnEngineConfiguration.getExpressionManager().createExpression(jobCategoryElement.getElementText())).getValue(variableContainer)) != null) {
            job.setCategory(categoryValue.toString());
        }
        job.setTenantId(variableContainer.getTenantId());
        return job;
    }
}

