/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.runtime.PlanItemInstanceQueryProperty;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.CacheAwareQuery;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;

public class PlanItemInstanceQueryImpl
extends AbstractVariableQueryImpl<PlanItemInstanceQuery, PlanItemInstance>
implements PlanItemInstanceQuery,
CacheAwareQuery<PlanItemInstanceEntity> {
    protected CmmnEngineConfiguration cmmnEngineConfiguration;
    protected String caseDefinitionId;
    protected String derivedCaseDefinitionId;
    protected String caseInstanceId;
    protected String stageInstanceId;
    protected String planItemInstanceId;
    protected String elementId;
    protected String planItemDefinitionId;
    protected String planItemDefinitionType;
    protected List<String> planItemDefinitionTypes;
    protected String name;
    protected String state;
    protected Date createdBefore;
    protected Date createdAfter;
    protected Date lastAvailableBefore;
    protected Date lastAvailableAfter;
    protected Date lastUnavailableBefore;
    protected Date lastUnavailableAfter;
    protected Date lastEnabledBefore;
    protected Date lastEnabledAfter;
    protected Date lastDisabledBefore;
    protected Date lastDisabledAfter;
    protected Date lastStartedBefore;
    protected Date lastStartedAfter;
    protected Date lastSuspendedBefore;
    protected Date lastSuspendedAfter;
    protected Date completedBefore;
    protected Date completedAfter;
    protected Date terminatedBefore;
    protected Date terminatedAfter;
    protected Date occurredBefore;
    protected Date occurredAfter;
    protected Date exitBefore;
    protected Date exitAfter;
    protected Date endedBefore;
    protected Date endedAfter;
    protected boolean ended;
    protected boolean includeEnded;
    protected String startUserId;
    protected String referenceId;
    protected String referenceType;
    protected boolean completable;
    protected boolean onlyStages;
    protected String entryCriterionId;
    protected String exitCriterionId;
    protected String formKey;
    protected String extraValue;
    protected String involvedUser;
    protected Collection<String> involvedGroups;
    private List<List<String>> safeInvolvedGroups;
    protected String tenantId;
    protected boolean withoutTenantId;
    protected String locale;
    protected boolean withLocalizationFallback;
    protected boolean includeLocalVariables;
    protected List<PlanItemInstanceQueryImpl> orQueryObjects = new ArrayList<PlanItemInstanceQueryImpl>();
    protected PlanItemInstanceQueryImpl currentOrQueryObject;
    protected boolean inOrStatement;

    public PlanItemInstanceQueryImpl() {
    }

    public PlanItemInstanceQueryImpl(CommandContext commandContext, CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(commandContext, cmmnEngineConfiguration.getVariableServiceConfiguration());
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public PlanItemInstanceQueryImpl(CommandExecutor commandExecutor, CmmnEngineConfiguration cmmnEngineConfiguration) {
        super(commandExecutor, cmmnEngineConfiguration.getVariableServiceConfiguration());
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public PlanItemInstanceQuery caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Case definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionId = caseDefinitionId;
        } else {
            this.caseDefinitionId = caseDefinitionId;
        }
        return this;
    }

    public PlanItemInstanceQuery derivedCaseDefinitionId(String derivedCaseDefinitionId) {
        if (derivedCaseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Derived case definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.derivedCaseDefinitionId = derivedCaseDefinitionId;
        } else {
            this.derivedCaseDefinitionId = derivedCaseDefinitionId;
        }
        return this;
    }

    public PlanItemInstanceQuery caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Case instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceId = caseInstanceId;
        } else {
            this.caseInstanceId = caseInstanceId;
        }
        return this;
    }

    public PlanItemInstanceQuery stageInstanceId(String stageInstanceId) {
        if (stageInstanceId == null) {
            throw new FlowableIllegalArgumentException("Stage instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.stageInstanceId = stageInstanceId;
        } else {
            this.stageInstanceId = stageInstanceId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceId(String planItemInstanceId) {
        if (planItemInstanceId == null) {
            throw new FlowableIllegalArgumentException("Plan Item instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.planItemInstanceId = planItemInstanceId;
        } else {
            this.planItemInstanceId = planItemInstanceId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceElementId(String elementId) {
        if (elementId == null) {
            throw new FlowableIllegalArgumentException("Element id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.elementId = elementId;
        } else {
            this.elementId = elementId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemDefinitionId(String planItemDefinitionId) {
        if (planItemDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Plan item definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.planItemDefinitionId = planItemDefinitionId;
        } else {
            this.planItemDefinitionId = planItemDefinitionId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemDefinitionType(String planItemDefinitionType) {
        if (planItemDefinitionType == null) {
            throw new FlowableIllegalArgumentException("Plan item definition type is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.planItemDefinitionType = planItemDefinitionType;
        } else {
            this.planItemDefinitionType = planItemDefinitionType;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemDefinitionTypes(List<String> planItemDefinitionTypes) {
        if (planItemDefinitionTypes == null) {
            throw new FlowableIllegalArgumentException("Plan item definition types is null");
        }
        if (planItemDefinitionTypes.isEmpty()) {
            throw new FlowableIllegalArgumentException("Plan item definition types is empty");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.planItemDefinitionTypes = planItemDefinitionTypes;
        } else {
            this.planItemDefinitionTypes = planItemDefinitionTypes;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceName(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.name = name;
        } else {
            this.name = name;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceState(String state) {
        if (state == null) {
            throw new FlowableIllegalArgumentException("State is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.state = state;
        } else {
            this.state = state;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceStateWaitingForRepetition() {
        return this.planItemInstanceState("wait_repetition");
    }

    public PlanItemInstanceQuery planItemInstanceStateActive() {
        return this.planItemInstanceState("active");
    }

    public PlanItemInstanceQuery planItemInstanceStateEnabled() {
        return this.planItemInstanceState("enabled");
    }

    public PlanItemInstanceQuery planItemInstanceStateDisabled() {
        return this.planItemInstanceState("disabled");
    }

    public PlanItemInstanceQuery planItemInstanceStateAsyncActive() {
        return this.planItemInstanceState("async-active");
    }

    public PlanItemInstanceQuery planItemInstanceStateAsyncActiveLeave() {
        return this.planItemInstanceState("async-active-leave");
    }

    public PlanItemInstanceQuery planItemInstanceStateAvailable() {
        return this.planItemInstanceState("available");
    }

    public PlanItemInstanceQuery planItemInstanceStateUnavailable() {
        return this.planItemInstanceState("unavailable");
    }

    public PlanItemInstanceQuery planItemInstanceStateCompleted() {
        return this.planItemInstanceState("completed");
    }

    public PlanItemInstanceQuery planItemInstanceStateTerminated() {
        return this.planItemInstanceState("terminated");
    }

    public PlanItemInstanceQuery planItemInstanceCreatedBefore(Date createdBefore) {
        if (createdBefore == null) {
            throw new FlowableIllegalArgumentException("createdBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.createdBefore = createdBefore;
        } else {
            this.createdBefore = createdBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceCreatedAfter(Date createdAfter) {
        if (createdAfter == null) {
            throw new FlowableIllegalArgumentException("createdAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.createdAfter = createdAfter;
        } else {
            this.createdAfter = createdAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastAvailableBefore(Date availableBefore) {
        if (availableBefore == null) {
            throw new FlowableIllegalArgumentException("availableBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastAvailableBefore = availableBefore;
        } else {
            this.lastAvailableBefore = availableBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastAvailableAfter(Date availableAfter) {
        if (availableAfter == null) {
            throw new FlowableIllegalArgumentException("availableAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastAvailableAfter = availableAfter;
        } else {
            this.lastAvailableAfter = availableAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastUnavailableBefore(Date unavailableBefore) {
        if (unavailableBefore == null) {
            throw new FlowableIllegalArgumentException("unavailableBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastUnavailableBefore = unavailableBefore;
        } else {
            this.lastUnavailableBefore = unavailableBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastUnavailableAfter(Date unavailableAfter) {
        if (unavailableAfter == null) {
            throw new FlowableIllegalArgumentException("unavailableAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastUnavailableAfter = unavailableAfter;
        } else {
            this.lastUnavailableAfter = unavailableAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastEnabledBefore(Date enabledBefore) {
        if (enabledBefore == null) {
            throw new FlowableIllegalArgumentException("enabledBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastEnabledBefore = enabledBefore;
        } else {
            this.lastEnabledBefore = enabledBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastEnabledAfter(Date enabledAfter) {
        if (enabledAfter == null) {
            throw new FlowableIllegalArgumentException("enabledAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastEnabledAfter = enabledAfter;
        } else {
            this.lastEnabledAfter = enabledAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastDisabledBefore(Date disabledBefore) {
        if (disabledBefore == null) {
            throw new FlowableIllegalArgumentException("disabledBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastDisabledBefore = disabledBefore;
        } else {
            this.lastDisabledBefore = disabledBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastDisabledAfter(Date disabledAfter) {
        if (disabledAfter == null) {
            throw new FlowableIllegalArgumentException("disabledAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastDisabledAfter = disabledAfter;
        } else {
            this.lastDisabledAfter = disabledAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastStartedBefore(Date startedBefore) {
        if (startedBefore == null) {
            throw new FlowableIllegalArgumentException("activatedBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastStartedBefore = startedBefore;
        } else {
            this.lastStartedBefore = startedBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastStartedAfter(Date startedAfter) {
        if (startedAfter == null) {
            throw new FlowableIllegalArgumentException("startedAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastStartedAfter = startedAfter;
        } else {
            this.lastStartedAfter = startedAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastSuspendedBefore(Date suspendedBefore) {
        if (suspendedBefore == null) {
            throw new FlowableIllegalArgumentException("suspendedBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastSuspendedBefore = suspendedBefore;
        } else {
            this.lastSuspendedBefore = suspendedBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceLastSuspendedAfter(Date suspendedAfter) {
        if (suspendedAfter == null) {
            throw new FlowableIllegalArgumentException("suspendedAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.lastSuspendedAfter = suspendedAfter;
        } else {
            this.lastSuspendedAfter = suspendedAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceCompletedBefore(Date completedBefore) {
        if (completedBefore == null) {
            throw new FlowableIllegalArgumentException("completedBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.completedBefore = completedBefore;
        } else {
            this.completedBefore = completedBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceCompletedAfter(Date completedAfter) {
        if (completedAfter == null) {
            throw new FlowableIllegalArgumentException("completedAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.completedAfter = completedAfter;
        } else {
            this.completedAfter = completedAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceOccurredBefore(Date occurredBefore) {
        if (occurredBefore == null) {
            throw new FlowableIllegalArgumentException("occurredBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.occurredBefore = occurredBefore;
        } else {
            this.occurredBefore = occurredBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceOccurredAfter(Date occurredAfter) {
        if (occurredAfter == null) {
            throw new FlowableIllegalArgumentException("occurredAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.occurredAfter = occurredAfter;
        } else {
            this.occurredAfter = occurredAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceTerminatedBefore(Date terminatedBefore) {
        if (terminatedBefore == null) {
            throw new FlowableIllegalArgumentException("terminatedBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.terminatedBefore = terminatedBefore;
        } else {
            this.terminatedBefore = terminatedBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceTerminatedAfter(Date terminatedAfter) {
        if (terminatedAfter == null) {
            throw new FlowableIllegalArgumentException("terminatedAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.terminatedAfter = terminatedAfter;
        } else {
            this.terminatedAfter = terminatedAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceExitBefore(Date exitBefore) {
        if (exitBefore == null) {
            throw new FlowableIllegalArgumentException("exitBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.exitBefore = exitBefore;
        } else {
            this.exitBefore = exitBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceExitAfter(Date exitAfter) {
        if (exitAfter == null) {
            throw new FlowableIllegalArgumentException("exitAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.exitAfter = exitAfter;
        } else {
            this.exitAfter = exitAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceEndedBefore(Date endedBefore) {
        if (endedBefore == null) {
            throw new FlowableIllegalArgumentException("endedBefore is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.endedBefore = endedBefore;
        } else {
            this.endedBefore = endedBefore;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceEndedAfter(Date endedAfter) {
        if (endedAfter == null) {
            throw new FlowableIllegalArgumentException("endedAfter is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.endedAfter = endedAfter;
        } else {
            this.endedAfter = endedAfter;
        }
        return this;
    }

    public PlanItemInstanceQuery ended() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.ended = true;
            this.includeEnded = true;
        } else {
            this.ended = true;
        }
        return this;
    }

    public PlanItemInstanceQuery includeEnded() {
        if (this.inOrStatement) {
            throw new FlowableIllegalArgumentException("includeEnded is not allowed within an or query");
        }
        this.includeEnded = true;
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceStartUserId(String startUserId) {
        if (startUserId == null) {
            throw new FlowableIllegalArgumentException("Start user id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startUserId = startUserId;
        } else {
            this.startUserId = startUserId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceReferenceId(String referenceId) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceId = referenceId;
        } else {
            this.referenceId = referenceId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceReferenceType(String referenceType) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceType = referenceType;
        } else {
            this.referenceType = referenceType;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceCompletable() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.completable = true;
        } else {
            this.completable = true;
        }
        return this;
    }

    public PlanItemInstanceQuery onlyStages() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.onlyStages = true;
        } else {
            this.onlyStages = true;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceEntryCriterionId(String entryCriterionId) {
        if (entryCriterionId == null) {
            throw new FlowableIllegalArgumentException("EntryCriterionId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.entryCriterionId = entryCriterionId;
        } else {
            this.entryCriterionId = entryCriterionId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceExitCriterionId(String exitCriterionId) {
        if (exitCriterionId == null) {
            throw new FlowableIllegalArgumentException("ExitCriterionId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.exitCriterionId = exitCriterionId;
        } else {
            this.exitCriterionId = exitCriterionId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceFormKey(String formKey) {
        if (formKey == null) {
            throw new FlowableIllegalArgumentException("formKey is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.formKey = formKey;
        } else {
            this.formKey = formKey;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceExtraValue(String extraValue) {
        if (extraValue == null) {
            throw new FlowableIllegalArgumentException("extraValue is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.extraValue = extraValue;
        } else {
            this.extraValue = extraValue;
        }
        return this;
    }

    public PlanItemInstanceQuery involvedUser(String involvedUser) {
        if (involvedUser == null) {
            throw new FlowableIllegalArgumentException("involvedUser is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedUser = involvedUser;
        } else {
            this.involvedUser = involvedUser;
        }
        return this;
    }

    public PlanItemInstanceQuery involvedGroups(Collection<String> involvedGroups) {
        if (involvedGroups == null) {
            throw new FlowableIllegalArgumentException("involvedGroups is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedGroups = involvedGroups;
        } else {
            this.involvedGroups = involvedGroups;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    public PlanItemInstanceQuery planItemInstanceWithoutTenantId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueEquals(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(name, value);
        } else {
            super.variableValueEquals(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueEquals(Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(value);
        } else {
            super.variableValueEquals(value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value);
        } else {
            super.variableValueEqualsIgnoreCase(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value);
        } else {
            super.variableValueNotEqualsIgnoreCase(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueNotEquals(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(name, value);
        } else {
            super.variableValueNotEquals(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value);
        } else {
            super.variableValueLikeIgnoreCase(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value);
        } else {
            super.variableValueLike(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value);
        } else {
            super.variableValueLessThanOrEqual(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value);
        } else {
            super.variableValueLessThan(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value);
        } else {
            super.variableValueGreaterThanOrEqual(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value);
        } else {
            super.variableValueGreaterThan(name, value);
        }
        return this;
    }

    public PlanItemInstanceQuery variableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name);
        } else {
            super.variableExists(name);
        }
        return this;
    }

    public PlanItemInstanceQuery variableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name);
        } else {
            super.variableNotExists(name);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueEquals(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(name, value, false);
        } else {
            this.variableValueEquals(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueEquals(Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(value, false);
        } else {
            this.variableValueEquals(value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, false);
        } else {
            this.variableValueEqualsIgnoreCase(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueNotEquals(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(name, value, false);
        } else {
            this.variableValueNotEquals(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
        } else {
            this.variableValueNotEqualsIgnoreCase(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, false);
        } else {
            this.variableValueGreaterThan(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, false);
        } else {
            this.variableValueGreaterThanOrEqual(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value, false);
        } else {
            this.variableValueLessThan(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, false);
        } else {
            this.variableValueLessThanOrEqual(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value, false);
        } else {
            this.variableValueLike(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, false);
        } else {
            this.variableValueLikeIgnoreCase(name, value, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, false);
        } else {
            this.variableExists(name, false);
        }
        return this;
    }

    public PlanItemInstanceQuery caseVariableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, false);
        } else {
            this.variableNotExists(name, false);
        }
        return this;
    }

    public PlanItemInstanceQuery or() {
        if (this.inOrStatement) {
            throw new FlowableIllegalArgumentException("The query is already in an or statement");
        }
        this.inOrStatement = true;
        this.currentOrQueryObject = this.commandContext != null ? new PlanItemInstanceQueryImpl(this.commandContext, this.cmmnEngineConfiguration) : new PlanItemInstanceQueryImpl(this.commandExecutor, this.cmmnEngineConfiguration);
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    public PlanItemInstanceQuery endOr() {
        if (!this.inOrStatement) {
            throw new FlowableIllegalArgumentException("endOr() can only be called after calling or()");
        }
        this.inOrStatement = false;
        this.currentOrQueryObject = null;
        return this;
    }

    public PlanItemInstanceQuery includeLocalVariables() {
        this.includeLocalVariables = true;
        return this;
    }

    public PlanItemInstanceQuery locale(String locale) {
        this.locale = locale;
        return this;
    }

    public PlanItemInstanceQuery withLocalizationFallback() {
        this.withLocalizationFallback = true;
        return this;
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().countByCriteria(this);
    }

    public List<PlanItemInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        List<PlanItemInstance> planItems = null;
        planItems = this.includeLocalVariables ? this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findWithVariablesByCriteria(this) : this.cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findByCriteria(this);
        if (this.cmmnEngineConfiguration.getPlanItemLocalizationManager() != null) {
            for (PlanItemInstance planItemInstance : planItems) {
                this.cmmnEngineConfiguration.getPlanItemLocalizationManager().localize(planItemInstance, this.locale, this.withLocalizationFallback);
            }
        }
        return planItems;
    }

    public PlanItemInstanceQuery orderByCreateTime() {
        this.orderProperty = PlanItemInstanceQueryProperty.CREATE_TIME;
        return this;
    }

    public PlanItemInstanceQuery orderByEndTime() {
        this.orderProperty = PlanItemInstanceQueryProperty.END_TIME;
        return this;
    }

    public PlanItemInstanceQuery orderByName() {
        this.orderProperty = PlanItemInstanceQueryProperty.NAME;
        return this;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getDerivedCaseDefinitionId() {
        return this.derivedCaseDefinitionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getStageInstanceId() {
        return this.stageInstanceId;
    }

    public String getPlanItemInstanceId() {
        return this.planItemInstanceId;
    }

    public String getId() {
        return this.planItemInstanceId;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getPlanItemDefinitionId() {
        return this.planItemDefinitionId;
    }

    public String getPlanItemDefinitionType() {
        return this.planItemDefinitionType;
    }

    public List<String> getPlanItemDefinitionTypes() {
        return this.planItemDefinitionTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public Date getLastAvailableBefore() {
        return this.lastAvailableBefore;
    }

    public Date getLastAvailableAfter() {
        return this.lastAvailableAfter;
    }

    public Date getLastUnavailableBefore() {
        return this.lastUnavailableBefore;
    }

    public Date getLastUnavailableAfter() {
        return this.lastUnavailableAfter;
    }

    public Date getLastEnabledBefore() {
        return this.lastEnabledBefore;
    }

    public Date getLastEnabledAfter() {
        return this.lastEnabledAfter;
    }

    public Date getLastDisabledBefore() {
        return this.lastDisabledBefore;
    }

    public Date getLastDisabledAfter() {
        return this.lastDisabledAfter;
    }

    public Date getLastStartedBefore() {
        return this.lastStartedBefore;
    }

    public Date getLastStartedAfter() {
        return this.lastStartedAfter;
    }

    public Date getLastSuspendedBefore() {
        return this.lastSuspendedBefore;
    }

    public Date getLastSuspendedAfter() {
        return this.lastSuspendedAfter;
    }

    public Date getCompletedBefore() {
        return this.completedBefore;
    }

    public Date getCompletedAfter() {
        return this.completedAfter;
    }

    public Date getTerminatedBefore() {
        return this.terminatedBefore;
    }

    public Date getTerminatedAfter() {
        return this.terminatedAfter;
    }

    public Date getOccurredBefore() {
        return this.occurredBefore;
    }

    public Date getOccurredAfter() {
        return this.occurredAfter;
    }

    public Date getExitBefore() {
        return this.exitBefore;
    }

    public Date getExitAfter() {
        return this.exitAfter;
    }

    public Date getEndedBefore() {
        return this.endedBefore;
    }

    public Date getEndedAfter() {
        return this.endedAfter;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public boolean isIncludeEnded() {
        return this.includeEnded;
    }

    public String getStartUserId() {
        return this.startUserId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public boolean isCompletable() {
        return this.completable;
    }

    public boolean isOnlyStages() {
        return this.onlyStages;
    }

    public String getEntryCriterionId() {
        return this.entryCriterionId;
    }

    public String getExitCriterionId() {
        return this.exitCriterionId;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public String getExtraValue() {
        return this.extraValue;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public Collection<String> getInvolvedGroups() {
        return this.involvedGroups;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public boolean isIncludeLocalVariables() {
        return this.includeLocalVariables;
    }

    public List<List<String>> getSafeInvolvedGroups() {
        return this.safeInvolvedGroups;
    }

    public void setSafeInvolvedGroups(List<List<String>> safeInvolvedGroups) {
        this.safeInvolvedGroups = safeInvolvedGroups;
    }

    protected void ensureVariablesInitialized() {
        super.ensureVariablesInitialized();
        for (PlanItemInstanceQueryImpl orQueryObject : this.orQueryObjects) {
            orQueryObject.ensureVariablesInitialized();
        }
    }

    public List<PlanItemInstanceQueryImpl> getOrQueryObjects() {
        return this.orQueryObjects;
    }
}

