/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.reactivation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.cmmn.api.reactivation.CaseReactivationBuilder;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.cmd.ReactivateHistoricCaseInstanceCmd;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;

public class CaseReactivationBuilderImpl
implements CaseReactivationBuilder {
    protected final CommandExecutor commandExecutor;
    protected final String caseInstanceId;
    protected List<String> terminatedPlanItemDefinitionIds = new ArrayList<String>();
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;

    public CaseReactivationBuilderImpl(CommandExecutor commandExecutor, String caseInstanceId) {
        this.commandExecutor = commandExecutor;
        this.caseInstanceId = caseInstanceId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public List<String> getTerminatedPlanItemDefinitionIds() {
        return this.terminatedPlanItemDefinitionIds;
    }

    public boolean hasVariables() {
        return this.variables != null && this.variables.size() > 0;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public boolean hasTransientVariables() {
        return this.transientVariables != null && this.transientVariables.size() > 0;
    }

    public Map<String, Object> getTransientVariables() {
        return this.transientVariables;
    }

    public CaseReactivationBuilder addTerminatedPlanItemInstanceForPlanItemDefinition(String planItemDefinitionId) {
        this.terminatedPlanItemDefinitionIds.add(planItemDefinitionId);
        return this;
    }

    public CaseReactivationBuilder variable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(name, value);
        return this;
    }

    public CaseReactivationBuilder variables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.putAll(variables);
        return this;
    }

    public CaseReactivationBuilder transientVariable(String name, Object value) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        this.transientVariables.put(name, value);
        return this;
    }

    public CaseReactivationBuilder transientVariables(Map<String, Object> variables) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        this.transientVariables.putAll(variables);
        return this;
    }

    public CaseInstance reactivate() {
        return (CaseInstance)this.commandExecutor.execute((Command)new ReactivateHistoricCaseInstanceCmd(this));
    }
}

