/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.persistence.entity;

import java.util.List;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricMilestoneInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CaseDefinitionQuery;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryHelper;
import org.flowable.cmmn.engine.impl.history.HistoricCaseInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.history.HistoricMilestoneInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseDefinitionEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricMilestoneInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricPlanItemInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.data.CaseDefinitionDataManager;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionQueryImpl;
import org.flowable.cmmn.engine.impl.runtime.CaseInstanceQueryImpl;
import org.flowable.cmmn.engine.impl.task.TaskHelper;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.AbstractEngineEntityManager;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.identitylink.service.impl.persistence.entity.HistoricIdentityLinkEntityManager;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntityManager;

public class CaseDefinitionEntityManagerImpl
extends AbstractEngineEntityManager<CmmnEngineConfiguration, CaseDefinitionEntity, CaseDefinitionDataManager>
implements CaseDefinitionEntityManager {
    public CaseDefinitionEntityManagerImpl(CmmnEngineConfiguration cmmnEngineConfiguration, CaseDefinitionDataManager caseDefinitionDataManager) {
        super((AbstractEngineConfiguration)cmmnEngineConfiguration, (DataManager)caseDefinitionDataManager);
    }

    @Override
    public CaseDefinitionEntity findLatestCaseDefinitionByKey(String caseDefinitionKey) {
        return ((CaseDefinitionDataManager)this.dataManager).findLatestCaseDefinitionByKey(caseDefinitionKey);
    }

    @Override
    public CaseDefinitionEntity findLatestCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        return ((CaseDefinitionDataManager)this.dataManager).findLatestCaseDefinitionByKeyAndTenantId(caseDefinitionKey, tenantId);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByDeploymentAndKey(String deploymentId, String caseDefinitionKey) {
        return ((CaseDefinitionDataManager)this.dataManager).findCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByDeploymentAndKeyAndTenantId(String deploymentId, String caseDefinitionKey, String tenantId) {
        return ((CaseDefinitionDataManager)this.dataManager).findCaseDefinitionByDeploymentAndKeyAndTenantId(deploymentId, caseDefinitionKey, tenantId);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByParentDeploymentAndKey(String parentDeploymentId, String caseDefinitionKey) {
        return ((CaseDefinitionDataManager)this.dataManager).findCaseDefinitionByParentDeploymentAndKey(parentDeploymentId, caseDefinitionKey);
    }

    @Override
    public CaseDefinitionEntity findCaseDefinitionByParentDeploymentAndKeyAndTenantId(String parentDeploymentId, String caseDefinitionKey, String tenantId) {
        return ((CaseDefinitionDataManager)this.dataManager).findCaseDefinitionByParentDeploymentAndKeyAndTenantId(parentDeploymentId, caseDefinitionKey, tenantId);
    }

    @Override
    public CaseDefinition findCaseDefinitionByKeyAndVersionAndTenantId(String caseDefinitionKey, Integer caseDefinitionVersion, String tenantId) {
        if (tenantId == null || "".equals(tenantId)) {
            return ((CaseDefinitionDataManager)this.dataManager).findCaseDefinitionByKeyAndVersion(caseDefinitionKey, caseDefinitionVersion);
        }
        return ((CaseDefinitionDataManager)this.dataManager).findCaseDefinitionByKeyAndVersionAndTenantId(caseDefinitionKey, caseDefinitionVersion, tenantId);
    }

    @Override
    public void deleteCaseDefinitionAndRelatedData(String caseDefinitionId, boolean cascadeHistory) {
        CaseInstanceEntityManager caseInstanceEntityManager = this.getCaseInstanceEntityManager();
        CommandContext commandContext = Context.getCommandContext();
        List<CaseInstance> caseInstances = caseInstanceEntityManager.findByCriteria(new CaseInstanceQueryImpl(commandContext, (CmmnEngineConfiguration)this.engineConfiguration).caseDefinitionId(caseDefinitionId));
        for (CaseInstance caseInstance : caseInstances) {
            caseInstanceEntityManager.delete(caseInstance.getId(), true, null);
        }
        if (cascadeHistory) {
            ((CmmnEngineConfiguration)this.engineConfiguration).getTaskServiceConfiguration().getHistoricTaskService().deleteHistoricTaskLogEntriesForScopeDefinition("cmmn", caseDefinitionId);
            HistoricIdentityLinkEntityManager historicIdentityLinkEntityManager = this.getHistoricIdentityLinkEntityManager();
            historicIdentityLinkEntityManager.deleteHistoricIdentityLinksByScopeDefinitionIdAndScopeType(caseDefinitionId, "cmmn");
            HistoricMilestoneInstanceEntityManager historicMilestoneInstanceEntityManager = this.getHistoricMilestoneInstanceEntityManager();
            List<HistoricMilestoneInstance> historicMilestoneInstances = historicMilestoneInstanceEntityManager.findHistoricMilestoneInstancesByQueryCriteria(new HistoricMilestoneInstanceQueryImpl().milestoneInstanceCaseDefinitionId(caseDefinitionId));
            for (HistoricMilestoneInstance historicMilestoneInstance : historicMilestoneInstances) {
                historicMilestoneInstanceEntityManager.delete(historicMilestoneInstance.getId());
            }
            HistoricTaskInstanceEntityManager historicTaskInstanceEntityManager = this.getHistoricTaskInstanceEntityManager();
            List historicTaskInstances = historicTaskInstanceEntityManager.findHistoricTaskInstancesByQueryCriteria(new HistoricTaskInstanceQueryImpl().scopeDefinitionId(caseDefinitionId).scopeType("cmmn"));
            for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
                TaskHelper.deleteHistoricTask(historicTaskInstance.getId(), (CmmnEngineConfiguration)this.engineConfiguration);
            }
            HistoricPlanItemInstanceEntityManager historicPlanItemInstanceEntityManager = this.getHistoricPlanItemInstanceEntityManager();
            historicPlanItemInstanceEntityManager.findByCaseDefinitionId(caseDefinitionId).forEach(p -> historicPlanItemInstanceEntityManager.delete(p.getId()));
            HistoricCaseInstanceEntityManager historicCaseInstanceEntityManager = this.getHistoricCaseInstanceEntityManager();
            List<HistoricCaseInstance> historicCaseInstanceEntities = historicCaseInstanceEntityManager.findByCriteria(new HistoricCaseInstanceQueryImpl().caseDefinitionId(caseDefinitionId));
            for (HistoricCaseInstance historicCaseInstanceEntity : historicCaseInstanceEntities) {
                CmmnHistoryHelper.deleteHistoricCaseInstance((CmmnEngineConfiguration)this.engineConfiguration, historicCaseInstanceEntity.getId());
            }
        }
        CaseDefinitionEntity caseDefinitionEntity = (CaseDefinitionEntity)this.findById(caseDefinitionId);
        this.delete(caseDefinitionEntity);
    }

    @Override
    public CaseDefinitionQuery createCaseDefinitionQuery() {
        return new CaseDefinitionQueryImpl(((CmmnEngineConfiguration)this.engineConfiguration).getCommandExecutor());
    }

    @Override
    public List<CaseDefinition> findCaseDefinitionsByQueryCriteria(CaseDefinitionQuery caseDefinitionQuery) {
        return ((CaseDefinitionDataManager)this.dataManager).findCaseDefinitionsByQueryCriteria((CaseDefinitionQueryImpl)caseDefinitionQuery);
    }

    @Override
    public long findCaseDefinitionCountByQueryCriteria(CaseDefinitionQuery caseDefinitionQuery) {
        return ((CaseDefinitionDataManager)this.dataManager).findCaseDefinitionCountByQueryCriteria((CaseDefinitionQueryImpl)caseDefinitionQuery);
    }

    protected CaseInstanceEntityManager getCaseInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getCaseInstanceEntityManager();
    }

    protected HistoricIdentityLinkEntityManager getHistoricIdentityLinkEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getIdentityLinkServiceConfiguration().getHistoricIdentityLinkEntityManager();
    }

    protected HistoricMilestoneInstanceEntityManager getHistoricMilestoneInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getHistoricMilestoneInstanceEntityManager();
    }

    protected HistoricTaskInstanceEntityManager getHistoricTaskInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getTaskServiceConfiguration().getHistoricTaskInstanceEntityManager();
    }

    protected HistoricPlanItemInstanceEntityManager getHistoricPlanItemInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getHistoricPlanItemInstanceEntityManager();
    }

    protected HistoricCaseInstanceEntityManager getHistoricCaseInstanceEntityManager() {
        return ((CmmnEngineConfiguration)this.engineConfiguration).getHistoricCaseInstanceEntityManager();
    }
}

