/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.job;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.cmmn.api.migration.HistoricCaseInstanceMigrationDocument;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.job.AbstractCaseInstanceMigrationJobHandler;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationManager;
import org.flowable.cmmn.engine.impl.migration.HistoricCaseInstanceMigrationDocumentImpl;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableBatchPartMigrationException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class HistoricCaseInstanceMigrationJobHandler
extends AbstractCaseInstanceMigrationJobHandler {
    public static final String TYPE = "historic-case-migration";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        final CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        final BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        CaseInstanceMigrationManager migrationManager = engineConfiguration.getCaseInstanceMigrationManager();
        final String batchPartId = HistoricCaseInstanceMigrationJobHandler.getBatchPartIdFromHandlerCfg(configuration);
        BatchPart batchPart = batchService.getBatchPart(batchPartId);
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        HistoricCaseInstanceMigrationDocument migrationDocument = HistoricCaseInstanceMigrationDocumentImpl.fromJson(batch.getBatchDocumentJson(engineConfiguration.getEngineCfgKey()));
        try {
            migrationManager.migrateHistoricCaseInstance(batchPart.getScopeId(), migrationDocument, commandContext);
        }
        catch (Exception e) {
            final String exceptionMessage = e.getMessage();
            engineConfiguration.getCommandExecutor().execute((Command)new Command<Object>(){

                public Void execute(CommandContext commandContext) {
                    CommandConfig commandConfig = engineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
                    return (Void)engineConfiguration.getCommandExecutor().execute(commandConfig, (Command)new Command<Void>(){

                        public Void execute(CommandContext commandContext2) {
                            String resultAsJsonString = HistoricCaseInstanceMigrationJobHandler.this.prepareResultAsJsonString(exceptionMessage, e);
                            batchService.completeBatchPart(batchPartId, "fail", resultAsJsonString);
                            return null;
                        }
                    });
                }
            });
            FlowableBatchPartMigrationException wrappedException = new FlowableBatchPartMigrationException(e.getMessage(), (Throwable)e);
            wrappedException.setIgnoreFailedJob(true);
            throw wrappedException;
        }
        String resultAsJsonString = this.prepareResultAsJsonString();
        batchService.completeBatchPart(batchPartId, "success", resultAsJsonString);
    }

    protected String prepareResultAsJsonString(String exceptionMessage, Exception e) {
        ObjectNode objectNode = HistoricCaseInstanceMigrationJobHandler.getObjectMapper().createObjectNode();
        objectNode.put("resultStatus", "fail");
        objectNode.put("resultMessage", exceptionMessage);
        objectNode.put("resultStacktrace", this.getExceptionStacktrace(e));
        return objectNode.toString();
    }

    protected String prepareResultAsJsonString() {
        ObjectNode objectNode = HistoricCaseInstanceMigrationJobHandler.getObjectMapper().createObjectNode();
        objectNode.put("resultStatus", "success");
        return objectNode.toString();
    }

    protected String getExceptionStacktrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

