/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendarManager;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimerEventListenerActivityBehaviour
extends CoreCmmnActivityBehavior
implements PlanItemActivityBehavior {
    protected TimerEventListener timerEventListener;

    public TimerEventListenerActivityBehaviour(TimerEventListener timerEventListener) {
        this.timerEventListener = timerEventListener;
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("create".equals(transition) && StringUtils.isEmpty((CharSequence)this.timerEventListener.getAvailableConditionExpression()) || "initiate".equals(transition)) {
            this.handleCreateTransition(commandContext, (PlanItemInstanceEntity)planItemInstance);
        } else if ("dismiss".equals(transition) || "terminate".equals(transition) || "exit".equals(transition)) {
            this.removeTimerJob(commandContext, (PlanItemInstanceEntity)planItemInstance);
        }
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        CommandContextUtil.getAgenda(commandContext).planOccurPlanItemInstanceOperation(planItemInstanceEntity);
    }

    @Override
    public void trigger(DelegatePlanItemInstance planItemInstance) {
        this.execute(planItemInstance);
    }

    protected void handleCreateTransition(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        if (this.timerJobForPlanItemInstanceExists(commandContext, planItemInstance)) {
            return;
        }
        Object timerValue = this.resolveTimerExpression(commandContext, planItemInstance);
        Date timerDueDate = null;
        boolean isRepeating = false;
        if (timerValue != null) {
            if (timerValue instanceof Date) {
                timerDueDate = (Date)timerValue;
            } else if (timerValue instanceof DateTime) {
                DateTime timerDateTime = (DateTime)timerValue;
                timerDueDate = timerDateTime.toDate();
            } else if (timerValue instanceof String) {
                String timerString = (String)timerValue;
                BusinessCalendarManager businessCalendarManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getBusinessCalendarManager();
                if (this.isDurationString(timerString)) {
                    timerDueDate = businessCalendarManager.getBusinessCalendar("dueDate").resolveDuedate(timerString);
                } else if (this.isRepetitionString(timerString)) {
                    timerDueDate = businessCalendarManager.getBusinessCalendar("cycle").resolveDuedate(timerString);
                    isRepeating = true;
                } else {
                    try {
                        timerDueDate = DateTime.parse((String)timerString).toDate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        timerDueDate = businessCalendarManager.getBusinessCalendar("cycle").resolveDuedate(timerString);
                        isRepeating = true;
                    }
                    catch (Exception exception) {}
                }
            } else if (timerValue instanceof Instant) {
                timerDueDate = Date.from((Instant)timerValue);
            } else if (timerValue instanceof LocalDate) {
                timerDueDate = Date.from(((LocalDate)timerValue).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            } else if (timerValue instanceof LocalDateTime) {
                timerDueDate = Date.from(((LocalDateTime)timerValue).atZone(ZoneId.systemDefault()).toInstant());
            }
        }
        if (timerDueDate == null) {
            throw new FlowableException("Timer expression '" + this.timerEventListener.getTimerExpression() + "' did not resolve to java.util.Date, org.joda.time.DateTime, java.time.Instant, java.time.LocalDate, java.time.LocalDateTime or an ISO8601 date/duration/repetition string or a cron expression for " + planItemInstance);
        }
        this.scheduleTimerJob(commandContext, planItemInstance, timerValue, timerDueDate, isRepeating);
    }

    protected boolean timerJobForPlanItemInstanceExists(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        List jobsByScopeIdAndSubScopeId = cmmnEngineConfiguration.getJobServiceConfiguration().getTimerJobEntityManager().findJobsByScopeIdAndSubScopeId(planItemInstance.getCaseInstanceId(), planItemInstance.getId());
        return jobsByScopeIdAndSubScopeId != null && !jobsByScopeIdAndSubScopeId.isEmpty();
    }

    protected void scheduleTimerJob(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, Object timerValue, Date timerDueDate, boolean isRepeating) {
        if (timerDueDate != null) {
            Expression categoryExpression;
            Object categoryValue;
            ExtensionElement jobCategoryElement;
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            JobServiceConfiguration jobServiceConfiguration = cmmnEngineConfiguration.getJobServiceConfiguration();
            TimerJobEntity timer = jobServiceConfiguration.getTimerJobService().createTimerJob();
            timer.setJobType("timer");
            timer.setJobHandlerType("cmmn-trigger-timer");
            timer.setExclusive(true);
            timer.setRetries(jobServiceConfiguration.getAsyncExecutorNumberOfRetries());
            timer.setDuedate(timerDueDate);
            timer.setScopeDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
            timer.setScopeId(planItemInstanceEntity.getCaseInstanceId());
            timer.setSubScopeId(planItemInstanceEntity.getId());
            PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItemDefinition();
            List jobCategoryElements = (List)planItemDefinition.getExtensionElements().get("jobCategory");
            if (jobCategoryElements != null && jobCategoryElements.size() > 0 && StringUtils.isNotEmpty((CharSequence)(jobCategoryElement = (ExtensionElement)jobCategoryElements.get(0)).getElementText()) && (categoryValue = (categoryExpression = cmmnEngineConfiguration.getExpressionManager().createExpression(jobCategoryElement.getElementText())).getValue((VariableContainer)planItemInstanceEntity)) != null) {
                timer.setCategory(categoryValue.toString());
            }
            timer.setScopeType("cmmn");
            timer.setElementId(this.timerEventListener.getId());
            timer.setElementName(this.timerEventListener.getName());
            timer.setTenantId(planItemInstanceEntity.getTenantId());
            if (isRepeating && timerValue instanceof String) {
                timer.setRepeat(this.prepareRepeat((String)timerValue, CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock()));
            }
            jobServiceConfiguration.getTimerJobService().scheduleTimerJob(timer);
        }
    }

    protected void removeTimerJob(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        TimerJobEntityManager timerJobEntityManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getJobServiceConfiguration().getTimerJobEntityManager();
        List timerJobsEntities = timerJobEntityManager.findJobsByScopeIdAndSubScopeId(planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId());
        for (TimerJobEntity timerJobEntity : timerJobsEntities) {
            timerJobEntityManager.delete((Entity)timerJobEntity);
        }
    }

    protected Object resolveTimerExpression(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        ExpressionManager expressionManager = CommandContextUtil.getExpressionManager(commandContext);
        Expression expression = expressionManager.createExpression(this.timerEventListener.getTimerExpression());
        return expression.getValue((VariableContainer)planItemInstanceEntity);
    }

    protected boolean isRepetitionString(String timerString) {
        return timerString != null && timerString.startsWith("R");
    }

    protected boolean isDurationString(String timerString) {
        return timerString != null && timerString.startsWith("P");
    }

    public String prepareRepeat(String dueDate, Clock clock) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
            return dueDate.replace("/", "/" + fmt.print((ReadableInstant)new DateTime((Object)clock.getCurrentTime(), DateTimeZone.forTimeZone((TimeZone)clock.getCurrentTimeZone()))) + "/");
        }
        return dueDate;
    }
}

