/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.flowable.cmmn.api.delegate.DelegatePlanItemInstance;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.PlanItemActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.TimerEventListener;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.calendar.BusinessCalendarManager;
import org.flowable.common.engine.impl.calendar.CycleBusinessCalendar;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.persistence.entity.Entity;
import org.flowable.common.engine.impl.runtime.Clock;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityManager;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimerEventListenerActivityBehaviour
extends CoreCmmnActivityBehavior
implements PlanItemActivityBehavior {
    protected String timerExpression;
    protected String startTriggerSourceRef;
    protected String startTriggerStandardEvent;

    public TimerEventListenerActivityBehaviour(TimerEventListener timerEventListener) {
        this.timerExpression = timerEventListener.getTimerExpression();
        this.startTriggerSourceRef = timerEventListener.getTimerStartTriggerSourceRef();
        this.startTriggerStandardEvent = timerEventListener.getTimerStartTriggerStandardEvent();
    }

    @Override
    public void onStateTransition(CommandContext commandContext, DelegatePlanItemInstance planItemInstance, String transition) {
        if ("create".equals(transition)) {
            this.handleCreateTransition(commandContext, (PlanItemInstanceEntity)planItemInstance);
        } else if ("terminate".equals(transition)) {
            this.handleTerminateTransition(commandContext, (PlanItemInstanceEntity)planItemInstance);
        }
    }

    protected void handleCreateTransition(CommandContext commandContext, PlanItemInstanceEntity planItemInstance) {
        PlanItemInstanceEntity planItemInstanceEntity = planItemInstance;
        Object timerValue = this.resolveTimerExpression(commandContext, planItemInstanceEntity);
        Date timerDueDate = null;
        boolean isRepeating = false;
        if (timerValue != null) {
            if (timerValue instanceof Date) {
                timerDueDate = (Date)timerValue;
            } else if (timerValue instanceof DateTime) {
                DateTime timerDateTime = (DateTime)timerValue;
                timerDueDate = timerDateTime.toDate();
            } else if (timerValue instanceof String) {
                String timerString = (String)timerValue;
                BusinessCalendarManager businessCalendarManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getBusinessCalendarManager();
                if (this.isDurationString(timerString)) {
                    timerDueDate = businessCalendarManager.getBusinessCalendar("dueDate").resolveDuedate(timerString);
                } else if (this.isRepetitionString(timerString)) {
                    timerDueDate = businessCalendarManager.getBusinessCalendar(CycleBusinessCalendar.NAME).resolveDuedate(timerString);
                    isRepeating = true;
                } else {
                    try {
                        timerDueDate = DateTime.parse((String)timerString).toDate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        timerDueDate = businessCalendarManager.getBusinessCalendar(CycleBusinessCalendar.NAME).resolveDuedate(timerString);
                        isRepeating = true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (timerDueDate == null) {
            throw new FlowableException("Timer expression '" + this.timerExpression + "' did not resolve to java.util.Date, org.joda.time.DateTime, an ISO8601 date/duration/repetition string or a cron expression");
        }
        this.scheduleTimerJob(commandContext, planItemInstanceEntity, timerValue, timerDueDate, isRepeating);
    }

    protected void scheduleTimerJob(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity, Object timerValue, Date timerDueDate, boolean isRepeating) {
        if (timerDueDate != null) {
            JobServiceConfiguration jobServiceConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getJobServiceConfiguration();
            TimerJobEntity timer = jobServiceConfiguration.getTimerJobService().createTimerJob();
            timer.setJobType("timer");
            timer.setJobHandlerType("cmmn-trigger-timer");
            timer.setExclusive(true);
            timer.setRetries(jobServiceConfiguration.getAsyncExecutorNumberOfRetries());
            timer.setDuedate(timerDueDate);
            timer.setScopeDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
            timer.setScopeId(planItemInstanceEntity.getCaseInstanceId());
            timer.setSubScopeId(planItemInstanceEntity.getId());
            timer.setScopeType("cmmn");
            timer.setTenantId(planItemInstanceEntity.getTenantId());
            if (isRepeating && timerValue instanceof String) {
                timer.setRepeat(this.prepareRepeat((String)timerValue, CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock()));
            }
            jobServiceConfiguration.getTimerJobService().scheduleTimerJob(timer);
        }
    }

    protected void handleTerminateTransition(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        TimerJobEntityManager timerJobEntityManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getJobServiceConfiguration().getTimerJobEntityManager();
        List timerJobsEntities = timerJobEntityManager.findJobsByScopeIdAndSubScopeId(planItemInstanceEntity.getCaseInstanceId(), planItemInstanceEntity.getId());
        for (TimerJobEntity timerJobEntity : timerJobsEntities) {
            timerJobEntityManager.delete((Entity)timerJobEntity);
        }
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        CommandContextUtil.getAgenda(commandContext).planOccurPlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected Object resolveTimerExpression(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        ExpressionManager expressionManager = CommandContextUtil.getExpressionManager(commandContext);
        Expression expression = expressionManager.createExpression(this.timerExpression);
        return expression.getValue((VariableContainer)planItemInstanceEntity);
    }

    protected boolean isRepetitionString(String timerString) {
        return timerString != null && timerString.startsWith("R");
    }

    protected boolean isDurationString(String timerString) {
        return timerString != null && timerString.startsWith("P");
    }

    public String prepareRepeat(String dueDate, Clock clock) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
            return dueDate.replace("/", "/" + fmt.print((ReadableInstant)new DateTime((Object)clock.getCurrentTime(), DateTimeZone.forTimeZone((TimeZone)clock.getCurrentTimeZone()))) + "/");
        }
        return dueDate;
    }

    @Override
    public void trigger(DelegatePlanItemInstance planItemInstance) {
        this.execute(planItemInstance);
    }
}

