/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractPlanItemInstanceOperation;
import org.flowable.cmmn.engine.impl.behavior.CmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnTriggerableActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class TriggerPlanItemInstanceOperation
extends AbstractPlanItemInstanceOperation {
    public TriggerPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    public void run() {
        if ("active".equals(this.planItemInstanceEntity.getState()) || this.planItemInstanceEntity.getPlanItem() != null && this.planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof EventListener && "available".equals(this.planItemInstanceEntity.getState())) {
            this.executeTrigger();
        }
    }

    protected void executeTrigger() {
        Object behaviorObject = this.planItemInstanceEntity.getPlanItem().getBehavior();
        if (!(behaviorObject instanceof CmmnTriggerableActivityBehavior)) {
            throw new FlowableException("Cannot trigger a plan item which activity behavior does not implement the " + CmmnTriggerableActivityBehavior.class + " interface");
        }
        CmmnTriggerableActivityBehavior behavior = (CmmnTriggerableActivityBehavior)this.planItemInstanceEntity.getPlanItem().getBehavior();
        if (behavior instanceof CoreCmmnTriggerableActivityBehavior) {
            ((CoreCmmnTriggerableActivityBehavior)behavior).trigger(this.commandContext, this.planItemInstanceEntity);
        } else {
            behavior.trigger(this.planItemInstanceEntity);
        }
    }

    public String toString() {
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Trigger PlanItem] ");
        if (planItem.getName() != null) {
            stringBuilder.append(planItem.getName());
            stringBuilder.append(" (");
            stringBuilder.append(planItem.getId());
            stringBuilder.append(")");
        } else {
            stringBuilder.append(planItem.getId());
        }
        return stringBuilder.toString();
    }
}

