/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class CmmnOperation
implements Runnable {
    protected CommandContext commandContext;

    public CmmnOperation() {
    }

    public CmmnOperation(CommandContext commandContext) {
        this.commandContext = commandContext;
    }

    protected Stage getStage(PlanItemInstanceEntity planItemInstanceEntity) {
        PlanItemDefinition planItemDefinition = planItemInstanceEntity.getPlanItem().getPlanItemDefinition();
        if (planItemDefinition instanceof Stage) {
            return (Stage)planItemDefinition;
        }
        return planItemDefinition.getParentStage();
    }

    protected boolean isStage(PlanItemInstanceEntity planItemInstanceEntity) {
        return planItemInstanceEntity.getPlanItem() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() != null && planItemInstanceEntity.getPlanItem().getPlanItemDefinition() instanceof Stage;
    }

    protected Stage getPlanModel(CaseInstanceEntity caseInstanceEntity) {
        return CaseDefinitionUtil.getCase(caseInstanceEntity.getCaseDefinitionId()).getPlanModel();
    }

    protected List<PlanItemInstanceEntity> createPlanItemInstances(CommandContext commandContext, List<PlanItem> planItems, String caseDefinitionId, String caseInstanceId, PlanItemInstanceEntity stagePlanItemInstanceEntity, String tenantId) {
        ArrayList<PlanItemInstanceEntity> planItemInstances = new ArrayList<PlanItemInstanceEntity>();
        for (PlanItem planItem : planItems) {
            if (stagePlanItemInstanceEntity != null && this.childPlanItemInstanceForPlanItemExists(stagePlanItemInstanceEntity, planItem)) continue;
            PlanItemInstanceEntity childPlanItemInstance = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createChildPlanItemInstance(planItem, caseDefinitionId, caseInstanceId, stagePlanItemInstanceEntity != null ? stagePlanItemInstanceEntity.getId() : null, tenantId, true);
            planItemInstances.add(childPlanItemInstance);
            CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceOperation(childPlanItemInstance);
        }
        return planItemInstances;
    }

    protected boolean childPlanItemInstanceForPlanItemExists(PlanItemInstanceEntity stagePlanItemInstanceEntity, PlanItem planItem) {
        List childPlanItemInstances = stagePlanItemInstanceEntity.getChildPlanItemInstances();
        if (childPlanItemInstances != null && !childPlanItemInstances.isEmpty()) {
            for (PlanItemInstanceEntity childPlanItemInstanceEntity : childPlanItemInstances) {
                if (childPlanItemInstanceEntity.getPlanItem() == null || !planItem.getId().equals(childPlanItemInstanceEntity.getPlanItem().getId())) continue;
                return true;
            }
        }
        return false;
    }

    protected PlanItemInstanceEntity copyAndInsertPlanItemInstance(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntityToCopy, boolean addToParent) {
        PlanItemInstanceEntity planItemInstanceEntity = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createChildPlanItemInstance(planItemInstanceEntityToCopy.getPlanItem(), planItemInstanceEntityToCopy.getCaseDefinitionId(), planItemInstanceEntityToCopy.getCaseInstanceId(), planItemInstanceEntityToCopy.getStageInstanceId(), planItemInstanceEntityToCopy.getTenantId(), addToParent);
        if (this.hasRepetitionRule(planItemInstanceEntityToCopy)) {
            int counter = this.getRepetitionCounter(planItemInstanceEntityToCopy);
            this.setRepetitionCounter(planItemInstanceEntity, counter);
        }
        return planItemInstanceEntity;
    }

    protected int getRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        Integer counter = (Integer)repeatingPlanItemInstanceEntity.getVariableLocal(this.getCounterVariable(repeatingPlanItemInstanceEntity));
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    protected void setRepetitionCounter(PlanItemInstanceEntity repeatingPlanItemInstanceEntity, int counterValue) {
        repeatingPlanItemInstanceEntity.setVariableLocal(this.getCounterVariable(repeatingPlanItemInstanceEntity), counterValue);
    }

    protected String getCounterVariable(PlanItemInstanceEntity repeatingPlanItemInstanceEntity) {
        String repetitionCounterVariableName = repeatingPlanItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule().getRepetitionCounterVariableName();
        return repetitionCounterVariableName;
    }

    protected boolean hasRepetitionRule(PlanItemInstanceEntity planItemInstanceEntity) {
        if (planItemInstanceEntity != null && planItemInstanceEntity.getPlanItem() != null) {
            return this.hasRepetitionRule(planItemInstanceEntity.getPlanItem());
        }
        return false;
    }

    protected boolean hasRepetitionRule(PlanItem planItem) {
        return planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null;
    }

    protected boolean evaluateRepetitionRule(PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.hasRepetitionRule(planItemInstanceEntity)) {
            String repetitionCondition = planItemInstanceEntity.getPlanItem().getItemControl().getRepetitionRule().getCondition();
            return this.evaluateRepetitionRule((VariableContainer)planItemInstanceEntity, repetitionCondition);
        }
        return false;
    }

    protected boolean evaluateRepetitionRule(VariableContainer variableContainer, String repetitionCondition) {
        if (StringUtils.isNotEmpty((CharSequence)repetitionCondition)) {
            return this.evaluateBooleanExpression(this.commandContext, variableContainer, repetitionCondition);
        }
        return true;
    }

    protected boolean evaluateBooleanExpression(CommandContext commandContext, VariableContainer variableContainer, String condition) {
        Expression expression = CommandContextUtil.getExpressionManager(commandContext).createExpression(condition);
        Object evaluationResult = expression.getValue(variableContainer);
        if (evaluationResult instanceof Boolean) {
            return (Boolean)evaluationResult;
        }
        if (evaluationResult instanceof String) {
            return ((String)evaluationResult).toLowerCase().equals("true");
        }
        throw new FlowableException("Expression condition " + condition + " did not evaluate to a boolean value");
    }
}

