/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.ValuedDataObject;

public class SubProcess
extends Activity
implements FlowElementsContainer {
    protected Map<String, FlowElement> flowElementMap = new LinkedHashMap<String, FlowElement>();
    protected List<FlowElement> flowElementList = new ArrayList<FlowElement>();
    protected List<Artifact> artifactList = new ArrayList<Artifact>();
    protected List<ValuedDataObject> dataObjects = new ArrayList<ValuedDataObject>();

    @Override
    public FlowElement getFlowElement(String id) {
        FlowElement foundElement = null;
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            foundElement = this.flowElementMap.get(id);
        }
        return foundElement;
    }

    @Override
    public Collection<FlowElement> getFlowElements() {
        return this.flowElementList;
    }

    @Override
    public void addFlowElement(FlowElement element) {
        this.flowElementList.add(element);
        element.setParentContainer(this);
        this.addFlowElementToMap(element);
    }

    @Override
    public void addFlowElementToMap(FlowElement element) {
        if (element != null && StringUtils.isNotEmpty((CharSequence)element.getId())) {
            this.flowElementMap.put(element.getId(), element);
            if (this.getParentContainer() != null) {
                this.getParentContainer().addFlowElementToMap(element);
            }
        }
    }

    @Override
    public void removeFlowElement(String elementId) {
        FlowElement element = this.getFlowElement(elementId);
        if (element != null) {
            this.flowElementList.remove(element);
            this.flowElementMap.remove(elementId);
            if (element.getParentContainer() != null) {
                element.getParentContainer().removeFlowElementFromMap(elementId);
            }
        }
    }

    @Override
    public void removeFlowElementFromMap(String elementId) {
        if (StringUtils.isNotEmpty((CharSequence)elementId)) {
            this.flowElementMap.remove(elementId);
        }
    }

    public Map<String, FlowElement> getFlowElementMap() {
        return this.flowElementMap;
    }

    public void setFlowElementMap(Map<String, FlowElement> flowElementMap) {
        this.flowElementMap = flowElementMap;
    }

    public boolean containsFlowElementId(String id) {
        return this.flowElementMap.containsKey(id);
    }

    @Override
    public Artifact getArtifact(String id) {
        Artifact foundArtifact = null;
        for (Artifact artifact : this.artifactList) {
            if (!id.equals(artifact.getId())) continue;
            foundArtifact = artifact;
            break;
        }
        return foundArtifact;
    }

    @Override
    public Collection<Artifact> getArtifacts() {
        return this.artifactList;
    }

    @Override
    public void addArtifact(Artifact artifact) {
        this.artifactList.add(artifact);
    }

    @Override
    public void removeArtifact(String artifactId) {
        Artifact artifact = this.getArtifact(artifactId);
        if (artifact != null) {
            this.artifactList.remove(artifact);
        }
    }

    @Override
    public SubProcess clone() {
        SubProcess clone = new SubProcess();
        clone.setValues(this);
        return clone;
    }

    public void setValues(SubProcess otherElement) {
        super.setValues(otherElement);
        for (ValuedDataObject thisObject : this.getDataObjects()) {
            boolean exists = false;
            for (ValuedDataObject otherObject : otherElement.getDataObjects()) {
                if (!thisObject.getId().equals(otherObject.getId())) continue;
                exists = true;
            }
            if (exists) continue;
            this.removeFlowElement(thisObject.getId());
        }
        this.dataObjects = new ArrayList<ValuedDataObject>();
        if (otherElement.getDataObjects() != null && !otherElement.getDataObjects().isEmpty()) {
            for (ValuedDataObject dataObject : otherElement.getDataObjects()) {
                ValuedDataObject clone = dataObject.clone();
                this.dataObjects.add(clone);
                this.removeFlowElement(clone.getId());
                this.addFlowElement(clone);
            }
        }
        this.flowElementList.clear();
        for (FlowElement flowElement : otherElement.getFlowElements()) {
            this.addFlowElement(flowElement);
        }
        this.artifactList.clear();
        for (Artifact artifact : otherElement.getArtifacts()) {
            this.addArtifact(artifact);
        }
    }

    public List<ValuedDataObject> getDataObjects() {
        return this.dataObjects;
    }

    public void setDataObjects(List<ValuedDataObject> dataObjects) {
        this.dataObjects = dataObjects;
    }
}

