/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.batch.service.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchQuery;
import org.flowable.batch.service.BatchServiceConfiguration;
import org.flowable.batch.service.impl.BatchQueryProperty;
import org.flowable.batch.service.impl.persistence.entity.BatchEntity;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.CacheAwareQuery;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;

public class BatchQueryImpl
extends AbstractQuery<BatchQuery, Batch>
implements BatchQuery,
CacheAwareQuery<BatchEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected BatchServiceConfiguration batchServiceConfiguration;
    protected String id;
    protected String batchType;
    protected Collection<String> batchTypes;
    protected String searchKey;
    protected String searchKey2;
    protected Date createTimeHigherThan;
    protected Date createTimeLowerThan;
    protected Date completeTimeHigherThan;
    protected Date completeTimeLowerThan;
    protected String status;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;

    public BatchQueryImpl() {
    }

    public BatchQueryImpl(CommandContext commandContext, BatchServiceConfiguration batchServiceConfiguration) {
        super(commandContext);
        this.batchServiceConfiguration = batchServiceConfiguration;
    }

    public BatchQueryImpl(CommandExecutor commandExecutor, BatchServiceConfiguration batchServiceConfiguration) {
        super(commandExecutor);
        this.batchServiceConfiguration = batchServiceConfiguration;
    }

    public BatchQuery batchId(String batchId) {
        if (batchId == null) {
            throw new FlowableIllegalArgumentException("Provided batch id is null");
        }
        this.id = batchId;
        return this;
    }

    public BatchQuery batchType(String batchType) {
        if (batchType == null) {
            throw new FlowableIllegalArgumentException("Provided batch type is null");
        }
        this.batchType = batchType;
        return this;
    }

    public BatchQuery batchTypes(Collection<String> batchTypes) {
        if (batchTypes == null || batchTypes.isEmpty()) {
            throw new FlowableIllegalArgumentException("Provided batch types must be provided and not empty");
        }
        this.batchTypes = batchTypes;
        return this;
    }

    public BatchQuery searchKey(String searchKey) {
        if (searchKey == null) {
            throw new FlowableIllegalArgumentException("Provided search key is null");
        }
        this.searchKey = searchKey;
        return this;
    }

    public BatchQuery searchKey2(String searchKey) {
        if (searchKey == null) {
            throw new FlowableIllegalArgumentException("Provided search key is null");
        }
        this.searchKey2 = searchKey;
        return this;
    }

    public BatchQuery createTimeHigherThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.createTimeHigherThan = date;
        return this;
    }

    public BatchQuery createTimeLowerThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.createTimeLowerThan = date;
        return this;
    }

    public BatchQuery completeTimeHigherThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.completeTimeHigherThan = date;
        return this;
    }

    public BatchQuery completeTimeLowerThan(Date date) {
        if (date == null) {
            throw new FlowableIllegalArgumentException("Provided date is null");
        }
        this.completeTimeLowerThan = date;
        return this;
    }

    public BatchQuery status(String status) {
        if (status == null) {
            throw new FlowableIllegalArgumentException("Provided status is null");
        }
        this.status = status;
        return this;
    }

    public BatchQuery tenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    public BatchQuery tenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new FlowableIllegalArgumentException("Provided tenant id is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    public BatchQuery withoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    public BatchQuery orderByBatchCreateTime() {
        return (BatchQuery)this.orderBy(BatchQueryProperty.CREATETIME);
    }

    public BatchQuery orderByBatchId() {
        return (BatchQuery)this.orderBy(BatchQueryProperty.BATCH_ID);
    }

    public BatchQuery orderByBatchTenantId() {
        return (BatchQuery)this.orderBy(BatchQueryProperty.TENANT_ID);
    }

    public long executeCount(CommandContext commandContext) {
        return this.batchServiceConfiguration.getBatchEntityManager().findBatchCountByQueryCriteria(this);
    }

    public List<Batch> executeList(CommandContext commandContext) {
        return this.batchServiceConfiguration.getBatchEntityManager().findBatchesByQueryCriteria(this);
    }

    public void delete() {
        if (this.commandExecutor != null) {
            this.commandExecutor.execute(context -> {
                this.executeDelete(context);
                return null;
            });
        } else {
            this.executeDelete(Context.getCommandContext());
        }
    }

    protected void executeDelete(CommandContext commandContext) {
        this.batchServiceConfiguration.getBatchEntityManager().deleteBatches(this);
    }

    public void deleteWithRelatedData() {
        this.delete();
    }

    public String getId() {
        return this.id;
    }

    public String getBatchType() {
        return this.batchType;
    }

    public Collection<String> getBatchTypes() {
        return this.batchTypes;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public String getSearchKey2() {
        return this.searchKey2;
    }

    public Date getCreateTimeHigherThan() {
        return this.createTimeHigherThan;
    }

    public Date getCreateTimeLowerThan() {
        return this.createTimeLowerThan;
    }

    public String getStatus() {
        return this.status;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }
}

