/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine.impl.deployer;

import java.util.Map;
import org.flowable.app.api.repository.AppModel;
import org.flowable.app.engine.AppEngineConfiguration;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntity;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntity;
import org.flowable.app.engine.impl.persistence.entity.deploy.AppDefinitionCacheEntry;
import org.flowable.app.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.repository.EngineDeployment;
import org.flowable.common.engine.api.repository.EngineResource;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDeployer
implements EngineDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDeployer.class);

    public void deploy(EngineDeployment deployment, Map<String, Object> deploymentSettings) {
        LOGGER.debug("Processing app deployment {}", (Object)deployment.getName());
        AppEngineConfiguration appEngineConfiguration = CommandContextUtil.getAppEngineConfiguration();
        AppModel appResourceModel = null;
        AppDeploymentEntity deploymentEntity = (AppDeploymentEntity)deployment;
        Map resources = deploymentEntity.getResources();
        for (String resourceName : resources.keySet()) {
            if (!resourceName.endsWith(".app")) continue;
            LOGGER.info("Processing app resource {}", (Object)resourceName);
            EngineResource resourceEntity = (EngineResource)resources.get(resourceName);
            byte[] resourceBytes = resourceEntity.getBytes();
            appResourceModel = appEngineConfiguration.getAppResourceConverter().convertAppResourceToModel(resourceBytes);
            if (deployment.isNew()) {
                AppDefinitionEntity latestAppDefinition = this.getMostRecentVersionOfAppDefinition(appResourceModel, deployment.getTenantId());
                int version = 1;
                if (latestAppDefinition != null) {
                    version = latestAppDefinition.getVersion() + 1;
                }
                AppDefinitionEntityManager appDefinitionEntityManager = appEngineConfiguration.getAppDefinitionEntityManager();
                AppDefinitionEntity newAppDefinition = (AppDefinitionEntity)appEngineConfiguration.getAppDefinitionEntityManager().create();
                newAppDefinition.setVersion(version);
                if (appEngineConfiguration.isUsePrefixId()) {
                    newAppDefinition.setId(newAppDefinition.getIdPrefix() + appEngineConfiguration.getIdGenerator().getNextId());
                } else {
                    newAppDefinition.setId(appEngineConfiguration.getIdGenerator().getNextId());
                }
                newAppDefinition.setKey(appResourceModel.getKey());
                newAppDefinition.setName(appResourceModel.getName());
                newAppDefinition.setDescription(appResourceModel.getDescription());
                newAppDefinition.setTenantId(deployment.getTenantId());
                newAppDefinition.setDeploymentId(deployment.getId());
                newAppDefinition.setResourceName(resourceName);
                appDefinitionEntityManager.insert(newAppDefinition, false);
                this.updateCachingAndArtifacts(newAppDefinition, appResourceModel, deploymentEntity);
                break;
            }
            AppDefinitionEntity appDefinitionEntity = this.getPersistedInstanceOfAppDefinition(appResourceModel.getKey(), deployment.getId(), deployment.getTenantId());
            this.updateCachingAndArtifacts(appDefinitionEntity, appResourceModel, deploymentEntity);
            break;
        }
    }

    protected AppDefinitionEntity getMostRecentVersionOfAppDefinition(AppModel appModel, String tenantId) {
        AppDefinitionEntityManager appDefinitionEntityManager = CommandContextUtil.getAppDefinitionEntityManager();
        AppDefinitionEntity existingAppDefinition = null;
        existingAppDefinition = tenantId != null && !tenantId.equals("") ? appDefinitionEntityManager.findLatestAppDefinitionByKeyAndTenantId(appModel.getKey(), tenantId) : appDefinitionEntityManager.findLatestAppDefinitionByKey(appModel.getKey());
        return existingAppDefinition;
    }

    protected AppDefinitionEntity getPersistedInstanceOfAppDefinition(String key, String deploymentId, String tenantId) {
        AppDefinitionEntityManager appDefinitionEntityManager = CommandContextUtil.getAppDefinitionEntityManager();
        AppDefinitionEntity persistedAppDefinitionEntity = null;
        persistedAppDefinitionEntity = tenantId == null || "".equals(tenantId) ? appDefinitionEntityManager.findAppDefinitionByDeploymentAndKey(deploymentId, key) : appDefinitionEntityManager.findAppDefinitionByDeploymentAndKeyAndTenantId(deploymentId, key, tenantId);
        return persistedAppDefinitionEntity;
    }

    protected void updateCachingAndArtifacts(AppDefinitionEntity appDefinition, AppModel appResourceModel, AppDeploymentEntity deployment) {
        AppEngineConfiguration appEngineConfiguration = CommandContextUtil.getAppEngineConfiguration();
        DeploymentCache<AppDefinitionCacheEntry> appDefinitionCache = appEngineConfiguration.getAppDefinitionCache();
        AppDefinitionCacheEntry cacheEntry = new AppDefinitionCacheEntry(appDefinition, appResourceModel);
        appDefinitionCache.add(appDefinition.getId(), (Object)cacheEntry);
        deployment.addDeployedArtifact(appDefinition);
        deployment.addAppDefinitionCacheEntry(appDefinition.getId(), cacheEntry);
    }
}

