/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppDefinition;
import org.flowable.app.rest.AppRestApiInterceptor;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"App Definitions"}, description="Manage App Definitions", authorizations={@Authorization(value="basicAuth")})
public class AppModelResource {
    @Autowired
    protected AppRepositoryService appRepositoryService;
    @Autowired(required=false)
    protected AppRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="Get an App model", tags={"App Definitions"}, nickname="getAppModel")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the app model was found returned."), @ApiResponse(code=404, message="Indicates the app model was not found.")})
    @GetMapping(value={"/app-repository/app-definitions/{appDefinitionId}/model"}, produces={"application/json"})
    public String getModelJsonResource(@ApiParam(name="appDefinitionId") @PathVariable String appDefinitionId) {
        String appModelJson;
        AppDefinition appDefinition = this.appRepositoryService.getAppDefinition(appDefinitionId);
        if (appDefinition == null) {
            throw new FlowableObjectNotFoundException("Could not find an app definition with id '" + appDefinitionId + "'.", AppDefinition.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessAppDefinitionInfoById(appDefinition);
        }
        if ((appModelJson = this.appRepositoryService.convertAppModelToJson(appDefinitionId)) == null) {
            throw new FlowableObjectNotFoundException("Could not find a app model json with id '" + appDefinitionId);
        }
        return appModelJson;
    }
}

