/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.testcontainers;

import org.firebirdsql.testcontainers.FirebirdContainer;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.JdbcDatabaseContainerProvider;
import org.testcontainers.jdbc.ConnectionUrl;
import org.testcontainers.utility.DockerImageName;

public class FirebirdContainerProvider
extends JdbcDatabaseContainerProvider {
    public static final String USER_PARAM = "user";
    public static final String PASSWORD_PARAM = "password";

    public boolean supports(String databaseType) {
        return "firebird".equals(databaseType) || "firebirdsql".equals(databaseType);
    }

    public JdbcDatabaseContainer newInstance() {
        return this.newInstance("v4.0.2");
    }

    public JdbcDatabaseContainer newInstance(String tag) {
        return new FirebirdContainer(DockerImageName.parse((String)"jacobalberty/firebird").withTag(tag));
    }

    public JdbcDatabaseContainer newInstance(ConnectionUrl connectionUrl) {
        return this.newInstanceFromConnectionUrl(connectionUrl, USER_PARAM, PASSWORD_PARAM);
    }
}

