// This file is auto-generated from the ISDA Common Domain Model, do not edit.
//
// Version: 7.0.0-dev.52
//
[assembly: Rosetta.Lib.Attributes.CdmVersion("7.0.0-dev.52")]

#nullable enable // Allow nullable reference types

namespace Org.Isda.Cdm
{
    using System.Collections.Generic;

    using Newtonsoft.Json;
    using Newtonsoft.Json.Converters;

    using NodaTime;

    using Rosetta.Lib;
    using Rosetta.Lib.Attributes;
    using Rosetta.Lib.Meta;
    using Rosetta.Lib.Validation;

    using Org.Isda.Cdm.Meta;
    using Org.Isda.Cdm.MetaFields;
    using _MetaFields = Org.Isda.Cdm.MetaFields.MetaFields;
    
    /// <summary>
    /// A class to specify each party&apos;s election with respect to the Termination Events that will be deemed an Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA).
    /// </summary>
    public class AccessConditions : AbstractRosettaModelObject<AccessConditions>
    {
        private static readonly IRosettaMetaData<AccessConditions> metaData = new AccessConditionsMeta();
        
        [JsonConstructor]
        public AccessConditions(IEnumerable<AccessConditionsElections> partyElection, IEnumerable<AdditionalTerminationEvent> additionalTerminationEvent)
        {
            PartyElection = partyElection;
            AdditionalTerminationEvent = additionalTerminationEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AccessConditions> MetaData => metaData;
        
        /// <summary>
        /// The parties&apos; Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA) election.
        /// </summary>
        public IEnumerable<AccessConditionsElections> PartyElection { get; }
        
        /// <summary>
        /// Additional Termination Events applicable to the agreement.
        /// </summary>
        public IEnumerable<AdditionalTerminationEvent> AdditionalTerminationEvent { get; }
    }
    
    /// <summary>
    /// A class to specify the Termination Events that will be deemed an Access Condition or a Specified Condition.
    /// </summary>
    public class AccessConditionsElections : AbstractRosettaModelObject<AccessConditionsElections>
    {
        private static readonly IRosettaMetaData<AccessConditionsElections> metaData = new AccessConditionsElectionsMeta();
        
        [JsonConstructor]
        public AccessConditionsElections(Enums.CounterpartyRole party, bool illegality, bool forceMajeure, bool taxEvent, bool taxEventUponMerger, bool creditEventUponMerger)
        {
            Party = party;
            Illegality = illegality;
            ForceMajeure = forceMajeure;
            TaxEvent = taxEvent;
            TaxEventUponMerger = taxEventUponMerger;
            CreditEventUponMerger = creditEventUponMerger;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AccessConditionsElections> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// Represents an illegality Termination Event.
        /// </summary>
        public bool Illegality { get; }
        
        /// <summary>
        /// Represents a force Majeure Termination Event.
        /// </summary>
        public bool ForceMajeure { get; }
        
        /// <summary>
        /// Represents a Tax Termination Event.
        /// </summary>
        public bool TaxEvent { get; }
        
        /// <summary>
        /// Represents a Tax Event Upon Merger Termination Event.
        /// </summary>
        public bool TaxEventUponMerger { get; }
        
        /// <summary>
        /// Represents a Credit Event Upon Merger Termination Event.
        /// </summary>
        public bool CreditEventUponMerger { get; }
    }
    
    /// <summary>
    /// A class to specify an account as an account number alongside, optionally. an account name, an account type, an account beneficiary and a servicing party.
    /// </summary>
    public class Account : AbstractRosettaModelObject<Account>
    {
        private static readonly IRosettaMetaData<Account> metaData = new AccountMeta();
        
        [JsonConstructor]
        public Account(ReferenceWithMetaParty? partyReference, FieldWithMetaString accountNumber, FieldWithMetaString? accountName, FieldWithMetaAccountTypeEnum? accountType, ReferenceWithMetaParty? accountBeneficiary, ReferenceWithMetaParty? servicingParty, _MetaFields? meta)
        {
            PartyReference = partyReference;
            AccountNumber = accountNumber;
            AccountName = accountName;
            AccountType = accountType;
            AccountBeneficiary = accountBeneficiary;
            ServicingParty = servicingParty;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Account> MetaData => metaData;
        
        /// <summary>
        /// A reference to the party to which the account refers to.
        /// </summary>
        public ReferenceWithMetaParty? PartyReference { get; }
        
        /// <summary>
        /// The account number.
        /// </summary>
        public FieldWithMetaString AccountNumber { get; }
        
        /// <summary>
        /// The name by which the account is known.
        /// </summary>
        public FieldWithMetaString? AccountName { get; }
        
        /// <summary>
        /// The type of account, e.g. client, house.
        /// </summary>
        public FieldWithMetaAccountTypeEnum? AccountType { get; }
        
        /// <summary>
        /// A reference to the party beneficiary of the account.
        /// </summary>
        public ReferenceWithMetaParty? AccountBeneficiary { get; }
        
        /// <summary>
        /// The reference to the legal entity that services the account, i.e. in the books of which the account is held.
        /// </summary>
        public ReferenceWithMetaParty? ServicingParty { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// The accrual rate and related terms, to adjust the price of an underlier impacted by a Corporate Action when economic impact consists in freezing the underlier price to the last fixing then applying accruals per each remaining underlier price fixing date required i.e. for each fixing date, adjustedPrice = lastFixingPrice x accrualFactor, where: accrualFactor = (1 + accrualRateValue x DCF).
    /// </summary>
    public class AccrualFactor : AbstractRosettaModelObject<AccrualFactor>
    {
        private static readonly IRosettaMetaData<AccrualFactor> metaData = new AccrualFactorMeta();
        
        [JsonConstructor]
        public AccrualFactor(FieldWithMetaPriceSchedule value, AccrualFactorCalculationTerms? calculationTerms)
        {
            Value = value;
            CalculationTerms = calculationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AccrualFactor> MetaData => metaData;
        
        /// <summary>
        /// The rate to be applied to the last fixing price, for price accrual calculation purposes. DatedValue may be used for the purpose of representing Price series if such calculation is required for multiple dates.
        /// </summary>
        public FieldWithMetaPriceSchedule Value { get; }
        
        /// <summary>
        /// Describes the input terms involved in the calculation of the accrual factor.
        /// </summary>
        public AccrualFactorCalculationTerms? CalculationTerms { get; }
    }
    
    /// <summary>
    /// Describes the input terms involved in the calculation of the accrual factor. Optionnally, long and short stub interpolation rates can be specified.
    /// </summary>
    public class AccrualFactorCalculationTerms : AbstractRosettaModelObject<AccrualFactorCalculationTerms>
    {
        private static readonly IRosettaMetaData<AccrualFactorCalculationTerms> metaData = new AccrualFactorCalculationTermsMeta();
        
        [JsonConstructor]
        public AccrualFactorCalculationTerms(decimal tenorTillMaturity, Enums.DayCountFraction dayCountFraction, StubValue? interpolationTerms)
        {
            TenorTillMaturity = tenorTillMaturity;
            DayCountFraction = dayCountFraction;
            InterpolationTerms = interpolationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AccrualFactorCalculationTerms> MetaData => metaData;
        
        /// <summary>
        /// The duration between last fixing date and the payment date of accruals, calculated in accordance with the appropriate DayCountFraction.
        /// </summary>
        public decimal TenorTillMaturity { get; }
        
        /// <summary>
        /// The enumerated values to specify the day count fraction.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayCountFraction DayCountFraction { get; }
        
        /// <summary>
        /// Describes the rate, tenor, period duration for the short and long stubs, when the accrualRate optionnaly results from an interpolation method.
        /// </summary>
        public StubValue? InterpolationTerms { get; }
    }
    
    public class AcctOwnr : AbstractRosettaModelObject<AcctOwnr>
    {
        private static readonly IRosettaMetaData<AcctOwnr> metaData = new AcctOwnrMeta();
        
        [JsonConstructor]
        public AcctOwnr(Id id)
        {
            Id = id;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AcctOwnr> MetaData => metaData;
        
        public Id Id { get; }
    }
    
    /// <summary>
    /// A type for defining the Additional Disruption Events.
    /// </summary>
    public class AdditionalDisruptionEvents : AbstractRosettaModelObject<AdditionalDisruptionEvents>
    {
        private static readonly IRosettaMetaData<AdditionalDisruptionEvents> metaData = new AdditionalDisruptionEventsMeta();
        
        [JsonConstructor]
        public AdditionalDisruptionEvents(bool? changeInLaw, bool? failureToDeliver, bool? insolvencyFiling, bool? hedgingDisruption, bool? increasedCostOfHedging, bool? foreignOwnershipEvent, bool? lossOfStockBorrow, decimal? maximumStockLoanRate, bool? increasedCostOfStockBorrow, decimal? initialStockLoanRate, Enums.AncillaryRole? determiningParty, IEnumerable<Clause> additionalBespokeTerms)
        {
            ChangeInLaw = changeInLaw;
            FailureToDeliver = failureToDeliver;
            InsolvencyFiling = insolvencyFiling;
            HedgingDisruption = hedgingDisruption;
            IncreasedCostOfHedging = increasedCostOfHedging;
            ForeignOwnershipEvent = foreignOwnershipEvent;
            LossOfStockBorrow = lossOfStockBorrow;
            MaximumStockLoanRate = maximumStockLoanRate;
            IncreasedCostOfStockBorrow = increasedCostOfStockBorrow;
            InitialStockLoanRate = initialStockLoanRate;
            DeterminingParty = determiningParty;
            AdditionalBespokeTerms = additionalBespokeTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalDisruptionEvents> MetaData => metaData;
        
        public bool? ChangeInLaw { get; }
        
        public bool? FailureToDeliver { get; }
        
        public bool? InsolvencyFiling { get; }
        
        public bool? HedgingDisruption { get; }
        
        public bool? IncreasedCostOfHedging { get; }
        
        public bool? ForeignOwnershipEvent { get; }
        
        public bool? LossOfStockBorrow { get; }
        
        /// <summary>
        /// Specifies the maximum stock loan rate for Loss of Stock Borrow. A percentage of 5% is represented as 0.05.
        /// </summary>
        public decimal? MaximumStockLoanRate { get; }
        
        public bool? IncreasedCostOfStockBorrow { get; }
        
        /// <summary>
        /// Specifies the initial stock loan per ISDA Def. A percentage of 5% is represented as 0.05.
        /// </summary>
        public decimal? InitialStockLoanRate { get; }
        
        /// <summary>
        /// Specifies the party which determines additional disruption events.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? DeterminingParty { get; }
        
        /// <summary>
        /// Where parties may optionnaly describe any extra bespoke agreements, in regards of the standardized Extraordinary Events.
        /// </summary>
        public IEnumerable<Clause> AdditionalBespokeTerms { get; }
    }
    
    /// <summary>
    /// A class to specify the events that will give rise to the payment additional fixed payments.
    /// </summary>
    public class AdditionalFixedPayments : AbstractRosettaModelObject<AdditionalFixedPayments>
    {
        private static readonly IRosettaMetaData<AdditionalFixedPayments> metaData = new AdditionalFixedPaymentsMeta();
        
        [JsonConstructor]
        public AdditionalFixedPayments(bool? interestShortfallReimbursement, bool? principalShortfallReimbursement, bool? writedownReimbursement)
        {
            InterestShortfallReimbursement = interestShortfallReimbursement;
            PrincipalShortfallReimbursement = principalShortfallReimbursement;
            WritedownReimbursement = writedownReimbursement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalFixedPayments> MetaData => metaData;
        
        /// <summary>
        /// An additional Fixed Payment Event. Corresponds to the payment by or on behalf of the Issuer of an actual interest amount in respect to the reference obligation that is greater than the expected interest amount. ISDA 2003 Term: Interest Shortfall Reimbursement.
        /// </summary>
        public bool? InterestShortfallReimbursement { get; }
        
        /// <summary>
        /// An additional Fixed Payment Event. Corresponds to the payment by or on behalf of the Issuer of an actual principal amount in respect to the reference obligation that is greater than the expected principal amount. ISDA 2003 Term: Principal Shortfall Reimbursement.
        /// </summary>
        public bool? PrincipalShortfallReimbursement { get; }
        
        /// <summary>
        /// An Additional Fixed Payment. Corresponds to the payment by or on behalf of the issuer of an amount in respect to the reference obligation in reduction of the prior writedowns. ISDA 2003 Term: Writedown Reimbursement.
        /// </summary>
        public bool? WritedownReimbursement { get; }
    }
    
    /// <summary>
    /// The election of party specific additional obligations applicable to the agreement.
    /// </summary>
    public class AdditionalObligations : AbstractRosettaModelObject<AdditionalObligations>
    {
        private static readonly IRosettaMetaData<AdditionalObligations> metaData = new AdditionalObligationsMeta();
        
        [JsonConstructor]
        public AdditionalObligations(Enums.CounterpartyRole party, string additionalObligations)
        {
            Party = party;
            AdditionalObligationsValue = additionalObligations;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalObligations> MetaData => metaData;
        
        /// <summary>
        /// The party that the additional obligations apply to.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The party specific additional obligations applicable to the agreement.
        /// </summary>
        [JsonProperty(PropertyName = "additionalObligations")]
        public string AdditionalObligationsValue { get; }
    }
    
    /// <summary>
    /// A class to specify the Additional Representation.
    /// </summary>
    public class AdditionalRepresentation : AbstractRosettaModelObject<AdditionalRepresentation>
    {
        private static readonly IRosettaMetaData<AdditionalRepresentation> metaData = new AdditionalRepresentationMeta();
        
        [JsonConstructor]
        public AdditionalRepresentation(IEnumerable<AdditionalRepresentationElection> partyElection, string? customElection)
        {
            PartyElection = partyElection;
            CustomElection = customElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalRepresentation> MetaData => metaData;
        
        /// <summary>
        /// A qualification as to whether the Additional Representation is applicable.
        /// </summary>
        public IEnumerable<AdditionalRepresentationElection> PartyElection { get; }
        
        /// <summary>
        /// A supplemental custom election that might be specified by the parties for the purpose of specifying the Additional Representation.
        /// </summary>
        public string? CustomElection { get; }
    }
    
    /// <summary>
    /// A class to specify the parties&apos; Additional Representation(s) election.
    /// </summary>
    public class AdditionalRepresentationElection : AbstractRosettaModelObject<AdditionalRepresentationElection>
    {
        private static readonly IRosettaMetaData<AdditionalRepresentationElection> metaData = new AdditionalRepresentationElectionMeta();
        
        [JsonConstructor]
        public AdditionalRepresentationElection(Enums.CounterpartyRole party, bool isApplicable)
        {
            Party = party;
            IsApplicable = isApplicable;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalRepresentationElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The Additional Representation is applicable when True, and not applicable when False.
        /// </summary>
        public bool IsApplicable { get; }
    }
    
    /// <summary>
    /// A class to specify Additional Representations that may be applicable to an agreement.
    /// </summary>
    public class AdditionalRepresentations : AbstractRosettaModelObject<AdditionalRepresentations>
    {
        private static readonly IRosettaMetaData<AdditionalRepresentations> metaData = new AdditionalRepresentationsMeta();
        
        [JsonConstructor]
        public AdditionalRepresentations(AdditionalRepresentation? additionalRepresentation, bool? regulatoryComplianceRepresentation)
        {
            AdditionalRepresentation = additionalRepresentation;
            RegulatoryComplianceRepresentation = regulatoryComplianceRepresentation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalRepresentations> MetaData => metaData;
        
        /// <summary>
        /// The specification of the Additional Representation that may be applicable to the agreement.
        /// </summary>
        public AdditionalRepresentation? AdditionalRepresentation { get; }
        
        /// <summary>
        /// The qualification of whether Additional Information related to Regulatory Compliance and Concentration Limits is applicable or not.
        /// </summary>
        public bool? RegulatoryComplianceRepresentation { get; }
    }
    
    /// <summary>
    /// A class to specify the Pledgor/Obligor/Chargor Additional Rights Event election.
    /// </summary>
    public class AdditionalRightsEvent : AbstractRosettaModelObject<AdditionalRightsEvent>
    {
        private static readonly IRosettaMetaData<AdditionalRightsEvent> metaData = new AdditionalRightsEventMeta();
        
        [JsonConstructor]
        public AdditionalRightsEvent(bool isApplicable, string? qualification)
        {
            IsApplicable = isApplicable;
            Qualification = qualification;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalRightsEvent> MetaData => metaData;
        
        /// <summary>
        /// The Pledgor Additional Rights Event election is applicable when True, and not applicable when False.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The qualification of the Pledgor Additional Rights Event election, when specified.
        /// </summary>
        public string? Qualification { get; }
    }
    
    /// <summary>
    /// A class to specify an optional termination event, additional to the Termination Events that will be deemed an Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA).
    /// </summary>
    public class AdditionalTerminationEvent : AbstractRosettaModelObject<AdditionalTerminationEvent>
    {
        private static readonly IRosettaMetaData<AdditionalTerminationEvent> metaData = new AdditionalTerminationEventMeta();
        
        [JsonConstructor]
        public AdditionalTerminationEvent(string name, IEnumerable<Enums.CounterpartyRole> applicableParty)
        {
            Name = name;
            ApplicableParty = applicableParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalTerminationEvent> MetaData => metaData;
        
        /// <summary>
        /// The name of the additional termination event.
        /// </summary>
        public string Name { get; }
        
        /// <summary>
        /// Whether the additional termination event is applicable for the relevant party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> ApplicableParty { get; }
    }
    
    /// <summary>
    /// The specification of the Additional Type of transaction that can require the collection or delivery of initial margin under a given regulatory regime for the purposes of Covered Transactions.
    /// </summary>
    public class AdditionalType : AbstractRosettaModelObject<AdditionalType>
    {
        private static readonly IRosettaMetaData<AdditionalType> metaData = new AdditionalTypeMeta();
        
        [JsonConstructor]
        public AdditionalType(Enums.AdditionalType standardValue, string? customValue)
        {
            StandardValue = standardValue;
            CustomValue = customValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdditionalType> MetaData => metaData;
        
        /// <summary>
        /// The qualification of the Additional Type of transaction that can require the collection or delivery of initial margin when specified as a standard value.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AdditionalType StandardValue { get; }
        
        /// <summary>
        /// The qualification of the Additional Type of transaction that can require the collection or delivery of initial margin when specified as a custom value by the parties to the legal agreement.
        /// </summary>
        public string? CustomValue { get; }
    }
    
    /// <summary>
    /// A class to specify a post or street address.
    /// </summary>
    public class Address : AbstractRosettaModelObject<Address>
    {
        private static readonly IRosettaMetaData<Address> metaData = new AddressMeta();
        
        [JsonConstructor]
        public Address(IEnumerable<string> street, string? city, string? state, FieldWithMetaString? country, string? postalCode)
        {
            Street = street;
            City = city;
            State = state;
            Country = country;
            PostalCode = postalCode;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Address> MetaData => metaData;
        
        /// <summary>
        /// The set of street and building number information that identifies a postal address within a city.
        /// </summary>
        public IEnumerable<string> Street { get; }
        
        /// <summary>
        /// The city component of the postal address.
        /// </summary>
        public string? City { get; }
        
        /// <summary>
        /// A country subdivision used in postal addresses in some countries. For example, US states, Canadian provinces, Swiss cantons, ...
        /// </summary>
        public string? State { get; }
        
        /// <summary>
        /// The ISO 3166 standard code for the country within which the postal address is located.
        /// </summary>
        public FieldWithMetaString? Country { get; }
        
        /// <summary>
        /// The code, required for computerized mail sorting systems, that is allocated to a physical address by a national postal authority.
        /// </summary>
        public string? PostalCode { get; }
    }
    
    /// <summary>
    /// Specification of the address and other details for notices.
    /// </summary>
    public class AddressForNotices : AbstractRosettaModelObject<AddressForNotices>
    {
        private static readonly IRosettaMetaData<AddressForNotices> metaData = new AddressForNoticesMeta();
        
        [JsonConstructor]
        public AddressForNotices(ContactElection primaryNotices, IEnumerable<PartyContactInformation> additionalNotices)
        {
            PrimaryNotices = primaryNotices;
            AdditionalNotices = additionalNotices;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AddressForNotices> MetaData => metaData;
        
        /// <summary>
        /// Specification of primary notice details
        /// </summary>
        public ContactElection PrimaryNotices { get; }
        
        /// <summary>
        /// The optional specification of additional information when a party requires notices to be delivered to more than one address.
        /// </summary>
        public IEnumerable<PartyContactInformation> AdditionalNotices { get; }
    }
    
    public class AddtlAttrbts : AbstractRosettaModelObject<AddtlAttrbts>
    {
        private static readonly IRosettaMetaData<AddtlAttrbts> metaData = new AddtlAttrbtsMeta();
        
        [JsonConstructor]
        public AddtlAttrbts(string rskRdcgTx, string sctiesFincgTxInd)
        {
            RskRdcgTx = rskRdcgTx;
            SctiesFincgTxInd = sctiesFincgTxInd;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AddtlAttrbts> MetaData => metaData;
        
        public string RskRdcgTx { get; }
        
        public string SctiesFincgTxInd { get; }
    }
    
    /// <summary>
    /// A class for defining a date that shall be subject to adjustment if it would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
    /// </summary>
    public class AdjustableDate : AbstractRosettaModelObject<AdjustableDate>
    {
        private static readonly IRosettaMetaData<AdjustableDate> metaData = new AdjustableDateMeta();
        
        [JsonConstructor]
        public AdjustableDate(LocalDate? unadjustedDate, BusinessDayAdjustments? dateAdjustments, ReferenceWithMetaBusinessDayAdjustments? dateAdjustmentsReference, FieldWithMetaLocalDate? adjustedDate, _MetaFields? meta)
        {
            UnadjustedDate = unadjustedDate;
            DateAdjustments = dateAdjustments;
            DateAdjustmentsReference = dateAdjustmentsReference;
            AdjustedDate = adjustedDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableDate> MetaData => metaData;
        
        /// <summary>
        /// A date subject to adjustment. While in FpML this date is required, this cardinality constraint has been relaxed as part of the CDM in order to support the FRA representation, which effective and termination dates are specified in FpML as adjusted dates.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// A pointer style reference to date adjustments defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaBusinessDayAdjustments? DateAdjustmentsReference { get; }
        
        /// <summary>
        /// The date once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        public FieldWithMetaLocalDate? AdjustedDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class for defining a series of dates that shall be subject to adjustment if they would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the dates.
    /// </summary>
    public class AdjustableDates : AbstractRosettaModelObject<AdjustableDates>
    {
        private static readonly IRosettaMetaData<AdjustableDates> metaData = new AdjustableDatesMeta();
        
        [JsonConstructor]
        public AdjustableDates(IEnumerable<LocalDate> unadjustedDate, BusinessDayAdjustments? dateAdjustments, IEnumerable<FieldWithMetaLocalDate> adjustedDate, _MetaFields? meta)
        {
            UnadjustedDate = unadjustedDate;
            DateAdjustments = dateAdjustments;
            AdjustedDate = adjustedDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableDates> MetaData => metaData;
        
        /// <summary>
        /// A date subject to adjustment.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public IEnumerable<LocalDate> UnadjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// The date(s) once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        public IEnumerable<FieldWithMetaLocalDate> AdjustedDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class for defining a date that shall be subject to adjustment if it would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
    /// </summary>
    public class AdjustableOrAdjustedDate : AbstractRosettaModelObject<AdjustableOrAdjustedDate>
    {
        private static readonly IRosettaMetaData<AdjustableOrAdjustedDate> metaData = new AdjustableOrAdjustedDateMeta();
        
        [JsonConstructor]
        public AdjustableOrAdjustedDate(LocalDate? unadjustedDate, BusinessDayAdjustments? dateAdjustments, FieldWithMetaLocalDate? adjustedDate, _MetaFields? meta)
        {
            UnadjustedDate = unadjustedDate;
            DateAdjustments = dateAdjustments;
            AdjustedDate = adjustedDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableOrAdjustedDate> MetaData => metaData;
        
        /// <summary>
        /// A date subject to adjustment.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// The date once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        public FieldWithMetaLocalDate? AdjustedDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// This Rosetta class specifies the date as either an unadjusted, adjusted or relative date. It supplements the features of the AdjustableOrAdjustedDate to support the credit default swap option premium, which uses the relative date construct.
    /// </summary>
    public class AdjustableOrAdjustedOrRelativeDate : AbstractRosettaModelObject<AdjustableOrAdjustedOrRelativeDate>
    {
        private static readonly IRosettaMetaData<AdjustableOrAdjustedOrRelativeDate> metaData = new AdjustableOrAdjustedOrRelativeDateMeta();
        
        [JsonConstructor]
        public AdjustableOrAdjustedOrRelativeDate(LocalDate? unadjustedDate, BusinessDayAdjustments? dateAdjustments, FieldWithMetaLocalDate? adjustedDate, RelativeDateOffset? relativeDate)
        {
            UnadjustedDate = unadjustedDate;
            DateAdjustments = dateAdjustments;
            AdjustedDate = adjustedDate;
            RelativeDate = relativeDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableOrAdjustedOrRelativeDate> MetaData => metaData;
        
        /// <summary>
        /// A date subject to adjustment.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// The date once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        public FieldWithMetaLocalDate? AdjustedDate { get; }
        
        /// <summary>
        /// A date specified as some offset to another date (the anchor date).
        /// </summary>
        public RelativeDateOffset? RelativeDate { get; }
    }
    
    /// <summary>
    /// A class giving the choice between defining a date as an explicit date together with applicable adjustments or as relative to some other (anchor) date.
    /// </summary>
    public class AdjustableOrRelativeDate : AbstractRosettaModelObject<AdjustableOrRelativeDate>
    {
        private static readonly IRosettaMetaData<AdjustableOrRelativeDate> metaData = new AdjustableOrRelativeDateMeta();
        
        [JsonConstructor]
        public AdjustableOrRelativeDate(AdjustableDate? adjustableDate, AdjustedRelativeDateOffset? relativeDate, _MetaFields? meta)
        {
            AdjustableDate = adjustableDate;
            RelativeDate = relativeDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableOrRelativeDate> MetaData => metaData;
        
        /// <summary>
        /// A date that shall be subject to adjustment if it would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
        /// </summary>
        public AdjustableDate? AdjustableDate { get; }
        
        /// <summary>
        /// A date specified as some offset to another date (the anchor date).
        /// </summary>
        public AdjustedRelativeDateOffset? RelativeDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class giving the choice between defining a series of dates as an explicit list of dates together with applicable adjustments or as relative to some other series of (anchor) dates.
    /// </summary>
    public class AdjustableOrRelativeDates : AbstractRosettaModelObject<AdjustableOrRelativeDates>
    {
        private static readonly IRosettaMetaData<AdjustableOrRelativeDates> metaData = new AdjustableOrRelativeDatesMeta();
        
        [JsonConstructor]
        public AdjustableOrRelativeDates(AdjustableDates? adjustableDates, RelativeDates? relativeDates, _MetaFields? meta)
        {
            AdjustableDates = adjustableDates;
            RelativeDates = relativeDates;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableOrRelativeDates> MetaData => metaData;
        
        /// <summary>
        /// A series of dates that shall be subject to adjustment if they would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
        /// </summary>
        public AdjustableDates? AdjustableDates { get; }
        
        /// <summary>
        /// A series of dates specified as some offset to another series of dates (the anchor dates).
        /// </summary>
        public RelativeDates? RelativeDates { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class giving the choice between defining a series of dates as an explicit list of dates together with applicable adjustments or as relative to some other series of (anchor) dates, or as a calculation period schedule.
    /// </summary>
    public class AdjustableRelativeOrPeriodicDates : AbstractRosettaModelObject<AdjustableRelativeOrPeriodicDates>
    {
        private static readonly IRosettaMetaData<AdjustableRelativeOrPeriodicDates> metaData = new AdjustableRelativeOrPeriodicDatesMeta();
        
        [JsonConstructor]
        public AdjustableRelativeOrPeriodicDates(AdjustableDates? adjustableDates, RelativeDates? relativeDates, PeriodicDates? periodicDates, _MetaFields? meta)
        {
            AdjustableDates = adjustableDates;
            RelativeDates = relativeDates;
            PeriodicDates = periodicDates;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustableRelativeOrPeriodicDates> MetaData => metaData;
        
        /// <summary>
        /// A series of dates that shall be subject to adjustment if they would otherwise fall on a day that is not a business day in the specified business centers, together with the convention for adjusting the date.
        /// </summary>
        public AdjustableDates? AdjustableDates { get; }
        
        /// <summary>
        /// A series of dates specified as some offset to another series of dates (the anchor dates).
        /// </summary>
        public RelativeDates? RelativeDates { get; }
        
        /// <summary>
        /// A calculation period schedule.
        /// </summary>
        public PeriodicDates? PeriodicDates { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A type defining a date (referred to as the derived date) as a relative offset from another date (referred to as the anchor date) plus optional date adjustments.
    /// </summary>
    public class AdjustedRelativeDateOffset : AbstractRosettaModelObject<AdjustedRelativeDateOffset>, IRelativeDateOffset
    {
        private static readonly IRosettaMetaData<AdjustedRelativeDateOffset> metaData = new AdjustedRelativeDateOffsetMeta();
        
        [JsonConstructor]
        public AdjustedRelativeDateOffset(int periodMultiplier, Enums.Period period, _MetaFields? meta, Enums.DayType? dayType, Enums.BusinessDayConvention businessDayConvention, BusinessCenters? businessCenters, ReferenceWithMetaBusinessCenters? businessCentersReference, BasicReferenceWithMetaLocalDate? dateRelativeTo, LocalDate? adjustedDate, BusinessDayAdjustments? relativeDateAdjustments)
        {
            PeriodMultiplier = periodMultiplier;
            PeriodValue = period;
            Meta = meta;
            DayType = dayType;
            BusinessDayConvention = businessDayConvention;
            BusinessCenters = businessCenters;
            BusinessCentersReference = businessCentersReference;
            DateRelativeTo = dateRelativeTo;
            AdjustedDate = adjustedDate;
            RelativeDateAdjustments = relativeDateAdjustments;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustedRelativeDateOffset> MetaData => metaData;
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        public BusinessCenters? BusinessCenters { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaBusinessCenters? BusinessCentersReference { get; }
        
        /// <inheritdoc/>
        public BasicReferenceWithMetaLocalDate? DateRelativeTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the relative date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? RelativeDateAdjustments { get; }
    }
    
    /// <summary>
    /// Describes the terms involved for adjusting the price of the underlier impacted by a Corporate Action.
    /// </summary>
    public class AdjustmentFactor : AbstractRosettaModelObject<AdjustmentFactor>
    {
        private static readonly IRosettaMetaData<AdjustmentFactor> metaData = new AdjustmentFactorMeta();
        
        [JsonConstructor]
        public AdjustmentFactor(decimal value, AdjustmentFactorCalculationTerms? calculationTerms)
        {
            Value = value;
            CalculationTerms = calculationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustmentFactor> MetaData => metaData;
        
        /// <summary>
        /// The multipler value applied to the price of the underlier impacted by a Corporate Action.
        /// </summary>
        public decimal Value { get; }
        
        /// <summary>
        /// Describes the input terms involved in the calculation of the adjustment factor applied to the price of the underlier impacted by a Corporate Action.
        /// </summary>
        public AdjustmentFactorCalculationTerms? CalculationTerms { get; }
    }
    
    /// <summary>
    /// Describes the input terms involved in the calculation of the adjustment factor applied to the price of the underlier impacted by a Corporate Action.
    /// </summary>
    public class AdjustmentFactorCalculationTerms : AbstractRosettaModelObject<AdjustmentFactorCalculationTerms>
    {
        private static readonly IRosettaMetaData<AdjustmentFactorCalculationTerms> metaData = new AdjustmentFactorCalculationTermsMeta();
        
        [JsonConstructor]
        public AdjustmentFactorCalculationTerms(decimal? shareForShareRatio, decimal? shareForRightsRatio, Price? rightsSubscriptionPrice, decimal? dividendRatio, SpinOff? spinOff, Merger? merger, AccrualFactor? accrualFactor, Price? lastFixingPriceBeforeAdjustment, PriceSchedule? dividendObservation, string? bespokeCalculationFormula)
        {
            ShareForShareRatio = shareForShareRatio;
            ShareForRightsRatio = shareForRightsRatio;
            RightsSubscriptionPrice = rightsSubscriptionPrice;
            DividendRatio = dividendRatio;
            SpinOff = spinOff;
            Merger = merger;
            AccrualFactor = accrualFactor;
            LastFixingPriceBeforeAdjustment = lastFixingPriceBeforeAdjustment;
            DividendObservation = dividendObservation;
            BespokeCalculationFormula = bespokeCalculationFormula;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AdjustmentFactorCalculationTerms> MetaData => metaData;
        
        /// <summary>
        /// Multiple value, say &apos;M/N&apos; where &apos;M&apos; is the number of shares after the event and &apos;N&apos; is the number of shares prior to the event. 
        /// </summary>
        public decimal? ShareForShareRatio { get; }
        
        /// <summary>
        /// Multiple value, say &apos;M/N&apos; where &apos;M&apos; is the number of rights after the event, and &apos;N&apos; of shares prior to the event. 
        /// </summary>
        public decimal? ShareForRightsRatio { get; }
        
        /// <summary>
        /// The price to pay per each right.
        /// </summary>
        public Price? RightsSubscriptionPrice { get; }
        
        /// <summary>
        /// Multipler value (e.g. 85 %, etc.) to calculate net dividend amount, given gross amount before taking into account the relevant fiscal features.
        /// </summary>
        public decimal? DividendRatio { get; }
        
        /// <summary>
        /// Defines the underlier for both the Parent Company and the Child Compagny involved in Spin Off corporate action, as well as the respective price observation for each.
        /// </summary>
        public SpinOff? SpinOff { get; }
        
        /// <summary>
        /// Defines the underlier for both the Purchaser Company and the Acquired Compagny involved in Spin Off corporate action, as well as the respective price observation for each.
        /// </summary>
        public Merger? Merger { get; }
        
        /// <summary>
        /// The accrual rate and related terms, to adjust the price of an underlier impacted by a Corporate Action when economic impact consists in freezing the underlier price to last fixing and applying accruals for each remaining underlier price fixing date required i.e. for each, adjustedPrice = lastFixingPrice x (1 + accrualRate x DCF).
        /// </summary>
        public AccrualFactor? AccrualFactor { get; }
        
        /// <summary>
        /// The last fixing price of the Underlier affected by the CorporateAction, before any adjustment with regards to the CorporateAction.
        /// </summary>
        public Price? LastFixingPriceBeforeAdjustment { get; }
        
        /// <summary>
        /// To record observations of dividends.
        /// </summary>
        public PriceSchedule? DividendObservation { get; }
        
        /// <summary>
        /// To describe the formula used to calculate the Adjustment Factor.
        /// </summary>
        public string? BespokeCalculationFormula { get; }
    }
    
    /// <summary>
    /// Represents a class to specify a credit notation.
    /// </summary>
    public class AgencyRatingCriteria : AbstractRosettaModelObject<AgencyRatingCriteria>
    {
        private static readonly IRosettaMetaData<AgencyRatingCriteria> metaData = new AgencyRatingCriteriaMeta();
        
        [JsonConstructor]
        public AgencyRatingCriteria(CreditNotation creditNotation, Enums.CreditNotationMismatchResolution? mismatchResolution, Enums.CreditRatingAgency? referenceAgency, Enums.CreditNotationBoundary? boundary)
        {
            CreditNotation = creditNotation;
            MismatchResolution = mismatchResolution;
            ReferenceAgency = referenceAgency;
            Boundary = boundary;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AgencyRatingCriteria> MetaData => metaData;
        
        /// <summary>
        /// Indicates the agency rating criteria specified for the asset or issuer.
        /// </summary>
        public CreditNotation CreditNotation { get; }
        
        /// <summary>
        /// Indicator for options to be used if several agency ratings (&gt;1) are specified and its necessary to identify specific charateristics. i.e (lowest or highest).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditNotationMismatchResolution? MismatchResolution { get; }
        
        /// <summary>
        /// identifies the dominant reference agency if there is a missmatch and several reference agencies exsist.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency? ReferenceAgency { get; }
        
        /// <summary>
        /// Indicates the boundary of a credit agency rating i.e minimum or maximum.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditNotationBoundary? Boundary { get; }
    }
    
    /// <summary>
    ///  Parameters to be used to filter events that are relevant to a given portfolio in order to calculate the state of this portfolio. The attributes correspond to all the possible aggregation criteria that can be used and these criteria can be combined. All the attributes are optional.
    /// </summary>
    public class AggregationParameters : AbstractRosettaModelObject<AggregationParameters>
    {
        private static readonly IRosettaMetaData<AggregationParameters> metaData = new AggregationParametersMeta();
        
        [JsonConstructor]
        public AggregationParameters(ZonedDateTime dateTime, bool? totalPosition, Enums.PositionStatus? positionStatus, IEnumerable<ReferenceWithMetaParty> party, IEnumerable<NonTransferableProduct> product, IEnumerable<string> productQualifier, IEnumerable<ReferenceWithMetaTrade> tradeReference)
        {
            DateTime = dateTime;
            TotalPosition = totalPosition;
            PositionStatus = positionStatus;
            Party = party;
            Product = product;
            ProductQualifier = productQualifier;
            TradeReference = tradeReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AggregationParameters> MetaData => metaData;
        
        /// <summary>
        /// To aggregate as of a particular date
        /// </summary>
        public ZonedDateTime DateTime { get; }
        
        /// <summary>
        /// Specifies whether to calculate total position to given date, or only daily position for the given date.
        /// </summary>
        public bool? TotalPosition { get; }
        
        /// <summary>
        /// To aggregate based on position status (EXECUTED, SETTLED etc)
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PositionStatus? PositionStatus { get; }
        
        /// <summary>
        /// To aggregate based on a selection of party(ies) / legal entity(ies).
        /// </summary>
        public IEnumerable<ReferenceWithMetaParty> Party { get; }
        
        /// <summary>
        /// To aggregate based on a selection of products.
        /// </summary>
        public IEnumerable<NonTransferableProduct> Product { get; }
        
        /// <summary>
        /// To aggregate based on a selection of product type(s).
        /// </summary>
        public IEnumerable<string> ProductQualifier { get; }
        
        public IEnumerable<ReferenceWithMetaTrade> TradeReference { get; }
    }
    
    /// <summary>
    /// Specification of the standard set of terms that define a legal agreement.
    /// </summary>
    public class Agreement : AbstractRosettaModelObject<Agreement>
    {
        private static readonly IRosettaMetaData<Agreement> metaData = new AgreementMeta();
        
        [JsonConstructor]
        public Agreement(CreditSupportAgreementElections? creditSupportAgreementElections, CollateralTransferAgreementElections? collateralTransferAgreementElections, SecurityAgreementElections? securityAgreementElections, MasterAgreementSchedule? masterAgreementSchedule, TransactionAdditionalTerms? transactionAdditionalTerms, MasterAgreementElections? masterAgreementElections)
        {
            CreditSupportAgreementElections = creditSupportAgreementElections;
            CollateralTransferAgreementElections = collateralTransferAgreementElections;
            SecurityAgreementElections = securityAgreementElections;
            MasterAgreementSchedule = masterAgreementSchedule;
            TransactionAdditionalTerms = transactionAdditionalTerms;
            MasterAgreementElections = masterAgreementElections;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Agreement> MetaData => metaData;
        
        /// <summary>
        /// Elections to specify a Credit Support Annex or Credit Support Deed for Intial or Variation Margin.
        /// </summary>
        public CreditSupportAgreementElections? CreditSupportAgreementElections { get; }
        
        /// <summary>
        /// Elections to specify a Collateral Transfer Agreement.
        /// </summary>
        public CollateralTransferAgreementElections? CollateralTransferAgreementElections { get; }
        
        /// <summary>
        /// Elections to specify a Security agreement.
        /// </summary>
        public SecurityAgreementElections? SecurityAgreementElections { get; }
        
        /// <summary>
        /// Elections to specify a Master Agreement Schedule.
        /// </summary>
        public MasterAgreementSchedule? MasterAgreementSchedule { get; }
        
        /// <summary>
        /// Any additional terms which mainly intend to specify the extraordinary events that may affect a trade and the related contractual rights and obligation of the parties when this happens
        /// </summary>
        public TransactionAdditionalTerms? TransactionAdditionalTerms { get; }
        
        /// <summary>
        /// A legal representation of the different possible master agreements
        /// </summary>
        public MasterAgreementElections? MasterAgreementElections { get; }
    }
    
    /// <summary>
    /// Specifies the agreement name through an agreement type and optional detailed sub agreement type.
    /// </summary>
    public class AgreementName : AbstractRosettaModelObject<AgreementName>
    {
        private static readonly IRosettaMetaData<AgreementName> metaData = new AgreementNameMeta();
        
        [JsonConstructor]
        public AgreementName(Enums.LegalAgreementType agreementType, FieldWithMetaCreditSupportAgreementTypeEnum? creditSupportAgreementType, Enums.CollateralMarginType? creditSupportAgreementMarginType, IEnumerable<FieldWithMetaContractualDefinitionsEnum> contractualDefinitionsType, IEnumerable<ContractualTermsSupplement> contractualTermsSupplement, IEnumerable<ContractualMatrix> contractualMatrix, FieldWithMetaMasterAgreementTypeEnum? masterAgreementType, FieldWithMetaMasterConfirmationTypeEnum? masterConfirmationType, FieldWithMetaMasterConfirmationAnnexTypeEnum? masterConfirmationAnnexType, string? otherAgreement, Enums.BrokerConfirmationType? brokerConfirmationType)
        {
            AgreementType = agreementType;
            CreditSupportAgreementType = creditSupportAgreementType;
            CreditSupportAgreementMarginType = creditSupportAgreementMarginType;
            ContractualDefinitionsType = contractualDefinitionsType;
            ContractualTermsSupplement = contractualTermsSupplement;
            ContractualMatrix = contractualMatrix;
            MasterAgreementType = masterAgreementType;
            MasterConfirmationType = masterConfirmationType;
            MasterConfirmationAnnexType = masterConfirmationAnnexType;
            OtherAgreement = otherAgreement;
            BrokerConfirmationType = brokerConfirmationType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AgreementName> MetaData => metaData;
        
        /// <summary>
        /// Specification of the legal agreement type.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.LegalAgreementType AgreementType { get; }
        
        /// <summary>
        /// Specification of the credit support agreement type.
        /// </summary>
        public FieldWithMetaCreditSupportAgreementTypeEnum? CreditSupportAgreementType { get; }
        
        /// <summary>
        /// specifies the type of margin for which a legal agreement is named.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralMarginType? CreditSupportAgreementMarginType { get; }
        
        /// <summary>
        /// The definitions such as those published by ISDA that will define the terms of the trade.
        /// </summary>
        public IEnumerable<FieldWithMetaContractualDefinitionsEnum> ContractualDefinitionsType { get; }
        
        /// <summary>
        /// A contractual supplement (such as those published by ISDA) that will apply to the trade.
        /// </summary>
        public IEnumerable<ContractualTermsSupplement> ContractualTermsSupplement { get; }
        
        /// <summary>
        /// A reference to a contractual matrix of elected terms/values (such as those published by ISDA) that shall be deemed to apply to the trade. The applicable matrix is identified by reference to a name and optionally a publication date. Depending on the structure of the matrix, an additional term (specified in the matrixTerm element) may be required to further identify a subset of applicable terms/values within the matrix.
        /// </summary>
        public IEnumerable<ContractualMatrix> ContractualMatrix { get; }
        
        /// <summary>
        /// Specification of the master agreement type.
        /// </summary>
        public FieldWithMetaMasterAgreementTypeEnum? MasterAgreementType { get; }
        
        /// <summary>
        /// The type of master confirmation executed between the parties.
        /// </summary>
        public FieldWithMetaMasterConfirmationTypeEnum? MasterConfirmationType { get; }
        
        /// <summary>
        /// The type of master confirmation annex executed between the parties.
        /// </summary>
        public FieldWithMetaMasterConfirmationAnnexTypeEnum? MasterConfirmationAnnexType { get; }
        
        /// <summary>
        /// Definition of an agreement that is not enumerated in the CDM.
        /// </summary>
        public string? OtherAgreement { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BrokerConfirmationType? BrokerConfirmationType { get; }
    }
    
    /// <summary>
    /// Specification of the content of a legal agreement.
    /// </summary>
    public class AgreementTerms : AbstractRosettaModelObject<AgreementTerms>
    {
        private static readonly IRosettaMetaData<AgreementTerms> metaData = new AgreementTermsMeta();
        
        [JsonConstructor]
        public AgreementTerms(Agreement agreement, bool? clauseLibrary, IEnumerable<Counterparty> counterparty)
        {
            Agreement = agreement;
            ClauseLibrary = clauseLibrary;
            Counterparty = counterparty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AgreementTerms> MetaData => metaData;
        
        /// <summary>
        /// Specification of the standard set of terms that define a legal agreement.
        /// </summary>
        public Agreement Agreement { get; }
        
        /// <summary>
        /// Specification of whether the agreement terms have been negotiated using the clause library methodology.
        /// </summary>
        public bool? ClauseLibrary { get; }
        
        /// <summary>
        /// Specification of the roles of the counterparties to the agreement.
        /// </summary>
        public IEnumerable<Counterparty> Counterparty { get; }
    }
    
    /// <summary>
    /// Used to combine two or more Collateral Criteria using AND logic.
    /// </summary>
    public class AllCriteria : AbstractRosettaModelObject<AllCriteria>
    {
        private static readonly IRosettaMetaData<AllCriteria> metaData = new AllCriteriaMeta();
        
        [JsonConstructor]
        public AllCriteria(IEnumerable<CollateralCriteria> allCriteria)
        {
            AllCriteriaValue = allCriteria;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AllCriteria> MetaData => metaData;
        
        [JsonProperty(PropertyName = "allCriteria")]
        public IEnumerable<CollateralCriteria> AllCriteriaValue { get; }
    }
    
    /// <summary>
    /// Used to combine two or more Ratings and associated direction using AND logic.
    /// </summary>
    public class AllDirectionRating : AbstractRosettaModelObject<AllDirectionRating>
    {
        private static readonly IRosettaMetaData<AllDirectionRating> metaData = new AllDirectionRatingMeta();
        
        [JsonConstructor]
        public AllDirectionRating(IEnumerable<DirectionRatingSet> allDirectionRating)
        {
            AllDirectionRatingValue = allDirectionRating;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AllDirectionRating> MetaData => metaData;
        
        [JsonProperty(PropertyName = "allDirectionRating")]
        public IEnumerable<DirectionRatingSet> AllDirectionRatingValue { get; }
    }
    
    /// <summary>
    /// Used to combine two or more Criteria using AND logic.
    /// </summary>
    public class AllEligibilityToHoldCollateralCriteria : AbstractRosettaModelObject<AllEligibilityToHoldCollateralCriteria>
    {
        private static readonly IRosettaMetaData<AllEligibilityToHoldCollateralCriteria> metaData = new AllEligibilityToHoldCollateralCriteriaMeta();
        
        [JsonConstructor]
        public AllEligibilityToHoldCollateralCriteria(IEnumerable<EligibilityToHoldCollateralCriteria> allCriteria)
        {
            AllCriteria = allCriteria;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AllEligibilityToHoldCollateralCriteria> MetaData => metaData;
        
        public IEnumerable<EligibilityToHoldCollateralCriteria> AllCriteria { get; }
    }
    
    /// <summary>
    /// A class to specify the effective date of the Amendment to Termination Currency. This date can be specified as either an actual date, a specific date (e.g. the annex date) or as a custom provision.
    /// </summary>
    public class AmendmentEffectiveDate : AbstractRosettaModelObject<AmendmentEffectiveDate>
    {
        private static readonly IRosettaMetaData<AmendmentEffectiveDate> metaData = new AmendmentEffectiveDateMeta();
        
        [JsonConstructor]
        public AmendmentEffectiveDate(LocalDate? date, Enums.AmendmentEffectiveDate? specificDate, string? customProvision)
        {
            Date = date;
            SpecificDate = specificDate;
            CustomProvision = customProvision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AmendmentEffectiveDate> MetaData => metaData;
        
        /// <summary>
        /// The effective date of the Amendment to Termination Currency when specified as an actual date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? Date { get; }
        
        /// <summary>
        /// The effective date of the Amendment to Termination Currency when specified as relative to another date (e.g. the annex date).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AmendmentEffectiveDate? SpecificDate { get; }
        
        /// <summary>
        /// The effective date of the Amendment to Termination Currency when specified as a non normalized custom provision.
        /// </summary>
        public string? CustomProvision { get; }
    }
    
    /// <summary>
    /// The amount of net capital.
    /// </summary>
    public class AmountOfNetCapital : AbstractRosettaModelObject<AmountOfNetCapital>
    {
        private static readonly IRosettaMetaData<AmountOfNetCapital> metaData = new AmountOfNetCapitalMeta();
        
        [JsonConstructor]
        public AmountOfNetCapital(Money? amountOfNetCapital)
        {
            AmountOfNetCapitalValue = amountOfNetCapital;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AmountOfNetCapital> MetaData => metaData;
        
        /// <summary>
        /// The amount of net capital.
        /// </summary>
        [JsonProperty(PropertyName = "amountOfNetCapital")]
        public Money? AmountOfNetCapitalValue { get; }
    }
    
    /// <summary>
    /// A class to specify a currency amount or a currency amount schedule.
    /// </summary>
    public class AmountSchedule : AbstractRosettaModelObject<AmountSchedule>, ISchedule
    {
        private static readonly IRosettaMetaData<AmountSchedule> metaData = new AmountScheduleMeta();
        
        [JsonConstructor]
        public AmountSchedule(decimal value, IEnumerable<DatedValue> datedValue, IEnumerable<FieldWithMetaString> currency)
        {
            Value = value;
            DatedValue = datedValue;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AmountSchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal Value { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <summary>
        /// The currency in which the amount schedule is denominated. The currency is specified outside of the actual schedule in order to be applied uniformly to it. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public IEnumerable<FieldWithMetaString> Currency { get; }
    }
    
    /// <summary>
    /// Holds an identifier for an ancillary entity, either identified directly via its ancillary role or directly as a legal entity.
    /// </summary>
    public class AncillaryEntity : AbstractRosettaModelObject<AncillaryEntity>
    {
        private static readonly IRosettaMetaData<AncillaryEntity> metaData = new AncillaryEntityMeta();
        
        [JsonConstructor]
        public AncillaryEntity(Enums.AncillaryRole? ancillaryParty, LegalEntity? legalEntity)
        {
            AncillaryParty = ancillaryParty;
            LegalEntity = legalEntity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AncillaryEntity> MetaData => metaData;
        
        /// <summary>
        /// Identifies a party via its ancillary role on a transaction (e.g. CCP or DCO through which the trade should be cleared.)
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? AncillaryParty { get; }
        
        public LegalEntity? LegalEntity { get; }
    }
    
    /// <summary>
    /// Defines an ancillary role enumerated value with an associated party reference. The product is agnostic to the actual parties involved in the transaction, with the party references abstracted away from the product definition and replaced by the AncillaryRoleEnum. The AncillaryRoleEnum can then be positioned in the product and this AncillaryParty type, which is positioned outside of the product definition, allows the AncillaryRoleEnum to be associated with an actual party reference.
    /// </summary>
    public class AncillaryParty : AbstractRosettaModelObject<AncillaryParty>
    {
        private static readonly IRosettaMetaData<AncillaryParty> metaData = new AncillaryPartyMeta();
        
        [JsonConstructor]
        public AncillaryParty(Enums.AncillaryRole role, IEnumerable<ReferenceWithMetaParty> partyReference, Enums.CounterpartyRole? onBehalfOf)
        {
            Role = role;
            PartyReference = partyReference;
            OnBehalfOf = onBehalfOf;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AncillaryParty> MetaData => metaData;
        
        /// <summary>
        /// Specifies the AncillaryRoleEnum that is associated to the party reference. An ancillary party is any involved party that is not one of the two principal parties to the transaction.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole Role { get; }
        
        /// <summary>
        /// Specifies the party, or parties, associated to the ancillary role.
        /// </summary>
        public IEnumerable<ReferenceWithMetaParty> PartyReference { get; }
        
        /// <summary>
        /// Optionally specifies the counterparty that the ancillary party is acting on behalf of.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole? OnBehalfOf { get; }
    }
    
    /// <summary>
    /// Used to combine two or more Collateral Criteria using OR logic.
    /// </summary>
    public class AnyCriteria : AbstractRosettaModelObject<AnyCriteria>
    {
        private static readonly IRosettaMetaData<AnyCriteria> metaData = new AnyCriteriaMeta();
        
        [JsonConstructor]
        public AnyCriteria(IEnumerable<CollateralCriteria> anyCriteria)
        {
            AnyCriteriaValue = anyCriteria;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AnyCriteria> MetaData => metaData;
        
        [JsonProperty(PropertyName = "anyCriteria")]
        public IEnumerable<CollateralCriteria> AnyCriteriaValue { get; }
    }
    
    /// <summary>
    /// Used to combine two or more Ratings and associated direction using OR logic.
    /// </summary>
    public class AnyDirectionRating : AbstractRosettaModelObject<AnyDirectionRating>
    {
        private static readonly IRosettaMetaData<AnyDirectionRating> metaData = new AnyDirectionRatingMeta();
        
        [JsonConstructor]
        public AnyDirectionRating(IEnumerable<DirectionRatingSet> anyDirectionRating)
        {
            AnyDirectionRatingValue = anyDirectionRating;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AnyDirectionRating> MetaData => metaData;
        
        [JsonProperty(PropertyName = "anyDirectionRating")]
        public IEnumerable<DirectionRatingSet> AnyDirectionRatingValue { get; }
    }
    
    /// <summary>
    /// Used to combine two or more Criteria using OR logic.
    /// </summary>
    public class AnyEligibilityToHoldCollateralCriteria : AbstractRosettaModelObject<AnyEligibilityToHoldCollateralCriteria>
    {
        private static readonly IRosettaMetaData<AnyEligibilityToHoldCollateralCriteria> metaData = new AnyEligibilityToHoldCollateralCriteriaMeta();
        
        [JsonConstructor]
        public AnyEligibilityToHoldCollateralCriteria(IEnumerable<EligibilityToHoldCollateralCriteria> anyCriteria)
        {
            AnyCriteria = anyCriteria;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AnyEligibilityToHoldCollateralCriteria> MetaData => metaData;
        
        public IEnumerable<EligibilityToHoldCollateralCriteria> AnyCriteria { get; }
    }
    
    /// <summary>
    /// A class to specify the applicable regulatory regime(s) that parties to a legal agreement, such as the ISDA 2016 and 2018 CSA for Initial Margin, might be subject to.
    /// </summary>
    public class ApplicableRegime : AbstractRosettaModelObject<ApplicableRegime>
    {
        private static readonly IRosettaMetaData<ApplicableRegime> metaData = new ApplicableRegimeMeta();
        
        [JsonConstructor]
        public ApplicableRegime(Enums.RegulatoryRegime? regime, string? additionalRegime, IEnumerable<RegimeTerms> regimeTerms, Enums.AdditionalType? additionalType, string? additionalTerms)
        {
            Regime = regime;
            AdditionalRegime = additionalRegime;
            RegimeTerms = regimeTerms;
            AdditionalType = additionalType;
            AdditionalTerms = additionalTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ApplicableRegime> MetaData => metaData;
        
        /// <summary>
        /// The applicable regulatory regime, as specified through an enumeration.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegulatoryRegime? Regime { get; }
        
        /// <summary>
        /// The additional regulatory regime as specified by the parties.
        /// </summary>
        public string? AdditionalRegime { get; }
        
        /// <summary>
        /// A class that is used by the ApplicableRegime and the AdditionalRegime classes to specify the terms that are specific to each party and regime which are referred to in the Regime Table as part of certain legal agreements, such as the ISDA 2016 and 2018 CSA for Initial Margin.
        /// </summary>
        public IEnumerable<RegimeTerms> RegimeTerms { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AdditionalType? AdditionalType { get; }
        
        /// <summary>
        /// The bespoke Additional Type for the purposes of Covered Transactions (IM).
        /// </summary>
        public string? AdditionalTerms { get; }
    }
    
    /// <summary>
    /// A class to specify the Valuation of Appropriated Collateral.
    /// </summary>
    public class AppropriatedCollateralValuation : AbstractRosettaModelObject<AppropriatedCollateralValuation>
    {
        private static readonly IRosettaMetaData<AppropriatedCollateralValuation> metaData = new AppropriatedCollateralValuationMeta();
        
        [JsonConstructor]
        public AppropriatedCollateralValuation(bool isSpecified, string? election)
        {
            IsSpecified = isSpecified;
            Election = election;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AppropriatedCollateralValuation> MetaData => metaData;
        
        /// <summary>
        /// The qualification of whether the Valuation of Appropriate Collateral provision is applicable (True) or not applicable (False).
        /// </summary>
        public bool IsSpecified { get; }
        
        /// <summary>
        /// The parties&apos; election that qualify the Valuation of Appropriate Collateral in the case where it is deemed applicable.
        /// </summary>
        public string? Election { get; }
    }
    
    /// <summary>
    /// An Asset is defined as something that can be owned and transferred in the financial markets. As a choice data type, one and only one of the attributes must be used.
    /// </summary>
    public class Asset : AbstractRosettaModelObject<Asset>, IAsset
    {
        private static readonly IRosettaMetaData<Asset> metaData = new AssetMeta();
        
        [JsonConstructor]
        public Asset(Cash? cash, Commodity? commodity, DigitalAsset? digitalAsset, Instrument? instrument)
        {
            Cash = cash;
            Commodity = commodity;
            DigitalAsset = digitalAsset;
            Instrument = instrument;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Asset> MetaData => metaData;
        
        /// <inheritdoc/>
        public Cash? Cash { get; }
        
        /// <inheritdoc/>
        public Commodity? Commodity { get; }
        
        /// <inheritdoc/>
        public DigitalAsset? DigitalAsset { get; }
        
        /// <inheritdoc/>
        public Instrument? Instrument { get; }
    }
    
    public class AssetAgencyRating : AbstractRosettaModelObject<AssetAgencyRating>
    {
        private static readonly IRosettaMetaData<AssetAgencyRating> metaData = new AssetAgencyRatingMeta();
        
        [JsonConstructor]
        public AssetAgencyRating(AgencyRatingCriteria assetAgencyRating)
        {
            AssetAgencyRatingValue = assetAgencyRating;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetAgencyRating> MetaData => metaData;
        
        /// <summary>
        /// Represents an agency rating based on default risk and creditors claim in event of default associated with specific instrument.
        /// </summary>
        [JsonProperty(PropertyName = "assetAgencyRating")]
        public AgencyRatingCriteria AssetAgencyRatingValue { get; }
    }
    
    /// <summary>
    /// The base data type to specify common attributes for all Assets.
    /// </summary>
    public class AssetBase : AbstractRosettaModelObject<AssetBase>, IAssetBase
    {
        private static readonly IRosettaMetaData<AssetBase> metaData = new AssetBaseMeta();
        
        [JsonConstructor]
        public AssetBase(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
    }
    
    public class AssetCountryOfOrigin : AbstractRosettaModelObject<AssetCountryOfOrigin>
    {
        private static readonly IRosettaMetaData<AssetCountryOfOrigin> metaData = new AssetCountryOfOriginMeta();
        
        [JsonConstructor]
        public AssetCountryOfOrigin(Enums.ISOCountryCode assetCountryOfOrigin)
        {
            AssetCountryOfOriginValue = assetCountryOfOrigin;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetCountryOfOrigin> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter on the asset country of origin based on the ISO Standard 3166.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "assetCountryOfOrigin")]
        public Enums.ISOCountryCode AssetCountryOfOriginValue { get; }
    }
    
    /// <summary>
    /// Contains the information relative to the delivery of the asset.
    /// </summary>
    public class AssetDeliveryInformation : AbstractRosettaModelObject<AssetDeliveryInformation>
    {
        private static readonly IRosettaMetaData<AssetDeliveryInformation> metaData = new AssetDeliveryInformationMeta();
        
        [JsonConstructor]
        public AssetDeliveryInformation(AssetDeliveryPeriods? periods, IEnumerable<LocationIdentifier> location, Quantity? deliveryCapacity, IEnumerable<Enums.ProductGrade> commodityGrade)
        {
            Periods = periods;
            Location = location;
            DeliveryCapacity = deliveryCapacity;
            CommodityGrade = commodityGrade;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetDeliveryInformation> MetaData => metaData;
        
        /// <summary>
        /// Defines the periods of delivery, including the delivery profile.
        /// </summary>
        public AssetDeliveryPeriods? Periods { get; }
        
        /// <summary>
        /// Defines the location of the delivery of the commodity.
        /// </summary>
        public IEnumerable<LocationIdentifier> Location { get; }
        
        /// <summary>
        /// The number of units included in the transaction for each delivery interval
        /// </summary>
        public Quantity? DeliveryCapacity { get; }
        
        /// <summary>
        /// Grade of product being delivered (e.g., grade of oil).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.ProductGrade> CommodityGrade { get; }
    }
    
    /// <summary>
    /// Defines the periods of delivery, including the delivery profile.
    /// </summary>
    public class AssetDeliveryPeriods : AbstractRosettaModelObject<AssetDeliveryPeriods>, IAssetDeliveryPeriods
    {
        private static readonly IRosettaMetaData<AssetDeliveryPeriods> metaData = new AssetDeliveryPeriodsMeta();
        
        [JsonConstructor]
        public AssetDeliveryPeriods(IEnumerable<AssetDeliveryProfile> profile, LocalDate? startDate, LocalDate? endDate)
        {
            Profile = profile;
            StartDate = startDate;
            EndDate = endDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetDeliveryPeriods> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetDeliveryProfile> Profile { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? StartDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EndDate { get; }
    }
    
    /// <summary>
    /// Defines the delivery profile of the asset, including the load type and the delivery intervals.
    /// </summary>
    public class AssetDeliveryProfile : AbstractRosettaModelObject<AssetDeliveryProfile>
    {
        private static readonly IRosettaMetaData<AssetDeliveryProfile> metaData = new AssetDeliveryProfileMeta();
        
        [JsonConstructor]
        public AssetDeliveryProfile(Enums.LoadType? loadType, IEnumerable<AssetDeliveryProfileBlock> block, Enums.BankHolidayTreatment? bankHolidaysTreatment)
        {
            LoadType = loadType;
            Block = block;
            BankHolidaysTreatment = bankHolidaysTreatment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetDeliveryProfile> MetaData => metaData;
        
        /// <summary>
        /// Identification of the delivery profile.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.LoadType? LoadType { get; }
        
        /// <summary>
        /// Defines a delivery profile block, including start and end time, days of the week, duration, delivery capacity and price time interval quantity.
        /// </summary>
        public IEnumerable<AssetDeliveryProfileBlock> Block { get; }
        
        /// <summary>
        /// Specifies whether the dates defined include holidays or not.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BankHolidayTreatment? BankHolidaysTreatment { get; }
    }
    
    /// <summary>
    /// Defines a delivery profile block, including start and end time, days of the week, duration, delivery capacity and price time interval quantity.
    /// </summary>
    public class AssetDeliveryProfileBlock : AbstractRosettaModelObject<AssetDeliveryProfileBlock>
    {
        private static readonly IRosettaMetaData<AssetDeliveryProfileBlock> metaData = new AssetDeliveryProfileBlockMeta();
        
        [JsonConstructor]
        public AssetDeliveryProfileBlock(LocalTime? startTime, LocalTime? endTime, IEnumerable<Enums.DayOfWeek> dayOfWeek, Quantity? deliveryCapacity, Price? priceTimeIntervalQuantity)
        {
            StartTime = startTime;
            EndTime = endTime;
            DayOfWeek = dayOfWeek;
            DeliveryCapacity = deliveryCapacity;
            PriceTimeIntervalQuantity = priceTimeIntervalQuantity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetDeliveryProfileBlock> MetaData => metaData;
        
        /// <summary>
        /// The start time of the delivery interval for each block or shape.
        /// </summary>
        public LocalTime? StartTime { get; }
        
        /// <summary>
        /// The end time of the delivery interval for each block or shape.
        /// </summary>
        public LocalTime? EndTime { get; }
        
        /// <summary>
        /// The days of the week of the delivery.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.DayOfWeek> DayOfWeek { get; }
        
        /// <summary>
        /// The number of units included in the transaction for each delivery interval
        /// </summary>
        public Quantity? DeliveryCapacity { get; }
        
        /// <summary>
        /// Price per quantity per delivery time interval.
        /// </summary>
        public Price? PriceTimeIntervalQuantity { get; }
    }
    
    /// <summary>
    /// Defines the basic parameters of an asset transfer, e.g. a cashflow: what (the asset), how much (the quantity) and when (the settlement date).
    /// </summary>
    public class AssetFlowBase : AbstractRosettaModelObject<AssetFlowBase>, IAssetFlowBase
    {
        private static readonly IRosettaMetaData<AssetFlowBase> metaData = new AssetFlowBaseMeta();
        
        [JsonConstructor]
        public AssetFlowBase(NonNegativeQuantity quantity, Asset asset, AdjustableOrAdjustedOrRelativeDate settlementDate)
        {
            Quantity = quantity;
            Asset = asset;
            SettlementDate = settlementDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetFlowBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public NonNegativeQuantity Quantity { get; }
        
        /// <inheritdoc/>
        public Asset Asset { get; }
        
        /// <inheritdoc/>
        public AdjustableOrAdjustedOrRelativeDate SettlementDate { get; }
    }
    
    /// <summary>
    /// The unique identifier for an Asset, specified using an Asset Identifier Type enumerator.
    /// </summary>
    public class AssetIdentifier : AbstractRosettaModelObject<AssetIdentifier>
    {
        private static readonly IRosettaMetaData<AssetIdentifier> metaData = new AssetIdentifierMeta();
        
        [JsonConstructor]
        public AssetIdentifier(FieldWithMetaString identifier, Enums.AssetIdType identifierType)
        {
            Identifier = identifier;
            IdentifierType = identifierType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetIdentifier> MetaData => metaData;
        
        /// <summary>
        /// The identifier value.
        /// </summary>
        public FieldWithMetaString Identifier { get; }
        
        /// <summary>
        /// Defines the symbology source of the Asset Identifier, eg CUSIP, ISIN, etc.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetIdType IdentifierType { get; }
    }
    
    /// <summary>
    /// Defines each asset movement of an asset payout.
    /// </summary>
    public class AssetLeg : AbstractRosettaModelObject<AssetLeg>
    {
        private static readonly IRosettaMetaData<AssetLeg> metaData = new AssetLegMeta();
        
        [JsonConstructor]
        public AssetLeg(AdjustableOrRelativeDate settlementDate, Enums.DeliveryMethod deliveryMethod)
        {
            SettlementDate = settlementDate;
            DeliveryMethod = deliveryMethod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetLeg> MetaData => metaData;
        
        /// <summary>
        /// Specifies the settlement date of securities.  In a repo transaction the purchase date would always be the effective date as specified under Economic Terms, the repurchase date would always be the termination date as specified under Economic Terms.
        /// </summary>
        public AdjustableOrRelativeDate SettlementDate { get; }
        
        /// <summary>
        /// Specifies a delivery method for the security transaction.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeliveryMethod DeliveryMethod { get; }
    }
    
    public class AssetMaturity : AbstractRosettaModelObject<AssetMaturity>
    {
        private static readonly IRosettaMetaData<AssetMaturity> metaData = new AssetMaturityMeta();
        
        [JsonConstructor]
        public AssetMaturity(Enums.MaturityType maturityType, PeriodRange maturityRange)
        {
            MaturityType = maturityType;
            MaturityRange = maturityRange;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetMaturity> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether the maturity range is the remaining or original maturity.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MaturityType MaturityType { get; }
        
        /// <summary>
        /// Represents a filter based on the underlying asset maturity.
        /// </summary>
        public PeriodRange MaturityRange { get; }
    }
    
    /// <summary>
    /// Security finance payout specification in case the product payout involves some form of security collateral, as in a securities financing transaction. Plus additional description for ICMA.
    /// </summary>
    public class AssetPayout : AbstractRosettaModelObject<AssetPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<AssetPayout> metaData = new AssetPayoutMeta();
        
        [JsonConstructor]
        public AssetPayout(PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms, IEnumerable<AssetLeg> assetLeg, Asset underlier, Money? minimumFee, DividendTerms? dividendTerms, Enums.AssetPayoutTradeType? tradeType)
        {
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
            AssetLeg = assetLeg;
            Underlier = underlier;
            MinimumFee = minimumFee;
            DividendTerms = dividendTerms;
            TradeType = tradeType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetPayout> MetaData => metaData;
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
        
        /// <summary>
        /// Defines each asset movement as a buy/sell at different dates, typically 1 near leg and 1 far leg in a securities financing transaction.
        /// </summary>
        public IEnumerable<AssetLeg> AssetLeg { get; }
        
        /// <summary>
        /// Specifies the Purchased Asset, usually a Security.
        /// </summary>
        public Asset Underlier { get; }
        
        /// <summary>
        /// A contractual minimum amount which the borrower will pay, regardless of the duration of the loan. A mechanism for making sure that a trade generates enough income.
        /// </summary>
        public Money? MinimumFee { get; }
        
        /// <summary>
        /// Specifies the terms under which dividends received by the borrower are passed through to the lender.
        /// </summary>
        public DividendTerms? DividendTerms { get; }
        
        /// <summary>
        /// The trade type, eg repurchase transaction or buy/sell-back.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetPayoutTradeType? TradeType { get; }
    }
    
    /// <summary>
    /// Represents a class to allow specification of the asset product type.
    /// </summary>
    public class AssetType : AbstractRosettaModelObject<AssetType>
    {
        private static readonly IRosettaMetaData<AssetType> metaData = new AssetTypeMeta();
        
        [JsonConstructor]
        public AssetType(Enums.AssetType assetType, Enums.InstrumentType? securityType, DebtType? debtType, EquityType? equityType, Enums.FundProductType? fundType, IEnumerable<string> otherAssetType)
        {
            AssetTypeValue = assetType;
            SecurityType = securityType;
            DebtType = debtType;
            EquityType = equityType;
            FundType = fundType;
            OtherAssetType = otherAssetType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssetType> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter based on the type of collateral asset.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "assetType")]
        public Enums.AssetType AssetTypeValue { get; }
        
        /// <summary>
        /// Represents a filter based on the type of security.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InstrumentType? SecurityType { get; }
        
        /// <summary>
        /// Represents a filter based on the type of bond.
        /// </summary>
        public DebtType? DebtType { get; }
        
        /// <summary>
        /// Represents a filter based on the type of equity.
        /// </summary>
        public EquityType? EquityType { get; }
        
        /// <summary>
        /// Represents a filter based on the type of fund.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FundProductType? FundType { get; }
        
        /// <summary>
        /// Specifies the eligible asset type when not enumerated.
        /// </summary>
        public IEnumerable<string> OtherAssetType { get; }
    }
    
    /// <summary>
    /// A class to specify the identifier value and its associated version.
    /// </summary>
    public class AssignedIdentifier : AbstractRosettaModelObject<AssignedIdentifier>
    {
        private static readonly IRosettaMetaData<AssignedIdentifier> metaData = new AssignedIdentifierMeta();
        
        [JsonConstructor]
        public AssignedIdentifier(FieldWithMetaString identifier, int? version)
        {
            Identifier = identifier;
            Version = version;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AssignedIdentifier> MetaData => metaData;
        
        /// <summary>
        /// The identifier value.
        /// </summary>
        public FieldWithMetaString Identifier { get; }
        
        /// <summary>
        /// The identifier version, which is specified as an integer and is meant to be incremented each time the transaction terms (whether contract or event) change. This version is made option to support the use case where the identifier is referenced without the version. The constraint that a contract and a lifecycle event need to have an associated version is enforced through data rules.
        /// </summary>
        public int? Version { get; }
    }
    
    /// <summary>
    /// A class to specify the Automatic Early Termination provision applicable to a Master Agreement.
    /// </summary>
    public class AutomaticEarlyTermination : AbstractRosettaModelObject<AutomaticEarlyTermination>
    {
        private static readonly IRosettaMetaData<AutomaticEarlyTermination> metaData = new AutomaticEarlyTerminationMeta();
        
        [JsonConstructor]
        public AutomaticEarlyTermination(bool fallbackAET, bool indemnity, IEnumerable<AutomaticEarlyTerminationElection> partyElection)
        {
            FallbackAET = fallbackAET;
            Indemnity = indemnity;
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AutomaticEarlyTermination> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether automatic termination applies in the event of certain bankruptcy events.
        /// </summary>
        public bool FallbackAET { get; }
        
        /// <summary>
        /// Specifies whether indemnity applies in the event AET is applicable to one or both of the parties.
        /// </summary>
        public bool Indemnity { get; }
        
        /// <summary>
        /// The party election specific to the Automatic Early Termination Clause.
        /// </summary>
        public IEnumerable<AutomaticEarlyTerminationElection> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify the party elections specific to the Automatic Early Termination Clause.
    /// </summary>
    public class AutomaticEarlyTerminationElection : AbstractRosettaModelObject<AutomaticEarlyTerminationElection>
    {
        private static readonly IRosettaMetaData<AutomaticEarlyTerminationElection> metaData = new AutomaticEarlyTerminationElectionMeta();
        
        [JsonConstructor]
        public AutomaticEarlyTerminationElection(Party party, bool isApplicable)
        {
            Party = party;
            IsApplicable = isApplicable;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AutomaticEarlyTerminationElection> MetaData => metaData;
        
        /// <summary>
        /// The party for which the Automatic Early Termination provisions are being specified.
        /// </summary>
        public Party Party { get; }
        
        /// <summary>
        /// A boolean election to specify whether the Automatic Early Termination provisions of Section 6(a) are applicable (True) or not applicable (False).
        /// </summary>
        public bool IsApplicable { get; }
    }
    
    /// <summary>
    /// A type to define automatic exercise of a swaption. With automatic exercise the option is deemed to have exercised if it is in the money by more than the threshold amount on the exercise date.
    /// </summary>
    public class AutomaticExercise : AbstractRosettaModelObject<AutomaticExercise>
    {
        private static readonly IRosettaMetaData<AutomaticExercise> metaData = new AutomaticExerciseMeta();
        
        [JsonConstructor]
        public AutomaticExercise(decimal? thresholdRate, bool? isApplicable)
        {
            ThresholdRate = thresholdRate;
            IsApplicable = isApplicable;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AutomaticExercise> MetaData => metaData;
        
        /// <summary>
        /// A threshold rate. The threshold of 0.10% would be represented as 0.001
        /// </summary>
        public decimal? ThresholdRate { get; }
        
        /// <summary>
        /// Boolean that indicates if it has an automaticExercise
        /// </summary>
        public bool? IsApplicable { get; }
    }
    
    /// <summary>
    /// A data type that can be used to describe the inventory of securities that a party holds. The securities are held in the AvailableInventoryRecord, with each item in the array being an individual security and its associated criteria. Criteria can include the quantity available, the rate at which the security is available to borrow at, as well as other details that can affect the decision as to whether a party wants to utilise the securities listed.
    /// </summary>
    public class AvailableInventory : AbstractRosettaModelObject<AvailableInventory>, IAvailableInventory
    {
        private static readonly IRosettaMetaData<AvailableInventory> metaData = new AvailableInventoryMeta();
        
        [JsonConstructor]
        public AvailableInventory(Enums.AvailableInventoryType availableInventoryType, MessageInformation? messageInformation, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, IEnumerable<AvailableInventoryRecord> availableInventoryRecord)
        {
            AvailableInventoryType = availableInventoryType;
            MessageInformation = messageInformation;
            Party = party;
            PartyRole = partyRole;
            AvailableInventoryRecord = availableInventoryRecord;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AvailableInventory> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AvailableInventoryType AvailableInventoryType { get; }
        
        /// <inheritdoc/>
        public MessageInformation? MessageInformation { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        public IEnumerable<AvailableInventoryRecord> AvailableInventoryRecord { get; }
    }
    
    /// <summary>
    /// An individual piece of available inventory. This represents a single security and its associated criteria. The criteria are used to describe any restrictions on the securities.
    /// </summary>
    public class AvailableInventoryRecord : AbstractRosettaModelObject<AvailableInventoryRecord>, IInventoryRecord
    {
        private static readonly IRosettaMetaData<AvailableInventoryRecord> metaData = new AvailableInventoryRecordMeta();
        
        [JsonConstructor]
        public AvailableInventoryRecord(AssignedIdentifier identifer, Security security, ZonedDateTime? expirationDateTime, IEnumerable<CollateralProvisions> collateral, IEnumerable<PartyRole> partyRole, Quantity? quantity, Price? interestRate)
        {
            Identifer = identifer;
            Security = security;
            ExpirationDateTime = expirationDateTime;
            Collateral = collateral;
            PartyRole = partyRole;
            Quantity = quantity;
            InterestRate = interestRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AvailableInventoryRecord> MetaData => metaData;
        
        /// <inheritdoc/>
        public AssignedIdentifier Identifer { get; }
        
        /// <inheritdoc/>
        public Security Security { get; }
        
        /// <summary>
        /// There may be a set period/time restriction associated to the security.
        /// </summary>
        public ZonedDateTime? ExpirationDateTime { get; }
        
        /// <summary>
        /// The type of collateral can often be required when determining if the piece of availability being described is suitable for a party.
        /// </summary>
        public IEnumerable<CollateralProvisions> Collateral { get; }
        
        /// <summary>
        /// An individual security may be held by several agents. Including the party role at this level allows us to reference the party holding this specific item.
        /// </summary>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <summary>
        /// The quantity of the security
        /// </summary>
        public Quantity? Quantity { get; }
        
        /// <summary>
        /// An optional element which can be used to hold a rate associated to this piece of availability.
        /// </summary>
        public Price? InterestRate { get; }
    }
    
    /// <summary>
    /// Represents the average trading volume of an Equity product upon an exchange or set of exchanges.
    /// </summary>
    public class AverageTradingVolume : AbstractRosettaModelObject<AverageTradingVolume>
    {
        private static readonly IRosettaMetaData<AverageTradingVolume> metaData = new AverageTradingVolumeMeta();
        
        [JsonConstructor]
        public AverageTradingVolume(Period period, Enums.AverageTradingVolumeMethodology methodology)
        {
            Period = period;
            Methodology = methodology;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AverageTradingVolume> MetaData => metaData;
        
        /// <summary>
        /// Represents the period of the equities average trading volume on the exchange/s.
        /// </summary>
        public Period Period { get; }
        
        /// <summary>
        /// Indicates the type of equity average trading volume being stated (single) the highest amount on one exchange, or (consolidated) volumes across multiple exchanges.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AverageTradingVolumeMethodology Methodology { get; }
    }
    
    /// <summary>
    /// Defines parameters for use in cases when a valuation or other term is based on an average of market observations.
    /// </summary>
    public class AveragingCalculation : AbstractRosettaModelObject<AveragingCalculation>
    {
        private static readonly IRosettaMetaData<AveragingCalculation> metaData = new AveragingCalculationMeta();
        
        [JsonConstructor]
        public AveragingCalculation(AveragingCalculationMethod averagingMethod, Rounding precision)
        {
            AveragingMethod = averagingMethod;
            Precision = precision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingCalculation> MetaData => metaData;
        
        /// <summary>
        /// Specifies enumerations for the type of averaging calculation.
        /// </summary>
        public AveragingCalculationMethod AveragingMethod { get; }
        
        /// <summary>
        /// Rounding applied to the average calculation. 
        /// </summary>
        public Rounding Precision { get; }
    }
    
    /// <summary>
    /// Defines the ways in which multiple values can be aggregated into a single value.
    /// </summary>
    public class AveragingCalculationMethod : AbstractRosettaModelObject<AveragingCalculationMethod>
    {
        private static readonly IRosettaMetaData<AveragingCalculationMethod> metaData = new AveragingCalculationMethodMeta();
        
        [JsonConstructor]
        public AveragingCalculationMethod(bool isWeighted, Enums.AveragingCalculationMethod calculationMethod)
        {
            IsWeighted = isWeighted;
            CalculationMethod = calculationMethod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingCalculationMethod> MetaData => metaData;
        
        /// <summary>
        /// Identifies whether the average values will be weighted or unweighted.
        /// </summary>
        public bool IsWeighted { get; }
        
        /// <summary>
        /// Identifies which of the Pythagorean means is being used to compute an average value.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingCalculationMethod CalculationMethod { get; }
    }
    
    /// <summary>
    /// As per ISDA 2002 Definitions.
    /// </summary>
    public class AveragingFeature : AbstractRosettaModelObject<AveragingFeature>
    {
        private static readonly IRosettaMetaData<AveragingFeature> metaData = new AveragingFeatureMeta();
        
        [JsonConstructor]
        public AveragingFeature(AveragingCalculation averagingCalculation, Enums.AveragingInOut averagingInOut, decimal? strikeFactor, AveragingPeriod? averagingPeriodIn, AveragingPeriod? averagingPeriodOut)
        {
            AveragingCalculation = averagingCalculation;
            AveragingInOut = averagingInOut;
            StrikeFactor = strikeFactor;
            AveragingPeriodIn = averagingPeriodIn;
            AveragingPeriodOut = averagingPeriodOut;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingFeature> MetaData => metaData;
        
        /// <summary>
        /// Defines parameters for use in cases when a valuation or other term is based on an average of market observations.
        /// </summary>
        public AveragingCalculation AveragingCalculation { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingInOut AveragingInOut { get; }
        
        /// <summary>
        /// The factor of strike.
        /// </summary>
        public decimal? StrikeFactor { get; }
        
        /// <summary>
        /// The averaging in period.
        /// </summary>
        public AveragingPeriod? AveragingPeriodIn { get; }
        
        /// <summary>
        /// The averaging out period.
        /// </summary>
        public AveragingPeriod? AveragingPeriodOut { get; }
    }
    
    /// <summary>
    /// An unordered list of weighted averaging observations.
    /// </summary>
    public class AveragingObservationList : AbstractRosettaModelObject<AveragingObservationList>
    {
        private static readonly IRosettaMetaData<AveragingObservationList> metaData = new AveragingObservationListMeta();
        
        [JsonConstructor]
        public AveragingObservationList(IEnumerable<WeightedAveragingObservation> averagingObservation)
        {
            AveragingObservation = averagingObservation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingObservationList> MetaData => metaData;
        
        /// <summary>
        /// A single weighted averaging observation.
        /// </summary>
        public IEnumerable<WeightedAveragingObservation> AveragingObservation { get; }
    }
    
    /// <summary>
    /// Period over which an average value is taken.
    /// </summary>
    public class AveragingPeriod : AbstractRosettaModelObject<AveragingPeriod>
    {
        private static readonly IRosettaMetaData<AveragingPeriod> metaData = new AveragingPeriodMeta();
        
        [JsonConstructor]
        public AveragingPeriod(IEnumerable<AveragingSchedule> schedule, DateTimeList? averagingDateTimes, AveragingObservationList? averagingObservations, FieldWithMetaMarketDisruptionEnum? marketDisruption)
        {
            Schedule = schedule;
            AveragingDateTimes = averagingDateTimes;
            AveragingObservations = averagingObservations;
            MarketDisruption = marketDisruption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingPeriod> MetaData => metaData;
        
        /// <summary>
        /// A schedule for generating averaging observation dates.
        /// </summary>
        public IEnumerable<AveragingSchedule> Schedule { get; }
        
        /// <summary>
        /// An unweighted list of averaging observation date and times.
        /// </summary>
        public DateTimeList? AveragingDateTimes { get; }
        
        /// <summary>
        /// A weighted list of averaging observation date and times.
        /// </summary>
        public AveragingObservationList? AveragingObservations { get; }
        
        /// <summary>
        /// The market disruption event as defined by ISDA 2002 Definitions.
        /// </summary>
        public FieldWithMetaMarketDisruptionEnum? MarketDisruption { get; }
    }
    
    /// <summary>
    /// Class to representing a method for generating a series of dates.
    /// </summary>
    public class AveragingSchedule : AbstractRosettaModelObject<AveragingSchedule>
    {
        private static readonly IRosettaMetaData<AveragingSchedule> metaData = new AveragingScheduleMeta();
        
        [JsonConstructor]
        public AveragingSchedule(LocalDate startDate, LocalDate endDate, CalculationPeriodFrequency averagingPeriodFrequency)
        {
            StartDate = startDate;
            EndDate = endDate;
            AveragingPeriodFrequency = averagingPeriodFrequency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingSchedule> MetaData => metaData;
        
        /// <summary>
        /// Date on which this period begins.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StartDate { get; }
        
        /// <summary>
        /// Date on which this period ends.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EndDate { get; }
        
        /// <summary>
        /// The frequency at which averaging period occurs with the regular part of the valuation schedule and their roll date convention.
        /// </summary>
        public CalculationPeriodFrequency AveragingPeriodFrequency { get; }
    }
    
    /// <summary>
    /// Defines the terms required to calculate the average observations associated with an averaging strike.
    /// </summary>
    public class AveragingStrikeFeature : AbstractRosettaModelObject<AveragingStrikeFeature>
    {
        private static readonly IRosettaMetaData<AveragingStrikeFeature> metaData = new AveragingStrikeFeatureMeta();
        
        [JsonConstructor]
        public AveragingStrikeFeature(AveragingCalculation averagingCalculation, ObservationTerms observationTerms)
        {
            AveragingCalculation = averagingCalculation;
            ObservationTerms = observationTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<AveragingStrikeFeature> MetaData => metaData;
        
        /// <summary>
        /// Defines parameters for use in cases when a valuation or other term is based on an average of market observations.
        /// </summary>
        public AveragingCalculation AveragingCalculation { get; }
        
        /// <summary>
        /// Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. 
        /// </summary>
        public ObservationTerms ObservationTerms { get; }
    }
    
    /// <summary>
    /// As per ISDA 2002 Definitions.
    /// </summary>
    public class Barrier : AbstractRosettaModelObject<Barrier>
    {
        private static readonly IRosettaMetaData<Barrier> metaData = new BarrierMeta();
        
        [JsonConstructor]
        public Barrier(TriggerEvent? barrierCap, TriggerEvent? barrierFloor)
        {
            BarrierCap = barrierCap;
            BarrierFloor = barrierFloor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Barrier> MetaData => metaData;
        
        /// <summary>
        /// A trigger level approached from beneath.
        /// </summary>
        public TriggerEvent? BarrierCap { get; }
        
        /// <summary>
        /// A trigger level approached from above.
        /// </summary>
        public TriggerEvent? BarrierFloor { get; }
    }
    
    /// <summary>
    /// The base and eligible currency(ies) for the document as specified by the parties to the agreement.
    /// </summary>
    public class BaseAndEligibleCurrency : AbstractRosettaModelObject<BaseAndEligibleCurrency>
    {
        private static readonly IRosettaMetaData<BaseAndEligibleCurrency> metaData = new BaseAndEligibleCurrencyMeta();
        
        [JsonConstructor]
        public BaseAndEligibleCurrency(Enums.ISOCurrencyCode baseCurrency, bool baseCurrencyTerminationCurrency, FieldWithMetaString? baseCurrencyOther, IEnumerable<Enums.ISOCurrencyCode> eligibleCurrency, bool eligibleCurrencyInclBaseCurrency, FieldWithMetaString? eligibleCurrencyOther)
        {
            BaseCurrency = baseCurrency;
            BaseCurrencyTerminationCurrency = baseCurrencyTerminationCurrency;
            BaseCurrencyOther = baseCurrencyOther;
            EligibleCurrency = eligibleCurrency;
            EligibleCurrencyInclBaseCurrency = eligibleCurrencyInclBaseCurrency;
            EligibleCurrencyOther = eligibleCurrencyOther;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BaseAndEligibleCurrency> MetaData => metaData;
        
        /// <summary>
        /// The common agreed currency into which relevant amounts of all collateral arrangements between the parties are converted, or if not an actual currency, the process through which this is determined. Where hardcoded (e.g. under the 1994 ISDA Credit Support Annex (Security Interest  NY Law)), the currency that effectively performs this function.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ISOCurrencyCode BaseCurrency { get; }
        
        /// <summary>
        /// A flag detailing whether the Base Currency is set to  the Termination Currency as defined in the related  Master Agreement.
        /// </summary>
        public bool BaseCurrencyTerminationCurrency { get; }
        
        /// <summary>
        /// Utilised where the clause data structure is not able to capture a material aspect of the clause.
        /// </summary>
        public FieldWithMetaString? BaseCurrencyOther { get; }
        
        /// <summary>
        /// A definition of a currency agreed by the parties, typically to indicate the currencies of eligible cash collateral.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.ISOCurrencyCode> EligibleCurrency { get; }
        
        /// <summary>
        /// A flag detailing whether the Base Currency is included as an Eligible Currency.
        /// </summary>
        public bool EligibleCurrencyInclBaseCurrency { get; }
        
        /// <summary>
        /// Utilised where the clause data structure is not able to capture a material aspect of the clause.
        /// </summary>
        public FieldWithMetaString? EligibleCurrencyOther { get; }
    }
    
    /// <summary>
    /// Defines a custom basket by referencing an identifier and its constituents.
    /// </summary>
    public class Basket : AbstractRosettaModelObject<Basket>, IAssetBase
    {
        private static readonly IRosettaMetaData<Basket> metaData = new BasketMeta();
        
        [JsonConstructor]
        public Basket(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, IEnumerable<FieldWithMetaBasketConstituent> basketConstituent)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            BasketConstituent = basketConstituent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Basket> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <summary>
        /// Identifies the constituents of the basket
        /// </summary>
        public IEnumerable<FieldWithMetaBasketConstituent> BasketConstituent { get; }
    }
    
    /// <summary>
    /// Identifies the constituents of the basket
    /// </summary>
    public class BasketConstituent : AbstractRosettaModelObject<BasketConstituent>, IObservable
    {
        private static readonly IRosettaMetaData<BasketConstituent> metaData = new BasketConstituentMeta();
        
        [JsonConstructor]
        public BasketConstituent(Asset? asset, Basket? basket, Index? index, IEnumerable<ReferenceWithMetaNonNegativeQuantitySchedule> quantity, IEnumerable<ReferenceWithMetaPriceSchedule> initialValuationPrice, IEnumerable<ReferenceWithMetaPriceSchedule> interimValuationPrice, IEnumerable<ReferenceWithMetaPriceSchedule> finalValuationPrice)
        {
            Asset = asset;
            Basket = basket;
            Index = index;
            Quantity = quantity;
            InitialValuationPrice = initialValuationPrice;
            InterimValuationPrice = interimValuationPrice;
            FinalValuationPrice = finalValuationPrice;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BasketConstituent> MetaData => metaData;
        
        /// <inheritdoc/>
        public Asset? Asset { get; }
        
        /// <inheritdoc/>
        public Basket? Basket { get; }
        
        /// <inheritdoc/>
        public Index? Index { get; }
        
        /// <summary>
        /// Specifies a quantity schedule to be associated to an individual underlier that is a basket constituent. The multiple cardinality is aligned to the one of the PriceQuantity-&gt;quantity that this quantity is referencing.
        /// </summary>
        public IEnumerable<ReferenceWithMetaNonNegativeQuantitySchedule> Quantity { get; }
        
        /// <summary>
        /// Specifies an initial price schedule to be associated to an individual underlier that is a basket constituent. The multiple cardinality is aligned to the one of the PriceQuantity-&gt;price that this price is referencing.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPriceSchedule> InitialValuationPrice { get; }
        
        /// <summary>
        /// Specifies an interim price schedule to be associated to an individual underlier that is a basket constituent. The multiple cardinality is aligned to the one of the PriceQuantity-&gt;price that this price is referencing.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPriceSchedule> InterimValuationPrice { get; }
        
        /// <summary>
        /// Specifies a final price schedule to be associated to an individual underlier that is a basket constituent. The multiple cardinality is aligned to the one of the PriceQuantity-&gt;price that this price is referencing.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPriceSchedule> FinalValuationPrice { get; }
    }
    
    /// <summary>
    /// CDS Basket Reference Information.
    /// </summary>
    public class BasketReferenceInformation : AbstractRosettaModelObject<BasketReferenceInformation>
    {
        private static readonly IRosettaMetaData<BasketReferenceInformation> metaData = new BasketReferenceInformationMeta();
        
        [JsonConstructor]
        public BasketReferenceInformation(FieldWithMetaString? basketName, IEnumerable<FieldWithMetaString> basketId, ReferencePool referencePool, int? nthToDefault, int? mthToDefault, Tranche? tranche)
        {
            BasketName = basketName;
            BasketId = basketId;
            ReferencePool = referencePool;
            NthToDefault = nthToDefault;
            MthToDefault = mthToDefault;
            Tranche = tranche;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BasketReferenceInformation> MetaData => metaData;
        
        /// <summary>
        /// The name of the basket expressed as a free format string. FpML does not define usage rules for this element.
        /// </summary>
        public FieldWithMetaString? BasketName { get; }
        
        /// <summary>
        /// A CDS basket identifier.
        /// </summary>
        public IEnumerable<FieldWithMetaString> BasketId { get; }
        
        /// <summary>
        /// This element contains all the reference pool items to define the reference entity and reference obligation(s) in the basket.
        /// </summary>
        public ReferencePool ReferencePool { get; }
        
        /// <summary>
        /// N th reference obligation to default triggers payout.
        /// </summary>
        public int? NthToDefault { get; }
        
        /// <summary>
        /// M th reference obligation to default to allow representation of N th to M th defaults.
        /// </summary>
        public int? MthToDefault { get; }
        
        /// <summary>
        /// This element contains CDS tranche terms.
        /// </summary>
        public Tranche? Tranche { get; }
    }
    
    /// <summary>
    /// A class to specify bespoke Calculation Date terms for the purposes of Initial Margin.
    /// </summary>
    public class BespokeCalculationDate : AbstractRosettaModelObject<BespokeCalculationDate>
    {
        private static readonly IRosettaMetaData<BespokeCalculationDate> metaData = new BespokeCalculationDateMeta();
        
        [JsonConstructor]
        public BespokeCalculationDate(bool isApplicable, string? calculationDateImTerms)
        {
            IsApplicable = isApplicable;
            CalculationDateImTerms = calculationDateImTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BespokeCalculationDate> MetaData => metaData;
        
        /// <summary>
        /// Additional Calculation Date terms are applicable when True and not applicable when False.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The Additional Calculation Date terms for the purposes of Initial Margin.
        /// </summary>
        public string? CalculationDateImTerms { get; }
    }
    
    /// <summary>
    /// A class to specify additional Calculation Time terms for the purposes of Initial Margin.
    /// </summary>
    public class BespokeCalculationTime : AbstractRosettaModelObject<BespokeCalculationTime>
    {
        private static readonly IRosettaMetaData<BespokeCalculationTime> metaData = new BespokeCalculationTimeMeta();
        
        [JsonConstructor]
        public BespokeCalculationTime(bool asCalculationAgent, string? bespokeCalculationTimeTerms)
        {
            AsCalculationAgent = asCalculationAgent;
            BespokeCalculationTimeTerms = bespokeCalculationTimeTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BespokeCalculationTime> MetaData => metaData;
        
        /// <summary>
        /// If set to True, the Calculation Time for Initial Margin is the time as of which the Calculation Agent (IM) computes its end of day valuations of derivatives transactions.
        /// </summary>
        public bool AsCalculationAgent { get; }
        
        /// <summary>
        /// Additional Terms applicable to Calculation Time for Initial Margin.
        /// </summary>
        public string? BespokeCalculationTimeTerms { get; }
    }
    
    /// <summary>
    /// A class to specify any bespoke Transfer Timing language by each party to the agreement.
    /// </summary>
    public class BespokeTransferTiming : AbstractRosettaModelObject<BespokeTransferTiming>
    {
        private static readonly IRosettaMetaData<BespokeTransferTiming> metaData = new BespokeTransferTimingMeta();
        
        [JsonConstructor]
        public BespokeTransferTiming(bool isApplicable, string? bespokeTransferTimingTerms)
        {
            IsApplicable = isApplicable;
            BespokeTransferTimingTerms = bespokeTransferTimingTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BespokeTransferTiming> MetaData => metaData;
        
        /// <summary>
        /// A boolean flag to specify whether bespoke transfer terms are applicable or not.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The bespoke transfer timing terms applicable to the agreement.
        /// </summary>
        public string? BespokeTransferTimingTerms { get; }
    }
    
    /// <summary>
    /// Specifies the instructions for creation of a Security Lending billing invoice.
    /// </summary>
    public class BillingInstruction : AbstractRosettaModelObject<BillingInstruction>
    {
        private static readonly IRosettaMetaData<BillingInstruction> metaData = new BillingInstructionMeta();
        
        [JsonConstructor]
        public BillingInstruction(Party sendingParty, Party receivingParty, LocalDate billingStartDate, LocalDate billingEndDate, IEnumerable<BillingRecordInstruction> billingRecordInstruction, IEnumerable<BillingSummaryInstruction> billingSummary)
        {
            SendingParty = sendingParty;
            ReceivingParty = receivingParty;
            BillingStartDate = billingStartDate;
            BillingEndDate = billingEndDate;
            BillingRecordInstruction = billingRecordInstruction;
            BillingSummary = billingSummary;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingInstruction> MetaData => metaData;
        
        /// <summary>
        /// The party issuing the invoice
        /// </summary>
        public Party SendingParty { get; }
        
        /// <summary>
        /// The party receiving the invoice
        /// </summary>
        public Party ReceivingParty { get; }
        
        /// <summary>
        /// The starting date of the period described by this invoice
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate BillingStartDate { get; }
        
        /// <summary>
        /// The ending date of the period described by this invoice
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate BillingEndDate { get; }
        
        /// <summary>
        /// Instructions for creating the billing records contained within the invoice
        /// </summary>
        public IEnumerable<BillingRecordInstruction> BillingRecordInstruction { get; }
        
        /// <summary>
        /// The billing summaries contained within the invoice
        /// </summary>
        public IEnumerable<BillingSummaryInstruction> BillingSummary { get; }
    }
    
    /// <summary>
    /// Specifies individual records within a billing invoice.
    /// </summary>
    public class BillingRecord : AbstractRosettaModelObject<BillingRecord>
    {
        private static readonly IRosettaMetaData<BillingRecord> metaData = new BillingRecordMeta();
        
        [JsonConstructor]
        public BillingRecord(ReferenceWithMetaTradeState tradeState, Transfer recordTransfer, LocalDate recordStartDate, LocalDate recordEndDate, Money? minimumFee)
        {
            TradeState = tradeState;
            RecordTransfer = recordTransfer;
            RecordStartDate = recordStartDate;
            RecordEndDate = recordEndDate;
            MinimumFee = minimumFee;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingRecord> MetaData => metaData;
        
        /// <summary>
        /// The trade for the individual billing record.
        /// </summary>
        public ReferenceWithMetaTradeState TradeState { get; }
        
        /// <summary>
        /// The settlement terms for the billing record
        /// </summary>
        public Transfer RecordTransfer { get; }
        
        /// <summary>
        /// The starting date of the period described by this record
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate RecordStartDate { get; }
        
        /// <summary>
        /// The ending date of the period described by this record
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate RecordEndDate { get; }
        
        /// <summary>
        /// Indicates the minimum fee amount applied to the billing record, if any.
        /// </summary>
        public Money? MinimumFee { get; }
    }
    
    /// <summary>
    /// Specifies the instructions for creation of a billing record.
    /// </summary>
    public class BillingRecordInstruction : AbstractRosettaModelObject<BillingRecordInstruction>
    {
        private static readonly IRosettaMetaData<BillingRecordInstruction> metaData = new BillingRecordInstructionMeta();
        
        [JsonConstructor]
        public BillingRecordInstruction(ReferenceWithMetaTradeState tradeState, IEnumerable<Observation> observation, LocalDate recordStartDate, LocalDate recordEndDate, LocalDate settlementDate)
        {
            TradeState = tradeState;
            Observation = observation;
            RecordStartDate = recordStartDate;
            RecordEndDate = recordEndDate;
            SettlementDate = settlementDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingRecordInstruction> MetaData => metaData;
        
        /// <summary>
        /// The trade for the individual billing record.
        /// </summary>
        public ReferenceWithMetaTradeState TradeState { get; }
        
        /// <summary>
        /// The observations used to calculate the billing amount.
        /// </summary>
        public IEnumerable<Observation> Observation { get; }
        
        /// <summary>
        /// The starting date of the period described by this record
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate RecordStartDate { get; }
        
        /// <summary>
        /// The ending date of the period described by this record
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate RecordEndDate { get; }
        
        /// <summary>
        /// The date for settlement of the transfer.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate SettlementDate { get; }
    }
    
    /// <summary>
    /// Specifies individual summaries within a billing invoice.
    /// </summary>
    public class BillingSummary : AbstractRosettaModelObject<BillingSummary>
    {
        private static readonly IRosettaMetaData<BillingSummary> metaData = new BillingSummaryMeta();
        
        [JsonConstructor]
        public BillingSummary(Transfer? summaryTransfer, Enums.RecordAmountType summaryAmountType)
        {
            SummaryTransfer = summaryTransfer;
            SummaryAmountType = summaryAmountType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingSummary> MetaData => metaData;
        
        /// <summary>
        /// The settlement terms for the billing summary
        /// </summary>
        public Transfer? SummaryTransfer { get; }
        
        /// <summary>
        /// The account level for the billing summary.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RecordAmountType SummaryAmountType { get; }
    }
    
    /// <summary>
    /// Specifies the instructions for creation of a billing summary.
    /// </summary>
    public class BillingSummaryInstruction : AbstractRosettaModelObject<BillingSummaryInstruction>
    {
        private static readonly IRosettaMetaData<BillingSummaryInstruction> metaData = new BillingSummaryInstructionMeta();
        
        [JsonConstructor]
        public BillingSummaryInstruction(Enums.RecordAmountType summaryAmountType)
        {
            SummaryAmountType = summaryAmountType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BillingSummaryInstruction> MetaData => metaData;
        
        /// <summary>
        /// The account level for the billing summary.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RecordAmountType SummaryAmountType { get; }
    }
    
    /// <summary>
    /// Reference to a bond underlier to represent an asset swap or Condition Precedent Bond.
    /// </summary>
    public class BondReference : AbstractRosettaModelObject<BondReference>
    {
        private static readonly IRosettaMetaData<BondReference> metaData = new BondReferenceMeta();
        
        [JsonConstructor]
        public BondReference(Security bond, bool conditionPrecedentBond, bool? discrepancyClause, FixedRateSpecification? couponRate)
        {
            Bond = bond;
            ConditionPrecedentBond = conditionPrecedentBond;
            DiscrepancyClause = discrepancyClause;
            CouponRate = couponRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BondReference> MetaData => metaData;
        
        /// <summary>
        /// Reference to a bond underlier.
        /// </summary>
        public Security Bond { get; }
        
        /// <summary>
        /// To indicate whether the Condition Precedent Bond is applicable. The swap contract is only valid if the bond is issued and if there is any dispute over the terms of fixed stream then the bond terms would be used.
        /// </summary>
        public bool ConditionPrecedentBond { get; }
        
        /// <summary>
        /// To indicate whether the Discrepancy Clause is applicable.
        /// </summary>
        public bool? DiscrepancyClause { get; }
        
        /// <summary>
        /// Specifies the coupon rate (expressed in percentage) of a fixed income security or convertible bond.
        /// </summary>
        public FixedRateSpecification? CouponRate { get; }
    }
    
    /// <summary>
    /// Describes correlation bounds, which form a cap and a floor on the realized correlation.
    /// </summary>
    public class BoundedCorrelation : AbstractRosettaModelObject<BoundedCorrelation>
    {
        private static readonly IRosettaMetaData<BoundedCorrelation> metaData = new BoundedCorrelationMeta();
        
        [JsonConstructor]
        public BoundedCorrelation(decimal? minimumBoundaryPercent, decimal? maximumBoundaryPercent)
        {
            MinimumBoundaryPercent = minimumBoundaryPercent;
            MaximumBoundaryPercent = maximumBoundaryPercent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BoundedCorrelation> MetaData => metaData;
        
        /// <summary>
        /// Minimum Boundary as a percentage of the Strike Price.
        /// </summary>
        public decimal? MinimumBoundaryPercent { get; }
        
        /// <summary>
        /// Maximum Boundary as a percentage of the Strike Price.
        /// </summary>
        public decimal? MaximumBoundaryPercent { get; }
    }
    
    public class BoundedVariance : AbstractRosettaModelObject<BoundedVariance>
    {
        private static readonly IRosettaMetaData<BoundedVariance> metaData = new BoundedVarianceMeta();
        
        [JsonConstructor]
        public BoundedVariance(Enums.RealisedVarianceMethod realisedVarianceMethod, bool daysInRangeAdjustment, decimal? upperBarrier, decimal? lowerBarrier)
        {
            RealisedVarianceMethod = realisedVarianceMethod;
            DaysInRangeAdjustment = daysInRangeAdjustment;
            UpperBarrier = upperBarrier;
            LowerBarrier = lowerBarrier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BoundedVariance> MetaData => metaData;
        
        /// <summary>
        /// The contract specifies which price must satisfy the boundary condition.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RealisedVarianceMethod RealisedVarianceMethod { get; }
        
        /// <summary>
        /// The contract specifies whether the notional should be scaled by the Number of Days in Range divided by the Expected N. The number of Days in Ranges refers to the number of returns that contribute to the realized volatility.
        /// </summary>
        public bool DaysInRangeAdjustment { get; }
        
        /// <summary>
        /// All observations above this price level will be excluded from the variance calculation.
        /// </summary>
        public decimal? UpperBarrier { get; }
        
        /// <summary>
        /// All observations below this price level will be excluded from the variance calculation.
        /// </summary>
        public decimal? LowerBarrier { get; }
    }
    
    /// <summary>
    /// Identifies the market sector in which the trade has been arranged.
    /// </summary>
    public class BrokerConfirmation : AbstractRosettaModelObject<BrokerConfirmation>
    {
        private static readonly IRosettaMetaData<BrokerConfirmation> metaData = new BrokerConfirmationMeta();
        
        [JsonConstructor]
        public BrokerConfirmation(FieldWithMetaBrokerConfirmationTypeEnum brokerConfirmationType)
        {
            BrokerConfirmationType = brokerConfirmationType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BrokerConfirmation> MetaData => metaData;
        
        /// <summary>
        /// The type of broker confirmation executed between the parties.
        /// </summary>
        public FieldWithMetaBrokerConfirmationTypeEnum BrokerConfirmationType { get; }
    }
    
    /// <summary>
    /// A class for defining a time with respect to a business day calendar location. For example, 11:00:00 GBLO.
    /// </summary>
    public class BusinessCenterTime : AbstractRosettaModelObject<BusinessCenterTime>, IBusinessCenterTime
    {
        private static readonly IRosettaMetaData<BusinessCenterTime> metaData = new BusinessCenterTimeMeta();
        
        [JsonConstructor]
        public BusinessCenterTime(LocalTime hourMinuteTime, FieldWithMetaBusinessCenterEnum businessCenter)
        {
            HourMinuteTime = hourMinuteTime;
            BusinessCenter = businessCenter;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessCenterTime> MetaData => metaData;
        
        /// <inheritdoc/>
        public LocalTime HourMinuteTime { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaBusinessCenterEnum BusinessCenter { get; }
    }
    
    /// <summary>
    /// A class for specifying the business day calendar location used in determining whether a day is a business day or not, either by specifying this business center by reference to an enumerated list that is maintained by the FpML standard, or by reference to such specification when it exists elsewhere as part of the instance document. This class corresponds to the FpML BusinessCentersOrReference.model.
    /// </summary>
    public class BusinessCenters : AbstractRosettaModelObject<BusinessCenters>
    {
        private static readonly IRosettaMetaData<BusinessCenters> metaData = new BusinessCentersMeta();
        
        [JsonConstructor]
        public BusinessCenters(IEnumerable<FieldWithMetaBusinessCenterEnum> businessCenter, IEnumerable<FieldWithMetaCommodityBusinessCalendarEnum> commodityBusinessCalendar, ReferenceWithMetaBusinessCenters? businessCentersReference, _MetaFields? meta)
        {
            BusinessCenter = businessCenter;
            CommodityBusinessCalendar = commodityBusinessCalendar;
            BusinessCentersReference = businessCentersReference;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessCenters> MetaData => metaData;
        
        /// <summary>
        /// A code identifying one or several business day calendar location(s). The set of business day calendar locations are specified by the business day calendar location enumeration which is maintained by the FpML standard.
        /// </summary>
        public IEnumerable<FieldWithMetaBusinessCenterEnum> BusinessCenter { get; }
        
        public IEnumerable<FieldWithMetaCommodityBusinessCalendarEnum> CommodityBusinessCalendar { get; }
        
        /// <summary>
        /// A reference to a financial business center location specified elsewhere in the instance document.
        /// </summary>
        public ReferenceWithMetaBusinessCenters? BusinessCentersReference { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class defining a range of contiguous business days by defining an unadjusted first date, an unadjusted last date and a business day convention and business centers for adjusting the first and last dates if they would otherwise fall on a non business day in the specified business centers. The days between the first and last date must also be good business days in the specified centers to be counted in the range.
    /// </summary>
    public class BusinessDateRange : AbstractRosettaModelObject<BusinessDateRange>, IDateRange
    {
        private static readonly IRosettaMetaData<BusinessDateRange> metaData = new BusinessDateRangeMeta();
        
        [JsonConstructor]
        public BusinessDateRange(LocalDate startDate, LocalDate endDate, Enums.BusinessDayConvention businessDayConvention, BusinessCenters? businessCenters)
        {
            StartDate = startDate;
            EndDate = endDate;
            BusinessDayConvention = businessDayConvention;
            BusinessCenters = businessCenters;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessDateRange> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StartDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EndDate { get; }
        
        /// <summary>
        /// The convention for adjusting a date if it would otherwise fall on a day that is not a business day, as specified by an ISDA convention (e.g. Following, Precedent).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        /// <summary>
        /// The business center(s), specified either explicitly or by reference to those specified somewhere else in the instance document.
        /// </summary>
        public BusinessCenters? BusinessCenters { get; }
    }
    
    /// <summary>
    /// A class defining the business day convention and financial business centers used for adjusting any relevant date if it would otherwise fall on a day that is not a business day in the specified business center.
    /// </summary>
    public class BusinessDayAdjustments : AbstractRosettaModelObject<BusinessDayAdjustments>
    {
        private static readonly IRosettaMetaData<BusinessDayAdjustments> metaData = new BusinessDayAdjustmentsMeta();
        
        [JsonConstructor]
        public BusinessDayAdjustments(Enums.BusinessDayConvention businessDayConvention, BusinessCenters? businessCenters, _MetaFields? meta)
        {
            BusinessDayConvention = businessDayConvention;
            BusinessCenters = businessCenters;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessDayAdjustments> MetaData => metaData;
        
        /// <summary>
        /// The convention for adjusting a date if it would otherwise fall on a day that is not a business day.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
        
        /// <summary>
        /// The business center(s), specified either explicitly or by reference to those specified somewhere else in the instance document.
        /// </summary>
        public BusinessCenters? BusinessCenters { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// This allows an offset to be specified as, for instance, N business days, with a business centers specified as included.
    /// </summary>
    public class BusinessDayOffset : AbstractRosettaModelObject<BusinessDayOffset>, IBusinessDayOffset, IPeriod
    {
        private static readonly IRosettaMetaData<BusinessDayOffset> metaData = new BusinessDayOffsetMeta();
        
        [JsonConstructor]
        public BusinessDayOffset(int periodMultiplier, Enums.Period period, _MetaFields? meta, BusinessCenters? businessCenters, string? fixingOffsetDefinition, string? fixingOffsetReason)
        {
            PeriodMultiplier = periodMultiplier;
            PeriodValue = period;
            Meta = meta;
            BusinessCenters = businessCenters;
            FixingOffsetDefinition = fixingOffsetDefinition;
            FixingOffsetReason = fixingOffsetReason;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessDayOffset> MetaData => metaData;
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        public BusinessCenters? BusinessCenters { get; }
        
        /// <inheritdoc/>
        public string? FixingOffsetDefinition { get; }
        
        /// <inheritdoc/>
        public string? FixingOffsetReason { get; }
    }
    
    /// <summary>
    /// A business event represents a life cycle event of a trade. The combination of the state changes results in a qualifiable life cycle event. An example of a Business Event is a PartialTermination which is a defined by a quantity change primitive event.
    /// </summary>
    public class BusinessEvent : AbstractRosettaModelObject<BusinessEvent>, IEventInstruction
    {
        private static readonly IRosettaMetaData<BusinessEvent> metaData = new BusinessEventMeta();
        
        [JsonConstructor]
        public BusinessEvent(Enums.EventIntent? intent, Enums.CorporateActionType? corporateActionIntent, LocalDate? eventDate, LocalDate? effectiveDate, IdentifiedList? packageInformation, IEnumerable<Instruction> instruction, string? eventQualifier, IEnumerable<TradeState> after, _MetaFields? meta)
        {
            Intent = intent;
            CorporateActionIntent = corporateActionIntent;
            EventDate = eventDate;
            EffectiveDate = effectiveDate;
            PackageInformation = packageInformation;
            Instruction = instruction;
            EventQualifier = eventQualifier;
            After = after;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessEvent> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.EventIntent? Intent { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CorporateActionType? CorporateActionIntent { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EventDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <inheritdoc/>
        public IdentifiedList? PackageInformation { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Instruction> Instruction { get; }
        
        /// <summary>
        /// The CDM event qualifier, which corresponds to the outcome of the isEvent qualification logic which qualifies the lifecycle event as a function of its features (e.g. PartialTermination, ClearingSubmission, Novation, ...).
        /// </summary>
        public string? EventQualifier { get; }
        
        /// <summary>
        /// Specifies the after trade state(s) created.
        /// </summary>
        public IEnumerable<TradeState> After { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class to specify an organizational unit.
    /// </summary>
    public class BusinessUnit : AbstractRosettaModelObject<BusinessUnit>
    {
        private static readonly IRosettaMetaData<BusinessUnit> metaData = new BusinessUnitMeta();
        
        [JsonConstructor]
        public BusinessUnit(string name, Identifier? identifier, ContactInformation? contactInformation, _MetaFields? meta)
        {
            Name = name;
            Identifier = identifier;
            ContactInformation = contactInformation;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BusinessUnit> MetaData => metaData;
        
        /// <summary>
        /// A name used to describe the organizational unit
        /// </summary>
        public string Name { get; }
        
        /// <summary>
        /// An identifier used to uniquely identify the organizational unit
        /// </summary>
        public Identifier? Identifier { get; }
        
        /// <summary>
        /// The contact information for such business unit, when different from the contact information associated with the party.
        /// </summary>
        public ContactInformation? ContactInformation { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// This class corresponds to the FpML BuyerSeller.model construct.
    /// </summary>
    public class BuyerSeller : AbstractRosettaModelObject<BuyerSeller>, IBuyerSeller
    {
        private static readonly IRosettaMetaData<BuyerSeller> metaData = new BuyerSellerMeta();
        
        [JsonConstructor]
        public BuyerSeller(Enums.CounterpartyRole buyer, Enums.CounterpartyRole seller)
        {
            Buyer = buyer;
            Seller = seller;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<BuyerSeller> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Buyer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Seller { get; }
    }
    
    public class Buyr : AbstractRosettaModelObject<Buyr>
    {
        private static readonly IRosettaMetaData<Buyr> metaData = new BuyrMeta();
        
        [JsonConstructor]
        public Buyr(AcctOwnr acctOwnr)
        {
            AcctOwnr = acctOwnr;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Buyr> MetaData => metaData;
        
        public AcctOwnr AcctOwnr { get; }
    }
    
    /// <summary>
    /// Defines a combination of Rating Agency, Rating Value, amount and Currency code.
    /// </summary>
    public class CSAMinimumTransferAmountVariableSet : AbstractRosettaModelObject<CSAMinimumTransferAmountVariableSet>
    {
        private static readonly IRosettaMetaData<CSAMinimumTransferAmountVariableSet> metaData = new CSAMinimumTransferAmountVariableSetMeta();
        
        [JsonConstructor]
        public CSAMinimumTransferAmountVariableSet(Enums.CreditRatingAgency? name, string? value, int? amount, bool? amountIsInfinity)
        {
            Name = name;
            Value = value;
            Amount = amount;
            AmountIsInfinity = amountIsInfinity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CSAMinimumTransferAmountVariableSet> MetaData => metaData;
        
        /// <summary>
        /// The name of the Rating Agency.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency? Name { get; }
        
        /// <summary>
        /// The value assigned to the rating.
        /// </summary>
        public string? Value { get; }
        
        /// <summary>
        /// The Minimum Transfer Amount (MTA) applicable to the Rating.
        /// </summary>
        public int? Amount { get; }
        
        /// <summary>
        /// A flag that defines the Minimum Transfer Amount (MTA) as Infinity.
        /// </summary>
        public bool? AmountIsInfinity { get; }
    }
    
    /// <summary>
    /// Defines a combination of Rating Agency, Rating Value, Threshold amount and Currency code.
    /// </summary>
    public class CSAThresholdVariableSet : AbstractRosettaModelObject<CSAThresholdVariableSet>
    {
        private static readonly IRosettaMetaData<CSAThresholdVariableSet> metaData = new CSAThresholdVariableSetMeta();
        
        [JsonConstructor]
        public CSAThresholdVariableSet(Enums.CreditRatingAgency? name, string? value, int? amount)
        {
            Name = name;
            Value = value;
            Amount = amount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CSAThresholdVariableSet> MetaData => metaData;
        
        /// <summary>
        /// The relevant rating agency.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency? Name { get; }
        
        /// <summary>
        /// Rating applicable to the party from a given rating agency.
        /// </summary>
        public string? Value { get; }
        
        /// <summary>
        /// The amount value applicable to the Threshold.
        /// </summary>
        public int? Amount { get; }
    }
    
    /// <summary>
    /// Specifies the date on which the value of collateral or exposure are calculated in accordance with the agreement.
    /// </summary>
    public class CSAValuationDate : AbstractRosettaModelObject<CSAValuationDate>
    {
        private static readonly IRosettaMetaData<CSAValuationDate> metaData = new CSAValuationDateMeta();
        
        [JsonConstructor]
        public CSAValuationDate(Enums.ValuationDateDate? date, Enums.ValuationDateDay? day, decimal? calendarDay, Enums.ValuationDateFrequency? frequency, string? additionalLanguage)
        {
            Date = date;
            Day = day;
            CalendarDay = calendarDay;
            Frequency = frequency;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CSAValuationDate> MetaData => metaData;
        
        /// <summary>
        /// Defines whether a date is defined by a certain day of the week or a particular date in the month. If not specified here, then additional language must be used.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ValuationDateDate? Date { get; }
        
        /// <summary>
        /// Specific day(s) or day of the week, if any, specified for Valuation Time.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ValuationDateDay? Day { get; }
        
        /// <summary>
        /// Defines the day of the calendar if this is specified for in the ValuationDateDateEnum.
        /// </summary>
        public decimal? CalendarDay { get; }
        
        /// <summary>
        /// Defines the regularity of the date specified for the Valuation Date.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ValuationDateFrequency? Frequency { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Defines the tradeState or payout on which to create a Transfer along with all necessary resets.
    /// </summary>
    public class CalculateTransferInstruction : AbstractRosettaModelObject<CalculateTransferInstruction>
    {
        private static readonly IRosettaMetaData<CalculateTransferInstruction> metaData = new CalculateTransferInstructionMeta();
        
        [JsonConstructor]
        public CalculateTransferInstruction(TradeState tradeState, ReferenceWithMetaPayout payout, IEnumerable<Reset> resets, PayerReceiver? payerReceiver, Quantity? quantity, LocalDate? date)
        {
            TradeState = tradeState;
            Payout = payout;
            Resets = resets;
            PayerReceiver = payerReceiver;
            Quantity = quantity;
            Date = date;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculateTransferInstruction> MetaData => metaData;
        
        public TradeState TradeState { get; }
        
        public ReferenceWithMetaPayout Payout { get; }
        
        public IEnumerable<Reset> Resets { get; }
        
        public PayerReceiver? PayerReceiver { get; }
        
        /// <summary>
        /// Specifies quantity amount returned if not the full amount from the TradeState, e.g. partial return
        /// </summary>
        public Quantity? Quantity { get; }
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? Date { get; }
    }
    
    /// <summary>
    /// Type for reporting details of calculated rates, including the observations that went into the final reported rate.
    /// </summary>
    public class CalculatedRateDetails : AbstractRosettaModelObject<CalculatedRateDetails>
    {
        private static readonly IRosettaMetaData<CalculatedRateDetails> metaData = new CalculatedRateDetailsMeta();
        
        [JsonConstructor]
        public CalculatedRateDetails(CalculatedRateObservations? observations, IEnumerable<decimal> weightedRates, IEnumerable<decimal> growthFactor, IEnumerable<decimal> compoundedGrowth, decimal? aggregateValue, decimal? aggregateWeight, decimal? calculatedRate)
        {
            Observations = observations;
            WeightedRates = weightedRates;
            GrowthFactor = growthFactor;
            CompoundedGrowth = compoundedGrowth;
            AggregateValue = aggregateValue;
            AggregateWeight = aggregateWeight;
            CalculatedRate = calculatedRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculatedRateDetails> MetaData => metaData;
        
        /// <summary>
        /// The observation dates and weights for each observation date.
        /// </summary>
        public CalculatedRateObservations? Observations { get; }
        
        /// <summary>
        /// The weighted value of each observation.
        /// </summary>
        public IEnumerable<decimal> WeightedRates { get; }
        
        /// <summary>
        /// The daily growth factors, showing the weighted rates divided by the day count basis plus one, giving how much the value grows for each step in the calculation.
        /// </summary>
        public IEnumerable<decimal> GrowthFactor { get; }
        
        /// <summary>
        /// The compounding curve, showing how the initial value grew during the calculation period.
        /// </summary>
        public IEnumerable<decimal> CompoundedGrowth { get; }
        
        /// <summary>
        /// The total sum or product of all the individual terms that went into the calculated rate.
        /// </summary>
        public decimal? AggregateValue { get; }
        
        /// <summary>
        /// The total weight of all the terms that went into the calculated rate.
        /// </summary>
        public decimal? AggregateWeight { get; }
        
        /// <summary>
        /// The resulting calculated weight.
        /// </summary>
        public decimal? CalculatedRate { get; }
    }
    
    /// <summary>
    /// Type for reporting the observations dates and the corresponding weights going into a daily calculated rate
    /// </summary>
    public class CalculatedRateObservationDatesAndWeights : AbstractRosettaModelObject<CalculatedRateObservationDatesAndWeights>
    {
        private static readonly IRosettaMetaData<CalculatedRateObservationDatesAndWeights> metaData = new CalculatedRateObservationDatesAndWeightsMeta();
        
        [JsonConstructor]
        public CalculatedRateObservationDatesAndWeights(IEnumerable<LocalDate> observationDates, IEnumerable<decimal> weights)
        {
            ObservationDates = observationDates;
            Weights = weights;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculatedRateObservationDatesAndWeights> MetaData => metaData;
        
        /// <summary>
        /// The observation date upon which the rate is observed.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public IEnumerable<LocalDate> ObservationDates { get; }
        
        /// <summary>
        /// The corresponding weight for each date.
        /// </summary>
        public IEnumerable<decimal> Weights { get; }
    }
    
    /// <summary>
    /// Type for reporting observations that went into the final reported rate.
    /// </summary>
    public class CalculatedRateObservations : AbstractRosettaModelObject<CalculatedRateObservations>
    {
        private static readonly IRosettaMetaData<CalculatedRateObservations> metaData = new CalculatedRateObservationsMeta();
        
        [JsonConstructor]
        public CalculatedRateObservations(IEnumerable<LocalDate> observationDates, IEnumerable<decimal> weights, IEnumerable<decimal> observedRates, IEnumerable<decimal> processedRates)
        {
            ObservationDates = observationDates;
            Weights = weights;
            ObservedRates = observedRates;
            ProcessedRates = processedRates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculatedRateObservations> MetaData => metaData;
        
        /// <summary>
        /// The observation date upon which the rate is observed.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public IEnumerable<LocalDate> ObservationDates { get; }
        
        /// <summary>
        /// The corresponding weight for each date.
        /// </summary>
        public IEnumerable<decimal> Weights { get; }
        
        /// <summary>
        /// The value observed for that date
        /// </summary>
        public IEnumerable<decimal> ObservedRates { get; }
        
        /// <summary>
        /// The value after any processing, such as application of caps or floors.
        /// </summary>
        public IEnumerable<decimal> ProcessedRates { get; }
    }
    
    /// <summary>
    /// A class defining the ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.
    /// </summary>
    public class CalculationAgent : AbstractRosettaModelObject<CalculationAgent>
    {
        private static readonly IRosettaMetaData<CalculationAgent> metaData = new CalculationAgentMeta();
        
        [JsonConstructor]
        public CalculationAgent(Enums.AncillaryRole? calculationAgentParty, Enums.PartyDetermination? calculationAgentPartyEnum, FieldWithMetaBusinessCenterEnum? calculationAgentBusinessCenter)
        {
            CalculationAgentParty = calculationAgentParty;
            CalculationAgentPartyEnum = calculationAgentPartyEnum;
            CalculationAgentBusinessCenter = calculationAgentBusinessCenter;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationAgent> MetaData => metaData;
        
        /// <summary>
        /// Specifies the party which is the ISDA Calculation Agent for the trade. If more than one party is referenced then the parties are assumed to be co-calculation agents, i.e. they have joint responsibility.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? CalculationAgentParty { get; }
        
        /// <summary>
        /// Specifies the ISDA calculation agent responsible for performing duties as defined in the applicable product definitions. For example, the Calculation Agent may be defined as being the Non-exercising Party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PartyDetermination? CalculationAgentPartyEnum { get; }
        
        /// <summary>
        /// The city in which the office through which ISDA Calculation Agent is acting for purposes of the transaction is located The short-form confirm for a trade that is executed under a Sovereign or Asia Pacific Master Confirmation Agreement ( MCA ), does not need to specify the Calculation Agent. However, the confirm does need to specify the Calculation Agent City. This is due to the fact that the MCA sets the value for Calculation Agent but does not set the value for Calculation Agent City.
        /// </summary>
        public FieldWithMetaBusinessCenterEnum? CalculationAgentBusinessCenter { get; }
    }
    
    /// <summary>
    /// A class to specify Calculation Agent for purposes of Initial or Variation Margin agreements.
    /// </summary>
    public class CalculationAgentTerms : AbstractRosettaModelObject<CalculationAgentTerms>
    {
        private static readonly IRosettaMetaData<CalculationAgentTerms> metaData = new CalculationAgentTermsMeta();
        
        [JsonConstructor]
        public CalculationAgentTerms(Enums.CalculationValuationAgentParty? party, string? bespokeCalculationAgentTerms)
        {
            Party = party;
            BespokeCalculationAgentTerms = bespokeCalculationAgentTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationAgentTerms> MetaData => metaData;
        
        /// <summary>
        /// The party which is specified as Calculation Agent for Initial Margin.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CalculationValuationAgentParty? Party { get; }
        
        /// <summary>
        /// The Calculation Agent (IM) terms when specified.
        /// </summary>
        public string? BespokeCalculationAgentTerms { get; }
    }
    
    /// <summary>
    /// A class to specify the Calculation, Valuation and Timing terms specific to the agreement.
    /// </summary>
    public class CalculationAndTiming : AbstractRosettaModelObject<CalculationAndTiming>
    {
        private static readonly IRosettaMetaData<CalculationAndTiming> metaData = new CalculationAndTimingMeta();
        
        [JsonConstructor]
        public CalculationAndTiming(CalculationAgentTerms? calculationAgentTerms, BespokeCalculationDate? bespokeCalculationDate, BespokeCalculationTime? bespokeCalculationTime, ValuationCalculationDateLocation? calculationDateLocation, NotificationTime notificationTime, string? cashSettlementDay, string? securitiesSettlementDay, CSAValuationDate? valuationDate, ValuationTime? valuationTime, ValuationAgent? valuationAgent, ValuationCalculationDateLocation? valuationDateLocation)
        {
            CalculationAgentTerms = calculationAgentTerms;
            BespokeCalculationDate = bespokeCalculationDate;
            BespokeCalculationTime = bespokeCalculationTime;
            CalculationDateLocation = calculationDateLocation;
            NotificationTime = notificationTime;
            CashSettlementDay = cashSettlementDay;
            SecuritiesSettlementDay = securitiesSettlementDay;
            ValuationDate = valuationDate;
            ValuationTime = valuationTime;
            ValuationAgent = valuationAgent;
            ValuationDateLocation = valuationDateLocation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationAndTiming> MetaData => metaData;
        
        /// <summary>
        /// The calculation agent terms applicable to the agreement.
        /// </summary>
        public CalculationAgentTerms? CalculationAgentTerms { get; }
        
        /// <summary>
        /// The specification of bespoke Calculation Date terms for the purposes of Initial or Variation Margin by the parties to the agreement.
        /// </summary>
        public BespokeCalculationDate? BespokeCalculationDate { get; }
        
        /// <summary>
        /// Bespoke terms to describe the time as of which such party (or the Calculation Agent (IM) (if applicale)) computes its end of day valuations of derivatives transactions.
        /// </summary>
        public BespokeCalculationTime? BespokeCalculationTime { get; }
        
        /// <summary>
        /// The specified location where the credit exposure will be calculated by the respective parties.
        /// </summary>
        public ValuationCalculationDateLocation? CalculationDateLocation { get; }
        
        /// <summary>
        /// The time by which a demand for the Transfer of Eligible Credit Support (IM) or Posted Credit Support (IM) needs to be made in order for the transfer to take place in accordance with the Transfer Timing provisions.
        /// </summary>
        public NotificationTime NotificationTime { get; }
        
        public string? CashSettlementDay { get; }
        
        public string? SecuritiesSettlementDay { get; }
        
        /// <summary>
        /// Details of the days on which calculations are to be made to determine the Delivery Amount and/or Return Amount.
        /// </summary>
        public CSAValuationDate? ValuationDate { get; }
        
        /// <summary>
        /// Specifies the time on which the value of collateral or exposure are calculated in accordance with the agreement.
        /// </summary>
        public ValuationTime? ValuationTime { get; }
        
        /// <summary>
        /// Details of the party calculating the value of collateral to be delivered or returned.
        /// </summary>
        public ValuationAgent? ValuationAgent { get; }
        
        /// <summary>
        /// The specified location where the credit exposure will be calculated by the respective parties.
        /// </summary>
        public ValuationCalculationDateLocation? ValuationDateLocation { get; }
    }
    
    /// <summary>
    /// A class to specify the ISDA SIMM Calculation Currency.
    /// </summary>
    public class CalculationCurrencyElection : AbstractRosettaModelObject<CalculationCurrencyElection>
    {
        private static readonly IRosettaMetaData<CalculationCurrencyElection> metaData = new CalculationCurrencyElectionMeta();
        
        [JsonConstructor]
        public CalculationCurrencyElection(Enums.CounterpartyRole party, bool isBaseCurrency, FieldWithMetaString? currency)
        {
            Party = party;
            IsBaseCurrency = isBaseCurrency;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationCurrencyElection> MetaData => metaData;
        
        /// <summary>
        /// The party which the SIMM Calculation Currency qualification applies to.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The SIMM Calculation Currency (also known as SIMM Reporting Currency) means the Base Currency when True. It means a different currency when False. In that latter case, the SIMM Calculation Currency is specified as part of the currency attribute.
        /// </summary>
        public bool IsBaseCurrency { get; }
        
        /// <summary>
        /// The currency in which the ISDA SIMM Calculation is denominated, when different from the Base Currency. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
    }
    
    /// <summary>
    /// Represents the parameters for describing how often something (such as collateral interest) is to be calculated.
    /// </summary>
    public class CalculationFrequency : AbstractRosettaModelObject<CalculationFrequency>
    {
        private static readonly IRosettaMetaData<CalculationFrequency> metaData = new CalculationFrequencyMeta();
        
        [JsonConstructor]
        public CalculationFrequency(Period period, decimal? monthOfYear, decimal? dayOfMonth, Enums.DayOfWeek? dayOfWeek, decimal? weekOfMonth, decimal offsetDays, BusinessCenterTime dateLocation, IEnumerable<Enums.BusinessCenter> businessCenter)
        {
            Period = period;
            MonthOfYear = monthOfYear;
            DayOfMonth = dayOfMonth;
            DayOfWeek = dayOfWeek;
            WeekOfMonth = weekOfMonth;
            OffsetDays = offsetDays;
            DateLocation = dateLocation;
            BusinessCenter = businessCenter;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationFrequency> MetaData => metaData;
        
        /// <summary>
        /// Specifies the time period at which calculation is performed, e.g. 1 month.
        /// </summary>
        public Period Period { get; }
        
        /// <summary>
        /// Specifies the month of the year if used.
        /// </summary>
        public decimal? MonthOfYear { get; }
        
        /// <summary>
        /// Specifies the day of the month if used.
        /// </summary>
        public decimal? DayOfMonth { get; }
        
        /// <summary>
        /// Specifies the day of the week if used.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayOfWeek? DayOfWeek { get; }
        
        /// <summary>
        /// Specifies the week of the month if used.
        /// </summary>
        public decimal? WeekOfMonth { get; }
        
        /// <summary>
        /// Specifies how many days from the trigger event should the payment occur.
        /// </summary>
        public decimal OffsetDays { get; }
        
        /// <summary>
        /// Specifies where is the time measured.
        /// </summary>
        public BusinessCenterTime DateLocation { get; }
        
        /// <summary>
        /// Specifies the business center for adjustment of calculation period.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.BusinessCenter> BusinessCenter { get; }
    }
    
    /// <summary>
    /// A data defining:  the parameters used in the calculation of a fixed or floating rate calculation period amount. This data forms:  part of cashflows representation of a swap stream.
    /// </summary>
    public class CalculationPeriod : AbstractRosettaModelObject<CalculationPeriod>, ICalculationPeriodBase
    {
        private static readonly IRosettaMetaData<CalculationPeriod> metaData = new CalculationPeriodMeta();
        
        [JsonConstructor]
        public CalculationPeriod(LocalDate? adjustedStartDate, LocalDate? adjustedEndDate, _MetaFields? meta, LocalDate? unadjustedStartDate, LocalDate? unadjustedEndDate, int? calculationPeriodNumberOfDays, decimal? notionalAmount, FxLinkedNotionalAmount? fxLinkedNotionalAmount, FloatingRateDefinition? floatingRateDefinition, decimal? fixedRate, decimal? dayCountYearFraction, Money? forecastAmount, decimal? forecastRate)
        {
            AdjustedStartDate = adjustedStartDate;
            AdjustedEndDate = adjustedEndDate;
            Meta = meta;
            UnadjustedStartDate = unadjustedStartDate;
            UnadjustedEndDate = unadjustedEndDate;
            CalculationPeriodNumberOfDays = calculationPeriodNumberOfDays;
            NotionalAmount = notionalAmount;
            FxLinkedNotionalAmount = fxLinkedNotionalAmount;
            FloatingRateDefinition = floatingRateDefinition;
            FixedRate = fixedRate;
            DayCountYearFraction = dayCountYearFraction;
            ForecastAmount = forecastAmount;
            ForecastRate = forecastRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriod> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedStartDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedEndDate { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The calculation start date, unadjusted.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedStartDate { get; }
        
        /// <summary>
        /// The calculation end date, unadjusted.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedEndDate { get; }
        
        /// <summary>
        /// The number of days from the adjusted effective / start date to the adjusted termination / end date calculated in accordance with the applicable day count fraction.
        /// </summary>
        public int? CalculationPeriodNumberOfDays { get; }
        
        /// <summary>
        /// The amount that a cashflow will accrue interest on.
        /// </summary>
        public decimal? NotionalAmount { get; }
        
        /// <summary>
        /// The amount that a cashflow will accrue interest on. This is the calculated amount of the FX linked - i.e. the other currency notional amount multiplied by the appropriate FX spot rate.
        /// </summary>
        public FxLinkedNotionalAmount? FxLinkedNotionalAmount { get; }
        
        /// <summary>
        /// The floating rate reset information for the calculation period.
        /// </summary>
        public FloatingRateDefinition? FloatingRateDefinition { get; }
        
        /// <summary>
        /// The calculation period fixed rate. A per annum rate, expressed as a decimal. A fixed rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal? FixedRate { get; }
        
        /// <summary>
        /// The year fraction value of the calculation period, result of applying the ISDA rules for day count fraction defined in the ISDA Annex.
        /// </summary>
        public decimal? DayCountYearFraction { get; }
        
        /// <summary>
        /// The amount representing the forecast of the accrued value of the calculation period. An intermediate value used to generate the forecastPaymentAmount in the PaymentCalculationPeriod.
        /// </summary>
        public Money? ForecastAmount { get; }
        
        /// <summary>
        /// A value representing the forecast rate used to calculate the forecast future value of the accrual period. This is a calculated rate determined based on averaging the rates in the rateObservation elements, and incorporates all of the rate treatment and averaging rules. A value of 1% should be represented as 0.01.
        /// </summary>
        public decimal? ForecastRate { get; }
    }
    
    /// <summary>
    /// The calculation period adjusted start and end dates, which are the baseline arguments needed to compute an interest accrual calculation.
    /// </summary>
    public class CalculationPeriodBase : AbstractRosettaModelObject<CalculationPeriodBase>, ICalculationPeriodBase
    {
        private static readonly IRosettaMetaData<CalculationPeriodBase> metaData = new CalculationPeriodBaseMeta();
        
        [JsonConstructor]
        public CalculationPeriodBase(LocalDate? adjustedStartDate, LocalDate? adjustedEndDate, _MetaFields? meta)
        {
            AdjustedStartDate = adjustedStartDate;
            AdjustedEndDate = adjustedEndDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriodBase> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedStartDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedEndDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    public class CalculationPeriodData : AbstractRosettaModelObject<CalculationPeriodData>
    {
        private static readonly IRosettaMetaData<CalculationPeriodData> metaData = new CalculationPeriodDataMeta();
        
        [JsonConstructor]
        public CalculationPeriodData(LocalDate startDate, LocalDate endDate, int daysInPeriod, int daysInLeapYearPeriod, bool isFirstPeriod, bool isLastPeriod)
        {
            StartDate = startDate;
            EndDate = endDate;
            DaysInPeriod = daysInPeriod;
            DaysInLeapYearPeriod = daysInLeapYearPeriod;
            IsFirstPeriod = isFirstPeriod;
            IsLastPeriod = isLastPeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriodData> MetaData => metaData;
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StartDate { get; }
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EndDate { get; }
        
        public int DaysInPeriod { get; }
        
        public int DaysInLeapYearPeriod { get; }
        
        public bool IsFirstPeriod { get; }
        
        public bool IsLastPeriod { get; }
    }
    
    /// <summary>
    /// A data for:  defining the parameters used to generate the calculation period dates schedule, including the specification of any initial or final stub calculation periods. A calculation period schedule consists of an optional initial stub calculation period, one or more regular calculation periods and an optional final stub calculation period. In the absence of any initial or final stub calculation periods, the regular part of the calculation period schedule is assumed to be between the effective date and the termination date. No implicit stubs are allowed, i.e. stubs must be explicitly specified using an appropriate combination of firstPeriodStartDate, firstRegularPeriodStartDate and lastRegularPeriodEndDate.
    /// </summary>
    public class CalculationPeriodDates : AbstractRosettaModelObject<CalculationPeriodDates>
    {
        private static readonly IRosettaMetaData<CalculationPeriodDates> metaData = new CalculationPeriodDatesMeta();
        
        [JsonConstructor]
        public CalculationPeriodDates(AdjustableOrRelativeDate? effectiveDate, AdjustableOrRelativeDate? terminationDate, BusinessDayAdjustments? calculationPeriodDatesAdjustments, AdjustableOrRelativeDate? firstPeriodStartDate, LocalDate? firstRegularPeriodStartDate, LocalDate? firstCompoundingPeriodEndDate, LocalDate? lastRegularPeriodEndDate, Enums.StubPeriodType? stubPeriodType, CalculationPeriodFrequency? calculationPeriodFrequency, _MetaFields? meta)
        {
            EffectiveDate = effectiveDate;
            TerminationDate = terminationDate;
            CalculationPeriodDatesAdjustments = calculationPeriodDatesAdjustments;
            FirstPeriodStartDate = firstPeriodStartDate;
            FirstRegularPeriodStartDate = firstRegularPeriodStartDate;
            FirstCompoundingPeriodEndDate = firstCompoundingPeriodEndDate;
            LastRegularPeriodEndDate = lastRegularPeriodEndDate;
            StubPeriodType = stubPeriodType;
            CalculationPeriodFrequency = calculationPeriodFrequency;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriodDates> MetaData => metaData;
        
        /// <summary>
        /// The first day of the terms of the trade. This day may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        public AdjustableOrRelativeDate? EffectiveDate { get; }
        
        /// <summary>
        /// The last day of the terms of the trade. This date may be subject to adjustments in accordance with the business day convention. It can also be specified in relation to another scheduled date (e.g. the last payment date).
        /// </summary>
        public AdjustableOrRelativeDate? TerminationDate { get; }
        
        /// <summary>
        /// The specification of the business day convention and financial business centers used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.
        /// </summary>
        public BusinessDayAdjustments? CalculationPeriodDatesAdjustments { get; }
        
        /// <summary>
        /// The start date of the calculation period. FpML specifies that for interest rate swaps this date must only be specified if it is not equal to the effective date. It is always specified in the case of equity swaps and credit default swaps with periodic payments. This date may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        public AdjustableOrRelativeDate? FirstPeriodStartDate { get; }
        
        /// <summary>
        /// The start date of the regular part of the calculation period schedule. It must only be specified if there is an initial stub calculation period. This day may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? FirstRegularPeriodStartDate { get; }
        
        /// <summary>
        /// The end date of the initial compounding period when compounding is applicable. It must only be specified when the compoundingMethod element is present and not equal to a value of None. This date may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? FirstCompoundingPeriodEndDate { get; }
        
        /// <summary>
        /// The end date of the regular part of the calculation period schedule. It must only be specified if there is a final stub calculation period. This day may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? LastRegularPeriodEndDate { get; }
        
        /// <summary>
        /// Method to allocate any irregular period remaining after regular periods have been allocated between the effective and termination date.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.StubPeriodType? StubPeriodType { get; }
        
        /// <summary>
        /// The frequency at which calculation period end dates occur with the regular part of the calculation period schedule and their roll date convention.
        /// </summary>
        public CalculationPeriodFrequency? CalculationPeriodFrequency { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class to specify the frequency at which calculation period end dates occur within the regular part of the calculation period schedule and their roll date convention.
    /// </summary>
    public class CalculationPeriodFrequency : AbstractRosettaModelObject<CalculationPeriodFrequency>, IFrequency
    {
        private static readonly IRosettaMetaData<CalculationPeriodFrequency> metaData = new CalculationPeriodFrequencyMeta();
        
        [JsonConstructor]
        public CalculationPeriodFrequency(int periodMultiplier, Enums.PeriodExtended period, _MetaFields? meta, Enums.RollConvention rollConvention, bool? balanceOfFirstPeriod)
        {
            PeriodMultiplier = periodMultiplier;
            Period = period;
            Meta = meta;
            RollConvention = rollConvention;
            BalanceOfFirstPeriod = balanceOfFirstPeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationPeriodFrequency> MetaData => metaData;
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PeriodExtended Period { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// The roll convention specifies the period term as part of a periodic schedule, i.e. the calculation period end date within the regular part of the calculation period. The value could be a rule, e.g. IMM Settlement Dates, which is the 3rd Wednesday of the month, or it could be a specific day of the month, such as the first day of the applicable month. It is used in conjunction with a frequency and the regular period start date of a calculation period.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RollConvention RollConvention { get; }
        
        /// <summary>
        /// Indicates, when true, that that the first Calculation Period should run from the Effective Date to the end of the calendar period in which the Effective Date falls, e.g. Jan 15 - Jan 31 if the calculation periods are one month long and Effective Date is Jan 15. If false, the first Calculation Period should run from the Effective Date for one whole period, e.g. Jan 15 to Feb 14 if the calculation periods are one month long and Effective Date is Jan 15. Mostly used in Commmodity Swaps.
        /// </summary>
        public bool? BalanceOfFirstPeriod { get; }
    }
    
    /// <summary>
    /// A class that allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
    /// </summary>
    public class CalculationSchedule : AbstractRosettaModelObject<CalculationSchedule>
    {
        private static readonly IRosettaMetaData<CalculationSchedule> metaData = new CalculationScheduleMeta();
        
        [JsonConstructor]
        public CalculationSchedule(IEnumerable<SchedulePeriod> schedulePeriod)
        {
            SchedulePeriod = schedulePeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationSchedule> MetaData => metaData;
        
        /// <summary>
        /// Defines a period of a calculation schedule structure.
        /// </summary>
        public IEnumerable<SchedulePeriod> SchedulePeriod { get; }
    }
    
    /// <summary>
    /// Period and time profile over which the delivery takes place.
    /// </summary>
    public class CalculationScheduleDeliveryPeriods : AbstractRosettaModelObject<CalculationScheduleDeliveryPeriods>, IAssetDeliveryPeriods
    {
        private static readonly IRosettaMetaData<CalculationScheduleDeliveryPeriods> metaData = new CalculationScheduleDeliveryPeriodsMeta();
        
        [JsonConstructor]
        public CalculationScheduleDeliveryPeriods(IEnumerable<AssetDeliveryProfile> profile, LocalDate? startDate, LocalDate? endDate, Quantity? deliveryCapacity, Price? priceTimeIntervalQuantity)
        {
            Profile = profile;
            StartDate = startDate;
            EndDate = endDate;
            DeliveryCapacity = deliveryCapacity;
            PriceTimeIntervalQuantity = priceTimeIntervalQuantity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalculationScheduleDeliveryPeriods> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetDeliveryProfile> Profile { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? StartDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EndDate { get; }
        
        /// <summary>
        /// The number of units included in the transaction for each delivery interval
        /// </summary>
        public Quantity? DeliveryCapacity { get; }
        
        /// <summary>
        /// Price per quantity per delivery time interval.
        /// </summary>
        public Price? PriceTimeIntervalQuantity { get; }
    }
    
    /// <summary>
    /// A type for defining a calendar spread feature.
    /// </summary>
    public class CalendarSpread : AbstractRosettaModelObject<CalendarSpread>
    {
        private static readonly IRosettaMetaData<CalendarSpread> metaData = new CalendarSpreadMeta();
        
        [JsonConstructor]
        public CalendarSpread(AdjustableOrRelativeDate expirationDateTwo)
        {
            ExpirationDateTwo = expirationDateTwo;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CalendarSpread> MetaData => metaData;
        
        public AdjustableOrRelativeDate ExpirationDateTwo { get; }
    }
    
    /// <summary>
    /// A data defining:  the right of a party to cancel a swap transaction on the specified exercise dates. The provision is for &apos;walk-away&apos; cancellation (i.e. the fair value of the swap is not paid). A fee payable on exercise can be specified. As a difference from the FpML construct, the canonical model extends the BuyerSeller class.
    /// </summary>
    public class CancelableProvision : AbstractRosettaModelObject<CancelableProvision>, IBuyerSeller
    {
        private static readonly IRosettaMetaData<CancelableProvision> metaData = new CancelableProvisionMeta();
        
        [JsonConstructor]
        public CancelableProvision(Enums.CounterpartyRole buyer, Enums.CounterpartyRole seller, ExerciseNotice? exerciseNotice, bool followUpConfirmation, CancelableProvisionAdjustedDates? cancelableProvisionAdjustedDates, IEnumerable<FinalCalculationPeriodDateAdjustment> finalCalculationPeriodDateAdjustment, Transfer? initialFee, Enums.CallingParty? callingParty, AdjustableOrRelativeDate? earliestDate, AdjustableOrRelativeDate? expirationDate, AdjustableOrRelativeDates? effectiveDate, Period? effectivePeriod, BusinessCenterTime? earliestCancellationTime, BusinessCenterTime? latestCancelationTime, ExerciseTerms exerciseTerms)
        {
            Buyer = buyer;
            Seller = seller;
            ExerciseNotice = exerciseNotice;
            FollowUpConfirmation = followUpConfirmation;
            CancelableProvisionAdjustedDates = cancelableProvisionAdjustedDates;
            FinalCalculationPeriodDateAdjustment = finalCalculationPeriodDateAdjustment;
            InitialFee = initialFee;
            CallingParty = callingParty;
            EarliestDate = earliestDate;
            ExpirationDate = expirationDate;
            EffectiveDate = effectiveDate;
            EffectivePeriod = effectivePeriod;
            EarliestCancellationTime = earliestCancellationTime;
            LatestCancelationTime = latestCancelationTime;
            ExerciseTerms = exerciseTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CancelableProvision> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Buyer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Seller { get; }
        
        /// <summary>
        /// Definition of the party to whom notice of exercise should be given.
        /// </summary>
        public ExerciseNotice? ExerciseNotice { get; }
        
        /// <summary>
        /// A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public bool FollowUpConfirmation { get; }
        
        /// <summary>
        /// The adjusted dates associated with a cancelable provision. These dates have been adjusted for any applicable business day convention.
        /// </summary>
        public CancelableProvisionAdjustedDates? CancelableProvisionAdjustedDates { get; }
        
        /// <summary>
        /// Business date convention adjustment to final payment period per leg (swapStream) upon exercise event. The adjustments can be made in-line with leg level BDC&apos;s or they can be specified separately.
        /// </summary>
        public IEnumerable<FinalCalculationPeriodDateAdjustment> FinalCalculationPeriodDateAdjustment { get; }
        
        /// <summary>
        /// An initial fee for the cancelable option.
        /// </summary>
        public Transfer? InitialFee { get; }
        
        /// <summary>
        /// The party with right to exercise a cancellation. Allows for buyer, seller or either.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CallingParty? CallingParty { get; }
        
        /// <summary>
        /// The first day when cancelation is permitted to take effect. A party may give notice prior to this date and taken together with the effective period would be necessary to cancel on this date.
        /// </summary>
        public AdjustableOrRelativeDate? EarliestDate { get; }
        
        /// <summary>
        /// The last day within the term of the contract that cancelation is allowed.
        /// </summary>
        public AdjustableOrRelativeDate? ExpirationDate { get; }
        
        /// <summary>
        /// The effective date if cancelation is invoked otherwise the cancellation period defines the cancellation date.
        /// </summary>
        public AdjustableOrRelativeDates? EffectiveDate { get; }
        
        /// <summary>
        /// Effective period for cancelation when notice is given. This is the period after notice is given that cancellation becomes effecticve.
        /// </summary>
        public Period? EffectivePeriod { get; }
        
        /// <summary>
        /// The earliest time in a business day that notice of cancelation can be given.
        /// </summary>
        public BusinessCenterTime? EarliestCancellationTime { get; }
        
        /// <summary>
        /// The latest time at which notice of cancelation can be given.
        /// </summary>
        public BusinessCenterTime? LatestCancelationTime { get; }
        
        /// <summary>
        /// The exercise terms associated with the cancelable provision, including details such as exercise style, exercise fees, and any other relevant conditions or terms governing the cancellation of the swap transaction.
        /// </summary>
        public ExerciseTerms ExerciseTerms { get; }
    }
    
    /// <summary>
    /// A data to:  define the adjusted dates for a cancelable provision on a swap transaction.
    /// </summary>
    public class CancelableProvisionAdjustedDates : AbstractRosettaModelObject<CancelableProvisionAdjustedDates>
    {
        private static readonly IRosettaMetaData<CancelableProvisionAdjustedDates> metaData = new CancelableProvisionAdjustedDatesMeta();
        
        [JsonConstructor]
        public CancelableProvisionAdjustedDates(IEnumerable<CancellationEvent> cancellationEvent)
        {
            CancellationEvent = cancellationEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CancelableProvisionAdjustedDates> MetaData => metaData;
        
        /// <summary>
        /// The adjusted dates for an individual cancellation date.
        /// </summary>
        public IEnumerable<CancellationEvent> CancellationEvent { get; }
    }
    
    /// <summary>
    /// The adjusted dates for a specific cancellation date, including the adjusted exercise date and adjusted termination date.
    /// </summary>
    public class CancellationEvent : AbstractRosettaModelObject<CancellationEvent>
    {
        private static readonly IRosettaMetaData<CancellationEvent> metaData = new CancellationEventMeta();
        
        [JsonConstructor]
        public CancellationEvent(LocalDate adjustedExerciseDate, LocalDate adjustedEarlyTerminationDate, _MetaFields? meta)
        {
            AdjustedExerciseDate = adjustedExerciseDate;
            AdjustedEarlyTerminationDate = adjustedEarlyTerminationDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CancellationEvent> MetaData => metaData;
        
        /// <summary>
        /// The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExerciseDate { get; }
        
        /// <summary>
        /// The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedEarlyTerminationDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// An Asset that consists solely of a monetary holding in a currency. The currency of the Cash asset is held in the string Identifier (from AssetBase) and the AssetIdTypeEnum must be set to define that a CurrencyCode is set.  The function SetCashCurrency can be used to create (or update) a Cash object and the function GetCashCurrency can be used to retrieve the currency of a Cash object.
    /// </summary>
    public class Cash : AbstractRosettaModelObject<Cash>, IAssetBase
    {
        private static readonly IRosettaMetaData<Cash> metaData = new CashMeta();
        
        [JsonConstructor]
        public Cash(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Cash> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
    }
    
    /// <summary>
    /// This type is a generic structure that can represent the parameters of several mid-market valuation and replacement value methods described in the 2021 ISDA Definitions.
    /// </summary>
    public class CashCollateralValuationMethod : AbstractRosettaModelObject<CashCollateralValuationMethod>
    {
        private static readonly IRosettaMetaData<CashCollateralValuationMethod> metaData = new CashCollateralValuationMethodMeta();
        
        [JsonConstructor]
        public CashCollateralValuationMethod(Enums.CsaType? applicableCsa, string? cashCollateralCurrency, FieldWithMetaString? cashCollateralInterestRate, FieldWithMetaString? agreedDiscountRate, IEnumerable<Enums.PartyDetermination> protectedParty, bool? prescribedDocumentationAdjustment)
        {
            ApplicableCsa = applicableCsa;
            CashCollateralCurrency = cashCollateralCurrency;
            CashCollateralInterestRate = cashCollateralInterestRate;
            AgreedDiscountRate = agreedDiscountRate;
            ProtectedParty = protectedParty;
            PrescribedDocumentationAdjustment = prescribedDocumentationAdjustment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashCollateralValuationMethod> MetaData => metaData;
        
        /// <summary>
        /// This may be used to specify what type of CSA (credit support annex/agreement) is to be used for cash settlement purposes.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CsaType? ApplicableCsa { get; }
        
        /// <summary>
        /// This may be used to indicate the currency of cash collateral for cash settlement purposes.
        /// </summary>
        public string? CashCollateralCurrency { get; }
        
        /// <summary>
        /// This may be used to indicate the interest rate to be used for cash collateral for cash settlement purposes.
        /// </summary>
        public FieldWithMetaString? CashCollateralInterestRate { get; }
        
        /// <summary>
        /// This may be used to indicate the discount rate to be used for cash collateral for cash settlement purposes.
        /// </summary>
        public FieldWithMetaString? AgreedDiscountRate { get; }
        
        /// <summary>
        /// This may be used to specify which party is protected (e.g. under Replacement Value cash settlement methods).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.PartyDetermination> ProtectedParty { get; }
        
        /// <summary>
        /// This may be used to indicate that &apos;prescribed documentation adjustment&apos; is applicable.
        /// </summary>
        public bool? PrescribedDocumentationAdjustment { get; }
    }
    
    /// <summary>
    /// Specifies the nature of a cash price either as a fee type, cash price type, or premium expression.
    /// </summary>
    public class CashPrice : AbstractRosettaModelObject<CashPrice>
    {
        private static readonly IRosettaMetaData<CashPrice> metaData = new CashPriceMeta();
        
        [JsonConstructor]
        public CashPrice(Enums.CashPriceType cashPriceType, PremiumExpression? premiumExpression, Enums.FeeType? feeType)
        {
            CashPriceType = cashPriceType;
            PremiumExpression = premiumExpression;
            FeeType = feeType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashPrice> MetaData => metaData;
        
        /// <summary>
        /// Specifies the type of Cash Price.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CashPriceType CashPriceType { get; }
        
        /// <summary>
        /// Specifies a premium when expressed in a way other than an amount, and any required forward starting price definition.
        /// </summary>
        public PremiumExpression? PremiumExpression { get; }
        
        /// <summary>
        /// Specifies the event type associated with a fee.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FeeType? FeeType { get; }
    }
    
    /// <summary>
    /// Defines the terms required to compute and settle a cash settlement amount according to a fixing value, including the fixing source, fixing method and fixing date. In FpML, PhysicalSettlementTerms and CashSettlementTerms extend SettlementTerms. In the CDM, this extension paradigm has not been used because SettlementTerms class has been used for purposes related to securities transactions, while it is not used as such in the FpML standard (i.e. only as an abstract construct.
    /// </summary>
    public class CashSettlementTerms : AbstractRosettaModelObject<CashSettlementTerms>
    {
        private static readonly IRosettaMetaData<CashSettlementTerms> metaData = new CashSettlementTermsMeta();
        
        [JsonConstructor]
        public CashSettlementTerms(Enums.CashSettlementMethod? cashSettlementMethod, ValuationMethod? valuationMethod, ValuationDate? valuationDate, BusinessCenterTime? valuationTime, Money? cashSettlementAmount, decimal? recoveryFactor, bool? fixedSettlement, bool? accruedInterest, _MetaFields? meta)
        {
            CashSettlementMethod = cashSettlementMethod;
            ValuationMethod = valuationMethod;
            ValuationDate = valuationDate;
            ValuationTime = valuationTime;
            CashSettlementAmount = cashSettlementAmount;
            RecoveryFactor = recoveryFactor;
            FixedSettlement = fixedSettlement;
            AccruedInterest = accruedInterest;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashSettlementTerms> MetaData => metaData;
        
        /// <summary>
        /// Specifies the type of cash settlement method: cash price, yield curve etc.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CashSettlementMethod? CashSettlementMethod { get; }
        
        /// <summary>
        /// Specifies the parameters required to obtain a valuation, including the source, quotation method (bid, mid etc.) and any applicable quotation amount.
        /// </summary>
        public ValuationMethod? ValuationMethod { get; }
        
        /// <summary>
        /// Defines the different methods to specify a valuation date, as used for cash settlement. The Single / Multiple ValuationDate is used for the determination of recovery in a credit event, the RelativeDateOffset is used for cash-settled option, and FxFixingDate is used for cross-currency settlement.
        /// </summary>
        public ValuationDate? ValuationDate { get; }
        
        /// <summary>
        /// The time of the cash settlement valuation date when the cash settlement amount will be determined according to the cash settlement method, if the parties have not otherwise been able to agree the cash settlement amount. When using quations, this is the time of day in the specified business center when the calculation agent seeks quotations for an amount of the reference obligation for purposes of cash settlement. ISDA 2003 Term: Valuation Time.
        /// </summary>
        public BusinessCenterTime? ValuationTime { get; }
        
        /// <summary>
        /// The amount paid by the seller to the buyer for cash settlement on the cash settlement date. If not otherwise specified, would typically be calculated as 100 (or the Reference Price) minus the price of the Reference Obligation (all expressed as a percentage) times Floating Rate Payer Calculation Amount. ISDA 2003 Term: Cash Settlement Amount.
        /// </summary>
        public Money? CashSettlementAmount { get; }
        
        /// <summary>
        /// Used for fixed recovery, specifies the recovery level, determined at contract formation, to be applied on a default. Used to calculate the amount paid by the seller to the buyer for cash settlement on the cash settlement date. Amount calculation is (1 minus the Recovery Factor) multiplied by the Floating Rate Payer Calculation Amount. The currency will be derived from the Floating Rate Payer Calculation Amount.
        /// </summary>
        public decimal? RecoveryFactor { get; }
        
        /// <summary>
        /// Used for Recovery Lock, to indicate whether fixed Settlement is Applicable or Not Applicable. If Buyer fails to deliver an effective Notice of Physical Settlement on or before the Buyer NOPS Cut-off Date, and if Seller fails to deliver an effective Seller NOPS on or before the Seller NOPS Cut-off Date, then either: (a) if Fixed Settlement is specified in the related Confirmation as not applicable, then the Seller NOPS Cut-off Date shall be the Termination Date; or (b) if Fixed Settlement is specified in the related Confirmation as applicable, then: (i) if the Fixed Settlement Amount is a positive number, Seller shall, subject to Section 3.1 (except for the requirement of satisfaction of the Notice of Physical Settlement Condition to Settlement), pay the Fixed Settlement Amount to Buyer on the Fixed Settlement Payment Date; and (ii) if the Fixed Settlement Amount is a negative number, Buyer shall, subject to Section 3.1 (except for the requirement of satisfaction of the Notice of Physical Settlement Condition to Settlement), pay the absolute value of the Fixed Settlement Amount to Seller on the Fixed Settlement Payment Date.
        /// </summary>
        public bool? FixedSettlement { get; }
        
        /// <summary>
        /// Indicates whether accrued interest is included (true) or not (false). For cash settlement this specifies whether quotations should be obtained inclusive or not of accrued interest. For physical settlement this specifies whether the buyer should deliver the obligation with an outstanding principal balance that includes or excludes accrued interest. ISDA 2003 Term: Include/Exclude Accrued Interest.
        /// </summary>
        public bool? AccruedInterest { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Class to specify a cashflow, i.e. the outcome of either of computation (e.g. interest accrual) or an assessment of some sort (e.g. a fee). The cashflow can then be turned into a cash transfer, artefact to be used as the input to a payment system or the outcome of it. The associated globalKey denotes the ability to associate a hash value to the Cashflow instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class Cashflow : AbstractRosettaModelObject<Cashflow>, IAssetFlowBase
    {
        private static readonly IRosettaMetaData<Cashflow> metaData = new CashflowMeta();
        
        [JsonConstructor]
        public Cashflow(NonNegativeQuantity quantity, Asset asset, AdjustableOrAdjustedOrRelativeDate settlementDate, PayerReceiver payerReceiver, CashflowType cashflowType, PaymentDiscounting? paymentDiscounting)
        {
            Quantity = quantity;
            Asset = asset;
            SettlementDate = settlementDate;
            PayerReceiver = payerReceiver;
            CashflowType = cashflowType;
            PaymentDiscounting = paymentDiscounting;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Cashflow> MetaData => metaData;
        
        /// <inheritdoc/>
        public NonNegativeQuantity Quantity { get; }
        
        /// <inheritdoc/>
        public Asset Asset { get; }
        
        /// <inheritdoc/>
        public AdjustableOrAdjustedOrRelativeDate SettlementDate { get; }
        
        /// <summary>
        /// Specifies who pays / receives the cashflow, though a normalised Party1 / Party2 enumerator.
        /// </summary>
        public PayerReceiver PayerReceiver { get; }
        
        /// <summary>
        /// The qualification of the type of cashflow, e.g. brokerage fee, premium, upfront fee etc. Particularly relevant when it cannot be inferred directly through lineage.
        /// </summary>
        public CashflowType CashflowType { get; }
        
        /// <summary>
        /// FpML specifies the FpML PaymentDiscounting.model group for representing the discounting elements that can be associated with a payment.
        /// </summary>
        public PaymentDiscounting? PaymentDiscounting { get; }
    }
    
    /// <summary>
    /// A data defining:  the cashflow representation of a swap trade.
    /// </summary>
    public class CashflowRepresentation : AbstractRosettaModelObject<CashflowRepresentation>
    {
        private static readonly IRosettaMetaData<CashflowRepresentation> metaData = new CashflowRepresentationMeta();
        
        [JsonConstructor]
        public CashflowRepresentation(bool cashflowsMatchParameters, IEnumerable<PaymentCalculationPeriod> paymentCalculationPeriod)
        {
            CashflowsMatchParameters = cashflowsMatchParameters;
            PaymentCalculationPeriod = paymentCalculationPeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashflowRepresentation> MetaData => metaData;
        
        /// <summary>
        /// A true/false flag to indicate whether the cashflows match the parametric definition of the stream, i.e. whether the cashflows could be regenerated from the parameters without loss of information.
        /// </summary>
        public bool CashflowsMatchParameters { get; }
        
        /// <summary>
        /// The adjusted payment date and associated calculation period parameters required to calculate the actual or projected payment amount. A list of payment calculation period elements may be ordered in the document by ascending adjusted payment date. An FpML document containing an unordered list of payment calculation periods is still regarded as a conformant document.
        /// </summary>
        public IEnumerable<PaymentCalculationPeriod> PaymentCalculationPeriod { get; }
    }
    
    /// <summary>
    /// Characterises the type of cashflow, which can result from either a scheduled or a non-scheduled lifecycle event.
    /// </summary>
    public class CashflowType : AbstractRosettaModelObject<CashflowType>
    {
        private static readonly IRosettaMetaData<CashflowType> metaData = new CashflowTypeMeta();
        
        [JsonConstructor]
        public CashflowType(Enums.ScheduledTransfer? cashflowType, CashPrice? cashPrice, Enums.PriceExpression? priceExpression)
        {
            CashflowTypeValue = cashflowType;
            CashPrice = cashPrice;
            PriceExpression = priceExpression;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CashflowType> MetaData => metaData;
        
        /// <summary>
        /// Type of cashflow corresponding to a scheduled event.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "cashflowType")]
        public Enums.ScheduledTransfer? CashflowTypeValue { get; }
        
        /// <summary>
        /// Type of cashflow corresponding to a non-scheduled event, where a price must be agreed between the parties.
        /// </summary>
        public CashPrice? CashPrice { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PriceExpression? PriceExpression { get; }
    }
    
    /// <summary>
    /// Result for the CheckEligibilityByDetails and CheckEligibilityForProduct functions
    /// </summary>
    public class CheckEligibilityResult : AbstractRosettaModelObject<CheckEligibilityResult>
    {
        private static readonly IRosettaMetaData<CheckEligibilityResult> metaData = new CheckEligibilityResultMeta();
        
        [JsonConstructor]
        public CheckEligibilityResult(bool isEligible, IEnumerable<EligibleCollateralCriteria> matchingEligibleCriteria, EligibilityQuery eligibilityQuery, EligibleCollateralSpecification specification)
        {
            IsEligible = isEligible;
            MatchingEligibleCriteria = matchingEligibleCriteria;
            EligibilityQuery = eligibilityQuery;
            Specification = specification;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CheckEligibilityResult> MetaData => metaData;
        
        /// <summary>
        /// a simple boolean which is set to true if the asset described in the EligibilityQuery input is eligible
        /// </summary>
        public bool IsEligible { get; }
        
        /// <summary>
        /// if there was a match, this will be the one or more criteria that were supplied in the EligbilityCollateralSpecification which matched with the query input
        /// </summary>
        public IEnumerable<EligibleCollateralCriteria> MatchingEligibleCriteria { get; }
        
        /// <summary>
        /// a copy of the input query that was checked against the eligible collateral specification
        /// </summary>
        public EligibilityQuery EligibilityQuery { get; }
        
        /// <summary>
        /// a copy of the input EligbilityCollateralSpecification that was checked against the query
        /// </summary>
        public EligibleCollateralSpecification Specification { get; }
    }
    
    /// <summary>
    /// A type for documenting additional clause that cannot yet be represented with the model and yet needed for a digital representation of the agreement.
    /// </summary>
    public class Clause : AbstractRosettaModelObject<Clause>
    {
        private static readonly IRosettaMetaData<Clause> metaData = new ClauseMeta();
        
        [JsonConstructor]
        public Clause(string? identifier, string? terms, IEnumerable<Clause> subcomponents)
        {
            Identifier = identifier;
            Terms = terms;
            Subcomponents = subcomponents;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Clause> MetaData => metaData;
        
        /// <summary>
        /// The  name or identifier associated to this clause.
        /// </summary>
        public string? Identifier { get; }
        
        /// <summary>
        /// Content of this bespoke clause.
        /// </summary>
        public string? Terms { get; }
        
        /// <summary>
        /// Additional hierarchical components of the clause if relevant.
        /// </summary>
        public IEnumerable<Clause> Subcomponents { get; }
    }
    
    /// <summary>
    /// All information required to perform the clear life cycle event; the clearing party (CCP), the two parties facing each other on the alpha contract, and optionally the parties acting as clearing members.
    /// </summary>
    public class ClearingInstruction : AbstractRosettaModelObject<ClearingInstruction>
    {
        private static readonly IRosettaMetaData<ClearingInstruction> metaData = new ClearingInstructionMeta();
        
        [JsonConstructor]
        public ClearingInstruction(TradeState alphaContract, Party clearingParty, Party party1, Party party2, Party? clearerParty1, Party? clearerParty2, bool? isOpenOffer)
        {
            AlphaContract = alphaContract;
            ClearingParty = clearingParty;
            Party1 = party1;
            Party2 = party2;
            ClearerParty1 = clearerParty1;
            ClearerParty2 = clearerParty2;
            IsOpenOffer = isOpenOffer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ClearingInstruction> MetaData => metaData;
        
        /// <summary>
        /// The contract that will be submitted to the clearing house for clearing. The contract should indicate that it should be cleared by assigning a clearing organisation as a party role.
        /// </summary>
        public TradeState AlphaContract { get; }
        
        /// <summary>
        /// The Central Counter party (CCP) that the contract will be submitted to for clearing.
        /// </summary>
        public Party ClearingParty { get; }
        
        /// <summary>
        /// First party facing the CCP if it is clearing for its own account.
        /// </summary>
        public Party Party1 { get; }
        
        /// <summary>
        /// Second party facing the CCP if it is clearing for its own account.
        /// </summary>
        public Party Party2 { get; }
        
        /// <summary>
        /// Optional party facing the CCP, acting as clearing member for party1.
        /// </summary>
        public Party? ClearerParty1 { get; }
        
        /// <summary>
        /// Optional party facing the CCP, acting as clearing member for party2.
        /// </summary>
        public Party? ClearerParty2 { get; }
        
        /// <summary>
        /// Open Offer
        /// </summary>
        public bool? IsOpenOffer { get; }
    }
    
    /// <summary>
    ///  A class to qualify the closed state of an execution or a contract through the combination or a state (e.g. terminated, novated) and a set of dates: activity date, effective date and, when relevant, last payment date.
    /// </summary>
    public class ClosedState : AbstractRosettaModelObject<ClosedState>
    {
        private static readonly IRosettaMetaData<ClosedState> metaData = new ClosedStateMeta();
        
        [JsonConstructor]
        public ClosedState(Enums.ClosedState state, LocalDate activityDate, LocalDate? effectiveDate, LocalDate? lastPaymentDate)
        {
            State = state;
            ActivityDate = activityDate;
            EffectiveDate = effectiveDate;
            LastPaymentDate = lastPaymentDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ClosedState> MetaData => metaData;
        
        /// <summary>
        /// The qualification of what gave way to the contract or execution closure, e.g. allocation, termination, ...
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ClosedState State { get; }
        
        /// <summary>
        /// The activity date on which the closing state took place, i.e. either the event date of the closing event (e.g. option exercise, contract early termination) or the contractual termination date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ActivityDate { get; }
        
        /// <summary>
        /// The date on which the closing event contractually takes effect, when different from the activity date. When an explicit event effective date attribute is associated with the closing event, it will be that date. In the case of a cancellation event, it will be the date on which the cancelled event took place.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <summary>
        /// The date associated with the last payment in relation to the artefact (e.g. contract) to which this closed state applies. As an example, in the case of an early termination event, it would be the settlement date of the associated fee, if applicable.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? LastPaymentDate { get; }
    }
    
    /// <summary>
    /// A type for defining the obligations of the counterparty subject to credit support requirements.
    /// </summary>
    public class Collateral : AbstractRosettaModelObject<Collateral>
    {
        private static readonly IRosettaMetaData<Collateral> metaData = new CollateralMeta();
        
        [JsonConstructor]
        public Collateral(IndependentAmount? independentAmount, IEnumerable<Identifier> portfolioIdentifier, IEnumerable<ReferenceWithMetaCollateralPortfolio> collateralPortfolio, CollateralProvisions? collateralProvisions, _MetaFields? meta)
        {
            IndependentAmount = independentAmount;
            PortfolioIdentifier = portfolioIdentifier;
            CollateralPortfolio = collateralPortfolio;
            CollateralProvisions = collateralProvisions;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Collateral> MetaData => metaData;
        
        /// <summary>
        /// Independent Amount is an amount that usually less creditworthy counterparties are asked to provide. It can either be a fixed amount or a percentage of the Transaction&apos;s value. The Independent Amount can be: (i) transferred before any trading between the parties occurs (as a deposit at a third party&apos;s account or with the counterparty) or (ii) callable after trading has occurred (typically because a downgrade has occurred). In situation (i), the Independent Amount is not included in the calculation of Exposure, but in situation (ii), it is included in the calculation of Exposure. Thus, for situation (ii), the Independent Amount may be transferred along with any collateral call. Independent Amount is a defined term in the ISDA Credit Support Annex. (&apos;with respect to a party, the amount specified as such for that party in Paragraph 13; if no amount is specified, zero&apos;).
        /// </summary>
        public IndependentAmount? IndependentAmount { get; }
        
        /// <summary>
        /// A list of identifiers pointing to the collateral portfolios which contain the collateral which covers a trade.
        /// </summary>
        public IEnumerable<Identifier> PortfolioIdentifier { get; }
        
        /// <summary>
        /// The collateral portfolios which contain the collateral which covers a trade. (NB: this can be provided by reference to a global key for each CollateralPortfolio object)
        /// </summary>
        public IEnumerable<ReferenceWithMetaCollateralPortfolio> CollateralPortfolio { get; }
        
        /// <summary>
        /// specifies the collateral provisions of the product.
        /// </summary>
        public CollateralProvisions? CollateralProvisions { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class to specify Collateral Access Breach language.
    /// </summary>
    public class CollateralAccessBreach : AbstractRosettaModelObject<CollateralAccessBreach>
    {
        private static readonly IRosettaMetaData<CollateralAccessBreach> metaData = new CollateralAccessBreachMeta();
        
        [JsonConstructor]
        public CollateralAccessBreach(bool isApplicable, bool? cabEndDateElection, decimal? cabEndDate, string? cabEndDateTerms)
        {
            IsApplicable = isApplicable;
            CabEndDateElection = cabEndDateElection;
            CabEndDate = cabEndDate;
            CabEndDateTerms = cabEndDateTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralAccessBreach> MetaData => metaData;
        
        /// <summary>
        /// Collateral Access Breach terms are applicable when True and not applicable when False.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// Determination of whether the Collateral Access Breach end date is a number of days (True) or specified (False).
        /// </summary>
        public bool? CabEndDateElection { get; }
        
        /// <summary>
        /// The business days following the related Collateral Access Breach when the additional terms end.
        /// </summary>
        public decimal? CabEndDate { get; }
        
        /// <summary>
        /// Specific terms for when Collateral Access Breach terms end.
        /// </summary>
        public string? CabEndDateTerms { get; }
    }
    
    /// <summary>
    /// Represents the parameters needed to calculate the floating rate paid on collateral holdings.
    /// </summary>
    public class CollateralAgreementFloatingRate : AbstractRosettaModelObject<CollateralAgreementFloatingRate>, IFloatingRateBase
    {
        private static readonly IRosettaMetaData<CollateralAgreementFloatingRate> metaData = new CollateralAgreementFloatingRateMeta();
        
        [JsonConstructor]
        public CollateralAgreementFloatingRate(ReferenceWithMetaInterestRateIndex? rateOption, SpreadSchedule? spreadSchedule, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, bool negativeInterest, bool compressibleSpread)
        {
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            NegativeInterest = negativeInterest;
            CompressibleSpread = compressibleSpread;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralAgreementFloatingRate> MetaData => metaData;
        
        public ReferenceWithMetaInterestRateIndex? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies how negative rates should be applied.  If rates go negative, should the payment be reversed (true) or zeroed out (false)?
        /// </summary>
        public bool NegativeInterest { get; }
        
        /// <summary>
        /// Specifies how spreads should be applied in a low/negative rate environment.  If true, spread is applied only if rate is positive.
        /// </summary>
        public bool CompressibleSpread { get; }
    }
    
    /// <summary>
    /// Represents common attributes to define a collateral balance recorded by the principal as held or posted.
    /// </summary>
    public class CollateralBalance : AbstractRosettaModelObject<CollateralBalance>
    {
        private static readonly IRosettaMetaData<CollateralBalance> metaData = new CollateralBalanceMeta();
        
        [JsonConstructor]
        public CollateralBalance(Enums.CollateralStatus? collateralBalanceStatus, Enums.HaircutIndicator? haircutIndicator, Money amountBaseCurrency, PartyReferencePayerReceiver payerReceiver)
        {
            CollateralBalanceStatus = collateralBalanceStatus;
            HaircutIndicator = haircutIndicator;
            AmountBaseCurrency = amountBaseCurrency;
            PayerReceiver = payerReceiver;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralBalance> MetaData => metaData;
        
        /// <summary>
        /// Defines the collateral balance breakdown of settlement status.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralStatus? CollateralBalanceStatus { get; }
        
        /// <summary>
        /// Indicates if the collateral balance amount is based on pre or post haircut, if a haircut is associated with the collateral asset
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.HaircutIndicator? HaircutIndicator { get; }
        
        /// <summary>
        /// Specifies the collateral balance amount in base currency determined within a collateral legal agreement, or defined for reporting purposes.
        /// </summary>
        public Money AmountBaseCurrency { get; }
        
        /// <summary>
        /// Specifies each of the parties in the collateral balance and its perspective with regards to the direction of the collateral balance, posted or received.
        /// </summary>
        public PartyReferencePayerReceiver PayerReceiver { get; }
    }
    
    /// <summary>
    /// The possible different terms that can be combined, using AND, OR and NOT logic, to define the issuers and/or assets that meet a given criteria for collateral.
    /// </summary>
    public class CollateralCriteria : AbstractRosettaModelObject<CollateralCriteria>
    {
        private static readonly IRosettaMetaData<CollateralCriteria> metaData = new CollateralCriteriaMeta();
        
        [JsonConstructor]
        public CollateralCriteria(AllCriteria? allCriteria, AnyCriteria? anyCriteria, NegativeCriteria? negativeCriteria, CollateralIssuerType? collateralIssuerType, AssetType? assetType, IssuerCountryOfOrigin? issuerCountryOfOrigin, AssetCountryOfOrigin? assetCountryOfOrigin, Enums.CurrencyCode? currencyCodeEnum, IssuerName? issuerName, IssuerAgencyRating? issuerAgencyRating, SovereignAgencyRating? sovereignAgencyRating, AssetAgencyRating? assetAgencyRating, AssetMaturity? assetMaturity, SpecificAsset? specificAsset, CollateralTaxonomy? collateralTaxonomy, ListingExchange? listingExchange, ListingSector? listingSector, Index? index, CounterpartyOwnIssuePermitted? counterpartyOwnIssuePermitted, DomesticCurrencyIssued? domesticCurrencyIssued)
        {
            AllCriteria = allCriteria;
            AnyCriteria = anyCriteria;
            NegativeCriteria = negativeCriteria;
            CollateralIssuerType = collateralIssuerType;
            AssetType = assetType;
            IssuerCountryOfOrigin = issuerCountryOfOrigin;
            AssetCountryOfOrigin = assetCountryOfOrigin;
            CurrencyCodeEnum = currencyCodeEnum;
            IssuerName = issuerName;
            IssuerAgencyRating = issuerAgencyRating;
            SovereignAgencyRating = sovereignAgencyRating;
            AssetAgencyRating = assetAgencyRating;
            AssetMaturity = assetMaturity;
            SpecificAsset = specificAsset;
            CollateralTaxonomy = collateralTaxonomy;
            ListingExchange = listingExchange;
            ListingSector = listingSector;
            Index = index;
            CounterpartyOwnIssuePermitted = counterpartyOwnIssuePermitted;
            DomesticCurrencyIssued = domesticCurrencyIssued;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralCriteria> MetaData => metaData;
        
        /// <summary>
        /// Enables two or more Collateral Criteria to be combined using AND logic.
        /// </summary>
        public AllCriteria? AllCriteria { get; }
        
        /// <summary>
        /// Enables two or more Collateral Criteria to be combined using OR logic.
        /// </summary>
        public AnyCriteria? AnyCriteria { get; }
        
        /// <summary>
        /// Enables a single Collateral Criteria to be excluded using NOT logic.
        /// </summary>
        public NegativeCriteria? NegativeCriteria { get; }
        
        /// <summary>
        /// Criteria is the type of entity issuing the asset.
        /// </summary>
        public CollateralIssuerType? CollateralIssuerType { get; }
        
        /// <summary>
        /// Criteria is the asset type of the collateral.
        /// </summary>
        public AssetType? AssetType { get; }
        
        /// <summary>
        /// Criteria is the issuing entity country of origin.
        /// </summary>
        public IssuerCountryOfOrigin? IssuerCountryOfOrigin { get; }
        
        /// <summary>
        /// Criteria is the collateral asset country of origin.
        /// </summary>
        public AssetCountryOfOrigin? AssetCountryOfOrigin { get; }
        
        /// <summary>
        /// Criteria is the denominated currency of the collateral.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CurrencyCode? CurrencyCodeEnum { get; }
        
        /// <summary>
        /// Criteria is a specific named issuer entity.
        /// </summary>
        public IssuerName? IssuerName { get; }
        
        /// <summary>
        /// Criteria is the agency rating(s) of the issuer.
        /// </summary>
        public IssuerAgencyRating? IssuerAgencyRating { get; }
        
        /// <summary>
        /// Criteria is the agency rating(s) of the country of the issuer.
        /// </summary>
        public SovereignAgencyRating? SovereignAgencyRating { get; }
        
        /// <summary>
        /// Criteria is the agency rating(s) of the collateral asset.
        /// </summary>
        public AssetAgencyRating? AssetAgencyRating { get; }
        
        /// <summary>
        /// Criteria is the maturity characteristics of the collateral asset.
        /// </summary>
        public AssetMaturity? AssetMaturity { get; }
        
        /// <summary>
        /// Criteria is a specifically identified asset
        /// </summary>
        public SpecificAsset? SpecificAsset { get; }
        
        /// <summary>
        /// Criteria is the taxonomy characteristics of an collateral.
        /// </summary>
        public CollateralTaxonomy? CollateralTaxonomy { get; }
        
        /// <summary>
        /// Criteria is that the collateral is listed on a specific exchange.
        /// </summary>
        public ListingExchange? ListingExchange { get; }
        
        /// <summary>
        /// Criteria is the industry sector of the collateral asset.
        /// </summary>
        public ListingSector? ListingSector { get; }
        
        /// <summary>
        /// Criteria is that the collateral is a constituent of a specific index.
        /// </summary>
        public Index? Index { get; }
        
        /// <summary>
        /// Criteria includes collateral issued by the counterparty.
        /// </summary>
        public CounterpartyOwnIssuePermitted? CounterpartyOwnIssuePermitted { get; }
        
        /// <summary>
        /// Criteria is that collateral must be denominated in the domestic currency of the issuer.
        /// </summary>
        public DomesticCurrencyIssued? DomesticCurrencyIssued { get; }
    }
    
    /// <summary>
    /// Represents a set of criteria used to specify and describe collateral.
    /// </summary>
    public class CollateralCriteriaBase : AbstractRosettaModelObject<CollateralCriteriaBase>, ICollateralCriteriaBase
    {
        private static readonly IRosettaMetaData<CollateralCriteriaBase> metaData = new CollateralCriteriaBaseMeta();
        
        [JsonConstructor]
        public CollateralCriteriaBase(CollateralCriteria? collateralCriteria, IEnumerable<Enums.CounterpartyRole> appliesTo, Enums.CollateralMarginType? restrictTo, Enums.RatingPriorityResolution? ratingPriorityResolution)
        {
            CollateralCriteria = collateralCriteria;
            AppliesTo = appliesTo;
            RestrictTo = restrictTo;
            RatingPriorityResolution = ratingPriorityResolution;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralCriteriaBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public CollateralCriteria? CollateralCriteria { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> AppliesTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralMarginType? RestrictTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatingPriorityResolution? RatingPriorityResolution { get; }
    }
    
    /// <summary>
    /// Represents parameters for calculating the amount the floating interest calculation, e.g.  for a single currency or defaults for all currencies.
    /// </summary>
    public class CollateralInterestCalculationParameters : AbstractRosettaModelObject<CollateralInterestCalculationParameters>
    {
        private static readonly IRosettaMetaData<CollateralInterestCalculationParameters> metaData = new CollateralInterestCalculationParametersMeta();
        
        [JsonConstructor]
        public CollateralInterestCalculationParameters(decimal? fixedRate, CollateralAgreementFloatingRate? floatingRate, bool inBaseCurrency, Enums.CompoundingType? compoundingType, IEnumerable<Enums.BusinessCenter> compoundingBusinessCenter, Enums.DayCountFraction dayCountFraction, Rounding? rounding, Enums.RoundingFrequency? roundingFrequency, decimal? withholdingTaxRate)
        {
            FixedRate = fixedRate;
            FloatingRate = floatingRate;
            InBaseCurrency = inBaseCurrency;
            CompoundingType = compoundingType;
            CompoundingBusinessCenter = compoundingBusinessCenter;
            DayCountFraction = dayCountFraction;
            Rounding = rounding;
            RoundingFrequency = roundingFrequency;
            WithholdingTaxRate = withholdingTaxRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralInterestCalculationParameters> MetaData => metaData;
        
        /// <summary>
        /// Specifies the applicable fixed rate  if used.
        /// </summary>
        public decimal? FixedRate { get; }
        
        /// <summary>
        /// Specifies the floating interest rate to be used.
        /// </summary>
        public CollateralAgreementFloatingRate? FloatingRate { get; }
        
        /// <summary>
        /// If True, specifies that the interest transfers should be converted to base currency equivalent, or if False specifies that the transfer should be in the currency of the collateral.
        /// </summary>
        public bool InBaseCurrency { get; }
        
        /// <summary>
        /// Specifies the type of compounding to be applied (None, Business, Calendar).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CompoundingType? CompoundingType { get; }
        
        /// <summary>
        /// Specifies the applicable business centers for compounding.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.BusinessCenter> CompoundingBusinessCenter { get; }
        
        /// <summary>
        /// Specifies the day count fraction to use for that currency.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayCountFraction DayCountFraction { get; }
        
        /// <summary>
        /// Specifies the rounding rules for settling in that currency.
        /// </summary>
        public Rounding? Rounding { get; }
        
        /// <summary>
        /// Specifies when/how often is rounding applied?
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RoundingFrequency? RoundingFrequency { get; }
        
        /// <summary>
        /// Specifies the withholding tax rate if a withholding tax is applicable.
        /// </summary>
        public decimal? WithholdingTaxRate { get; }
    }
    
    /// <summary>
    /// Represents parameters that describe how calculated interest amounts are handled, i.e. are they transferred/distributed, or is the collateral balance adjusted, is netting done, and any other special handling.
    /// </summary>
    public class CollateralInterestHandlingParameters : AbstractRosettaModelObject<CollateralInterestHandlingParameters>
    {
        private static readonly IRosettaMetaData<CollateralInterestHandlingParameters> metaData = new CollateralInterestHandlingParametersMeta();
        
        [JsonConstructor]
        public CollateralInterestHandlingParameters(Enums.CollateralInterestHandling interestPaymentHandling, IEnumerable<Enums.BusinessCenter> paymentBusinessCenter, bool netPostedAndHeldInterest, bool netInterestWithMarginCalls, bool includeAccrualInMarginCalc, bool? accrueInterestOnUnsettledInterest, bool onFullReturn, bool onPartialReturn, InterestAmountApplication? interestAmountApplication, NumberBound? interestRolloverLimit, NumberBound? writeoffLimit, Enums.AlternativeToInterestAmount? alternativeToInterestAmount, string? alternativeProvision, LocalTime? cutoffTime, CollateralInterestNotification? notification)
        {
            InterestPaymentHandling = interestPaymentHandling;
            PaymentBusinessCenter = paymentBusinessCenter;
            NetPostedAndHeldInterest = netPostedAndHeldInterest;
            NetInterestWithMarginCalls = netInterestWithMarginCalls;
            IncludeAccrualInMarginCalc = includeAccrualInMarginCalc;
            AccrueInterestOnUnsettledInterest = accrueInterestOnUnsettledInterest;
            OnFullReturn = onFullReturn;
            OnPartialReturn = onPartialReturn;
            InterestAmountApplication = interestAmountApplication;
            InterestRolloverLimit = interestRolloverLimit;
            WriteoffLimit = writeoffLimit;
            AlternativeToInterestAmount = alternativeToInterestAmount;
            AlternativeProvision = alternativeProvision;
            CutoffTime = cutoffTime;
            Notification = notification;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralInterestHandlingParameters> MetaData => metaData;
        
        /// <summary>
        /// Specifies how the collateral interest is to be handled.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralInterestHandling InterestPaymentHandling { get; }
        
        /// <summary>
        /// Specifies applicable business centers for payments.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.BusinessCenter> PaymentBusinessCenter { get; }
        
        /// <summary>
        /// Indicates whether to net Held and Posted Interest Payments (i.e. whether interest payable for a period can be netted with interest receivable).
        /// </summary>
        public bool NetPostedAndHeldInterest { get; }
        
        /// <summary>
        /// Indicates whether the interest amount may be offset against any margin call deliver or return amounts?   (aka &apos;net payments&apos; indicator).
        /// </summary>
        public bool NetInterestWithMarginCalls { get; }
        
        /// <summary>
        /// Indicates whether or not to include the open interest accrual in the margin calculation.
        /// </summary>
        public bool IncludeAccrualInMarginCalc { get; }
        
        /// <summary>
        /// Indicates whether interest accruing on unsettled interest amount is included (continues to be accrued) in the following period.
        /// </summary>
        public bool? AccrueInterestOnUnsettledInterest { get; }
        
        /// <summary>
        /// Indicates the option that accrued interest should be calculated and distributed when a full return of collateral occurs.
        /// </summary>
        public bool OnFullReturn { get; }
        
        /// <summary>
        /// Indicates the option that accrued interest should be calculated and distributed when a partial return collateral occurs.
        /// </summary>
        public bool OnPartialReturn { get; }
        
        /// <summary>
        /// The application of Interest Amount with respect to the Delivery Amount and the Return Amount.
        /// </summary>
        public InterestAmountApplication? InterestAmountApplication { get; }
        
        /// <summary>
        /// Specifies the level below which the interest will be rolled over.
        /// </summary>
        public NumberBound? InterestRolloverLimit { get; }
        
        /// <summary>
        /// Specifies the level below which the interest will be written off; if omitted write-off is not applicable.
        /// </summary>
        public NumberBound? WriteoffLimit { get; }
        
        /// <summary>
        /// Specifies the alternative to interest amounts.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AlternativeToInterestAmount? AlternativeToInterestAmount { get; }
        
        /// <summary>
        /// Specifies an alternative to interest amount, when the alternative provision clause is specified.
        /// </summary>
        public string? AlternativeProvision { get; }
        
        /// <summary>
        /// Specifies the time of day that interest needs to be confirmed by.
        /// </summary>
        public LocalTime? CutoffTime { get; }
        
        /// <summary>
        /// Specifies the terms describing notification requirements.
        /// </summary>
        public CollateralInterestNotification? Notification { get; }
    }
    
    /// <summary>
    /// Represents the parameters describing when notifications should be made for required collateral interest transfers.
    /// </summary>
    public class CollateralInterestNotification : AbstractRosettaModelObject<CollateralInterestNotification>
    {
        private static readonly IRosettaMetaData<CollateralInterestNotification> metaData = new CollateralInterestNotificationMeta();
        
        [JsonConstructor]
        public CollateralInterestNotification(string trigger, decimal offset, LocalTime notificationTime, Enums.DayType notificationDayType)
        {
            Trigger = trigger;
            Offset = offset;
            NotificationTime = notificationTime;
            NotificationDayType = notificationDayType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralInterestNotification> MetaData => metaData;
        
        /// <summary>
        /// Specifies what triggers notification (should be enum) Interest Statement Frequency, Period End Date.
        /// </summary>
        public string Trigger { get; }
        
        /// <summary>
        /// Specifies the number of days before (negative) or after (positive) the trigger event.
        /// </summary>
        public decimal Offset { get; }
        
        /// <summary>
        /// Specifies the time of day that the notification should occur.
        /// </summary>
        public LocalTime NotificationTime { get; }
        
        /// <summary>
        /// The type of days on which notification should occur.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType NotificationDayType { get; }
    }
    
    /// <summary>
    /// Represents the floating interest calculation and distribution parameters for a single currency.
    /// </summary>
    public class CollateralInterestParameters : AbstractRosettaModelObject<CollateralInterestParameters>
    {
        private static readonly IRosettaMetaData<CollateralInterestParameters> metaData = new CollateralInterestParametersMeta();
        
        [JsonConstructor]
        public CollateralInterestParameters(Enums.CounterpartyRole? postingParty, Enums.CollateralMarginType? marginType, string? currency, CollateralInterestCalculationParameters? interestCalculationParameters, CalculationFrequency? interestCalculationFrequency, CollateralInterestHandlingParameters? interestHandlingParameters)
        {
            PostingParty = postingParty;
            MarginType = marginType;
            Currency = currency;
            InterestCalculationParameters = interestCalculationParameters;
            InterestCalculationFrequency = interestCalculationFrequency;
            InterestHandlingParameters = interestHandlingParameters;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralInterestParameters> MetaData => metaData;
        
        /// <summary>
        /// Represents the party to which these parameters apply (the applicable party).  In other words, if the parameters are different depending on which party is posting/holding the collateral, for which party to the Collateral Agreement (Party 1 or Party 2) that is posting the collateral do these parameters apply?
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole? PostingParty { get; }
        
        /// <summary>
        /// Specifies the type of margin for which interest is being calculated, if the parameters are different depending on type of margin (initial or variation).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralMarginType? MarginType { get; }
        
        /// <summary>
        /// Specifies the currency for which the parameters are captured.
        /// </summary>
        public string? Currency { get; }
        
        /// <summary>
        /// Represents the basic interest calculation parameters.
        /// </summary>
        public CollateralInterestCalculationParameters? InterestCalculationParameters { get; }
        
        /// <summary>
        /// Represents how often and when interest is calculated.
        /// </summary>
        public CalculationFrequency? InterestCalculationFrequency { get; }
        
        /// <summary>
        /// Represents the parameters describing how and when interest transfer occurs.
        /// </summary>
        public CollateralInterestHandlingParameters? InterestHandlingParameters { get; }
    }
    
    /// <summary>
    /// Represents a class to allow specification of the type of entity issuing the collateral.
    /// </summary>
    public class CollateralIssuerType : AbstractRosettaModelObject<CollateralIssuerType>
    {
        private static readonly IRosettaMetaData<CollateralIssuerType> metaData = new CollateralIssuerTypeMeta();
        
        [JsonConstructor]
        public CollateralIssuerType(Enums.IssuerType issuerType, Enums.SupraNationalIssuerType? supraNationalType, QuasiGovernmentIssuerType? quasiGovernmentType, RegionalGovernmentIssuerType? regionalGovernmentType, SpecialPurposeVehicleIssuerType? specialPurposeVehicleType)
        {
            IssuerType = issuerType;
            SupraNationalType = supraNationalType;
            QuasiGovernmentType = quasiGovernmentType;
            RegionalGovernmentType = regionalGovernmentType;
            SpecialPurposeVehicleType = specialPurposeVehicleType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralIssuerType> MetaData => metaData;
        
        /// <summary>
        /// Specifies the origin of entity issuing the collateral.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IssuerType IssuerType { get; }
        
        /// <summary>
        /// Specifies debt issued by international organisations and multilateral banks.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SupraNationalIssuerType? SupraNationalType { get; }
        
        /// <summary>
        /// Specifies debt issues by institutions or bodies, typically constituted by statute, with a function mandated by the government and subject to government supervision inclusive of profit- and non-profit making bodies. Includes the US Agencies and GSEs and the EU concept of public sector entities. Excluding any entities which are also Regional Government.
        /// </summary>
        public QuasiGovernmentIssuerType? QuasiGovernmentType { get; }
        
        /// <summary>
        /// Specifies Regional government, local authority or municipal.
        /// </summary>
        public RegionalGovernmentIssuerType? RegionalGovernmentType { get; }
        
        /// <summary>
        /// Specifies a subsidiary company that is formed to undertake a specific business purpose of acquisition and financing of specific assets on a potentially limited recourse basis dependent of how it is designed. E.g. asset backed securities, including securitisations.
        /// </summary>
        public SpecialPurposeVehicleIssuerType? SpecialPurposeVehicleType { get; }
    }
    
    /// <summary>
    /// A class to specify the Collateral Management Agreement election.
    /// </summary>
    public class CollateralManagementAgreement : AbstractRosettaModelObject<CollateralManagementAgreement>
    {
        private static readonly IRosettaMetaData<CollateralManagementAgreement> metaData = new CollateralManagementAgreementMeta();
        
        [JsonConstructor]
        public CollateralManagementAgreement(IEnumerable<CollateralManagementAgreementElection> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralManagementAgreement> MetaData => metaData;
        
        /// <summary>
        /// The parties&apos; Collateral Management Agreement election.
        /// </summary>
        public IEnumerable<CollateralManagementAgreementElection> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify the Collateral Management Agreement election.
    /// </summary>
    public class CollateralManagementAgreementElection : AbstractRosettaModelObject<CollateralManagementAgreementElection>
    {
        private static readonly IRosettaMetaData<CollateralManagementAgreementElection> metaData = new CollateralManagementAgreementElectionMeta();
        
        [JsonConstructor]
        public CollateralManagementAgreementElection(Enums.CounterpartyRole party, string collateralManagementAgreement)
        {
            Party = party;
            CollateralManagementAgreement = collateralManagementAgreement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralManagementAgreementElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The designated Collateral Management Agreement with respect to the elective party as the Obligee.
        /// </summary>
        public string CollateralManagementAgreement { get; }
    }
    
    /// <summary>
    /// Represents common attributes to define the details of collateral assets, to be used in margin call messaging and contribute to collateral balances e.g securities in a collateral account.
    /// </summary>
    public class CollateralPortfolio : AbstractRosettaModelObject<CollateralPortfolio>
    {
        private static readonly IRosettaMetaData<CollateralPortfolio> metaData = new CollateralPortfolioMeta();
        
        [JsonConstructor]
        public CollateralPortfolio(Identifier? portfolioIdentifier, IEnumerable<CollateralPosition> collateralPosition, IEnumerable<CollateralBalance> collateralBalance, ReferenceWithMetaLegalAgreement? legalAgreement, _MetaFields? meta)
        {
            PortfolioIdentifier = portfolioIdentifier;
            CollateralPosition = collateralPosition;
            CollateralBalance = collateralBalance;
            LegalAgreement = legalAgreement;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralPortfolio> MetaData => metaData;
        
        /// <summary>
        /// Specifies a unique identifier for a set of collateral positions in a portfolio.
        /// </summary>
        public Identifier? PortfolioIdentifier { get; }
        
        /// <summary>
        /// Specifies the individual components of the collateral positions in the collateral portfolio.
        /// </summary>
        public IEnumerable<CollateralPosition> CollateralPosition { get; }
        
        /// <summary>
        /// Represents the populated or calculated collateral aggregate balance amount for the collateral portfolio.
        /// </summary>
        public IEnumerable<CollateralBalance> CollateralBalance { get; }
        
        /// <summary>
        ///  The specification of a legal agreement between two parties governing the collateral relationship such as Credit Support Agreement or Collateral Transfer Agreement etc. (NB: this can be provided by reference to a global key for each LegalAgreement object).
        /// </summary>
        public ReferenceWithMetaLegalAgreement? LegalAgreement { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies the individual components of collateral positions.
    /// </summary>
    public class CollateralPosition : AbstractRosettaModelObject<CollateralPosition>, IPositionBase
    {
        private static readonly IRosettaMetaData<CollateralPosition> metaData = new CollateralPositionMeta();
        
        [JsonConstructor]
        public CollateralPosition(IEnumerable<PriceQuantity> priceQuantity, Product? product, Asset? asset, Money? cashBalance, ReferenceWithMetaTradeState? tradeReference, CollateralTreatment? treatment, Enums.CollateralStatus? collateralPositionStatus)
        {
            PriceQuantity = priceQuantity;
            Product = product;
            Asset = asset;
            CashBalance = cashBalance;
            TradeReference = tradeReference;
            Treatment = treatment;
            CollateralPositionStatus = collateralPositionStatus;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralPosition> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<PriceQuantity> PriceQuantity { get; }
        
        /// <inheritdoc/>
        public Product? Product { get; }
        
        /// <inheritdoc/>
        public Asset? Asset { get; }
        
        /// <inheritdoc/>
        public Money? CashBalance { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaTradeState? TradeReference { get; }
        
        /// <summary>
        /// Specifies if there is any treatment to be applied to collateral, such as percentage discount which will impact collateral value.
        /// </summary>
        public CollateralTreatment? Treatment { get; }
        
        /// <summary>
        /// Indicates the collateral positions settlement status.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralStatus? CollateralPositionStatus { get; }
    }
    
    /// <summary>
    /// Contains collateral attributes which can also inherit information from a GMRA
    /// </summary>
    public class CollateralProvisions : AbstractRosettaModelObject<CollateralProvisions>
    {
        private static readonly IRosettaMetaData<CollateralProvisions> metaData = new CollateralProvisionsMeta();
        
        [JsonConstructor]
        public CollateralProvisions(Enums.CollateralType collateralType, IEnumerable<EligibleCollateralCriteria> eligibleCollateral, SubstitutionProvisions? substitutionProvisions)
        {
            CollateralType = collateralType;
            EligibleCollateral = eligibleCollateral;
            SubstitutionProvisions = substitutionProvisions;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralProvisions> MetaData => metaData;
        
        /// <summary>
        /// Enumerates the collateral types which are accepted by the Seller.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralType CollateralType { get; }
        
        /// <summary>
        /// The eligible collateral as specified in relation to the transaction.
        /// </summary>
        public IEnumerable<EligibleCollateralCriteria> EligibleCollateral { get; }
        
        /// <summary>
        /// The provisions for collateral substitutions such as how many and when they are allowed.
        /// </summary>
        public SubstitutionProvisions? SubstitutionProvisions { get; }
    }
    
    /// <summary>
    /// A class to specify the rounding methodology applicable to the Delivery Amount and the Return Amount.
    /// </summary>
    public class CollateralRounding : AbstractRosettaModelObject<CollateralRounding>
    {
        private static readonly IRosettaMetaData<CollateralRounding> metaData = new CollateralRoundingMeta();
        
        [JsonConstructor]
        public CollateralRounding(decimal deliveryAmount, Enums.RoundingMode deliveryDirection, decimal returnAmount, Enums.RoundingMode returnDirection, Enums.ISOCurrencyCode currency, string? other)
        {
            DeliveryAmount = deliveryAmount;
            DeliveryDirection = deliveryDirection;
            ReturnAmount = returnAmount;
            ReturnDirection = returnDirection;
            Currency = currency;
            Other = other;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralRounding> MetaData => metaData;
        
        /// <summary>
        /// The nearest integral multiple of Base Currency units to which the Delivery Amount will be rounded in accordance with the specified rounding direction.
        /// </summary>
        public decimal DeliveryAmount { get; }
        
        /// <summary>
        /// The rounding rule applicable to the Delivery Amount (which can be (i) up to nearest; (ii) down to nearest).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RoundingMode DeliveryDirection { get; }
        
        /// <summary>
        /// The nearest integral multiple of Base Currency units to which the Return Amount will be rounded in accordance with the specified rounding direction.
        /// </summary>
        public decimal ReturnAmount { get; }
        
        /// <summary>
        /// The rounding rule applicable to the Return Amount (which can be (i) up to nearest; (ii) down to nearest).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RoundingMode ReturnDirection { get; }
        
        /// <summary>
        /// The currency in which the Delivery Amount and Return Amount rounding amounts are specified.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ISOCurrencyCode Currency { get; }
        
        /// <summary>
        /// Utilised where the clause data structure is not able to capture a material aspect of the clause.
        /// </summary>
        public string? Other { get; }
    }
    
    /// <summary>
    /// Specifies the collateral taxonomy, which is composed of a taxonomy value and a taxonomy source.
    /// </summary>
    public class CollateralTaxonomy : AbstractRosettaModelObject<CollateralTaxonomy>
    {
        private static readonly IRosettaMetaData<CollateralTaxonomy> metaData = new CollateralTaxonomyMeta();
        
        [JsonConstructor]
        public CollateralTaxonomy(CollateralTaxonomyValue taxonomyValue, Enums.TaxonomySource taxonomySource)
        {
            TaxonomyValue = taxonomyValue;
            TaxonomySource = taxonomySource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTaxonomy> MetaData => metaData;
        
        /// <summary>
        /// Specifies the taxonomy value.
        /// </summary>
        public CollateralTaxonomyValue TaxonomyValue { get; }
        
        /// <summary>
        /// Specifies the taxonomy source.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TaxonomySource TaxonomySource { get; }
    }
    
    /// <summary>
    /// Specifies the collateral taxonomy value, either as a specified enumeration or as a string.
    /// </summary>
    public class CollateralTaxonomyValue : AbstractRosettaModelObject<CollateralTaxonomyValue>
    {
        private static readonly IRosettaMetaData<CollateralTaxonomyValue> metaData = new CollateralTaxonomyValueMeta();
        
        [JsonConstructor]
        public CollateralTaxonomyValue(IEnumerable<Enums.EU_EMIR_EligibleCollateral> eu_EMIR_EligibleCollateral, IEnumerable<Enums.UK_EMIR_EligibleCollateral> uk_EMIR_EligibleCollateral, IEnumerable<Enums.US_CFTC_PR_EligibleCollateral> us_CFTC_PR_EligibleCollateral, IEnumerable<FieldWithMetaString> nonEnumeratedTaxonomyValue)
        {
            Eu_EMIR_EligibleCollateral = eu_EMIR_EligibleCollateral;
            Uk_EMIR_EligibleCollateral = uk_EMIR_EligibleCollateral;
            Us_CFTC_PR_EligibleCollateral = us_CFTC_PR_EligibleCollateral;
            NonEnumeratedTaxonomyValue = nonEnumeratedTaxonomyValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTaxonomyValue> MetaData => metaData;
        
        /// <summary>
        /// Identifies European Union Eligible Collateral Assets classification categories based on EMIR Uncleared Margin Rules. Eligible Collateral asset classes for both initial margin (IM) and variation margin (VM) posted and collected between specified entities. Please note: EMIR regulation will detail which eligible collateral assets classes apply to each type of entity pairing (counterparty) and which apply to posting of IM and VM
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.EU_EMIR_EligibleCollateral> Eu_EMIR_EligibleCollateral { get; }
        
        /// <summary>
        /// Identifies United Kingdom Eligible Collateral Assets classification categories based on UK Onshored EMIR Uncleared Margin Rules Eligible Collateral asset classes for both initial margin (IM) and variation margin (VM) posted and collected between specified entities. Please note: UK EMIR regulation will detail which eligible collateral assets classes apply to each type of entity pairing (counterparty) and which apply to posting of IM and VM.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.UK_EMIR_EligibleCollateral> Uk_EMIR_EligibleCollateral { get; }
        
        /// <summary>
        /// Identifies US Eligible Collateral Assets classification categories based on Uncleared Margin Rules published by the CFTC and the US Prudential Regulator. Note: While the same basic categories exist in the CFTC and US Prudential Regulators’ margin rules, the precise definitions or application of those rules could differ between the two rules.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.US_CFTC_PR_EligibleCollateral> Us_CFTC_PR_EligibleCollateral { get; }
        
        /// <summary>
        /// Identifies the taxonomy value when not specified as an enumeration.
        /// </summary>
        public IEnumerable<FieldWithMetaString> NonEnumeratedTaxonomyValue { get; }
    }
    
    /// <summary>
    /// The set of elections which specify a Collateral Transfer Agreement.
    /// </summary>
    public class CollateralTransferAgreementElections : AbstractRosettaModelObject<CollateralTransferAgreementElections>
    {
        private static readonly IRosettaMetaData<CollateralTransferAgreementElections> metaData = new CollateralTransferAgreementElectionsMeta();
        
        [JsonConstructor]
        public CollateralTransferAgreementElections(Regime regime, OneWayProvisions oneWayProvisions, GeneralSimmElections generalSimmElections, bool? identifiedCrossCurrencySwap, SensitivityMethodologies sensitivityMethodologies, FxHaircutCurrency? fxHaircutCurrency, PostingObligations postingObligations, IEnumerable<SubstitutedRegime> substitutedRegime, BaseAndEligibleCurrency baseAndEligibleCurrency, CreditSupportObligations creditSupportObligations, CalculationAndTiming calculationAndTiming, ConditionsPrecedent conditionsPrecedent, Substitution? substitution, DisputeResolution disputeResolution, RightsEvents? rightsEvents, CustodyArrangements custodyArrangements, AdditionalRepresentations additionalRepresentations, DemandsAndNotices? demandsAndNotices, ContactElection? addressesForTransfer, string? otherCsa, TerminationCurrencyAmendment terminationCurrencyAmendment, MinimumTransferAmountAmendment? minimumTransferAmountAmendment, string? interpretationTerms, ProcessAgent? processAgent, JurisdictionRelatedTerms? jurisdictionRelatedTerms, string? additionalAmendments, string? additionalBespokeTerms, PledgeeRepresentativeRider? pledgeeRepresentativeRider, FinalReturns finalReturns)
        {
            Regime = regime;
            OneWayProvisions = oneWayProvisions;
            GeneralSimmElections = generalSimmElections;
            IdentifiedCrossCurrencySwap = identifiedCrossCurrencySwap;
            SensitivityMethodologies = sensitivityMethodologies;
            FxHaircutCurrency = fxHaircutCurrency;
            PostingObligations = postingObligations;
            SubstitutedRegime = substitutedRegime;
            BaseAndEligibleCurrency = baseAndEligibleCurrency;
            CreditSupportObligations = creditSupportObligations;
            CalculationAndTiming = calculationAndTiming;
            ConditionsPrecedent = conditionsPrecedent;
            Substitution = substitution;
            DisputeResolution = disputeResolution;
            RightsEvents = rightsEvents;
            CustodyArrangements = custodyArrangements;
            AdditionalRepresentations = additionalRepresentations;
            DemandsAndNotices = demandsAndNotices;
            AddressesForTransfer = addressesForTransfer;
            OtherCsa = otherCsa;
            TerminationCurrencyAmendment = terminationCurrencyAmendment;
            MinimumTransferAmountAmendment = minimumTransferAmountAmendment;
            InterpretationTerms = interpretationTerms;
            ProcessAgent = processAgent;
            JurisdictionRelatedTerms = jurisdictionRelatedTerms;
            AdditionalAmendments = additionalAmendments;
            AdditionalBespokeTerms = additionalBespokeTerms;
            PledgeeRepresentativeRider = pledgeeRepresentativeRider;
            FinalReturns = finalReturns;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTransferAgreementElections> MetaData => metaData;
        
        /// <summary>
        /// The Regime Table provision , which determines the regulatory regime(s) applicable to each of the parties to the agreement.
        /// </summary>
        public Regime Regime { get; }
        
        /// <summary>
        /// The determination of whether the One Way Provisions are applicable (true) or not applicable (false).
        /// </summary>
        public OneWayProvisions OneWayProvisions { get; }
        
        /// <summary>
        /// The specification of the ISDA SIMM Method for all Covered Transactions with respect to all Regimes.
        /// </summary>
        public GeneralSimmElections GeneralSimmElections { get; }
        
        /// <summary>
        /// The qualification of whether cross-currency swaps need to be identified in the Confirmation so that the obligations to exchange principal be disregarded for the purpose of determining the Delivery Amount or Return Amount.
        /// </summary>
        public bool? IdentifiedCrossCurrencySwap { get; }
        
        /// <summary>
        /// The specification of methodologies to compute sensitivities specific to the agreement.
        /// </summary>
        public SensitivityMethodologies SensitivityMethodologies { get; }
        
        /// <summary>
        /// The reference currency for the purpose of specifying the FX Haircut relating to a posting obligation, as being either the Termination Currency or an FX Designated Currency.
        /// </summary>
        public FxHaircutCurrency? FxHaircutCurrency { get; }
        
        /// <summary>
        /// The security providers posting obligations.
        /// </summary>
        public PostingObligations PostingObligations { get; }
        
        /// <summary>
        /// The specification of Additional regimes for purposes of determining whether a Regulatory Event has occurred.
        /// </summary>
        public IEnumerable<SubstitutedRegime> SubstitutedRegime { get; }
        
        /// <summary>
        /// The base and eligible currency(ies) for the document as specified by the parties to the agreement.
        /// </summary>
        public BaseAndEligibleCurrency BaseAndEligibleCurrency { get; }
        
        /// <summary>
        /// The Credit Support Obligations applicable to the agreement.
        /// </summary>
        public CreditSupportObligations CreditSupportObligations { get; }
        
        /// <summary>
        /// The set of elections for determining Valuation and Timing terms specific to the agreement.
        /// </summary>
        public CalculationAndTiming CalculationAndTiming { get; }
        
        /// <summary>
        /// The set of elections that may overwrite the default Condition Precedent provision, and the set of provisions that are deemed Access Condition.
        /// </summary>
        public ConditionsPrecedent ConditionsPrecedent { get; }
        
        /// <summary>
        /// The conditions under which the Security Provider can substitute posted collateral.
        /// </summary>
        public Substitution? Substitution { get; }
        
        /// <summary>
        /// The election terms under which a party disputes (i) the Calculation Agents calculation of a Delivery Amount or a Return Amount, or (ii) the Value of any Transfer of Eligible Credit Support or Posted Credit Support.
        /// </summary>
        public DisputeResolution DisputeResolution { get; }
        
        /// <summary>
        /// The bespoke provisions that might be specified by the parties to the agreement to specify the rights of Security Taker and/or Security Provider when an Early Termination or Access Condition event has occurred.
        /// </summary>
        public RightsEvents? RightsEvents { get; }
        
        /// <summary>
        /// The Custodian and Segregated Account details in respect of each party to the agreement.
        /// </summary>
        public CustodyArrangements CustodyArrangements { get; }
        
        /// <summary>
        /// The specification Additional Representations that may be applicable to the agreement.
        /// </summary>
        public AdditionalRepresentations AdditionalRepresentations { get; }
        
        /// <summary>
        /// The optional specification of address where the demands, specifications and notices will be communicated to for each of the parties to the agreement.
        /// </summary>
        public DemandsAndNotices? DemandsAndNotices { get; }
        
        /// <summary>
        /// The optional specification of address for transfer as specified by the respective parties to the agreement.
        /// </summary>
        public ContactElection? AddressesForTransfer { get; }
        
        /// <summary>
        /// The bespoke definition of Other CSA as specified by the parties to the agreement.
        /// </summary>
        public string? OtherCsa { get; }
        
        /// <summary>
        /// The bespoke provision that might be specified by the parties to the agreement applicable to Termination Currency.  Unless specified the definition of Termination Currency has the meaning specified in the Schedule to the ISDA Master Agreement.
        /// </summary>
        public TerminationCurrencyAmendment TerminationCurrencyAmendment { get; }
        
        /// <summary>
        /// The bespoke provision that might be specified by the parties to the agreement applicable to Minimum Transfer Amount.  Unless specified the definition of Minimum Transfer Amount in any Other Regulatory CSA has the meaning specified in such Other Regulatory CSA.
        /// </summary>
        public MinimumTransferAmountAmendment? MinimumTransferAmountAmendment { get; }
        
        /// <summary>
        /// The bespoke provision that might be specified by the parties to the agreement applicable to Interpretations.
        /// </summary>
        public string? InterpretationTerms { get; }
        
        /// <summary>
        /// The Process Agent that might be appointed by the parties to the agreement.
        /// </summary>
        public ProcessAgent? ProcessAgent { get; }
        
        /// <summary>
        /// The jurisdiction specific terms relevant to the agreement.
        /// </summary>
        public JurisdictionRelatedTerms? JurisdictionRelatedTerms { get; }
        
        /// <summary>
        /// Any additional amendments that might be specified by the parties to the agreement.
        /// </summary>
        public string? AdditionalAmendments { get; }
        
        /// <summary>
        /// Any additional terms that might be specified applicable.
        /// </summary>
        public string? AdditionalBespokeTerms { get; }
        
        /// <summary>
        /// The terms of the Rider for the ISDA Euroclear 2019 Collateral Transfer Agreement with respect to the use of a Pledgee Representative attached to this Agreement.
        /// </summary>
        public PledgeeRepresentativeRider? PledgeeRepresentativeRider { get; }
        
        /// <summary>
        /// A clause providing that final return collateral is to be provided without consideration of any Minimum Transfer Amount and collateral haircut.
        /// </summary>
        public FinalReturns FinalReturns { get; }
    }
    
    /// <summary>
    /// Specification of transfer / settlement timing for cash and securities collateral assuming that the notice is provided before the Notification Time (and with a 1LBD lag introduced if the notice is delivered after the Notification Time), and that securities allow for a further Local Business Day for transfer / settlement.
    /// </summary>
    public class CollateralTransferTiming : AbstractRosettaModelObject<CollateralTransferTiming>
    {
        private static readonly IRosettaMetaData<CollateralTransferTiming> metaData = new CollateralTransferTimingMeta();
        
        [JsonConstructor]
        public CollateralTransferTiming(LegacyTransferSettlementTiming? transferSettlementTiming, LegacyDefinition? legacyDefinition)
        {
            TransferSettlementTiming = transferSettlementTiming;
            LegacyDefinition = legacyDefinition;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTransferTiming> MetaData => metaData;
        
        /// <summary>
        /// Specification of transfer / settlement timing for cash and securities collateral assuming that the notice is provided before the Notification Time (and with a 1LBD lag introduced if the notice is delivered after the Notification Time), and that securities allow for a further Local Business Day for transfer / settlement.
        /// </summary>
        public LegacyTransferSettlementTiming? TransferSettlementTiming { get; }
        
        /// <summary>
        /// Bespoke language removing the pre-print requirement to transfer legal title of securities collateral through written instructions to the relevant depository institution or other securities intermediaries solely for the purposes of the 1994 New York Law Credit Support Annex.
        /// </summary>
        public LegacyDefinition? LegacyDefinition { get; }
    }
    
    /// <summary>
    /// Specifies the treatment terms for the eligible collateral criteria specified.
    /// </summary>
    public class CollateralTreatment : AbstractRosettaModelObject<CollateralTreatment>
    {
        private static readonly IRosettaMetaData<CollateralTreatment> metaData = new CollateralTreatmentMeta();
        
        [JsonConstructor]
        public CollateralTreatment(CollateralValuationTreatment? valuationTreatment, IEnumerable<ConcentrationLimit> concentrationLimit, bool isIncluded)
        {
            ValuationTreatment = valuationTreatment;
            ConcentrationLimit = concentrationLimit;
            IsIncluded = isIncluded;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralTreatment> MetaData => metaData;
        
        /// <summary>
        /// Specification of the valuation treatment for the specified collateral.
        /// </summary>
        public CollateralValuationTreatment? ValuationTreatment { get; }
        
        /// <summary>
        /// Specification of concentration limits applicable to the collateral criteria.
        /// </summary>
        public IEnumerable<ConcentrationLimit> ConcentrationLimit { get; }
        
        /// <summary>
        /// A boolean attribute to specify whether collateral critieria are inclusion (True) or exclusion (False) criteria.
        /// </summary>
        public bool IsIncluded { get; }
    }
    
    /// <summary>
    /// Specification of the valuation treatment for the specified collateral.
    /// </summary>
    public class CollateralValuationTreatment : AbstractRosettaModelObject<CollateralValuationTreatment>
    {
        private static readonly IRosettaMetaData<CollateralValuationTreatment> metaData = new CollateralValuationTreatmentMeta();
        
        [JsonConstructor]
        public CollateralValuationTreatment(decimal? haircutPercentage, decimal? marginPercentage, decimal? fxHaircutPercentage, decimal? additionalHaircutPercentage)
        {
            HaircutPercentage = haircutPercentage;
            MarginPercentage = marginPercentage;
            FxHaircutPercentage = fxHaircutPercentage;
            AdditionalHaircutPercentage = additionalHaircutPercentage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralValuationTreatment> MetaData => metaData;
        
        /// <summary>
        /// Specifies a haircut percentage to be applied to the value of asset and used as a discount factor to the value of the collateral asset,expressed as a percentage in decimal terms. As an example a 0.5% haircut would be represented as a decimal number 0.005.
        /// </summary>
        public decimal? HaircutPercentage { get; }
        
        /// <summary>
        /// Specifies a percentage value of transaction needing to be posted as collateral expressed as a valuation. As an example a 104% requirement would be represented as a decimal number 1.04.
        /// </summary>
        public decimal? MarginPercentage { get; }
        
        /// <summary>
        /// Specifies an FX haircut applied to a specific asset which is agreed between the parties (for example, if pledgor eligible collateral is not denominated in the termination currency or under other specified cases in collateral support documents both for initial margin and variation margin).The percentage value is expressed as the discount haircut to the value of the collateral- as an example an 8% FX haircut would be expressed as 0.08.
        /// </summary>
        public decimal? FxHaircutPercentage { get; }
        
        /// <summary>
        /// Specifies a percentage value of any additional haircut to be applied to a collateral asset,the percentage value is expressed as the discount haircut to the value of the collateral- as an example a 5% haircut would be expressed as 0.05. 
        /// </summary>
        public decimal? AdditionalHaircutPercentage { get; }
    }
    
    /// <summary>
    /// Details how particular types of collateral are valued (other than in respect of a default).
    /// </summary>
    public class CollateralValueMethod : AbstractRosettaModelObject<CollateralValueMethod>
    {
        private static readonly IRosettaMetaData<CollateralValueMethod> metaData = new CollateralValueMethodMeta();
        
        [JsonConstructor]
        public CollateralValueMethod(Enums.ValueCash? cashCollateral, Enums.ValueSecurities? securitiesCollateral, string? additionalLanguage)
        {
            CashCollateral = cashCollateral;
            SecuritiesCollateral = securitiesCollateral;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CollateralValueMethod> MetaData => metaData;
        
        /// <summary>
        /// Details of how cash collateral is valued.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ValueCash? CashCollateral { get; }
        
        /// <summary>
        /// Details of how securities collateral is valued.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ValueSecurities? SecuritiesCollateral { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Identifies a specific commodity by referencing a product identifier or by a product definition.
    /// </summary>
    public class Commodity : AbstractRosettaModelObject<Commodity>, IAssetBase
    {
        private static readonly IRosettaMetaData<Commodity> metaData = new CommodityMeta();
        
        [JsonConstructor]
        public Commodity(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, CommodityProductDefinition? commodityProductDefinition, Enums.QuotationSide priceQuoteType, DeliveryDateParameters? deliveryDateReference, string? description)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            CommodityProductDefinition = commodityProductDefinition;
            PriceQuoteType = priceQuoteType;
            DeliveryDateReference = deliveryDateReference;
            Description = description;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Commodity> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <summary>
        /// Specifies the commodity underlier in the event that no ISDA Commodity Reference Benchmark exists.
        /// </summary>
        public CommodityProductDefinition? CommodityProductDefinition { get; }
        
        /// <summary>
        /// Describes the required quote type of the underlying price that will be observed. Example values include &apos;Bid, &apos;Ask&apos;, &apos;Settlement&apos; (for a futures contract) and &apos;WeightedAverage&apos; (for some published prices and indices).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuotationSide PriceQuoteType { get; }
        
        /// <summary>
        /// Specifies the parameters for identifying the relevant contract date when the commodity reference price is a futures contract.
        /// </summary>
        public DeliveryDateParameters? DeliveryDateReference { get; }
        
        /// <summary>
        /// Provides additional information about the commodity underlier.
        /// </summary>
        public string? Description { get; }
    }
    
    /// <summary>
    /// Payout based on the averaged price of a referenced underlier. (e.g. Commodities). Can represent both average (average of many) &amp; bullet (average of 1) pricing
    /// </summary>
    public class CommodityPayout : AbstractRosettaModelObject<CommodityPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<CommodityPayout> metaData = new CommodityPayoutMeta();
        
        [JsonConstructor]
        public CommodityPayout(PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms, AveragingCalculation? averagingFeature, CommodityPriceReturnTerms? commodityPriceReturnTerms, PricingDates pricingDates, CalculationSchedule? schedule, CalculationPeriodDates? calculationPeriodDates, PaymentDates paymentDates, Underlier underlier, FxFeature? fxFeature, AssetDeliveryInformation? delivery)
        {
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
            AveragingFeature = averagingFeature;
            CommodityPriceReturnTerms = commodityPriceReturnTerms;
            PricingDates = pricingDates;
            Schedule = schedule;
            CalculationPeriodDates = calculationPeriodDates;
            PaymentDates = paymentDates;
            Underlier = underlier;
            FxFeature = fxFeature;
            Delivery = delivery;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommodityPayout> MetaData => metaData;
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
        
        /// <summary>
        /// Indicates if the averaging calculation, when applicable, is weighted or unweighted.
        /// </summary>
        public AveragingCalculation? AveragingFeature { get; }
        
        /// <summary>
        /// Defines parameters in which the commodity price is assessed.
        /// </summary>
        public CommodityPriceReturnTerms? CommodityPriceReturnTerms { get; }
        
        /// <summary>
        /// Specifies specific dates or parametric rules for the dates on which the price will be determined.
        /// </summary>
        public PricingDates PricingDates { get; }
        
        /// <summary>
        /// Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
        /// </summary>
        public CalculationSchedule? Schedule { get; }
        
        /// <summary>
        /// Defines the calculation period dates schedule.
        /// </summary>
        public CalculationPeriodDates? CalculationPeriodDates { get; }
        
        /// <summary>
        /// Defines the payment date schedule, as defined by the parameters that are needed to specify it, either in a parametric way or by reference to another schedule of dates (e.g. the valuation dates).
        /// </summary>
        public PaymentDates PaymentDates { get; }
        
        /// <summary>
        /// Identifies the underlying product that is referenced for pricing of the applicable leg in a swap. Referenced in the &apos;2018 ISDA CDM Equity Confirmation for Security Equity Swap&apos; as Security.
        /// </summary>
        public Underlier Underlier { get; }
        
        /// <summary>
        /// Defines quanto or composite FX features that are included in the swap leg.
        /// </summary>
        public FxFeature? FxFeature { get; }
        
        /// <summary>
        /// Contains the information relative to the delivery of the asset.
        /// </summary>
        public AssetDeliveryInformation? Delivery { get; }
    }
    
    /// <summary>
    /// Defines parameters in which the commodity price is assessed.
    /// </summary>
    public class CommodityPriceReturnTerms : AbstractRosettaModelObject<CommodityPriceReturnTerms>
    {
        private static readonly IRosettaMetaData<CommodityPriceReturnTerms> metaData = new CommodityPriceReturnTermsMeta();
        
        [JsonConstructor]
        public CommodityPriceReturnTerms(Rounding? rounding, SpreadSchedule? spread, RollFeature? rollFeature, decimal? conversionFactor)
        {
            Rounding = rounding;
            Spread = spread;
            RollFeature = rollFeature;
            ConversionFactor = conversionFactor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommodityPriceReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Defines rounding rules and precision to be used in the rounding of a number.
        /// </summary>
        public Rounding? Rounding { get; }
        
        /// <summary>
        /// Defines a spread value for one or more defined dates.
        /// </summary>
        public SpreadSchedule? Spread { get; }
        
        /// <summary>
        /// Used in conjunction with an exchange-based pricing source. Identifies a way in which the futures contracts referenced will roll between periods. 
        /// </summary>
        public RollFeature? RollFeature { get; }
        
        /// <summary>
        /// Defines the conversion applied if the quantity unit on contract is different from unit on referenced underlier.
        /// </summary>
        public decimal? ConversionFactor { get; }
    }
    
    /// <summary>
    /// Specifies the commodity underlier in the event that no ISDA Commodity Reference Price exists.
    /// </summary>
    public class CommodityProductDefinition : AbstractRosettaModelObject<CommodityProductDefinition>
    {
        private static readonly IRosettaMetaData<CommodityProductDefinition> metaData = new CommodityProductDefinitionMeta();
        
        [JsonConstructor]
        public CommodityProductDefinition(CommodityReferenceFramework referenceFramework, PriceSource? priceSource, Enums.CommodityInformationPublisher? commodityInfoPublisher, FieldWithMetaString exchangeId)
        {
            ReferenceFramework = referenceFramework;
            PriceSource = priceSource;
            CommodityInfoPublisher = commodityInfoPublisher;
            ExchangeId = exchangeId;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommodityProductDefinition> MetaData => metaData;
        
        /// <summary>
        /// Specifies the type of commodity.
        /// </summary>
        public CommodityReferenceFramework ReferenceFramework { get; }
        
        /// <summary>
        /// Specifies a publication that provides the commodity price, including, where applicable the details of where in the publication the price is published.  Applicable when the commodity reference price is not a futures contract
        /// </summary>
        public PriceSource? PriceSource { get; }
        
        /// <summary>
        /// Specifies the publication where the commodity prices can be found.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CommodityInformationPublisher? CommodityInfoPublisher { get; }
        
        /// <summary>
        ///  Identifies the exchange from which the reference price should be sourced, using the scheme at the following url: http://www.fpml.org/coding-scheme/external/exchange-id-MIC-1-0
        /// </summary>
        public FieldWithMetaString ExchangeId { get; }
    }
    
    /// <summary>
    /// Specifies the type of commodity.
    /// </summary>
    public class CommodityReferenceFramework : AbstractRosettaModelObject<CommodityReferenceFramework>
    {
        private static readonly IRosettaMetaData<CommodityReferenceFramework> metaData = new CommodityReferenceFrameworkMeta();
        
        [JsonConstructor]
        public CommodityReferenceFramework(string commodityName, Enums.CapacityUnit? capacityUnit, Enums.WeatherUnit? weatherUnit, FieldWithMetaString currency)
        {
            CommodityName = commodityName;
            CapacityUnit = capacityUnit;
            WeatherUnit = weatherUnit;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CommodityReferenceFramework> MetaData => metaData;
        
        /// <summary>
        /// Identifies the commodity more specifically. Where possible, this should follow the naming convention used in the 2005 ISDA Commodity Definitions SubAnnex A, including the subCommodity and additional qualifiers, but should be limited to 256 characters or less.
        /// </summary>
        public string CommodityName { get; }
        
        /// <summary>
        /// Provides an enumerated value for a capacity unit, generally used in the context of defining quantities for commodities.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CapacityUnit? CapacityUnit { get; }
        
        /// <summary>
        /// Provides an enumerated values for a weather unit, generally used in the context of defining quantities for commodities.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.WeatherUnit? WeatherUnit { get; }
        
        /// <summary>
        /// Defines the currency in which the commodity is priced.
        /// </summary>
        public FieldWithMetaString Currency { get; }
    }
    
    /// <summary>
    /// Specifies the conditions to be applied for converting into a reference currency when the actual currency rate is not determined upfront.
    /// </summary>
    public class Composite : AbstractRosettaModelObject<Composite>
    {
        private static readonly IRosettaMetaData<Composite> metaData = new CompositeMeta();
        
        [JsonConstructor]
        public Composite(Enums.DeterminationMethod? determinationMethod, RelativeDateOffset? relativeDate, FxSpotRateSource? fxSpotRateSource, BusinessCenterTime? fixingTime)
        {
            DeterminationMethod = determinationMethod;
            RelativeDate = relativeDate;
            FxSpotRateSource = fxSpotRateSource;
            FixingTime = fixingTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Composite> MetaData => metaData;
        
        /// <summary>
        /// Specifies the method according to which an amount or a date is determined.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? DeterminationMethod { get; }
        
        /// <summary>
        /// A date specified as some offset to another date (the anchor date).
        /// </summary>
        public RelativeDateOffset? RelativeDate { get; }
        
        /// <summary>
        /// Specifies the methodology (reference source and, optionally, fixing time) to be used for determining a currency conversion rate.
        /// </summary>
        public FxSpotRateSource? FxSpotRateSource { get; }
        
        /// <summary>
        /// The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.
        /// </summary>
        public BusinessCenterTime? FixingTime { get; }
    }
    
    /// <summary>
    /// A class to specify the outcome of a computed amount, for testing purposes.
    /// </summary>
    public class ComputedAmount : AbstractRosettaModelObject<ComputedAmount>
    {
        private static readonly IRosettaMetaData<ComputedAmount> metaData = new ComputedAmountMeta();
        
        [JsonConstructor]
        public ComputedAmount(string callFunction, decimal amount, FieldWithMetaString? currency)
        {
            CallFunction = callFunction;
            Amount = amount;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ComputedAmount> MetaData => metaData;
        
        public string CallFunction { get; }
        
        public decimal Amount { get; }
        
        /// <summary>
        /// The currency in which the computed amount is denominated. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
    }
    
    /// <summary>
    /// Represents a class to describe concentration limits that may be applicable to eligible collateral criteria.
    /// </summary>
    public class ConcentrationLimit : AbstractRosettaModelObject<ConcentrationLimit>
    {
        private static readonly IRosettaMetaData<ConcentrationLimit> metaData = new ConcentrationLimitMeta();
        
        [JsonConstructor]
        public ConcentrationLimit(ConcentrationLimitCriteria? concentrationLimitCriteria, MoneyRange? valueLimit, NumberRange? percentageLimit)
        {
            ConcentrationLimitCriteria = concentrationLimitCriteria;
            ValueLimit = valueLimit;
            PercentageLimit = percentageLimit;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ConcentrationLimit> MetaData => metaData;
        
        /// <summary>
        /// Specifies a set of criteria to describe the assets that the concentration limits apply to.
        /// </summary>
        public ConcentrationLimitCriteria? ConcentrationLimitCriteria { get; }
        
        /// <summary>
        /// Specifies the value of collateral limit represented as a range.
        /// </summary>
        public MoneyRange? ValueLimit { get; }
        
        /// <summary>
        /// Specifies the perecentage of collateral limit represented as a decimal number - example 25% is 0.25.
        /// </summary>
        public NumberRange? PercentageLimit { get; }
    }
    
    /// <summary>
    /// Respresents a class to describe a set of criteria to describe specific assets that the concentration limits apply to.
    /// </summary>
    public class ConcentrationLimitCriteria : AbstractRosettaModelObject<ConcentrationLimitCriteria>, ICollateralCriteriaBase
    {
        private static readonly IRosettaMetaData<ConcentrationLimitCriteria> metaData = new ConcentrationLimitCriteriaMeta();
        
        [JsonConstructor]
        public ConcentrationLimitCriteria(CollateralCriteria? collateralCriteria, IEnumerable<Enums.CounterpartyRole> appliesTo, Enums.CollateralMarginType? restrictTo, Enums.RatingPriorityResolution? ratingPriorityResolution, Enums.ConcentrationLimitType? concentrationLimitType, AverageTradingVolume? averageTradingVolume)
        {
            CollateralCriteria = collateralCriteria;
            AppliesTo = appliesTo;
            RestrictTo = restrictTo;
            RatingPriorityResolution = ratingPriorityResolution;
            ConcentrationLimitType = concentrationLimitType;
            AverageTradingVolume = averageTradingVolume;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ConcentrationLimitCriteria> MetaData => metaData;
        
        /// <inheritdoc/>
        public CollateralCriteria? CollateralCriteria { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> AppliesTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralMarginType? RestrictTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatingPriorityResolution? RatingPriorityResolution { get; }
        
        /// <summary>
        /// Specifies the type of concentration limit to be applied.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ConcentrationLimitType? ConcentrationLimitType { get; }
        
        /// <summary>
        /// Specifies an average trading volume on an exchange in relation to Equity products.
        /// </summary>
        public AverageTradingVolume? AverageTradingVolume { get; }
    }
    
    /// <summary>
    /// A class to specify the two set of elections that may overwrite the default Condition Precedent provision.
    /// </summary>
    public class ConditionsPrecedent : AbstractRosettaModelObject<ConditionsPrecedent>
    {
        private static readonly IRosettaMetaData<ConditionsPrecedent> metaData = new ConditionsPrecedentMeta();
        
        [JsonConstructor]
        public ConditionsPrecedent(Enums.Exception? conditionsPrecedentElection, string? customProvision, AccessConditions accessConditions, SpecifiedCondition? specifiedCondition)
        {
            ConditionsPrecedentElection = conditionsPrecedentElection;
            CustomProvision = customProvision;
            AccessConditions = accessConditions;
            SpecifiedCondition = specifiedCondition;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ConditionsPrecedent> MetaData => metaData;
        
        /// <summary>
        /// The election to specify whether the standard Conditions Precedent apply.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.Exception? ConditionsPrecedentElection { get; }
        
        /// <summary>
        /// The custom provisions that might be specified by the parties to the agreement for the purpose of overwriting the default Condition Precedent provision specified in the CSA.
        /// </summary>
        public string? CustomProvision { get; }
        
        /// <summary>
        /// The parties&apos; election with respect to the Termination Events that will be deemed an Access Condition (Initial Margin CSA) or a Specified Condition (Variation Margin CSA).
        /// </summary>
        public AccessConditions AccessConditions { get; }
        
        /// <summary>
        /// Specifies events elected by the parties, that if triggered, can temporarily or permanently suspend rights to rehypothecate, transfer or substitute collateral.
        /// </summary>
        public SpecifiedCondition? SpecifiedCondition { get; }
    }
    
    /// <summary>
    /// A class describing the weight of each of the underlier constituent within the basket, either in absolute or relative terms.
    /// </summary>
    public class ConstituentWeight : AbstractRosettaModelObject<ConstituentWeight>
    {
        private static readonly IRosettaMetaData<ConstituentWeight> metaData = new ConstituentWeightMeta();
        
        [JsonConstructor]
        public ConstituentWeight(decimal? openUnits, decimal? basketPercentage)
        {
            OpenUnits = openUnits;
            BasketPercentage = basketPercentage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ConstituentWeight> MetaData => metaData;
        
        /// <summary>
        /// The number of units (index or securities) that constitute the underlier of the swap. In the case of a basket swap, this element is used to reference both the number of basket units, and the number of each asset components of the basket when these are expressed in absolute terms.
        /// </summary>
        public decimal? OpenUnits { get; }
        
        /// <summary>
        /// The relative weight of each respective basket constituent, expressed in percentage. A basket percentage of 5% would be represented as 0.05.
        /// </summary>
        public decimal? BasketPercentage { get; }
    }
    
    /// <summary>
    /// A class to specify the parties&apos; election to specify contact information, in relation to elections such as the Addresses for Transfer or the Demand and Notices as specified in the ISDA Credit Support Annex agreement.
    /// </summary>
    public class ContactElection : AbstractRosettaModelObject<ContactElection>
    {
        private static readonly IRosettaMetaData<ContactElection> metaData = new ContactElectionMeta();
        
        [JsonConstructor]
        public ContactElection(IEnumerable<PartyContactInformation> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContactElection> MetaData => metaData;
        
        /// <summary>
        /// The parties&apos; contact information election.
        /// </summary>
        public IEnumerable<PartyContactInformation> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify contact information associated with a party: telephone, postal/street address, email and web page.
    /// </summary>
    public class ContactInformation : AbstractRosettaModelObject<ContactInformation>
    {
        private static readonly IRosettaMetaData<ContactInformation> metaData = new ContactInformationMeta();
        
        [JsonConstructor]
        public ContactInformation(IEnumerable<TelephoneNumber> telephone, IEnumerable<Address> address, IEnumerable<string> email, IEnumerable<string> webPage)
        {
            Telephone = telephone;
            Address = address;
            Email = email;
            WebPage = webPage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContactInformation> MetaData => metaData;
        
        /// <summary>
        /// The telephone number.
        /// </summary>
        public IEnumerable<TelephoneNumber> Telephone { get; }
        
        /// <summary>
        /// The street/postal address.
        /// </summary>
        public IEnumerable<Address> Address { get; }
        
        /// <summary>
        /// The email address.
        /// </summary>
        public IEnumerable<string> Email { get; }
        
        /// <summary>
        /// The web page. This attribute is not specified as part of the FpML ContactInformation complex type.
        /// </summary>
        public IEnumerable<string> WebPage { get; }
    }
    
    /// <summary>
    /// Encapsulates data features common to trade and position.
    /// </summary>
    public class ContractBase : AbstractRosettaModelObject<ContractBase>, IContractBase
    {
        private static readonly IRosettaMetaData<ContractBase> metaData = new ContractBaseMeta();
        
        [JsonConstructor]
        public ContractBase(ReferenceWithMetaContractDetails? contractDetails, ReferenceWithMetaExecutionDetails? executionDetails, ReferenceWithMetaCollateral? collateral)
        {
            ContractDetails = contractDetails;
            ExecutionDetails = executionDetails;
            Collateral = collateral;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaContractDetails? ContractDetails { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaExecutionDetails? ExecutionDetails { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateral? Collateral { get; }
    }
    
    /// <summary>
    /// Defines specific attributes that relate to contractual details of trades.
    /// </summary>
    public class ContractDetails : AbstractRosettaModelObject<ContractDetails>
    {
        private static readonly IRosettaMetaData<ContractDetails> metaData = new ContractDetailsMeta();
        
        [JsonConstructor]
        public ContractDetails(IEnumerable<LegalAgreement> documentation, FieldWithMetaGoverningLawEnum? governingLaw, _MetaFields? meta)
        {
            Documentation = documentation;
            GoverningLaw = governingLaw;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractDetails> MetaData => metaData;
        
        /// <summary>
        /// Represents the legal document(s) that governs a trade and associated contractual product terms, either as a reference to such documents when specified as part of the CDM, or through identification of some of the key terms of those documents, such as the type of document, the document identifier, the publisher, the document vintage and the agreement date.
        /// </summary>
        public IEnumerable<LegalAgreement> Documentation { get; }
        
        /// <summary>
        /// Represents the law governing the trade and associated contractual product terms.
        /// </summary>
        public FieldWithMetaGoverningLawEnum? GoverningLaw { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies instructions to create a fully formed contract, with optional legal agreements.
    /// </summary>
    public class ContractFormationInstruction : AbstractRosettaModelObject<ContractFormationInstruction>
    {
        private static readonly IRosettaMetaData<ContractFormationInstruction> metaData = new ContractFormationInstructionMeta();
        
        [JsonConstructor]
        public ContractFormationInstruction(IEnumerable<LegalAgreement> legalAgreement)
        {
            LegalAgreement = legalAgreement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractFormationInstruction> MetaData => metaData;
        
        /// <summary>
        /// Optional legal agreements associated to the contract being formed, for instance a master agreement.
        /// </summary>
        public IEnumerable<LegalAgreement> LegalAgreement { get; }
    }
    
    public class ContractualDefinition : AbstractRosettaModelObject<ContractualDefinition>
    {
        private static readonly IRosettaMetaData<ContractualDefinition> metaData = new ContractualDefinitionMeta();
        
        [JsonConstructor]
        public ContractualDefinition(Identifier? identifier, ContractualDefinitionIdentifier? contractualDefinitionIdentifier, LocalDate? publicationDate)
        {
            Identifier = identifier;
            ContractualDefinitionIdentifier = contractualDefinitionIdentifier;
            PublicationDate = publicationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractualDefinition> MetaData => metaData;
        
        /// <summary>
        /// Corresponds to the unique identifier of the Contractual Definition in which the code is published
        /// </summary>
        public Identifier? Identifier { get; }
        
        /// <summary>
        /// Contractual Definition Identifier in which the code is published. Includes Document Type and Document Version
        /// </summary>
        public ContractualDefinitionIdentifier? ContractualDefinitionIdentifier { get; }
        
        /// <summary>
        /// 2021-06-11
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? PublicationDate { get; }
    }
    
    public class ContractualDefinitionIdentifier : AbstractRosettaModelObject<ContractualDefinitionIdentifier>
    {
        private static readonly IRosettaMetaData<ContractualDefinitionIdentifier> metaData = new ContractualDefinitionIdentifierMeta();
        
        [JsonConstructor]
        public ContractualDefinitionIdentifier(Enums.ContractualDefinitions contractualDefinitionType, string? contractualDefinitionVersion)
        {
            ContractualDefinitionType = contractualDefinitionType;
            ContractualDefinitionVersion = contractualDefinitionVersion;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractualDefinitionIdentifier> MetaData => metaData;
        
        /// <summary>
        /// e.g. ISDA2021Definitions
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ContractualDefinitions ContractualDefinitionType { get; }
        
        /// <summary>
        /// e.g. V1
        /// </summary>
        public string? ContractualDefinitionVersion { get; }
    }
    
    public class ContractualMatrix : AbstractRosettaModelObject<ContractualMatrix>
    {
        private static readonly IRosettaMetaData<ContractualMatrix> metaData = new ContractualMatrixMeta();
        
        [JsonConstructor]
        public ContractualMatrix(FieldWithMetaMatrixTypeEnum matrixType, FieldWithMetaMatrixTermEnum? matrixTerm)
        {
            MatrixType = matrixType;
            MatrixTerm = matrixTerm;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractualMatrix> MetaData => metaData;
        
        /// <summary>
        /// Identifies the form of applicable matrix.
        /// </summary>
        public FieldWithMetaMatrixTypeEnum MatrixType { get; }
        
        /// <summary>
        /// Defines any applicable key into the relevant matrix. For example, the Transaction Type would be the single term required for the Credit Derivatives Physical Settlement Matrix. This element should be omitted in the case of the 2000 ISDA Definitions Settlement Matrix for Early Termination and Swaptions.
        /// </summary>
        public FieldWithMetaMatrixTermEnum? MatrixTerm { get; }
    }
    
    /// <summary>
    /// A contractual supplement (such as those published by ISDA) and its publication date that will apply to the trade.
    /// </summary>
    public class ContractualTermsSupplement : AbstractRosettaModelObject<ContractualTermsSupplement>
    {
        private static readonly IRosettaMetaData<ContractualTermsSupplement> metaData = new ContractualTermsSupplementMeta();
        
        [JsonConstructor]
        public ContractualTermsSupplement(FieldWithMetaContractualSupplementTypeEnum contractualTermsSupplementType, LocalDate? publicationDate)
        {
            ContractualTermsSupplementType = contractualTermsSupplementType;
            PublicationDate = publicationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ContractualTermsSupplement> MetaData => metaData;
        
        /// <summary>
        /// Identifies the form of applicable contractual supplement.
        /// </summary>
        public FieldWithMetaContractualSupplementTypeEnum ContractualTermsSupplementType { get; }
        
        /// <summary>
        /// Specifies the publication date of the applicable version of the contractual supplement.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? PublicationDate { get; }
    }
    
    /// <summary>
    /// A class to specify the relationship between the Control Agreement and the Credit Support Agreement.
    /// </summary>
    public class ControlAgreement : AbstractRosettaModelObject<ControlAgreement>
    {
        private static readonly IRosettaMetaData<ControlAgreement> metaData = new ControlAgreementMeta();
        
        [JsonConstructor]
        public ControlAgreement(IEnumerable<ControlAgreementElections> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ControlAgreement> MetaData => metaData;
        
        /// <summary>
        /// The party specific elections.
        /// </summary>
        public IEnumerable<ControlAgreementElections> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify the Control Agreement election sby each party to the agreement.
    /// </summary>
    public class ControlAgreementElections : AbstractRosettaModelObject<ControlAgreementElections>
    {
        private static readonly IRosettaMetaData<ControlAgreementElections> metaData = new ControlAgreementElectionsMeta();
        
        [JsonConstructor]
        public ControlAgreementElections(Enums.CounterpartyRole party, bool controlAgreementAsCsd, bool? consistencyWithControlAgreement, bool? relationshipWithControlAgreement)
        {
            Party = party;
            ControlAgreementAsCsd = controlAgreementAsCsd;
            ConsistencyWithControlAgreement = consistencyWithControlAgreement;
            RelationshipWithControlAgreement = relationshipWithControlAgreement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ControlAgreementElections> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The identification of whether the Control Agreement is a Credit Support Document with respect to each party.
        /// </summary>
        public bool ControlAgreementAsCsd { get; }
        
        /// <summary>
        /// Unless specified as inapplicable in the event of any inconsistency between this Deed and the Control Agreement, this Deed will prevail over the Control Agreement.
        /// </summary>
        public bool? ConsistencyWithControlAgreement { get; }
        
        /// <summary>
        /// Unless specified as inapplicable the parties recognise that the Control Agreement is a means by which the parties can perform their obligations.
        /// </summary>
        public bool? RelationshipWithControlAgreement { get; }
    }
    
    /// <summary>
    /// A class to specify Control Agreement language related to delivery of a Notice of Exclusive Control.
    /// </summary>
    public class ControlAgreementNecEvent : AbstractRosettaModelObject<ControlAgreementNecEvent>
    {
        private static readonly IRosettaMetaData<ControlAgreementNecEvent> metaData = new ControlAgreementNecEventMeta();
        
        [JsonConstructor]
        public ControlAgreementNecEvent(IEnumerable<ControlAgreementNecEventElection> controlAgreementNecEventElection)
        {
            ControlAgreementNecEventElection = controlAgreementNecEventElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ControlAgreementNecEvent> MetaData => metaData;
        
        /// <summary>
        /// Indicates party specific Control Agreement language related to delivery of a Notice of Exclusive Control.
        /// </summary>
        public IEnumerable<ControlAgreementNecEventElection> ControlAgreementNecEventElection { get; }
    }
    
    /// <summary>
    /// A class to specify party specific Control Agreement language related to delivery of a Notice of Exclusive Control.
    /// </summary>
    public class ControlAgreementNecEventElection : AbstractRosettaModelObject<ControlAgreementNecEventElection>
    {
        private static readonly IRosettaMetaData<ControlAgreementNecEventElection> metaData = new ControlAgreementNecEventElectionMeta();
        
        [JsonConstructor]
        public ControlAgreementNecEventElection(Enums.CounterpartyRole party, bool necEvent)
        {
            Party = party;
            NecEvent = necEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ControlAgreementNecEventElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// Indicates Control Agreement language related to delivery of a Notice of Exclusive Control.
        /// </summary>
        public bool NecEvent { get; }
    }
    
    /// <summary>
    /// Specifies the relevant data regarding a corporate action
    /// </summary>
    public class CorporateAction : AbstractRosettaModelObject<CorporateAction>
    {
        private static readonly IRosettaMetaData<CorporateAction> metaData = new CorporateActionMeta();
        
        [JsonConstructor]
        public CorporateAction(Enums.CorporateActionType corporateActionType, LocalDate exDate, LocalDate payDate, LocalDate? recordDate, LocalDate? announcementDate, Underlier underlier, AdjustmentFactor? adjustmentFactor, InformationSource? informationSource, PriceSchedule? dividendObservation, string? bespokeEventDescription)
        {
            CorporateActionType = corporateActionType;
            ExDate = exDate;
            PayDate = payDate;
            RecordDate = recordDate;
            AnnouncementDate = announcementDate;
            Underlier = underlier;
            AdjustmentFactor = adjustmentFactor;
            InformationSource = informationSource;
            DividendObservation = dividendObservation;
            BespokeEventDescription = bespokeEventDescription;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CorporateAction> MetaData => metaData;
        
        /// <summary>
        /// The type of corporate action taking place.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CorporateActionType CorporateActionType { get; }
        
        /// <summary>
        /// The date on which the corporate action is known to have taken place.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ExDate { get; }
        
        /// <summary>
        /// The date on which resulting from the corporate action are delivered.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate PayDate { get; }
        
        /// <summary>
        /// The date on which the account phyical balance and related underlier ownership is recorded by the custodian.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? RecordDate { get; }
        
        /// <summary>
        /// The date on which the corporate action is announced by the issuer.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AnnouncementDate { get; }
        
        /// <summary>
        /// The underlier impacted by the corporate action.
        /// </summary>
        public Underlier Underlier { get; }
        
        /// <summary>
        /// Specifies any additional details e.g. further descriptions depending on the particular type of Corporate Action, adjustmentFactor, calculations
        /// </summary>
        public AdjustmentFactor? AdjustmentFactor { get; }
        
        /// <summary>
        /// A class defining the source of data used in an Observation for any purposes. The data is either sourced from a Provider, or from a Party.
        /// </summary>
        public InformationSource? InformationSource { get; }
        
        /// <summary>
        /// To record observations of dividends.
        /// </summary>
        public PriceSchedule? DividendObservation { get; }
        
        /// <summary>
        /// Corporate action triggered by the occurrence of an event which description is seperatly agreed between the parties and/or described in any referenced agreement (for instance bespoke term described in any string type objects present in most root attributes of Agreement type).
        /// </summary>
        public string? BespokeEventDescription { get; }
    }
    
    public class CorrelationReturnTerms : AbstractRosettaModelObject<CorrelationReturnTerms>, IReturnTermsBase
    {
        private static readonly IRosettaMetaData<CorrelationReturnTerms> metaData = new CorrelationReturnTermsMeta();
        
        [JsonConstructor]
        public CorrelationReturnTerms(ValuationTerms valuationTerms, int? annualizationFactor, DividendApplicability? dividendApplicability, EquityUnderlierProvisions? equityUnderlierProvisions, bool? sharePriceDividendAdjustment, int expectedN, decimal? initialLevel, Enums.DeterminationMethod? initialLevelSource, bool? meanAdjustment, string? performance, Price correlationStrikePrice, NumberRange? boundedCorrelation, int? numberOfDataSeries)
        {
            ValuationTerms = valuationTerms;
            AnnualizationFactor = annualizationFactor;
            DividendApplicability = dividendApplicability;
            EquityUnderlierProvisions = equityUnderlierProvisions;
            SharePriceDividendAdjustment = sharePriceDividendAdjustment;
            ExpectedN = expectedN;
            InitialLevel = initialLevel;
            InitialLevelSource = initialLevelSource;
            MeanAdjustment = meanAdjustment;
            Performance = performance;
            CorrelationStrikePrice = correlationStrikePrice;
            BoundedCorrelation = boundedCorrelation;
            NumberOfDataSeries = numberOfDataSeries;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CorrelationReturnTerms> MetaData => metaData;
        
        /// <inheritdoc/>
        public ValuationTerms ValuationTerms { get; }
        
        /// <inheritdoc/>
        public int? AnnualizationFactor { get; }
        
        /// <inheritdoc/>
        public DividendApplicability? DividendApplicability { get; }
        
        /// <inheritdoc/>
        public EquityUnderlierProvisions? EquityUnderlierProvisions { get; }
        
        /// <inheritdoc/>
        public bool? SharePriceDividendAdjustment { get; }
        
        /// <inheritdoc/>
        public int ExpectedN { get; }
        
        /// <inheritdoc/>
        public decimal? InitialLevel { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? InitialLevelSource { get; }
        
        /// <inheritdoc/>
        public bool? MeanAdjustment { get; }
        
        /// <inheritdoc/>
        public string? Performance { get; }
        
        /// <summary>
        /// Correlation Strike Price in accordance with the ISDA 2011 Equity Derivatives Definitions.
        /// </summary>
        public Price CorrelationStrikePrice { get; }
        
        /// <summary>
        /// Describes correlation bounds, which form a cap and a floor on the realized correlation.
        /// </summary>
        public NumberRange? BoundedCorrelation { get; }
        
        /// <summary>
        /// Number of data series, normal market practice is that correlation data sets are drawn from geographic market areas, such as America, Europe and Asia Pacific, each of these geographic areas will have its own data series to avoid contagion.
        /// </summary>
        public int? NumberOfDataSeries { get; }
    }
    
    /// <summary>
    /// Defines a counterparty enumerated value, e.g. Party1 or Party2, with an associated party reference. The product is agnostic to the actual parties to the transaction, with the party references abstracted away from the product definition and replaced by the CounterpartyEnum (e.g. values Party1 or Party2). The CounterpartyEnum can then be positioned in the product (e.g. to specify which counterparty is the payer, receiver etc) and this Counterparty type, which is positioned outside of the product definition, allows the CounterpartyEnum to be associated with an actual party reference.
    /// </summary>
    public class Counterparty : AbstractRosettaModelObject<Counterparty>
    {
        private static readonly IRosettaMetaData<Counterparty> metaData = new CounterpartyMeta();
        
        [JsonConstructor]
        public Counterparty(Enums.CounterpartyRole role, ReferenceWithMetaParty partyReference)
        {
            Role = role;
            PartyReference = partyReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Counterparty> MetaData => metaData;
        
        /// <summary>
        /// Specifies the CounterpartyEnum, e.g. either Party1 or Party2, that is associated to the partyReference.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Role { get; }
        
        /// <summary>
        /// Specifies the party that is associated to the counterparty.
        /// </summary>
        public ReferenceWithMetaParty PartyReference { get; }
    }
    
    public class CounterpartyOwnIssuePermitted : AbstractRosettaModelObject<CounterpartyOwnIssuePermitted>
    {
        private static readonly IRosettaMetaData<CounterpartyOwnIssuePermitted> metaData = new CounterpartyOwnIssuePermittedMeta();
        
        [JsonConstructor]
        public CounterpartyOwnIssuePermitted(bool counterpartyOwnIssuePermitted)
        {
            CounterpartyOwnIssuePermittedValue = counterpartyOwnIssuePermitted;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CounterpartyOwnIssuePermitted> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter based on whether it is permitted for the underlying asset to be issued by the posting entity or part of their corporate family.
        /// </summary>
        [JsonProperty(PropertyName = "counterpartyOwnIssuePermitted")]
        public bool CounterpartyOwnIssuePermittedValue { get; }
    }
    
    /// <summary>
    /// A Position describes the accumulated effect of a set of securities or financial transactions.
    /// </summary>
    public class CounterpartyPosition : AbstractRosettaModelObject<CounterpartyPosition>, IContractBase
    {
        private static readonly IRosettaMetaData<CounterpartyPosition> metaData = new CounterpartyPositionMeta();
        
        [JsonConstructor]
        public CounterpartyPosition(ReferenceWithMetaContractDetails? contractDetails, ReferenceWithMetaExecutionDetails? executionDetails, ReferenceWithMetaCollateral? collateral, IEnumerable<PositionIdentifier> positionIdentifier, LocalDateTime? openDateTime, IEnumerable<ReferenceWithMetaTradeState> tradeReference, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, TradableProduct positionBase)
        {
            ContractDetails = contractDetails;
            ExecutionDetails = executionDetails;
            Collateral = collateral;
            PositionIdentifier = positionIdentifier;
            OpenDateTime = openDateTime;
            TradeReference = tradeReference;
            Party = party;
            PartyRole = partyRole;
            PositionBase = positionBase;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CounterpartyPosition> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaContractDetails? ContractDetails { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaExecutionDetails? ExecutionDetails { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateral? Collateral { get; }
        
        /// <summary>
        /// Represents the identifier(s) that uniquely identify a position for an identity issuer. A position can include multiple identifiers, for example an internal position identifer and a UTI (Unique Trade Identifier).
        /// </summary>
        public IEnumerable<PositionIdentifier> PositionIdentifier { get; }
        
        /// <summary>
        /// The date and time when the position was opened.
        /// </summary>
        public LocalDateTime? OpenDateTime { get; }
        
        /// <summary>
        /// Reference to all the trades that constitute the position.
        /// </summary>
        public IEnumerable<ReferenceWithMetaTradeState> TradeReference { get; }
        
        /// <summary>
        /// The parties involved in the position, including the Clearing Organization.
        /// </summary>
        public IEnumerable<Party> Party { get; }
        
        /// <summary>
        /// Represents the role each specified party takes in the position.
        /// </summary>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <summary>
        /// Encapsulates the core constituents that characterize a position.
        /// </summary>
        public TradableProduct PositionBase { get; }
    }
    
    /// <summary>
    /// A business event represents a life cycle event of a position. The combination of the state changes results in a qualifiable life cycle event.
    /// </summary>
    public class CounterpartyPositionBusinessEvent : AbstractRosettaModelObject<CounterpartyPositionBusinessEvent>
    {
        private static readonly IRosettaMetaData<CounterpartyPositionBusinessEvent> metaData = new CounterpartyPositionBusinessEventMeta();
        
        [JsonConstructor]
        public CounterpartyPositionBusinessEvent(Enums.PositionEventIntent intent, Enums.CorporateActionType? corporateActionIntent, LocalDate? eventDate, LocalDate? effectiveDate, IdentifiedList? packageInformation, IEnumerable<CounterpartyPositionState> after)
        {
            Intent = intent;
            CorporateActionIntent = corporateActionIntent;
            EventDate = eventDate;
            EffectiveDate = effectiveDate;
            PackageInformation = packageInformation;
            After = after;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CounterpartyPositionBusinessEvent> MetaData => metaData;
        
        /// <summary>
        /// The intent attribute is meant to be specified when the event qualification cannot be programmatically inferred from the event features. As a result it is only associated with those primitives that can give way to such ambiguity, the quantityChange being one of those.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PositionEventIntent Intent { get; }
        
        /// <summary>
        /// The intent of a corporate action on the position.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CorporateActionType? CorporateActionIntent { get; }
        
        /// <summary>
        /// Specifies the date on which the event is taking place. This date is equal to the trade date in the case of a simple execution.  However it can be different from the trade date, for example in the case of a partial termination.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EventDate { get; }
        
        /// <summary>
        /// The date on which the event contractually takes effect, when different from the event date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <summary>
        /// Specifies the package information in case the business event represents several trades executed as a package (hence this attribute is optional). The package information is only instantiated once at the business event level to preserve referential integrity, whereas individual trades make reference to it to identify that they are part of a package.
        /// </summary>
        public IdentifiedList? PackageInformation { get; }
        
        /// <summary>
        /// Specifies the after position state(s) created.
        /// </summary>
        public IEnumerable<CounterpartyPositionState> After { get; }
    }
    
    /// <summary>
    /// Defines the fundamental financial information that can be changed by a Primitive Event and by extension any business or life-cycle event. Each PositionState specifies where a Position is in its life-cycle. PositionState is a root type and as such, can be created independently to any other CDM data type, but can also be used as part of the CDM Event Model.
    /// </summary>
    public class CounterpartyPositionState : AbstractRosettaModelObject<CounterpartyPositionState>
    {
        private static readonly IRosettaMetaData<CounterpartyPositionState> metaData = new CounterpartyPositionStateMeta();
        
        [JsonConstructor]
        public CounterpartyPositionState(CounterpartyPosition counterpartyPosition, State? state, IEnumerable<ObservationEvent> observationHistory, IEnumerable<Valuation> valuationHistory, _MetaFields? meta)
        {
            CounterpartyPosition = counterpartyPosition;
            State = state;
            ObservationHistory = observationHistory;
            ValuationHistory = valuationHistory;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CounterpartyPositionState> MetaData => metaData;
        
        /// <summary>
        /// Represents the Position that has been effected by a business or life-cycle event.
        /// </summary>
        public CounterpartyPosition CounterpartyPosition { get; }
        
        /// <summary>
        /// Represents the State of the Position through its life-cycle.
        /// </summary>
        public State? State { get; }
        
        /// <summary>
        /// Represents the observed events related to a particular product or process, such as credit events or corporate actions.
        /// </summary>
        public IEnumerable<ObservationEvent> ObservationHistory { get; }
        
        public IEnumerable<Valuation> ValuationHistory { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specification of Transactions covered by the legal agreement.
    /// </summary>
    public class CoveredTransactions : AbstractRosettaModelObject<CoveredTransactions>
    {
        private static readonly IRosettaMetaData<CoveredTransactions> metaData = new CoveredTransactionsMeta();
        
        [JsonConstructor]
        public CoveredTransactions(LocalDate inclusionDate, IEnumerable<ProductTaxonomy> coveredTransactions, IEnumerable<string> bespokeCoveredTransactions, IEnumerable<AdditionalObligations> additionalObligations, ExposureScope? exposure)
        {
            InclusionDate = inclusionDate;
            CoveredTransactionsValue = coveredTransactions;
            BespokeCoveredTransactions = bespokeCoveredTransactions;
            AdditionalObligations = additionalObligations;
            Exposure = exposure;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CoveredTransactions> MetaData => metaData;
        
        /// <summary>
        /// Includes any Transaction specified below that is entered into on or after the specified date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate InclusionDate { get; }
        
        /// <summary>
        /// Covered Transactions when expressed using the ISDA taxonomy.
        /// </summary>
        [JsonProperty(PropertyName = "coveredTransactions")]
        public IEnumerable<ProductTaxonomy> CoveredTransactionsValue { get; }
        
        /// <summary>
        /// Covered Transactions when not expressed using the ISDA taxonomy.
        /// </summary>
        public IEnumerable<string> BespokeCoveredTransactions { get; }
        
        /// <summary>
        /// The party specific additional obligations applicable to the document.
        /// </summary>
        public IEnumerable<AdditionalObligations> AdditionalObligations { get; }
        
        /// <summary>
        /// Specification of amendments to the calculation of Exposure in terms of the Transactions covered.
        /// </summary>
        public ExposureScope? Exposure { get; }
    }
    
    /// <summary>
    ///  The credit default payout specification provides the details necessary for determining when a credit payout will be triggered as well as the parameters for calculating the payout and the settlement terms. The associated globalKey denotes the ability to associate a hash value to the CreditDefaultPayout instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class CreditDefaultPayout : AbstractRosettaModelObject<CreditDefaultPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<CreditDefaultPayout> metaData = new CreditDefaultPayoutMeta();
        
        [JsonConstructor]
        public CreditDefaultPayout(PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms, GeneralTerms generalTerms, IEnumerable<ProtectionTerms> protectionTerms, TransactedPrice? transactedPrice)
        {
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
            GeneralTerms = generalTerms;
            ProtectionTerms = protectionTerms;
            TransactedPrice = transactedPrice;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditDefaultPayout> MetaData => metaData;
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
        
        /// <summary>
        /// The specification of the non-monetary terms for the Credit Derivative Transaction, including the buyer and seller and selected items from the ISDA 2014 Credit Definition article II, such as the reference obligation and related terms.
        /// </summary>
        public GeneralTerms GeneralTerms { get; }
        
        /// <summary>
        /// Specifies the terms for calculating a payout to protect the buyer of the swap in the case of a qualified credit event. These terms include the applicable credit events, the reference obligation, and in the case of a CDS on mortgage-backed securities, the floatingAmountEvents.
        /// </summary>
        public IEnumerable<ProtectionTerms> ProtectionTerms { get; }
        
        /// <summary>
        /// The qualification of the price at which the contract has been transacted, in terms of market fixed rate, initial points, market price and/or quotation style. In FpML, those attributes are positioned as part of the fee leg.
        /// </summary>
        public TransactedPrice? TransactedPrice { get; }
    }
    
    /// <summary>
    /// Specifies the relevant data regarding a credit event.
    /// </summary>
    public class CreditEvent : AbstractRosettaModelObject<CreditEvent>
    {
        private static readonly IRosettaMetaData<CreditEvent> metaData = new CreditEventMeta();
        
        [JsonConstructor]
        public CreditEvent(Enums.CreditEventType creditEventType, LocalDate eventDeterminationDate, LocalDate? auctionDate, Price? finalPrice, decimal? recoveryPercent, IEnumerable<Resource> publiclyAvailableInformation, ReferenceInformation referenceInformation)
        {
            CreditEventType = creditEventType;
            EventDeterminationDate = eventDeterminationDate;
            AuctionDate = auctionDate;
            FinalPrice = finalPrice;
            RecoveryPercent = recoveryPercent;
            PubliclyAvailableInformation = publiclyAvailableInformation;
            ReferenceInformation = referenceInformation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditEvent> MetaData => metaData;
        
        /// <summary>
        /// The type of credit event taking place.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditEventType CreditEventType { get; }
        
        /// <summary>
        /// The date in which the credit event is determined by the Credit Derivatives Determinations Comitee.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EventDeterminationDate { get; }
        
        /// <summary>
        /// The date on which the auction is scheduled to occur.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AuctionDate { get; }
        
        /// <summary>
        /// The final price resulting from the auction.
        /// </summary>
        public Price? FinalPrice { get; }
        
        /// <summary>
        /// The percentage of the original value of the asset affected by the credit event that can be recovered.
        /// </summary>
        public decimal? RecoveryPercent { get; }
        
        /// <summary>
        /// A public information source, e.g. a particular newspaper or electronic news service, that may publish relevant information used in the determination of whether or not a credit event has occurred.
        /// </summary>
        public IEnumerable<Resource> PubliclyAvailableInformation { get; }
        
        /// <summary>
        /// The reference entity, part of a credit basket, impacted by the credit event.
        /// </summary>
        public ReferenceInformation ReferenceInformation { get; }
    }
    
    public class CreditEventNotice : AbstractRosettaModelObject<CreditEventNotice>
    {
        private static readonly IRosettaMetaData<CreditEventNotice> metaData = new CreditEventNoticeMeta();
        
        [JsonConstructor]
        public CreditEventNotice(IEnumerable<Enums.CounterpartyRole> notifyingParty, Enums.BusinessCenter? businessCenter, PubliclyAvailableInformation? publiclyAvailableInformation)
        {
            NotifyingParty = notifyingParty;
            BusinessCenter = businessCenter;
            PubliclyAvailableInformation = publiclyAvailableInformation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditEventNotice> MetaData => metaData;
        
        /// <summary>
        /// The notifying party is the party that notifies the other party when a credit event has occurred by means of a credit event notice. If more than one party is referenced as being the notifying party then either party may notify the other of a credit event occurring. ISDA 2003 Term: Notifying Party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> NotifyingParty { get; }
        
        /// <summary>
        /// Inclusion of this business center element implies that Greenwich Mean Time in Section 3.3 of the 2003 ISDA Credit Derivatives Definitions is replaced by the local time of the city indicated by the businessCenter element value.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessCenter? BusinessCenter { get; }
        
        /// <summary>
        /// A specified condition to settlement. Publicly available information means information that reasonably confirms any of the facts relevant to determining that a credit event or potential repudiation/moratorium, as applicable, has occurred. The ISDA defined list (2003) is the market standard and is considered comprehensive, and a minimum of two differing public sources must have published the relevant information, to declare a Credit Event. ISDA 2003 Term: Notice of Publicly Available Information Applicable.
        /// </summary>
        public PubliclyAvailableInformation? PubliclyAvailableInformation { get; }
    }
    
    /// <summary>
    /// A class to specify the applicable Credit Events that would trigger a settlement, as specified in the related Confirmation and defined in the ISDA 2014 Credit Definition article IV section 4.1.
    /// </summary>
    public class CreditEvents : AbstractRosettaModelObject<CreditEvents>
    {
        private static readonly IRosettaMetaData<CreditEvents> metaData = new CreditEventsMeta();
        
        [JsonConstructor]
        public CreditEvents(bool? bankruptcy, FailureToPay? failureToPay, bool? failureToPayPrincipal, bool? failureToPayInterest, bool? obligationDefault, bool? obligationAcceleration, bool? repudiationMoratorium, Restructuring? restructuring, bool? governmentalIntervention, bool? distressedRatingsDowngrade, bool? maturityExtension, bool? writedown, bool? impliedWritedown, Money? defaultRequirement, CreditEventNotice? creditEventNotice, _MetaFields? meta)
        {
            Bankruptcy = bankruptcy;
            FailureToPay = failureToPay;
            FailureToPayPrincipal = failureToPayPrincipal;
            FailureToPayInterest = failureToPayInterest;
            ObligationDefault = obligationDefault;
            ObligationAcceleration = obligationAcceleration;
            RepudiationMoratorium = repudiationMoratorium;
            Restructuring = restructuring;
            GovernmentalIntervention = governmentalIntervention;
            DistressedRatingsDowngrade = distressedRatingsDowngrade;
            MaturityExtension = maturityExtension;
            Writedown = writedown;
            ImpliedWritedown = impliedWritedown;
            DefaultRequirement = defaultRequirement;
            CreditEventNotice = creditEventNotice;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditEvents> MetaData => metaData;
        
        /// <summary>
        /// A credit event. The reference entity has been dissolved or has become insolvent. It also covers events that may be a precursor to insolvency such as instigation of bankruptcy or insolvency proceedings. Sovereign trades are not subject to Bankruptcy as &apos;technically&apos; a Sovereign cannot become bankrupt. ISDA 2003 Term: Bankruptcy.
        /// </summary>
        public bool? Bankruptcy { get; }
        
        /// <summary>
        /// A credit event. This credit event triggers, after the expiration of any applicable grace period, if the reference entity fails to make due payments in an aggregate amount of not less than the payment requirement on one or more obligations (e.g. a missed coupon payment). ISDA 2003 Term: Failure to Pay.
        /// </summary>
        public FailureToPay? FailureToPay { get; }
        
        /// <summary>
        /// A credit event. Corresponds to the failure by the Reference Entity to pay an expected principal amount or the payment of an actual principal amount that is less than the expected principal amount. ISDA 2003 Term: Failure to Pay Principal.
        /// </summary>
        public bool? FailureToPayPrincipal { get; }
        
        /// <summary>
        /// A credit event. Corresponds to the failure by the Reference Entity to pay an expected interest amount or the payment of an actual interest amount that is less than the expected interest amount. ISDA 2003 Term: Failure to Pay Interest.
        /// </summary>
        public bool? FailureToPayInterest { get; }
        
        /// <summary>
        /// A credit event. One or more of the obligations have become capable of being declared due and payable before they would otherwise have been due and payable as a result of, or on the basis of, the occurrence of a default, event of default or other similar condition or event other than failure to pay. ISDA 2003 Term: Obligation Default.
        /// </summary>
        public bool? ObligationDefault { get; }
        
        /// <summary>
        /// A credit event. One or more of the obligations have been declared due and payable before they would otherwise have been due and payable as a result of, or on the basis of, the occurrence of a default, event of default or other similar condition or event other than failure to pay (preferred by the market over Obligation Default, because more definitive and encompasses the definition of Obligation Default - this is more favorable to the Seller). Subject to the default requirement amount. ISDA 2003 Term: Obligation Acceleration.
        /// </summary>
        public bool? ObligationAcceleration { get; }
        
        /// <summary>
        /// A credit event. The reference entity, or a governmental authority, either refuses to recognise or challenges the validity of one or more obligations of the reference entity, or imposes a moratorium thereby postponing payments on one or more of the obligations of the reference entity. Subject to the default requirement amount. ISDA 2003 Term: Repudiation/Moratorium.
        /// </summary>
        public bool? RepudiationMoratorium { get; }
        
        /// <summary>
        /// A credit event. A restructuring is an event that materially impacts the reference entity&apos;s obligations, such as an interest rate reduction, principal reduction, deferral of interest or principal, change in priority ranking, or change in currency or composition of payment. ISDA 2003 Term: Restructuring.
        /// </summary>
        public Restructuring? Restructuring { get; }
        
        /// <summary>
        /// A credit event. A governmental intervention is an event resulting from an action by a governmental authority that materially impacts the reference entity&apos;s obligations, such as an interest rate reduction, principal reduction, deferral of interest or principal, change in priority ranking, or change in currency or composition of payment. ISDA 2014 Term: Governmental Intervention.
        /// </summary>
        public bool? GovernmentalIntervention { get; }
        
        /// <summary>
        /// A credit event. Results from the fact that the rating of the reference obligation is down-graded to a distressed rating level. From a usage standpoint, this credit event is typically not applicable in case of RMBS trades.
        /// </summary>
        public bool? DistressedRatingsDowngrade { get; }
        
        /// <summary>
        /// A credit event. Results from the fact that the underlier fails to make principal payments as expected.
        /// </summary>
        public bool? MaturityExtension { get; }
        
        /// <summary>
        /// A credit event. Results from the fact that the underlier writes down its outstanding principal amount.
        /// </summary>
        public bool? Writedown { get; }
        
        /// <summary>
        /// A credit event. Results from the fact that losses occur to the underlying instruments that do not result in reductions of the outstanding principal of the reference obligation.
        /// </summary>
        public bool? ImpliedWritedown { get; }
        
        /// <summary>
        /// In relation to certain credit events, serves as a threshold for Obligation Acceleration, Obligation Default, Repudiation/Moratorium and Restructuring. Market standard is USD 10,000,000 (JPY 1,000,000,000 for all Japanese Yen trades). This is applied on an aggregate or total basis across all Obligations of the Reference Entity. Used to prevent technical/operational errors from triggering credit events. ISDA 2003 Term: Default Requirement.
        /// </summary>
        public Money? DefaultRequirement { get; }
        
        /// <summary>
        /// A specified condition to settlement. An irrevocable written or verbal notice that describes a credit event that has occurred. The notice is sent from the notifying party (either the buyer or the seller) to the counterparty. It provides information relevant to determining that a credit event has occurred. This is typically accompanied by Publicly Available Information. ISDA 2003 Term: Credit Event Notice.
        /// </summary>
        public CreditEventNotice? CreditEventNotice { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specification of an index based on credit risk, typically composed using corporate debt instruments in a region or industry sector, e.g. the iTraxx indices.
    /// </summary>
    public class CreditIndex : AbstractRosettaModelObject<CreditIndex>, IIndexBase
    {
        private static readonly IRosettaMetaData<CreditIndex> metaData = new CreditIndexMeta();
        
        [JsonConstructor]
        public CreditIndex(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, FieldWithMetaString? name, LegalEntity? provider, Enums.AssetClass? assetClass, int? indexSeries, int? indexAnnexVersion, LocalDate? indexAnnexDate, FieldWithMetaIndexAnnexSourceEnum? indexAnnexSource, IEnumerable<ReferenceInformation> excludedReferenceEntity, Tranche? tranche, SettledEntityMatrix? settledEntityMatrix, decimal? indexFactor, Enums.CreditSeniority? seniority, _MetaFields? meta)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            Name = name;
            Provider = provider;
            AssetClass = assetClass;
            IndexSeries = indexSeries;
            IndexAnnexVersion = indexAnnexVersion;
            IndexAnnexDate = indexAnnexDate;
            IndexAnnexSource = indexAnnexSource;
            ExcludedReferenceEntity = excludedReferenceEntity;
            Tranche = tranche;
            SettledEntityMatrix = settledEntityMatrix;
            IndexFactor = indexFactor;
            Seniority = seniority;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditIndex> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Name { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Provider { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetClass? AssetClass { get; }
        
        /// <summary>
        /// A CDS index series identifier, e.g. 1, 2, 3 etc.
        /// </summary>
        public int? IndexSeries { get; }
        
        /// <summary>
        /// A CDS index series version identifier, e.g. 1, 2, 3 etc.
        /// </summary>
        public int? IndexAnnexVersion { get; }
        
        /// <summary>
        /// A CDS index series annex date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? IndexAnnexDate { get; }
        
        /// <summary>
        /// A CDS index series annex source.
        /// </summary>
        public FieldWithMetaIndexAnnexSourceEnum? IndexAnnexSource { get; }
        
        /// <summary>
        /// Excluded reference entity.
        /// </summary>
        public IEnumerable<ReferenceInformation> ExcludedReferenceEntity { get; }
        
        /// <summary>
        /// This element contains CDS tranche terms.
        /// </summary>
        public Tranche? Tranche { get; }
        
        /// <summary>
        /// Used to specify the Relevant Settled Entity Matrix when there are settled entities at the time of the trade.
        /// </summary>
        public SettledEntityMatrix? SettledEntityMatrix { get; }
        
        /// <summary>
        /// Index Factor is the index version factor or percent, expressed as an absolute decimal value between 0 and 1, that multiplied by the original notional amount yields the notional amount covered by the seller of protection.
        /// </summary>
        public decimal? IndexFactor { get; }
        
        /// <summary>
        /// Seniority of debt instruments comprising the index.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditSeniority? Seniority { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class to represent the credit limit utilisation information.
    /// </summary>
    public class CreditLimitInformation : AbstractRosettaModelObject<CreditLimitInformation>
    {
        private static readonly IRosettaMetaData<CreditLimitInformation> metaData = new CreditLimitInformationMeta();
        
        [JsonConstructor]
        public CreditLimitInformation(IEnumerable<LimitApplicableExtended> limitApplicable)
        {
            LimitApplicable = limitApplicable;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditLimitInformation> MetaData => metaData;
        
        public IEnumerable<LimitApplicableExtended> LimitApplicable { get; }
    }
    
    /// <summary>
    /// Credit limit utilisation breakdown by executed trades and pending orders.
    /// </summary>
    public class CreditLimitUtilisation : AbstractRosettaModelObject<CreditLimitUtilisation>
    {
        private static readonly IRosettaMetaData<CreditLimitUtilisation> metaData = new CreditLimitUtilisationMeta();
        
        [JsonConstructor]
        public CreditLimitUtilisation(CreditLimitUtilisationPosition? executed, CreditLimitUtilisationPosition? pending)
        {
            Executed = executed;
            Pending = pending;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditLimitUtilisation> MetaData => metaData;
        
        /// <summary>
        /// Credit limit utilisation attributable to executed trades.
        /// </summary>
        public CreditLimitUtilisationPosition? Executed { get; }
        
        /// <summary>
        /// Credit limit utilisation attributable to pending unexecuted orders.
        /// </summary>
        public CreditLimitUtilisationPosition? Pending { get; }
    }
    
    public class CreditLimitUtilisationPosition : AbstractRosettaModelObject<CreditLimitUtilisationPosition>
    {
        private static readonly IRosettaMetaData<CreditLimitUtilisationPosition> metaData = new CreditLimitUtilisationPositionMeta();
        
        [JsonConstructor]
        public CreditLimitUtilisationPosition(decimal? shortPosition, decimal? longPosition, decimal? global)
        {
            ShortPosition = shortPosition;
            LongPosition = longPosition;
            Global = global;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditLimitUtilisationPosition> MetaData => metaData;
        
        /// <summary>
        /// Credit limit utilisation attributable to short positions.
        /// </summary>
        public decimal? ShortPosition { get; }
        
        /// <summary>
        /// Credit limit utilisation attributable to long positions.
        /// </summary>
        public decimal? LongPosition { get; }
        
        /// <summary>
        /// Global credit limit utilisation amount, agnostic of long/short position direction.
        /// </summary>
        public decimal? Global { get; }
    }
    
    /// <summary>
    /// Represents a class to specify the credit notation as the combination of agency, notation, scale and debt type qualifications.
    /// </summary>
    public class CreditNotation : AbstractRosettaModelObject<CreditNotation>, ICreditNotation
    {
        private static readonly IRosettaMetaData<CreditNotation> metaData = new CreditNotationMeta();
        
        [JsonConstructor]
        public CreditNotation(Enums.CreditRatingAgency agency, FieldWithMetaString notation, FieldWithMetaString? scale, CreditRatingDebt? debt, Enums.CreditRatingOutlook? outlook, Enums.CreditRatingCreditWatch? creditWatch)
        {
            Agency = agency;
            Notation = notation;
            Scale = scale;
            Debt = debt;
            Outlook = outlook;
            CreditWatch = creditWatch;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditNotation> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency Agency { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString Notation { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Scale { get; }
        
        /// <inheritdoc/>
        public CreditRatingDebt? Debt { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingOutlook? Outlook { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingCreditWatch? CreditWatch { get; }
    }
    
    /// <summary>
    /// Represents the credit rating notation higher level construct, which provides the ability to specify multiple rating notations.
    /// </summary>
    public class CreditNotations : AbstractRosettaModelObject<CreditNotations>
    {
        private static readonly IRosettaMetaData<CreditNotations> metaData = new CreditNotationsMeta();
        
        [JsonConstructor]
        public CreditNotations(CreditNotation? creditNotation, MultipleCreditNotations? creditNotations)
        {
            CreditNotation = creditNotation;
            CreditNotationsValue = creditNotations;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditNotations> MetaData => metaData;
        
        /// <summary>
        /// Specifies only one credit notation is determined.
        /// </summary>
        public CreditNotation? CreditNotation { get; }
        
        /// <summary>
        /// Specifies if several credit notations exist, alongside an &apos;any&apos; or &apos;all&apos; or all condition.
        /// </summary>
        [JsonProperty(PropertyName = "creditNotations")]
        public MultipleCreditNotations? CreditNotationsValue { get; }
    }
    
    /// <summary>
    /// Specifies the credit rating debt type(s) associated with the credit rating notation and scale. When several debt types are specified, they must be qualified through an &apos;any&apos; or &apos;all&apos;.
    /// </summary>
    public class CreditRatingDebt : AbstractRosettaModelObject<CreditRatingDebt>
    {
        private static readonly IRosettaMetaData<CreditRatingDebt> metaData = new CreditRatingDebtMeta();
        
        [JsonConstructor]
        public CreditRatingDebt(FieldWithMetaString? debtType, MultipleDebtTypes? debtTypes)
        {
            DebtType = debtType;
            DebtTypes = debtTypes;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditRatingDebt> MetaData => metaData;
        
        /// <summary>
        /// Specifies when there is only one debt type. FpML doesn&apos;t specify values in relation to the associated scheme, which is hence not specified as an enumeration as part of the CDM.
        /// </summary>
        public FieldWithMetaString? DebtType { get; }
        
        /// <summary>
        /// Specifies if there are several debt types, alongside an &apos;any&apos; or &apos;all&apos; or all condition. As an example, Baa1 rating is required for any long term debt and deposit.
        /// </summary>
        public MultipleDebtTypes? DebtTypes { get; }
    }
    
    /// <summary>
    /// The set of elections which specify a Credit Support Annex or Deed.
    /// </summary>
    public class CreditSupportAgreementElections : AbstractRosettaModelObject<CreditSupportAgreementElections>
    {
        private static readonly IRosettaMetaData<CreditSupportAgreementElections> metaData = new CreditSupportAgreementElectionsMeta();
        
        [JsonConstructor]
        public CreditSupportAgreementElections(Regime regime, OneWayProvisions oneWayProvisions, GeneralSimmElections? generalSimmElections, bool? identifiedCrossCurrencySwap, SensitivityMethodologies sensitivityMethodologies, FxHaircutCurrency? fxHaircutCurrency, PostingObligations postingObligations, IEnumerable<SubstitutedRegime> substitutedRegime, BaseAndEligibleCurrency baseAndEligibleCurrency, string? additionalObligations, CoveredTransactions coveredTransactions, CreditSupportObligations creditSupportObligations, string? exchangeDate, CalculationAndTiming calculationAndTiming, ConditionsPrecedent? conditionsPrecedent, Substitution substitution, DisputeResolution disputeResolution, HoldingAndUsingPostedCollateral holdingAndUsingPostedCollateral, RightsEvents rightsEvents, CustodyArrangements? custodyArrangements, DistributionAndInterestPayment? distributionAndInterestPayment, bool creditSupportOffsets, AdditionalRepresentations additionalRepresentations, OtherEligibleAndPostedSupport otherEligibleAndPostedSupport, DemandsAndNotices? demandsAndNotices, ContactElection? addressesForTransfer, OtherAgreements? otherAgreements, TerminationCurrencyAmendment terminationCurrencyAmendment, MinimumTransferAmountAmendment minimumTransferAmountAmendment, string? interpretationTerms, ProcessAgent? processAgent, AppropriatedCollateralValuation? appropriatedCollateralValuation, JurisdictionRelatedTerms? jurisdictionRelatedTerms, string? additionalAmendments, string? additionalBespokeTerms, bool trustSchemeAddendum, SecurityInterestForObligations securityInterestForObligations, SinglePostingParty? singlePostingParty, DatedAsOfDate? datedAsOfDate, string? cass, string? otherCSA, string? legacyAdditionalRepresentations, CollateralValueMethod? value, FinalReturns finalReturns)
        {
            Regime = regime;
            OneWayProvisions = oneWayProvisions;
            GeneralSimmElections = generalSimmElections;
            IdentifiedCrossCurrencySwap = identifiedCrossCurrencySwap;
            SensitivityMethodologies = sensitivityMethodologies;
            FxHaircutCurrency = fxHaircutCurrency;
            PostingObligations = postingObligations;
            SubstitutedRegime = substitutedRegime;
            BaseAndEligibleCurrency = baseAndEligibleCurrency;
            AdditionalObligations = additionalObligations;
            CoveredTransactions = coveredTransactions;
            CreditSupportObligations = creditSupportObligations;
            ExchangeDate = exchangeDate;
            CalculationAndTiming = calculationAndTiming;
            ConditionsPrecedent = conditionsPrecedent;
            Substitution = substitution;
            DisputeResolution = disputeResolution;
            HoldingAndUsingPostedCollateral = holdingAndUsingPostedCollateral;
            RightsEvents = rightsEvents;
            CustodyArrangements = custodyArrangements;
            DistributionAndInterestPayment = distributionAndInterestPayment;
            CreditSupportOffsets = creditSupportOffsets;
            AdditionalRepresentations = additionalRepresentations;
            OtherEligibleAndPostedSupport = otherEligibleAndPostedSupport;
            DemandsAndNotices = demandsAndNotices;
            AddressesForTransfer = addressesForTransfer;
            OtherAgreements = otherAgreements;
            TerminationCurrencyAmendment = terminationCurrencyAmendment;
            MinimumTransferAmountAmendment = minimumTransferAmountAmendment;
            InterpretationTerms = interpretationTerms;
            ProcessAgent = processAgent;
            AppropriatedCollateralValuation = appropriatedCollateralValuation;
            JurisdictionRelatedTerms = jurisdictionRelatedTerms;
            AdditionalAmendments = additionalAmendments;
            AdditionalBespokeTerms = additionalBespokeTerms;
            TrustSchemeAddendum = trustSchemeAddendum;
            SecurityInterestForObligations = securityInterestForObligations;
            SinglePostingParty = singlePostingParty;
            DatedAsOfDate = datedAsOfDate;
            Cass = cass;
            OtherCSA = otherCSA;
            LegacyAdditionalRepresentations = legacyAdditionalRepresentations;
            Value = value;
            FinalReturns = finalReturns;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportAgreementElections> MetaData => metaData;
        
        /// <summary>
        /// The Regime Table provision , which determines the regulatory regime(s) applicable to each of the parties to the agreement.
        /// </summary>
        public Regime Regime { get; }
        
        /// <summary>
        /// The determination of whether the One Way Provisions are applicable (true) or not applicable (false).
        /// </summary>
        public OneWayProvisions OneWayProvisions { get; }
        
        /// <summary>
        /// The specification of the ISDA SIMM Method for all Covered Transactions with respect to all Regimes.
        /// </summary>
        public GeneralSimmElections? GeneralSimmElections { get; }
        
        /// <summary>
        /// The qualification of whether cross-currency swaps need to be identified in the Confirmation so that the obligations to exchange principal be disregarded for the purpose of determining the Delivery Amount or Return Amount.
        /// </summary>
        public bool? IdentifiedCrossCurrencySwap { get; }
        
        /// <summary>
        /// The specification of methodologies to compute sensitivities specific to the agreement.
        /// </summary>
        public SensitivityMethodologies SensitivityMethodologies { get; }
        
        /// <summary>
        /// The reference currency for the purpose of specifying the FX Haircut relating to a posting obligation, as being either the Termination Currency or an FX Designated Currency.
        /// </summary>
        public FxHaircutCurrency? FxHaircutCurrency { get; }
        
        /// <summary>
        /// The security providers posting obligations.
        /// </summary>
        public PostingObligations PostingObligations { get; }
        
        /// <summary>
        /// The specification of Additional regimes for purposes of determining whether a Regulatory Event has occurred.
        /// </summary>
        public IEnumerable<SubstitutedRegime> SubstitutedRegime { get; }
        
        /// <summary>
        /// The base and eligible currency(ies) for the document as specified by the parties to the agreement.
        /// </summary>
        public BaseAndEligibleCurrency BaseAndEligibleCurrency { get; }
        
        /// <summary>
        /// The additional obligations that might be specified by the parties to a Credit Support Agreement.
        /// </summary>
        public string? AdditionalObligations { get; }
        
        /// <summary>
        /// The specification of transactions covered by the terms of the agreement.
        /// </summary>
        public CoveredTransactions CoveredTransactions { get; }
        
        /// <summary>
        /// The Credit Support Obligations applicable to the agreement.
        /// </summary>
        public CreditSupportObligations CreditSupportObligations { get; }
        
        /// <summary>
        /// The bespoke exchange date terms that might be specified by the parties to the agreement.
        /// </summary>
        public string? ExchangeDate { get; }
        
        /// <summary>
        /// The set of elections for determining Valuation and Timing terms specific to the agreement.
        /// </summary>
        public CalculationAndTiming CalculationAndTiming { get; }
        
        /// <summary>
        /// The set of elections that may overwrite the default Condition Precedent provision, and the set of provisions that are deemed Access Condition.
        /// </summary>
        public ConditionsPrecedent? ConditionsPrecedent { get; }
        
        /// <summary>
        /// The conditions under which the Security Provider can substitute posted collateral.
        /// </summary>
        public Substitution Substitution { get; }
        
        /// <summary>
        /// The election terms under which a party disputes (i) the Calculation Agents calculation of a Delivery Amount or a Return Amount, or (ii) the Value of any Transfer of Eligible Credit Support or Posted Credit Support.
        /// </summary>
        public DisputeResolution DisputeResolution { get; }
        
        /// <summary>
        /// The elections for the holding and using of posted collateral by the respective parties to the Credit Support Annex for Variation Margin.
        /// </summary>
        public HoldingAndUsingPostedCollateral HoldingAndUsingPostedCollateral { get; }
        
        /// <summary>
        /// The bespoke provisions that might be specified by the parties to the agreement to specify the rights of Security Taker and/or Security Provider when an Early Termination or Access Condition event has occurred.
        /// </summary>
        public RightsEvents RightsEvents { get; }
        
        /// <summary>
        /// The Custodian and Segregated Account details in respect of each party to the agreement.
        /// </summary>
        public CustodyArrangements? CustodyArrangements { get; }
        
        /// <summary>
        /// The Distributions and Interest Payment terms specified as part of the agreement.
        /// </summary>
        public DistributionAndInterestPayment? DistributionAndInterestPayment { get; }
        
        /// <summary>
        /// The specification of whether the standard Credit Support Offset provisions are applicable (true) or not applicable (false).
        /// </summary>
        public bool CreditSupportOffsets { get; }
        
        /// <summary>
        /// The specification Additional Representations that may be applicable to the agreement.
        /// </summary>
        public AdditionalRepresentations AdditionalRepresentations { get; }
        
        /// <summary>
        /// The Other Eligible Support elections associated with margin agreements.
        /// </summary>
        public OtherEligibleAndPostedSupport OtherEligibleAndPostedSupport { get; }
        
        /// <summary>
        /// The optional specification of address where the demands, specifications and notices will be communicated to for each of the parties to the agreement.
        /// </summary>
        public DemandsAndNotices? DemandsAndNotices { get; }
        
        /// <summary>
        /// The optional specification of address for transfer as specified by the respective parties to the agreement.
        /// </summary>
        public ContactElection? AddressesForTransfer { get; }
        
        /// <summary>
        /// The bespoke definition of other agreement terms as specified by the parties to the agreement.
        /// </summary>
        public OtherAgreements? OtherAgreements { get; }
        
        /// <summary>
        /// The bespoke provision that might be specified by the parties to the agreement applicable to Termination Currency.  Unless specified the definition of Termination Currency has the meaning specified in the Schedule to the ISDA Master Agreement.
        /// </summary>
        public TerminationCurrencyAmendment TerminationCurrencyAmendment { get; }
        
        /// <summary>
        /// The bespoke provision that might be specified by the parties to the agreement applicable to Minimum Transfer Amount.  Unless specified the definition of Minimum Transfer Amount in any Other Regulatory CSA has the meaning specified in such Other Regulatory CSA.
        /// </summary>
        public MinimumTransferAmountAmendment MinimumTransferAmountAmendment { get; }
        
        /// <summary>
        /// The bespoke provision that might be specified by the parties to the agreement applicable to Interpretations.
        /// </summary>
        public string? InterpretationTerms { get; }
        
        /// <summary>
        /// The Process Agent that might be appointed by the parties to the agreement.
        /// </summary>
        public ProcessAgent? ProcessAgent { get; }
        
        /// <summary>
        /// The election for the Valuation of Appropriate Collateral.
        /// </summary>
        public AppropriatedCollateralValuation? AppropriatedCollateralValuation { get; }
        
        /// <summary>
        /// The jurisdiction specific terms relevant to the agreement.
        /// </summary>
        public JurisdictionRelatedTerms? JurisdictionRelatedTerms { get; }
        
        /// <summary>
        /// Any additional amendments that might be specified by the parties to the agreement.
        /// </summary>
        public string? AdditionalAmendments { get; }
        
        /// <summary>
        /// Any additional terms that might be specified applicable.
        /// </summary>
        public string? AdditionalBespokeTerms { get; }
        
        /// <summary>
        /// The qualification of whether Trust Scheme Addendum is applicable (True) or not applicable (False).
        /// </summary>
        public bool TrustSchemeAddendum { get; }
        
        /// <summary>
        /// The party to whom obligations under the Master Agreement are owed and secured by the credit support arrangements. Applicable to 1994 NY CSA, 1995 English Law CSD and 2016 New York Law VM CSA.
        /// </summary>
        public SecurityInterestForObligations SecurityInterestForObligations { get; }
        
        /// <summary>
        /// Where only a single  party is explicitly designated to post collateral, the party which is specified as the sole poster of collateral.
        /// </summary>
        public SinglePostingParty? SinglePostingParty { get; }
        
        /// <summary>
        /// Defines the dates agreed by the parties as the date of the Credit Support Annex or Credit Support Deed.
        /// </summary>
        public DatedAsOfDate? DatedAsOfDate { get; }
        
        /// <summary>
        /// Details of language relating to Client Asset and Money Rules.
        /// </summary>
        public string? Cass { get; }
        
        /// <summary>
        /// A clause detailing the prescence of another collateralisation arrangement within the Master Agreement between the parties to this Collateral Arrangement.
        /// </summary>
        public string? OtherCSA { get; }
        
        /// <summary>
        /// Details of any Additional Representations given by the relevant parties in relation to the collateral arrangement.
        /// </summary>
        public string? LegacyAdditionalRepresentations { get; }
        
        /// <summary>
        /// Details how particular types of collateral are valued (other than in respect of a default).
        /// </summary>
        public CollateralValueMethod? Value { get; }
        
        /// <summary>
        /// A clause providing that final return collateral is to be provided without consideration of any Minimum Transfer Amount and collateral haircut.
        /// </summary>
        public FinalReturns FinalReturns { get; }
    }
    
    /// <summary>
    /// The total amount one counterparty must deliver to the other at any time: the combination of the Exposure to that party and the net Independent Amounts it must post, minus any agreed Threshold.
    /// </summary>
    public class CreditSupportAmount : AbstractRosettaModelObject<CreditSupportAmount>
    {
        private static readonly IRosettaMetaData<CreditSupportAmount> metaData = new CreditSupportAmountMeta();
        
        [JsonConstructor]
        public CreditSupportAmount(Enums.CreditSupportAmount creditSupportAmount, string? additionalLanguage)
        {
            CreditSupportAmountValue = creditSupportAmount;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportAmount> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether the meaning of credit support amount follows the pre-print definition or deviates from the standard (either based on a rating or some other methodology).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "creditSupportAmount")]
        public Enums.CreditSupportAmount CreditSupportAmountValue { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Identification of party specific Credit Support Documents applicable to the document.
    /// </summary>
    public class CreditSupportDocument : AbstractRosettaModelObject<CreditSupportDocument>
    {
        private static readonly IRosettaMetaData<CreditSupportDocument> metaData = new CreditSupportDocumentMeta();
        
        [JsonConstructor]
        public CreditSupportDocument(IEnumerable<CreditSupportDocumentElection> creditSupportDocumentElection)
        {
            CreditSupportDocumentElection = creditSupportDocumentElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportDocument> MetaData => metaData;
        
        /// <summary>
        /// The party election of Credit Support Document(s), if any.
        /// </summary>
        public IEnumerable<CreditSupportDocumentElection> CreditSupportDocumentElection { get; }
    }
    
    /// <summary>
    /// The party election of Credit Support Provider(s), if any.
    /// </summary>
    public class CreditSupportDocumentElection : AbstractRosettaModelObject<CreditSupportDocumentElection>
    {
        private static readonly IRosettaMetaData<CreditSupportDocumentElection> metaData = new CreditSupportDocumentElectionMeta();
        
        [JsonConstructor]
        public CreditSupportDocumentElection(Party party, Enums.CreditSupportDocumentTerms creditSupportDocumentTerms, IEnumerable<LegalAgreement> creditSupportDocument, string? bespokeCreditSuppportDocument)
        {
            Party = party;
            CreditSupportDocumentTerms = creditSupportDocumentTerms;
            CreditSupportDocument = creditSupportDocument;
            BespokeCreditSuppportDocument = bespokeCreditSuppportDocument;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportDocumentElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        public Party Party { get; }
        
        /// <summary>
        /// Specification of the Credit Support Document terms.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditSupportDocumentTerms CreditSupportDocumentTerms { get; }
        
        /// <summary>
        /// The specified Credit Support Document(s), if any.
        /// </summary>
        public IEnumerable<LegalAgreement> CreditSupportDocument { get; }
        
        /// <summary>
        /// Specification of a document when not captured under RelatedAgreement.
        /// </summary>
        public string? BespokeCreditSuppportDocument { get; }
    }
    
    /// <summary>
    /// A class to specify the Credit Support Obligations applicable to the Initial Margin Credit Support Annex.
    /// </summary>
    public class CreditSupportObligations : AbstractRosettaModelObject<CreditSupportObligations>
    {
        private static readonly IRosettaMetaData<CreditSupportObligations> metaData = new CreditSupportObligationsMeta();
        
        [JsonConstructor]
        public CreditSupportObligations(string? deliveryAmount, string? returnAmount, MarginApproach? marginApproach, string? otherEligibleSupportIM, CollateralRounding? rounding, BespokeTransferTiming? bespokeTransferTiming, CreditSupportObligationsVariationMargin? creditSupportObligationsVariationMargin, Threshold? threshold, MinimumTransferAmount? minimumTransferAmount, LegacyDeliveryAmount legacyDeliveryAmount, LegacyReturnAmount legacyReturnAmount, CreditSupportAmount creditSupportAmount, CollateralTransferTiming? collateralTransferTiming, LegacyIndependentAmount? legacyIndependentAmount, EligibleCreditSupport eligibleCreditSupport)
        {
            DeliveryAmount = deliveryAmount;
            ReturnAmount = returnAmount;
            MarginApproach = marginApproach;
            OtherEligibleSupportIM = otherEligibleSupportIM;
            Rounding = rounding;
            BespokeTransferTiming = bespokeTransferTiming;
            CreditSupportObligationsVariationMargin = creditSupportObligationsVariationMargin;
            Threshold = threshold;
            MinimumTransferAmount = minimumTransferAmount;
            LegacyDeliveryAmount = legacyDeliveryAmount;
            LegacyReturnAmount = legacyReturnAmount;
            CreditSupportAmount = creditSupportAmount;
            CollateralTransferTiming = collateralTransferTiming;
            LegacyIndependentAmount = legacyIndependentAmount;
            EligibleCreditSupport = eligibleCreditSupport;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportObligations> MetaData => metaData;
        
        /// <summary>
        /// Delivery Amount (VM) has the meaning specified in Paragraph 3(a), unless otherwise specified here.
        /// </summary>
        public string? DeliveryAmount { get; }
        
        /// <summary>
        /// Return Amount (VM) has the meaning specified in Paragraph 3(a), unless otherwise specified here.
        /// </summary>
        public string? ReturnAmount { get; }
        
        /// <summary>
        /// The selection of Margin Approach applicable to the agreement.
        /// </summary>
        public MarginApproach? MarginApproach { get; }
        
        /// <summary>
        /// The Other Eligible Support election. If not specified, this election is deemed as not applicable.
        /// </summary>
        public string? OtherEligibleSupportIM { get; }
        
        /// <summary>
        /// The rounding methodology applicable to the Delivery Amount and the Return Amount in terms of nearest integral multiple of Base Currency units.
        /// </summary>
        public CollateralRounding? Rounding { get; }
        
        /// <summary>
        /// The time by which the transfer of collateral must take place when different from the Regular Settlement Day as a result of parties&apos; election.
        /// </summary>
        public BespokeTransferTiming? BespokeTransferTiming { get; }
        
        /// <summary>
        /// The specification of Credit Support Obligations applicable to Variation Margin agreements.
        /// </summary>
        public CreditSupportObligationsVariationMargin? CreditSupportObligationsVariationMargin { get; }
        
        /// <summary>
        /// Represents the amount of unsecured risk that a party is willing to tolerate without holding any posted collateral provided by the other party.
        /// </summary>
        public Threshold? Threshold { get; }
        
        /// <summary>
        /// Represents the threshold specified in the agreement below which collateral need not be delivered, and represents the smallest incremental value of exposure that must be reached before the parties are obliged to transfer collateral.
        /// </summary>
        public MinimumTransferAmount? MinimumTransferAmount { get; }
        
        /// <summary>
        /// In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be transferred to it as a Delivery Amount.
        /// </summary>
        public LegacyDeliveryAmount LegacyDeliveryAmount { get; }
        
        /// <summary>
        /// In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be recalled to it as a Return Amount.
        /// </summary>
        public LegacyReturnAmount LegacyReturnAmount { get; }
        
        /// <summary>
        /// The total amount one counterparty must deliver to the other at any time: the combination of the Exposure to that party and the net Independent Amounts it must post, minus any agreed Threshold.
        /// </summary>
        public CreditSupportAmount CreditSupportAmount { get; }
        
        /// <summary>
        /// Specification of transfer / settlement timing for cash and securities collateral assuming that the notice is provided before the Notification Time (and with a 1LBD lag introduced if the notice is delivered after the Notification Time), and that securities allow for a further Local Business Day for transfer / settlement.
        /// </summary>
        public CollateralTransferTiming? CollateralTransferTiming { get; }
        
        /// <summary>
        /// Specifies the additional amount of collateral that is required to be delivered by a party irrespective of the mark-to-market exposure under the related Transactions. It may take the form of a fixed amount or may be determined using ratings.
        /// </summary>
        public LegacyIndependentAmount? LegacyIndependentAmount { get; }
        
        /// <summary>
        /// Specification of the Eligible Collateral or Credit Support applicable to the Agreement.
        /// </summary>
        public EligibleCreditSupport EligibleCreditSupport { get; }
    }
    
    /// <summary>
    /// A class to specify the Credit Support Obligations applicable to the Variation Margin Credit Support Annex.
    /// </summary>
    public class CreditSupportObligationsVariationMargin : AbstractRosettaModelObject<CreditSupportObligationsVariationMargin>
    {
        private static readonly IRosettaMetaData<CreditSupportObligationsVariationMargin> metaData = new CreditSupportObligationsVariationMarginMeta();
        
        [JsonConstructor]
        public CreditSupportObligationsVariationMargin(IneligibleCreditSupport? ineligibleCreditSupport, IEnumerable<FieldWithMetaString> majorCurrency, string? fxHaircut)
        {
            IneligibleCreditSupport = ineligibleCreditSupport;
            MajorCurrency = majorCurrency;
            FxHaircut = fxHaircut;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportObligationsVariationMargin> MetaData => metaData;
        
        /// <summary>
        /// The parties to which the provisions of the Credit Support Annex for Variation Margin will apply to.
        /// </summary>
        public IneligibleCreditSupport? IneligibleCreditSupport { get; }
        
        /// <summary>
        /// The additional currencies that are specified as Major Currency for the purpose of applying the FX Haircut Percentage.
        /// </summary>
        public IEnumerable<FieldWithMetaString> MajorCurrency { get; }
        
        /// <summary>
        /// The alternative definition for FX haircut percentage that applies to each party and item of Eligible Collateral unless this item is denominated in a Major Currency or in the Base Currency.
        /// </summary>
        public string? FxHaircut { get; }
    }
    
    /// <summary>
    /// Identification of party specific Credit Support Providers applicable to the document.
    /// </summary>
    public class CreditSupportProvider : AbstractRosettaModelObject<CreditSupportProvider>
    {
        private static readonly IRosettaMetaData<CreditSupportProvider> metaData = new CreditSupportProviderMeta();
        
        [JsonConstructor]
        public CreditSupportProvider(IEnumerable<CreditSupportProviderElection> creditSupportProviderElection)
        {
            CreditSupportProviderElection = creditSupportProviderElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportProvider> MetaData => metaData;
        
        /// <summary>
        /// The party election of Credit Support Provider(s), if any.
        /// </summary>
        public IEnumerable<CreditSupportProviderElection> CreditSupportProviderElection { get; }
    }
    
    /// <summary>
    /// The party election of Credit Support Provider(s), if any.
    /// </summary>
    public class CreditSupportProviderElection : AbstractRosettaModelObject<CreditSupportProviderElection>
    {
        private static readonly IRosettaMetaData<CreditSupportProviderElection> metaData = new CreditSupportProviderElectionMeta();
        
        [JsonConstructor]
        public CreditSupportProviderElection(Party party, Enums.CreditSupportProviderTerms creditSupportProviderTerms, IEnumerable<LegalEntity> creditSupportProvider, string? bespokeCreditSuppportProvider)
        {
            Party = party;
            CreditSupportProviderTerms = creditSupportProviderTerms;
            CreditSupportProvider = creditSupportProvider;
            BespokeCreditSuppportProvider = bespokeCreditSuppportProvider;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CreditSupportProviderElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        public Party Party { get; }
        
        /// <summary>
        /// Specification of the Credit Support Provider terms.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditSupportProviderTerms CreditSupportProviderTerms { get; }
        
        /// <summary>
        /// The specified Credit Support Provider(s), if any.
        /// </summary>
        public IEnumerable<LegalEntity> CreditSupportProvider { get; }
        
        /// <summary>
        /// ...
        /// </summary>
        public string? BespokeCreditSuppportProvider { get; }
    }
    
    public class Curve : AbstractRosettaModelObject<Curve>
    {
        private static readonly IRosettaMetaData<Curve> metaData = new CurveMeta();
        
        [JsonConstructor]
        public Curve(InterestRateCurve? interestRateCurve, FieldWithMetaCommodityReferencePriceEnum? commodityCurve)
        {
            InterestRateCurve = interestRateCurve;
            CommodityCurve = commodityCurve;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Curve> MetaData => metaData;
        
        public InterestRateCurve? InterestRateCurve { get; }
        
        public FieldWithMetaCommodityReferencePriceEnum? CommodityCurve { get; }
    }
    
    /// <summary>
    /// A class to specify the custodian and custody account details for each party to the agreement.
    /// </summary>
    public class Custodian : AbstractRosettaModelObject<Custodian>
    {
        private static readonly IRosettaMetaData<Custodian> metaData = new CustodianMeta();
        
        [JsonConstructor]
        public Custodian(IEnumerable<CustodianElection> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Custodian> MetaData => metaData;
        
        /// <summary>
        /// The party specific elections.
        /// </summary>
        public IEnumerable<CustodianElection> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify the custodian and custody account details for each party to the agreement.
    /// </summary>
    public class CustodianElection : AbstractRosettaModelObject<CustodianElection>
    {
        private static readonly IRosettaMetaData<CustodianElection> metaData = new CustodianElectionMeta();
        
        [JsonConstructor]
        public CustodianElection(Enums.CounterpartyRole party, LegalEntity? custodian, Account? segregatedCashAccount, Account? segregatedSecurityAccount, Enums.LegacyVMCustodian? legacyVMCustodian, LegalEntity? legacyNamedEntity, string? additionalLanguage)
        {
            Party = party;
            Custodian = custodian;
            SegregatedCashAccount = segregatedCashAccount;
            SegregatedSecurityAccount = segregatedSecurityAccount;
            LegacyVMCustodian = legacyVMCustodian;
            LegacyNamedEntity = legacyNamedEntity;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustodianElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The custody agent. While CreateiQ only specifies the custodian&apos;s name, specifying the legal entity as part of the CDM is deemed more appropriate, while this will still provide the ability to accommodate situations where only the entity name is available, as the entityId attribute is optional as part of the LegalEntity class.
        /// </summary>
        public LegalEntity? Custodian { get; }
        
        /// <summary>
        /// The identification of the segregated cash account for the purpose of holding cash collateral.
        /// </summary>
        public Account? SegregatedCashAccount { get; }
        
        /// <summary>
        /// The identification of the segregated security account for the purpose of holding security collateral.
        /// </summary>
        public Account? SegregatedSecurityAccount { get; }
        
        /// <summary>
        /// Details how the Custodian is determined.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.LegacyVMCustodian? LegacyVMCustodian { get; }
        
        /// <summary>
        /// The identity of the relevant custodian where Named Entity is elected.
        /// </summary>
        public LegalEntity? LegacyNamedEntity { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// A class to specify the Custodian Event.
    /// </summary>
    public class CustodianEvent : AbstractRosettaModelObject<CustodianEvent>
    {
        private static readonly IRosettaMetaData<CustodianEvent> metaData = new CustodianEventMeta();
        
        [JsonConstructor]
        public CustodianEvent(bool isApplicable, CustodianEventEndDate? endDate)
        {
            IsApplicable = isApplicable;
            EndDate = endDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustodianEvent> MetaData => metaData;
        
        /// <summary>
        /// The qualification as to whether the Custodian Event (English Law &amp; New York Law ISDA CSA) or the Collateral Manager Event (Japanese Law ISDA CSA) is applicable.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The qualification of the Custodian Event (English Law &amp; New York Law ISDA CSA) or Collateral Manager Event (Japanese Law ISDA CSA) End Date.
        /// </summary>
        public CustodianEventEndDate? EndDate { get; }
    }
    
    /// <summary>
    /// A class to specify the Custodian Event.
    /// </summary>
    public class CustodianEventEndDate : AbstractRosettaModelObject<CustodianEventEndDate>
    {
        private static readonly IRosettaMetaData<CustodianEventEndDate> metaData = new CustodianEventEndDateMeta();
        
        [JsonConstructor]
        public CustodianEventEndDate(CustomisableOffset daysAfterCustodianEvent, CustomisableOffset releaseDate, CustomisableOffset? safekeepingPeriodExpiry, CustomisableOffset dateOfTimelyStatement)
        {
            DaysAfterCustodianEvent = daysAfterCustodianEvent;
            ReleaseDate = releaseDate;
            SafekeepingPeriodExpiry = safekeepingPeriodExpiry;
            DateOfTimelyStatement = dateOfTimelyStatement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustodianEventEndDate> MetaData => metaData;
        
        /// <summary>
        /// Election to specify the number of days after the occurrence of the Custodian Event/Collateral Management Event for the purpose of qualifying the CE/CME End Date.
        /// </summary>
        public CustomisableOffset DaysAfterCustodianEvent { get; }
        
        /// <summary>
        /// Election to specify the number of days prior to the termination of the Control Agreement /Collateral Management Event for the purpose of qualifying the CE/CME End Date, in the case where advance notice is given.
        /// </summary>
        public CustomisableOffset ReleaseDate { get; }
        
        /// <summary>
        /// The parties&apos; election to specify the number of days prior to the end of the safekeeping period (Clearstream CTA) purpose of qualifying the CE/CME End Date, in the case where advance notice is given.
        /// </summary>
        public CustomisableOffset? SafekeepingPeriodExpiry { get; }
        
        /// <summary>
        /// The parties&apos; election to specify the number of days one party has effectively provided the Timely Statement to the other party.
        /// </summary>
        public CustomisableOffset DateOfTimelyStatement { get; }
    }
    
    /// <summary>
    /// A class to specify the Custodian Risk elections specific to a Credit Support Agreement.
    /// </summary>
    public class CustodianRisk : AbstractRosettaModelObject<CustodianRisk>
    {
        private static readonly IRosettaMetaData<CustodianRisk> metaData = new CustodianRiskMeta();
        
        [JsonConstructor]
        public CustodianRisk(IEnumerable<CustodianRiskElection> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustodianRisk> MetaData => metaData;
        
        /// <summary>
        /// The party specific elections.
        /// </summary>
        public IEnumerable<CustodianRiskElection> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify the Custodian Risk.
    /// </summary>
    public class CustodianRiskElection : AbstractRosettaModelObject<CustodianRiskElection>
    {
        private static readonly IRosettaMetaData<CustodianRiskElection> metaData = new CustodianRiskElectionMeta();
        
        [JsonConstructor]
        public CustodianRiskElection(Enums.CounterpartyRole? party, bool isSpecified, string? qualification)
        {
            Party = party;
            IsSpecified = isSpecified;
            Qualification = qualification;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustodianRiskElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole? Party { get; }
        
        /// <summary>
        /// The qualification as to whether the risk is deemed as Specified.
        /// </summary>
        public bool IsSpecified { get; }
        
        /// <summary>
        /// The Custodian Risk or Collateral Manager Risk qualification.
        /// </summary>
        public string? Qualification { get; }
    }
    
    /// <summary>
    /// A class to specify the requirements applicable to the custodian with respect to the holding of posted collateral.
    /// </summary>
    public class CustodianTerms : AbstractRosettaModelObject<CustodianTerms>
    {
        private static readonly IRosettaMetaData<CustodianTerms> metaData = new CustodianTermsMeta();
        
        [JsonConstructor]
        public CustodianTerms(Money? minimumAssets, CreditNotation? minimumRating, LegalEntity? initialDesignation)
        {
            MinimumAssets = minimumAssets;
            MinimumRating = minimumRating;
            InitialDesignation = initialDesignation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustodianTerms> MetaData => metaData;
        
        /// <summary>
        /// The minimal level of assets requirement with respect to the custody agent.
        /// </summary>
        public Money? MinimumAssets { get; }
        
        /// <summary>
        /// The minimal rating requirement with respect to the custody agent.
        /// </summary>
        public CreditNotation? MinimumRating { get; }
        
        /// <summary>
        /// Election to specify the initial custodian.
        /// </summary>
        public LegalEntity? InitialDesignation { get; }
    }
    
    /// <summary>
    /// A class to specify the Custody Arrangements for the agreement.
    /// </summary>
    public class CustodyArrangements : AbstractRosettaModelObject<CustodyArrangements>
    {
        private static readonly IRosettaMetaData<CustodyArrangements> metaData = new CustodyArrangementsMeta();
        
        [JsonConstructor]
        public CustodyArrangements(bool? isCreditSupportDocument, bool? hasControlAgreementLanguage, string? otherProvisions, CollateralAccessBreach? collateralAccessBreach, CustodianRisk? custodianRisk, ControlAgreement? controlAgreement, CustodianEvent custodianEvent, Custodian? custodian, CollateralManagementAgreement? collateralManagementAgreement)
        {
            IsCreditSupportDocument = isCreditSupportDocument;
            HasControlAgreementLanguage = hasControlAgreementLanguage;
            OtherProvisions = otherProvisions;
            CollateralAccessBreach = collateralAccessBreach;
            CustodianRisk = custodianRisk;
            ControlAgreement = controlAgreement;
            CustodianEvent = custodianEvent;
            Custodian = custodian;
            CollateralManagementAgreement = collateralManagementAgreement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustodyArrangements> MetaData => metaData;
        
        /// <summary>
        /// Unless specified as True, the Control Agreement is not a Credit Support Document under the agreement with respect to a party.
        /// </summary>
        public bool? IsCreditSupportDocument { get; }
        
        /// <summary>
        /// Control Agreement language is specified when True.
        /// </summary>
        public bool? HasControlAgreementLanguage { get; }
        
        /// <summary>
        /// Other Custom Provisions of Custody Arrangements.
        /// </summary>
        public string? OtherProvisions { get; }
        
        /// <summary>
        /// The elections specific to Collateral Access Breach language.
        /// </summary>
        public CollateralAccessBreach? CollateralAccessBreach { get; }
        
        /// <summary>
        /// The qualification of the Custodian Risk.
        /// </summary>
        public CustodianRisk? CustodianRisk { get; }
        
        /// <summary>
        /// The party-specific election with respect to the control agreement.
        /// </summary>
        public ControlAgreement? ControlAgreement { get; }
        
        /// <summary>
        /// Specifies if and until when a Custodian Event clause applies.
        /// </summary>
        public CustodianEvent CustodianEvent { get; }
        
        /// <summary>
        /// The custodian and segregated account details for each party to the agreement.
        /// </summary>
        public Custodian? Custodian { get; }
        
        public CollateralManagementAgreement? CollateralManagementAgreement { get; }
    }
    
    /// <summary>
    /// A class to specify an offset either as a normalized [multiplier, period, dayType] or as a custom provision of type string.
    /// </summary>
    public class CustomisableOffset : AbstractRosettaModelObject<CustomisableOffset>
    {
        private static readonly IRosettaMetaData<CustomisableOffset> metaData = new CustomisableOffsetMeta();
        
        [JsonConstructor]
        public CustomisableOffset(Offset? offset, string? customProvision)
        {
            Offset = offset;
            CustomProvision = customProvision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustomisableOffset> MetaData => metaData;
        
        public Offset? Offset { get; }
        
        public string? CustomProvision { get; }
    }
    
    /// <summary>
    /// In its initial iteration, this class is meant to support the DTCC TIW workflow information.
    /// </summary>
    public class CustomisedWorkflow : AbstractRosettaModelObject<CustomisedWorkflow>
    {
        private static readonly IRosettaMetaData<CustomisedWorkflow> metaData = new CustomisedWorkflowMeta();
        
        [JsonConstructor]
        public CustomisedWorkflow(string itemName, string itemValue)
        {
            ItemName = itemName;
            ItemValue = itemValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<CustomisedWorkflow> MetaData => metaData;
        
        /// <summary>
        /// In this initial iteration, this corresponds to the DTCC TIW element name.
        /// </summary>
        public string ItemName { get; }
        
        /// <summary>
        /// In this initial iteration, this corresponds to the DTCC value.
        /// </summary>
        public string ItemValue { get; }
    }
    
    /// <summary>
    /// List of dates.
    /// </summary>
    public class DateList : AbstractRosettaModelObject<DateList>
    {
        private static readonly IRosettaMetaData<DateList> metaData = new DateListMeta();
        
        [JsonConstructor]
        public DateList(IEnumerable<LocalDate> date)
        {
            Date = date;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateList> MetaData => metaData;
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public IEnumerable<LocalDate> Date { get; }
    }
    
    /// <summary>
    /// A class defining a contiguous series of calendar dates. The date range is defined as all the dates between and including the start and the end date. The start date must fall on or before the end date.
    /// </summary>
    public class DateRange : AbstractRosettaModelObject<DateRange>, IDateRange
    {
        private static readonly IRosettaMetaData<DateRange> metaData = new DateRangeMeta();
        
        [JsonConstructor]
        public DateRange(LocalDate startDate, LocalDate endDate)
        {
            StartDate = startDate;
            EndDate = endDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateRange> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StartDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EndDate { get; }
    }
    
    /// <summary>
    /// A data to:  provide the ability to point to multiple payment nodes in the document through the unbounded paymentDatesReference.
    /// </summary>
    public class DateRelativeToCalculationPeriodDates : AbstractRosettaModelObject<DateRelativeToCalculationPeriodDates>
    {
        private static readonly IRosettaMetaData<DateRelativeToCalculationPeriodDates> metaData = new DateRelativeToCalculationPeriodDatesMeta();
        
        [JsonConstructor]
        public DateRelativeToCalculationPeriodDates(IEnumerable<ReferenceWithMetaCalculationPeriodDates> calculationPeriodDatesReference)
        {
            CalculationPeriodDatesReference = calculationPeriodDatesReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateRelativeToCalculationPeriodDates> MetaData => metaData;
        
        /// <summary>
        /// A set of href pointers to calculation period dates defined somewhere else in the document.
        /// </summary>
        public IEnumerable<ReferenceWithMetaCalculationPeriodDates> CalculationPeriodDatesReference { get; }
    }
    
    /// <summary>
    /// A data to:  provide the ability to point to multiple payment nodes in the document through the unbounded paymentDatesReference.
    /// </summary>
    public class DateRelativeToPaymentDates : AbstractRosettaModelObject<DateRelativeToPaymentDates>
    {
        private static readonly IRosettaMetaData<DateRelativeToPaymentDates> metaData = new DateRelativeToPaymentDatesMeta();
        
        [JsonConstructor]
        public DateRelativeToPaymentDates(IEnumerable<ReferenceWithMetaPaymentDates> paymentDatesReference)
        {
            PaymentDatesReference = paymentDatesReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateRelativeToPaymentDates> MetaData => metaData;
        
        /// <summary>
        /// A set of href pointers to payment dates defined somewhere else in the document.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPaymentDates> PaymentDatesReference { get; }
    }
    
    /// <summary>
    /// A data to:  provide the ability to point to multiple payment nodes in the document through the unbounded paymentDatesReference.
    /// </summary>
    public class DateRelativeToValuationDates : AbstractRosettaModelObject<DateRelativeToValuationDates>
    {
        private static readonly IRosettaMetaData<DateRelativeToValuationDates> metaData = new DateRelativeToValuationDatesMeta();
        
        [JsonConstructor]
        public DateRelativeToValuationDates(IEnumerable<ReferenceWithMetaPerformanceValuationDates> valuationDatesReference)
        {
            ValuationDatesReference = valuationDatesReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateRelativeToValuationDates> MetaData => metaData;
        
        /// <summary>
        /// A set of href pointers to valuation period dates defined somewhere else in the document.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPerformanceValuationDates> ValuationDatesReference { get; }
    }
    
    /// <summary>
    /// List of dateTimes.
    /// </summary>
    public class DateTimeList : AbstractRosettaModelObject<DateTimeList>
    {
        private static readonly IRosettaMetaData<DateTimeList> metaData = new DateTimeListMeta();
        
        [JsonConstructor]
        public DateTimeList(IEnumerable<ZonedDateTime> dateTime)
        {
            DateTime = dateTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DateTimeList> MetaData => metaData;
        
        /// <summary>
        /// The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.
        /// </summary>
        public IEnumerable<ZonedDateTime> DateTime { get; }
    }
    
    /// <summary>
    /// Defines the dates agreed by the parties as the date of the Credit Support Annex or Credit Support Deed.
    /// </summary>
    public class DatedAsOfDate : AbstractRosettaModelObject<DatedAsOfDate>
    {
        private static readonly IRosettaMetaData<DatedAsOfDate> metaData = new DatedAsOfDateMeta();
        
        [JsonConstructor]
        public DatedAsOfDate(LocalDate? csaDatedAsOfDate, LocalDate? masterAgreementDatedAsOfDate, LocalDate? csaMadeOn, string? additionalLanguage)
        {
            CsaDatedAsOfDate = csaDatedAsOfDate;
            MasterAgreementDatedAsOfDate = masterAgreementDatedAsOfDate;
            CsaMadeOn = csaMadeOn;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DatedAsOfDate> MetaData => metaData;
        
        /// <summary>
        /// The date agreed by the parties as the Dated as of Date for the Credit Support Annex.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? CsaDatedAsOfDate { get; }
        
        /// <summary>
        /// The date agreed by the parties as the Dated as of Date for the Master Agreement.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? MasterAgreementDatedAsOfDate { get; }
        
        /// <summary>
        /// The date agreed by the parties as the Made On date of the Credit Support Deed.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? CsaMadeOn { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Defines a date and value pair. This definition is used for varying rate or amount schedules, e.g. a notional amortisation or a step-up coupon schedule.
    /// </summary>
    public class DatedValue : AbstractRosettaModelObject<DatedValue>
    {
        private static readonly IRosettaMetaData<DatedValue> metaData = new DatedValueMeta();
        
        [JsonConstructor]
        public DatedValue(LocalDate date, decimal value, _MetaFields? meta)
        {
            Date = date;
            Value = value;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DatedValue> MetaData => metaData;
        
        /// <summary>
        /// The date on which the associated step value becomes effective. This day may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate Date { get; }
        
        /// <summary>
        /// The rate of amount which becomes effective on the associated step date. A rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal Value { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies selected economics of a debt instrument.
    /// </summary>
    public class DebtEconomics : AbstractRosettaModelObject<DebtEconomics>
    {
        private static readonly IRosettaMetaData<DebtEconomics> metaData = new DebtEconomicsMeta();
        
        [JsonConstructor]
        public DebtEconomics(Enums.DebtSeniority? debtSeniority, Enums.DebtInterest? debtInterest, Enums.DebtPrincipal? debtPrincipal)
        {
            DebtSeniority = debtSeniority;
            DebtInterest = debtInterest;
            DebtPrincipal = debtPrincipal;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DebtEconomics> MetaData => metaData;
        
        /// <summary>
        /// Specifies the order of repayment in the event of a sale or bankruptcy of the issuer or a related party (eg guarantor).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DebtSeniority? DebtSeniority { get; }
        
        /// <summary>
        /// Specifies the general rule for periodic interest rate payment.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DebtInterest? DebtInterest { get; }
        
        /// <summary>
        /// Specifies the general rule for repayment of principal.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DebtPrincipal? DebtPrincipal { get; }
    }
    
    /// <summary>
    /// Specifies the type of debt instrument.
    /// </summary>
    public class DebtType : AbstractRosettaModelObject<DebtType>
    {
        private static readonly IRosettaMetaData<DebtType> metaData = new DebtTypeMeta();
        
        [JsonConstructor]
        public DebtType(Enums.DebtClass? debtClass, IEnumerable<DebtEconomics> debtEconomics)
        {
            DebtClass = debtClass;
            DebtEconomics = debtEconomics;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DebtType> MetaData => metaData;
        
        /// <summary>
        /// Specifies the characteristics of a debt instrument.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DebtClass? DebtClass { get; }
        
        /// <summary>
        /// Specifies selected financial terms of a debt instrument.
        /// </summary>
        public IEnumerable<DebtEconomics> DebtEconomics { get; }
    }
    
    /// <summary>
    /// A class to specify all the ISDA terms relevant to defining the deliverable obligations.
    /// </summary>
    public class DeliverableObligations : AbstractRosettaModelObject<DeliverableObligations>
    {
        private static readonly IRosettaMetaData<DeliverableObligations> metaData = new DeliverableObligationsMeta();
        
        [JsonConstructor]
        public DeliverableObligations(bool? accruedInterest, Enums.ObligationCategory? category, bool? notSubordinated, SpecifiedCurrency? specifiedCurrency, bool? notSovereignLender, NotDomesticCurrency? notDomesticCurrency, bool? notDomesticLaw, bool? listed, bool? notContingent, bool? notDomesticIssuance, PCDeliverableObligationCharac? assignableLoan, PCDeliverableObligationCharac? consentRequiredLoan, LoanParticipation? directLoanParticipation, bool? transferable, Period? maximumMaturity, bool? acceleratedOrMatured, bool? notBearer, bool? fullFaithAndCreditObLiability, bool? generalFundObligationLiability, bool? revenueObligationLiability, LoanParticipation? indirectLoanParticipation, string? excluded, string? othReferenceEntityObligations)
        {
            AccruedInterest = accruedInterest;
            Category = category;
            NotSubordinated = notSubordinated;
            SpecifiedCurrency = specifiedCurrency;
            NotSovereignLender = notSovereignLender;
            NotDomesticCurrency = notDomesticCurrency;
            NotDomesticLaw = notDomesticLaw;
            Listed = listed;
            NotContingent = notContingent;
            NotDomesticIssuance = notDomesticIssuance;
            AssignableLoan = assignableLoan;
            ConsentRequiredLoan = consentRequiredLoan;
            DirectLoanParticipation = directLoanParticipation;
            Transferable = transferable;
            MaximumMaturity = maximumMaturity;
            AcceleratedOrMatured = acceleratedOrMatured;
            NotBearer = notBearer;
            FullFaithAndCreditObLiability = fullFaithAndCreditObLiability;
            GeneralFundObligationLiability = generalFundObligationLiability;
            RevenueObligationLiability = revenueObligationLiability;
            IndirectLoanParticipation = indirectLoanParticipation;
            Excluded = excluded;
            OthReferenceEntityObligations = othReferenceEntityObligations;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeliverableObligations> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether accrued interest is included (true) or not (false). For cash settlement this specifies whether quotations should be obtained inclusive or not of accrued interest. For physical settlement this specifies whether the buyer should deliver the obligation with an outstanding principal balance that includes or excludes accrued interest. ISDA 2003 Term: Include/Exclude Accrued Interest.
        /// </summary>
        public bool? AccruedInterest { get; }
        
        /// <summary>
        /// Used in both obligations and deliverable obligations to represent a class or type of securities which apply. ISDA 2003 Term: Obligation Category/Deliverable Obligation Category.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ObligationCategory? Category { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. An obligation that ranks at least equal with the most senior Reference Obligation in priority of payment or, if no Reference Obligation is specified in the related Confirmation, the obligations of the Reference Entity that are senior. ISDA 2003 Term: Not Subordinated.
        /// </summary>
        public bool? NotSubordinated { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. The currency or currencies in which an obligation or deliverable obligation must be payable. ISDA 2003 Term: Specified Currency.
        /// </summary>
        public SpecifiedCurrency? SpecifiedCurrency { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation that is not primarily (majority) owed to a Sovereign or Supranational Organisation. ISDA 2003 Term: Not Sovereign Lender.
        /// </summary>
        public bool? NotSovereignLender { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation that is payable in any currency other than the domestic currency. Domestic currency is either the currency so specified or, if no currency is specified, the currency of (a) the reference entity, if the reference entity is a sovereign, or (b) the jurisdiction in which the relevant reference entity is organised, if the reference entity is not a sovereign. ISDA 2003 Term: Not Domestic Currency.
        /// </summary>
        public NotDomesticCurrency? NotDomesticCurrency { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. If the reference entity is a Sovereign, this means any obligation that is not subject to the laws of the reference entity. If the reference entity is not a sovereign, this means any obligation that is not subject to the laws of the jurisdiction of the reference entity. ISDA 2003 Term: Not Domestic Law.
        /// </summary>
        public bool? NotDomesticLaw { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Indicates whether or not the obligation is quoted, listed or ordinarily purchased and sold on an exchange. ISDA 2003 Term: Listed.
        /// </summary>
        public bool? Listed { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. In essence Not Contingent means the repayment of principal cannot be dependant on a formula/index, i.e. to prevent the risk of being delivered an instrument that may never pay any element of principal, and to ensure that the obligation is interest bearing (on a regular schedule). ISDA 2003 Term: Not Contingent.
        /// </summary>
        public bool? NotContingent { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation other than an obligation that was intended to be offered for sale primarily in the domestic market of the relevant Reference Entity. This specifies that the obligation must be an internationally recognised bond. ISDA 2003 Term: Not Domestic Issuance.
        /// </summary>
        public bool? NotDomesticIssuance { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. A loan that is freely assignable to a bank or financial institution without the consent of the Reference Entity or the guarantor, if any, of the loan (or the consent of the applicable borrower if a Reference Entity is guaranteeing the loan) or any agent. ISDA 2003 Term: Assignable Loan.
        /// </summary>
        public PCDeliverableObligationCharac? AssignableLoan { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. A loan that is capable of being assigned with the consent of the Reference Entity or the guarantor, if any, of the loan or any agent. ISDA 2003 Term: Consent Required Loan.
        /// </summary>
        public PCDeliverableObligationCharac? ConsentRequiredLoan { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. A loan with a participation agreement whereby the buyer is capable of creating, or procuring the creation of, a contractual right in favour of the seller that provides the seller with recourse to the participation seller for a specified share in any payments due under the relevant loan which are received by the participation seller. ISDA 2003 Term: Direct Loan Participation.
        /// </summary>
        public LoanParticipation? DirectLoanParticipation { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. An obligation that is transferable to institutional investors without any contractual, statutory or regulatory restrictions. ISDA 2003 Term: Transferable.
        /// </summary>
        public bool? Transferable { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. An obligation that has a remaining maturity from the Physical Settlement Date of not greater than the period specified. ISDA 2003 Term: Maximum Maturity.
        /// </summary>
        public Period? MaximumMaturity { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. An obligation at time of default is due to mature and due to be repaid, or as a result of downgrade/bankruptcy is due to be repaid as a result of an acceleration clause. ISDA 2003 Term: Accelerated or Matured.
        /// </summary>
        public bool? AcceleratedOrMatured { get; }
        
        /// <summary>
        /// A deliverable obligation characteristic. Any obligation that is not a bearer instrument. This applies to Bonds only and is meant to avoid tax, fraud and security/delivery provisions that can potentially be associated with Bearer Bonds. ISDA 2003 Term: Not Bearer.
        /// </summary>
        public bool? NotBearer { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: Full Faith and Credit Obligation Liability.
        /// </summary>
        public bool? FullFaithAndCreditObLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: General Fund Obligation Liability.
        /// </summary>
        public bool? GeneralFundObligationLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: Revenue Obligation Liability.
        /// </summary>
        public bool? RevenueObligationLiability { get; }
        
        /// <summary>
        /// ISDA 1999 Term: Indirect Loan Participation. NOTE: Only applicable as a deliverable obligation under ISDA Credit 1999.
        /// </summary>
        public LoanParticipation? IndirectLoanParticipation { get; }
        
        /// <summary>
        /// A free format string to specify any excluded obligations or deliverable obligations, as the case may be, of the reference entity or excluded types of obligations or deliverable obligations. ISDA 2003 Term: Excluded Obligations/Excluded Deliverable Obligations.
        /// </summary>
        public string? Excluded { get; }
        
        /// <summary>
        /// This element is used to specify any other obligations of a reference entity in both obligations and deliverable obligations. The obligations can be specified free-form. ISDA 2003 Term: Other Obligations of a Reference Entity.
        /// </summary>
        public string? OthReferenceEntityObligations { get; }
    }
    
    /// <summary>
    /// A class to specify the application of Interest Amount with respect the Delivery Amount.
    /// </summary>
    public class DeliveryAmount : AbstractRosettaModelObject<DeliveryAmount>
    {
        private static readonly IRosettaMetaData<DeliveryAmount> metaData = new DeliveryAmountMeta();
        
        [JsonConstructor]
        public DeliveryAmount(Enums.DeliveryAmountElection? standardElection, string? customElection)
        {
            StandardElection = standardElection;
            CustomElection = customElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeliveryAmount> MetaData => metaData;
        
        /// <summary>
        /// The standard election as specified by an enumeration.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeliveryAmountElection? StandardElection { get; }
        
        /// <summary>
        /// The custom election that might be specified by the parties to the agreement.
        /// </summary>
        public string? CustomElection { get; }
    }
    
    /// <summary>
    /// Specifies a specific date or the parameters for identifying the relevant contract date when the commodity reference price is a futures contract.
    /// </summary>
    public class DeliveryDateParameters : AbstractRosettaModelObject<DeliveryDateParameters>
    {
        private static readonly IRosettaMetaData<DeliveryDateParameters> metaData = new DeliveryDateParametersMeta();
        
        [JsonConstructor]
        public DeliveryDateParameters(Offset? deliveryNearby, AdjustableDate? deliveryDate, Offset? deliveryDateRollConvention, Offset? deliveryDateExpirationConvention)
        {
            DeliveryNearby = deliveryNearby;
            DeliveryDate = deliveryDate;
            DeliveryDateRollConvention = deliveryDateRollConvention;
            DeliveryDateExpirationConvention = deliveryDateExpirationConvention;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeliveryDateParameters> MetaData => metaData;
        
        /// <summary>
        /// Provides a container for the parametric representation that specifies which nearby contract date would be used as a refrence for a price.
        /// </summary>
        public Offset? DeliveryNearby { get; }
        
        /// <summary>
        /// Specifies the specific contract date for the contract that should be referenced for a price.
        /// </summary>
        public AdjustableDate? DeliveryDate { get; }
        
        /// <summary>
        /// Specifies, for a Commodity Transaction that references a listed future, the day on which the specified future will roll to the next nearby month prior to the expiration of the referenced future. If the future will not roll at all - i.e. the price will be taken from the expiring contract, 0 days should be specified here. If the future will roll to the next nearby on the last trading day - i.e. the price will be taken from the next nearby on the last trading day, then 1 business day should be specified and so on.
        /// </summary>
        public Offset? DeliveryDateRollConvention { get; }
        
        /// <summary>
        /// Specifies, for a Commodity Transaction that references a listed future, the day on which the specified future will expire ahead of the actual expiration of the referenced future. For example: Z21 Contract expires on 19Nov21, with an adjust of 2D the &apos;expire&apos; will be 16Nov21. DeliveryDateRollConvention takes precedence. Example: Pricing on the Z21 Contract with NearbyContractDay and a deliveryDateRoll of 10D, Sampling of the F22 Contract will occur on 8Nov21 through the last Date of the Z21 Contract. With an ExpConvention of 5D, the last sampling date on the F22 contract will be 12Nov21.
        /// </summary>
        public Offset? DeliveryDateExpirationConvention { get; }
    }
    
    /// <summary>
    /// The optional specification of address where the demands, specifications and notices will be communicated to for each of the parties to the agreement.
    /// </summary>
    public class DemandsAndNotices : AbstractRosettaModelObject<DemandsAndNotices>
    {
        private static readonly IRosettaMetaData<DemandsAndNotices> metaData = new DemandsAndNoticesMeta();
        
        [JsonConstructor]
        public DemandsAndNotices(IEnumerable<PartyContactInformation> partyElection, bool deemedEffectiveNextLBD)
        {
            PartyElection = partyElection;
            DeemedEffectiveNextLBD = deemedEffectiveNextLBD;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DemandsAndNotices> MetaData => metaData;
        
        /// <summary>
        /// The parties&apos; contact information election.
        /// </summary>
        public IEnumerable<PartyContactInformation> PartyElection { get; }
        
        /// <summary>
        /// Specifies if notice shall be deemed to be effective at the time such notice is actually received unless such notice is received on a day which is not a Local Business Day or after the Notification Time on any Local Business Day in which event such notice shall be deemed to be effective on the next succeeding Local Business Day. If deemed effective,&apos;True&apos;. If not deemed effective, or not stated,&apos;False&apos;.
        /// </summary>
        public bool DeemedEffectiveNextLBD { get; }
    }
    
    public class DerivInstrmAttrbts : AbstractRosettaModelObject<DerivInstrmAttrbts>
    {
        private static readonly IRosettaMetaData<DerivInstrmAttrbts> metaData = new DerivInstrmAttrbtsMeta();
        
        [JsonConstructor]
        public DerivInstrmAttrbts(string xpryDt, string pricMltplr, UndrlygInstrm undrlygInstrm, string dlvryTp)
        {
            XpryDt = xpryDt;
            PricMltplr = pricMltplr;
            UndrlygInstrm = undrlygInstrm;
            DlvryTp = dlvryTp;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DerivInstrmAttrbts> MetaData => metaData;
        
        public string XpryDt { get; }
        
        public string PricMltplr { get; }
        
        public UndrlygInstrm UndrlygInstrm { get; }
        
        public string DlvryTp { get; }
    }
    
    /// <summary>
    /// Specifies the method according to which an amount or a date is determined.
    /// </summary>
    public class DeterminationMethodology : AbstractRosettaModelObject<DeterminationMethodology>
    {
        private static readonly IRosettaMetaData<DeterminationMethodology> metaData = new DeterminationMethodologyMeta();
        
        [JsonConstructor]
        public DeterminationMethodology(Enums.DeterminationMethod? determinationMethod, Enums.AveragingCalculationMethod? averagingMethod)
        {
            DeterminationMethod = determinationMethod;
            AveragingMethod = averagingMethod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeterminationMethodology> MetaData => metaData;
        
        /// <summary>
        /// Represents a more granular dimention of observation. Typically relevent for resolving a unique equity price, which can be expressed as trade-weighted or volume-weighted averages.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? DeterminationMethod { get; }
        
        /// <summary>
        /// Specifies enumerations for the type of averaging calculation.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingCalculationMethod? AveragingMethod { get; }
    }
    
    /// <summary>
    /// Defines the roles and related terms which document the agreement of parties about any determination requirements ; mostly about Extraordinary Events, without being necessarily restricted to such scope, as further specified in the particular product at stake e.g. for instance when Calculation Agent is mentioned as the Price Determination Method enumarated value, etc.
    /// </summary>
    public class DeterminationRolesAndTerms : AbstractRosettaModelObject<DeterminationRolesAndTerms>
    {
        private static readonly IRosettaMetaData<DeterminationRolesAndTerms> metaData = new DeterminationRolesAndTermsMeta();
        
        [JsonConstructor]
        public DeterminationRolesAndTerms(Enums.DeterminationRole determinationRole, IEnumerable<Enums.CounterpartyRole> whoToDetermine, Enums.CounterpartyRole? disputingParty, Clause? fallbackLanguageBespokeTerms)
        {
            DeterminationRole = determinationRole;
            WhoToDetermine = whoToDetermine;
            DisputingParty = disputingParty;
            FallbackLanguageBespokeTerms = fallbackLanguageBespokeTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DeterminationRolesAndTerms> MetaData => metaData;
        
        /// <summary>
        /// Defines the enumerated values to specify the determination roles to the transaction. Such roles mostly address any determination that would be required when some Extraordinary Events would happen, for instance qualifying the effectiveness of such event, or when a calculation is required, etc. else any other kind of determination as need be. Yet for clarity, other kinds of determination may be covered by such roles, which are not necessarily restricted to the scope of Extarordinary Events, depending on particular product specifications e.g. for instance when Calculation Agent is mentioned as the Price Determination Method enumarated value, etc.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationRole DeterminationRole { get; }
        
        /// <summary>
        /// Designates which Counterparty to the transaction is granted with the particular role ; cardinality of this object is 2, in case parties are both having the same role e.g. jointly CalculationAgent, jointly Determining Party, etc. 
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> WhoToDetermine { get; }
        
        /// <summary>
        /// Where the party who is not granted with the determination role at least has a right to dispute the determination given by the counterparty with such role. As an example, a given PartyA is the unique Counterparty with the Role of CalculationAgent, yet Party B could be Disputing Party in regard of such Role.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole? DisputingParty { get; }
        
        /// <summary>
        /// Where parties may optionnaly describe any extra bespoke agreements about fallback procedure attached to a particular determination role. This fallback bespoke paragraph would typically address topics such as : delay for the Disputing Party to notify a disagreement when receiving a determination from the Calculation Agent ; Independent Third Party Dealers election terms e.g. number of Dealers to be jointly elected by the counterparties ; delay for joint election of Dealers by the counterparties ; further fallback election procedure in case of disagreement between parties to jointly elect all the Dealers e.g. typically each party designates 1 Dealer, each a Party Representant, which thus result in 2 Dealers in charge of joint election of 3 other Dealers who will be the final ones to provide the response, each a Final Dealer ; delay for joint election of the Final Dealers by the Party Representants ; fees repartition e.g. typically cost and fees incurred by the election of Dealers are equally shared by the parties ; etc.
        /// </summary>
        public Clause? FallbackLanguageBespokeTerms { get; }
    }
    
    /// <summary>
    /// An Asset that exists only in digital form, eg Bitcoin or Ethereum, that is not backed by other Assets; excludes the digital representation of other Assets, eg coins or Tokenised assets.
    /// </summary>
    public class DigitalAsset : AbstractRosettaModelObject<DigitalAsset>, IAssetBase
    {
        private static readonly IRosettaMetaData<DigitalAsset> metaData = new DigitalAssetMeta();
        
        [JsonConstructor]
        public DigitalAsset(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DigitalAsset> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
    }
    
    /// <summary>
    /// A logical container to hold a defined set of related data. In this case the collation of Ratings Agency, Rating value and an associated direction.
    /// </summary>
    public class DirectionRating : AbstractRosettaModelObject<DirectionRating>, ICreditNotation
    {
        private static readonly IRosettaMetaData<DirectionRating> metaData = new DirectionRatingMeta();
        
        [JsonConstructor]
        public DirectionRating(Enums.CreditRatingAgency agency, FieldWithMetaString notation, FieldWithMetaString? scale, CreditRatingDebt? debt, Enums.CreditRatingOutlook? outlook, Enums.CreditRatingCreditWatch? creditWatch, Enums.CompareOp direction)
        {
            Agency = agency;
            Notation = notation;
            Scale = scale;
            Debt = debt;
            Outlook = outlook;
            CreditWatch = creditWatch;
            Direction = direction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DirectionRating> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency Agency { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString Notation { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Scale { get; }
        
        /// <inheritdoc/>
        public CreditRatingDebt? Debt { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingOutlook? Outlook { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingCreditWatch? CreditWatch { get; }
        
        /// <summary>
        /// Specifies the direction of measurement for the rated party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CompareOp Direction { get; }
    }
    
    /// <summary>
    /// A logical container to hold a defined set of related data. In this case the collation of Ratings Information and associated exposure multiplier.
    /// </summary>
    public class DirectionRatingMultiplier : AbstractRosettaModelObject<DirectionRatingMultiplier>
    {
        private static readonly IRosettaMetaData<DirectionRatingMultiplier> metaData = new DirectionRatingMultiplierMeta();
        
        [JsonConstructor]
        public DirectionRatingMultiplier(IEnumerable<DirectionRatingSet> variableSet, decimal exposureMultiplier)
        {
            VariableSet = variableSet;
            ExposureMultiplier = exposureMultiplier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DirectionRatingMultiplier> MetaData => metaData;
        
        /// <summary>
        /// A logical container to hold a defined set of related data. In this case the collation of Ratings Agency, Rating value and an associated direction.
        /// </summary>
        public IEnumerable<DirectionRatingSet> VariableSet { get; }
        
        /// <summary>
        /// Specifies the multiplier applied to exposure based on the credit rating of the rated party.
        /// </summary>
        public decimal ExposureMultiplier { get; }
    }
    
    /// <summary>
    /// A logical container to hold a defined set of related data. In this case the collation of Ratings Agency, Rating value and an associated direction that are grouped by either AND or OR logic.
    /// </summary>
    public class DirectionRatingSet : AbstractRosettaModelObject<DirectionRatingSet>
    {
        private static readonly IRosettaMetaData<DirectionRatingSet> metaData = new DirectionRatingSetMeta();
        
        [JsonConstructor]
        public DirectionRatingSet(AllDirectionRating? allDirectionRating, AnyDirectionRating? anyDirectionRating, DirectionRating? directionRating)
        {
            AllDirectionRating = allDirectionRating;
            AnyDirectionRating = anyDirectionRating;
            DirectionRating = directionRating;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DirectionRatingSet> MetaData => metaData;
        
        /// <summary>
        /// Enables two or more Direction and Ratings to be combined using AND logic.
        /// </summary>
        public AllDirectionRating? AllDirectionRating { get; }
        
        /// <summary>
        /// Enables two or more Direction and Ratings to be combined using OR logic.
        /// </summary>
        public AnyDirectionRating? AnyDirectionRating { get; }
        
        /// <summary>
        /// A logical container to hold a defined set of related data. In this case the collation of Ratings Agency, Rating value and an associated direction.
        /// </summary>
        public DirectionRating? DirectionRating { get; }
    }
    
    /// <summary>
    /// A data defining:  discounting information. The 2000 ISDA definitions, section 8.4. discounting (related to the calculation of a discounted fixed amount or floating amount) apply. This type must only be included if discounting applies.
    /// </summary>
    public class DiscountingMethod : AbstractRosettaModelObject<DiscountingMethod>
    {
        private static readonly IRosettaMetaData<DiscountingMethod> metaData = new DiscountingMethodMeta();
        
        [JsonConstructor]
        public DiscountingMethod(Enums.DiscountingType discountingType, decimal? discountRate, FieldWithMetaDayCountFractionEnum? discountRateDayCountFraction)
        {
            DiscountingType = discountingType;
            DiscountRate = discountRate;
            DiscountRateDayCountFraction = discountRateDayCountFraction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DiscountingMethod> MetaData => metaData;
        
        /// <summary>
        /// The discounting method that is applicable.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DiscountingType DiscountingType { get; }
        
        /// <summary>
        /// A discount rate, expressed as a decimal, to be used in the calculation of a discounted amount. A discount amount of 5% would be represented as 0.05.
        /// </summary>
        public decimal? DiscountRate { get; }
        
        /// <summary>
        /// A discount day count fraction to be used in the calculation of a discounted amount.
        /// </summary>
        public FieldWithMetaDayCountFractionEnum? DiscountRateDayCountFraction { get; }
    }
    
    /// <summary>
    /// A class to specify the election terms under which a party disputes the Value of any Transfer of Eligible Credit Support or Posted Credit Support.
    /// </summary>
    public class DisputeResolution : AbstractRosettaModelObject<DisputeResolution>
    {
        private static readonly IRosettaMetaData<DisputeResolution> metaData = new DisputeResolutionMeta();
        
        [JsonConstructor]
        public DisputeResolution(BusinessCenterTime? resolutionTime, string? otherTerms, string? alternativeTerms, RecalculationOfValue? recalculationOfValue, LegacyResolutionAlternative? legacyAlternative, ResolutionValue? value)
        {
            ResolutionTime = resolutionTime;
            OtherTerms = otherTerms;
            AlternativeTerms = alternativeTerms;
            RecalculationOfValue = recalculationOfValue;
            LegacyAlternative = legacyAlternative;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DisputeResolution> MetaData => metaData;
        
        /// <summary>
        /// The time by which the dispute needs to be resolved, failure of which would trigger a recalculation alongside a process that is specified as part of the agreement.
        /// </summary>
        public BusinessCenterTime? ResolutionTime { get; }
        
        /// <summary>
        /// The custom Resolution Time election that might be specified by the parties.
        /// </summary>
        public string? OtherTerms { get; }
        
        /// <summary>
        /// The alternative dispute resolution procedure if specified.
        /// </summary>
        public string? AlternativeTerms { get; }
        
        /// <summary>
        /// The elections to specify terms for recalculation of the market value of posted collateral.
        /// </summary>
        public RecalculationOfValue? RecalculationOfValue { get; }
        
        /// <summary>
        /// Alternative procedures to those in the pre-print for resolving collateral related disputes.
        /// </summary>
        public LegacyResolutionAlternative? LegacyAlternative { get; }
        
        /// <summary>
        /// Methodology for resolving disputes in respect of the determination of the value of collateral.
        /// </summary>
        public ResolutionValue? Value { get; }
    }
    
    /// <summary>
    /// A class to specify the Distributions and Interest Payment provisions applicable to the collateral agreement.
    /// </summary>
    public class DistributionAndInterestPayment : AbstractRosettaModelObject<DistributionAndInterestPayment>
    {
        private static readonly IRosettaMetaData<DistributionAndInterestPayment> metaData = new DistributionAndInterestPaymentMeta();
        
        [JsonConstructor]
        public DistributionAndInterestPayment(IEnumerable<CollateralInterestParameters> interestParameters)
        {
            InterestParameters = interestParameters;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DistributionAndInterestPayment> MetaData => metaData;
        
        /// <summary>
        /// Represents the interest parameters for the various currencies, margin types, posting parties.
        /// </summary>
        public IEnumerable<CollateralInterestParameters> InterestParameters { get; }
    }
    
    /// <summary>
    /// The parameters which define whether dividends are applicable
    /// </summary>
    public class DividendApplicability : AbstractRosettaModelObject<DividendApplicability>
    {
        private static readonly IRosettaMetaData<DividendApplicability> metaData = new DividendApplicabilityMeta();
        
        [JsonConstructor]
        public DividendApplicability(bool? optionsExchangeDividends, bool? additionalDividends, bool? allDividends)
        {
            OptionsExchangeDividends = optionsExchangeDividends;
            AdditionalDividends = additionalDividends;
            AllDividends = allDividends;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendApplicability> MetaData => metaData;
        
        /// <summary>
        /// If present and true, then options exchange dividends are applicable.
        /// </summary>
        public bool? OptionsExchangeDividends { get; }
        
        /// <summary>
        /// If present and true, then additional dividends are applicable.
        /// </summary>
        public bool? AdditionalDividends { get; }
        
        /// <summary>
        /// Represents the European Master Confirmation value of &apos;All Dividends&apos; which, when applicable, signifies that, for a given Ex-Date, the daily observed Share Price for that day is adjusted (reduced) by the cash dividend and/or the cash value of any non cash dividend per Share (including Extraordinary Dividends) declared by the Issuer. All Dividends in accordance with the ISDA 2002 Equity Derivatives Definitions.
        /// </summary>
        public bool? AllDividends { get; }
    }
    
    /// <summary>
    /// A class to specify the currency in which the dividends will be denominated, i.e. either in the dividend currency or in a currency specified as part of the contract.
    /// </summary>
    public class DividendCurrency : AbstractRosettaModelObject<DividendCurrency>
    {
        private static readonly IRosettaMetaData<DividendCurrency> metaData = new DividendCurrencyMeta();
        
        [JsonConstructor]
        public DividendCurrency(FieldWithMetaString? currency, Enums.DeterminationMethod? determinationMethod, BasicReferenceWithMetaString? currencyReference)
        {
            Currency = currency;
            DeterminationMethod = determinationMethod;
            CurrencyReference = currencyReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendCurrency> MetaData => metaData;
        
        /// <summary>
        /// The currency in which the dividend is denominated. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
        
        /// <summary>
        /// Specifies the method according to which the dividend is determined, e.g. the dividend currency.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DeterminationMethod? DeterminationMethod { get; }
        
        /// <summary>
        /// Reference to a currency specified elsewhere in the document
        /// </summary>
        public BasicReferenceWithMetaString? CurrencyReference { get; }
    }
    
    /// <summary>
    /// A class to specify the dividend date by reference to another date, with the ability to apply and offset. This class doesn&apos;t exist in FpML and is meant to simplify the choice constraint associated with the DividendPaymentDate class.
    /// </summary>
    public class DividendDateReference : AbstractRosettaModelObject<DividendDateReference>
    {
        private static readonly IRosettaMetaData<DividendDateReference> metaData = new DividendDateReferenceMeta();
        
        [JsonConstructor]
        public DividendDateReference(Enums.DividendDateReference dateReference, Offset? paymentDateOffset)
        {
            DateReference = dateReference;
            PaymentDateOffset = paymentDateOffset;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendDateReference> MetaData => metaData;
        
        /// <summary>
        /// Specification of the dividend date using an enumeration, with values such as the pay date, the ex-date or the record date.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendDateReference DateReference { get; }
        
        /// <summary>
        /// Only to be used when SharePayment has been specified in the dividendDateReference element. The number of Currency Business Days following the day on which the Issuer of the Shares pays the relevant dividend to holders of record of the Shares.
        /// </summary>
        public Offset? PaymentDateOffset { get; }
    }
    
    /// <summary>
    /// A class describing the date on which the dividend will be paid/received. This class is also used to specify the date on which the FX rate will be determined, when applicable.
    /// </summary>
    public class DividendPaymentDate : AbstractRosettaModelObject<DividendPaymentDate>
    {
        private static readonly IRosettaMetaData<DividendPaymentDate> metaData = new DividendPaymentDateMeta();
        
        [JsonConstructor]
        public DividendPaymentDate(DividendDateReference? dividendDateReference, ReferenceWithMetaAdjustableOrRelativeDate? dividendDate)
        {
            DividendDateReference = dividendDateReference;
            DividendDate = dividendDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendPaymentDate> MetaData => metaData;
        
        public DividendDateReference? DividendDateReference { get; }
        
        public ReferenceWithMetaAdjustableOrRelativeDate? DividendDate { get; }
    }
    
    /// <summary>
    /// A class describing the dividend payout ratio associated with an equity underlier. In certain cases the actual ratio is not known on trade inception, and only general conditions are then specified.
    /// </summary>
    public class DividendPayoutRatio : AbstractRosettaModelObject<DividendPayoutRatio>
    {
        private static readonly IRosettaMetaData<DividendPayoutRatio> metaData = new DividendPayoutRatioMeta();
        
        [JsonConstructor]
        public DividendPayoutRatio(decimal totalRatio, decimal? cashRatio, decimal? nonCashRatio, ReferenceWithMetaBasketConstituent? basketConstituent)
        {
            TotalRatio = totalRatio;
            CashRatio = cashRatio;
            NonCashRatio = nonCashRatio;
            BasketConstituent = basketConstituent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendPayoutRatio> MetaData => metaData;
        
        /// <summary>
        /// Specifies the total actual dividend payout ratio associated with the equity underlier. A ratio of 90% should be expressed at 0.90.
        /// </summary>
        public decimal TotalRatio { get; }
        
        /// <summary>
        /// Specifies the cash actual dividend payout ratio associated with the equity underlier. A ratio of 90% should be expressed at 0.90.
        /// </summary>
        public decimal? CashRatio { get; }
        
        /// <summary>
        /// Specifies the non cash actual dividend payout ratio associated with the equity underlier. A ratio of 90% should be expressed at 0.90.
        /// </summary>
        public decimal? NonCashRatio { get; }
        
        /// <summary>
        /// In the case of a basket underlier, specifies to which component of the basket this particular set of dividend payout ratios correspond.
        /// </summary>
        public ReferenceWithMetaBasketConstituent? BasketConstituent { get; }
    }
    
    /// <summary>
    /// Time bounded dividend payment periods, each with a dividend payment date per period.
    /// </summary>
    public class DividendPeriod : AbstractRosettaModelObject<DividendPeriod>
    {
        private static readonly IRosettaMetaData<DividendPeriod> metaData = new DividendPeriodMeta();
        
        [JsonConstructor]
        public DividendPeriod(DividendPaymentDate? startDate, DividendPaymentDate? endDate, BusinessDayAdjustments dateAdjustments, ReferenceWithMetaBasketConstituent? basketConstituent, DividendPaymentDate dividendPaymentDate, AdjustableOrRelativeDate? dividendValuationDate)
        {
            StartDate = startDate;
            EndDate = endDate;
            DateAdjustments = dateAdjustments;
            BasketConstituent = basketConstituent;
            DividendPaymentDate = dividendPaymentDate;
            DividendValuationDate = dividendValuationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendPeriod> MetaData => metaData;
        
        /// <summary>
        /// Dividend period start date.
        /// </summary>
        public DividendPaymentDate? StartDate { get; }
        
        /// <summary>
        /// Dividend period end date.
        /// </summary>
        public DividendPaymentDate? EndDate { get; }
        
        /// <summary>
        /// Date adjustments for all unadjusted dates in this dividend period.
        /// </summary>
        public BusinessDayAdjustments DateAdjustments { get; }
        
        /// <summary>
        /// For basket underliers, reference to the basket component which is paying dividends in the specified period.
        /// </summary>
        public ReferenceWithMetaBasketConstituent? BasketConstituent { get; }
        
        /// <summary>
        /// Specifies when the dividend will be paid to the receiver of the equity return. Has the meaning as defined in the ISDA 2002 Equity Derivatives Definitions. Is not applicable in the case of a dividend reinvestment election.
        /// </summary>
        public DividendPaymentDate DividendPaymentDate { get; }
        
        /// <summary>
        /// Specifies the dividend valuation dates of the swap.
        /// </summary>
        public AdjustableOrRelativeDate? DividendValuationDate { get; }
    }
    
    /// <summary>
    /// A class describing the conditions governing the payment of dividends to the receiver of the equity return, with the exception of the dividend payout ratio, which is defined for each of the underlying components.
    /// </summary>
    public class DividendReturnTerms : AbstractRosettaModelObject<DividendReturnTerms>
    {
        private static readonly IRosettaMetaData<DividendReturnTerms> metaData = new DividendReturnTermsMeta();
        
        [JsonConstructor]
        public DividendReturnTerms(IEnumerable<DividendPayoutRatio> dividendPayoutRatio, bool? dividendReinvestment, Enums.DividendEntitlement? dividendEntitlement, Enums.DividendAmountType? dividendAmountType, string? performance, Enums.DividendPeriod? firstOrSecondPeriod, Enums.AncillaryRole? extraordinaryDividendsParty, Enums.DividendAmountType? excessDividendAmount, DividendCurrency? dividendCurrency, Enums.NonCashDividendTreatment? nonCashDividendTreatment, Enums.DividendComposition? dividendComposition, bool? specialDividends, bool? materialDividend, IEnumerable<DividendPeriod> dividendPeriod)
        {
            DividendPayoutRatio = dividendPayoutRatio;
            DividendReinvestment = dividendReinvestment;
            DividendEntitlement = dividendEntitlement;
            DividendAmountType = dividendAmountType;
            Performance = performance;
            FirstOrSecondPeriod = firstOrSecondPeriod;
            ExtraordinaryDividendsParty = extraordinaryDividendsParty;
            ExcessDividendAmount = excessDividendAmount;
            DividendCurrency = dividendCurrency;
            NonCashDividendTreatment = nonCashDividendTreatment;
            DividendComposition = dividendComposition;
            SpecialDividends = specialDividends;
            MaterialDividend = materialDividend;
            DividendPeriod = dividendPeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendReturnTerms> MetaData => metaData;
        
        /// <summary>
        /// Specifies the dividend payout ratio associated with each underlier. In FpML 5.10 the payout is positioned at the underlier level, although there is an intent to reconsider this approach and position it at the leg level. This is approach adopted by the CDM.
        /// </summary>
        public IEnumerable<DividendPayoutRatio> DividendPayoutRatio { get; }
        
        /// <summary>
        /// Boolean element that defines whether the dividend will be reinvested or not.
        /// </summary>
        public bool? DividendReinvestment { get; }
        
        /// <summary>
        /// Defines the date on which the receiver of the equity return is entitled to the dividend.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendEntitlement? DividendEntitlement { get; }
        
        /// <summary>
        /// Specifies whether the dividend is paid with respect to the Dividend Period.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendAmountType? DividendAmountType { get; }
        
        /// <summary>
        /// Performance calculation, in accordance with Part 1 Section 12 of the 2018 ISDA CDM Equity Confirmation for Security Equity Swap, Para 75. &apos;Equity Performance&apos;. Cumulative performance is used as a notional multiplier factor on both legs of an Equity Swap.
        /// </summary>
        public string? Performance { get; }
        
        /// <summary>
        /// 2002 ISDA Equity Derivatives Definitions: Dividend Period as either the First Period or the Second Period. | 
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendPeriod? FirstOrSecondPeriod { get; }
        
        /// <summary>
        /// Specifies the party which determines if dividends are extraordinary in relation to normal levels.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? ExtraordinaryDividendsParty { get; }
        
        /// <summary>
        /// Determination of Gross Cash Dividend per Share.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendAmountType? ExcessDividendAmount { get; }
        
        /// <summary>
        /// Specifies the currency in which the dividend will be denominated, e.g. the dividend currency, or a specified currency. This class is not specified as such in FpML, which makes use of the CurrencyAndDeterminationMethod.model to specify such terms.
        /// </summary>
        public DividendCurrency? DividendCurrency { get; }
        
        /// <summary>
        /// Specifies the treatment of Non-Cash Dividends.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NonCashDividendTreatment? NonCashDividendTreatment { get; }
        
        /// <summary>
        /// Specifies how the composition of Dividends is to be determined.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendComposition? DividendComposition { get; }
        
        /// <summary>
        /// Specifies the method according to which special dividends are determined.
        /// </summary>
        public bool? SpecialDividends { get; }
        
        /// <summary>
        /// If present and true, then material non cash dividends are applicable.
        /// </summary>
        public bool? MaterialDividend { get; }
        
        /// <summary>
        /// One to many time bounded dividend payment periods, each with a dividend payment date per period.
        /// </summary>
        public IEnumerable<DividendPeriod> DividendPeriod { get; }
    }
    
    /// <summary>
    /// Information related to dividends and payments.
    /// </summary>
    public class DividendTerms : AbstractRosettaModelObject<DividendTerms>
    {
        private static readonly IRosettaMetaData<DividendTerms> metaData = new DividendTermsMeta();
        
        [JsonConstructor]
        public DividendTerms(DividendPayoutRatio manufacturedIncomeRequirement, Enums.DividendEntitlement? dividendEntitlement, Money? minimumBillingAmount)
        {
            ManufacturedIncomeRequirement = manufacturedIncomeRequirement;
            DividendEntitlement = dividendEntitlement;
            MinimumBillingAmount = minimumBillingAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DividendTerms> MetaData => metaData;
        
        /// <summary>
        /// Specifies the proportion of the value of the dividend on the borrowed shares that the borrower is legally obligated to return to the lender.
        /// </summary>
        public DividendPayoutRatio ManufacturedIncomeRequirement { get; }
        
        /// <summary>
        /// Defines the date on which the receiver of the equity return is entitled to the dividend.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DividendEntitlement? DividendEntitlement { get; }
        
        /// <summary>
        /// daily fee increments accrue until a threshold is crossed, at which point payment becomes due)
        /// </summary>
        public Money? MinimumBillingAmount { get; }
    }
    
    public class Document : AbstractRosettaModelObject<Document>
    {
        private static readonly IRosettaMetaData<Document> metaData = new DocumentMeta();
        
        [JsonConstructor]
        public Document(FinInstrmRptgTxRpt finInstrmRptgTxRpt)
        {
            FinInstrmRptgTxRpt = finInstrmRptgTxRpt;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Document> MetaData => metaData;
        
        public FinInstrmRptgTxRpt FinInstrmRptgTxRpt { get; }
    }
    
    public class DomesticCurrencyIssued : AbstractRosettaModelObject<DomesticCurrencyIssued>
    {
        private static readonly IRosettaMetaData<DomesticCurrencyIssued> metaData = new DomesticCurrencyIssuedMeta();
        
        [JsonConstructor]
        public DomesticCurrencyIssued(bool domesticCurrencyIssued)
        {
            DomesticCurrencyIssuedValue = domesticCurrencyIssued;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<DomesticCurrencyIssued> MetaData => metaData;
        
        /// <summary>
        /// Identifies that the Security must be denominated in the domestic currency of the issuer.
        /// </summary>
        [JsonProperty(PropertyName = "domesticCurrencyIssued")]
        public bool DomesticCurrencyIssuedValue { get; }
    }
    
    /// <summary>
    /// A data to:  define the adjusted dates associated with an early termination provision.
    /// </summary>
    public class EarlyTerminationEvent : AbstractRosettaModelObject<EarlyTerminationEvent>
    {
        private static readonly IRosettaMetaData<EarlyTerminationEvent> metaData = new EarlyTerminationEventMeta();
        
        [JsonConstructor]
        public EarlyTerminationEvent(LocalDate adjustedExerciseDate, LocalDate adjustedEarlyTerminationDate, LocalDate adjustedCashSettlementValuationDate, LocalDate adjustedCashSettlementPaymentDate, LocalDate? adjustedExerciseFeePaymentDate, _MetaFields? meta)
        {
            AdjustedExerciseDate = adjustedExerciseDate;
            AdjustedEarlyTerminationDate = adjustedEarlyTerminationDate;
            AdjustedCashSettlementValuationDate = adjustedCashSettlementValuationDate;
            AdjustedCashSettlementPaymentDate = adjustedCashSettlementPaymentDate;
            AdjustedExerciseFeePaymentDate = adjustedExerciseFeePaymentDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EarlyTerminationEvent> MetaData => metaData;
        
        /// <summary>
        /// The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExerciseDate { get; }
        
        /// <summary>
        /// The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedEarlyTerminationDate { get; }
        
        /// <summary>
        /// The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedCashSettlementValuationDate { get; }
        
        /// <summary>
        /// The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business date convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedCashSettlementPaymentDate { get; }
        
        /// <summary>
        /// The date on which the exercise fee amount is paid. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedExerciseFeePaymentDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A data defining:  an early termination provision for a swap. This early termination is at fair value, i.e. on termination the fair value of the product must be settled between the parties.
    /// </summary>
    public class EarlyTerminationProvision : AbstractRosettaModelObject<EarlyTerminationProvision>
    {
        private static readonly IRosettaMetaData<EarlyTerminationProvision> metaData = new EarlyTerminationProvisionMeta();
        
        [JsonConstructor]
        public EarlyTerminationProvision(MandatoryEarlyTermination? mandatoryEarlyTermination, Period? mandatoryEarlyTerminationDateTenor, OptionalEarlyTermination? optionalEarlyTermination, ExercisePeriod? optionalEarlyTerminationParameters, _MetaFields? meta)
        {
            MandatoryEarlyTermination = mandatoryEarlyTermination;
            MandatoryEarlyTerminationDateTenor = mandatoryEarlyTerminationDateTenor;
            OptionalEarlyTermination = optionalEarlyTermination;
            OptionalEarlyTerminationParameters = optionalEarlyTerminationParameters;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EarlyTerminationProvision> MetaData => metaData;
        
        /// <summary>
        /// A mandatory early termination provision to terminate the swap at fair value.
        /// </summary>
        public MandatoryEarlyTermination? MandatoryEarlyTermination { get; }
        
        /// <summary>
        /// Period after trade date of the mandatory early termination date.
        /// </summary>
        public Period? MandatoryEarlyTerminationDateTenor { get; }
        
        /// <summary>
        /// An option for either or both parties to terminate the swap at fair value.
        /// </summary>
        public OptionalEarlyTermination? OptionalEarlyTermination { get; }
        
        /// <summary>
        /// Definition of the first early termination date and the frequency of the termination dates subsequent to that. American exercise is defined by having a frequency of one day.
        /// </summary>
        public ExercisePeriod? OptionalEarlyTerminationParameters { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    ///  This class represents the full set of price-forming features associated with a contractual product: the payout component, the notional/quantity, the effective and termination date and the date adjustment provisions when applying uniformily across the payout components. This class also includes the legal provisions which have valuation implications: cancelable provision, extendible provision, early termination provision and extraordinary events specification.
    /// </summary>
    public class EconomicTerms : AbstractRosettaModelObject<EconomicTerms>
    {
        private static readonly IRosettaMetaData<EconomicTerms> metaData = new EconomicTermsMeta();
        
        [JsonConstructor]
        public EconomicTerms(AdjustableOrRelativeDate? effectiveDate, AdjustableOrRelativeDate? terminationDate, BusinessDayAdjustments? dateAdjustments, IEnumerable<Payout> payout, TerminationProvision? terminationProvision, CalculationAgent? calculationAgent, bool? nonStandardisedTerms, Collateral? collateral)
        {
            EffectiveDate = effectiveDate;
            TerminationDate = terminationDate;
            DateAdjustments = dateAdjustments;
            Payout = payout;
            TerminationProvision = terminationProvision;
            CalculationAgent = calculationAgent;
            NonStandardisedTerms = nonStandardisedTerms;
            Collateral = collateral;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EconomicTerms> MetaData => metaData;
        
        /// <summary>
        /// The first day of the terms of the trade. This day may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        public AdjustableOrRelativeDate? EffectiveDate { get; }
        
        /// <summary>
        /// The last day of the terms of the trade. This date may be subject to adjustments in accordance with the business day convention. It can also be specified in relation to another scheduled date (e.g. the last payment date).
        /// </summary>
        public AdjustableOrRelativeDate? TerminationDate { get; }
        
        /// <summary>
        /// The business day adjustment convention when it applies across all the payout components. This specification of the business day convention and financial business centers is used for adjusting any calculation period date if it would otherwise fall on a day that is not a business day in the specified business center.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
        
        /// <summary>
        /// The payout specifies the future cashflow computation methodology which characterizes a financial product.
        /// </summary>
        public IEnumerable<Payout> Payout { get; }
        
        /// <summary>
        /// Contains optional provisions pertaining to the termination characteristics of a contract.
        /// </summary>
        public TerminationProvision? TerminationProvision { get; }
        
        /// <summary>
        /// The ISDA calculation agent responsible for performing duties as defined in the applicable product definitions.
        /// </summary>
        public CalculationAgent? CalculationAgent { get; }
        
        /// <summary>
        /// Specifies, when boolean value is True, that additional economic terms exist that have not been included in the product representation.
        /// </summary>
        public bool? NonStandardisedTerms { get; }
        
        /// <summary>
        /// Represents the collateral obligations of a party.
        /// </summary>
        public Collateral? Collateral { get; }
    }
    
    /// <summary>
    /// A class to specify the party elective amounts which can be used for the purpose of specifying elections such as the ISDA CSA Threshold and Minimum Transfer Amount.
    /// </summary>
    public class ElectiveAmountElection : AbstractRosettaModelObject<ElectiveAmountElection>
    {
        private static readonly IRosettaMetaData<ElectiveAmountElection> metaData = new ElectiveAmountElectionMeta();
        
        [JsonConstructor]
        public ElectiveAmountElection(Enums.CounterpartyRole party, Enums.ElectiveAmount? electiveAmount, Money? amount, string? customElection)
        {
            Party = party;
            ElectiveAmount = electiveAmount;
            Amount = amount;
            CustomElection = customElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ElectiveAmountElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// Specifies an enumerated election to express the elective amount.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ElectiveAmount? ElectiveAmount { get; }
        
        /// <summary>
        /// The elective amount when expressed as a currency amount. The associated PartyElectiveAmount_amount data rule enforces that the currency amount is actually greater than 0.
        /// </summary>
        public Money? Amount { get; }
        
        /// <summary>
        /// The elective amount when expressed as a custom election by the party.
        /// </summary>
        public string? CustomElection { get; }
    }
    
    /// <summary>
    /// Query to check against an EligibleCollateralSpecification
    /// </summary>
    public class EligibilityQuery : AbstractRosettaModelObject<EligibilityQuery>
    {
        private static readonly IRosettaMetaData<EligibilityQuery> metaData = new EligibilityQueryMeta();
        
        [JsonConstructor]
        public EligibilityQuery(decimal maturity, AssetType collateralAssetType, Enums.ISOCountryCode assetCountryOfOrigin, Enums.CurrencyCode denominatedCurrency, AgencyRatingCriteria agencyRating, CollateralIssuerType issuerType, LegalEntity issuerName)
        {
            Maturity = maturity;
            CollateralAssetType = collateralAssetType;
            AssetCountryOfOrigin = assetCountryOfOrigin;
            DenominatedCurrency = denominatedCurrency;
            AgencyRating = agencyRating;
            IssuerType = issuerType;
            IssuerName = issuerName;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibilityQuery> MetaData => metaData;
        
        /// <summary>
        /// Maturity in years
        /// </summary>
        public decimal Maturity { get; }
        
        /// <summary>
        /// The asset product type.
        /// </summary>
        public AssetType CollateralAssetType { get; }
        
        /// <summary>
        /// The asset country of origin.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ISOCountryCode AssetCountryOfOrigin { get; }
        
        /// <summary>
        /// The underlying asset denominated currency.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CurrencyCode DenominatedCurrency { get; }
        
        /// <summary>
        /// The agency rating based on default risk and creditors claim in event of default associated with specific instrument.
        /// </summary>
        public AgencyRatingCriteria AgencyRating { get; }
        
        /// <summary>
        /// Represents a filter based on the type of entity issuing the asset.
        /// </summary>
        public CollateralIssuerType IssuerType { get; }
        
        /// <summary>
        /// Specifies the issuing entity name or LEI.
        /// </summary>
        public LegalEntity IssuerName { get; }
    }
    
    /// <summary>
    /// Specifies the conditions under which a party and its custodian(s) are entitled to hold collateral.
    /// </summary>
    public class EligibilityToHoldCollateral : AbstractRosettaModelObject<EligibilityToHoldCollateral>
    {
        private static readonly IRosettaMetaData<EligibilityToHoldCollateral> metaData = new EligibilityToHoldCollateralMeta();
        
        [JsonConstructor]
        public EligibilityToHoldCollateral(bool custodianEligibility, LegalEntity? initialCustodian, EligibilityToHoldCollateralCriteria? criteria, IEnumerable<FieldWithMetaString> eligibleCountry, string? custodianCondition)
        {
            CustodianEligibility = custodianEligibility;
            InitialCustodian = initialCustodian;
            Criteria = criteria;
            EligibleCountry = eligibleCountry;
            CustodianCondition = custodianCondition;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibilityToHoldCollateral> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether the party&apos;s custodian is eligible to hold the other party&apos;s posted collateral. If &apos;True&apos; then the custodian is eligible to hold the Posted Collateral given that the specified criteria are met.
        /// </summary>
        public bool CustodianEligibility { get; }
        
        /// <summary>
        /// Election to specify the initial custodian.
        /// </summary>
        public LegalEntity? InitialCustodian { get; }
        
        /// <summary>
        /// A logical container to hold a defined set of related data. In this case the collation of criteria required by the party and its custodian to Hold the other party&apos;s Posted Collateral.
        /// </summary>
        public EligibilityToHoldCollateralCriteria? Criteria { get; }
        
        /// <summary>
        /// The restrictions that might be required by a party and its custodian in terms of country(ies) where the other party&apos;s collateral can be held.
        /// </summary>
        public IEnumerable<FieldWithMetaString> EligibleCountry { get; }
        
        /// <summary>
        /// Specifies any additional conditions relevant to the Custodian of the respective parties as set out in the Holding and Using Posted Collateral clause.
        /// </summary>
        public string? CustodianCondition { get; }
    }
    
    /// <summary>
    /// Defines a set of Criteria required by the party and its custodian to hold the other party&apos;s Posted Collateral.
    /// </summary>
    public class EligibilityToHoldCollateralCriteria : AbstractRosettaModelObject<EligibilityToHoldCollateralCriteria>
    {
        private static readonly IRosettaMetaData<EligibilityToHoldCollateralCriteria> metaData = new EligibilityToHoldCollateralCriteriaMeta();
        
        [JsonConstructor]
        public EligibilityToHoldCollateralCriteria(AllEligibilityToHoldCollateralCriteria? allEligibilityToHoldCollateralCriteria, AnyEligibilityToHoldCollateralCriteria? anyEligibilityToHoldCollateralCriteria, RatingAgencyValue? ratingAgencyValue, AmountOfNetCapital? amountOfNetCapital)
        {
            AllEligibilityToHoldCollateralCriteria = allEligibilityToHoldCollateralCriteria;
            AnyEligibilityToHoldCollateralCriteria = anyEligibilityToHoldCollateralCriteria;
            RatingAgencyValue = ratingAgencyValue;
            AmountOfNetCapital = amountOfNetCapital;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibilityToHoldCollateralCriteria> MetaData => metaData;
        
        /// <summary>
        /// Enables two or more Criteria to be combined using AND logic.
        /// </summary>
        public AllEligibilityToHoldCollateralCriteria? AllEligibilityToHoldCollateralCriteria { get; }
        
        /// <summary>
        /// Enables two or more Criteria to be combined using OR logic.
        /// </summary>
        public AnyEligibilityToHoldCollateralCriteria? AnyEligibilityToHoldCollateralCriteria { get; }
        
        /// <summary>
        /// A logical container designed to define a combination of Ratings based attributes. In this case, the minimum Rating Value, associated Rating Agency and Rating Type for the Party/Custodian to be entitled to hold Posted Collateral.
        /// </summary>
        public RatingAgencyValue? RatingAgencyValue { get; }
        
        /// <summary>
        /// The minimum amount of net capital to be entitled to hold Posted Collateral.
        /// </summary>
        public AmountOfNetCapital? AmountOfNetCapital { get; }
    }
    
    /// <summary>
    /// Represents a set of criteria used to specify eligible collateral.
    /// </summary>
    public class EligibleCollateralCriteria : AbstractRosettaModelObject<EligibleCollateralCriteria>, ICollateralCriteriaBase
    {
        private static readonly IRosettaMetaData<EligibleCollateralCriteria> metaData = new EligibleCollateralCriteriaMeta();
        
        [JsonConstructor]
        public EligibleCollateralCriteria(CollateralCriteria collateralCriteria, IEnumerable<Enums.CounterpartyRole> appliesTo, Enums.CollateralMarginType? restrictTo, Enums.RatingPriorityResolution? ratingPriorityResolution, CollateralTreatment treatment)
        {
            CollateralCriteria = collateralCriteria;
            AppliesTo = appliesTo;
            RestrictTo = restrictTo;
            RatingPriorityResolution = ratingPriorityResolution;
            Treatment = treatment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibleCollateralCriteria> MetaData => metaData;
        
        /// <summary>
        /// The specific criteria in an Eligible Collateral Schedule. This is a mandatory attribute of an ECS so an override is required to enforce the cardinality.
        /// </summary>
        public CollateralCriteria CollateralCriteria { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> AppliesTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CollateralMarginType? RestrictTo { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatingPriorityResolution? RatingPriorityResolution { get; }
        
        /// <summary>
        /// Identifies the treatment of specified collateral, e.g., haircuts,holding limits or exclusions.
        /// </summary>
        public CollateralTreatment Treatment { get; }
    }
    
    /// <summary>
    /// Specifies the collateral posting obligations for the security provider party(ies).
    /// </summary>
    public class EligibleCollateralElection : AbstractRosettaModelObject<EligibleCollateralElection>, IPostingObligationsElection
    {
        private static readonly IRosettaMetaData<EligibleCollateralElection> metaData = new EligibleCollateralElectionMeta();
        
        [JsonConstructor]
        public EligibleCollateralElection(Enums.CounterpartyRole party, bool asPermitted, IEnumerable<EligibleCollateralCriteria> eligibleCollateral, string? excludedCollateral, string? additionalLanguage, string otherEligibleSupport)
        {
            Party = party;
            AsPermitted = asPermitted;
            EligibleCollateral = eligibleCollateral;
            ExcludedCollateral = excludedCollateral;
            AdditionalLanguage = additionalLanguage;
            OtherEligibleSupport = otherEligibleSupport;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibleCollateralElection> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <inheritdoc/>
        public bool AsPermitted { get; }
        
        /// <inheritdoc/>
        public IEnumerable<EligibleCollateralCriteria> EligibleCollateral { get; }
        
        /// <inheritdoc/>
        public string? ExcludedCollateral { get; }
        
        /// <inheritdoc/>
        public string? AdditionalLanguage { get; }
        
        /// <summary>
        /// Specifies the Other Eligible Support conditions. If not specified, this election is deemed as not applicable.
        /// </summary>
        public string OtherEligibleSupport { get; }
    }
    
    /// <summary>
    /// Represents a set of criteria used to specify eligible collateral.
    /// </summary>
    public class EligibleCollateralSpecification : AbstractRosettaModelObject<EligibleCollateralSpecification>
    {
        private static readonly IRosettaMetaData<EligibleCollateralSpecification> metaData = new EligibleCollateralSpecificationMeta();
        
        [JsonConstructor]
        public EligibleCollateralSpecification(IEnumerable<Identifier> identifier, IEnumerable<Party> party, IEnumerable<Counterparty> counterparty, IEnumerable<EligibleCollateralCriteria> criteria, IEnumerable<PartyRole> partyRole, _MetaFields? meta)
        {
            Identifier = identifier;
            Party = party;
            Counterparty = counterparty;
            Criteria = criteria;
            PartyRole = partyRole;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibleCollateralSpecification> MetaData => metaData;
        
        /// <summary>
        /// Specifies the identifier(s) to uniquely identify eligible collateral or a set of eligible collateral, such as a schedule or equivalant for an identity issuer.
        /// </summary>
        public IEnumerable<Identifier> Identifier { get; }
        
        /// <summary>
        /// The parties associated with the specification.
        /// </summary>
        public IEnumerable<Party> Party { get; }
        
        /// <summary>
        /// Specification of the roles of the counterparties to the specification.
        /// </summary>
        public IEnumerable<Counterparty> Counterparty { get; }
        
        /// <summary>
        /// Represents a set of criteria used to specify eligible collateral.
        /// </summary>
        public IEnumerable<EligibleCollateralCriteria> Criteria { get; }
        
        /// <summary>
        /// Specifies the role(s) that each of the party(s) is playing in the context of the specification, eg Payor or Receiver.
        /// </summary>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies the collateral posting obligations of the security provider or security providers as specified in the corresponding agreement
    /// </summary>
    public class EligibleCreditSupport : AbstractRosettaModelObject<EligibleCreditSupport>
    {
        private static readonly IRosettaMetaData<EligibleCreditSupport> metaData = new EligibleCreditSupportMeta();
        
        [JsonConstructor]
        public EligibleCreditSupport(IEnumerable<EligibleCollateralElection> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EligibleCreditSupport> MetaData => metaData;
        
        /// <summary>
        /// The specification of the collateral posting obligations for the security provider party(ies)
        /// </summary>
        public IEnumerable<EligibleCollateralElection> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify Enforcement Events specific to Security Agreements.
    /// </summary>
    public class EnforcementEvent : AbstractRosettaModelObject<EnforcementEvent>
    {
        private static readonly IRosettaMetaData<EnforcementEvent> metaData = new EnforcementEventMeta();
        
        [JsonConstructor]
        public EnforcementEvent(bool earlyTerminationDate, bool? failureToPay)
        {
            EarlyTerminationDate = earlyTerminationDate;
            FailureToPay = failureToPay;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EnforcementEvent> MetaData => metaData;
        
        /// <summary>
        /// The early termination election.
        /// </summary>
        public bool EarlyTerminationDate { get; }
        
        /// <summary>
        /// The failure to pay election.
        /// </summary>
        public bool? FailureToPay { get; }
    }
    
    /// <summary>
    /// Transaction AdditionalTerms that apply to Equity asset class.
    /// </summary>
    public class EquityAdditionalTerms : AbstractRosettaModelObject<EquityAdditionalTerms>
    {
        private static readonly IRosettaMetaData<EquityAdditionalTerms> metaData = new EquityAdditionalTermsMeta();
        
        [JsonConstructor]
        public EquityAdditionalTerms(ExtraordinaryEvents? extraordinaryEvents, IEnumerable<DeterminationRolesAndTerms> determinationTerms, UnderlierSubstitutionProvision? substitutionProvision)
        {
            ExtraordinaryEvents = extraordinaryEvents;
            DeterminationTerms = determinationTerms;
            SubstitutionProvision = substitutionProvision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityAdditionalTerms> MetaData => metaData;
        
        public ExtraordinaryEvents? ExtraordinaryEvents { get; }
        
        public IEnumerable<DeterminationRolesAndTerms> DeterminationTerms { get; }
        
        public UnderlierSubstitutionProvision? SubstitutionProvision { get; }
    }
    
    /// <summary>
    /// A class for defining the merger events and their treatment.
    /// </summary>
    public class EquityCorporateEvents : AbstractRosettaModelObject<EquityCorporateEvents>
    {
        private static readonly IRosettaMetaData<EquityCorporateEvents> metaData = new EquityCorporateEventsMeta();
        
        [JsonConstructor]
        public EquityCorporateEvents(Enums.ShareExtraordinaryEvent shareForShare, Enums.ShareExtraordinaryEvent shareForOther, Enums.ShareExtraordinaryEvent shareForCombined)
        {
            ShareForShare = shareForShare;
            ShareForOther = shareForOther;
            ShareForCombined = shareForCombined;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityCorporateEvents> MetaData => metaData;
        
        /// <summary>
        /// Shall occur if a Merger Event occurs and the consideration for the relevant Security consists solely of Combined Consideration.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ShareExtraordinaryEvent ShareForShare { get; }
        
        /// <summary>
        /// Shall occur if a Merger Event occurs and the consideration for the relevant Security consists solely of Other Consideration.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ShareExtraordinaryEvent ShareForOther { get; }
        
        /// <summary>
        /// Shall occur if a Merger Event occurs and the consideration for the relevant Security consists solely of Combined Consideration.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ShareExtraordinaryEvent ShareForCombined { get; }
    }
    
    /// <summary>
    /// Specification of an index based on equity securities, e.g. the S&amp;P 500..
    /// </summary>
    public class EquityIndex : AbstractRosettaModelObject<EquityIndex>, IIndexBase
    {
        private static readonly IRosettaMetaData<EquityIndex> metaData = new EquityIndexMeta();
        
        [JsonConstructor]
        public EquityIndex(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, FieldWithMetaString? name, LegalEntity? provider, Enums.AssetClass? assetClass, Enums.EquityIndex? equityIndex)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            Name = name;
            Provider = provider;
            AssetClass = assetClass;
            EquityIndexValue = equityIndex;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityIndex> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Name { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Provider { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetClass? AssetClass { get; }
        
        /// <summary>
        /// The equity index value speciied from the EquityIndexEnum.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "equityIndex")]
        public Enums.EquityIndex? EquityIndexValue { get; }
    }
    
    /// <summary>
    /// Specification for General Terms and Elections of an Equity Master Confirmation that is applicable across multiple Equity confirmations and is referenced by each of these confirmations, an example of which being the 2018 ISDA CDM Equity Confirmation for Security Equity Swap.
    /// </summary>
    public class EquityMasterConfirmation : AbstractRosettaModelObject<EquityMasterConfirmation>, IEquityMasterConfirmation, IMasterConfirmationBase
    {
        private static readonly IRosettaMetaData<EquityMasterConfirmation> metaData = new EquityMasterConfirmationMeta();
        
        [JsonConstructor]
        public EquityMasterConfirmation()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityMasterConfirmation> MetaData => metaData;
        
    }
    
    /// <summary>
    /// Specification for the General Terms and Relationship Supplement Elections as provided in the 2018 ISDA CDM Equity Confirmation for Security Equity Swap.
    /// </summary>
    public class EquitySwapMasterConfirmation2018 : AbstractRosettaModelObject<EquitySwapMasterConfirmation2018>, IEquityMasterConfirmation
    {
        private static readonly IRosettaMetaData<EquitySwapMasterConfirmation2018> metaData = new EquitySwapMasterConfirmation2018Meta();
        
        [JsonConstructor]
        public EquitySwapMasterConfirmation2018(Enums.ReturnType typeOfSwapElection, PriceReturnTerms pricingMethodElection, Enums.InterpolationMethod linearInterpolationElection, SettlementTerms settlementTerms, ValuationDates valuationDates, PaymentDates equityCashSettlementDates)
        {
            TypeOfSwapElection = typeOfSwapElection;
            PricingMethodElection = pricingMethodElection;
            LinearInterpolationElection = linearInterpolationElection;
            SettlementTerms = settlementTerms;
            ValuationDates = valuationDates;
            EquityCashSettlementDates = equityCashSettlementDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquitySwapMasterConfirmation2018> MetaData => metaData;
        
        /// <summary>
        /// Per Part 1 Section 4, &apos;Dividend Obligations&apos;, of the 2018 ISDA CDM Equity Confirmation, Para 4.2 &apos;Dividend Returns&apos;.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ReturnType TypeOfSwapElection { get; }
        
        /// <summary>
        /// Per Part 1 Section 5, &apos;Pricing&apos;, of the 2018 ISDA CDM Equity Confirmation, Para 5.1.
        /// </summary>
        public PriceReturnTerms PricingMethodElection { get; }
        
        /// <summary>
        /// Per Part 1 Section 3, &apos;Floating Obligations&apos;, of the 2018 ISDA CDM Equity Confirmation. Para 3.3.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InterpolationMethod LinearInterpolationElection { get; }
        
        /// <summary>
        /// Per Part 1 Section 8, &apos;Settlement&apos;, of the 2018 ISDA CDM Equity Confirmation for Security Equity Swap.
        /// </summary>
        public SettlementTerms SettlementTerms { get; }
        
        /// <summary>
        /// The parameters used to generate the &apos;Equity Valuation Dates&apos; schedule, including the Effective Date and Termination Date for the Swap.
        /// </summary>
        public ValuationDates ValuationDates { get; }
        
        /// <summary>
        /// The parameters used to generate the payment date schedule, relative to the equityCalculationPeriod. Per Part 1 Section 12, &apos;Definitions&apos;, of the 2018 ISDA CDM Equity Confirmation. Para 73.
        /// </summary>
        public PaymentDates EquityCashSettlementDates { get; }
    }
    
    public class EquityType : AbstractRosettaModelObject<EquityType>
    {
        private static readonly IRosettaMetaData<EquityType> metaData = new EquityTypeMeta();
        
        [JsonConstructor]
        public EquityType(Enums.EquityType? equityType, Enums.DepositaryReceiptType? depositaryReceipt)
        {
            EquityTypeValue = equityType;
            DepositaryReceipt = depositaryReceipt;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityType> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "equityType")]
        public Enums.EquityType? EquityTypeValue { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DepositaryReceiptType? DepositaryReceipt { get; }
    }
    
    public class EquityUnderlierProvisions : AbstractRosettaModelObject<EquityUnderlierProvisions>
    {
        private static readonly IRosettaMetaData<EquityUnderlierProvisions> metaData = new EquityUnderlierProvisionsMeta();
        
        [JsonConstructor]
        public EquityUnderlierProvisions(bool? multipleExchangeIndexAnnexFallback, bool? componentSecurityIndexAnnexFallback, FieldWithMetaString? localJurisdiction, FieldWithMetaString? relevantJurisdiction)
        {
            MultipleExchangeIndexAnnexFallback = multipleExchangeIndexAnnexFallback;
            ComponentSecurityIndexAnnexFallback = componentSecurityIndexAnnexFallback;
            LocalJurisdiction = localJurisdiction;
            RelevantJurisdiction = relevantJurisdiction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EquityUnderlierProvisions> MetaData => metaData;
        
        /// <summary>
        /// For an index option or swap transaction, a flag to indicate whether a relevant Multiple Exchange Index Annex is applicable to the transaction. This annex defines additional provisions which are applicable where an index is comprised of component securities that are traded on multiple exchanges.
        /// </summary>
        public bool? MultipleExchangeIndexAnnexFallback { get; }
        
        /// <summary>
        /// For an index option or swap transaction, a flag to indicate whether a relevant Component Security Index Annex is applicable to the transaction.
        /// </summary>
        public bool? ComponentSecurityIndexAnnexFallback { get; }
        
        /// <summary>
        /// The ISO 3166 standard code for the country within which the postal address is located.
        /// </summary>
        public FieldWithMetaString? LocalJurisdiction { get; }
        
        /// <summary>
        /// The ISO 3166 standard code for the country within which the postal address is located.
        /// </summary>
        public FieldWithMetaString? RelevantJurisdiction { get; }
    }
    
    /// <summary>
    /// Refers to the segregation deposit procedure parties may want to commmit into during the time a Disruption Event is effective
    /// </summary>
    public class EscrowArrangement : AbstractRosettaModelObject<EscrowArrangement>
    {
        private static readonly IRosettaMetaData<EscrowArrangement> metaData = new EscrowArrangementMeta();
        
        [JsonConstructor]
        public EscrowArrangement(bool escrowArrangementIsApplicable, ValuationPostponement? maximumDaysOfDisruption, Clause? bespokeEscrowArrangements)
        {
            EscrowArrangementIsApplicable = escrowArrangementIsApplicable;
            MaximumDaysOfDisruption = maximumDaysOfDisruption;
            BespokeEscrowArrangements = bespokeEscrowArrangements;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EscrowArrangement> MetaData => metaData;
        
        public bool EscrowArrangementIsApplicable { get; }
        
        public ValuationPostponement? MaximumDaysOfDisruption { get; }
        
        public Clause? BespokeEscrowArrangements { get; }
    }
    
    /// <summary>
    /// Defines the currency referenced as such in any terms related to FX Disruption Events
    /// </summary>
    public class EventCurrency : AbstractRosettaModelObject<EventCurrency>
    {
        private static readonly IRosettaMetaData<EventCurrency> metaData = new EventCurrencyMeta();
        
        [JsonConstructor]
        public EventCurrency(FieldWithMetaString eventCurrency, Quantity? eventCurrentAmount, IEnumerable<BuyerSeller> eventCurrencyBuyerSeller)
        {
            EventCurrencyValue = eventCurrency;
            EventCurrentAmount = eventCurrentAmount;
            EventCurrencyBuyerSeller = eventCurrencyBuyerSeller;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EventCurrency> MetaData => metaData;
        
        /// <summary>
        /// Defines the currency referenced as such in any terms related to FX Disruption Events
        /// </summary>
        [JsonProperty(PropertyName = "eventCurrency")]
        public FieldWithMetaString EventCurrencyValue { get; }
        
        /// <summary>
        /// Defines the Event Currency Amount to be exchanged on the Settlement Date.
        /// </summary>
        public Quantity? EventCurrentAmount { get; }
        
        /// <summary>
        /// Unless otherwised specified, the Buyer is the party to which the Event Currency Amount is owed on the Settlement Date and the Seller is the party which owes the Event Currency Amount on the Settlement Date.
        /// </summary>
        public IEnumerable<BuyerSeller> EventCurrencyBuyerSeller { get; }
    }
    
    /// <summary>
    /// Specifies instructions to create a BusinessEvent.
    /// </summary>
    public class EventInstruction : AbstractRosettaModelObject<EventInstruction>, IEventInstruction
    {
        private static readonly IRosettaMetaData<EventInstruction> metaData = new EventInstructionMeta();
        
        [JsonConstructor]
        public EventInstruction(Enums.EventIntent? intent, Enums.CorporateActionType? corporateActionIntent, LocalDate? eventDate, LocalDate? effectiveDate, IdentifiedList? packageInformation, IEnumerable<Instruction> instruction)
        {
            Intent = intent;
            CorporateActionIntent = corporateActionIntent;
            EventDate = eventDate;
            EffectiveDate = effectiveDate;
            PackageInformation = packageInformation;
            Instruction = instruction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EventInstruction> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.EventIntent? Intent { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CorporateActionType? CorporateActionIntent { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EventDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <inheritdoc/>
        public IdentifiedList? PackageInformation { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Instruction> Instruction { get; }
    }
    
    /// <summary>
    /// A class to represent the various set of timestamps that can be associated with lifecycle events, as a collection of [dateTime, qualifier].
    /// </summary>
    public class EventTimestamp : AbstractRosettaModelObject<EventTimestamp>
    {
        private static readonly IRosettaMetaData<EventTimestamp> metaData = new EventTimestampMeta();
        
        [JsonConstructor]
        public EventTimestamp(ZonedDateTime dateTime, Enums.EventTimestampQualification qualification)
        {
            DateTime = dateTime;
            Qualification = qualification;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EventTimestamp> MetaData => metaData;
        
        /// <summary>
        /// The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.
        /// </summary>
        public ZonedDateTime DateTime { get; }
        
        /// <summary>
        /// The timestamp qualifier is specified through an enumeration because the experience of integrating the DTCC and CME data representations suggests that a wide set of timestamps are currently utilized among service providers, while there is not at present an objective set of criteria that could help suggest a defined set of timestamps as part of the CDM. At some future point, one possible baseline could be developed from the review of the set of timestamps specified across regulatory regimes and regulations (incl. regulations such as high frequency trading). Also, the integration with a further set of implementations and the specification of business workflows such as clearing as part of the CDM development should help confirm the implementation approach in this respect.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.EventTimestampQualification Qualification { get; }
    }
    
    /// <summary>
    /// Specifies a transaction which automatically extends for a specified timeframe until the exercise of an embedded option.
    /// </summary>
    public class EvergreenProvision : AbstractRosettaModelObject<EvergreenProvision>
    {
        private static readonly IRosettaMetaData<EvergreenProvision> metaData = new EvergreenProvisionMeta();
        
        [JsonConstructor]
        public EvergreenProvision(PartyRole? singlePartyOption, RelativeDateOffset noticePeriod, RelativeDateOffset? noticeDeadlinePeriod, ZonedDateTime? noticeDeadlineDateTime, AdjustableRelativeOrPeriodicDates extensionFrequency, Price? finalPeriodFeeAdjustment)
        {
            SinglePartyOption = singlePartyOption;
            NoticePeriod = noticePeriod;
            NoticeDeadlinePeriod = noticeDeadlinePeriod;
            NoticeDeadlineDateTime = noticeDeadlineDateTime;
            ExtensionFrequency = extensionFrequency;
            FinalPeriodFeeAdjustment = finalPeriodFeeAdjustment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<EvergreenProvision> MetaData => metaData;
        
        /// <summary>
        /// If evergreen termination is not available to both parties then this component specifies the buyer and seller of the option.
        /// </summary>
        public PartyRole? SinglePartyOption { get; }
        
        /// <summary>
        /// The length of each evergreen extension period relative to the effective date of the preceding contract.
        /// </summary>
        public RelativeDateOffset NoticePeriod { get; }
        
        /// <summary>
        /// Defines the minimum period before an evergreen is scheduled to terminate that notice can be given that it will terminate beyond the scheduled termination date.
        /// </summary>
        public RelativeDateOffset? NoticeDeadlinePeriod { get; }
        
        /// <summary>
        /// A specific date and time for the notice deadline
        /// </summary>
        public ZonedDateTime? NoticeDeadlineDateTime { get; }
        
        /// <summary>
        /// The frequency with which the evergreen contract will be extended if notice is not given.
        /// </summary>
        public AdjustableRelativeOrPeriodicDates ExtensionFrequency { get; }
        
        /// <summary>
        /// An optional adjustment to the rate for the last period of the evergreen i.e. the period from when notice is given to stop rolling the contract through to the termination date.
        /// </summary>
        public Price? FinalPeriodFeeAdjustment { get; }
    }
    
    /// <summary>
    /// Description of the relevant derivative transactions excluded from the calculation of exposure.
    /// </summary>
    public class ExcludedProducts : AbstractRosettaModelObject<ExcludedProducts>
    {
        private static readonly IRosettaMetaData<ExcludedProducts> metaData = new ExcludedProductsMeta();
        
        [JsonConstructor]
        public ExcludedProducts(IEnumerable<Enums.ExposureScopeProduct> product, IEnumerable<Enums.BusinessCenter> branch, bool excluded)
        {
            Product = product;
            Branch = branch;
            Excluded = excluded;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExcludedProducts> MetaData => metaData;
        
        /// <summary>
        /// Description of the relevant derivative transactions excluded from the calculation of exposure.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.ExposureScopeProduct> Product { get; }
        
        /// <summary>
        /// Description of the specific branch entered into by the relevant party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.BusinessCenter> Branch { get; }
        
        /// <summary>
        /// A flag to indicate whether transactions entered into by a specific branch with respect to the relevant party are excluded; set to True if excluded, false if included.
        /// </summary>
        public bool Excluded { get; }
    }
    
    public class ExctgPrsn : AbstractRosettaModelObject<ExctgPrsn>
    {
        private static readonly IRosettaMetaData<ExctgPrsn> metaData = new ExctgPrsnMeta();
        
        [JsonConstructor]
        public ExctgPrsn(Prsn prsn)
        {
            Prsn = prsn;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExctgPrsn> MetaData => metaData;
        
        public Prsn Prsn { get; }
    }
    
    /// <summary>
    /// Defines specific attributes that relate to trade executions.
    /// </summary>
    public class ExecutionDetails : AbstractRosettaModelObject<ExecutionDetails>
    {
        private static readonly IRosettaMetaData<ExecutionDetails> metaData = new ExecutionDetailsMeta();
        
        [JsonConstructor]
        public ExecutionDetails(Enums.ExecutionType executionType, LegalEntity? executionVenue, IdentifiedList? packageReference, _MetaFields? meta)
        {
            ExecutionType = executionType;
            ExecutionVenue = executionVenue;
            PackageReference = packageReference;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExecutionDetails> MetaData => metaData;
        
        /// <summary>
        /// Identifies the type of execution, e.g. via voice, electronically...
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ExecutionType ExecutionType { get; }
        
        /// <summary>
        /// Represents the venue on which a trade was executed.
        /// </summary>
        public LegalEntity? ExecutionVenue { get; }
        
        /// <summary>
        /// A reference to the package linking the trade with other trades, in case the trade was executed as part of a package (hence this attribute is optional).
        /// </summary>
        public IdentifiedList? PackageReference { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies instructions for execution of a transaction, consisting of a product, price, quantity, parties, trade identifier, execution details, and settlement terms.
    /// </summary>
    public class ExecutionInstruction : AbstractRosettaModelObject<ExecutionInstruction>
    {
        private static readonly IRosettaMetaData<ExecutionInstruction> metaData = new ExecutionInstructionMeta();
        
        [JsonConstructor]
        public ExecutionInstruction(NonTransferableProduct product, IEnumerable<PriceQuantity> priceQuantity, IEnumerable<Counterparty> counterparty, IEnumerable<AncillaryParty> ancillaryParty, IEnumerable<Party> parties, IEnumerable<PartyRole> partyRoles, ExecutionDetails executionDetails, FieldWithMetaLocalDate tradeDate, FieldWithMetaTimeZone? tradeTime, IEnumerable<TradeIdentifier> tradeIdentifier, Collateral? collateral, Identifier? lotIdentifier)
        {
            Product = product;
            PriceQuantity = priceQuantity;
            Counterparty = counterparty;
            AncillaryParty = ancillaryParty;
            Parties = parties;
            PartyRoles = partyRoles;
            ExecutionDetails = executionDetails;
            TradeDate = tradeDate;
            TradeTime = tradeTime;
            TradeIdentifier = tradeIdentifier;
            Collateral = collateral;
            LotIdentifier = lotIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExecutionInstruction> MetaData => metaData;
        
        /// <summary>
        /// Defines the financial product to be executed and contract formed.
        /// </summary>
        public NonTransferableProduct Product { get; }
        
        /// <summary>
        /// Defines the prices (e.g. spread, equity price, FX rate), quantities (e.g. currency amount, no. shares) and settlement terms (e.g. initial fee, broker fee, up-front cds payment or option premium settlement) associated with the constituents of the transacted product.
        /// </summary>
        public IEnumerable<PriceQuantity> PriceQuantity { get; }
        
        /// <summary>
        /// Maps two defined parties to counterparty enums for the transacted product.
        /// </summary>
        public IEnumerable<Counterparty> Counterparty { get; }
        
        /// <summary>
        /// Maps any ancillary parties, e.g. parties involved in the transaction that are not one of the two principal parties.
        /// </summary>
        public IEnumerable<AncillaryParty> AncillaryParty { get; }
        
        /// <summary>
        /// Defines all parties to that execution, including agents and brokers.
        /// </summary>
        public IEnumerable<Party> Parties { get; }
        
        /// <summary>
        /// Defines the role(s) that party(ies) may have in relation to the execution.
        /// </summary>
        public IEnumerable<PartyRole> PartyRoles { get; }
        
        /// <summary>
        /// Specifies the type and venue of execution, e.g. via voice, or electronically.
        /// </summary>
        public ExecutionDetails ExecutionDetails { get; }
        
        /// <summary>
        /// Denotes the trade/execution date.
        /// </summary>
        public FieldWithMetaLocalDate TradeDate { get; }
        
        /// <summary>
        /// Denotes the trade time and timezone as agreed by the parties to the trade.
        /// </summary>
        public FieldWithMetaTimeZone? TradeTime { get; }
        
        /// <summary>
        /// Denotes one or more identifiers associated with the transaction.
        /// </summary>
        public IEnumerable<TradeIdentifier> TradeIdentifier { get; }
        
        /// <summary>
        /// Detail the collateral requirement anticipated with the transaction.
        /// </summary>
        public Collateral? Collateral { get; }
        
        /// <summary>
        /// Lot Identifier associated with the transaction.
        /// </summary>
        public Identifier? LotIdentifier { get; }
    }
    
    /// <summary>
    /// A class to specify execution language terms of a Security Agreement.
    /// </summary>
    public class ExecutionLanguage : AbstractRosettaModelObject<ExecutionLanguage>
    {
        private static readonly IRosettaMetaData<ExecutionLanguage> metaData = new ExecutionLanguageMeta();
        
        [JsonConstructor]
        public ExecutionLanguage(bool standardLanguage, string? numberOfOriginals, string? otherLanguage)
        {
            StandardLanguage = standardLanguage;
            NumberOfOriginals = numberOfOriginals;
            OtherLanguage = otherLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExecutionLanguage> MetaData => metaData;
        
        /// <summary>
        /// A boolean attribute to determine if standard language is applicable or not.
        /// </summary>
        public bool StandardLanguage { get; }
        
        /// <summary>
        /// The number of original documents.
        /// </summary>
        public string? NumberOfOriginals { get; }
        
        /// <summary>
        /// Bespoke execution language to be included when specified.
        /// </summary>
        public string? OtherLanguage { get; }
    }
    
    /// <summary>
    /// A class to specify execution location terms of a Security Agreement.
    /// </summary>
    public class ExecutionLocation : AbstractRosettaModelObject<ExecutionLocation>
    {
        private static readonly IRosettaMetaData<ExecutionLocation> metaData = new ExecutionLocationMeta();
        
        [JsonConstructor]
        public ExecutionLocation(Enums.ExecutionLocation executionLocation, string? otherLanguage, string? dutyPayer, string? dutyPayerLanguage, LocalDate? dutyPaymentDate, string? dutyPaymentLanguage)
        {
            ExecutionLocationValue = executionLocation;
            OtherLanguage = otherLanguage;
            DutyPayer = dutyPayer;
            DutyPayerLanguage = dutyPayerLanguage;
            DutyPaymentDate = dutyPaymentDate;
            DutyPaymentLanguage = dutyPaymentLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExecutionLocation> MetaData => metaData;
        
        /// <summary>
        /// The execution location of the agreement.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "executionLocation")]
        public Enums.ExecutionLocation ExecutionLocationValue { get; }
        
        /// <summary>
        /// Bespoke execution location language to be included when specified.
        /// </summary>
        public string? OtherLanguage { get; }
        
        /// <summary>
        /// The payer of documentary duty.
        /// </summary>
        public string? DutyPayer { get; }
        
        /// <summary>
        /// Bespoke terms specific to the payment of documentary duty.
        /// </summary>
        public string? DutyPayerLanguage { get; }
        
        /// <summary>
        /// The date that documentary duty will be paid.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? DutyPaymentDate { get; }
        
        /// <summary>
        /// Bespoke terms specific to the date that documentary duty will be paid.
        /// </summary>
        public string? DutyPaymentLanguage { get; }
    }
    
    /// <summary>
    /// A class to specify execution location and language of execution to determine duty to be paid.
    /// </summary>
    public class ExecutionTerms : AbstractRosettaModelObject<ExecutionTerms>
    {
        private static readonly IRosettaMetaData<ExecutionTerms> metaData = new ExecutionTermsMeta();
        
        [JsonConstructor]
        public ExecutionTerms(ExecutionLanguage executionLanguage, ExecutionLocation executionLocation)
        {
            ExecutionLanguage = executionLanguage;
            ExecutionLocation = executionLocation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExecutionTerms> MetaData => metaData;
        
        /// <summary>
        /// The bespoke execution language election.
        /// </summary>
        public ExecutionLanguage ExecutionLanguage { get; }
        
        /// <summary>
        /// The bespoke execution location election.
        /// </summary>
        public ExecutionLocation ExecutionLocation { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted dates associated with a particular exercise event.
    /// </summary>
    public class ExerciseEvent : AbstractRosettaModelObject<ExerciseEvent>
    {
        private static readonly IRosettaMetaData<ExerciseEvent> metaData = new ExerciseEventMeta();
        
        [JsonConstructor]
        public ExerciseEvent(LocalDate adjustedExerciseDate, LocalDate adjustedRelevantSwapEffectiveDate, LocalDate? adjustedCashSettlementValuationDate, LocalDate? adjustedCashSettlementPaymentDate, LocalDate? adjustedExerciseFeePaymentDate, _MetaFields? meta)
        {
            AdjustedExerciseDate = adjustedExerciseDate;
            AdjustedRelevantSwapEffectiveDate = adjustedRelevantSwapEffectiveDate;
            AdjustedCashSettlementValuationDate = adjustedCashSettlementValuationDate;
            AdjustedCashSettlementPaymentDate = adjustedCashSettlementPaymentDate;
            AdjustedExerciseFeePaymentDate = adjustedExerciseFeePaymentDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseEvent> MetaData => metaData;
        
        /// <summary>
        /// The date on which the option exercise takes place. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExerciseDate { get; }
        
        /// <summary>
        /// The effective date of the underlying swap associated with a given exercise date. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedRelevantSwapEffectiveDate { get; }
        
        /// <summary>
        /// The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedCashSettlementValuationDate { get; }
        
        /// <summary>
        /// The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedCashSettlementPaymentDate { get; }
        
        /// <summary>
        /// The date on which the exercise fee amount is paid. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedExerciseFeePaymentDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class defining the fee payable on exercise of an option. This fee may be defined as an amount or a percentage of the notional exercised. As a difference with FpML, it extends the BuyerSeller class.
    /// </summary>
    public class ExerciseFee : AbstractRosettaModelObject<ExerciseFee>, IPayerReceiver
    {
        private static readonly IRosettaMetaData<ExerciseFee> metaData = new ExerciseFeeMeta();
        
        [JsonConstructor]
        public ExerciseFee(Enums.CounterpartyRole payer, Enums.CounterpartyRole receiver, ReferenceWithMetaMoney notionalReference, decimal? feeAmount, decimal? feeRate, RelativeDateOffset feePaymentDate)
        {
            Payer = payer;
            Receiver = receiver;
            NotionalReference = notionalReference;
            FeeAmount = feeAmount;
            FeeRate = feeRate;
            FeePaymentDate = feePaymentDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseFee> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Payer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Receiver { get; }
        
        /// <summary>
        /// A pointer style reference to the associated notional schedule defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaMoney NotionalReference { get; }
        
        /// <summary>
        /// The amount of fee to be paid on exercise. The fee currency is that of the referenced notional.
        /// </summary>
        public decimal? FeeAmount { get; }
        
        /// <summary>
        /// A fee represented as a percentage of some referenced notional. A percentage of 5% would be represented as 0.05.
        /// </summary>
        public decimal? FeeRate { get; }
        
        /// <summary>
        /// The date on which exercise fee(s) will be paid. It is specified as a relative date.
        /// </summary>
        public RelativeDateOffset FeePaymentDate { get; }
    }
    
    /// <summary>
    /// A class to define a fee or schedule of fees to be payable on the exercise of an option. This fee may be defined as an amount or a percentage of the notional exercised. As a difference with FpML, it extends the BuyerSeller class.
    /// </summary>
    public class ExerciseFeeSchedule : AbstractRosettaModelObject<ExerciseFeeSchedule>, IPayerReceiver
    {
        private static readonly IRosettaMetaData<ExerciseFeeSchedule> metaData = new ExerciseFeeScheduleMeta();
        
        [JsonConstructor]
        public ExerciseFeeSchedule(Enums.CounterpartyRole payer, Enums.CounterpartyRole receiver, ReferenceWithMetaMoney notionalReference, AmountSchedule? feeAmountSchedule, Schedule? feeRateSchedule, RelativeDateOffset feePaymentDate)
        {
            Payer = payer;
            Receiver = receiver;
            NotionalReference = notionalReference;
            FeeAmountSchedule = feeAmountSchedule;
            FeeRateSchedule = feeRateSchedule;
            FeePaymentDate = feePaymentDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseFeeSchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Payer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Receiver { get; }
        
        /// <summary>
        /// A pointer style reference to the associated notional schedule defined elsewhere in the document.
        /// </summary>
        public ReferenceWithMetaMoney NotionalReference { get; }
        
        /// <summary>
        /// The exercise fee amount schedule. The fees are expressed as currency amounts. The currency of the fee is assumed to be that of the notional schedule referenced.
        /// </summary>
        public AmountSchedule? FeeAmountSchedule { get; }
        
        /// <summary>
        /// The exercise free rate schedule. The fees are expressed as percentage rates of the notional being exercised. The currency of the fee is assumed to be that of the notional schedule referenced.
        /// </summary>
        public Schedule? FeeRateSchedule { get; }
        
        /// <summary>
        /// The date on which exercise fee(s) will be paid. It is specified as a relative date.
        /// </summary>
        public RelativeDateOffset FeePaymentDate { get; }
    }
    
    /// <summary>
    /// Specifies the information required to communicate the choices made by the exercising party, in a financial product endowing the party with at least one option.
    /// </summary>
    public class ExerciseInstruction : AbstractRosettaModelObject<ExerciseInstruction>
    {
        private static readonly IRosettaMetaData<ExerciseInstruction> metaData = new ExerciseInstructionMeta();
        
        [JsonConstructor]
        public ExerciseInstruction(PrimitiveInstruction exerciseQuantity, ReferenceWithMetaOptionPayout? exerciseOption, AdjustableOrAdjustedDate? exerciseDate, BusinessCenterTime? exerciseTime, IEnumerable<TradeIdentifier> replacementTradeIdentifier)
        {
            ExerciseQuantity = exerciseQuantity;
            ExerciseOption = exerciseOption;
            ExerciseDate = exerciseDate;
            ExerciseTime = exerciseTime;
            ReplacementTradeIdentifier = replacementTradeIdentifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseInstruction> MetaData => metaData;
        
        /// <summary>
        /// Contains instructions for exercising the option including a quantity change, and optionally a transfer.
        /// </summary>
        public PrimitiveInstruction ExerciseQuantity { get; }
        
        /// <summary>
        /// Specifies the Option Payout being exercised on the trade.
        /// </summary>
        public ReferenceWithMetaOptionPayout? ExerciseOption { get; }
        
        /// <summary>
        /// Specifies the date on which an option contained within the financial product would be exercised. The date may be omitted if the contractual product allows for only a single date of exercise (European exercise).
        /// </summary>
        public AdjustableOrAdjustedDate? ExerciseDate { get; }
        
        /// <summary>
        /// Specifies the time at which an option contained within the financial product woulld be exercised. The time may be omitted if the contractual product allows for only a single time of exercise (European exercise). 
        /// </summary>
        public BusinessCenterTime? ExerciseTime { get; }
        
        /// <summary>
        /// Specifies the trade identifier to apply to the replacement trade for physical exercise.
        /// </summary>
        public IEnumerable<TradeIdentifier> ReplacementTradeIdentifier { get; }
    }
    
    /// <summary>
    /// Defines to whom and where notice of execution should be given. The exerciseNoticeGiver refers to one or both of the principal parties of the trade. If present the exerciseNoticeReceiver refers to a party, other than the principal party, to whom notice should be given.
    /// </summary>
    public class ExerciseNotice : AbstractRosettaModelObject<ExerciseNotice>
    {
        private static readonly IRosettaMetaData<ExerciseNotice> metaData = new ExerciseNoticeMeta();
        
        [JsonConstructor]
        public ExerciseNotice(Enums.ExerciseNoticeGiver exerciseNoticeGiver, Enums.AncillaryRole? exerciseNoticeReceiver, FieldWithMetaBusinessCenterEnum businessCenter)
        {
            ExerciseNoticeGiver = exerciseNoticeGiver;
            ExerciseNoticeReceiver = exerciseNoticeReceiver;
            BusinessCenter = businessCenter;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseNotice> MetaData => metaData;
        
        /// <summary>
        /// Specifies the principal party of the trade that has the right to exercise.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ExerciseNoticeGiver ExerciseNoticeGiver { get; }
        
        /// <summary>
        /// Specifies the party to which notice of exercise should be given, e.g. by the buyer of the option. Although in many cases it is the buyer of the option who sends the exercise notice to the seller of the option, this component is reused, e.g. in case of OptionEarlyTermination, either or both parties have the right to exercise.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AncillaryRole? ExerciseNoticeReceiver { get; }
        
        /// <summary>
        /// Specifies the location where the exercise must be reported, e.g. where the exercise notice receiver is based.
        /// </summary>
        public FieldWithMetaBusinessCenterEnum BusinessCenter { get; }
    }
    
    /// <summary>
    /// This defines the time interval to the start of the exercise period, i.e. the earliest exercise date, and the frequency of subsequent exercise dates (if any).
    /// </summary>
    public class ExercisePeriod : AbstractRosettaModelObject<ExercisePeriod>
    {
        private static readonly IRosettaMetaData<ExercisePeriod> metaData = new ExercisePeriodMeta();
        
        [JsonConstructor]
        public ExercisePeriod(Period earliestExerciseDateTenor, Period? exerciseFrequency, _MetaFields? meta)
        {
            EarliestExerciseDateTenor = earliestExerciseDateTenor;
            ExerciseFrequency = exerciseFrequency;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExercisePeriod> MetaData => metaData;
        
        /// <summary>
        /// The time interval to the first (and possibly only) exercise date in the exercise period.
        /// </summary>
        public Period EarliestExerciseDateTenor { get; }
        
        /// <summary>
        /// The frequency of subsequent exercise dates in the exercise period following the earliest exercise date. An interval of 1 day should be used to indicate an American style exercise period.
        /// </summary>
        public Period? ExerciseFrequency { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class describing how notice of exercise should be given. This can be either manual or automatic.
    /// </summary>
    public class ExerciseProcedure : AbstractRosettaModelObject<ExerciseProcedure>
    {
        private static readonly IRosettaMetaData<ExerciseProcedure> metaData = new ExerciseProcedureMeta();
        
        [JsonConstructor]
        public ExerciseProcedure(ManualExercise? manualExercise, AutomaticExercise? automaticExercise, bool followUpConfirmation, bool? limitedRightToConfirm, bool? splitTicket)
        {
            ManualExercise = manualExercise;
            AutomaticExercise = automaticExercise;
            FollowUpConfirmation = followUpConfirmation;
            LimitedRightToConfirm = limitedRightToConfirm;
            SplitTicket = splitTicket;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseProcedure> MetaData => metaData;
        
        /// <summary>
        /// Specifies that the notice of exercise must be given by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public ManualExercise? ManualExercise { get; }
        
        /// <summary>
        /// If automatic is specified, then the notional amount of the underlying swap not previously exercised under the swaption will be automatically exercised at the expiration time on the expiration date if at such time the buyer is in-the-money, provided that the difference between the settlement rate and the fixed rate under the relevant underlying swap is not less than the specified threshold rate. The term in-the-money is assumed to have the meaning defining in the 2000 ISDA Definitions, Section 17.4 In-the-money.
        /// </summary>
        public AutomaticExercise? AutomaticExercise { get; }
        
        /// <summary>
        /// A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public bool FollowUpConfirmation { get; }
        
        /// <summary>
        /// Has the meaning defined as part of the 1997 ISDA Government Bond Option Definitions, section 4.5 Limited Right to Confirm Exercise. If present, (i) the Seller may request the Buyer to confirm its intent if not done on or before the expiration time on the Expiration date (ii) specific rules will apply in relation to the settlement mode.
        /// </summary>
        public bool? LimitedRightToConfirm { get; }
        
        /// <summary>
        /// Typically applicable to the physical settlement of bond and convertible bond options. If present, means that the party required to deliver the bonds will divide those to be delivered as notifying party desires to facilitate delivery obligations.
        /// </summary>
        public bool? SplitTicket { get; }
    }
    
    /// <summary>
    /// A class defining the exercise period for an option together with any rules governing the notional amount of the underlying which can be exercised on any given exercise date and any associated exercise fees.
    /// </summary>
    public class ExerciseTerms : AbstractRosettaModelObject<ExerciseTerms>
    {
        private static readonly IRosettaMetaData<ExerciseTerms> metaData = new ExerciseTermsMeta();
        
        [JsonConstructor]
        public ExerciseTerms(Enums.OptionExerciseStyle? style, AdjustableOrRelativeDate? commencementDate, AdjustableOrRelativeDates? exerciseDates, IEnumerable<AdjustableOrRelativeDate> expirationDate, AdjustableOrRelativeDates? relevantUnderlyingDate, BusinessCenterTime? earliestExerciseTime, BusinessCenterTime? latestExerciseTime, BusinessCenterTime? expirationTime, Enums.ExpirationTimeType expirationTimeType, MultipleExercise? multipleExercise, ExerciseFeeSchedule? exerciseFeeSchedule, ExerciseProcedure? exerciseProcedure, ExerciseFee? exerciseFee, PartialExercise? partialExercise, _MetaFields? meta)
        {
            Style = style;
            CommencementDate = commencementDate;
            ExerciseDates = exerciseDates;
            ExpirationDate = expirationDate;
            RelevantUnderlyingDate = relevantUnderlyingDate;
            EarliestExerciseTime = earliestExerciseTime;
            LatestExerciseTime = latestExerciseTime;
            ExpirationTime = expirationTime;
            ExpirationTimeType = expirationTimeType;
            MultipleExercise = multipleExercise;
            ExerciseFeeSchedule = exerciseFeeSchedule;
            ExerciseProcedure = exerciseProcedure;
            ExerciseFee = exerciseFee;
            PartialExercise = partialExercise;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExerciseTerms> MetaData => metaData;
        
        /// <summary>
        /// Whether the option has a single exercise (european), multiple exercise dates (bermuda), or a continuous range of exercise (american).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.OptionExerciseStyle? Style { get; }
        
        /// <summary>
        /// The first day of the exercise period for an American style option.
        /// </summary>
        public AdjustableOrRelativeDate? CommencementDate { get; }
        
        /// <summary>
        /// The dates that define the Bermuda option exercise dates and the expiration date. The last specified date is assumed to be the expiration date. The dates can either be specified as a series of explicit dates and associated adjustments or as a series of dates defined relative to another schedule of dates, for example, the calculation period start dates. Where a relative series of dates are defined the first and last possible exercise dates can be separately specified.
        /// </summary>
        public AdjustableOrRelativeDates? ExerciseDates { get; }
        
        /// <summary>
        /// The last day within an exercise period for an American style option. For a European style option it is the only day within the exercise period.
        /// </summary>
        public IEnumerable<AdjustableOrRelativeDate> ExpirationDate { get; }
        
        /// <summary>
        /// The effective date on the underlying product if the option is exercised.  For example, for a swaption it is the swap effective date, for an option on an FX spot or forward it is the value date for settlement, and in an extendible/cancelable provision it is the swap termination date, which is the date on which the termination is effective.&apos;
        /// </summary>
        public AdjustableOrRelativeDates? RelevantUnderlyingDate { get; }
        
        /// <summary>
        /// The earliest time at which notice of exercise can be given by the buyer to the seller (or seller&apos;s agent) to, and including, the expiration date.
        /// </summary>
        public BusinessCenterTime? EarliestExerciseTime { get; }
        
        /// <summary>
        /// For a Bermuda or American style option, the latest time on an exercise business day (excluding the expiration date) within the exercise period that notice can be given by the buyer to the seller or seller&apos;s agent. Notice of exercise given after this time will be deemed to have been given on the next exercise business day.
        /// </summary>
        public BusinessCenterTime? LatestExerciseTime { get; }
        
        /// <summary>
        /// The latest time for exercise on expirationDate. It is made mandatory given that for all option styles, this field is required.
        /// </summary>
        public BusinessCenterTime? ExpirationTime { get; }
        
        /// <summary>
        /// The time of day at which the equity option expires, for example the official closing time of the exchange.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ExpirationTimeType ExpirationTimeType { get; }
        
        /// <summary>
        /// As defined in the 2000 ISDA Definitions, Section 12.4. Multiple Exercise, the buyer of the option has the right to exercise all or less than all the unexercised notional amount of the underlying swap on one or more days in the exercise period, but on any such day may not exercise less than the minimum notional amount or more that the maximum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.
        /// </summary>
        public MultipleExercise? MultipleExercise { get; }
        
        /// <summary>
        /// The fees associated with an exercise date. The fees are conditional on the exercise occurring. The fees can be specified as actual currency amounts or as percentages of the notional amount being exercised.
        /// </summary>
        public ExerciseFeeSchedule? ExerciseFeeSchedule { get; }
        
        /// <summary>
        /// The set of parameters defining the procedure associated with the exercise, e.g. manual exercise.
        /// </summary>
        public ExerciseProcedure? ExerciseProcedure { get; }
        
        /// <summary>
        /// A fee to be paid on exercise. This could be represented as an amount or a rate and notional reference on which to apply the rate.
        /// </summary>
        public ExerciseFee? ExerciseFee { get; }
        
        /// <summary>
        /// As defined in the 2000 ISDA Definitions, Section 12.3. Partial Exercise, the buyer of the option has the right to exercise all or less than all the notional amount of the underlying swap on the expiration date, but may not exercise less than the minimum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.
        /// </summary>
        public PartialExercise? PartialExercise { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Represents the current mark to market value or IM calculation value of the trade portfolio as recorded by the principle (in base currency).
    /// </summary>
    public class Exposure : AbstractRosettaModelObject<Exposure>
    {
        private static readonly IRosettaMetaData<Exposure> metaData = new ExposureMeta();
        
        [JsonConstructor]
        public Exposure(ReferenceWithMetaPortfolioState tradePortfolio, Money aggregateValue, ZonedDateTime? calculationDateTime, ZonedDateTime valuationDateTime)
        {
            TradePortfolio = tradePortfolio;
            AggregateValue = aggregateValue;
            CalculationDateTime = calculationDateTime;
            ValuationDateTime = valuationDateTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Exposure> MetaData => metaData;
        
        /// <summary>
        /// Represents a Portfolio that describes all the positions held at a given time, in various states which can be either traded, settled, etc., with lineage information to the previous state.
        /// </summary>
        public ReferenceWithMetaPortfolioState TradePortfolio { get; }
        
        /// <summary>
        /// Represents the aggregate value of the portfolio in base currency.
        /// </summary>
        public Money AggregateValue { get; }
        
        /// <summary>
        /// Indicates the date when the exposure is calculated if different from valuation date.
        /// </summary>
        public ZonedDateTime? CalculationDateTime { get; }
        
        /// <summary>
        /// Indicates the valuation date of the exposure underlying the calculation.
        /// </summary>
        public ZonedDateTime ValuationDateTime { get; }
    }
    
    /// <summary>
    /// Optionally, for each party, specifies the amendments to the included coverage in the calculation of Exposure.
    /// </summary>
    public class ExposureScope : AbstractRosettaModelObject<ExposureScope>
    {
        private static readonly IRosettaMetaData<ExposureScope> metaData = new ExposureScopeMeta();
        
        [JsonConstructor]
        public ExposureScope(IEnumerable<LegacyExposureScopeElection> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExposureScope> MetaData => metaData;
        
        /// <summary>
        /// Defines the electice scope for a specific party.
        /// </summary>
        public IEnumerable<LegacyExposureScopeElection> PartyElection { get; }
    }
    
    /// <summary>
    /// A data defining:  an option to extend an existing swap transaction on the specified exercise dates for a term ending on the specified new termination date. As a difference from FpML, it extends the BuyerSeller class, which represents the BuyerSeller.model.
    /// </summary>
    public class ExtendibleProvision : AbstractRosettaModelObject<ExtendibleProvision>, IBuyerSeller
    {
        private static readonly IRosettaMetaData<ExtendibleProvision> metaData = new ExtendibleProvisionMeta();
        
        [JsonConstructor]
        public ExtendibleProvision(Enums.CounterpartyRole buyer, Enums.CounterpartyRole seller, ExerciseNotice? exerciseNotice, bool? followUpConfirmation, ExtendibleProvisionAdjustedDates? extendibleProvisionAdjustedDates, Enums.CallingParty? callingParty, PartyRole? singlePartyOption, RelativeDateOffset? noticeDeadlinePeriod, ZonedDateTime? noticeDeadlineDateTime, RelativeDateOffset? extensionTerm, AdjustableRelativeOrPeriodicDates? extensionPeriod, ExerciseTerms exerciseTerms)
        {
            Buyer = buyer;
            Seller = seller;
            ExerciseNotice = exerciseNotice;
            FollowUpConfirmation = followUpConfirmation;
            ExtendibleProvisionAdjustedDates = extendibleProvisionAdjustedDates;
            CallingParty = callingParty;
            SinglePartyOption = singlePartyOption;
            NoticeDeadlinePeriod = noticeDeadlinePeriod;
            NoticeDeadlineDateTime = noticeDeadlineDateTime;
            ExtensionTerm = extensionTerm;
            ExtensionPeriod = extensionPeriod;
            ExerciseTerms = exerciseTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExtendibleProvision> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Buyer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Seller { get; }
        
        /// <summary>
        /// Definition of the party to whom notice of exercise should be given.
        /// </summary>
        public ExerciseNotice? ExerciseNotice { get; }
        
        /// <summary>
        /// A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public bool? FollowUpConfirmation { get; }
        
        /// <summary>
        /// The adjusted dates associated with an extendible provision. These dates have been adjusted for any applicable business day convention.
        /// </summary>
        public ExtendibleProvisionAdjustedDates? ExtendibleProvisionAdjustedDates { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CallingParty? CallingParty { get; }
        
        /// <summary>
        /// If the ability to extend the contract is not available to both parties then this component specifies the buyer and seller of the option.
        /// </summary>
        public PartyRole? SinglePartyOption { get; }
        
        /// <summary>
        /// Defines the minimum period before a contract is scheduled to terminate that notice can be given that it will terminate beyond the scheduled termination date.
        /// </summary>
        public RelativeDateOffset? NoticeDeadlinePeriod { get; }
        
        /// <summary>
        /// A specific date and time for the notice deadline
        /// </summary>
        public ZonedDateTime? NoticeDeadlineDateTime { get; }
        
        /// <summary>
        /// The length of each extension period relative to the effective date of the preceding contract.
        /// </summary>
        public RelativeDateOffset? ExtensionTerm { get; }
        
        /// <summary>
        /// The period within which notice can be given that the contract will be extended.
        /// </summary>
        public AdjustableRelativeOrPeriodicDates? ExtensionPeriod { get; }
        
        /// <summary>
        /// The exercise terms associated with the extendible provision, including details such as exercise style, exercise fees, and any other relevant conditions or terms governing the extension of the swap transaction.
        /// </summary>
        public ExerciseTerms ExerciseTerms { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted dates associated with a provision to extend a swap.
    /// </summary>
    public class ExtendibleProvisionAdjustedDates : AbstractRosettaModelObject<ExtendibleProvisionAdjustedDates>
    {
        private static readonly IRosettaMetaData<ExtendibleProvisionAdjustedDates> metaData = new ExtendibleProvisionAdjustedDatesMeta();
        
        [JsonConstructor]
        public ExtendibleProvisionAdjustedDates(IEnumerable<ExtensionEvent> extensionEvent)
        {
            ExtensionEvent = extensionEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExtendibleProvisionAdjustedDates> MetaData => metaData;
        
        /// <summary>
        /// The adjusted dates associated with a single extendible exercise date.
        /// </summary>
        public IEnumerable<ExtensionEvent> ExtensionEvent { get; }
    }
    
    /// <summary>
    /// A data to:  define the adjusted dates associated with an individual extension event.
    /// </summary>
    public class ExtensionEvent : AbstractRosettaModelObject<ExtensionEvent>
    {
        private static readonly IRosettaMetaData<ExtensionEvent> metaData = new ExtensionEventMeta();
        
        [JsonConstructor]
        public ExtensionEvent(LocalDate adjustedExerciseDate, LocalDate adjustedExtendedTerminationDate, _MetaFields? meta)
        {
            AdjustedExerciseDate = adjustedExerciseDate;
            AdjustedExtendedTerminationDate = adjustedExtendedTerminationDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExtensionEvent> MetaData => metaData;
        
        /// <summary>
        /// The date on which option exercise takes place. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExerciseDate { get; }
        
        /// <summary>
        /// The termination date if an extendible provision is exercised. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedExtendedTerminationDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Where the underlying is shares, defines market events affecting the issuer of those shares that may require the terms of the transaction to be adjusted.
    /// </summary>
    public class ExtraordinaryEvents : AbstractRosettaModelObject<ExtraordinaryEvents>
    {
        private static readonly IRosettaMetaData<ExtraordinaryEvents> metaData = new ExtraordinaryEventsMeta();
        
        [JsonConstructor]
        public ExtraordinaryEvents(IEnumerable<Clause> additionalBespokeTerms, EquityCorporateEvents? mergerEvents, EquityCorporateEvents? tenderOfferEvents, bool? compositionOfCombinedConsideration, IndexAdjustmentEvents? indexAdjustmentEvents, AdditionalDisruptionEvents? additionalDisruptionEvents, bool? failureToDeliver, Representations? representations, Enums.NationalizationOrInsolvencyOrDelistingEvent? nationalizationOrInsolvency, Enums.NationalizationOrInsolvencyOrDelistingEvent? delisting)
        {
            AdditionalBespokeTerms = additionalBespokeTerms;
            MergerEvents = mergerEvents;
            TenderOfferEvents = tenderOfferEvents;
            CompositionOfCombinedConsideration = compositionOfCombinedConsideration;
            IndexAdjustmentEvents = indexAdjustmentEvents;
            AdditionalDisruptionEvents = additionalDisruptionEvents;
            FailureToDeliver = failureToDeliver;
            Representations = representations;
            NationalizationOrInsolvency = nationalizationOrInsolvency;
            Delisting = delisting;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ExtraordinaryEvents> MetaData => metaData;
        
        /// <summary>
        /// Where parties may optionnaly describe any extra bespoke agreements, in regards of the standardized Extraordinary Events.
        /// </summary>
        public IEnumerable<Clause> AdditionalBespokeTerms { get; }
        
        public EquityCorporateEvents? MergerEvents { get; }
        
        public EquityCorporateEvents? TenderOfferEvents { get; }
        
        public bool? CompositionOfCombinedConsideration { get; }
        
        public IndexAdjustmentEvents? IndexAdjustmentEvents { get; }
        
        public AdditionalDisruptionEvents? AdditionalDisruptionEvents { get; }
        
        /// <summary>
        /// If true, failure to deliver is applicable.
        /// </summary>
        public bool? FailureToDeliver { get; }
        
        public Representations? Representations { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NationalizationOrInsolvencyOrDelistingEvent? NationalizationOrInsolvency { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NationalizationOrInsolvencyOrDelistingEvent? Delisting { get; }
    }
    
    public class FailureToPay : AbstractRosettaModelObject<FailureToPay>
    {
        private static readonly IRosettaMetaData<FailureToPay> metaData = new FailureToPayMeta();
        
        [JsonConstructor]
        public FailureToPay(bool applicable, GracePeriodExtension? gracePeriodExtension, Money? paymentRequirement)
        {
            Applicable = applicable;
            GracePeriodExtension = gracePeriodExtension;
            PaymentRequirement = paymentRequirement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FailureToPay> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the failure to pay provision is applicable.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// If this element is specified, indicates whether or not a grace period extension is applicable. ISDA 2003 Term: Grace Period Extension Applicable.
        /// </summary>
        public GracePeriodExtension? GracePeriodExtension { get; }
        
        /// <summary>
        /// Specifies a threshold for the failure to pay credit event. Market standard is USD 1,000,000 (JPY 100,000,000 for Japanese Yen trades) or its equivalent in the relevant obligation currency. This is applied on an aggregate basis across all Obligations of the Reference Entity. Intended to prevent technical/operational errors from triggering credit events. ISDA 2003 Term: Payment Requirement
        /// </summary>
        public Money? PaymentRequirement { get; }
    }
    
    /// <summary>
    /// Defines the structure needed to represent fallback rate parameters. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class FallbackRateParameters : AbstractRosettaModelObject<FallbackRateParameters>
    {
        private static readonly IRosettaMetaData<FallbackRateParameters> metaData = new FallbackRateParametersMeta();
        
        [JsonConstructor]
        public FallbackRateParameters(Enums.FloatingRateIndex floatingRateIndex, LocalDate? effectiveDate, FloatingRateCalculationParameters? calculationParameters, decimal? spreadAdjustment)
        {
            FloatingRateIndex = floatingRateIndex;
            EffectiveDate = effectiveDate;
            CalculationParameters = calculationParameters;
            SpreadAdjustment = spreadAdjustment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FallbackRateParameters> MetaData => metaData;
        
        /// <summary>
        /// The floating rate index that is used as the basis of the fallback rate.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndex FloatingRateIndex { get; }
        
        /// <summary>
        /// The date the fallback rate takes effect.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <summary>
        /// Support for modular calculated rates, such such as lockout compound calculations.
        /// </summary>
        public FloatingRateCalculationParameters? CalculationParameters { get; }
        
        /// <summary>
        /// The economic spread applied to the underlying fallback rate to replicate the original risky rate.
        /// </summary>
        public decimal? SpreadAdjustment { get; }
    }
    
    /// <summary>
    /// The method, prioritised by the order it is listed in this element, to get a replacement rate for the disrupted settlement rate option.
    /// </summary>
    public class FallbackReferencePrice : AbstractRosettaModelObject<FallbackReferencePrice>
    {
        private static readonly IRosettaMetaData<FallbackReferencePrice> metaData = new FallbackReferencePriceMeta();
        
        [JsonConstructor]
        public FallbackReferencePrice(ValuationPostponement? valuationPostponement, IEnumerable<FieldWithMetaSettlementRateOptionEnum> fallBackSettlementRateOption, bool? fallbackSurveyValuationPostponement, CalculationAgent? calculationAgentDetermination)
        {
            ValuationPostponement = valuationPostponement;
            FallBackSettlementRateOption = fallBackSettlementRateOption;
            FallbackSurveyValuationPostponement = fallbackSurveyValuationPostponement;
            CalculationAgentDetermination = calculationAgentDetermination;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FallbackReferencePrice> MetaData => metaData;
        
        /// <summary>
        /// Specifies how long to wait to get a quote from a settlement rate option upon a price source disruption.
        /// </summary>
        public ValuationPostponement? ValuationPostponement { get; }
        
        /// <summary>
        /// This settlement rate option will be used in its place.
        /// </summary>
        public IEnumerable<FieldWithMetaSettlementRateOptionEnum> FallBackSettlementRateOption { get; }
        
        /// <summary>
        /// Request rate quotes from the market. This element is set as type Empty in FpML. When present, the FpML synonym is mapped to a value True in the CDM.
        /// </summary>
        public bool? FallbackSurveyValuationPostponement { get; }
        
        /// <summary>
        /// The calculation agent will decide the rate.
        /// </summary>
        public CalculationAgent? CalculationAgentDetermination { get; }
    }
    
    /// <summary>
    /// Payment made following trigger occurrence.
    /// </summary>
    public class FeaturePayment : AbstractRosettaModelObject<FeaturePayment>
    {
        private static readonly IRosettaMetaData<FeaturePayment> metaData = new FeaturePaymentMeta();
        
        [JsonConstructor]
        public FeaturePayment(PartyReferencePayerReceiver payerReceiver, decimal? levelPercentage, decimal? amount, Enums.TimeType? time, FieldWithMetaString? currency, AdjustableOrRelativeDate? paymentDate, _MetaFields? meta)
        {
            PayerReceiver = payerReceiver;
            LevelPercentage = levelPercentage;
            Amount = amount;
            Time = time;
            Currency = currency;
            PaymentDate = paymentDate;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FeaturePayment> MetaData => metaData;
        
        /// <summary>
        /// This attribute doesn&apos;t exist as part of the FpML construct, which makes use of the PayerReceiver.model group.
        /// </summary>
        public PartyReferencePayerReceiver PayerReceiver { get; }
        
        /// <summary>
        /// The trigger level percentage.
        /// </summary>
        public decimal? LevelPercentage { get; }
        
        /// <summary>
        /// The monetary quantity in currency units.
        /// </summary>
        public decimal? Amount { get; }
        
        /// <summary>
        /// The feature payment time.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TimeType? Time { get; }
        
        /// <summary>
        /// The currency in which an amount is denominated.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
        
        /// <summary>
        /// The feature payment date.
        /// </summary>
        public AdjustableOrRelativeDate? PaymentDate { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    public class FinInstrm : AbstractRosettaModelObject<FinInstrm>
    {
        private static readonly IRosettaMetaData<FinInstrm> metaData = new FinInstrmMeta();
        
        [JsonConstructor]
        public FinInstrm(Othr othr)
        {
            Othr = othr;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinInstrm> MetaData => metaData;
        
        public Othr Othr { get; }
    }
    
    public class FinInstrmGnlAttrbts : AbstractRosettaModelObject<FinInstrmGnlAttrbts>
    {
        private static readonly IRosettaMetaData<FinInstrmGnlAttrbts> metaData = new FinInstrmGnlAttrbtsMeta();
        
        [JsonConstructor]
        public FinInstrmGnlAttrbts(string fullNm, string clssfctnTp, string ntnlCcy)
        {
            FullNm = fullNm;
            ClssfctnTp = clssfctnTp;
            NtnlCcy = ntnlCcy;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinInstrmGnlAttrbts> MetaData => metaData;
        
        public string FullNm { get; }
        
        public string ClssfctnTp { get; }
        
        public string NtnlCcy { get; }
    }
    
    public class FinInstrmRptgTxRpt : AbstractRosettaModelObject<FinInstrmRptgTxRpt>
    {
        private static readonly IRosettaMetaData<FinInstrmRptgTxRpt> metaData = new FinInstrmRptgTxRptMeta();
        
        [JsonConstructor]
        public FinInstrmRptgTxRpt(Tx tx)
        {
            Tx = tx;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinInstrmRptgTxRpt> MetaData => metaData;
        
        public Tx Tx { get; }
    }
    
    /// <summary>
    /// A data to:  define business date convention adjustment to final payment period per leg.
    /// </summary>
    public class FinalCalculationPeriodDateAdjustment : AbstractRosettaModelObject<FinalCalculationPeriodDateAdjustment>
    {
        private static readonly IRosettaMetaData<FinalCalculationPeriodDateAdjustment> metaData = new FinalCalculationPeriodDateAdjustmentMeta();
        
        [JsonConstructor]
        public FinalCalculationPeriodDateAdjustment(ReferenceWithMetaAdjustableOrRelativeDates relevantUnderlyingDateReference, ReferenceWithMetaInterestRatePayout swapStreamReference, Enums.BusinessDayConvention businessDayConvention)
        {
            RelevantUnderlyingDateReference = relevantUnderlyingDateReference;
            SwapStreamReference = swapStreamReference;
            BusinessDayConvention = businessDayConvention;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinalCalculationPeriodDateAdjustment> MetaData => metaData;
        
        /// <summary>
        /// Reference to the unadjusted cancellation effective dates.
        /// </summary>
        public ReferenceWithMetaAdjustableOrRelativeDates RelevantUnderlyingDateReference { get; }
        
        /// <summary>
        /// Reference to the leg, where date adjustments may apply.
        /// </summary>
        public ReferenceWithMetaInterestRatePayout SwapStreamReference { get; }
        
        /// <summary>
        /// Override business date convention. This takes precedence over leg level information.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention BusinessDayConvention { get; }
    }
    
    /// <summary>
    /// A clause providing that final return collateral is to be provided without consideration of any Minimum Transfer Amount and collateral haircut.
    /// </summary>
    public class FinalReturns : AbstractRosettaModelObject<FinalReturns>
    {
        private static readonly IRosettaMetaData<FinalReturns> metaData = new FinalReturnsMeta();
        
        [JsonConstructor]
        public FinalReturns(bool? applicable, string? additionalLanguage)
        {
            Applicable = applicable;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FinalReturns> MetaData => metaData;
        
        /// <summary>
        /// Defines if the clause is applicable to this agreement or any other exceptions.
        /// </summary>
        public bool? Applicable { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Type for reporting the detailed results of calculating a cash flow for a calculation period.  This is enhanced relative to the FpML-based cashflows structure to allow more information to be returned about daily compounded rates.
    /// </summary>
    public class FixedAmountCalculationDetails : AbstractRosettaModelObject<FixedAmountCalculationDetails>
    {
        private static readonly IRosettaMetaData<FixedAmountCalculationDetails> metaData = new FixedAmountCalculationDetailsMeta();
        
        [JsonConstructor]
        public FixedAmountCalculationDetails(CalculationPeriodBase calculationPeriod, Money calculationPeriodNotionalAmount, decimal fixedRate, decimal yearFraction, decimal calculatedAmount)
        {
            CalculationPeriod = calculationPeriod;
            CalculationPeriodNotionalAmount = calculationPeriodNotionalAmount;
            FixedRate = fixedRate;
            YearFraction = yearFraction;
            CalculatedAmount = calculatedAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FixedAmountCalculationDetails> MetaData => metaData;
        
        /// <summary>
        /// The calculation period for which the floating calculation was performed.
        /// </summary>
        public CalculationPeriodBase CalculationPeriod { get; }
        
        /// <summary>
        /// The notional in effect during the calculation period.
        /// </summary>
        public Money CalculationPeriodNotionalAmount { get; }
        
        /// <summary>
        /// The value of the fixed rate that was used.
        /// </summary>
        public decimal FixedRate { get; }
        
        /// <summary>
        /// The fraction of a year that this calculation represents, according to the day count fraction method.
        /// </summary>
        public decimal YearFraction { get; }
        
        /// <summary>
        /// The amount of the cash flow that was computed, including any spreads and other processing.
        /// </summary>
        public decimal CalculatedAmount { get; }
    }
    
    /// <summary>
    /// A predefined price accorded by the counterparties.
    /// </summary>
    public class FixedPrice : AbstractRosettaModelObject<FixedPrice>
    {
        private static readonly IRosettaMetaData<FixedPrice> metaData = new FixedPriceMeta();
        
        [JsonConstructor]
        public FixedPrice(ReferenceWithMetaPriceSchedule? price)
        {
            Price = price;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FixedPrice> MetaData => metaData;
        
        /// <summary>
        /// Fixed price step schedule, including an initial price specified as an absolute number.
        /// </summary>
        public ReferenceWithMetaPriceSchedule? Price { get; }
    }
    
    /// <summary>
    /// Represents a fixed price payout. There is no underlier associated with this payout type and is based on fixed pricing per a given unit (e.g. in commodities price per barrel)
    /// </summary>
    public class FixedPricePayout : AbstractRosettaModelObject<FixedPricePayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<FixedPricePayout> metaData = new FixedPricePayoutMeta();
        
        [JsonConstructor]
        public FixedPricePayout(PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms, PaymentDates paymentDates, FixedPrice fixedPrice, CalculationSchedule? schedule)
        {
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
            PaymentDates = paymentDates;
            FixedPrice = fixedPrice;
            Schedule = schedule;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FixedPricePayout> MetaData => metaData;
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
        
        /// <summary>
        /// Specifies the parameters to generate the payment date schedule, either through a parametric representation or by reference to specified dates.
        /// </summary>
        public PaymentDates PaymentDates { get; }
        
        /// <summary>
        /// Specifies the fixed price on which fixed forward payments are based.
        /// </summary>
        public FixedPrice FixedPrice { get; }
        
        /// <summary>
        /// Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
        /// </summary>
        public CalculationSchedule? Schedule { get; }
    }
    
    /// <summary>
    /// Type defining the specification for a fixed rate.
    /// </summary>
    public class FixedRateSpecification : AbstractRosettaModelObject<FixedRateSpecification>
    {
        private static readonly IRosettaMetaData<FixedRateSpecification> metaData = new FixedRateSpecificationMeta();
        
        [JsonConstructor]
        public FixedRateSpecification(RateSchedule? rateSchedule, _MetaFields? meta)
        {
            RateSchedule = rateSchedule;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FixedRateSpecification> MetaData => metaData;
        
        /// <summary>
        /// The fixed rate or fixed rate schedule expressed as explicit fixed rates and dates. In the case of a schedule, the step dates may be subject to adjustment in accordance with any adjustments specified in calculationPeriodDatesAdjustments.
        /// </summary>
        public RateSchedule? RateSchedule { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Type for reporting the detailed results of calculating a cash flow for a calculation period.  This is enhanced relative to the FpML-based cashflows structure to allow more information to be returned about daily compounded rates.
    /// </summary>
    public class FloatingAmountCalculationDetails : AbstractRosettaModelObject<FloatingAmountCalculationDetails>
    {
        private static readonly IRosettaMetaData<FloatingAmountCalculationDetails> metaData = new FloatingAmountCalculationDetailsMeta();
        
        [JsonConstructor]
        public FloatingAmountCalculationDetails(CalculationPeriodBase calculationPeriod, Money calculationPeriodNotionalAmount, FloatingRateSettingDetails? floatingRate, FloatingRateProcessingDetails? processingDetails, decimal appliedRate, decimal yearFraction, decimal calculatedAmount, decimal spreadExclusiveCalculatedAMount)
        {
            CalculationPeriod = calculationPeriod;
            CalculationPeriodNotionalAmount = calculationPeriodNotionalAmount;
            FloatingRate = floatingRate;
            ProcessingDetails = processingDetails;
            AppliedRate = appliedRate;
            YearFraction = yearFraction;
            CalculatedAmount = calculatedAmount;
            SpreadExclusiveCalculatedAMount = spreadExclusiveCalculatedAMount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingAmountCalculationDetails> MetaData => metaData;
        
        /// <summary>
        /// The calculation period for which the floating calculation was performed.
        /// </summary>
        public CalculationPeriodBase CalculationPeriod { get; }
        
        /// <summary>
        /// The notional in effect during the calculation period.
        /// </summary>
        public Money CalculationPeriodNotionalAmount { get; }
        
        /// <summary>
        /// The details of the floating rate setting.  (If it is a calculated rate, details of that calculation will be inside that.
        /// </summary>
        public FloatingRateSettingDetails? FloatingRate { get; }
        
        /// <summary>
        /// Details fo the floating rate treatment after the rate is observed or calculated.  This will include details of things like multipliers, spreads, caps and floors, and the raw and treated rates.
        /// </summary>
        public FloatingRateProcessingDetails? ProcessingDetails { get; }
        
        /// <summary>
        /// The rate that was actually applied, after all calculations and treatments.
        /// </summary>
        public decimal AppliedRate { get; }
        
        /// <summary>
        /// The fraction of a year that this calculation represents, according to the day count fraction method.
        /// </summary>
        public decimal YearFraction { get; }
        
        /// <summary>
        /// The amount of the cash flow that was computed, including any spreads and other processing.
        /// </summary>
        public decimal CalculatedAmount { get; }
        
        /// <summary>
        /// The amount of the cash flow excluding any spread, for subsequent processing.
        /// </summary>
        public decimal SpreadExclusiveCalculatedAMount { get; }
    }
    
    /// <summary>
    /// A class to specify the ISDA terms relating to the floating rate payment events and the implied additional fixed payments, applicable to the credit derivatives transactions on mortgage-backed securities with pay-as-you-go or physical settlement.
    /// </summary>
    public class FloatingAmountEvents : AbstractRosettaModelObject<FloatingAmountEvents>
    {
        private static readonly IRosettaMetaData<FloatingAmountEvents> metaData = new FloatingAmountEventsMeta();
        
        [JsonConstructor]
        public FloatingAmountEvents(bool? failureToPayPrincipal, InterestShortFall? interestShortfall, bool? writedown, bool? impliedWritedown, FloatingAmountProvisions? floatingAmountProvisions, AdditionalFixedPayments? additionalFixedPayments)
        {
            FailureToPayPrincipal = failureToPayPrincipal;
            InterestShortfall = interestShortfall;
            Writedown = writedown;
            ImpliedWritedown = impliedWritedown;
            FloatingAmountProvisions = floatingAmountProvisions;
            AdditionalFixedPayments = additionalFixedPayments;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingAmountEvents> MetaData => metaData;
        
        /// <summary>
        /// A floating rate payment event. Corresponds to the failure by the Reference Entity to pay an expected principal amount or the payment of an actual principal amount that is less than the expected principal amount. ISDA 2003 Term: Failure to Pay Principal.
        /// </summary>
        public bool? FailureToPayPrincipal { get; }
        
        /// <summary>
        /// A floating rate payment event. With respect to any Reference Obligation Payment Date, either (a) the non-payment of an Expected Interest Amount or (b) the payment of an Actual Interest Amount that is less than the Expected Interest Amount. ISDA 2003 Term: Interest Shortfall.
        /// </summary>
        public InterestShortFall? InterestShortfall { get; }
        
        /// <summary>
        /// A floating rate payment event. Results from the fact that the underlier writes down its outstanding principal amount. ISDA 2003 Term: Writedown.
        /// </summary>
        public bool? Writedown { get; }
        
        /// <summary>
        /// A floating rate payment event. Results from the fact that losses occur to the underlying instruments that do not result in reductions of the outstanding principal of the reference obligation.
        /// </summary>
        public bool? ImpliedWritedown { get; }
        
        /// <summary>
        /// Specifies the floating amount provisions associated with the floatingAmountEvents.
        /// </summary>
        public FloatingAmountProvisions? FloatingAmountProvisions { get; }
        
        /// <summary>
        /// Specifies the events that will give rise to the payment additional fixed payments.
        /// </summary>
        public AdditionalFixedPayments? AdditionalFixedPayments { get; }
    }
    
    public class FloatingAmountProvisions : AbstractRosettaModelObject<FloatingAmountProvisions>
    {
        private static readonly IRosettaMetaData<FloatingAmountProvisions> metaData = new FloatingAmountProvisionsMeta();
        
        [JsonConstructor]
        public FloatingAmountProvisions(bool? wacCapInterestProvision, bool? stepUpProvision)
        {
            WacCapInterestProvision = wacCapInterestProvision;
            StepUpProvision = stepUpProvision;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingAmountProvisions> MetaData => metaData;
        
        /// <summary>
        /// As specified by the ISDA Supplement for use with trades on mortgage-backed securities, &apos;WAC Cap&apos; means a weighted average coupon or weighted average rate cap provision (however defined in the Underlying Instruments) of the Underlying Instruments that limits, increases or decreases the interest rate or interest entitlement, as set out in the Underlying Instruments on the Effective Date without regard to any subsequent amendment The presence of the element with value set to &apos;true&apos; signifies that the provision is applicable. From a usage standpoint, this provision is typically applicable in the case of CMBS and not applicable in case of RMBS trades.
        /// </summary>
        public bool? WacCapInterestProvision { get; }
        
        /// <summary>
        /// As specified by the ISDA Standard Terms Supplement for use with trades on mortgage-backed securities. The presence of the element with value set to &apos;true&apos; signifies that the provision is applicable. If applicable, the applicable step-up terms are specified as part of that ISDA Standard Terms Supplement. From a usage standpoint, this provision is typically applicable in the case of RMBS and not applicable in case of CMBS trades.
        /// </summary>
        public bool? StepUpProvision { get; }
    }
    
    public class FloatingRate : AbstractRosettaModelObject<FloatingRate>, IFloatingRate, IFloatingRateBase
    {
        private static readonly IRosettaMetaData<FloatingRate> metaData = new FloatingRateMeta();
        
        [JsonConstructor]
        public FloatingRate(ReferenceWithMetaInterestRateIndex? rateOption, SpreadSchedule? spreadSchedule, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, RateSchedule? floatingRateMultiplierSchedule, Enums.RateTreatment? rateTreatment, FloatingRateCalculationParameters? calculationParameters, FallbackRateParameters? fallbackRate)
        {
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            FloatingRateMultiplierSchedule = floatingRateMultiplierSchedule;
            RateTreatment = rateTreatment;
            CalculationParameters = calculationParameters;
            FallbackRate = fallbackRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRate> MetaData => metaData;
        
        public ReferenceWithMetaInterestRateIndex? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        public RateSchedule? FloatingRateMultiplierSchedule { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? RateTreatment { get; }
        
        /// <inheritdoc/>
        public FloatingRateCalculationParameters? CalculationParameters { get; }
        
        /// <inheritdoc/>
        public FallbackRateParameters? FallbackRate { get; }
    }
    
    /// <summary>
    /// A class defining a floating interest rate through the specification of the floating rate index, the tenor, the multiplier schedule, the spread, the qualification of whether a specific rate treatment and/or a cap or floor apply.
    /// </summary>
    public class FloatingRateBase : AbstractRosettaModelObject<FloatingRateBase>, IFloatingRateBase
    {
        private static readonly IRosettaMetaData<FloatingRateBase> metaData = new FloatingRateBaseMeta();
        
        [JsonConstructor]
        public FloatingRateBase(ReferenceWithMetaInterestRateIndex? rateOption, SpreadSchedule? spreadSchedule, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta)
        {
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateBase> MetaData => metaData;
        
        public ReferenceWithMetaInterestRateIndex? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Defines the structures needed to represent the calculation parameters for daily averaged and compounded modular rates as defined in the 2021 ISDA Definitions in Section 7. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class FloatingRateCalculationParameters : AbstractRosettaModelObject<FloatingRateCalculationParameters>
    {
        private static readonly IRosettaMetaData<FloatingRateCalculationParameters> metaData = new FloatingRateCalculationParametersMeta();
        
        [JsonConstructor]
        public FloatingRateCalculationParameters(Enums.CalculationMethod calculationMethod, ObservationShiftCalculation? observationShiftCalculation, OffsetCalculation? lookbackCalculation, OffsetCalculation? lockoutCalculation, BusinessCenters? applicableBusinessDays, ObservationParameters? observationParameters)
        {
            CalculationMethod = calculationMethod;
            ObservationShiftCalculation = observationShiftCalculation;
            LookbackCalculation = lookbackCalculation;
            LockoutCalculation = lockoutCalculation;
            ApplicableBusinessDays = applicableBusinessDays;
            ObservationParameters = observationParameters;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateCalculationParameters> MetaData => metaData;
        
        /// <summary>
        /// calculation type (averaging or compounding).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CalculationMethod CalculationMethod { get; }
        
        /// <summary>
        /// any obervation shift parameters if applicable.
        /// </summary>
        public ObservationShiftCalculation? ObservationShiftCalculation { get; }
        
        /// <summary>
        /// any lookback  parameters if applicable.
        /// </summary>
        public OffsetCalculation? LookbackCalculation { get; }
        
        /// <summary>
        /// any lockout  parameters if applicable.
        /// </summary>
        public OffsetCalculation? LockoutCalculation { get; }
        
        /// <summary>
        /// the business days that are applicable for the calculation.
        /// </summary>
        public BusinessCenters? ApplicableBusinessDays { get; }
        
        /// <summary>
        ///  any applicable observation parameters, such as daily caps or floors.
        /// </summary>
        public ObservationParameters? ObservationParameters { get; }
    }
    
    /// <summary>
    /// A data defining:  parameters associated with a floating rate reset. This data forms:  part of the cashflows representation of a stream.
    /// </summary>
    public class FloatingRateDefinition : AbstractRosettaModelObject<FloatingRateDefinition>
    {
        private static readonly IRosettaMetaData<FloatingRateDefinition> metaData = new FloatingRateDefinitionMeta();
        
        [JsonConstructor]
        public FloatingRateDefinition(decimal? calculatedRate, IEnumerable<RateObservation> rateObservation, decimal? floatingRateMultiplier, decimal? spread, IEnumerable<Strike> capRate, IEnumerable<Strike> floorRate)
        {
            CalculatedRate = calculatedRate;
            RateObservation = rateObservation;
            FloatingRateMultiplier = floatingRateMultiplier;
            Spread = spread;
            CapRate = capRate;
            FloorRate = floorRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateDefinition> MetaData => metaData;
        
        /// <summary>
        /// The final calculated rate for a calculation period after any required averaging of rates A calculated rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal? CalculatedRate { get; }
        
        /// <summary>
        /// The details of a particular rate observation, including the fixing date and observed rate. A list of rate observation elements may be ordered in the document by ascending adjusted fixing date. An FpML document containing an unordered list of rate observations is still regarded as a conformant document.
        /// </summary>
        public IEnumerable<RateObservation> RateObservation { get; }
        
        /// <summary>
        /// A rate multiplier to apply to the floating rate. The multiplier can be a positive or negative decimal. This element should only be included if the multiplier is not equal to 1 (one).
        /// </summary>
        public decimal? FloatingRateMultiplier { get; }
        
        /// <summary>
        /// The ISDA Spread, if any, which applies for the calculation period. The spread is a per annum rate, expressed as a decimal. For purposes of determining a calculation period amount, if positive the spread will be added to the floating rate and if negative the spread will be subtracted from the floating rate. A positive 10 basis point (0.1%) spread would be represented as 0.001.
        /// </summary>
        public decimal? Spread { get; }
        
        /// <summary>
        /// The cap rate, if any, which applies to the floating rate for the calculation period. The cap rate (strike) is only required where the floating rate on a swap stream is capped at a certain strike level. The cap rate is assumed to be exclusive of any spread and is a per annum rate, expressed as a decimal. A cap rate of 5% would be represented as 0.05.
        /// </summary>
        public IEnumerable<Strike> CapRate { get; }
        
        /// <summary>
        /// The floor rate, if any, which applies to the floating rate for the calculation period. The floor rate (strike) is only required where the floating rate on a swap stream is floored at a certain strike level. The floor rate is assumed to be exclusive of any spread and is a per annum rate, expressed as a decimal. The floor rate of 5% would be represented as 0.05.
        /// </summary>
        public IEnumerable<Strike> FloorRate { get; }
    }
    
    /// <summary>
    /// Specification of an interest rate index which can change over time, e.g. the SONIA (Sterling Overnight Index Average) in the UK.
    /// </summary>
    public class FloatingRateIndex : AbstractRosettaModelObject<FloatingRateIndex>, IIndexBase
    {
        private static readonly IRosettaMetaData<FloatingRateIndex> metaData = new FloatingRateIndexMeta();
        
        [JsonConstructor]
        public FloatingRateIndex(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, FieldWithMetaString? name, LegalEntity? provider, Enums.AssetClass? assetClass, FieldWithMetaFloatingRateIndexEnum floatingRateIndex, Period? indexTenor)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            Name = name;
            Provider = provider;
            AssetClass = assetClass;
            FloatingRateIndexValue = floatingRateIndex;
            IndexTenor = indexTenor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndex> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Name { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Provider { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetClass? AssetClass { get; }
        
        /// <summary>
        /// The reference index that is used to specify the floating interest rate.
        /// </summary>
        [JsonProperty(PropertyName = "floatingRateIndex")]
        public FieldWithMetaFloatingRateIndexEnum FloatingRateIndexValue { get; }
        
        /// <summary>
        /// The ISDA Designated Maturity, i.e. the floating rate tenor.
        /// </summary>
        public Period? IndexTenor { get; }
    }
    
    /// <summary>
    /// This holds the rate calculation defaults applicable for a floating rate index.
    /// </summary>
    public class FloatingRateIndexCalculationDefaults : AbstractRosettaModelObject<FloatingRateIndexCalculationDefaults>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexCalculationDefaults> metaData = new FloatingRateIndexCalculationDefaultsMeta();
        
        [JsonConstructor]
        public FloatingRateIndexCalculationDefaults(Enums.FloatingRateIndexCategory? category, Enums.FloatingRateIndexStyle? indexStyle, Enums.FloatingRateIndexCalculationMethod? method, IEnumerable<FloatingRateIndexFixingDetails> fixing, Enums.DayCountFraction? dayCountFraction, BusinessCenters? applicableBusinessDays, Enums.BusinessCenter? publicationCalendar)
        {
            Category = category;
            IndexStyle = indexStyle;
            Method = method;
            Fixing = fixing;
            DayCountFraction = dayCountFraction;
            ApplicableBusinessDays = applicableBusinessDays;
            PublicationCalendar = publicationCalendar;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexCalculationDefaults> MetaData => metaData;
        
        /// <summary>
        /// The ISDA FRO category (e.g. screen rate or calculated rate).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndexCategory? Category { get; }
        
        /// <summary>
        /// The ISDA FRO style (e.g. term rate, swap rate, etc).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndexStyle? IndexStyle { get; }
        
        /// <summary>
        /// The ISDA FRO calculation method (e.g. OIS Compounding).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndexCalculationMethod? Method { get; }
        
        /// <summary>
        /// The default fixing details.
        /// </summary>
        public IEnumerable<FloatingRateIndexFixingDetails> Fixing { get; }
        
        /// <summary>
        /// The default day count fraction.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayCountFraction? DayCountFraction { get; }
        
        /// <summary>
        /// The default applicable business days.
        /// </summary>
        public BusinessCenters? ApplicableBusinessDays { get; }
        
        /// <summary>
        /// Publication Calendar (e.g. EUR-ICESWAP)
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessCenter? PublicationCalendar { get; }
    }
    
    public class FloatingRateIndexDefinition : AbstractRosettaModelObject<FloatingRateIndexDefinition>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexDefinition> metaData = new FloatingRateIndexDefinitionMeta();
        
        [JsonConstructor]
        public FloatingRateIndexDefinition(FloatingRateIndexIdentification fro, FloatingRateIndexCalculationDefaults? calculationDefaults, IEnumerable<ContractualDefinition> supportedDefinition, string? definitionalSource, bool? designatedMaturityApplicable, FloatingRateIndexMappings? mappings, FloatingRateIndexExternalMappings? externalMappings, bool? inLoan, FroHistory? history, string? deprecationReason, string? fpmlDescription)
        {
            Fro = fro;
            CalculationDefaults = calculationDefaults;
            SupportedDefinition = supportedDefinition;
            DefinitionalSource = definitionalSource;
            DesignatedMaturityApplicable = designatedMaturityApplicable;
            Mappings = mappings;
            ExternalMappings = externalMappings;
            InLoan = inLoan;
            History = history;
            DeprecationReason = deprecationReason;
            FpmlDescription = fpmlDescription;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexDefinition> MetaData => metaData;
        
        /// <summary>
        /// The underlying FRO name and designated maturity.
        /// </summary>
        public FloatingRateIndexIdentification Fro { get; }
        
        /// <summary>
        /// Any calculation default values.
        /// </summary>
        public FloatingRateIndexCalculationDefaults? CalculationDefaults { get; }
        
        /// <summary>
        /// The definition version or versions supported by the FRO.
        /// </summary>
        public IEnumerable<ContractualDefinition> SupportedDefinition { get; }
        
        /// <summary>
        /// The source of an FRO, particularly if not a Contractual Definition (e.g. the broker rates matrix).
        /// </summary>
        public string? DefinitionalSource { get; }
        
        public bool? DesignatedMaturityApplicable { get; }
        
        /// <summary>
        /// Any mappings to other FRos.
        /// </summary>
        public FloatingRateIndexMappings? Mappings { get; }
        
        /// <summary>
        /// Any mappings to other codes for this index.
        /// </summary>
        public FloatingRateIndexExternalMappings? ExternalMappings { get; }
        
        /// <summary>
        /// YES / NO to flag FROs identified by the FpML Syndicated Loan WG as having underlying benchmark that may also be referenced in syndicated loans.
        /// </summary>
        public bool? InLoan { get; }
        
        /// <summary>
        /// FRO History
        /// </summary>
        public FroHistory? History { get; }
        
        /// <summary>
        /// Deprecation and Code Descriptions
        /// </summary>
        public string? DeprecationReason { get; }
        
        /// <summary>
        /// FpML Description
        /// </summary>
        public string? FpmlDescription { get; }
    }
    
    /// <summary>
    /// A map for a single FRO to or from an equivalent or similar codes in a different standard such as ISO.
    /// </summary>
    public class FloatingRateIndexExternalMap : AbstractRosettaModelObject<FloatingRateIndexExternalMap>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexExternalMap> metaData = new FloatingRateIndexExternalMapMeta();
        
        [JsonConstructor]
        public FloatingRateIndexExternalMap(string externalId, string? externalStandard)
        {
            ExternalId = externalId;
            ExternalStandard = externalStandard;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexExternalMap> MetaData => metaData;
        
        /// <summary>
        ///  The FRO name that is being mapped to/from.
        /// </summary>
        public string ExternalId { get; }
        
        /// <summary>
        /// The standard/version to which the map applies.
        /// </summary>
        public string? ExternalStandard { get; }
    }
    
    /// <summary>
    /// Represents the mappings of FRO codes to other.
    /// </summary>
    public class FloatingRateIndexExternalMappings : AbstractRosettaModelObject<FloatingRateIndexExternalMappings>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexExternalMappings> metaData = new FloatingRateIndexExternalMappingsMeta();
        
        [JsonConstructor]
        public FloatingRateIndexExternalMappings(FloatingRateIndexExternalMap? isoCode)
        {
            IsoCode = isoCode;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexExternalMappings> MetaData => metaData;
        
        public FloatingRateIndexExternalMap? IsoCode { get; }
    }
    
    /// <summary>
    /// This type holds parameters defining the fixingt time and offset for a floating rate index.
    /// </summary>
    public class FloatingRateIndexFixingDetails : AbstractRosettaModelObject<FloatingRateIndexFixingDetails>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexFixingDetails> metaData = new FloatingRateIndexFixingDetailsMeta();
        
        [JsonConstructor]
        public FloatingRateIndexFixingDetails(FloatingRateIndexFixingTime? fixingTime, BusinessDayOffset? fixingOffset)
        {
            FixingTime = fixingTime;
            FixingOffset = fixingOffset;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexFixingDetails> MetaData => metaData;
        
        /// <summary>
        /// Parameters defining the normal fixing time (can vary by index tenor / designated maturity).
        /// </summary>
        public FloatingRateIndexFixingTime? FixingTime { get; }
        
        /// <summary>
        /// Parameters defining the normal fixing offset (can vary by index tenor / designated maturity).
        /// </summary>
        public BusinessDayOffset? FixingOffset { get; }
    }
    
    /// <summary>
    /// This type holds parameters defining the normal fixing offset for a floating rate index.
    /// </summary>
    public class FloatingRateIndexFixingOffset : AbstractRosettaModelObject<FloatingRateIndexFixingOffset>, IBusinessDayOffset
    {
        private static readonly IRosettaMetaData<FloatingRateIndexFixingOffset> metaData = new FloatingRateIndexFixingOffsetMeta();
        
        [JsonConstructor]
        public FloatingRateIndexFixingOffset(int periodMultiplier, Enums.Period period, _MetaFields? meta, BusinessCenters? businessCenters, string? fixingOffsetDefinition, string? fixingOffsetReason, string? designatedMaturity)
        {
            PeriodMultiplier = periodMultiplier;
            PeriodValue = period;
            Meta = meta;
            BusinessCenters = businessCenters;
            FixingOffsetDefinition = fixingOffsetDefinition;
            FixingOffsetReason = fixingOffsetReason;
            DesignatedMaturity = designatedMaturity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexFixingOffset> MetaData => metaData;
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        public BusinessCenters? BusinessCenters { get; }
        
        /// <inheritdoc/>
        public string? FixingOffsetDefinition { get; }
        
        /// <inheritdoc/>
        public string? FixingOffsetReason { get; }
        
        /// <summary>
        /// Allows a reason to be specified for using the alternative fixing offset.
        /// </summary>
        public string? DesignatedMaturity { get; }
    }
    
    /// <summary>
    /// This type holds parameters defining the normal fixing time for a floating rate index.
    /// </summary>
    public class FloatingRateIndexFixingTime : AbstractRosettaModelObject<FloatingRateIndexFixingTime>, IBusinessCenterTime
    {
        private static readonly IRosettaMetaData<FloatingRateIndexFixingTime> metaData = new FloatingRateIndexFixingTimeMeta();
        
        [JsonConstructor]
        public FloatingRateIndexFixingTime(LocalTime hourMinuteTime, FieldWithMetaBusinessCenterEnum businessCenter, string? designatedMaturity, string? fixingTimeDefinition, string? fixingReason)
        {
            HourMinuteTime = hourMinuteTime;
            BusinessCenter = businessCenter;
            DesignatedMaturity = designatedMaturity;
            FixingTimeDefinition = fixingTimeDefinition;
            FixingReason = fixingReason;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexFixingTime> MetaData => metaData;
        
        /// <inheritdoc/>
        public LocalTime HourMinuteTime { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaBusinessCenterEnum BusinessCenter { get; }
        
        /// <summary>
        /// Allows a designed maturity to be specified for the fixing time.
        /// </summary>
        public string? DesignatedMaturity { get; }
        
        /// <summary>
        /// Legal text that underlies the Fixing Time. ISDA Fixing Time Definition. (e.g. 09:30, Sydney time).
        /// </summary>
        public string? FixingTimeDefinition { get; }
        
        /// <summary>
        /// Fixing Reason
        /// </summary>
        public string? FixingReason { get; }
    }
    
    public class FloatingRateIndexIdentification : AbstractRosettaModelObject<FloatingRateIndexIdentification>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexIdentification> metaData = new FloatingRateIndexIdentificationMeta();
        
        [JsonConstructor]
        public FloatingRateIndexIdentification(FieldWithMetaFloatingRateIndexEnum? floatingRateIndex, Enums.ISOCurrencyCode? currency, string? froType)
        {
            FloatingRateIndex = floatingRateIndex;
            Currency = currency;
            FroType = froType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexIdentification> MetaData => metaData;
        
        /// <summary>
        /// The reference index that is used to specify the floating interest rate. The FpML standard maintains the list of such indices, which are positioned as enumeration values as part of the CDM.
        /// </summary>
        public FieldWithMetaFloatingRateIndexEnum? FloatingRateIndex { get; }
        
        /// <summary>
        /// FRO currency - 3 character ISO currrency code
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ISOCurrencyCode? Currency { get; }
        
        /// <summary>
        /// FRO type (e.g. OIS)
        /// </summary>
        public string? FroType { get; }
    }
    
    /// <summary>
    /// A map for a single FRO to or from an equivalent or similar FRO in a different contractual definitions version.
    /// </summary>
    public class FloatingRateIndexMap : AbstractRosettaModelObject<FloatingRateIndexMap>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexMap> metaData = new FloatingRateIndexMapMeta();
        
        [JsonConstructor]
        public FloatingRateIndexMap(IEnumerable<Enums.FloatingRateIndex> index, ContractualDefinitionIdentifier? contractualDefinitionIdentifier, Identifier? identifier)
        {
            Index = index;
            ContractualDefinitionIdentifier = contractualDefinitionIdentifier;
            Identifier = identifier;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexMap> MetaData => metaData;
        
        /// <summary>
        ///  The FRO name that is being mapped to/from.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.FloatingRateIndex> Index { get; }
        
        /// <summary>
        /// Contractual Definition to which the map applies. Includes Document Type and Document Version
        /// </summary>
        public ContractualDefinitionIdentifier? ContractualDefinitionIdentifier { get; }
        
        /// <summary>
        /// Corresponds to the unique identifier of the Contractual Definition to which the map applies
        /// </summary>
        public Identifier? Identifier { get; }
    }
    
    /// <summary>
    /// This type defines mappings between FROs in different definitional versions.
    /// </summary>
    public class FloatingRateIndexMappings : AbstractRosettaModelObject<FloatingRateIndexMappings>
    {
        private static readonly IRosettaMetaData<FloatingRateIndexMappings> metaData = new FloatingRateIndexMappingsMeta();
        
        [JsonConstructor]
        public FloatingRateIndexMappings(FloatingRateIndexMap? mapsTo, IEnumerable<FloatingRateIndexMap> mapsFrom)
        {
            MapsTo = mapsTo;
            MapsFrom = mapsFrom;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateIndexMappings> MetaData => metaData;
        
        /// <summary>
        /// The successor FRO that this index maps to.
        /// </summary>
        public FloatingRateIndexMap? MapsTo { get; }
        
        /// <summary>
        /// The predecessor FRO(s) that this index maps to.
        /// </summary>
        public IEnumerable<FloatingRateIndexMap> MapsFrom { get; }
    }
    
    /// <summary>
    /// Type for reporting the details of the rate treatment.  This could potentially be replaced by the existing FloatingRateDefinition type , but this is slightly more detailed.
    /// </summary>
    public class FloatingRateProcessingDetails : AbstractRosettaModelObject<FloatingRateProcessingDetails>
    {
        private static readonly IRosettaMetaData<FloatingRateProcessingDetails> metaData = new FloatingRateProcessingDetailsMeta();
        
        [JsonConstructor]
        public FloatingRateProcessingDetails(decimal rawRate, FloatingRateProcessingParameters? processingParameters, decimal processedRate, decimal spreadExclusiveRate)
        {
            RawRate = rawRate;
            ProcessingParameters = processingParameters;
            ProcessedRate = processedRate;
            SpreadExclusiveRate = spreadExclusiveRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateProcessingDetails> MetaData => metaData;
        
        /// <summary>
        /// The raw or untreated rate, prior to any of the rate treatments.
        /// </summary>
        public decimal RawRate { get; }
        
        public FloatingRateProcessingParameters? ProcessingParameters { get; }
        
        /// <summary>
        /// The value of the rate after processing.
        /// </summary>
        public decimal ProcessedRate { get; }
        
        /// <summary>
        /// The value of the processed rate without the spread applied, for subsequent compounding, etc.
        /// </summary>
        public decimal SpreadExclusiveRate { get; }
    }
    
    /// <summary>
    /// Type to hold the processing parameters that should be or were used to calculate a floating amount.  These parameters can vary over a schedule so this type holds the acutal values applicable to this calculation.
    /// </summary>
    public class FloatingRateProcessingParameters : AbstractRosettaModelObject<FloatingRateProcessingParameters>
    {
        private static readonly IRosettaMetaData<FloatingRateProcessingParameters> metaData = new FloatingRateProcessingParametersMeta();
        
        [JsonConstructor]
        public FloatingRateProcessingParameters(Price? initialRate, decimal? multiplier, decimal? spread, Enums.RateTreatment? treatment, decimal? capRate, decimal? floorRate, Rounding? rounding, Enums.NegativeInterestRateTreatment? negativeTreatment)
        {
            InitialRate = initialRate;
            Multiplier = multiplier;
            Spread = spread;
            Treatment = treatment;
            CapRate = capRate;
            FloorRate = floorRate;
            Rounding = rounding;
            NegativeTreatment = negativeTreatment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateProcessingParameters> MetaData => metaData;
        
        /// <summary>
        /// The rate to be applied for the initial period.
        /// </summary>
        public Price? InitialRate { get; }
        
        /// <summary>
        /// floating rate multiplier.
        /// </summary>
        public decimal? Multiplier { get; }
        
        /// <summary>
        /// spread to be added to the floating rate.
        /// </summary>
        public decimal? Spread { get; }
        
        /// <summary>
        /// US rate treatment (Bond Equivalent Yield or Money Market Yield, if applicable.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? Treatment { get; }
        
        /// <summary>
        /// capt to be applied to the floating rate.
        /// </summary>
        public decimal? CapRate { get; }
        
        /// <summary>
        /// floor to be applied to the floating rate.
        /// </summary>
        public decimal? FloorRate { get; }
        
        /// <summary>
        /// THe final rate rounding to be applied.
        /// </summary>
        public Rounding? Rounding { get; }
        
        /// <summary>
        /// How to handle negative interest rates.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NegativeInterestRateTreatment? NegativeTreatment { get; }
    }
    
    /// <summary>
    /// Type for reporting the raw (untreated) observed or calculated rate for a calculation period.  If this is a calculated rate, it allows details of the observations and the resulting rate to be returned.
    /// </summary>
    public class FloatingRateSettingDetails : AbstractRosettaModelObject<FloatingRateSettingDetails>
    {
        private static readonly IRosettaMetaData<FloatingRateSettingDetails> metaData = new FloatingRateSettingDetailsMeta();
        
        [JsonConstructor]
        public FloatingRateSettingDetails(CalculatedRateDetails? calculationDetails, LocalDate? observationDate, LocalDate? resetDate, decimal floatingRate)
        {
            CalculationDetails = calculationDetails;
            ObservationDate = observationDate;
            ResetDate = resetDate;
            FloatingRate = floatingRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateSettingDetails> MetaData => metaData;
        
        /// <summary>
        /// Calculated rate details (observation dates, values, and weights).
        /// </summary>
        public CalculatedRateDetails? CalculationDetails { get; }
        
        /// <summary>
        /// The day upon which the rate was observed (for term rates).
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ObservationDate { get; }
        
        /// <summary>
        /// The day for which the rate is needed (e.g. period beginning or end date).
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ResetDate { get; }
        
        /// <summary>
        /// The resulting rate that was observed or calculated.
        /// </summary>
        public decimal FloatingRate { get; }
    }
    
    /// <summary>
    /// A class to specify the floating interest rate by extending the floating rate definition with a set of attributes that specify such rate: the initial value specified as part of the trade, the rounding convention, the averaging method and the negative interest rate treatment.
    /// </summary>
    public class FloatingRateSpecification : AbstractRosettaModelObject<FloatingRateSpecification>, IFloatingRateSpecification, IFloatingRate
    {
        private static readonly IRosettaMetaData<FloatingRateSpecification> metaData = new FloatingRateSpecificationMeta();
        
        [JsonConstructor]
        public FloatingRateSpecification(ReferenceWithMetaInterestRateIndex? rateOption, SpreadSchedule? spreadSchedule, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, RateSchedule? floatingRateMultiplierSchedule, Enums.RateTreatment? rateTreatment, FloatingRateCalculationParameters? calculationParameters, FallbackRateParameters? fallbackRate, Price? initialRate, Rounding? finalRateRounding, Enums.AveragingWeightingMethod? averagingMethod, Enums.NegativeInterestRateTreatment? negativeInterestRateTreatment)
        {
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            FloatingRateMultiplierSchedule = floatingRateMultiplierSchedule;
            RateTreatment = rateTreatment;
            CalculationParameters = calculationParameters;
            FallbackRate = fallbackRate;
            InitialRate = initialRate;
            FinalRateRounding = finalRateRounding;
            AveragingMethod = averagingMethod;
            NegativeInterestRateTreatment = negativeInterestRateTreatment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FloatingRateSpecification> MetaData => metaData;
        
        public ReferenceWithMetaInterestRateIndex? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        public RateSchedule? FloatingRateMultiplierSchedule { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? RateTreatment { get; }
        
        /// <inheritdoc/>
        public FloatingRateCalculationParameters? CalculationParameters { get; }
        
        /// <inheritdoc/>
        public FallbackRateParameters? FallbackRate { get; }
        
        /// <inheritdoc/>
        public Price? InitialRate { get; }
        
        /// <inheritdoc/>
        public Rounding? FinalRateRounding { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingWeightingMethod? AveragingMethod { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NegativeInterestRateTreatment? NegativeInterestRateTreatment { get; }
    }
    
    /// <summary>
    /// From FpML: A type defining either a spot or forward FX transactions.
    /// </summary>
    public class ForeignExchange : AbstractRosettaModelObject<ForeignExchange>
    {
        private static readonly IRosettaMetaData<ForeignExchange> metaData = new ForeignExchangeMeta();
        
        [JsonConstructor]
        public ForeignExchange(Cashflow exchangedCurrency1, Cashflow exchangedCurrency2, Period? tenorPeriod)
        {
            ExchangedCurrency1 = exchangedCurrency1;
            ExchangedCurrency2 = exchangedCurrency2;
            TenorPeriod = tenorPeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ForeignExchange> MetaData => metaData;
        
        /// <summary>
        /// This is the first of the two currency flows that define a single leg of a standard foreign exchange transaction.
        /// </summary>
        public Cashflow ExchangedCurrency1 { get; }
        
        /// <summary>
        /// This is the second of the two currency flows that define a single leg of a standard foreign exchange transaction.
        /// </summary>
        public Cashflow ExchangedCurrency2 { get; }
        
        /// <summary>
        /// A tenor expressed as a period type and multiplier (e.g. 1D, 1Y, etc.)
        /// </summary>
        public Period? TenorPeriod { get; }
    }
    
    /// <summary>
    /// Specification of a rate based on the exchange of a pair of cash assets in specific currencies, e.g. USD versus GBP.
    /// </summary>
    public class ForeignExchangeRateIndex : AbstractRosettaModelObject<ForeignExchangeRateIndex>, IIndexBase
    {
        private static readonly IRosettaMetaData<ForeignExchangeRateIndex> metaData = new ForeignExchangeRateIndexMeta();
        
        [JsonConstructor]
        public ForeignExchangeRateIndex(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, FieldWithMetaString? name, LegalEntity? provider, Enums.AssetClass? assetClass, FieldWithMetaQuotedCurrencyPair quotedCurrencyPair, InformationSource primaryFxSpotRateSource, InformationSource? secondaryFxSpotRateSource)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            Name = name;
            Provider = provider;
            AssetClass = assetClass;
            QuotedCurrencyPair = quotedCurrencyPair;
            PrimaryFxSpotRateSource = primaryFxSpotRateSource;
            SecondaryFxSpotRateSource = secondaryFxSpotRateSource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ForeignExchangeRateIndex> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Name { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Provider { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetClass? AssetClass { get; }
        
        /// <summary>
        /// Describes the composition of a rate that has been quoted or is to be quoted.
        /// </summary>
        public FieldWithMetaQuotedCurrencyPair QuotedCurrencyPair { get; }
        
        /// <summary>
        /// Specifies the primary source from which a rate should be observed.
        /// </summary>
        public InformationSource PrimaryFxSpotRateSource { get; }
        
        /// <summary>
        /// Specifies an alternative, or secondary, source from which a rate should be observed.
        /// </summary>
        public InformationSource? SecondaryFxSpotRateSource { get; }
    }
    
    /// <summary>
    /// A class to specify party specific elections when a Collateral Transfer Agreement is governed by French Law.
    /// </summary>
    public class FrenchLawAddendum : AbstractRosettaModelObject<FrenchLawAddendum>
    {
        private static readonly IRosettaMetaData<FrenchLawAddendum> metaData = new FrenchLawAddendumMeta();
        
        [JsonConstructor]
        public FrenchLawAddendum(bool isApplicable, IEnumerable<FrenchLawAddendumElection> partyElection)
        {
            IsApplicable = isApplicable;
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FrenchLawAddendum> MetaData => metaData;
        
        /// <summary>
        /// The qualification of whether the French Law Addendum is deemed applicable by the parties (True) or not (False).
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The parties French Law Addendum Elections.
        /// </summary>
        public IEnumerable<FrenchLawAddendumElection> PartyElection { get; }
    }
    
    /// <summary>
    /// A class to specify party specific French Law Addendum language.
    /// </summary>
    public class FrenchLawAddendumElection : AbstractRosettaModelObject<FrenchLawAddendumElection>
    {
        private static readonly IRosettaMetaData<FrenchLawAddendumElection> metaData = new FrenchLawAddendumElectionMeta();
        
        [JsonConstructor]
        public FrenchLawAddendumElection(Enums.CounterpartyRole party, bool isApplicable, string? addendumLanguage)
        {
            Party = party;
            IsApplicable = isApplicable;
            AddendumLanguage = addendumLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FrenchLawAddendumElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The qualification of whether the party elects specific language.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The party specific language to be included in the agreement.
        /// </summary>
        public string? AddendumLanguage { get; }
    }
    
    /// <summary>
    /// A class for defining a date frequency, e.g. one day, three months, through the combination of an integer value and a standardized period value that is specified as part of an enumeration.
    /// </summary>
    public class Frequency : AbstractRosettaModelObject<Frequency>, IFrequency
    {
        private static readonly IRosettaMetaData<Frequency> metaData = new FrequencyMeta();
        
        [JsonConstructor]
        public Frequency(int periodMultiplier, Enums.PeriodExtended period, _MetaFields? meta)
        {
            PeriodMultiplier = periodMultiplier;
            Period = period;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Frequency> MetaData => metaData;
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PeriodExtended Period { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// FRO History
    /// </summary>
    public class FroHistory : AbstractRosettaModelObject<FroHistory>
    {
        private static readonly IRosettaMetaData<FroHistory> metaData = new FroHistoryMeta();
        
        [JsonConstructor]
        public FroHistory(LocalDate? startDate, ContractualDefinition? firstDefinedIn, LocalDate? updateDate, ContractualDefinition? lastUpdatedIn, LocalDate? endDate)
        {
            StartDate = startDate;
            FirstDefinedIn = firstDefinedIn;
            UpdateDate = updateDate;
            LastUpdatedIn = lastUpdatedIn;
            EndDate = endDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FroHistory> MetaData => metaData;
        
        /// <summary>
        /// The date the Floating Rate Option was added to the 2006 Definitions or 2021 Floating Rate Matrix. (e.g. 2017/04/06)
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? StartDate { get; }
        
        /// <summary>
        /// The supplement or version the FRO was first added to the 2006 Definitions or 2021 Floating Rate Matrix. (e.g. S52)
        /// </summary>
        public ContractualDefinition? FirstDefinedIn { get; }
        
        /// <summary>
        /// The date the Floating Rate Option was last updated in the 2006 Definitions or 2021 Floating Rate Matrix. (e.g. 2021/06/11)
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UpdateDate { get; }
        
        /// <summary>
        /// The supplement or version the FRO was last updated in the 2006 Definitions or 2021 Floating Rate Matrix. (e.g. FRO-M-V1)
        /// </summary>
        public ContractualDefinition? LastUpdatedIn { get; }
        
        /// <summary>
        /// The date the Floating Rate Option was removed from the 2006 Definitions or 2021 Floating Rate Matrix. (e.g. 2014/01/01)
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EndDate { get; }
    }
    
    /// <summary>
    /// A class defining a currency and a future value date.
    /// </summary>
    public class FutureValueAmount : AbstractRosettaModelObject<FutureValueAmount>
    {
        private static readonly IRosettaMetaData<FutureValueAmount> metaData = new FutureValueAmountMeta();
        
        [JsonConstructor]
        public FutureValueAmount(ReferenceWithMetaNonNegativeQuantitySchedule? quantity, FieldWithMetaString currency, int calculationPeriodNumberOfDays, LocalDate valueDate)
        {
            Quantity = quantity;
            Currency = currency;
            CalculationPeriodNumberOfDays = calculationPeriodNumberOfDays;
            ValueDate = valueDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FutureValueAmount> MetaData => metaData;
        
        public ReferenceWithMetaNonNegativeQuantitySchedule? Quantity { get; }
        
        /// <summary>
        /// The currency in which the an amount is denominated. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString Currency { get; }
        
        /// <summary>
        /// The number of days from the adjusted calculation period start date to the adjusted value date, calculated in accordance with the applicable day count fraction.
        /// </summary>
        public int CalculationPeriodNumberOfDays { get; }
        
        /// <summary>
        /// Adjusted value date of the future value amount.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ValueDate { get; }
    }
    
    /// <summary>
    /// TransactionAdditionalTerms which apply to the CurrencyPair asset class.
    /// </summary>
    public class FxAdditionalTerms : AbstractRosettaModelObject<FxAdditionalTerms>
    {
        private static readonly IRosettaMetaData<FxAdditionalTerms> metaData = new FxAdditionalTermsMeta();
        
        [JsonConstructor]
        public FxAdditionalTerms(FxDisruptionEvents? disruptionEvents, DeterminationRolesAndTerms? determinationTerms, bool? noFaultTermination)
        {
            DisruptionEvents = disruptionEvents;
            DeterminationTerms = determinationTerms;
            NoFaultTermination = noFaultTermination;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxAdditionalTerms> MetaData => metaData;
        
        public FxDisruptionEvents? DisruptionEvents { get; }
        
        public DeterminationRolesAndTerms? DeterminationTerms { get; }
        
        public bool? NoFaultTermination { get; }
    }
    
    public class FxBenchmarkObligationDefault : AbstractRosettaModelObject<FxBenchmarkObligationDefault>
    {
        private static readonly IRosettaMetaData<FxBenchmarkObligationDefault> metaData = new FxBenchmarkObligationDefaultMeta();
        
        [JsonConstructor]
        public FxBenchmarkObligationDefault(bool benchmarkObligationDefaultIsApplicable, Enums.FxSubstitutionProvisionType? localSubstituteProvisionType, Enums.SpecifiedValue? specifiedValue, EscrowArrangement? escrowArrangement)
        {
            BenchmarkObligationDefaultIsApplicable = benchmarkObligationDefaultIsApplicable;
            LocalSubstituteProvisionType = localSubstituteProvisionType;
            SpecifiedValue = specifiedValue;
            EscrowArrangement = escrowArrangement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxBenchmarkObligationDefault> MetaData => metaData;
        
        public bool BenchmarkObligationDefaultIsApplicable { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FxSubstitutionProvisionType? LocalSubstituteProvisionType { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SpecifiedValue? SpecifiedValue { get; }
        
        public EscrowArrangement? EscrowArrangement { get; }
    }
    
    /// <summary>
    /// Additional Provisions for a Confirmation of an FX or Currency Option Transaction
    /// </summary>
    public class FxDisruptionEvents : AbstractRosettaModelObject<FxDisruptionEvents>
    {
        private static readonly IRosettaMetaData<FxDisruptionEvents> metaData = new FxDisruptionEventsMeta();
        
        [JsonConstructor]
        public FxDisruptionEvents(Enums.FxIllegalityOrImpossibility? illegalityOrImpossibility, Enums.FxForceMajeureOrActOfSState? forceMajeureOrActOfSState, EventCurrency? eventCurrency, FxPriceSourceDisruption? priceSourceDisruption, FxBenchmarkObligationDefault? benchmarkObligationDefault, FxDualExchangeRate? dualExchangeRate, FxInconvertibilityOrNonTransferability? inconvertibilityOrNonTransferability, GovernmentalAuthorityDefault? governmentalAuthorityDefault, Illiquidity? illiquidity, MaterialChangeInCircumstance? materialChangeInCircumstance, Nationalization? nationalization, PriceMateriality? priceMateriality, Clause? fallbackLanguageBespokeTerms)
        {
            IllegalityOrImpossibility = illegalityOrImpossibility;
            ForceMajeureOrActOfSState = forceMajeureOrActOfSState;
            EventCurrency = eventCurrency;
            PriceSourceDisruption = priceSourceDisruption;
            BenchmarkObligationDefault = benchmarkObligationDefault;
            DualExchangeRate = dualExchangeRate;
            InconvertibilityOrNonTransferability = inconvertibilityOrNonTransferability;
            GovernmentalAuthorityDefault = governmentalAuthorityDefault;
            Illiquidity = illiquidity;
            MaterialChangeInCircumstance = materialChangeInCircumstance;
            Nationalization = nationalization;
            PriceMateriality = priceMateriality;
            FallbackLanguageBespokeTerms = fallbackLanguageBespokeTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxDisruptionEvents> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FxIllegalityOrImpossibility? IllegalityOrImpossibility { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FxForceMajeureOrActOfSState? ForceMajeureOrActOfSState { get; }
        
        /// <summary>
        /// Additional Provisions for a Confirmation of an FX or Currency Option Transaction.
        /// </summary>
        public EventCurrency? EventCurrency { get; }
        
        public FxPriceSourceDisruption? PriceSourceDisruption { get; }
        
        public FxBenchmarkObligationDefault? BenchmarkObligationDefault { get; }
        
        public FxDualExchangeRate? DualExchangeRate { get; }
        
        public FxInconvertibilityOrNonTransferability? InconvertibilityOrNonTransferability { get; }
        
        public GovernmentalAuthorityDefault? GovernmentalAuthorityDefault { get; }
        
        public Illiquidity? Illiquidity { get; }
        
        public MaterialChangeInCircumstance? MaterialChangeInCircumstance { get; }
        
        public Nationalization? Nationalization { get; }
        
        public PriceMateriality? PriceMateriality { get; }
        
        /// <summary>
        /// Where parties may optionaly describe any extra bespoke agreements about fallback procedure attached to a particular determination role.
        /// </summary>
        public Clause? FallbackLanguageBespokeTerms { get; }
    }
    
    public class FxDualExchangeRate : AbstractRosettaModelObject<FxDualExchangeRate>
    {
        private static readonly IRosettaMetaData<FxDualExchangeRate> metaData = new FxDualExchangeRateMeta();
        
        [JsonConstructor]
        public FxDualExchangeRate(bool dualExchangeRateIsApplicable, FallbackReferencePrice? fallbackReferencePrice, EscrowArrangement? escrowArrangement)
        {
            DualExchangeRateIsApplicable = dualExchangeRateIsApplicable;
            FallbackReferencePrice = fallbackReferencePrice;
            EscrowArrangement = escrowArrangement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxDualExchangeRate> MetaData => metaData;
        
        public bool DualExchangeRateIsApplicable { get; }
        
        /// <summary>
        /// The method, prioritised by the order it is listed in this element, to get a replacement rate for the disrupted settlement rate option.
        /// </summary>
        public FallbackReferencePrice? FallbackReferencePrice { get; }
        
        public EscrowArrangement? EscrowArrangement { get; }
    }
    
    /// <summary>
    /// A type for defining FX Features.
    /// </summary>
    public class FxFeature : AbstractRosettaModelObject<FxFeature>
    {
        private static readonly IRosettaMetaData<FxFeature> metaData = new FxFeatureMeta();
        
        [JsonConstructor]
        public FxFeature(FieldWithMetaString referenceCurrency, Composite? composite, Quanto? quanto, Composite? crossCurrency)
        {
            ReferenceCurrency = referenceCurrency;
            Composite = composite;
            Quanto = quanto;
            CrossCurrency = crossCurrency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxFeature> MetaData => metaData;
        
        /// <summary>
        /// Specifies the reference currency of the trade.
        /// </summary>
        public FieldWithMetaString ReferenceCurrency { get; }
        
        /// <summary>
        /// If &apos;Composite&apos; is specified as the Settlement Type in the relevant Transaction Supplement, an amount in the Settlement Currency, determined by the Calculation Agent as being equal to the number of Options exercised or deemed exercised, multiplied by: (Settlement Price – Strike Price) / (Strike Price – Settlement Price) x Multiplier provided that if the above is equal to a negative amount the Option Cash Settlement Amount shall be deemed to be zero.
        /// </summary>
        public Composite? Composite { get; }
        
        /// <summary>
        /// If &apos;Quanto&apos; is specified as the Settlement Type in the relevant Transaction Supplement, an amount, as determined by the Calculation Agent in accordance with the Section 8.2 of the Equity Definitions.
        /// </summary>
        public Quanto? Quanto { get; }
        
        /// <summary>
        /// If &apos;Cross-Currency&apos; is specified as the Settlement Type in the relevant Transaction Supplement, an amount in the Settlement Currency, determined by the Calculation Agent as being equal to the number of Options exercised or deemed exercised, multiplied by: (Settlement Price – Strike Price) / (Strike Price – Settlement Price) x Multiplier x one unit of the Reference Currency converted into an amount in the Settlement Currency using the rate of exchange of the Settlement Currency as quoted on the Reference Price Source on the Valuation Date, provided that if the above is equal to a negative amount the Option Cash Settlement Amount shall be deemed to be zero.
        /// </summary>
        public Composite? CrossCurrency { get; }
    }
    
    /// <summary>
    /// Extends the Offset structure to specify an FX fixing date as an offset to dates specified somewhere else in the document.
    /// </summary>
    public class FxFixingDate : AbstractRosettaModelObject<FxFixingDate>, IOffset
    {
        private static readonly IRosettaMetaData<FxFixingDate> metaData = new FxFixingDateMeta();
        
        [JsonConstructor]
        public FxFixingDate(int periodMultiplier, Enums.Period period, _MetaFields? meta, Enums.DayType? dayType, Enums.BusinessDayConvention? businessDayConvention, BusinessCenters? businessCenters, ReferenceWithMetaBusinessCenters? businessCentersReference, DateRelativeToPaymentDates? dateRelativeToPaymentDates, DateRelativeToCalculationPeriodDates? dateRelativeToCalculationPeriodDates, DateRelativeToValuationDates? dateRelativeToValuationDates, AdjustableOrRelativeDate? fxFixingDate)
        {
            PeriodMultiplier = periodMultiplier;
            PeriodValue = period;
            Meta = meta;
            DayType = dayType;
            BusinessDayConvention = businessDayConvention;
            BusinessCenters = businessCenters;
            BusinessCentersReference = businessCentersReference;
            DateRelativeToPaymentDates = dateRelativeToPaymentDates;
            DateRelativeToCalculationPeriodDates = dateRelativeToCalculationPeriodDates;
            DateRelativeToValuationDates = dateRelativeToValuationDates;
            FxFixingDateValue = fxFixingDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxFixingDate> MetaData => metaData;
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
        
        /// <summary>
        /// The convention for adjusting a date if it would otherwise fall on a day that is not a business day, as specified by an ISDA convention (e.g. Following, Precedent).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.BusinessDayConvention? BusinessDayConvention { get; }
        
        public BusinessCenters? BusinessCenters { get; }
        
        /// <summary>
        /// A reference to a set of financial business centers defined elsewhere in the document. This set of business centers is used to determine whether a particular day is a business day or not.
        /// </summary>
        public ReferenceWithMetaBusinessCenters? BusinessCentersReference { get; }
        
        /// <summary>
        /// The payment date references on which settlements in non-deliverable currency are due and will then have to be converted according to the terms specified through the other parts of the nonDeliverableSettlement structure.
        /// </summary>
        public DateRelativeToPaymentDates? DateRelativeToPaymentDates { get; }
        
        /// <summary>
        /// The calculation period references on which settlements in non-deliverable currency are due and will then have to be converted according to the terms specified through the other parts of the nonDeliverableSettlement structure. Implemented for Brazilian-CDI swaps where it will refer to the termination date of the appropriate leg.
        /// </summary>
        public DateRelativeToCalculationPeriodDates? DateRelativeToCalculationPeriodDates { get; }
        
        /// <summary>
        /// The calculation period references on which settlements in non-deliverable currency are due and will then have to be converted according to the terms specified through the other parts of the nonDeliverableSettlement structure. Implemented for Brazilian-CDI swaps where it will refer to the termination date of the appropriate leg.
        /// </summary>
        public DateRelativeToValuationDates? DateRelativeToValuationDates { get; }
        
        /// <summary>
        /// Describes the specific date when a non-deliverable forward or cash-settled option will &apos;fix&apos; against a particular rate, which will be used to compute the ultimate cash settlement. This element should be omitted where a single, discrete fixing date cannot be identified e.g. on an american option, where fixing may occur at any date on a continuous range.  This attribute was formerly part of &apos;fxSettlementTerms&apos;, which is now being harmonised into a common &apos;CashSettlementTerms&apos; that includes a &apos;ValuationDate&apos;.
        /// </summary>
        [JsonProperty(PropertyName = "fxFixingDate")]
        public AdjustableOrRelativeDate? FxFixingDateValue { get; }
    }
    
    /// <summary>
    /// A class to specify the reference currency for the purpose of specifying the FX Haircut relating to a posting obligation, as being either the Termination Currency or an FX Designated Currency.
    /// </summary>
    public class FxHaircutCurrency : AbstractRosettaModelObject<FxHaircutCurrency>
    {
        private static readonly IRosettaMetaData<FxHaircutCurrency> metaData = new FxHaircutCurrencyMeta();
        
        [JsonConstructor]
        public FxHaircutCurrency(bool isTerminationCurrency, FieldWithMetaString? fxDesignatedCurrency)
        {
            IsTerminationCurrency = isTerminationCurrency;
            FxDesignatedCurrency = fxDesignatedCurrency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxHaircutCurrency> MetaData => metaData;
        
        /// <summary>
        /// The reference currency for the purpose of specifying the FX Haircut relating to a posting obligation is the Termination Currency when the Boolean value is set to True.
        /// </summary>
        public bool IsTerminationCurrency { get; }
        
        /// <summary>
        /// When specified, the reference currency for the purpose of specifying the FX Haircut relating to a posting obligation. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? FxDesignatedCurrency { get; }
    }
    
    public class FxInconvertibilityOrNonTransferability : AbstractRosettaModelObject<FxInconvertibilityOrNonTransferability>
    {
        private static readonly IRosettaMetaData<FxInconvertibilityOrNonTransferability> metaData = new FxInconvertibilityOrNonTransferabilityMeta();
        
        [JsonConstructor]
        public FxInconvertibilityOrNonTransferability(GeneralInconvertibility? generalInconvertibility, GeneralNonTransferability? generalNonTransferability, SpecificInconvertibility? specificInconvertibility, SpecificNonTransferability? specificNonTransferability)
        {
            GeneralInconvertibility = generalInconvertibility;
            GeneralNonTransferability = generalNonTransferability;
            SpecificInconvertibility = specificInconvertibility;
            SpecificNonTransferability = specificNonTransferability;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxInconvertibilityOrNonTransferability> MetaData => metaData;
        
        public GeneralInconvertibility? GeneralInconvertibility { get; }
        
        public GeneralNonTransferability? GeneralNonTransferability { get; }
        
        public SpecificInconvertibility? SpecificInconvertibility { get; }
        
        public SpecificNonTransferability? SpecificNonTransferability { get; }
    }
    
    /// <summary>
    /// Information source specific to Foreign Exchange products.
    /// </summary>
    public class FxInformationSource : AbstractRosettaModelObject<FxInformationSource>, IInformationSource
    {
        private static readonly IRosettaMetaData<FxInformationSource> metaData = new FxInformationSourceMeta();
        
        [JsonConstructor]
        public FxInformationSource(FieldWithMetaInformationProviderEnum sourceProvider, FieldWithMetaString? sourcePage, string? sourcePageHeading, BusinessCenterTime? fixingTime)
        {
            SourceProvider = sourceProvider;
            SourcePage = sourcePage;
            SourcePageHeading = sourcePageHeading;
            FixingTime = fixingTime;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxInformationSource> MetaData => metaData;
        
        /// <inheritdoc/>
        public FieldWithMetaInformationProviderEnum SourceProvider { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? SourcePage { get; }
        
        /// <inheritdoc/>
        public string? SourcePageHeading { get; }
        
        /// <summary>
        /// The time that the fixing will be taken along with a business center to define the time zone.
        /// </summary>
        public BusinessCenterTime? FixingTime { get; }
    }
    
    /// <summary>
    /// A data to:  describe the cashflow representation for FX linked notionals.
    /// </summary>
    public class FxLinkedNotionalAmount : AbstractRosettaModelObject<FxLinkedNotionalAmount>
    {
        private static readonly IRosettaMetaData<FxLinkedNotionalAmount> metaData = new FxLinkedNotionalAmountMeta();
        
        [JsonConstructor]
        public FxLinkedNotionalAmount(LocalDate? resetDate, LocalDate? adjustedFxSpotFixingDate, decimal? observedFxSpotRate, decimal? notionalAmount)
        {
            ResetDate = resetDate;
            AdjustedFxSpotFixingDate = adjustedFxSpotFixingDate;
            ObservedFxSpotRate = observedFxSpotRate;
            NotionalAmount = notionalAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxLinkedNotionalAmount> MetaData => metaData;
        
        /// <summary>
        /// The reset date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? ResetDate { get; }
        
        /// <summary>
        /// The date on which the FX spot rate is observed. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedFxSpotFixingDate { get; }
        
        /// <summary>
        /// The actual observed FX spot rate.
        /// </summary>
        public decimal? ObservedFxSpotRate { get; }
        
        /// <summary>
        /// The calculation period notional amount.
        /// </summary>
        public decimal? NotionalAmount { get; }
    }
    
    /// <summary>
    /// A data to:  describe a notional schedule where each notional that applies to a calculation period is calculated with reference to a notional amount or notional amount schedule in a different currency by means of a spot currency exchange rate which is normally observed at the beginning of each period.
    /// </summary>
    public class FxLinkedNotionalSchedule : AbstractRosettaModelObject<FxLinkedNotionalSchedule>
    {
        private static readonly IRosettaMetaData<FxLinkedNotionalSchedule> metaData = new FxLinkedNotionalScheduleMeta();
        
        [JsonConstructor]
        public FxLinkedNotionalSchedule(FieldWithMetaString varyingNotionalCurrency, RelativeDateOffset varyingNotionalFixingDates, FxSpotRateSource fxSpotRateSource, BusinessCenterTime? fixingTime, RelativeDateOffset varyingNotionalInterimExchangePaymentDates)
        {
            VaryingNotionalCurrency = varyingNotionalCurrency;
            VaryingNotionalFixingDates = varyingNotionalFixingDates;
            FxSpotRateSource = fxSpotRateSource;
            FixingTime = fixingTime;
            VaryingNotionalInterimExchangePaymentDates = varyingNotionalInterimExchangePaymentDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxLinkedNotionalSchedule> MetaData => metaData;
        
        /// <summary>
        /// The currency of the varying notional amount, i.e. the notional amount being determined periodically based on observation of a spot currency exchange rate. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString VaryingNotionalCurrency { get; }
        
        /// <summary>
        /// The dates on which spot currency exchange rates are observed for purposes of determining the varying notional currency amount that will apply to a calculation period.
        /// </summary>
        public RelativeDateOffset VaryingNotionalFixingDates { get; }
        
        /// <summary>
        /// The information source and time at which the spot currency exchange rate will be observed.
        /// </summary>
        public FxSpotRateSource FxSpotRateSource { get; }
        
        /// <summary>
        /// The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.
        /// </summary>
        public BusinessCenterTime? FixingTime { get; }
        
        /// <summary>
        /// The dates on which interim exchanges of notional are paid. Interim exchanges will arise as a result of changes in the spot currency exchange amount or changes in the constant notional schedule (e.g. amortisation).
        /// </summary>
        public RelativeDateOffset VaryingNotionalInterimExchangePaymentDates { get; }
    }
    
    public class FxPriceSourceDisruption : AbstractRosettaModelObject<FxPriceSourceDisruption>
    {
        private static readonly IRosettaMetaData<FxPriceSourceDisruption> metaData = new FxPriceSourceDisruptionMeta();
        
        [JsonConstructor]
        public FxPriceSourceDisruption(bool priceSourceDisruptionIsApplicable, SettlementRateOption? fallbackReferencePrice, EscrowArrangement? escrowArrangement)
        {
            PriceSourceDisruptionIsApplicable = priceSourceDisruptionIsApplicable;
            FallbackReferencePrice = fallbackReferencePrice;
            EscrowArrangement = escrowArrangement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxPriceSourceDisruption> MetaData => metaData;
        
        public bool PriceSourceDisruptionIsApplicable { get; }
        
        /// <summary>
        /// The method, prioritised by the order it is listed in this element, to get a replacement rate for the disrupted settlement rate option.
        /// </summary>
        public SettlementRateOption? FallbackReferencePrice { get; }
        
        public EscrowArrangement? EscrowArrangement { get; }
    }
    
    /// <summary>
    /// A class describing the rate of a currency conversion: pair of currency, quotation mode and exchange rate.
    /// </summary>
    public class FxRate : AbstractRosettaModelObject<FxRate>
    {
        private static readonly IRosettaMetaData<FxRate> metaData = new FxRateMeta();
        
        [JsonConstructor]
        public FxRate(QuotedCurrencyPair quotedCurrencyPair, decimal? rate)
        {
            QuotedCurrencyPair = quotedCurrencyPair;
            Rate = rate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxRate> MetaData => metaData;
        
        /// <summary>
        /// Defines the two currencies for an FX trade and the quotation relationship between the two currencies.
        /// </summary>
        public QuotedCurrencyPair QuotedCurrencyPair { get; }
        
        /// <summary>
        /// The rate of exchange between the two currencies of the leg of a deal. Must be specified with a quote basis.
        /// </summary>
        public decimal? Rate { get; }
    }
    
    /// <summary>
    /// Describes a rate source to be fixed and the date the fixing occurs
    /// </summary>
    public class FxRateSourceFixing : AbstractRosettaModelObject<FxRateSourceFixing>
    {
        private static readonly IRosettaMetaData<FxRateSourceFixing> metaData = new FxRateSourceFixingMeta();
        
        [JsonConstructor]
        public FxRateSourceFixing(FxSettlementRateSource settlementRateSource, AdjustableDate fixingDate)
        {
            SettlementRateSource = settlementRateSource;
            FixingDate = fixingDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxRateSourceFixing> MetaData => metaData;
        
        public FxSettlementRateSource SettlementRateSource { get; }
        
        /// <summary>
        /// The date on which the fixing is scheduled to occur.
        /// </summary>
        public AdjustableDate FixingDate { get; }
    }
    
    /// <summary>
    /// The source of the Foreign Exchange settlement rate.
    /// </summary>
    public class FxSettlementRateSource : AbstractRosettaModelObject<FxSettlementRateSource>
    {
        private static readonly IRosettaMetaData<FxSettlementRateSource> metaData = new FxSettlementRateSourceMeta();
        
        [JsonConstructor]
        public FxSettlementRateSource(FieldWithMetaString? settlementRateOption, FxInformationSource? nonstandardSettlementRate)
        {
            SettlementRateOption = settlementRateOption;
            NonstandardSettlementRate = nonstandardSettlementRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxSettlementRateSource> MetaData => metaData;
        
        /// <summary>
        /// Indicates that an officially defined rate settlement rate option will be the used for the fixing.
        /// </summary>
        public FieldWithMetaString? SettlementRateOption { get; }
        
        /// <summary>
        /// Indicates that a non-standard rate source will be used for the fixing.
        /// </summary>
        public FxInformationSource? NonstandardSettlementRate { get; }
    }
    
    /// <summary>
    /// A class defining the rate source and fixing time for an FX rate.
    /// </summary>
    public class FxSpotRateSource : AbstractRosettaModelObject<FxSpotRateSource>
    {
        private static readonly IRosettaMetaData<FxSpotRateSource> metaData = new FxSpotRateSourceMeta();
        
        [JsonConstructor]
        public FxSpotRateSource(InformationSource primarySource, InformationSource? secondarySource)
        {
            PrimarySource = primarySource;
            SecondarySource = secondarySource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<FxSpotRateSource> MetaData => metaData;
        
        /// <summary>
        /// The primary source for where the rate observation will occur. Will typically be either a page or a reference bank published rate.
        /// </summary>
        public InformationSource PrimarySource { get; }
        
        /// <summary>
        /// An alternative, or secondary, source for where the rate observation will occur. Will typically be either a page or a reference bank published rate.
        /// </summary>
        public InformationSource? SecondarySource { get; }
    }
    
    public class GeneralInconvertibility : AbstractRosettaModelObject<GeneralInconvertibility>
    {
        private static readonly IRosettaMetaData<GeneralInconvertibility> metaData = new GeneralInconvertibilityMeta();
        
        [JsonConstructor]
        public GeneralInconvertibility(bool generalInconvertibilityIsApplicable, Enums.FxSubstitutionProvisionType? localSubstituteProvisionType, ValuationPostponement? maximumDaysOfDisruption, NonDeliverableSubstitute? nonDeliverableSubstitute, EscrowArrangement? escrowArrangement)
        {
            GeneralInconvertibilityIsApplicable = generalInconvertibilityIsApplicable;
            LocalSubstituteProvisionType = localSubstituteProvisionType;
            MaximumDaysOfDisruption = maximumDaysOfDisruption;
            NonDeliverableSubstitute = nonDeliverableSubstitute;
            EscrowArrangement = escrowArrangement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GeneralInconvertibility> MetaData => metaData;
        
        public bool GeneralInconvertibilityIsApplicable { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FxSubstitutionProvisionType? LocalSubstituteProvisionType { get; }
        
        /// <summary>
        /// Specifies how long to wait to get a quote from a settlement rate option upon a price source disruption.
        /// </summary>
        public ValuationPostponement? MaximumDaysOfDisruption { get; }
        
        public NonDeliverableSubstitute? NonDeliverableSubstitute { get; }
        
        /// <summary>
        /// Refers to the segregation deposit procedure parties may want to commmit into during the time a Disruption Event is effective
        /// </summary>
        public EscrowArrangement? EscrowArrangement { get; }
    }
    
    public class GeneralNonTransferability : AbstractRosettaModelObject<GeneralNonTransferability>
    {
        private static readonly IRosettaMetaData<GeneralNonTransferability> metaData = new GeneralNonTransferabilityMeta();
        
        [JsonConstructor]
        public GeneralNonTransferability(bool generalNonTransferabilityIsApplicable, Enums.FxSubstitutionProvisionType? localSubstituteProvisionType, ValuationPostponement? maximumDaysOfDisruption, NonDeliverableSubstitute? nonDeliverableSubstitute, EscrowArrangement? escrowArrangement)
        {
            GeneralNonTransferabilityIsApplicable = generalNonTransferabilityIsApplicable;
            LocalSubstituteProvisionType = localSubstituteProvisionType;
            MaximumDaysOfDisruption = maximumDaysOfDisruption;
            NonDeliverableSubstitute = nonDeliverableSubstitute;
            EscrowArrangement = escrowArrangement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GeneralNonTransferability> MetaData => metaData;
        
        public bool GeneralNonTransferabilityIsApplicable { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FxSubstitutionProvisionType? LocalSubstituteProvisionType { get; }
        
        /// <summary>
        /// Specifies how long to wait to get a quote from a settlement rate option upon a price source disruption.
        /// </summary>
        public ValuationPostponement? MaximumDaysOfDisruption { get; }
        
        public NonDeliverableSubstitute? NonDeliverableSubstitute { get; }
        
        /// <summary>
        /// Refers to the segregation deposit procedure parties may want to commmit into during the time a Disruption Event is effective
        /// </summary>
        public EscrowArrangement? EscrowArrangement { get; }
    }
    
    /// <summary>
    /// A class to specify the ISDA SIMM as the Method for all Covered Transactions with respect to all Regimes.
    /// </summary>
    public class GeneralSimmElections : AbstractRosettaModelObject<GeneralSimmElections>
    {
        private static readonly IRosettaMetaData<GeneralSimmElections> metaData = new GeneralSimmElectionsMeta();
        
        [JsonConstructor]
        public GeneralSimmElections(SimmVersion? simmVersion, SimmCalculationCurrency simmCalculationCurrency)
        {
            SimmVersion = simmVersion;
            SimmCalculationCurrency = simmCalculationCurrency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GeneralSimmElections> MetaData => metaData;
        
        /// <summary>
        /// The qualification of the ISDA SIMM version that is specified for all Covered Transactions.
        /// </summary>
        public SimmVersion? SimmVersion { get; }
        
        /// <summary>
        /// The SIMM Calculation Currency, as specified for each of the parties to the CSA Initial Margin.
        /// </summary>
        public SimmCalculationCurrency SimmCalculationCurrency { get; }
    }
    
    /// <summary>
    ///  A class specifying a set of non-monetary terms for the Credit Derivative Transaction, including the buyer and seller and selected items from the ISDA 2014 Credit Definition article II, such as the reference obligation and related terms. The CDM GeneralTerms class corresponds to the FpML GeneralTerms complex type, except that the effectiveDate and scheduledTerminationDate have been positioned as part of the InterestRatePayout class in the CDM instead of in GeneralTerms.
    /// </summary>
    public class GeneralTerms : AbstractRosettaModelObject<GeneralTerms>
    {
        private static readonly IRosettaMetaData<GeneralTerms> metaData = new GeneralTermsMeta();
        
        [JsonConstructor]
        public GeneralTerms(ReferenceInformation? referenceInformation, CreditIndex? indexReferenceInformation, BasketReferenceInformation? basketReferenceInformation, IEnumerable<FieldWithMetaString> additionalTerm, bool? substitution, bool? modifiedEquityDelivery)
        {
            ReferenceInformation = referenceInformation;
            IndexReferenceInformation = indexReferenceInformation;
            BasketReferenceInformation = basketReferenceInformation;
            AdditionalTerm = additionalTerm;
            Substitution = substitution;
            ModifiedEquityDelivery = modifiedEquityDelivery;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GeneralTerms> MetaData => metaData;
        
        /// <summary>
        /// This attribute contains all the terms relevant to defining the reference entity and reference obligation(s).
        /// </summary>
        public ReferenceInformation? ReferenceInformation { get; }
        
        /// <summary>
        /// This attribute contains all the terms relevant to the underlying Index.
        /// </summary>
        public CreditIndex? IndexReferenceInformation { get; }
        
        /// <summary>
        /// This attribute contains all the terms relevant to defining the Credit Default Swap Basket.
        /// </summary>
        public BasketReferenceInformation? BasketReferenceInformation { get; }
        
        /// <summary>
        /// This attribute is used for representing information contained in the Additional Terms field of the 2003 Master Credit Derivatives confirm.
        /// </summary>
        public IEnumerable<FieldWithMetaString> AdditionalTerm { get; }
        
        /// <summary>
        /// Value of this attribute set to &apos;true&apos; indicates that substitution is applicable.
        /// </summary>
        public bool? Substitution { get; }
        
        /// <summary>
        /// Value of this attribute set to &apos;true&apos; indicates that modified equity delivery is applicable.
        /// </summary>
        public bool? ModifiedEquityDelivery { get; }
    }
    
    /// <summary>
    /// The set of elections that define a GMRA
    /// </summary>
    public class GlobalMasterRepoAgreement : AbstractRosettaModelObject<GlobalMasterRepoAgreement>, IMasterAgreementBase
    {
        private static readonly IRosettaMetaData<GlobalMasterRepoAgreement> metaData = new GlobalMasterRepoAgreementMeta();
        
        [JsonConstructor]
        public GlobalMasterRepoAgreement()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GlobalMasterRepoAgreement> MetaData => metaData;
        
    }
    
    /// <summary>
    /// The set of elections that define a GMSLA.
    /// </summary>
    public class GlobalMasterSecuritiesLendingAgreement : AbstractRosettaModelObject<GlobalMasterSecuritiesLendingAgreement>, IMasterAgreementBase
    {
        private static readonly IRosettaMetaData<GlobalMasterSecuritiesLendingAgreement> metaData = new GlobalMasterSecuritiesLendingAgreementMeta();
        
        [JsonConstructor]
        public GlobalMasterSecuritiesLendingAgreement()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GlobalMasterSecuritiesLendingAgreement> MetaData => metaData;
        
    }
    
    public class GovernmentalAuthorityDefault : AbstractRosettaModelObject<GovernmentalAuthorityDefault>
    {
        private static readonly IRosettaMetaData<GovernmentalAuthorityDefault> metaData = new GovernmentalAuthorityDefaultMeta();
        
        [JsonConstructor]
        public GovernmentalAuthorityDefault(bool governmentalAuthorityDefaultIsApplicable, EscrowArrangement? escrowArrangement, Enums.FxSubstitutionProvisionType? localSubstituteProvisionType, Enums.SpecifiedValue? specifiedValue, ValuationPostponement? maximumDaysOfDisruption)
        {
            GovernmentalAuthorityDefaultIsApplicable = governmentalAuthorityDefaultIsApplicable;
            EscrowArrangement = escrowArrangement;
            LocalSubstituteProvisionType = localSubstituteProvisionType;
            SpecifiedValue = specifiedValue;
            MaximumDaysOfDisruption = maximumDaysOfDisruption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GovernmentalAuthorityDefault> MetaData => metaData;
        
        public bool GovernmentalAuthorityDefaultIsApplicable { get; }
        
        public EscrowArrangement? EscrowArrangement { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FxSubstitutionProvisionType? LocalSubstituteProvisionType { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SpecifiedValue? SpecifiedValue { get; }
        
        public ValuationPostponement? MaximumDaysOfDisruption { get; }
    }
    
    public class GracePeriodExtension : AbstractRosettaModelObject<GracePeriodExtension>
    {
        private static readonly IRosettaMetaData<GracePeriodExtension> metaData = new GracePeriodExtensionMeta();
        
        [JsonConstructor]
        public GracePeriodExtension(bool applicable, Offset? gracePeriod)
        {
            Applicable = applicable;
            GracePeriod = gracePeriod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<GracePeriodExtension> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the grace period extension provision is applicable.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// The number of calendar or business days after any due date that the reference entity has to fulfil its obligations before a failure to pay credit event is deemed to have occurred. ISDA 2003 Term: Grace Period.
        /// </summary>
        public Offset? GracePeriod { get; }
    }
    
    /// <summary>
    /// Specifies the conditions that need to be satisfied before the Secured Party or Custodian acting on its behalf can hold and use posted collateral.
    /// </summary>
    public class HoldingAndUsingPostedCollateral : AbstractRosettaModelObject<HoldingAndUsingPostedCollateral>
    {
        private static readonly IRosettaMetaData<HoldingAndUsingPostedCollateral> metaData = new HoldingAndUsingPostedCollateralMeta();
        
        [JsonConstructor]
        public HoldingAndUsingPostedCollateral(IEnumerable<HoldingAndUsingPostedCollateralElection> partyElection, string? additionalLanguage)
        {
            PartyElection = partyElection;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<HoldingAndUsingPostedCollateral> MetaData => metaData;
        
        /// <summary>
        /// The parties&apos; elections for the holding and using of posted collateral.
        /// </summary>
        public IEnumerable<HoldingAndUsingPostedCollateralElection> PartyElection { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Specifies the parties&apos; elections related to the holding and using of posted collateral.
    /// </summary>
    public class HoldingAndUsingPostedCollateralElection : AbstractRosettaModelObject<HoldingAndUsingPostedCollateralElection>
    {
        private static readonly IRosettaMetaData<HoldingAndUsingPostedCollateralElection> metaData = new HoldingAndUsingPostedCollateralElectionMeta();
        
        [JsonConstructor]
        public HoldingAndUsingPostedCollateralElection(Enums.CounterpartyRole party, EligibilityToHoldCollateral eligibilityToHoldCollateral, bool useOfPostedCollateral)
        {
            Party = party;
            EligibilityToHoldCollateral = eligibilityToHoldCollateral;
            UseOfPostedCollateral = useOfPostedCollateral;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<HoldingAndUsingPostedCollateralElection> MetaData => metaData;
        
        /// <summary>
        /// The party to which the elections apply.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The specification of the conditions under which a party and its custodian(s) are entitled to hold posted collateral.
        /// </summary>
        public EligibilityToHoldCollateral EligibilityToHoldCollateral { get; }
        
        /// <summary>
        /// Indicates whether the party has the right to reuse, rehypothecate, or otherwise make use of the posted collateral. &apos;True&apos; if the party has the right,&apos;False&apos; if the party does not have the right.
        /// </summary>
        public bool UseOfPostedCollateral { get; }
    }
    
    public class Id : AbstractRosettaModelObject<Id>
    {
        private static readonly IRosettaMetaData<Id> metaData = new IdMeta();
        
        [JsonConstructor]
        public Id(string lei)
        {
            Lei = lei;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Id> MetaData => metaData;
        
        public string Lei { get; }
    }
    
    /// <summary>
    /// Attaches an identifier to a collection of objects, when those objects themselves can each be represented by an identifier. One use case is the representation of package transactions, where each component is a separate trade with its own identifier, and those trades are linked together as a package with its own identifier. The data type has been named generically rather than referring to &apos;packages&apos; as it may have a number of other uses.
    /// </summary>
    public class IdentifiedList : AbstractRosettaModelObject<IdentifiedList>
    {
        private static readonly IRosettaMetaData<IdentifiedList> metaData = new IdentifiedListMeta();
        
        [JsonConstructor]
        public IdentifiedList(Identifier listId, IEnumerable<Identifier> componentId, Price? price, _MetaFields? meta)
        {
            ListId = listId;
            ComponentId = componentId;
            Price = price;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IdentifiedList> MetaData => metaData;
        
        /// <summary>
        /// The identifier for the list. In the case of a package transaction, this would be the package identifier. This attribute is mandatory to allow the list itself to be identified.
        /// </summary>
        public Identifier ListId { get; }
        
        /// <summary>
        /// Identifiers for each component of the list. Since the data type is used to link multiple identified objects together, at least 2 components are required in the list. Creating an identified list with only 1 identified component has been deemed unnecessary, because it would just create a redundant identifier.
        /// </summary>
        public IEnumerable<Identifier> ComponentId { get; }
        
        /// <summary>
        /// The price of the package.
        /// </summary>
        public Price? Price { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class to specify a generic identifier, applicable to CDM artefacts such as executions, contracts, lifecycle events and legal documents. An issuer can be associated with the actual identifier value as a way to properly qualify it.
    /// </summary>
    public class Identifier : AbstractRosettaModelObject<Identifier>, IIdentifier
    {
        private static readonly IRosettaMetaData<Identifier> metaData = new IdentifierMeta();
        
        [JsonConstructor]
        public Identifier(ReferenceWithMetaParty? issuerReference, FieldWithMetaString? issuer, IEnumerable<AssignedIdentifier> assignedIdentifier, _MetaFields? meta)
        {
            IssuerReference = issuerReference;
            Issuer = issuer;
            AssignedIdentifier = assignedIdentifier;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Identifier> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty? IssuerReference { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Issuer { get; }
        
        /// <inheritdoc/>
        public IEnumerable<AssignedIdentifier> AssignedIdentifier { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    public class Illiquidity : AbstractRosettaModelObject<Illiquidity>
    {
        private static readonly IRosettaMetaData<Illiquidity> metaData = new IlliquidityMeta();
        
        [JsonConstructor]
        public Illiquidity(bool illiquidityIsApplicable, EscrowArrangement? escrowArrangement, Quantity? minimumAmount, SettlementRateOption? fallbackReferencePrice, AdjustedRelativeDateOffset? illiquidityValuationDate)
        {
            IlliquidityIsApplicable = illiquidityIsApplicable;
            EscrowArrangement = escrowArrangement;
            MinimumAmount = minimumAmount;
            FallbackReferencePrice = fallbackReferencePrice;
            IlliquidityValuationDate = illiquidityValuationDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Illiquidity> MetaData => metaData;
        
        public bool IlliquidityIsApplicable { get; }
        
        public EscrowArrangement? EscrowArrangement { get; }
        
        public Quantity? MinimumAmount { get; }
        
        /// <summary>
        /// The method, prioritised by the order it is listed in this element, to get a replacement rate for the disrupted settlement rate option.
        /// </summary>
        public SettlementRateOption? FallbackReferencePrice { get; }
        
        public AdjustedRelativeDateOffset? IlliquidityValuationDate { get; }
    }
    
    /// <summary>
    /// A class specifying the Independent Amount as the combination of a payer/receiver, a payment amount, a payment date and an associated payment calculation rule.
    /// </summary>
    public class IndependentAmount : AbstractRosettaModelObject<IndependentAmount>, IPartyReferencePayerReceiver
    {
        private static readonly IRosettaMetaData<IndependentAmount> metaData = new IndependentAmountMeta();
        
        [JsonConstructor]
        public IndependentAmount(ReferenceWithMetaParty payerPartyReference, ReferenceWithMetaAccount? payerAccountReference, ReferenceWithMetaParty receiverPartyReference, ReferenceWithMetaAccount? receiverAccountReference, IEnumerable<PaymentDetail> paymentDetail)
        {
            PayerPartyReference = payerPartyReference;
            PayerAccountReference = payerAccountReference;
            ReceiverPartyReference = receiverPartyReference;
            ReceiverAccountReference = receiverAccountReference;
            PaymentDetail = paymentDetail;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndependentAmount> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty PayerPartyReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaAccount? PayerAccountReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty ReceiverPartyReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaAccount? ReceiverAccountReference { get; }
        
        /// <summary>
        /// An attribute that specifies a payment as the combination of a payment amount, a payment date and an associated payment calculation rule.
        /// </summary>
        public IEnumerable<PaymentDetail> PaymentDetail { get; }
    }
    
    /// <summary>
    /// A logical container designed to hold a set of related data. In this case, designed to hold a set of information required when Independent Amount is determined using credit ratings.
    /// </summary>
    public class IndependentAmountRatings : AbstractRosettaModelObject<IndependentAmountRatings>, IIndependentAmountRatings
    {
        private static readonly IRosettaMetaData<IndependentAmountRatings> metaData = new IndependentAmountRatingsMeta();
        
        [JsonConstructor]
        public IndependentAmountRatings(Enums.IndependentAmountCompare compare, Enums.RatedParty ratedParty, LegalEntity? namedAffiliate, LegalEntity? namedEntity, Enums.RatingType ratingType)
        {
            Compare = compare;
            RatedParty = ratedParty;
            NamedAffiliate = namedAffiliate;
            NamedEntity = namedEntity;
            RatingType = ratingType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndependentAmountRatings> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndependentAmountCompare Compare { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatedParty RatedParty { get; }
        
        /// <inheritdoc/>
        public LegalEntity? NamedAffiliate { get; }
        
        /// <inheritdoc/>
        public LegalEntity? NamedEntity { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatingType RatingType { get; }
    }
    
    /// <summary>
    /// An Index is an Observable which is computed based on the prices, rates or valuations of a number of assets that are tracked in a standardized way.  Examples include equity market indices as well as indices on interest rates, inflation and credit instruments.
    /// </summary>
    public class Index : AbstractRosettaModelObject<Index>
    {
        private static readonly IRosettaMetaData<Index> metaData = new IndexMeta();
        
        [JsonConstructor]
        public Index(CreditIndex? creditIndex, EquityIndex? equityIndex, FieldWithMetaInterestRateIndex? interestRateIndex, ForeignExchangeRateIndex? foreignExchangeRateIndex, OtherIndex? otherIndex)
        {
            CreditIndex = creditIndex;
            EquityIndex = equityIndex;
            InterestRateIndex = interestRateIndex;
            ForeignExchangeRateIndex = foreignExchangeRateIndex;
            OtherIndex = otherIndex;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Index> MetaData => metaData;
        
        /// <summary>
        /// An index based on credit risk, typically composed using corporate debt instruments in a region or industry sector, e.g. the iTraxx indices.
        /// </summary>
        public CreditIndex? CreditIndex { get; }
        
        /// <summary>
        /// An index based on equity securities, e.g. the S&amp;P 500.
        /// </summary>
        public EquityIndex? EquityIndex { get; }
        
        /// <summary>
        /// An index based in interest rates or inflation rates in a certain market.
        /// </summary>
        public FieldWithMetaInterestRateIndex? InterestRateIndex { get; }
        
        /// <summary>
        /// A rate based on the exchange of a pair of cash assets in specific currencies, e.g. USD versus GBP.
        /// </summary>
        public ForeignExchangeRateIndex? ForeignExchangeRateIndex { get; }
        
        /// <summary>
        /// An index created by a market participant which doesn&apos;t align with the other index types.
        /// </summary>
        public OtherIndex? OtherIndex { get; }
    }
    
    /// <summary>
    /// Defines the specification of the consequences of Index Events
    /// </summary>
    public class IndexAdjustmentEvents : AbstractRosettaModelObject<IndexAdjustmentEvents>
    {
        private static readonly IRosettaMetaData<IndexAdjustmentEvents> metaData = new IndexAdjustmentEventsMeta();
        
        [JsonConstructor]
        public IndexAdjustmentEvents(Enums.IndexEventConsequence indexModification, Enums.IndexEventConsequence indexCancellation, Enums.IndexEventConsequence indexDisruption)
        {
            IndexModification = indexModification;
            IndexCancellation = indexCancellation;
            IndexDisruption = indexDisruption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndexAdjustmentEvents> MetaData => metaData;
        
        /// <summary>
        /// Consequence of index modification.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndexEventConsequence IndexModification { get; }
        
        /// <summary>
        /// Consequence of index cancellation.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndexEventConsequence IndexCancellation { get; }
        
        /// <summary>
        /// Consequence of index disruption.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndexEventConsequence IndexDisruption { get; }
    }
    
    /// <summary>
    /// Identifies an index by referencing an identifier.
    /// </summary>
    public class IndexBase : AbstractRosettaModelObject<IndexBase>, IIndexBase, IAssetBase
    {
        private static readonly IRosettaMetaData<IndexBase> metaData = new IndexBaseMeta();
        
        [JsonConstructor]
        public IndexBase(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, FieldWithMetaString? name, LegalEntity? provider, Enums.AssetClass? assetClass)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            Name = name;
            Provider = provider;
            AssetClass = assetClass;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndexBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Name { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Provider { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetClass? AssetClass { get; }
    }
    
    /// <summary>
    /// Defines the information needed to create a Index Transition Business Event.
    /// </summary>
    public class IndexTransitionInstruction : AbstractRosettaModelObject<IndexTransitionInstruction>
    {
        private static readonly IRosettaMetaData<IndexTransitionInstruction> metaData = new IndexTransitionInstructionMeta();
        
        [JsonConstructor]
        public IndexTransitionInstruction(IEnumerable<PriceQuantity> priceQuantity, LocalDate effectiveDate, Transfer? cashTransfer)
        {
            PriceQuantity = priceQuantity;
            EffectiveDate = effectiveDate;
            CashTransfer = cashTransfer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IndexTransitionInstruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies both new floating rate index and spread adjustment for each leg to be updated.  The spread adjustment accounts for the difference between the old floating rate index relative to the new one. This spread amount is added to the existing spread to determine the new spread, which is applied from the specified effective date forward. In the case of the IBOR Fallback Rate Adjustments, the adjustment spread (also known as the Fallback Adjustment) accounts for two distinctions: i) the fact that the replacement Risk-Free Rate is an overnight rate while IBORs have term structures (e.g., 1, 3, 6-month LIBOR); and (ii) the historical spread differential between IBORs and their term equivalent Overnight Risk-Free Rate compounded rates.
        /// </summary>
        public IEnumerable<PriceQuantity> PriceQuantity { get; }
        
        /// <summary>
        /// Specifies the effective date of the index transition event. This is first date on which the floating rate calculation will use the new floating rate index and adjusted spread in the floating rate calculation.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate EffectiveDate { get; }
        
        /// <summary>
        /// Specifies the cash transfer that can optionally be tied to an index transition event.
        /// </summary>
        public Transfer? CashTransfer { get; }
    }
    
    public class Indx : AbstractRosettaModelObject<Indx>
    {
        private static readonly IRosettaMetaData<Indx> metaData = new IndxMeta();
        
        [JsonConstructor]
        public Indx(Nm nm)
        {
            Nm = nm;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Indx> MetaData => metaData;
        
        public Nm Nm { get; }
    }
    
    /// <summary>
    /// Identifies collateral that has been designated as not meeting the eligibility criteria set out in the agreement.
    /// </summary>
    public class IneligibleCreditSupport : AbstractRosettaModelObject<IneligibleCreditSupport>
    {
        private static readonly IRosettaMetaData<IneligibleCreditSupport> metaData = new IneligibleCreditSupportMeta();
        
        [JsonConstructor]
        public IneligibleCreditSupport(string? totalIneligibilityDate, string? transferIneligibilityDate, IEnumerable<Enums.CounterpartyRole> specifiedParty)
        {
            TotalIneligibilityDate = totalIneligibilityDate;
            TransferIneligibilityDate = transferIneligibilityDate;
            SpecifiedParty = specifiedParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IneligibleCreditSupport> MetaData => metaData;
        
        /// <summary>
        /// Specifies the date from which all credit support provided by a party is treated as ineligible under the agreement.
        /// </summary>
        public string? TotalIneligibilityDate { get; }
        
        /// <summary>
        /// Specifies the date from which the transfer of credit support by a party is treated as ineligible under the agreement.
        /// </summary>
        public string? TransferIneligibilityDate { get; }
        
        /// <summary>
        /// Identifies a party designated in the agreement for the purpose of applying particular rights, obligations, or elections.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> SpecifiedParty { get; }
    }
    
    /// <summary>
    /// Specification of an index that measures inflation in a specific market, e.g. the US Consumer Price Index.
    /// </summary>
    public class InflationIndex : AbstractRosettaModelObject<InflationIndex>, IIndexBase
    {
        private static readonly IRosettaMetaData<InflationIndex> metaData = new InflationIndexMeta();
        
        [JsonConstructor]
        public InflationIndex(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, FieldWithMetaString? name, LegalEntity? provider, Enums.AssetClass? assetClass, FieldWithMetaInflationRateIndexEnum inflationRateIndex, Period? indexTenor)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            Name = name;
            Provider = provider;
            AssetClass = assetClass;
            InflationRateIndex = inflationRateIndex;
            IndexTenor = indexTenor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InflationIndex> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Name { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Provider { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetClass? AssetClass { get; }
        
        /// <summary>
        /// The reference index that is used to specify the inflation interest rate.
        /// </summary>
        public FieldWithMetaInflationRateIndexEnum InflationRateIndex { get; }
        
        /// <summary>
        /// The ISDA Designated Maturity, i.e. the floating rate tenor.
        /// </summary>
        public Period? IndexTenor { get; }
    }
    
    /// <summary>
    /// A data to:  specify the inflation rate.
    /// </summary>
    public class InflationRateSpecification : AbstractRosettaModelObject<InflationRateSpecification>, IFloatingRateSpecification
    {
        private static readonly IRosettaMetaData<InflationRateSpecification> metaData = new InflationRateSpecificationMeta();
        
        [JsonConstructor]
        public InflationRateSpecification(ReferenceWithMetaInterestRateIndex? rateOption, SpreadSchedule? spreadSchedule, StrikeSchedule? capRateSchedule, StrikeSchedule? floorRateSchedule, _MetaFields? meta, RateSchedule? floatingRateMultiplierSchedule, Enums.RateTreatment? rateTreatment, FloatingRateCalculationParameters? calculationParameters, FallbackRateParameters? fallbackRate, Price? initialRate, Rounding? finalRateRounding, Enums.AveragingWeightingMethod? averagingMethod, Enums.NegativeInterestRateTreatment? negativeInterestRateTreatment, Offset inflationLag, FieldWithMetaString indexSource, FieldWithMetaString mainPublication, FieldWithMetaInterpolationMethodEnum interpolationMethod, decimal? initialIndexLevel, bool fallbackBondApplicable, Enums.InflationCalculationMethod? calculationMethod, Enums.InflationCalculationStyle? calculationStyle, Enums.FinalPrincipalExchangeCalculation? finalPrincipalExchangeCalculation)
        {
            RateOption = rateOption;
            SpreadSchedule = spreadSchedule;
            CapRateSchedule = capRateSchedule;
            FloorRateSchedule = floorRateSchedule;
            Meta = meta;
            FloatingRateMultiplierSchedule = floatingRateMultiplierSchedule;
            RateTreatment = rateTreatment;
            CalculationParameters = calculationParameters;
            FallbackRate = fallbackRate;
            InitialRate = initialRate;
            FinalRateRounding = finalRateRounding;
            AveragingMethod = averagingMethod;
            NegativeInterestRateTreatment = negativeInterestRateTreatment;
            InflationLag = inflationLag;
            IndexSource = indexSource;
            MainPublication = mainPublication;
            InterpolationMethod = interpolationMethod;
            InitialIndexLevel = initialIndexLevel;
            FallbackBondApplicable = fallbackBondApplicable;
            CalculationMethod = calculationMethod;
            CalculationStyle = calculationStyle;
            FinalPrincipalExchangeCalculation = finalPrincipalExchangeCalculation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InflationRateSpecification> MetaData => metaData;
        
        public ReferenceWithMetaInterestRateIndex? RateOption { get; }
        
        /// <inheritdoc/>
        public SpreadSchedule? SpreadSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? CapRateSchedule { get; }
        
        /// <inheritdoc/>
        public StrikeSchedule? FloorRateSchedule { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        public RateSchedule? FloatingRateMultiplierSchedule { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RateTreatment? RateTreatment { get; }
        
        /// <inheritdoc/>
        public FloatingRateCalculationParameters? CalculationParameters { get; }
        
        /// <inheritdoc/>
        public FallbackRateParameters? FallbackRate { get; }
        
        /// <inheritdoc/>
        public Price? InitialRate { get; }
        
        /// <inheritdoc/>
        public Rounding? FinalRateRounding { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AveragingWeightingMethod? AveragingMethod { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NegativeInterestRateTreatment? NegativeInterestRateTreatment { get; }
        
        /// <summary>
        /// An off-setting period from the payment date which determines the reference period for which the inflation index is observed.
        /// </summary>
        public Offset InflationLag { get; }
        
        /// <summary>
        /// The reference source such as Reuters or Bloomberg. FpML specifies indexSource to be of type rateSourcePageScheme, but without specifying actual values.
        /// </summary>
        public FieldWithMetaString IndexSource { get; }
        
        /// <summary>
        /// The current main publication source such as relevant web site or a government body. FpML specifies mainPublication to be of type mainPublicationSource, but without specifying actual values.
        /// </summary>
        public FieldWithMetaString MainPublication { get; }
        
        /// <summary>
        /// The method used when calculating the Inflation Index Level from multiple points. The most common is Linear.
        /// </summary>
        public FieldWithMetaInterpolationMethodEnum InterpolationMethod { get; }
        
        /// <summary>
        /// Initial known index level for the first calculation period.
        /// </summary>
        public decimal? InitialIndexLevel { get; }
        
        /// <summary>
        /// The applicability of a fallback bond as defined in the 2006 ISDA Inflation Derivatives Definitions, sections 1.3 and 1.8.
        /// </summary>
        public bool FallbackBondApplicable { get; }
        
        /// <summary>
        /// Indicates how to use the inflation index to calculate the payment (e.g. Ratio, Return, Spread). Added for Inflation Asset Swap
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InflationCalculationMethod? CalculationMethod { get; }
        
        /// <summary>
        /// Indicates the style of how the inflation index calculates the payment (e.g. YearOnYear, ZeroCoupon).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InflationCalculationStyle? CalculationStyle { get; }
        
        /// <summary>
        /// To be specified only for products that embed a redemption payment.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FinalPrincipalExchangeCalculation? FinalPrincipalExchangeCalculation { get; }
    }
    
    /// <summary>
    /// A class defining the source for a piece of information (e.g. a rate fix or an FX fixing). The attribute names have been adjusted from FpML to address the fact that the information is not limited to rates.
    /// </summary>
    public class InformationSource : AbstractRosettaModelObject<InformationSource>, IInformationSource
    {
        private static readonly IRosettaMetaData<InformationSource> metaData = new InformationSourceMeta();
        
        [JsonConstructor]
        public InformationSource(FieldWithMetaInformationProviderEnum sourceProvider, FieldWithMetaString? sourcePage, string? sourcePageHeading)
        {
            SourceProvider = sourceProvider;
            SourcePage = sourcePage;
            SourcePageHeading = sourcePageHeading;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InformationSource> MetaData => metaData;
        
        /// <inheritdoc/>
        public FieldWithMetaInformationProviderEnum SourceProvider { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? SourcePage { get; }
        
        /// <inheritdoc/>
        public string? SourcePageHeading { get; }
    }
    
    /// <summary>
    /// A CDM class which purpose is to specify the initial fixing date either alongside the FpML interest rate specification as an offset of another date, or alongside the credit derivative specification as an unadjusted date.
    /// </summary>
    public class InitialFixingDate : AbstractRosettaModelObject<InitialFixingDate>
    {
        private static readonly IRosettaMetaData<InitialFixingDate> metaData = new InitialFixingDateMeta();
        
        [JsonConstructor]
        public InitialFixingDate(RelativeDateOffset? relativeDateOffset, LocalDate? initialFixingDate)
        {
            RelativeDateOffset = relativeDateOffset;
            InitialFixingDateValue = initialFixingDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InitialFixingDate> MetaData => metaData;
        
        public RelativeDateOffset? RelativeDateOffset { get; }
        
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        [JsonProperty(PropertyName = "initialFixingDate")]
        public LocalDate? InitialFixingDateValue { get; }
    }
    
    /// <summary>
    /// Instruction to a function that will be used to perform a business event
    /// </summary>
    public class Instruction : AbstractRosettaModelObject<Instruction>
    {
        private static readonly IRosettaMetaData<Instruction> metaData = new InstructionMeta();
        
        [JsonConstructor]
        public Instruction(PrimitiveInstruction? primitiveInstruction, ReferenceWithMetaTradeState? before)
        {
            PrimitiveInstruction = primitiveInstruction;
            Before = before;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Instruction> MetaData => metaData;
        
        /// <summary>
        /// Specifies the primitive instructions that will be used to call primitive event functions.
        /// </summary>
        public PrimitiveInstruction? PrimitiveInstruction { get; }
        
        /// <summary>
        /// Specifies the trade state that will be acted on by the primitive event functions.
        /// </summary>
        public ReferenceWithMetaTradeState? Before { get; }
    }
    
    /// <summary>
    /// A type of Asset that is issued by one party to one or more others.
    /// </summary>
    public class Instrument : AbstractRosettaModelObject<Instrument>
    {
        private static readonly IRosettaMetaData<Instrument> metaData = new InstrumentMeta();
        
        [JsonConstructor]
        public Instrument(ListedDerivative? listedDerivative, Loan? loan, Security? security)
        {
            ListedDerivative = listedDerivative;
            Loan = loan;
            Security = security;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Instrument> MetaData => metaData;
        
        /// <summary>
        /// A securitized derivative on another asset that is created by an exchange.
        /// </summary>
        public ListedDerivative? ListedDerivative { get; }
        
        /// <summary>
        /// An Asset that represents a loan or borrow obligation.
        /// </summary>
        public Loan? Loan { get; }
        
        /// <summary>
        /// An Asset that is issued by a party to be held by or transferred to others.
        /// </summary>
        public Security? Security { get; }
    }
    
    /// <summary>
    /// Defines the common attributes for all Instrument data types.
    /// </summary>
    public class InstrumentBase : AbstractRosettaModelObject<InstrumentBase>, IInstrumentBase, IAssetBase
    {
        private static readonly IRosettaMetaData<InstrumentBase> metaData = new InstrumentBaseMeta();
        
        [JsonConstructor]
        public InstrumentBase(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, Enums.InstrumentType instrumentType)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            InstrumentType = instrumentType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InstrumentBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InstrumentType InstrumentType { get; }
    }
    
    /// <summary>
    /// A class to specify whether the Interest Adjustment is applicable and what its periodicity is.
    /// </summary>
    public class InterestAdjustment : AbstractRosettaModelObject<InterestAdjustment>
    {
        private static readonly IRosettaMetaData<InterestAdjustment> metaData = new InterestAdjustmentMeta();
        
        [JsonConstructor]
        public InterestAdjustment(bool isApplicable, InterestAdjustmentPeriodicity periodicity)
        {
            IsApplicable = isApplicable;
            Periodicity = periodicity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestAdjustment> MetaData => metaData;
        
        /// <summary>
        /// The Interest Adjustment is applicable when True and not applicable when False.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The qualification of the Interest Adjustment periodicity.
        /// </summary>
        public InterestAdjustmentPeriodicity Periodicity { get; }
    }
    
    /// <summary>
    /// A class to specify the Interest Adjustment periodicity.
    /// </summary>
    public class InterestAdjustmentPeriodicity : AbstractRosettaModelObject<InterestAdjustmentPeriodicity>
    {
        private static readonly IRosettaMetaData<InterestAdjustmentPeriodicity> metaData = new InterestAdjustmentPeriodicityMeta();
        
        [JsonConstructor]
        public InterestAdjustmentPeriodicity(Enums.InterestAdjustmentPeriodicity? standardElection, string? customElection)
        {
            StandardElection = standardElection;
            CustomElection = customElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestAdjustmentPeriodicity> MetaData => metaData;
        
        /// <summary>
        /// The Interest Adjustment periodicity when specified through a standardized election.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InterestAdjustmentPeriodicity? StandardElection { get; }
        
        /// <summary>
        /// The Interest Adjustment periodicity when specified through a custom election.
        /// </summary>
        public string? CustomElection { get; }
    }
    
    /// <summary>
    /// A class to specify the application of Interest Amount with respect to the Delivery Amount and the Return Amount.
    /// </summary>
    public class InterestAmount : AbstractRosettaModelObject<InterestAmount>
    {
        private static readonly IRosettaMetaData<InterestAmount> metaData = new InterestAmountMeta();
        
        [JsonConstructor]
        public InterestAmount(ReturnAmount returnAmount, DeliveryAmount deliveryAmount)
        {
            ReturnAmount = returnAmount;
            DeliveryAmount = deliveryAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestAmount> MetaData => metaData;
        
        /// <summary>
        /// The application of Interest Amount with respect the Return Amount.
        /// </summary>
        public ReturnAmount ReturnAmount { get; }
        
        /// <summary>
        /// The application of Interest Amount with respect the Delivery Amount.
        /// </summary>
        public DeliveryAmount DeliveryAmount { get; }
    }
    
    /// <summary>
    /// A class to specify the application of Interest Amount with respect to the Delivery Amount and the Return Amount.
    /// </summary>
    public class InterestAmountApplication : AbstractRosettaModelObject<InterestAmountApplication>
    {
        private static readonly IRosettaMetaData<InterestAmountApplication> metaData = new InterestAmountApplicationMeta();
        
        [JsonConstructor]
        public InterestAmountApplication(ReturnAmount returnAmount, DeliveryAmount deliveryAmount)
        {
            ReturnAmount = returnAmount;
            DeliveryAmount = deliveryAmount;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestAmountApplication> MetaData => metaData;
        
        /// <summary>
        /// The application of Interest Amount with respect the Return Amount.
        /// </summary>
        public ReturnAmount ReturnAmount { get; }
        
        /// <summary>
        /// The application of Interest Amount with respect the Delivery Amount.
        /// </summary>
        public DeliveryAmount DeliveryAmount { get; }
    }
    
    public class InterestRateCurve : AbstractRosettaModelObject<InterestRateCurve>
    {
        private static readonly IRosettaMetaData<InterestRateCurve> metaData = new InterestRateCurveMeta();
        
        [JsonConstructor]
        public InterestRateCurve(FieldWithMetaFloatingRateIndexEnum floatingRateIndex, Period tenor)
        {
            FloatingRateIndex = floatingRateIndex;
            Tenor = tenor;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestRateCurve> MetaData => metaData;
        
        public FieldWithMetaFloatingRateIndexEnum FloatingRateIndex { get; }
        
        public Period Tenor { get; }
    }
    
    /// <summary>
    /// An index based in interest rates or inflation rates in a certain market.
    /// </summary>
    public class InterestRateIndex : AbstractRosettaModelObject<InterestRateIndex>
    {
        private static readonly IRosettaMetaData<InterestRateIndex> metaData = new InterestRateIndexMeta();
        
        [JsonConstructor]
        public InterestRateIndex(FloatingRateIndex? floatingRateIndex, InflationIndex? inflationIndex)
        {
            FloatingRateIndex = floatingRateIndex;
            InflationIndex = inflationIndex;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestRateIndex> MetaData => metaData;
        
        /// <summary>
        /// An interest rate index which can change over time, e.g. the SONIA (Sterling Overnight Index Average) in the UK.
        /// </summary>
        public FloatingRateIndex? FloatingRateIndex { get; }
        
        /// <summary>
        /// An index that measures inflation in a specific market, e.g. the US Consumer Price Index.
        /// </summary>
        public InflationIndex? InflationIndex { get; }
    }
    
    /// <summary>
    ///  A class to specify all of the terms necessary to define and calculate a cash flow based on a fixed, a floating or an inflation index rate. The interest rate payout can be applied to interest rate swaps and FRA (which both have two associated interest rate payouts), credit default swaps (to represent the fee leg when subject to periodic payments) and equity swaps (to represent the funding leg). The associated globalKey denotes the ability to associate a hash value to the InterestRatePayout instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class InterestRatePayout : AbstractRosettaModelObject<InterestRatePayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<InterestRatePayout> metaData = new InterestRatePayoutMeta();
        
        [JsonConstructor]
        public InterestRatePayout(PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms, RateSpecification? rateSpecification, FieldWithMetaDayCountFractionEnum? dayCountFraction, CalculationPeriodDates? calculationPeriodDates, PaymentDates? paymentDates, AdjustableDate? paymentDate, bool? paymentDelay, ResetDates? resetDates, DiscountingMethod? discountingMethod, Enums.CompoundingMethod? compoundingMethod, CashflowRepresentation? cashflowRepresentation, StubPeriod? stubPeriod, BondReference? bondReference, string? fixedAmount, string? floatingAmount, Enums.SpreadCalculationMethod? spreadCalculationMethod)
        {
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
            RateSpecification = rateSpecification;
            DayCountFraction = dayCountFraction;
            CalculationPeriodDates = calculationPeriodDates;
            PaymentDates = paymentDates;
            PaymentDate = paymentDate;
            PaymentDelay = paymentDelay;
            ResetDates = resetDates;
            DiscountingMethod = discountingMethod;
            CompoundingMethod = compoundingMethod;
            CashflowRepresentation = cashflowRepresentation;
            StubPeriod = stubPeriod;
            BondReference = bondReference;
            FixedAmount = fixedAmount;
            FloatingAmount = floatingAmount;
            SpreadCalculationMethod = spreadCalculationMethod;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestRatePayout> MetaData => metaData;
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
        
        /// <summary>
        /// The specification of the rate value(s) applicable to the contract using either a floating rate calculation, a single fixed rate, a fixed rate schedule, or an inflation rate calculation.
        /// </summary>
        public RateSpecification? RateSpecification { get; }
        
        /// <summary>
        /// The day count fraction. The cardinality has been relaxed when compared with the FpML interest rate swap for the purpose of accommodating standardized credit default swaps which DCF is not explicitly stated as part of the economic terms. The data rule InterestRatePayout_dayCountFraction requires that the DCF be stated for interest rate products.
        /// </summary>
        public FieldWithMetaDayCountFractionEnum? DayCountFraction { get; }
        
        /// <summary>
        /// The parameters used to generate the calculation period dates schedule, including the specification of any initial or final stub calculation periods.
        /// </summary>
        public CalculationPeriodDates? CalculationPeriodDates { get; }
        
        /// <summary>
        /// The payment date schedule, as defined by the parameters that are needed to specify it, either in a parametric way or by reference to another schedule of dates (e.g. the reset dates).
        /// </summary>
        public PaymentDates? PaymentDates { get; }
        
        /// <summary>
        /// The payment date, where only one date is specified, as for the FRA product.
        /// </summary>
        public AdjustableDate? PaymentDate { get; }
        
        /// <summary>
        /// Applicable to CDS on MBS to specify whether payment delays are applicable to the fixed Amount. RMBS typically have a payment delay of 5 days between the coupon date of the reference obligation and the payment date of the synthetic swap. CMBS do not, on the other hand, with both payment dates being on the 25th of each month.
        /// </summary>
        public bool? PaymentDelay { get; }
        
        /// <summary>
        /// The reset dates schedule, i.e. the dates on which the new observed index value is applied for each period and the interest rate hence begins to accrue.
        /// </summary>
        public ResetDates? ResetDates { get; }
        
        /// <summary>
        /// The parameters specifying any discounting conventions that may apply. This element must only be included if discounting applies.
        /// </summary>
        public DiscountingMethod? DiscountingMethod { get; }
        
        /// <summary>
        /// If one or more calculation period contributes to a single payment amount this element specifies whether compounding is applicable and, if so, what compounding method is to be used. This element must only be included when more than one calculation period contributes to a single payment amount.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CompoundingMethod? CompoundingMethod { get; }
        
        /// <summary>
        /// The cashflow representation of the swap stream.
        /// </summary>
        public CashflowRepresentation? CashflowRepresentation { get; }
        
        /// <summary>
        /// The stub calculation period amount parameters. This element must only be included if there is an initial or final stub calculation period. Even then, it must only be included if either the stub references a different floating rate tenor to the regular calculation periods, or if the stub is calculated as a linear interpolation of two different floating rate tenors, or if a specific stub rate or stub amount has been negotiated.
        /// </summary>
        public StubPeriod? StubPeriod { get; }
        
        /// <summary>
        /// Reference to a bond underlier to represent an asset swap or Condition Precedent Bond.
        /// </summary>
        public BondReference? BondReference { get; }
        
        /// <summary>
        /// Fixed Amount Calculation
        /// </summary>
        public string? FixedAmount { get; }
        
        /// <summary>
        /// Floating Amount Calculation
        /// </summary>
        public string? FloatingAmount { get; }
        
        /// <summary>
        /// Method by which spread is calculated. For example on an asset swap: &apos;ParPar&apos; or &apos;Proceeds&apos; may be the method indicated.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SpreadCalculationMethod? SpreadCalculationMethod { get; }
    }
    
    /// <summary>
    /// A class to specify the interest shortfall floating rate payment event.
    /// </summary>
    public class InterestShortFall : AbstractRosettaModelObject<InterestShortFall>
    {
        private static readonly IRosettaMetaData<InterestShortFall> metaData = new InterestShortFallMeta();
        
        [JsonConstructor]
        public InterestShortFall(Enums.InterestShortfallCap interestShortfallCap, bool compounding, FieldWithMetaFloatingRateIndexEnum? rateSource)
        {
            InterestShortfallCap = interestShortfallCap;
            Compounding = compounding;
            RateSource = rateSource;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InterestShortFall> MetaData => metaData;
        
        /// <summary>
        /// Specifies the nature of the interest Shortfall cap (i.e. Fixed Cap or Variable Cap) in the case where it is applicable. ISDA 2003 Term: Interest Shortfall Cap.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InterestShortfallCap InterestShortfallCap { get; }
        
        public bool Compounding { get; }
        
        /// <summary>
        /// The rate source in the case of a variable cap.
        /// </summary>
        public FieldWithMetaFloatingRateIndexEnum? RateSource { get; }
    }
    
    /// <summary>
    /// A data type that can be used to describe an inventory of securities.
    /// </summary>
    public class Inventory : AbstractRosettaModelObject<Inventory>
    {
        private static readonly IRosettaMetaData<Inventory> metaData = new InventoryMeta();
        
        [JsonConstructor]
        public Inventory(IEnumerable<InventoryRecord> inventoryRecord)
        {
            InventoryRecord = inventoryRecord;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Inventory> MetaData => metaData;
        
        /// <summary>
        /// An array holding the list of inventory being described. Each element in the inventoryRecord array represents an individual piece of inventory i.e. a security.
        /// </summary>
        public IEnumerable<InventoryRecord> InventoryRecord { get; }
    }
    
    /// <summary>
    /// An individual piece of inventory. This represents a single security.
    /// </summary>
    public class InventoryRecord : AbstractRosettaModelObject<InventoryRecord>, IInventoryRecord
    {
        private static readonly IRosettaMetaData<InventoryRecord> metaData = new InventoryRecordMeta();
        
        [JsonConstructor]
        public InventoryRecord(AssignedIdentifier identifer, Security security)
        {
            Identifer = identifer;
            Security = security;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InventoryRecord> MetaData => metaData;
        
        /// <inheritdoc/>
        public AssignedIdentifier Identifer { get; }
        
        /// <inheritdoc/>
        public Security Security { get; }
    }
    
    public class InvstmtDcsnPrsn : AbstractRosettaModelObject<InvstmtDcsnPrsn>
    {
        private static readonly IRosettaMetaData<InvstmtDcsnPrsn> metaData = new InvstmtDcsnPrsnMeta();
        
        [JsonConstructor]
        public InvstmtDcsnPrsn(Prsn prsn)
        {
            Prsn = prsn;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<InvstmtDcsnPrsn> MetaData => metaData;
        
        public Prsn Prsn { get; }
    }
    
    public class IssuerAgencyRating : AbstractRosettaModelObject<IssuerAgencyRating>
    {
        private static readonly IRosettaMetaData<IssuerAgencyRating> metaData = new IssuerAgencyRatingMeta();
        
        [JsonConstructor]
        public IssuerAgencyRating(AgencyRatingCriteria issuerAgencyRating)
        {
            IssuerAgencyRatingValue = issuerAgencyRating;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IssuerAgencyRating> MetaData => metaData;
        
        /// <summary>
        /// Represents an agency rating based on default risk and creditors claim in event of default associated with asset issuer.
        /// </summary>
        [JsonProperty(PropertyName = "issuerAgencyRating")]
        public AgencyRatingCriteria IssuerAgencyRatingValue { get; }
    }
    
    public class IssuerCountryOfOrigin : AbstractRosettaModelObject<IssuerCountryOfOrigin>
    {
        private static readonly IRosettaMetaData<IssuerCountryOfOrigin> metaData = new IssuerCountryOfOriginMeta();
        
        [JsonConstructor]
        public IssuerCountryOfOrigin(Enums.ISOCountryCode issuerCountryOfOrigin)
        {
            IssuerCountryOfOriginValue = issuerCountryOfOrigin;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IssuerCountryOfOrigin> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter on the issuing entity country of origin based on the ISO Standard 3166, which is the same as filtering by eligible Sovereigns.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "issuerCountryOfOrigin")]
        public Enums.ISOCountryCode IssuerCountryOfOriginValue { get; }
    }
    
    public class IssuerName : AbstractRosettaModelObject<IssuerName>
    {
        private static readonly IRosettaMetaData<IssuerName> metaData = new IssuerNameMeta();
        
        [JsonConstructor]
        public IssuerName(LegalEntity issuerName)
        {
            IssuerNameValue = issuerName;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<IssuerName> MetaData => metaData;
        
        /// <summary>
        /// Specifies the issuing entity name or LEI.
        /// </summary>
        [JsonProperty(PropertyName = "issuerName")]
        public LegalEntity IssuerNameValue { get; }
    }
    
    /// <summary>
    /// A class to specify Japanese Securities Provision elections.
    /// </summary>
    public class JapaneseSecuritiesProvisions : AbstractRosettaModelObject<JapaneseSecuritiesProvisions>
    {
        private static readonly IRosettaMetaData<JapaneseSecuritiesProvisions> metaData = new JapaneseSecuritiesProvisionsMeta();
        
        [JsonConstructor]
        public JapaneseSecuritiesProvisions(bool isApplicable, bool? relevantProvisionsElection, string? relevantProvisionsTerms, bool? amendmentsToJapaneseProvisions, string? amendmentsToJapaneseProvisionsTerms, bool? clearstreamAmendmentToJapaneseProvisions)
        {
            IsApplicable = isApplicable;
            RelevantProvisionsElection = relevantProvisionsElection;
            RelevantProvisionsTerms = relevantProvisionsTerms;
            AmendmentsToJapaneseProvisions = amendmentsToJapaneseProvisions;
            AmendmentsToJapaneseProvisionsTerms = amendmentsToJapaneseProvisionsTerms;
            ClearstreamAmendmentToJapaneseProvisions = clearstreamAmendmentToJapaneseProvisions;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<JapaneseSecuritiesProvisions> MetaData => metaData;
        
        /// <summary>
        /// Japanese Securities Provisions are applicable when True and Not Applicable when False.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// Recommended Japanese Securities Provisions are applicable when True, additional Provisions are specified when False.
        /// </summary>
        public bool? RelevantProvisionsElection { get; }
        
        /// <summary>
        /// Specific terms applicable to Recommended Japanese Securities Provisions.
        /// </summary>
        public string? RelevantProvisionsTerms { get; }
        
        /// <summary>
        /// Additional Amendments to Japanese Securities Provisions are specified when True, and not specified when False.
        /// </summary>
        public bool? AmendmentsToJapaneseProvisions { get; }
        
        /// <summary>
        /// Specific terms applicable to Additional Amendments to Japanese Securities Provisions.
        /// </summary>
        public string? AmendmentsToJapaneseProvisionsTerms { get; }
        
        /// <summary>
        /// Specification of whether Clearstream Event amendment language is included (true) or excluded (false).
        /// </summary>
        public bool? ClearstreamAmendmentToJapaneseProvisions { get; }
    }
    
    /// <summary>
    /// A class to specify terms jurisdiction related terms.
    /// </summary>
    public class JurisdictionRelatedTerms : AbstractRosettaModelObject<JurisdictionRelatedTerms>
    {
        private static readonly IRosettaMetaData<JurisdictionRelatedTerms> metaData = new JurisdictionRelatedTermsMeta();
        
        [JsonConstructor]
        public JurisdictionRelatedTerms(JapaneseSecuritiesProvisions? japaneseSecuritiesProvisions, bool? exclusiveJurisdiction, bool? juryWaiver, FrenchLawAddendum? frenchLawAddendum, bool? belgianLawSecurityAgreement)
        {
            JapaneseSecuritiesProvisions = japaneseSecuritiesProvisions;
            ExclusiveJurisdiction = exclusiveJurisdiction;
            JuryWaiver = juryWaiver;
            FrenchLawAddendum = frenchLawAddendum;
            BelgianLawSecurityAgreement = belgianLawSecurityAgreement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<JurisdictionRelatedTerms> MetaData => metaData;
        
        /// <summary>
        /// The Japanese Securities Provisions election.
        /// </summary>
        public JapaneseSecuritiesProvisions? JapaneseSecuritiesProvisions { get; }
        
        /// <summary>
        /// Classification of optional exclusive jurisdiction terms.
        /// </summary>
        public bool? ExclusiveJurisdiction { get; }
        
        /// <summary>
        /// The Jury Waiver conditions specific to the agreement.
        /// </summary>
        public bool? JuryWaiver { get; }
        
        /// <summary>
        /// The French Law Addendum Provisions specific to the agreement.
        /// </summary>
        public FrenchLawAddendum? FrenchLawAddendum { get; }
        
        /// <summary>
        /// The qualification of whether the Belgian Law Security Agreement Addendum is deemed applicable by the parties (True) or not (False).
        /// </summary>
        public bool? BelgianLawSecurityAgreement { get; }
    }
    
    /// <summary>
    /// Knock In means option to exercise comes into existence. Knock Out means option to exercise goes out of existence.
    /// </summary>
    public class Knock : AbstractRosettaModelObject<Knock>
    {
        private static readonly IRosettaMetaData<Knock> metaData = new KnockMeta();
        
        [JsonConstructor]
        public Knock(TriggerEvent? knockIn, TriggerEvent? knockOut)
        {
            KnockIn = knockIn;
            KnockOut = knockOut;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Knock> MetaData => metaData;
        
        /// <summary>
        /// The knock in.
        /// </summary>
        public TriggerEvent? KnockIn { get; }
        
        /// <summary>
        /// The knock out.
        /// </summary>
        public TriggerEvent? KnockOut { get; }
    }
    
    /// <summary>
    /// The pricing period per calculation period if the pricing days do not wholly fall within the respective calculation period.
    /// </summary>
    public class Lag : AbstractRosettaModelObject<Lag>
    {
        private static readonly IRosettaMetaData<Lag> metaData = new LagMeta();
        
        [JsonConstructor]
        public Lag(Offset lagDuration, Offset? firstObservationDateOffset)
        {
            LagDuration = lagDuration;
            FirstObservationDateOffset = firstObservationDateOffset;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Lag> MetaData => metaData;
        
        /// <summary>
        /// Defines the offset of the series of pricing dates relative to the calculation period.
        /// </summary>
        public Offset LagDuration { get; }
        
        /// <summary>
        /// Defines the offset of the series of pricing dates relative to the calculation period.
        /// </summary>
        public Offset? FirstObservationDateOffset { get; }
    }
    
    /// <summary>
    /// Bespoke language removing the pre-print requirement to transfer legal title of securities collateral through written instructions to the relevant depository institution or other securities intermediaries solely for the purposes of the 1994 New York Law Credit Support Annex.
    /// </summary>
    public class LegacyDefinition : AbstractRosettaModelObject<LegacyDefinition>
    {
        private static readonly IRosettaMetaData<LegacyDefinition> metaData = new LegacyDefinitionMeta();
        
        [JsonConstructor]
        public LegacyDefinition(bool? isApplicable, string? additionalLanguage)
        {
            IsApplicable = isApplicable;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyDefinition> MetaData => metaData;
        
        /// <summary>
        /// A boolean flag to represent bespoke amendment to the pre-print definition of Transfer.
        /// </summary>
        public bool? IsApplicable { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be transferred to it as a Delivery Amount.
    /// </summary>
    public class LegacyDeliveryAmount : AbstractRosettaModelObject<LegacyDeliveryAmount>
    {
        private static readonly IRosettaMetaData<LegacyDeliveryAmount> metaData = new LegacyDeliveryAmountMeta();
        
        [JsonConstructor]
        public LegacyDeliveryAmount(Enums.LegacyDeliveryReturnAmount legacyDeliveryAmount, string? additionalLanguage)
        {
            LegacyDeliveryAmountValue = legacyDeliveryAmount;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyDeliveryAmount> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether the meaning of Delivery Amount follows the pre-print definition or deviates from this (either based on a rating or some other methodology).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "legacyDeliveryAmount")]
        public Enums.LegacyDeliveryReturnAmount LegacyDeliveryAmountValue { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Specification of amendments to the calculation of Exposure in terms of the Transactions and Products covered.
    /// </summary>
    public class LegacyExposureScopeElection : AbstractRosettaModelObject<LegacyExposureScopeElection>
    {
        private static readonly IRosettaMetaData<LegacyExposureScopeElection> metaData = new LegacyExposureScopeElectionMeta();
        
        [JsonConstructor]
        public LegacyExposureScopeElection(Enums.CounterpartyRole party, bool excludedTransactions, IEnumerable<ExcludedProducts> excludedProducts, string? additionalLanguage)
        {
            Party = party;
            ExcludedTransactions = excludedTransactions;
            ExcludedProducts = excludedProducts;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyExposureScopeElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// A boolean flag to represent whether any transactions are excluded (ie True) or not (ie False).
        /// </summary>
        public bool ExcludedTransactions { get; }
        
        /// <summary>
        /// Description of the relevant derivative transactions excluded from the calculation of exposure.
        /// </summary>
        public IEnumerable<ExcludedProducts> ExcludedProducts { get; }
        
        /// <summary>
        /// The bespoke/additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Sets out the additional amount of collateral that is required to be delivered by that party irrespective of the mark-to-market exposure under the related Transactions. It may take the form of a fixed amount, or be determined using credit ratings.
    /// </summary>
    public class LegacyIndependentAmount : AbstractRosettaModelObject<LegacyIndependentAmount>
    {
        private static readonly IRosettaMetaData<LegacyIndependentAmount> metaData = new LegacyIndependentAmountMeta();
        
        [JsonConstructor]
        public LegacyIndependentAmount(IEnumerable<LegacyIndependentAmountParty> partyElection, string? additionalLanguage)
        {
            PartyElection = partyElection;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyIndependentAmount> MetaData => metaData;
        
        /// <summary>
        /// The party specific elections for the Independent Amount clause.
        /// </summary>
        public IEnumerable<LegacyIndependentAmountParty> PartyElection { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// The party specific elections for the Independent Amount clause.
    /// </summary>
    public class LegacyIndependentAmountParty : AbstractRosettaModelObject<LegacyIndependentAmountParty>
    {
        private static readonly IRosettaMetaData<LegacyIndependentAmountParty> metaData = new LegacyIndependentAmountPartyMeta();
        
        [JsonConstructor]
        public LegacyIndependentAmountParty(Enums.CounterpartyRole party, bool isApplicable, Money? fixedAmount, LegacyIndependentAmountRatingsBased? ratingsBased, LegacyIndependentAmountRatingsXExposure? ratingsXExposure)
        {
            Party = party;
            IsApplicable = isApplicable;
            FixedAmount = fixedAmount;
            RatingsBased = ratingsBased;
            RatingsXExposure = ratingsXExposure;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyIndependentAmountParty> MetaData => metaData;
        
        /// <summary>
        /// Identifies the Party making the election.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// Specifies whether Independent Amount is applicable to the elected party. If applicable, &apos;True&apos;, and if not applicable then &apos;False&apos;.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// Indicates the Independent Amount is specified as a fixed amount.
        /// </summary>
        public Money? FixedAmount { get; }
        
        /// <summary>
        /// Indicates the Independent Amount is determined using a credit rating.
        /// </summary>
        public LegacyIndependentAmountRatingsBased? RatingsBased { get; }
        
        /// <summary>
        /// Indicates the Independent Amount is determined using both credit rating and exposure metrics.
        /// </summary>
        public LegacyIndependentAmountRatingsXExposure? RatingsXExposure { get; }
    }
    
    /// <summary>
    /// Specifies that the Independent Amount is determined using a credit rating.
    /// </summary>
    public class LegacyIndependentAmountRatingsBased : AbstractRosettaModelObject<LegacyIndependentAmountRatingsBased>, IIndependentAmountRatings
    {
        private static readonly IRosettaMetaData<LegacyIndependentAmountRatingsBased> metaData = new LegacyIndependentAmountRatingsBasedMeta();
        
        [JsonConstructor]
        public LegacyIndependentAmountRatingsBased(Enums.IndependentAmountCompare compare, Enums.RatedParty ratedParty, LegalEntity? namedAffiliate, LegalEntity? namedEntity, Enums.RatingType ratingType, IEnumerable<RatingAgencyAmount> variableSet, FieldWithMetaString? currency)
        {
            Compare = compare;
            RatedParty = ratedParty;
            NamedAffiliate = namedAffiliate;
            NamedEntity = namedEntity;
            RatingType = ratingType;
            VariableSet = variableSet;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyIndependentAmountRatingsBased> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndependentAmountCompare Compare { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatedParty RatedParty { get; }
        
        /// <inheritdoc/>
        public LegalEntity? NamedAffiliate { get; }
        
        /// <inheritdoc/>
        public LegalEntity? NamedEntity { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatingType RatingType { get; }
        
        /// <summary>
        /// A logical container designed to hold a defined set of related data. In this case the collation of Rating Information and an associated Independent Amount.
        /// </summary>
        public IEnumerable<RatingAgencyAmount> VariableSet { get; }
        
        /// <summary>
        /// Specifies the currency applicable to the relevant Independent Amount.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
    }
    
    /// <summary>
    /// Specifies that the Independent Amount is determined using both credit rating and exposure metrics.
    /// </summary>
    public class LegacyIndependentAmountRatingsXExposure : AbstractRosettaModelObject<LegacyIndependentAmountRatingsXExposure>, IIndependentAmountRatings
    {
        private static readonly IRosettaMetaData<LegacyIndependentAmountRatingsXExposure> metaData = new LegacyIndependentAmountRatingsXExposureMeta();
        
        [JsonConstructor]
        public LegacyIndependentAmountRatingsXExposure(Enums.IndependentAmountCompare compare, Enums.RatedParty ratedParty, LegalEntity? namedAffiliate, LegalEntity? namedEntity, Enums.RatingType ratingType, IEnumerable<RatingMultiplier> highestLowestVariableSet, IEnumerable<DirectionRatingMultiplier> compareVariableSet)
        {
            Compare = compare;
            RatedParty = ratedParty;
            NamedAffiliate = namedAffiliate;
            NamedEntity = namedEntity;
            RatingType = ratingType;
            HighestLowestVariableSet = highestLowestVariableSet;
            CompareVariableSet = compareVariableSet;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyIndependentAmountRatingsXExposure> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.IndependentAmountCompare Compare { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatedParty RatedParty { get; }
        
        /// <inheritdoc/>
        public LegalEntity? NamedAffiliate { get; }
        
        /// <inheritdoc/>
        public LegalEntity? NamedEntity { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatingType RatingType { get; }
        
        /// <summary>
        /// A logical container to hold a defined set of related data. In this case the collation of Ratings Information and associated exposure multiplier where highest or lowest of the associated credit ratings are used when determining the applicable Independent Amount.
        /// </summary>
        public IEnumerable<RatingMultiplier> HighestLowestVariableSet { get; }
        
        /// <summary>
        /// A logical container to hold a defined set of related data. In this case the collation of Ratings Information and associated exposure multiplier where multiple credit ratings are compared when determining the applicable Independent Amount.
        /// </summary>
        public IEnumerable<DirectionRatingMultiplier> CompareVariableSet { get; }
    }
    
    /// <summary>
    /// Alternative procedures to those in the pre-print for resolving collateral related disputes.
    /// </summary>
    public class LegacyResolutionAlternative : AbstractRosettaModelObject<LegacyResolutionAlternative>
    {
        private static readonly IRosettaMetaData<LegacyResolutionAlternative> metaData = new LegacyResolutionAlternativeMeta();
        
        [JsonConstructor]
        public LegacyResolutionAlternative(Enums.LegacyResolutionAlternative? resolutionAlternative, Money? amount, string? additionalLanguage)
        {
            ResolutionAlternative = resolutionAlternative;
            Amount = amount;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyResolutionAlternative> MetaData => metaData;
        
        /// <summary>
        /// Details of the alternative dispute resolution procedure (if any).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.LegacyResolutionAlternative? ResolutionAlternative { get; }
        
        /// <summary>
        /// The maximum amount to which the difference between the calculations by the valuation agent and disputing party can be split, where Split the Difference is elected.
        /// </summary>
        public Money? Amount { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be recalled to it as a Return Amount.
    /// </summary>
    public class LegacyReturnAmount : AbstractRosettaModelObject<LegacyReturnAmount>
    {
        private static readonly IRosettaMetaData<LegacyReturnAmount> metaData = new LegacyReturnAmountMeta();
        
        [JsonConstructor]
        public LegacyReturnAmount(Enums.LegacyDeliveryReturnAmount legacyReturnAmount, string? additionalLanguage)
        {
            LegacyReturnAmountValue = legacyReturnAmount;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyReturnAmount> MetaData => metaData;
        
        /// <summary>
        /// Specifies whether the meaning of Return Amount follows the pre-print definition or deviates from this (either based on a rating or some other methodology).
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "legacyReturnAmount")]
        public Enums.LegacyDeliveryReturnAmount LegacyReturnAmountValue { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// Specification of transfer / settlement timing for cash and securities collateral assuming that the notice is provided before the Notification Time (and with a 1LBD lag introduced if the notice is delivered after the Notification Time), and that securities allow for a further Local Business Day for transfer / settlement.
    /// </summary>
    public class LegacyTransferSettlementTiming : AbstractRosettaModelObject<LegacyTransferSettlementTiming>
    {
        private static readonly IRosettaMetaData<LegacyTransferSettlementTiming> metaData = new LegacyTransferSettlementTimingMeta();
        
        [JsonConstructor]
        public LegacyTransferSettlementTiming(Enums.CashCTSTime? cashCollateralTransferSettlementTime, Enums.SecuritiesCTSTime? securititesCollateralTransferSettlementTime, string? additionalLanguage)
        {
            CashCollateralTransferSettlementTime = cashCollateralTransferSettlementTime;
            SecurititesCollateralTransferSettlementTime = securititesCollateralTransferSettlementTime;
            AdditionalLanguage = additionalLanguage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegacyTransferSettlementTiming> MetaData => metaData;
        
        /// <summary>
        /// Details the day on which collateral is required to be transferred relative to the Notification Time.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CashCTSTime? CashCollateralTransferSettlementTime { get; }
        
        /// <summary>
        /// Details the day on which collateral is required to be transferred relative to the Notification Time.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.SecuritiesCTSTime? SecurititesCollateralTransferSettlementTime { get; }
        
        /// <summary>
        /// The additional language that might be specified by the parties to the legal agreement.
        /// </summary>
        public string? AdditionalLanguage { get; }
    }
    
    /// <summary>
    /// The specification of a legal agreement between two parties, being negotiated or having been executed. This includes the baseline information and the optional specialised elections
    /// </summary>
    public class LegalAgreement : AbstractRosettaModelObject<LegalAgreement>, ILegalAgreementBase
    {
        private static readonly IRosettaMetaData<LegalAgreement> metaData = new LegalAgreementMeta();
        
        [JsonConstructor]
        public LegalAgreement(LocalDate? agreementDate, LocalDate? effectiveDate, IEnumerable<Identifier> identifier, LegalAgreementIdentification legalAgreementIdentification, IEnumerable<ReferenceWithMetaParty> contractualParty, IEnumerable<PartyRole> otherParty, IEnumerable<Resource> attachment, AgreementTerms? agreementTerms, IEnumerable<LegalAgreement> relatedAgreements, UmbrellaAgreement? umbrellaAgreement, _MetaFields? meta)
        {
            AgreementDate = agreementDate;
            EffectiveDate = effectiveDate;
            Identifier = identifier;
            LegalAgreementIdentification = legalAgreementIdentification;
            ContractualParty = contractualParty;
            OtherParty = otherParty;
            Attachment = attachment;
            AgreementTerms = agreementTerms;
            RelatedAgreements = relatedAgreements;
            UmbrellaAgreement = umbrellaAgreement;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegalAgreement> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AgreementDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Identifier> Identifier { get; }
        
        /// <inheritdoc/>
        public LegalAgreementIdentification LegalAgreementIdentification { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaParty> ContractualParty { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> OtherParty { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Resource> Attachment { get; }
        
        /// <summary>
        /// Specification of the content of the legal agreement.
        /// </summary>
        public AgreementTerms? AgreementTerms { get; }
        
        /// <summary>
        /// Specifies the agreement(s) that govern the agreement, either as a reference to such agreements when specified as part of the CDM, or through identification of some of the key terms of those agreements, such as the type of agreement, the publisher, the vintage, the agreement identifier and the agreement date.
        /// </summary>
        public IEnumerable<LegalAgreement> RelatedAgreements { get; }
        
        /// <summary>
        /// The determination of whether Umbrella Agreement terms are applicable (True) or Not Applicable (False).
        /// </summary>
        public UmbrellaAgreement? UmbrellaAgreement { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies the legal agreement baseline information, being negotiated or having been executed. It excludes specialized elections
    /// </summary>
    public class LegalAgreementBase : AbstractRosettaModelObject<LegalAgreementBase>, ILegalAgreementBase
    {
        private static readonly IRosettaMetaData<LegalAgreementBase> metaData = new LegalAgreementBaseMeta();
        
        [JsonConstructor]
        public LegalAgreementBase(LocalDate? agreementDate, LocalDate? effectiveDate, IEnumerable<Identifier> identifier, LegalAgreementIdentification legalAgreementIdentification, IEnumerable<ReferenceWithMetaParty> contractualParty, IEnumerable<PartyRole> otherParty, IEnumerable<Resource> attachment)
        {
            AgreementDate = agreementDate;
            EffectiveDate = effectiveDate;
            Identifier = identifier;
            LegalAgreementIdentification = legalAgreementIdentification;
            ContractualParty = contractualParty;
            OtherParty = otherParty;
            Attachment = attachment;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegalAgreementBase> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AgreementDate { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? EffectiveDate { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Identifier> Identifier { get; }
        
        /// <inheritdoc/>
        public LegalAgreementIdentification LegalAgreementIdentification { get; }
        
        /// <inheritdoc/>
        public IEnumerable<ReferenceWithMetaParty> ContractualParty { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> OtherParty { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Resource> Attachment { get; }
    }
    
    /// <summary>
    /// Specifies the type of legal agreement, identified via a set of composable attributes: agreementName, publisher, governing law and version, e.g. ISDA 2013 Standard Credit Support Annex English Law.
    /// </summary>
    public class LegalAgreementIdentification : AbstractRosettaModelObject<LegalAgreementIdentification>
    {
        private static readonly IRosettaMetaData<LegalAgreementIdentification> metaData = new LegalAgreementIdentificationMeta();
        
        [JsonConstructor]
        public LegalAgreementIdentification(Enums.GoverningLaw? governingLaw, AgreementName agreementName, Enums.LegalAgreementPublisher? publisher, int? vintage)
        {
            GoverningLaw = governingLaw;
            AgreementName = agreementName;
            Publisher = publisher;
            Vintage = vintage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegalAgreementIdentification> MetaData => metaData;
        
        /// <summary>
        /// The law governing the legal agreement, e.g. English Law, New York Law or Japanese Law.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.GoverningLaw? GoverningLaw { get; }
        
        /// <summary>
        /// The legal agreement name, e.g. Credit Support Annex for Variation Margin.
        /// </summary>
        public AgreementName AgreementName { get; }
        
        /// <summary>
        /// The legal agreement publisher, e.g. ISDA.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.LegalAgreementPublisher? Publisher { get; }
        
        /// <summary>
        /// In the case where successive definitions of the legal agreement have been developed, the vintage identification. This is typically (but not necessarily) done by referencing the year, e.g. 2013 in the case of the ISDA 2013 Standard Credit Support Annex.
        /// </summary>
        public int? Vintage { get; }
    }
    
    /// <summary>
    /// A class to specify a legal entity, with a required name and an optional entity identifier (such as the LEI).
    /// </summary>
    public class LegalEntity : AbstractRosettaModelObject<LegalEntity>, ILegalEntity
    {
        private static readonly IRosettaMetaData<LegalEntity> metaData = new LegalEntityMeta();
        
        [JsonConstructor]
        public LegalEntity(IEnumerable<FieldWithMetaString> entityId, FieldWithMetaString name, _MetaFields? meta)
        {
            EntityId = entityId;
            Name = name;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LegalEntity> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<FieldWithMetaString> EntityId { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString Name { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    public class LimitApplicable : AbstractRosettaModelObject<LimitApplicable>, ILimitApplicable
    {
        private static readonly IRosettaMetaData<LimitApplicable> metaData = new LimitApplicableMeta();
        
        [JsonConstructor]
        public LimitApplicable(FieldWithMetaCreditLimitTypeEnum? limitType, int? clipSize, decimal? amountUtilized, CreditLimitUtilisation? utilization, decimal? amountRemaining, FieldWithMetaString? currency, Velocity? velocity)
        {
            LimitType = limitType;
            ClipSize = clipSize;
            AmountUtilized = amountUtilized;
            Utilization = utilization;
            AmountRemaining = amountRemaining;
            Currency = currency;
            Velocity = velocity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LimitApplicable> MetaData => metaData;
        
        /// <inheritdoc/>
        public FieldWithMetaCreditLimitTypeEnum? LimitType { get; }
        
        /// <inheritdoc/>
        public int? ClipSize { get; }
        
        /// <inheritdoc/>
        public decimal? AmountUtilized { get; }
        
        public CreditLimitUtilisation? Utilization { get; }
        
        /// <inheritdoc/>
        public decimal? AmountRemaining { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Currency { get; }
        
        public Velocity? Velocity { get; }
    }
    
    /// <summary>
    /// A class to represent the CDM attributes that are not part of the FpML standard. Once broader usage is confirmed, it is expected that those two classes can be collapsed.
    /// </summary>
    public class LimitApplicableExtended : AbstractRosettaModelObject<LimitApplicableExtended>, ILimitApplicable
    {
        private static readonly IRosettaMetaData<LimitApplicableExtended> metaData = new LimitApplicableExtendedMeta();
        
        [JsonConstructor]
        public LimitApplicableExtended(FieldWithMetaCreditLimitTypeEnum? limitType, int? clipSize, decimal? amountUtilized, CreditLimitUtilisation? utilization, decimal? amountRemaining, FieldWithMetaString? currency, Velocity? velocity, FieldWithMetaLimitLevelEnum? limitLevel, decimal? limitAmount, decimal? limitImpactDueToTrade)
        {
            LimitType = limitType;
            ClipSize = clipSize;
            AmountUtilized = amountUtilized;
            Utilization = utilization;
            AmountRemaining = amountRemaining;
            Currency = currency;
            Velocity = velocity;
            LimitLevel = limitLevel;
            LimitAmount = limitAmount;
            LimitImpactDueToTrade = limitImpactDueToTrade;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LimitApplicableExtended> MetaData => metaData;
        
        /// <inheritdoc/>
        public FieldWithMetaCreditLimitTypeEnum? LimitType { get; }
        
        /// <inheritdoc/>
        public int? ClipSize { get; }
        
        /// <inheritdoc/>
        public decimal? AmountUtilized { get; }
        
        public CreditLimitUtilisation? Utilization { get; }
        
        /// <inheritdoc/>
        public decimal? AmountRemaining { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Currency { get; }
        
        public Velocity? Velocity { get; }
        
        /// <summary>
        /// The level at which the limit is set: customer business, proprietary business or account level. This attribute is specified as a string as part of the CME clearing confirmation specification.
        /// </summary>
        public FieldWithMetaLimitLevelEnum? LimitLevel { get; }
        
        /// <summary>
        /// The total limit available for the limit level and limit type. While the attribute is of type integer in the CME schema, it has been specified to be of type number in the CDM to take into consideration java size limits as well as for consistency purposes with the way most monetary amounts are expressed.
        /// </summary>
        public decimal? LimitAmount { get; }
        
        /// <summary>
        /// The limit utilized by this specific trade. While the attribute is of type integer in the CME schema, it has been specified to be of type number in the CDM to take into consideration java size limits as well as for consistency purposes with the way most monetary amounts are expressed.
        /// </summary>
        public decimal? LimitImpactDueToTrade { get; }
    }
    
    /// <summary>
    /// A class to provide lineage information across lifecycle events through a pointer or set of pointers into the event(s), contract(s) and, possibly, payout components that the event is dependent on or relates to. As an example, if an contractFormation event is corrected, the correction event will have a lineage into the initial event, which takes the form of a globalKey into that initial contract formation event. Two referencing mechanisms are provided as part of the CDM: either the globalKey, which corresponds to the hash value of the CDM class which is referred to, or a reference qualifier which is meant to provide support for the ingestion of xml documents with id/href mechanisms. The CDM recommends the use of the globalKey and provides a default implementation which is accessible in the generated code through org.isda.cdm.globalKey.GlobalKeyHashCalculator. If implementers want to use an alternative hashing mechanism, the API in which they need to plug it is com.rosetta.model.lib.HashFunction.
    /// </summary>
    public class Lineage : AbstractRosettaModelObject<Lineage>
    {
        private static readonly IRosettaMetaData<Lineage> metaData = new LineageMeta();
        
        [JsonConstructor]
        public Lineage(IEnumerable<ReferenceWithMetaTrade> tradeReference, IEnumerable<ReferenceWithMetaWorkflowStep> eventReference, IEnumerable<ReferenceWithMetaPortfolioState> portfolioStateReference)
        {
            TradeReference = tradeReference;
            EventReference = eventReference;
            PortfolioStateReference = portfolioStateReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Lineage> MetaData => metaData;
        
        public IEnumerable<ReferenceWithMetaTrade> TradeReference { get; }
        
        /// <summary>
        /// The reference to the instantiation of an Event object, either through a globalKey or an xml-derived id/href mechanism. The definition associated to the Lineage class provides more details with respect to those referencing approaches, their expected usage and available implementation.
        /// </summary>
        public IEnumerable<ReferenceWithMetaWorkflowStep> EventReference { get; }
        
        /// <summary>
        /// The reference to the previous state of a Portfolio, in a chain of Events leading up to a build of that Portfolio as the holding of Product(s) in specific Quantity(ies). As part of the PortfolioState object, a pointer to the previous PortfolioState is provided through a Lineage object, together with pointer(s) to the Event or set of Events leading up to the current (new) state.
        /// </summary>
        public IEnumerable<ReferenceWithMetaPortfolioState> PortfolioStateReference { get; }
    }
    
    /// <summary>
    /// A securitized derivative on another asset.
    /// </summary>
    public class ListedDerivative : AbstractRosettaModelObject<ListedDerivative>, IInstrumentBase
    {
        private static readonly IRosettaMetaData<ListedDerivative> metaData = new ListedDerivativeMeta();
        
        [JsonConstructor]
        public ListedDerivative(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, Enums.InstrumentType instrumentType, string? deliveryTerm, Enums.PutCall? optionType, decimal? strike)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            InstrumentType = instrumentType;
            DeliveryTerm = deliveryTerm;
            OptionType = optionType;
            Strike = strike;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ListedDerivative> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InstrumentType InstrumentType { get; }
        
        /// <summary>
        /// Also called contract month or delivery month. However, it&apos;s not always a month. It is usually expressed using a code, e.g. Z23 would be the Dec 2023 contract, (Z = December). For crude oil, the corresponding contract might be called CLZ23. Optional as this can be uniquely identified in the identifier.
        /// </summary>
        public string? DeliveryTerm { get; }
        
        /// <summary>
        /// The type of option, ie Put or Call. Left empty if it is a Future.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PutCall? OptionType { get; }
        
        /// <summary>
        /// Specifies the strike of the option.
        /// </summary>
        public decimal? Strike { get; }
    }
    
    /// <summary>
    /// Specifies a filter based on a stock exchange.
    /// </summary>
    public class ListingExchange : AbstractRosettaModelObject<ListingExchange>
    {
        private static readonly IRosettaMetaData<ListingExchange> metaData = new ListingExchangeMeta();
        
        [JsonConstructor]
        public ListingExchange(IEnumerable<FieldWithMetaString> exchange)
        {
            Exchange = exchange;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ListingExchange> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter based on the Primary Stock Exchange facilitating the listing of companies, exchange of Stocks, Exchange traded Derivatives, Bonds, and other Securities expressed in ISO standard 10383.
        /// </summary>
        public IEnumerable<FieldWithMetaString> Exchange { get; }
    }
    
    /// <summary>
    /// Specifies a filter based on an industry sector.
    /// </summary>
    public class ListingSector : AbstractRosettaModelObject<ListingSector>
    {
        private static readonly IRosettaMetaData<ListingSector> metaData = new ListingSectorMeta();
        
        [JsonConstructor]
        public ListingSector(IEnumerable<FieldWithMetaString> sector)
        {
            Sector = sector;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ListingSector> MetaData => metaData;
        
        /// <summary>
        /// Represents a filter based on an industry sector defined under a system for classifying industry types such as Global Industry Classification Standard (GICS) and North American Industry Classification System (NAICS)
        /// </summary>
        public IEnumerable<FieldWithMetaString> Sector { get; }
    }
    
    /// <summary>
    /// Identifies a loan by referencing an asset identifier and through an optional set of attributes.
    /// </summary>
    public class Loan : AbstractRosettaModelObject<Loan>, IInstrumentBase
    {
        private static readonly IRosettaMetaData<Loan> metaData = new LoanMeta();
        
        [JsonConstructor]
        public Loan(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, Enums.InstrumentType instrumentType, IEnumerable<LegalEntity> borrower, FieldWithMetaString? lien, FieldWithMetaString? facilityType, LocalDate? creditAgreementDate, FieldWithMetaString? tranche)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            InstrumentType = instrumentType;
            Borrower = borrower;
            Lien = lien;
            FacilityType = facilityType;
            CreditAgreementDate = creditAgreementDate;
            Tranche = tranche;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Loan> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InstrumentType InstrumentType { get; }
        
        /// <summary>
        /// Specifies the borrower. There can be more than one borrower. It is meant to be used in the event that there is no Bloomberg Id or the Secured List isn&apos;t applicable.
        /// </summary>
        public IEnumerable<LegalEntity> Borrower { get; }
        
        /// <summary>
        /// Specifies the seniority level of the lien.
        /// </summary>
        public FieldWithMetaString? Lien { get; }
        
        /// <summary>
        /// Specifies the type of loan facility (letter of credit, revolving, ...).
        /// </summary>
        public FieldWithMetaString? FacilityType { get; }
        
        /// <summary>
        /// Specifies the credit agreement date is the closing date (the date where the agreement has been signed) for the loans in the credit agreement. Funding of the facilities occurs on (or sometimes a little after) the Credit Agreement date. This underlier attribute is used to help identify which of the company&apos;s outstanding loans are being referenced by knowing to which credit agreement it belongs. ISDA Standards Terms Supplement term: Date of Original Credit Agreement.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? CreditAgreementDate { get; }
        
        /// <summary>
        /// Denotes the loan tranche that is subject to the derivative transaction. It will typically be referenced as the Bloomberg tranche number. ISDA Standards Terms Supplement term: Bloomberg Tranche Number.
        /// </summary>
        public FieldWithMetaString? Tranche { get; }
    }
    
    /// <summary>
    /// A class to specify loan with a participation agreement whereby the buyer is capable of creating, or procuring the creation of, a contractual right in favour of the seller that provides the seller with recourse to the participation seller for a specified share in any payments due under the relevant loan which are received by the participation seller. ISDA 2003 Term: Direct Loan Participation.
    /// </summary>
    public class LoanParticipation : AbstractRosettaModelObject<LoanParticipation>, IPCDeliverableObligationCharac
    {
        private static readonly IRosettaMetaData<LoanParticipation> metaData = new LoanParticipationMeta();
        
        [JsonConstructor]
        public LoanParticipation(bool applicable, bool? partialCashSettlement, string? qualifyingParticipationSeller)
        {
            Applicable = applicable;
            PartialCashSettlement = partialCashSettlement;
            QualifyingParticipationSeller = qualifyingParticipationSeller;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LoanParticipation> MetaData => metaData;
        
        /// <inheritdoc/>
        public bool Applicable { get; }
        
        /// <inheritdoc/>
        public bool? PartialCashSettlement { get; }
        
        /// <summary>
        /// If Direct Loan Participation is specified as a deliverable obligation characteristic, this specifies any requirements for the Qualifying Participation Seller. The requirements may be listed free-form. ISDA 2003 Term: Qualifying Participation Seller.
        /// </summary>
        public string? QualifyingParticipationSeller { get; }
    }
    
    /// <summary>
    /// Specifies a location identifier. An issuer and an identifier type can be associated with the actual identifier value as a way to properly qualify it.
    /// </summary>
    public class LocationIdentifier : AbstractRosettaModelObject<LocationIdentifier>, IIdentifier
    {
        private static readonly IRosettaMetaData<LocationIdentifier> metaData = new LocationIdentifierMeta();
        
        [JsonConstructor]
        public LocationIdentifier(ReferenceWithMetaParty? issuerReference, FieldWithMetaString? issuer, IEnumerable<AssignedIdentifier> assignedIdentifier, _MetaFields? meta, Enums.CommodityLocationIdentifierType? locationIdentifierType)
        {
            IssuerReference = issuerReference;
            Issuer = issuer;
            AssignedIdentifier = assignedIdentifier;
            Meta = meta;
            LocationIdentifierType = locationIdentifierType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<LocationIdentifier> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty? IssuerReference { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Issuer { get; }
        
        /// <inheritdoc/>
        public IEnumerable<AssignedIdentifier> AssignedIdentifier { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <summary>
        /// Specifies the nature of a location identifier.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CommodityLocationIdentifierType? LocationIdentifierType { get; }
    }
    
    /// <summary>
    /// A class to specify the amount to be paid by the buyer of the option if the option is exercised prior to the Early Call Date (typically applicable to the convertible bond options).
    /// </summary>
    public class MakeWholeAmount : AbstractRosettaModelObject<MakeWholeAmount>, ISwapCurveValuation
    {
        private static readonly IRosettaMetaData<MakeWholeAmount> metaData = new MakeWholeAmountMeta();
        
        [JsonConstructor]
        public MakeWholeAmount(Enums.FloatingRateIndex floatingRateIndex, Period? indexTenor, decimal spread, Enums.QuotationSide? side, Enums.InterpolationMethod? interpolationMethod, FieldWithMetaLocalDate earlyCallDate)
        {
            FloatingRateIndex = floatingRateIndex;
            IndexTenor = indexTenor;
            Spread = spread;
            Side = side;
            InterpolationMethod = interpolationMethod;
            EarlyCallDate = earlyCallDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MakeWholeAmount> MetaData => metaData;
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.FloatingRateIndex FloatingRateIndex { get; }
        
        /// <inheritdoc/>
        public Period? IndexTenor { get; }
        
        /// <inheritdoc/>
        public decimal Spread { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.QuotationSide? Side { get; }
        
        /// <summary>
        /// The type of interpolation method that the calculation agent reserves the right to use.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.InterpolationMethod? InterpolationMethod { get; }
        
        /// <summary>
        /// Date prior to which the option buyer will have to pay a Make Whole Amount to the option seller if he/she exercises the option.
        /// </summary>
        public FieldWithMetaLocalDate EarlyCallDate { get; }
    }
    
    /// <summary>
    /// A data to:  define an early termination provision for which exercise is mandatory.
    /// </summary>
    public class MandatoryEarlyTermination : AbstractRosettaModelObject<MandatoryEarlyTermination>
    {
        private static readonly IRosettaMetaData<MandatoryEarlyTermination> metaData = new MandatoryEarlyTerminationMeta();
        
        [JsonConstructor]
        public MandatoryEarlyTermination(AdjustableDate mandatoryEarlyTerminationDate, CalculationAgent calculationAgent, SettlementTerms cashSettlement, MandatoryEarlyTerminationAdjustedDates? mandatoryEarlyTerminationAdjustedDates, _MetaFields? meta)
        {
            MandatoryEarlyTerminationDate = mandatoryEarlyTerminationDate;
            CalculationAgent = calculationAgent;
            CashSettlement = cashSettlement;
            MandatoryEarlyTerminationAdjustedDates = mandatoryEarlyTerminationAdjustedDates;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MandatoryEarlyTermination> MetaData => metaData;
        
        /// <summary>
        /// The early termination date associated with a mandatory early termination of a swap.
        /// </summary>
        public AdjustableDate MandatoryEarlyTerminationDate { get; }
        
        /// <summary>
        /// The ISDA Calculation Agent responsible for performing duties associated with an optional early termination.
        /// </summary>
        public CalculationAgent CalculationAgent { get; }
        
        /// <summary>
        /// If specified, this means that cash settlement is applicable to the transaction and defines the parameters associated with the cash settlement procedure. If not specified, then physical settlement is applicable.
        /// </summary>
        public SettlementTerms CashSettlement { get; }
        
        /// <summary>
        /// The adjusted dates associated with a mandatory early termination provision. These dates have been adjusted for any applicable business day convention.
        /// </summary>
        public MandatoryEarlyTerminationAdjustedDates? MandatoryEarlyTerminationAdjustedDates { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted dates associated with a mandatory early termination provision.
    /// </summary>
    public class MandatoryEarlyTerminationAdjustedDates : AbstractRosettaModelObject<MandatoryEarlyTerminationAdjustedDates>
    {
        private static readonly IRosettaMetaData<MandatoryEarlyTerminationAdjustedDates> metaData = new MandatoryEarlyTerminationAdjustedDatesMeta();
        
        [JsonConstructor]
        public MandatoryEarlyTerminationAdjustedDates(LocalDate adjustedEarlyTerminationDate, LocalDate adjustedCashSettlementValuationDate, LocalDate adjustedCashSettlementPaymentDate)
        {
            AdjustedEarlyTerminationDate = adjustedEarlyTerminationDate;
            AdjustedCashSettlementValuationDate = adjustedCashSettlementValuationDate;
            AdjustedCashSettlementPaymentDate = adjustedCashSettlementPaymentDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MandatoryEarlyTerminationAdjustedDates> MetaData => metaData;
        
        /// <summary>
        /// The early termination date that is applicable if an early termination provision is exercised. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedEarlyTerminationDate { get; }
        
        /// <summary>
        /// The date by which the cash settlement amount must be agreed. This date should already be adjusted for any applicable business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedCashSettlementValuationDate { get; }
        
        /// <summary>
        /// The date on which the cash settlement amount is paid. This date should already be adjusted for any applicable business date convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate AdjustedCashSettlementPaymentDate { get; }
    }
    
    /// <summary>
    /// A class defining manual exercise, i.e. that the option buyer counterparty must give notice to the option seller of exercise.
    /// </summary>
    public class ManualExercise : AbstractRosettaModelObject<ManualExercise>
    {
        private static readonly IRosettaMetaData<ManualExercise> metaData = new ManualExerciseMeta();
        
        [JsonConstructor]
        public ManualExercise(ExerciseNotice? exerciseNotice, bool? fallbackExercise)
        {
            ExerciseNotice = exerciseNotice;
            FallbackExercise = fallbackExercise;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ManualExercise> MetaData => metaData;
        
        /// <summary>
        /// Definition of the party to whom notice of exercise should be given.
        /// </summary>
        public ExerciseNotice? ExerciseNotice { get; }
        
        /// <summary>
        /// If fallback exercise is specified then the notional amount of the underlying swap, not previously exercised under the swaption, will be automatically exercised at the expiration time on the expiration date if at such time the buyer is in-the-money, provided that the difference between the settlement rate and the fixed rate under the relevant underlying swap is not less than one tenth of a percentage point (0.10% or 0.001). The term in-the-money is assumed to have the meaning defined in the 2000 ISDA Definitions, Section 17.4. In-the-money.
        /// </summary>
        public bool? FallbackExercise { get; }
    }
    
    /// <summary>
    /// A class for selection of Margin Approach.
    /// </summary>
    public class MarginApproach : AbstractRosettaModelObject<MarginApproach>
    {
        private static readonly IRosettaMetaData<MarginApproach> metaData = new MarginApproachMeta();
        
        [JsonConstructor]
        public MarginApproach(Enums.MarginApproach marginApproach)
        {
            MarginApproachValue = marginApproach;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginApproach> MetaData => metaData;
        
        /// <summary>
        /// Specifies the margin approach specific to Initial Margin agreements.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "marginApproach")]
        public Enums.MarginApproach MarginApproachValue { get; }
    }
    
    /// <summary>
    /// Represents common attributes required for Issuance and Response to a Margin Call action as a result of a demand for delivery or return of collateral determined under a legal agreement such as a credit support document or equivalent.
    /// </summary>
    public class MarginCallBase : AbstractRosettaModelObject<MarginCallBase>, IMarginCallBase
    {
        private static readonly IRosettaMetaData<MarginCallBase> metaData = new MarginCallBaseMeta();
        
        [JsonConstructor]
        public MarginCallBase(MarginCallInstructionType instructionType, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Party? clearingBroker, Identifier? callIdentifier, AgreementName callAgreementType, Money? agreementMinimumTransferAmount, Money? agreementThreshold, Money? agreementRounding, Enums.RegMarginType regMarginType, Enums.RegIMRole? regIMRole, MarginCallExposure? baseCurrencyExposure, ReferenceWithMetaCollateralPortfolio? collateralPortfolio, CollateralBalance? independentAmountBalance)
        {
            InstructionType = instructionType;
            Party = party;
            PartyRole = partyRole;
            ClearingBroker = clearingBroker;
            CallIdentifier = callIdentifier;
            CallAgreementType = callAgreementType;
            AgreementMinimumTransferAmount = agreementMinimumTransferAmount;
            AgreementThreshold = agreementThreshold;
            AgreementRounding = agreementRounding;
            RegMarginType = regMarginType;
            RegIMRole = regIMRole;
            BaseCurrencyExposure = baseCurrencyExposure;
            CollateralPortfolio = collateralPortfolio;
            IndependentAmountBalance = independentAmountBalance;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public MarginCallInstructionType InstructionType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        public Party? ClearingBroker { get; }
        
        /// <inheritdoc/>
        public Identifier? CallIdentifier { get; }
        
        /// <inheritdoc/>
        public AgreementName CallAgreementType { get; }
        
        /// <inheritdoc/>
        public Money? AgreementMinimumTransferAmount { get; }
        
        /// <inheritdoc/>
        public Money? AgreementThreshold { get; }
        
        /// <inheritdoc/>
        public Money? AgreementRounding { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegMarginType RegMarginType { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegIMRole? RegIMRole { get; }
        
        /// <inheritdoc/>
        public MarginCallExposure? BaseCurrencyExposure { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateralPortfolio? CollateralPortfolio { get; }
        
        /// <inheritdoc/>
        public CollateralBalance? IndependentAmountBalance { get; }
    }
    
    /// <summary>
    /// Represents attributes required for mark to market value or IM calculation value of the trade portfolio as recorded by the principle (in base currency).
    /// </summary>
    public class MarginCallExposure : AbstractRosettaModelObject<MarginCallExposure>, IMarginCallBase
    {
        private static readonly IRosettaMetaData<MarginCallExposure> metaData = new MarginCallExposureMeta();
        
        [JsonConstructor]
        public MarginCallExposure(MarginCallInstructionType instructionType, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Party? clearingBroker, Identifier? callIdentifier, AgreementName callAgreementType, Money? agreementMinimumTransferAmount, Money? agreementThreshold, Money? agreementRounding, Enums.RegMarginType regMarginType, Enums.RegIMRole? regIMRole, MarginCallExposure? baseCurrencyExposure, ReferenceWithMetaCollateralPortfolio? collateralPortfolio, CollateralBalance? independentAmountBalance, Exposure overallExposure, Exposure? simmIMExposure, Exposure? scheduleGridIMExposure)
        {
            InstructionType = instructionType;
            Party = party;
            PartyRole = partyRole;
            ClearingBroker = clearingBroker;
            CallIdentifier = callIdentifier;
            CallAgreementType = callAgreementType;
            AgreementMinimumTransferAmount = agreementMinimumTransferAmount;
            AgreementThreshold = agreementThreshold;
            AgreementRounding = agreementRounding;
            RegMarginType = regMarginType;
            RegIMRole = regIMRole;
            BaseCurrencyExposure = baseCurrencyExposure;
            CollateralPortfolio = collateralPortfolio;
            IndependentAmountBalance = independentAmountBalance;
            OverallExposure = overallExposure;
            SimmIMExposure = simmIMExposure;
            ScheduleGridIMExposure = scheduleGridIMExposure;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallExposure> MetaData => metaData;
        
        /// <inheritdoc/>
        public MarginCallInstructionType InstructionType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        public Party? ClearingBroker { get; }
        
        /// <inheritdoc/>
        public Identifier? CallIdentifier { get; }
        
        /// <inheritdoc/>
        public AgreementName CallAgreementType { get; }
        
        /// <inheritdoc/>
        public Money? AgreementMinimumTransferAmount { get; }
        
        /// <inheritdoc/>
        public Money? AgreementThreshold { get; }
        
        /// <inheritdoc/>
        public Money? AgreementRounding { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegMarginType RegMarginType { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegIMRole? RegIMRole { get; }
        
        /// <inheritdoc/>
        public MarginCallExposure? BaseCurrencyExposure { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateralPortfolio? CollateralPortfolio { get; }
        
        /// <inheritdoc/>
        public CollateralBalance? IndependentAmountBalance { get; }
        
        /// <summary>
        /// Represents the whole overall mark to market value or IM calculation value of the trade portfolio as recorded by the principle (in base currency).
        /// </summary>
        public Exposure OverallExposure { get; }
        
        /// <summary>
        /// Represents Initial Margin (IM) exposure derived from ISDA SIMM calculation.
        /// </summary>
        public Exposure? SimmIMExposure { get; }
        
        /// <summary>
        /// Represents Initial Margin (IM) exposure derived from schedule or Grid calculation.
        /// </summary>
        public Exposure? ScheduleGridIMExposure { get; }
    }
    
    /// <summary>
    /// Represents enumeration values to specify the call notification type, direction, specific action type.
    /// </summary>
    public class MarginCallInstructionType : AbstractRosettaModelObject<MarginCallInstructionType>
    {
        private static readonly IRosettaMetaData<MarginCallInstructionType> metaData = new MarginCallInstructionTypeMeta();
        
        [JsonConstructor]
        public MarginCallInstructionType(Enums.CallType callType, bool? visibilityIndicator)
        {
            CallType = callType;
            VisibilityIndicator = visibilityIndicator;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallInstructionType> MetaData => metaData;
        
        /// <summary>
        /// Indicates the status of the call message type, such as expected call, notification of a call or an actionable margin call.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CallType CallType { get; }
        
        /// <summary>
        /// Indicates the choice if the call instruction is visible or not to the other party.
        /// </summary>
        public bool? VisibilityIndicator { get; }
    }
    
    /// <summary>
    /// Represents common attributes required for a Margin Call Issuance under a legal agreement such as a credit support document or equivalent.
    /// </summary>
    public class MarginCallIssuance : AbstractRosettaModelObject<MarginCallIssuance>, IMarginCallBase
    {
        private static readonly IRosettaMetaData<MarginCallIssuance> metaData = new MarginCallIssuanceMeta();
        
        [JsonConstructor]
        public MarginCallIssuance(MarginCallInstructionType instructionType, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Party? clearingBroker, Identifier? callIdentifier, AgreementName callAgreementType, Money? agreementMinimumTransferAmount, Money? agreementThreshold, Money? agreementRounding, Enums.RegMarginType regMarginType, Enums.RegIMRole? regIMRole, MarginCallExposure? baseCurrencyExposure, ReferenceWithMetaCollateralPortfolio? collateralPortfolio, CollateralBalance? independentAmountBalance, Money callAmountInBaseCurrency, IEnumerable<EligibleCollateralCriteria> recallNonCashCollateralDescription)
        {
            InstructionType = instructionType;
            Party = party;
            PartyRole = partyRole;
            ClearingBroker = clearingBroker;
            CallIdentifier = callIdentifier;
            CallAgreementType = callAgreementType;
            AgreementMinimumTransferAmount = agreementMinimumTransferAmount;
            AgreementThreshold = agreementThreshold;
            AgreementRounding = agreementRounding;
            RegMarginType = regMarginType;
            RegIMRole = regIMRole;
            BaseCurrencyExposure = baseCurrencyExposure;
            CollateralPortfolio = collateralPortfolio;
            IndependentAmountBalance = independentAmountBalance;
            CallAmountInBaseCurrency = callAmountInBaseCurrency;
            RecallNonCashCollateralDescription = recallNonCashCollateralDescription;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallIssuance> MetaData => metaData;
        
        /// <inheritdoc/>
        public MarginCallInstructionType InstructionType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        public Party? ClearingBroker { get; }
        
        /// <inheritdoc/>
        public Identifier? CallIdentifier { get; }
        
        /// <inheritdoc/>
        public AgreementName CallAgreementType { get; }
        
        /// <inheritdoc/>
        public Money? AgreementMinimumTransferAmount { get; }
        
        /// <inheritdoc/>
        public Money? AgreementThreshold { get; }
        
        /// <inheritdoc/>
        public Money? AgreementRounding { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegMarginType RegMarginType { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegIMRole? RegIMRole { get; }
        
        /// <inheritdoc/>
        public MarginCallExposure? BaseCurrencyExposure { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateralPortfolio? CollateralPortfolio { get; }
        
        /// <inheritdoc/>
        public CollateralBalance? IndependentAmountBalance { get; }
        
        /// <summary>
        /// Specifies the amount of margin being called for which accounts for margin calculation inclusive of exposure, independent amount,threshold,collateral balance, MTA, rounding increments (in base currency detailed in supporting collateral agreement).
        /// </summary>
        public Money CallAmountInBaseCurrency { get; }
        
        /// <summary>
        /// Specifies the details to describe or identify non-cash collateral eligible assets for recall purposes.
        /// </summary>
        public IEnumerable<EligibleCollateralCriteria> RecallNonCashCollateralDescription { get; }
    }
    
    /// <summary>
    /// Represents common attributes required for a Margin Call Response under a legal agreement such as a credit support document or equivalent.
    /// </summary>
    public class MarginCallResponse : AbstractRosettaModelObject<MarginCallResponse>, IMarginCallBase
    {
        private static readonly IRosettaMetaData<MarginCallResponse> metaData = new MarginCallResponseMeta();
        
        [JsonConstructor]
        public MarginCallResponse(MarginCallInstructionType instructionType, IEnumerable<Party> party, IEnumerable<PartyRole> partyRole, Party? clearingBroker, Identifier? callIdentifier, AgreementName callAgreementType, Money? agreementMinimumTransferAmount, Money? agreementThreshold, Money? agreementRounding, Enums.RegMarginType regMarginType, Enums.RegIMRole? regIMRole, MarginCallExposure? baseCurrencyExposure, ReferenceWithMetaCollateralPortfolio? collateralPortfolio, CollateralBalance? independentAmountBalance, IEnumerable<MarginCallResponseAction> marginCallResponseAction, Enums.MarginCallResponseType marginResponseType, Money agreedAmountBaseCurrency)
        {
            InstructionType = instructionType;
            Party = party;
            PartyRole = partyRole;
            ClearingBroker = clearingBroker;
            CallIdentifier = callIdentifier;
            CallAgreementType = callAgreementType;
            AgreementMinimumTransferAmount = agreementMinimumTransferAmount;
            AgreementThreshold = agreementThreshold;
            AgreementRounding = agreementRounding;
            RegMarginType = regMarginType;
            RegIMRole = regIMRole;
            BaseCurrencyExposure = baseCurrencyExposure;
            CollateralPortfolio = collateralPortfolio;
            IndependentAmountBalance = independentAmountBalance;
            MarginCallResponseAction = marginCallResponseAction;
            MarginResponseType = marginResponseType;
            AgreedAmountBaseCurrency = agreedAmountBaseCurrency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallResponse> MetaData => metaData;
        
        /// <inheritdoc/>
        public MarginCallInstructionType InstructionType { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Party> Party { get; }
        
        /// <inheritdoc/>
        public IEnumerable<PartyRole> PartyRole { get; }
        
        /// <inheritdoc/>
        public Party? ClearingBroker { get; }
        
        /// <inheritdoc/>
        public Identifier? CallIdentifier { get; }
        
        /// <inheritdoc/>
        public AgreementName CallAgreementType { get; }
        
        /// <inheritdoc/>
        public Money? AgreementMinimumTransferAmount { get; }
        
        /// <inheritdoc/>
        public Money? AgreementThreshold { get; }
        
        /// <inheritdoc/>
        public Money? AgreementRounding { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegMarginType RegMarginType { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RegIMRole? RegIMRole { get; }
        
        /// <inheritdoc/>
        public MarginCallExposure? BaseCurrencyExposure { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaCollateralPortfolio? CollateralPortfolio { get; }
        
        /// <inheritdoc/>
        public CollateralBalance? IndependentAmountBalance { get; }
        
        /// <summary>
        /// Specifies the margin call action details, including collateral to be moved and direction.
        /// </summary>
        public IEnumerable<MarginCallResponseAction> MarginCallResponseAction { get; }
        
        /// <summary>
        /// Indicates the response type, such as, is the margin call response a &apos;full&apos; &apos;part&apos; agreement or &apos;dispute&apos;.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MarginCallResponseType MarginResponseType { get; }
        
        /// <summary>
        /// Indicates the amount that posting entity agrees to remit in response to margin call (in base currency).
        /// </summary>
        public Money AgreedAmountBaseCurrency { get; }
    }
    
    /// <summary>
    /// Specifies the margin call action details, including collateral to be moved and its direction.
    /// </summary>
    public class MarginCallResponseAction : AbstractRosettaModelObject<MarginCallResponseAction>
    {
        private static readonly IRosettaMetaData<MarginCallResponseAction> metaData = new MarginCallResponseActionMeta();
        
        [JsonConstructor]
        public MarginCallResponseAction(IEnumerable<CollateralPosition> collateralPositionComponent, Enums.MarginCallAction marginCallAction)
        {
            CollateralPositionComponent = collateralPositionComponent;
            MarginCallAction = marginCallAction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MarginCallResponseAction> MetaData => metaData;
        
        /// <summary>
        /// Specifies the collateral to be moved and its direction.
        /// </summary>
        public IEnumerable<CollateralPosition> CollateralPositionComponent { get; }
        
        /// <summary>
        /// Specifies the margin call action details, specified as either Delivery or Return.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MarginCallAction MarginCallAction { get; }
    }
    
    /// <summary>
    /// The set of elections that define an ISDA Master Agreement.
    /// </summary>
    public class MasterAgreement : AbstractRosettaModelObject<MasterAgreement>, IMasterAgreementBase
    {
        private static readonly IRosettaMetaData<MasterAgreement> metaData = new MasterAgreementMeta();
        
        [JsonConstructor]
        public MasterAgreement(AutomaticEarlyTermination automaticEarlyTermination, TerminationCurrency terminationCurrency, AddressForNotices addressForNotices, bool nonContractualObligations, CreditSupportDocument creditSupportDocument, CreditSupportProvider creditSupportProvider, IEnumerable<SpecifiedEntities> specifiedEntities)
        {
            AutomaticEarlyTermination = automaticEarlyTermination;
            TerminationCurrency = terminationCurrency;
            AddressForNotices = addressForNotices;
            NonContractualObligations = nonContractualObligations;
            CreditSupportDocument = creditSupportDocument;
            CreditSupportProvider = creditSupportProvider;
            SpecifiedEntities = specifiedEntities;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterAgreement> MetaData => metaData;
        
        /// <summary>
        /// The specification of whether there is an automatic occurrence of an Early Termination Date in respect of Transactions upon the occurrence of certain bankruptcy / insolvency related events.
        /// </summary>
        public AutomaticEarlyTermination AutomaticEarlyTermination { get; }
        
        /// <summary>
        /// Specification of the currency in which the termination payment is made (including the process by which such currency is determined).
        /// </summary>
        public TerminationCurrency TerminationCurrency { get; }
        
        /// <summary>
        /// Specification of the address and other details for notices.
        /// </summary>
        public AddressForNotices AddressForNotices { get; }
        
        /// <summary>
        /// Specification of whether the Governing Law clause extends to Non-Contractual Obligations (True) or does not extend to Non-Contractual Obligations (False).
        /// </summary>
        public bool NonContractualObligations { get; }
        
        /// <summary>
        /// Identification of party specific Credit Support Documents applicable to the document.
        /// </summary>
        public CreditSupportDocument CreditSupportDocument { get; }
        
        /// <summary>
        /// Identification of party specific Credit Support Providers applicable to the document.
        /// </summary>
        public CreditSupportProvider CreditSupportProvider { get; }
        
        /// <summary>
        /// A provision that allows each party to specify its Specified Entities for certain Events of Default and Termination Events.
        /// </summary>
        public IEnumerable<SpecifiedEntities> SpecifiedEntities { get; }
    }
    
    /// <summary>
    /// A set of elections that can be shared across master agreement types - this should be built upon for specific contracts.
    /// </summary>
    public class MasterAgreementBase : AbstractRosettaModelObject<MasterAgreementBase>, IMasterAgreementBase
    {
        private static readonly IRosettaMetaData<MasterAgreementBase> metaData = new MasterAgreementBaseMeta();
        
        [JsonConstructor]
        public MasterAgreementBase()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterAgreementBase> MetaData => metaData;
        
    }
    
    /// <summary>
    /// Defines clauses that make up a Master Agreement.
    /// </summary>
    public class MasterAgreementClause : AbstractRosettaModelObject<MasterAgreementClause>
    {
        private static readonly IRosettaMetaData<MasterAgreementClause> metaData = new MasterAgreementClauseMeta();
        
        [JsonConstructor]
        public MasterAgreementClause(Enums.MasterAgreementClauseIdentifier identifer, string? name, IEnumerable<Enums.CounterpartyRole> counterparty, IEnumerable<Enums.PartyRole> otherParty, IEnumerable<MasterAgreementClauseVariant> variant)
        {
            Identifer = identifer;
            Name = name;
            Counterparty = counterparty;
            OtherParty = otherParty;
            Variant = variant;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterAgreementClause> MetaData => metaData;
        
        /// <summary>
        /// Unique identifier for the clause.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MasterAgreementClauseIdentifier Identifer { get; }
        
        /// <summary>
        /// Optional textual description of the clause.
        /// </summary>
        public string? Name { get; }
        
        /// <summary>
        /// Optional counterparty role. This can be used where a clause needs to be assigned to a specific party on the agreement based upon their role i.e. Party A or Party B.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> Counterparty { get; }
        
        /// <summary>
        /// Optional party. This can be required for umbrella agreements where a clause may need to be assigned to a specific party who may or may not be on the agreement.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.PartyRole> OtherParty { get; }
        
        /// <summary>
        /// Allows multiple variants to be defined for a clause. This needs to be an array as some clauses can specify different variants for different parties. At least one variant must be specified for a clause.
        /// </summary>
        public IEnumerable<MasterAgreementClauseVariant> Variant { get; }
    }
    
    /// <summary>
    /// Sets the details for a specific variant associated to a clause in a Master Agreement.
    /// </summary>
    public class MasterAgreementClauseVariant : AbstractRosettaModelObject<MasterAgreementClauseVariant>
    {
        private static readonly IRosettaMetaData<MasterAgreementClauseVariant> metaData = new MasterAgreementClauseVariantMeta();
        
        [JsonConstructor]
        public MasterAgreementClauseVariant(Enums.MasterAgreementVariantIdentifier identifier, string? name, IEnumerable<Enums.CounterpartyRole> counterparty, IEnumerable<Enums.PartyRole> otherParty, IEnumerable<MasterAgreementVariableSet> variableSet)
        {
            Identifier = identifier;
            Name = name;
            Counterparty = counterparty;
            OtherParty = otherParty;
            VariableSet = variableSet;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterAgreementClauseVariant> MetaData => metaData;
        
        /// <summary>
        /// Unique identifier for this variant.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.MasterAgreementVariantIdentifier Identifier { get; }
        
        /// <summary>
        /// Optional textual description of the variant.
        /// </summary>
        public string? Name { get; }
        
        /// <summary>
        /// Optional counterparty role. This can be used where a clause needs to assign a different variant to the different parties on the agreement based upon their role i.e. Party A or Party B.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.CounterpartyRole> Counterparty { get; }
        
        /// <summary>
        /// Optional party. This can be used where a clause needs to assign different variants to different parties who may or may not be on the agreement.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.PartyRole> OtherParty { get; }
        
        /// <summary>
        /// For some variants of some clauses additional details are required to work out what has been elected. This array can be used to define the name and value of these variables. Please refer to the agreement documentation for more details of the variables that are available for any clause.
        /// </summary>
        public IEnumerable<MasterAgreementVariableSet> VariableSet { get; }
    }
    
    /// <summary>
    /// A representation of a master agreement extended from a base agreement of shared elections.
    /// </summary>
    public class MasterAgreementElections : AbstractRosettaModelObject<MasterAgreementElections>
    {
        private static readonly IRosettaMetaData<MasterAgreementElections> metaData = new MasterAgreementElectionsMeta();
        
        [JsonConstructor]
        public MasterAgreementElections(GlobalMasterSecuritiesLendingAgreement? islaGmsla, GlobalMasterRepoAgreement? icmaGmra, MasterAgreement? isdaMaster)
        {
            IslaGmsla = islaGmsla;
            IcmaGmra = icmaGmra;
            IsdaMaster = isdaMaster;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterAgreementElections> MetaData => metaData;
        
        /// <summary>
        /// The set of elections that define a GMSLA.
        /// </summary>
        public GlobalMasterSecuritiesLendingAgreement? IslaGmsla { get; }
        
        /// <summary>
        /// The set of elections that define a GMRA.
        /// </summary>
        public GlobalMasterRepoAgreement? IcmaGmra { get; }
        
        /// <summary>
        /// The set of elections that define an ISDA Master Agreement.
        /// </summary>
        public MasterAgreement? IsdaMaster { get; }
    }
    
    /// <summary>
    /// The set of elections which specify a Master Agreement.
    /// </summary>
    public class MasterAgreementSchedule : AbstractRosettaModelObject<MasterAgreementSchedule>
    {
        private static readonly IRosettaMetaData<MasterAgreementSchedule> metaData = new MasterAgreementScheduleMeta();
        
        [JsonConstructor]
        public MasterAgreementSchedule(IEnumerable<MasterAgreementClause> clause)
        {
            Clause = clause;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterAgreementSchedule> MetaData => metaData;
        
        /// <summary>
        /// Clauses that have had elections made against them in this Master Agreement. There must be at least one clause defined in the agreement.
        /// </summary>
        public IEnumerable<MasterAgreementClause> Clause { get; }
    }
    
    /// <summary>
    /// Defines a type where additional variables associated to clauses and their variants can be described.
    /// </summary>
    public class MasterAgreementVariableSet : AbstractRosettaModelObject<MasterAgreementVariableSet>
    {
        private static readonly IRosettaMetaData<MasterAgreementVariableSet> metaData = new MasterAgreementVariableSetMeta();
        
        [JsonConstructor]
        public MasterAgreementVariableSet(IEnumerable<MasterAgreementVariableSet> variableSet, string? name, string? value)
        {
            VariableSet = variableSet;
            Name = name;
            Value = value;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterAgreementVariableSet> MetaData => metaData;
        
        /// <summary>
        /// For some variants a table of variables is required. To support this use case we need to be able to specify variables within variables. Including a variable set here gives us infinite nesting opportunities - realistically we are only ever expecting that a table would need to be defined for any particular clause, so we would expect two levels of nesting as a maximum i.e. variableSet-&gt;variableSet-&gt;name/value.
        /// </summary>
        public IEnumerable<MasterAgreementVariableSet> VariableSet { get; }
        
        /// <summary>
        /// The name of the variable.
        /// </summary>
        public string? Name { get; }
        
        /// <summary>
        /// The value for this variable.
        /// </summary>
        public string? Value { get; }
    }
    
    /// <summary>
    /// Legal agreement specification for General Terms and Elections that are applicable across multiple confirmations and are referenced by these confirmations.
    /// </summary>
    public class MasterConfirmationBase : AbstractRosettaModelObject<MasterConfirmationBase>, IMasterConfirmationBase
    {
        private static readonly IRosettaMetaData<MasterConfirmationBase> metaData = new MasterConfirmationBaseMeta();
        
        [JsonConstructor]
        public MasterConfirmationBase()
        {
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MasterConfirmationBase> MetaData => metaData;
        
    }
    
    public class MaterialChangeInCircumstance : AbstractRosettaModelObject<MaterialChangeInCircumstance>
    {
        private static readonly IRosettaMetaData<MaterialChangeInCircumstance> metaData = new MaterialChangeInCircumstanceMeta();
        
        [JsonConstructor]
        public MaterialChangeInCircumstance(bool materialChangeInCircumstanceIsApplicable, EscrowArrangement? escrowArrangement, ValuationPostponement? maximumDaysOfDisruption)
        {
            MaterialChangeInCircumstanceIsApplicable = materialChangeInCircumstanceIsApplicable;
            EscrowArrangement = escrowArrangement;
            MaximumDaysOfDisruption = maximumDaysOfDisruption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MaterialChangeInCircumstance> MetaData => metaData;
        
        public bool MaterialChangeInCircumstanceIsApplicable { get; }
        
        public EscrowArrangement? EscrowArrangement { get; }
        
        public ValuationPostponement? MaximumDaysOfDisruption { get; }
    }
    
    /// <summary>
    /// Defines a concrete measure as a number associated to a unit. It extends MeasureBase by requiring the value attribute to be present. A measure may be unit-less so the unit attribute is still optional.
    /// </summary>
    public class Measure : AbstractRosettaModelObject<Measure>, IMeasureBase
    {
        private static readonly IRosettaMetaData<Measure> metaData = new MeasureMeta();
        
        [JsonConstructor]
        public Measure(decimal? value, UnitType? unit)
        {
            Value = value;
            Unit = unit;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Measure> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal? Value { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
    }
    
    /// <summary>
    /// Provides an abstract type to define a measure as a number associated to a unit. This type is abstract because all its attributes are optional. The types that extend it can specify further existence constraints.
    /// </summary>
    public class MeasureBase : AbstractRosettaModelObject<MeasureBase>, IMeasureBase
    {
        private static readonly IRosettaMetaData<MeasureBase> metaData = new MeasureBaseMeta();
        
        [JsonConstructor]
        public MeasureBase(decimal? value, UnitType? unit)
        {
            Value = value;
            Unit = unit;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MeasureBase> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal? Value { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
    }
    
    /// <summary>
    /// A set of measures, all in the same unit, where the values are defined through a schedule of steps. The initial value may be defined either as part of the steps, or using the single amount attribute.
    /// </summary>
    public class MeasureSchedule : AbstractRosettaModelObject<MeasureSchedule>, IMeasureSchedule, IMeasureBase
    {
        private static readonly IRosettaMetaData<MeasureSchedule> metaData = new MeasureScheduleMeta();
        
        [JsonConstructor]
        public MeasureSchedule(decimal? value, UnitType? unit, IEnumerable<DatedValue> datedValue)
        {
            Value = value;
            Unit = unit;
            DatedValue = datedValue;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MeasureSchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal? Value { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
    }
    
    /// <summary>
    /// Defines the underlier for both the Purchaser Company and the Acquired Compagny involved in Merger corporate action, as well as th respective price observation for each.
    /// </summary>
    public class Merger : AbstractRosettaModelObject<Merger>
    {
        private static readonly IRosettaMetaData<Merger> metaData = new MergerMeta();
        
        [JsonConstructor]
        public Merger(Security purchaserSecurity, Price purchaserSecurityPrice, Security acquiredSecurity, Price acquiredSecurityPrice)
        {
            PurchaserSecurity = purchaserSecurity;
            PurchaserSecurityPrice = purchaserSecurityPrice;
            AcquiredSecurity = acquiredSecurity;
            AcquiredSecurityPrice = acquiredSecurityPrice;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Merger> MetaData => metaData;
        
        /// <summary>
        /// Defines the underlier for the Purchaser Company involved in Merger corporate action.
        /// </summary>
        public Security PurchaserSecurity { get; }
        
        /// <summary>
        /// The price observation that relates to underlier for the Purchaser Company.
        /// </summary>
        public Price PurchaserSecurityPrice { get; }
        
        /// <summary>
        /// Defines the underlier for the Acquired Company involved in Merger corporate action.
        /// </summary>
        public Security AcquiredSecurity { get; }
        
        /// <summary>
        /// The price observation that relates to underlier for the Acquired Company.
        /// </summary>
        public Price AcquiredSecurityPrice { get; }
    }
    
    /// <summary>
    /// This class corresponds to the components of the FpML MessageHeader.model.
    /// </summary>
    public class MessageInformation : AbstractRosettaModelObject<MessageInformation>
    {
        private static readonly IRosettaMetaData<MessageInformation> metaData = new MessageInformationMeta();
        
        [JsonConstructor]
        public MessageInformation(FieldWithMetaString messageId, FieldWithMetaString? sentBy, IEnumerable<FieldWithMetaString> sentTo, IEnumerable<FieldWithMetaString> copyTo)
        {
            MessageId = messageId;
            SentBy = sentBy;
            SentTo = sentTo;
            CopyTo = copyTo;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MessageInformation> MetaData => metaData;
        
        /// <summary>
        /// A unique identifier assigned to the message.
        /// </summary>
        public FieldWithMetaString MessageId { get; }
        
        /// <summary>
        /// The identifier for the originator of a message instance.
        /// </summary>
        public FieldWithMetaString? SentBy { get; }
        
        /// <summary>
        /// The identifier(s) for the recipient(s) of a message instance.
        /// </summary>
        public IEnumerable<FieldWithMetaString> SentTo { get; }
        
        /// <summary>
        /// A unique identifier (within the specified coding scheme) giving the details of some party to whom a copy of this message will be sent for reference.
        /// </summary>
        public IEnumerable<FieldWithMetaString> CopyTo { get; }
    }
    
    /// <summary>
    /// Represents the threshold specified in the agreement below which collateral need not be delivered, and represents the smallest incremental value of exposure that must be reached before the parties are obliged to transfer collateral.
    /// </summary>
    public class MinimumTransferAmount : AbstractRosettaModelObject<MinimumTransferAmount>
    {
        private static readonly IRosettaMetaData<MinimumTransferAmount> metaData = new MinimumTransferAmountMeta();
        
        [JsonConstructor]
        public MinimumTransferAmount(IEnumerable<MinimumTransferAmountElection> partyElection)
        {
            PartyElection = partyElection;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MinimumTransferAmount> MetaData => metaData;
        
        /// <summary>
        /// The party specific elections for the Minimum Transfer Amount clause.
        /// </summary>
        public IEnumerable<MinimumTransferAmountElection> PartyElection { get; }
    }
    
    /// <summary>
    ///  A class to specify whether Amendment to Minimum Transfer Amount language is applicable or not.
    /// </summary>
    public class MinimumTransferAmountAmendment : AbstractRosettaModelObject<MinimumTransferAmountAmendment>
    {
        private static readonly IRosettaMetaData<MinimumTransferAmountAmendment> metaData = new MinimumTransferAmountAmendmentMeta();
        
        [JsonConstructor]
        public MinimumTransferAmountAmendment(bool isApplicable, AmendmentEffectiveDate? effectiveDate, IEnumerable<ElectiveAmountElection> partyElections)
        {
            IsApplicable = isApplicable;
            EffectiveDate = effectiveDate;
            PartyElections = partyElections;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MinimumTransferAmountAmendment> MetaData => metaData;
        
        /// <summary>
        /// The definition of Minimum Transfer Amount in any Other Regulatory CSA will be amended when applicable.
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The effective date of the Amendment to Termination Currency.
        /// </summary>
        public AmendmentEffectiveDate? EffectiveDate { get; }
        
        /// <summary>
        /// The party elective amounts.
        /// </summary>
        public IEnumerable<ElectiveAmountElection> PartyElections { get; }
    }
    
    /// <summary>
    /// Specifies the method by which the minimum transfer amount is defined, such as a fixed amount, ratings based, or an alternative basis set out in the agreement.
    /// </summary>
    public class MinimumTransferAmountElection : AbstractRosettaModelObject<MinimumTransferAmountElection>
    {
        private static readonly IRosettaMetaData<MinimumTransferAmountElection> metaData = new MinimumTransferAmountElectionMeta();
        
        [JsonConstructor]
        public MinimumTransferAmountElection(Enums.CounterpartyRole party, ThresholdMinimumTransferAmountFixedAmount? fixedAmount, MinimumTransferAmountRatingsBased? ratingsBased, string? other)
        {
            Party = party;
            FixedAmount = fixedAmount;
            RatingsBased = ratingsBased;
            Other = other;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MinimumTransferAmountElection> MetaData => metaData;
        
        /// <summary>
        /// The party to which the minimum transfer amount applies.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// Defines that the Minimum Transfer Amount (MTA) is a Fixed Amount.
        /// </summary>
        public ThresholdMinimumTransferAmountFixedAmount? FixedAmount { get; }
        
        /// <summary>
        /// Defines that the Minimum Transfer Amount (MTA) is based on a Ratings condition(s).
        /// </summary>
        public MinimumTransferAmountRatingsBased? RatingsBased { get; }
        
        /// <summary>
        /// Utilised where the clause data structure is not able to capture a material aspect of the clause.
        /// </summary>
        public string? Other { get; }
    }
    
    /// <summary>
    /// Defines that the Minimum Transfer Amount (MTA) is based on a Ratings condition(s).
    /// </summary>
    public class MinimumTransferAmountRatingsBased : AbstractRosettaModelObject<MinimumTransferAmountRatingsBased>, IThresholdMinmumTransferAmountBase
    {
        private static readonly IRosettaMetaData<MinimumTransferAmountRatingsBased> metaData = new MinimumTransferAmountRatingsBasedMeta();
        
        [JsonConstructor]
        public MinimumTransferAmountRatingsBased(bool zeroEvent, IEnumerable<Enums.ZeroEvent> eventValue, Enums.ISOCurrencyCode currency, Enums.RatingType ratingType, IEnumerable<CSAMinimumTransferAmountVariableSet> variableSet, Enums.RatedParty? ratedParty, string? namedEntity, string? namedAffiliate, Enums.CreditNotationMismatchResolution? compare, bool noRating, Enums.NotRatedBy? notRatedBy, Enums.NumberOfRatingAgencies? numberOfRatingAgencies)
        {
            ZeroEvent = zeroEvent;
            Event = eventValue;
            Currency = currency;
            RatingType = ratingType;
            VariableSet = variableSet;
            RatedParty = ratedParty;
            NamedEntity = namedEntity;
            NamedAffiliate = namedAffiliate;
            Compare = compare;
            NoRating = noRating;
            NotRatedBy = notRatedBy;
            NumberOfRatingAgencies = numberOfRatingAgencies;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MinimumTransferAmountRatingsBased> MetaData => metaData;
        
        /// <inheritdoc/>
        public bool ZeroEvent { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.ZeroEvent> Event { get; }
        
        /// <summary>
        /// The minimum transfer amount currency code.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ISOCurrencyCode Currency { get; }
        
        /// <summary>
        /// The relevant rating type.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatingType RatingType { get; }
        
        /// <summary>
        /// Defines a combination of Rating Agency, Rating Value, amount and Currency code.
        /// </summary>
        public IEnumerable<CSAMinimumTransferAmountVariableSet> VariableSet { get; }
        
        /// <summary>
        /// The party to which a rating applies.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.RatedParty? RatedParty { get; }
        
        /// <summary>
        /// Details the Named Entity where the Rated Party is Named Entity.
        /// </summary>
        public string? NamedEntity { get; }
        
        /// <summary>
        /// Details the Named Affiliate where the Rated Party is Named Affiliate.
        /// </summary>
        public string? NamedAffiliate { get; }
        
        /// <summary>
        /// Where two ratings are specified whether the higher or lower rating prevails.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditNotationMismatchResolution? Compare { get; }
        
        /// <summary>
        /// What conditions apply where a party has no rating.
        /// </summary>
        public bool NoRating { get; }
        
        /// <summary>
        /// Defines where conditions apply if no Rating where ratings may not exist.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NotRatedBy? NotRatedBy { get; }
        
        /// <summary>
        /// Defines the number of Rating Agencies that the Party must be rated by.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.NumberOfRatingAgencies? NumberOfRatingAgencies { get; }
    }
    
    /// <summary>
    /// Defines a monetary amount in a specified currency.
    /// </summary>
    public class Money : AbstractRosettaModelObject<Money>, IQuantity
    {
        private static readonly IRosettaMetaData<Money> metaData = new MoneyMeta();
        
        [JsonConstructor]
        public Money(decimal? value, UnitType? unit, IEnumerable<DatedValue> datedValue, Measure? multiplier, Frequency? frequency, _MetaFields? meta)
        {
            Value = value;
            Unit = unit;
            DatedValue = datedValue;
            Multiplier = multiplier;
            Frequency = frequency;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Money> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal? Value { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public Measure? Multiplier { get; }
        
        /// <inheritdoc/>
        public Frequency? Frequency { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// The money bound is defined as a money amount and whether the bound is inclusive.
    /// </summary>
    public class MoneyBound : AbstractRosettaModelObject<MoneyBound>
    {
        private static readonly IRosettaMetaData<MoneyBound> metaData = new MoneyBoundMeta();
        
        [JsonConstructor]
        public MoneyBound(Money money, bool inclusive)
        {
            Money = money;
            Inclusive = inclusive;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MoneyBound> MetaData => metaData;
        
        /// <summary>
        /// The money amount to be used as the bound, e.g. 1,000 USD.
        /// </summary>
        public Money Money { get; }
        
        /// <summary>
        /// Whether the money amount bound is inclusive, e.g. for a lower bound, false would indicate greater than, whereas true would indicate greater than or equal to.
        /// </summary>
        public bool Inclusive { get; }
    }
    
    /// <summary>
    /// The money range defined as either a lower and upper money bound, or both.
    /// </summary>
    public class MoneyRange : AbstractRosettaModelObject<MoneyRange>
    {
        private static readonly IRosettaMetaData<MoneyRange> metaData = new MoneyRangeMeta();
        
        [JsonConstructor]
        public MoneyRange(MoneyBound? lowerBound, MoneyBound? upperBound)
        {
            LowerBound = lowerBound;
            UpperBound = upperBound;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MoneyRange> MetaData => metaData;
        
        /// <summary>
        /// The lower bound of a money range, e.g. greater than or equal to 1,000 USD.
        /// </summary>
        public MoneyBound? LowerBound { get; }
        
        /// <summary>
        /// The upper bound of a money range, e.g. less than 10,000 USD.
        /// </summary>
        public MoneyBound? UpperBound { get; }
    }
    
    /// <summary>
    /// Represetns a class to specify multiple credit notations alongside a conditional &apos;any&apos; or &apos;all&apos; qualifier.
    /// </summary>
    public class MultipleCreditNotations : AbstractRosettaModelObject<MultipleCreditNotations>
    {
        private static readonly IRosettaMetaData<MultipleCreditNotations> metaData = new MultipleCreditNotationsMeta();
        
        [JsonConstructor]
        public MultipleCreditNotations(Enums.Quantifier condition, IEnumerable<FieldWithMetaCreditNotation> creditNotation, Enums.CreditNotationMismatchResolution? mismatchResolution, Enums.CreditRatingAgency? referenceAgency)
        {
            Condition = condition;
            CreditNotation = creditNotation;
            MismatchResolution = mismatchResolution;
            ReferenceAgency = referenceAgency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MultipleCreditNotations> MetaData => metaData;
        
        /// <summary>
        /// An enumerated element, to qualify whether All or Any credit notation applies.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.Quantifier Condition { get; }
        
        /// <summary>
        /// At least two credit notations much be specified.
        /// </summary>
        public IEnumerable<FieldWithMetaCreditNotation> CreditNotation { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditNotationMismatchResolution? MismatchResolution { get; }
        
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CreditRatingAgency? ReferenceAgency { get; }
    }
    
    /// <summary>
    /// Represents a class to specify multiple credit debt types alongside a conditional &apos;any&apos; or &apos;all&apos; qualifier.
    /// </summary>
    public class MultipleDebtTypes : AbstractRosettaModelObject<MultipleDebtTypes>
    {
        private static readonly IRosettaMetaData<MultipleDebtTypes> metaData = new MultipleDebtTypesMeta();
        
        [JsonConstructor]
        public MultipleDebtTypes(Enums.Quantifier condition, IEnumerable<FieldWithMetaString> debtType)
        {
            Condition = condition;
            DebtType = debtType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MultipleDebtTypes> MetaData => metaData;
        
        /// <summary>
        /// An enumerated attribute, to qualify whether All or Any debt type applies.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.Quantifier Condition { get; }
        
        /// <summary>
        /// The type of debt, e.g. long term debt, deposit, ... FpML doesn&apos;t specific a scheme value, hence no enumeration is specified as part of the CDM. At least two debt types much be specified.
        /// </summary>
        public IEnumerable<FieldWithMetaString> DebtType { get; }
    }
    
    /// <summary>
    /// A class defining multiple exercises. As defined in the 2000 ISDA Definitions, Section 12.4. Multiple Exercise, the buyer of the option has the right to exercise all or less than all the unexercised notional amount of the underlying swap on one or more days in the exercise period, but on any such day may not exercise less than the minimum notional amount or more than the maximum notional amount, and if an integral multiple amount is specified, the notional exercised must be equal to or, be an integral multiple of, the integral multiple amount. In FpML, MultipleExercise is built upon the PartialExercise.model.
    /// </summary>
    public class MultipleExercise : AbstractRosettaModelObject<MultipleExercise>, IPartialExercise
    {
        private static readonly IRosettaMetaData<MultipleExercise> metaData = new MultipleExerciseMeta();
        
        [JsonConstructor]
        public MultipleExercise(ReferenceWithMetaMoney notionalReference, decimal? integralMultipleAmount, decimal? minimumNotionalAmount, int? minimumNumberOfOptions, decimal? maximumNotionalAmount, int? maximumNumberOfOptions)
        {
            NotionalReference = notionalReference;
            IntegralMultipleAmount = integralMultipleAmount;
            MinimumNotionalAmount = minimumNotionalAmount;
            MinimumNumberOfOptions = minimumNumberOfOptions;
            MaximumNotionalAmount = maximumNotionalAmount;
            MaximumNumberOfOptions = maximumNumberOfOptions;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MultipleExercise> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaMoney NotionalReference { get; }
        
        /// <inheritdoc/>
        public decimal? IntegralMultipleAmount { get; }
        
        /// <inheritdoc/>
        public decimal? MinimumNotionalAmount { get; }
        
        /// <inheritdoc/>
        public int? MinimumNumberOfOptions { get; }
        
        /// <summary>
        /// The maximum notional amount that can be exercised on a given exercise date.
        /// </summary>
        public decimal? MaximumNotionalAmount { get; }
        
        /// <summary>
        /// The maximum number of options that can be exercised on a given exercise date. If the number is not specified, it means that the maximum number of options corresponds to the remaining unexercised options.
        /// </summary>
        public int? MaximumNumberOfOptions { get; }
    }
    
    public class MultipleValuationDates : AbstractRosettaModelObject<MultipleValuationDates>, ISingleValuationDate
    {
        private static readonly IRosettaMetaData<MultipleValuationDates> metaData = new MultipleValuationDatesMeta();
        
        [JsonConstructor]
        public MultipleValuationDates(int? businessDays, int? businessDaysThereafter, int? numberValuationDates)
        {
            BusinessDays = businessDays;
            BusinessDaysThereafter = businessDaysThereafter;
            NumberValuationDates = numberValuationDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<MultipleValuationDates> MetaData => metaData;
        
        /// <inheritdoc/>
        public int? BusinessDays { get; }
        
        /// <summary>
        /// The number of business days between successive valuation dates when multiple valuation dates are applicable for cash settlement. ISDA 2003 Term: Business Days thereafter.
        /// </summary>
        public int? BusinessDaysThereafter { get; }
        
        /// <summary>
        /// Where multiple valuation dates are specified as being applicable for cash settlement, this element specifies (a) the number of applicable valuation dates, and (b) the number of business days after satisfaction of all conditions to settlement when the first such valuation date occurs, and (c) the number of business days thereafter of each successive valuation date. ISDA 2003 Term: Multiple Valuation Dates.
        /// </summary>
        public int? NumberValuationDates { get; }
    }
    
    public class Nationalization : AbstractRosettaModelObject<Nationalization>
    {
        private static readonly IRosettaMetaData<Nationalization> metaData = new NationalizationMeta();
        
        [JsonConstructor]
        public Nationalization(bool nationalizationIsApplicable, IEnumerable<AncillaryEntity> relevantAffiliate, EscrowArrangement? escrowArrangement, bool? assignmentOfClaim, ValuationPostponement? maximumDaysOfDisruption)
        {
            NationalizationIsApplicable = nationalizationIsApplicable;
            RelevantAffiliate = relevantAffiliate;
            EscrowArrangement = escrowArrangement;
            AssignmentOfClaim = assignmentOfClaim;
            MaximumDaysOfDisruption = maximumDaysOfDisruption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Nationalization> MetaData => metaData;
        
        public bool NationalizationIsApplicable { get; }
        
        public IEnumerable<AncillaryEntity> RelevantAffiliate { get; }
        
        public EscrowArrangement? EscrowArrangement { get; }
        
        public bool? AssignmentOfClaim { get; }
        
        public ValuationPostponement? MaximumDaysOfDisruption { get; }
    }
    
    /// <summary>
    /// A class to represent the attributes that are specific to a natural person.
    /// </summary>
    public class NaturalPerson : AbstractRosettaModelObject<NaturalPerson>
    {
        private static readonly IRosettaMetaData<NaturalPerson> metaData = new NaturalPersonMeta();
        
        [JsonConstructor]
        public NaturalPerson(IEnumerable<FieldWithMetaPersonIdentifier> personId, string? honorific, string? firstName, IEnumerable<string> middleName, IEnumerable<string> initial, string? surname, string? suffix, LocalDate? dateOfBirth, ContactInformation? contactInformation, _MetaFields? meta)
        {
            PersonId = personId;
            Honorific = honorific;
            FirstName = firstName;
            MiddleName = middleName;
            Initial = initial;
            Surname = surname;
            Suffix = suffix;
            DateOfBirth = dateOfBirth;
            ContactInformation = contactInformation;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NaturalPerson> MetaData => metaData;
        
        /// <summary>
        /// The identifier associated with a person, e.g. the internal identification code.
        /// </summary>
        public IEnumerable<FieldWithMetaPersonIdentifier> PersonId { get; }
        
        /// <summary>
        /// An honorific title, such as Mr., Ms., Dr. etc.
        /// </summary>
        public string? Honorific { get; }
        
        /// <summary>
        /// The natural person&apos;s first name. It is optional in FpML.
        /// </summary>
        public string? FirstName { get; }
        
        /// <summary>
        /// The natural person&apos;s middle name(s). If a middle name is provided then an initial should be absent.
        /// </summary>
        public IEnumerable<string> MiddleName { get; }
        
        /// <summary>
        /// The natural person&apos;s middle initial(s). If a middle initial is provided then a name should be absent.
        /// </summary>
        public IEnumerable<string> Initial { get; }
        
        /// <summary>
        /// The natural person&apos;s surname.
        /// </summary>
        public string? Surname { get; }
        
        /// <summary>
        /// Name suffix, such as Jr., III, etc.
        /// </summary>
        public string? Suffix { get; }
        
        /// <summary>
        /// The natural person&apos;s date of birth.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? DateOfBirth { get; }
        
        /// <summary>
        /// The contact information for such person, when different from the contact information associated with the party.
        /// </summary>
        public ContactInformation? ContactInformation { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class to specify the role(s) that natural person(s) may have in relation to the contract.
    /// </summary>
    public class NaturalPersonRole : AbstractRosettaModelObject<NaturalPersonRole>
    {
        private static readonly IRosettaMetaData<NaturalPersonRole> metaData = new NaturalPersonRoleMeta();
        
        [JsonConstructor]
        public NaturalPersonRole(ReferenceWithMetaNaturalPerson personReference, IEnumerable<FieldWithMetaNaturalPersonRoleEnum> role)
        {
            PersonReference = personReference;
            Role = role;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NaturalPersonRole> MetaData => metaData;
        
        /// <summary>
        /// A reference to the natural person to whom the role refers to.
        /// </summary>
        public ReferenceWithMetaNaturalPerson PersonReference { get; }
        
        /// <summary>
        /// FpML specifies a person role that is distinct from the party role.
        /// </summary>
        public IEnumerable<FieldWithMetaNaturalPersonRoleEnum> Role { get; }
    }
    
    /// <summary>
    /// Used to apply a NOT logic condition to a single Collateral Criteria.
    /// </summary>
    public class NegativeCriteria : AbstractRosettaModelObject<NegativeCriteria>
    {
        private static readonly IRosettaMetaData<NegativeCriteria> metaData = new NegativeCriteriaMeta();
        
        [JsonConstructor]
        public NegativeCriteria(CollateralCriteria negativeCriteria)
        {
            NegativeCriteriaValue = negativeCriteria;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NegativeCriteria> MetaData => metaData;
        
        [JsonProperty(PropertyName = "negativeCriteria")]
        public CollateralCriteria NegativeCriteriaValue { get; }
    }
    
    public class New : AbstractRosettaModelObject<New>
    {
        private static readonly IRosettaMetaData<New> metaData = new NewMeta();
        
        [JsonConstructor]
        public New(string txId, string exctgPty, string invstmtPtyInd, string submitgPty, Buyr buyr, Sellr sellr, OrdrTrnsmssn ordrTrnsmssn, Tx tx, FinInstrm finInstrm, InvstmtDcsnPrsn invstmtDcsnPrsn, ExctgPrsn exctgPrsn, AddtlAttrbts addtlAttrbts)
        {
            TxId = txId;
            ExctgPty = exctgPty;
            InvstmtPtyInd = invstmtPtyInd;
            SubmitgPty = submitgPty;
            Buyr = buyr;
            Sellr = sellr;
            OrdrTrnsmssn = ordrTrnsmssn;
            Tx = tx;
            FinInstrm = finInstrm;
            InvstmtDcsnPrsn = invstmtDcsnPrsn;
            ExctgPrsn = exctgPrsn;
            AddtlAttrbts = addtlAttrbts;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<New> MetaData => metaData;
        
        public string TxId { get; }
        
        public string ExctgPty { get; }
        
        public string InvstmtPtyInd { get; }
        
        public string SubmitgPty { get; }
        
        public Buyr Buyr { get; }
        
        public Sellr Sellr { get; }
        
        public OrdrTrnsmssn OrdrTrnsmssn { get; }
        
        public Tx Tx { get; }
        
        public FinInstrm FinInstrm { get; }
        
        public InvstmtDcsnPrsn InvstmtDcsnPrsn { get; }
        
        public ExctgPrsn ExctgPrsn { get; }
        
        public AddtlAttrbts AddtlAttrbts { get; }
    }
    
    public class Nm : AbstractRosettaModelObject<Nm>
    {
        private static readonly IRosettaMetaData<Nm> metaData = new NmMeta();
        
        [JsonConstructor]
        public Nm(RefRate refRate, Term term)
        {
            RefRate = refRate;
            Term = term;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Nm> MetaData => metaData;
        
        public RefRate RefRate { get; }
        
        public Term Term { get; }
    }
    
    public class NonDeliverableSubstitute : AbstractRosettaModelObject<NonDeliverableSubstitute>
    {
        private static readonly IRosettaMetaData<NonDeliverableSubstitute> metaData = new NonDeliverableSubstituteMeta();
        
        [JsonConstructor]
        public NonDeliverableSubstitute(bool nonDeliverableSubstituteIsApplicable, AdjustedRelativeDateOffset? valuationDate, AdjustedRelativeDateOffset? settlementDate, SettlementRateOption? settlementRateOption)
        {
            NonDeliverableSubstituteIsApplicable = nonDeliverableSubstituteIsApplicable;
            ValuationDate = valuationDate;
            SettlementDate = settlementDate;
            SettlementRateOption = settlementRateOption;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NonDeliverableSubstitute> MetaData => metaData;
        
        public bool NonDeliverableSubstituteIsApplicable { get; }
        
        public AdjustedRelativeDateOffset? ValuationDate { get; }
        
        public AdjustedRelativeDateOffset? SettlementDate { get; }
        
        public SettlementRateOption? SettlementRateOption { get; }
    }
    
    /// <summary>
    /// Specifies a quantity as a non-negative number, which condition is enforced through a data rule that only applies to the extending class.
    /// </summary>
    public class NonNegativeQuantity : AbstractRosettaModelObject<NonNegativeQuantity>, IQuantity
    {
        private static readonly IRosettaMetaData<NonNegativeQuantity> metaData = new NonNegativeQuantityMeta();
        
        [JsonConstructor]
        public NonNegativeQuantity(decimal? value, UnitType? unit, IEnumerable<DatedValue> datedValue, Measure? multiplier, Frequency? frequency)
        {
            Value = value;
            Unit = unit;
            DatedValue = datedValue;
            Multiplier = multiplier;
            Frequency = frequency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NonNegativeQuantity> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal? Value { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public Measure? Multiplier { get; }
        
        /// <inheritdoc/>
        public Frequency? Frequency { get; }
    }
    
    public class NonNegativeQuantitySchedule : AbstractRosettaModelObject<NonNegativeQuantitySchedule>, IQuantitySchedule
    {
        private static readonly IRosettaMetaData<NonNegativeQuantitySchedule> metaData = new NonNegativeQuantityScheduleMeta();
        
        [JsonConstructor]
        public NonNegativeQuantitySchedule(decimal? value, UnitType? unit, IEnumerable<DatedValue> datedValue, Measure? multiplier, Frequency? frequency)
        {
            Value = value;
            Unit = unit;
            DatedValue = datedValue;
            Multiplier = multiplier;
            Frequency = frequency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NonNegativeQuantitySchedule> MetaData => metaData;
        
        /// <inheritdoc/>
        public decimal? Value { get; }
        
        /// <inheritdoc/>
        public UnitType? Unit { get; }
        
        /// <inheritdoc/>
        public IEnumerable<DatedValue> DatedValue { get; }
        
        /// <inheritdoc/>
        public Measure? Multiplier { get; }
        
        /// <inheritdoc/>
        public Frequency? Frequency { get; }
    }
    
    /// <summary>
    /// A class defining a step date and non-negative step value pair. This step definitions are used to define varying rate or amount schedules, e.g. a notional amortisation or a step-up coupon schedule.
    /// </summary>
    public class NonNegativeStep : AbstractRosettaModelObject<NonNegativeStep>
    {
        private static readonly IRosettaMetaData<NonNegativeStep> metaData = new NonNegativeStepMeta();
        
        [JsonConstructor]
        public NonNegativeStep(LocalDate stepDate, decimal stepValue, _MetaFields? meta)
        {
            StepDate = stepDate;
            StepValue = stepValue;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NonNegativeStep> MetaData => metaData;
        
        /// <summary>
        /// The date on which the associated stepValue becomes effective. This day may be subject to adjustment in accordance with a business day convention.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate StepDate { get; }
        
        /// <summary>
        /// The non-negative rate or amount which becomes effective on the associated stepDate. A rate of 5% would be represented as 0.05.
        /// </summary>
        public decimal StepValue { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A data type to specify the financial product&apos;s economic terms, alongside the product identification and product taxonomy. The non-transferable product data type represents a product that can be traded (as part of a TradableProduct) but cannot be transferred to others.  It is meant to be used across the pre-execution, execution and (as part of the Contract) post-execution lifecycle contexts.
    /// </summary>
    public class NonTransferableProduct : AbstractRosettaModelObject<NonTransferableProduct>
    {
        private static readonly IRosettaMetaData<NonTransferableProduct> metaData = new NonTransferableProductMeta();
        
        [JsonConstructor]
        public NonTransferableProduct(IEnumerable<ProductIdentifier> identifier, IEnumerable<ProductTaxonomy> taxonomy, EconomicTerms economicTerms, _MetaFields? meta)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            EconomicTerms = economicTerms;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NonTransferableProduct> MetaData => metaData;
        
        /// <summary>
        /// Comprises a identifier and a source to uniquely identify the nonTransferableProduct. 
        /// </summary>
        public IEnumerable<ProductIdentifier> Identifier { get; }
        
        /// <summary>
        /// Specifies the product taxonomy, which is composed of a taxonomy value and a taxonomy source.
        /// </summary>
        public IEnumerable<ProductTaxonomy> Taxonomy { get; }
        
        /// <summary>
        /// The price forming features, including payouts and provisions.
        /// </summary>
        public EconomicTerms EconomicTerms { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class to specify the ISDA 2003 Term: Not Domestic Currency.
    /// </summary>
    public class NotDomesticCurrency : AbstractRosettaModelObject<NotDomesticCurrency>
    {
        private static readonly IRosettaMetaData<NotDomesticCurrency> metaData = new NotDomesticCurrencyMeta();
        
        [JsonConstructor]
        public NotDomesticCurrency(bool applicable, FieldWithMetaString? currency)
        {
            Applicable = applicable;
            Currency = currency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NotDomesticCurrency> MetaData => metaData;
        
        /// <summary>
        /// Indicates whether the Not Domestic Currency provision is applicable.
        /// </summary>
        public bool Applicable { get; }
        
        /// <summary>
        /// An explicit specification of the domestic currency. The list of valid currencies is not presently positioned as an enumeration as part of the CDM because that scope is limited to the values specified by ISDA and FpML. As a result, implementers have to make reference to the relevant standard, such as the ISO 4217 standard for currency codes.
        /// </summary>
        public FieldWithMetaString? Currency { get; }
    }
    
    /// <summary>
    /// A class to specify the time by which a demand for the Transfer of Eligible Credit Support (IM) or Posted Credit Support (IM) needs to be made in order for the transfer to take place in accordance with the Transfer Timing provisions.
    /// </summary>
    public class NotificationTime : AbstractRosettaModelObject<NotificationTime>
    {
        private static readonly IRosettaMetaData<NotificationTime> metaData = new NotificationTimeMeta();
        
        [JsonConstructor]
        public NotificationTime(IEnumerable<NotificationTimeElection> partyElections, bool? disputeNotificationReference, bool? transferTimingProviso)
        {
            PartyElections = partyElections;
            DisputeNotificationReference = disputeNotificationReference;
            TransferTimingProviso = transferTimingProviso;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NotificationTime> MetaData => metaData;
        
        /// <summary>
        /// The parties&apos; Notification Time election.
        /// </summary>
        public IEnumerable<NotificationTimeElection> PartyElections { get; }
        
        /// <summary>
        /// The determination of whether reference is made to dispute resolution notification timing in the agreement.
        /// </summary>
        public bool? DisputeNotificationReference { get; }
        
        /// <summary>
        /// The determination of whether transfer timing language is applicable or not.
        /// </summary>
        public bool? TransferTimingProviso { get; }
    }
    
    /// <summary>
    /// A class to specify the notification time election by the respective parties to the agreement.
    /// </summary>
    public class NotificationTimeElection : AbstractRosettaModelObject<NotificationTimeElection>
    {
        private static readonly IRosettaMetaData<NotificationTimeElection> metaData = new NotificationTimeElectionMeta();
        
        [JsonConstructor]
        public NotificationTimeElection(Enums.CounterpartyRole party, BusinessCenterTime? notificationTime, string? customNotification, bool? localBusinessDay)
        {
            Party = party;
            NotificationTime = notificationTime;
            CustomNotification = customNotification;
            LocalBusinessDay = localBusinessDay;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NotificationTimeElection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Party { get; }
        
        /// <summary>
        /// The Notification Time as a time that is qualified as a standard business center.
        /// </summary>
        public BusinessCenterTime? NotificationTime { get; }
        
        /// <summary>
        /// The Notification Time as a bespoke election.
        /// </summary>
        public string? CustomNotification { get; }
        
        /// <summary>
        /// Whether the Notification Time is precluded on the day being a local business day.
        /// </summary>
        public bool? LocalBusinessDay { get; }
    }
    
    /// <summary>
    /// The number bound is defined as a number and whether the bound is inclusive.
    /// </summary>
    public class NumberBound : AbstractRosettaModelObject<NumberBound>
    {
        private static readonly IRosettaMetaData<NumberBound> metaData = new NumberBoundMeta();
        
        [JsonConstructor]
        public NumberBound(decimal number, bool inclusive)
        {
            Number = number;
            Inclusive = inclusive;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NumberBound> MetaData => metaData;
        
        /// <summary>
        /// The number to be used as the bound, e.g. 5.
        /// </summary>
        public decimal Number { get; }
        
        /// <summary>
        /// Whether the number bound is inclusive, e.g. for a lower bound, false would indicate greater than, whereas true would indicate greater than or equal to.
        /// </summary>
        public bool Inclusive { get; }
    }
    
    /// <summary>
    /// The number range defined as either a lower and upper number bound, or both.
    /// </summary>
    public class NumberRange : AbstractRosettaModelObject<NumberRange>
    {
        private static readonly IRosettaMetaData<NumberRange> metaData = new NumberRangeMeta();
        
        [JsonConstructor]
        public NumberRange(NumberBound? lowerBound, NumberBound? upperBound)
        {
            LowerBound = lowerBound;
            UpperBound = upperBound;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<NumberRange> MetaData => metaData;
        
        /// <summary>
        /// The lower bound of a number range, e.g. greater than or equal to 5.
        /// </summary>
        public NumberBound? LowerBound { get; }
        
        /// <summary>
        /// The upper bound of a number range, e.g. less than 10.
        /// </summary>
        public NumberBound? UpperBound { get; }
    }
    
    /// <summary>
    /// A class to specify the underlying obligations of the reference entity on which protection is purchased or sold through the Credit Default Swap.
    /// </summary>
    public class Obligations : AbstractRosettaModelObject<Obligations>
    {
        private static readonly IRosettaMetaData<Obligations> metaData = new ObligationsMeta();
        
        [JsonConstructor]
        public Obligations(Enums.ObligationCategory category, bool? notSubordinated, SpecifiedCurrency? specifiedCurrency, bool? notSovereignLender, NotDomesticCurrency? notDomesticCurrency, bool? notDomesticLaw, bool? listed, bool? notDomesticIssuance, bool? fullFaithAndCreditObLiability, bool? generalFundObligationLiability, bool? revenueObligationLiability, bool? notContingent, string? excluded, string? othReferenceEntityObligations, FieldWithMetaString? designatedPriority, bool? cashSettlementOnly, bool? deliveryOfCommitments, bool? continuity)
        {
            Category = category;
            NotSubordinated = notSubordinated;
            SpecifiedCurrency = specifiedCurrency;
            NotSovereignLender = notSovereignLender;
            NotDomesticCurrency = notDomesticCurrency;
            NotDomesticLaw = notDomesticLaw;
            Listed = listed;
            NotDomesticIssuance = notDomesticIssuance;
            FullFaithAndCreditObLiability = fullFaithAndCreditObLiability;
            GeneralFundObligationLiability = generalFundObligationLiability;
            RevenueObligationLiability = revenueObligationLiability;
            NotContingent = notContingent;
            Excluded = excluded;
            OthReferenceEntityObligations = othReferenceEntityObligations;
            DesignatedPriority = designatedPriority;
            CashSettlementOnly = cashSettlementOnly;
            DeliveryOfCommitments = deliveryOfCommitments;
            Continuity = continuity;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Obligations> MetaData => metaData;
        
        /// <summary>
        /// Used in both obligations and deliverable obligations to represent a class or type of securities which apply. ISDA 2003 Term: Obligation Category/Deliverable Obligation Category.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ObligationCategory Category { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. An obligation that ranks at least equal with the most senior Reference Obligation in priority of payment or, if no Reference Obligation is specified in the related Confirmation, the obligations of the Reference Entity that are senior. ISDA 2003 Term: Not Subordinated.
        /// </summary>
        public bool? NotSubordinated { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. The currency or currencies in which an obligation or deliverable obligation must be payable. ISDA 2003 Term: Specified Currency.
        /// </summary>
        public SpecifiedCurrency? SpecifiedCurrency { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation that is not primarily (majority) owed to a Sovereign or Supranational Organisation. ISDA 2003 Term: Not Sovereign Lender.
        /// </summary>
        public bool? NotSovereignLender { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation that is payable in any currency other than the domestic currency. Domestic currency is either the currency so specified or, if no currency is specified, the currency of (a) the reference entity, if the reference entity is a sovereign, or (b) the jurisdiction in which the relevant reference entity is organised, if the reference entity is not a sovereign. ISDA 2003 Term: Not Domestic Currency.
        /// </summary>
        public NotDomesticCurrency? NotDomesticCurrency { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. If the reference entity is a Sovereign, this means any obligation that is not subject to the laws of the reference entity. If the reference entity is not a sovereign, this means any obligation that is not subject to the laws of the jurisdiction of the reference entity. ISDA 2003 Term: Not Domestic Law.
        /// </summary>
        public bool? NotDomesticLaw { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Indicates whether or not the obligation is quoted, listed or ordinarily purchased and sold on an exchange. ISDA 2003 Term: Listed.
        /// </summary>
        public bool? Listed { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Any obligation other than an obligation that was intended to be offered for sale primarily in the domestic market of the relevant Reference Entity. This specifies that the obligation must be an internationally recognised bond. ISDA 2003 Term: Not Domestic Issuance.
        /// </summary>
        public bool? NotDomesticIssuance { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: Full Faith and Credit Obligation Liability.
        /// </summary>
        public bool? FullFaithAndCreditObLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: General Fund Obligation Liability.
        /// </summary>
        public bool? GeneralFundObligationLiability { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published additional provisions for U.S. Municipal as Reference Entity. ISDA 2003 Term: Revenue Obligation Liability.
        /// </summary>
        public bool? RevenueObligationLiability { get; }
        
        /// <summary>
        /// OTE: Only allowed as an obligation characteristic under ISDA Credit 1999. In essence Not Contingent means the repayment of principal cannot be dependent on a formula/index, i.e. to prevent the risk of being delivered an instrument that may never pay any element of principal, and to ensure that the obligation is interest bearing (on a regular schedule). ISDA 2003 Term: Not Contingent.
        /// </summary>
        public bool? NotContingent { get; }
        
        /// <summary>
        /// A free format string to specify any excluded obligations or deliverable obligations, as the case may be, of the reference entity or excluded types of obligations or deliverable obligations. ISDA 2003 Term: Excluded Obligations/Excluded Deliverable Obligations.
        /// </summary>
        public string? Excluded { get; }
        
        /// <summary>
        /// This element is used to specify any other obligations of a reference entity in both obligations and deliverable obligations. The obligations can be specified free-form. ISDA 2003 Term: Other Obligations of a Reference Entity.
        /// </summary>
        public string? OthReferenceEntityObligations { get; }
        
        /// <summary>
        /// Applies to Loan CDS, to indicate what lien level is appropriate for a deliverable obligation. Applies to European Loan CDS, to indicate the Ranking of the obligation. Example: a 2nd lien Loan CDS would imply that the deliverable obligations are 1st or 2nd lien loans.
        /// </summary>
        public FieldWithMetaString? DesignatedPriority { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published Standard Terms Supplement for use with CDS Transactions on Leveraged Loans. ISDA 2003 Term: Cash Settlement Only.
        /// </summary>
        public bool? CashSettlementOnly { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published Standard Terms Supplement for use with CDS Transactions on Leveraged Loans. ISDA 2003 Term: Delivery of Commitments.
        /// </summary>
        public bool? DeliveryOfCommitments { get; }
        
        /// <summary>
        /// An obligation and deliverable obligation characteristic. Defined in the ISDA published Standard Terms Supplement for use with CDS Transactions on Leveraged Loans. ISDA 2003 Term: Continuity.
        /// </summary>
        public bool? Continuity { get; }
    }
    
    /// <summary>
    /// Specifies the object to be observed for a price, it could be an asset or a reference.
    /// </summary>
    public class Observable : AbstractRosettaModelObject<Observable>, IObservable
    {
        private static readonly IRosettaMetaData<Observable> metaData = new ObservableMeta();
        
        [JsonConstructor]
        public Observable(Asset? asset, Basket? basket, Index? index)
        {
            Asset = asset;
            Basket = basket;
            Index = index;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Observable> MetaData => metaData;
        
        /// <inheritdoc/>
        public Asset? Asset { get; }
        
        /// <inheritdoc/>
        public Basket? Basket { get; }
        
        /// <inheritdoc/>
        public Index? Index { get; }
    }
    
    /// <summary>
    /// Defines a single, numerical value that was observed in the marketplace. Observations of market data are made independently to business events or trade life-cycle events, so data instances of Observation can be created independently of any other model type, hence it is annotated as a root type. Observations will be broadly reused in many situations, so references to Observation are supported via the &apos;key&apos; annotation.
    /// </summary>
    public class Observation : AbstractRosettaModelObject<Observation>
    {
        private static readonly IRosettaMetaData<Observation> metaData = new ObservationMeta();
        
        [JsonConstructor]
        public Observation(Price observedValue, ObservationIdentifier observationIdentifier, _MetaFields? meta)
        {
            ObservedValue = observedValue;
            ObservationIdentifier = observationIdentifier;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Observation> MetaData => metaData;
        
        /// <summary>
        /// Specifies the observed value as a number.
        /// </summary>
        public Price ObservedValue { get; }
        
        /// <summary>
        /// Represents the observation was made i.e. how to uniquely identify the observed value among the population of all available market data.
        /// </summary>
        public ObservationIdentifier ObservationIdentifier { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies a single date on which market observations take place and specifies optional associated weighting.
    /// </summary>
    public class ObservationDate : AbstractRosettaModelObject<ObservationDate>
    {
        private static readonly IRosettaMetaData<ObservationDate> metaData = new ObservationDateMeta();
        
        [JsonConstructor]
        public ObservationDate(LocalDate? unadjustedDate, LocalDate? adjustedDate, decimal? weight, string? observationReference, _MetaFields? meta)
        {
            UnadjustedDate = unadjustedDate;
            AdjustedDate = adjustedDate;
            Weight = weight;
            ObservationReference = observationReference;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationDate> MetaData => metaData;
        
        /// <summary>
        /// A date subject to adjustment.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedDate { get; }
        
        /// <summary>
        /// The date once the adjustment has been performed. (Note that this date may change if the business center holidays change).
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedDate { get; }
        
        /// <summary>
        /// Specifies the degree of importance of the observation.
        /// </summary>
        public decimal? Weight { get; }
        
        /// <summary>
        /// Specifies an identification key for the market observation. This attribute can be used as a reference to assign weights to a series of dates defined in a parametricSchedule.
        /// </summary>
        public string? ObservationReference { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Describes date details for a set of observation dates in parametric or non-parametric form.
    /// </summary>
    public class ObservationDates : AbstractRosettaModelObject<ObservationDates>
    {
        private static readonly IRosettaMetaData<ObservationDates> metaData = new ObservationDatesMeta();
        
        [JsonConstructor]
        public ObservationDates(ObservationSchedule? observationSchedule, PeriodicDates? periodicSchedule, ParametricDates? parametricDates)
        {
            ObservationSchedule = observationSchedule;
            PeriodicSchedule = periodicSchedule;
            ParametricDates = parametricDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationDates> MetaData => metaData;
        
        /// <summary>
        /// Specifies a schedule of dates (non-parametric) on which market observations take place, and allows for the optional definition of weights where applicable.  When no weight is specified, then weight of each date is assumed to be 1.0
        /// </summary>
        public ObservationSchedule? ObservationSchedule { get; }
        
        /// <summary>
        /// Specifies the date range and frequency on which market observations take place.  Weights can be assigned to dates in the schedule by assigning the weight and corresponding observationReference in the observationSchedule.
        /// </summary>
        public PeriodicDates? PeriodicSchedule { get; }
        
        /// <summary>
        /// Specifies parametric terms to determine which days within a given calculation period the price would be observed. Typically associated with Commodities. 
        /// </summary>
        public ParametricDates? ParametricDates { get; }
    }
    
    /// <summary>
    /// Specifies the necessary information to create any observation event.
    /// </summary>
    public class ObservationEvent : AbstractRosettaModelObject<ObservationEvent>
    {
        private static readonly IRosettaMetaData<ObservationEvent> metaData = new ObservationEventMeta();
        
        [JsonConstructor]
        public ObservationEvent(CreditEvent? creditEvent, CorporateAction? corporateAction)
        {
            CreditEvent = creditEvent;
            CorporateAction = corporateAction;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationEvent> MetaData => metaData;
        
        /// <summary>
        /// Specifies the necessary information to create a credit event.
        /// </summary>
        public CreditEvent? CreditEvent { get; }
        
        /// <summary>
        /// Specifies the necessary information to create a corporate action.
        /// </summary>
        public CorporateAction? CorporateAction { get; }
    }
    
    /// <summary>
    /// Defines the parameters needed to uniquely identify a piece of data among the population of all available market data.
    /// </summary>
    public class ObservationIdentifier : AbstractRosettaModelObject<ObservationIdentifier>
    {
        private static readonly IRosettaMetaData<ObservationIdentifier> metaData = new ObservationIdentifierMeta();
        
        [JsonConstructor]
        public ObservationIdentifier(Observable observable, LocalDate observationDate, TimeZone? observationTime, InformationSource? informationSource, DeterminationMethodology? determinationMethodology)
        {
            Observable = observable;
            ObservationDate = observationDate;
            ObservationTime = observationTime;
            InformationSource = informationSource;
            DeterminationMethodology = determinationMethodology;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationIdentifier> MetaData => metaData;
        
        /// <summary>
        /// Represents the asset or rate to which the observation relates.
        /// </summary>
        public Observable Observable { get; }
        
        /// <summary>
        /// Specifies the date value to use when resolving the market data.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate ObservationDate { get; }
        
        /// <summary>
        /// Represents the time and time-zone.
        /// </summary>
        public TimeZone? ObservationTime { get; }
        
        /// <summary>
        /// Represents where the market data published and should be observed.
        /// </summary>
        public InformationSource? InformationSource { get; }
        
        /// <summary>
        /// Specifies the method according to which an amount or a date is determined.
        /// </summary>
        public DeterminationMethodology? DeterminationMethodology { get; }
    }
    
    /// <summary>
    /// Specifies inputs needed to process an observation.
    /// </summary>
    public class ObservationInstruction : AbstractRosettaModelObject<ObservationInstruction>
    {
        private static readonly IRosettaMetaData<ObservationInstruction> metaData = new ObservationInstructionMeta();
        
        [JsonConstructor]
        public ObservationInstruction(ObservationEvent observationEvent)
        {
            ObservationEvent = observationEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationInstruction> MetaData => metaData;
        
        /// <summary>
        /// Contains all information related to an observation.
        /// </summary>
        public ObservationEvent ObservationEvent { get; }
    }
    
    /// <summary>
    /// Parameters on daily observed computed rates, specifically daily caps and floors. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class ObservationParameters : AbstractRosettaModelObject<ObservationParameters>
    {
        private static readonly IRosettaMetaData<ObservationParameters> metaData = new ObservationParametersMeta();
        
        [JsonConstructor]
        public ObservationParameters(decimal? observationCapRate, decimal? observationFloorRate)
        {
            ObservationCapRate = observationCapRate;
            ObservationFloorRate = observationFloorRate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationParameters> MetaData => metaData;
        
        /// <summary>
        /// A daily observation cap rate.
        /// </summary>
        public decimal? ObservationCapRate { get; }
        
        /// <summary>
        /// A daily observation floor rate.
        /// </summary>
        public decimal? ObservationFloorRate { get; }
    }
    
    /// <summary>
    /// Specifies a single date on which market observations take place and specifies optional associated weighting.
    /// </summary>
    public class ObservationSchedule : AbstractRosettaModelObject<ObservationSchedule>
    {
        private static readonly IRosettaMetaData<ObservationSchedule> metaData = new ObservationScheduleMeta();
        
        [JsonConstructor]
        public ObservationSchedule(IEnumerable<ObservationDate> observationDate, BusinessDayAdjustments? dateAdjustments)
        {
            ObservationDate = observationDate;
            DateAdjustments = dateAdjustments;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationSchedule> MetaData => metaData;
        
        /// <summary>
        /// Specifies an adjusted or unadjusted date for a market observation.
        /// </summary>
        public IEnumerable<ObservationDate> ObservationDate { get; }
        
        /// <summary>
        /// The business day convention and financial business centers used for adjusting the date if it would otherwise fall on a day that is not a business date in the specified business centers.
        /// </summary>
        public BusinessDayAdjustments? DateAdjustments { get; }
    }
    
    /// <summary>
    /// Parameters to describe the observation shift for a daily compounded or averaged floating rate. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class ObservationShiftCalculation : AbstractRosettaModelObject<ObservationShiftCalculation>
    {
        private static readonly IRosettaMetaData<ObservationShiftCalculation> metaData = new ObservationShiftCalculationMeta();
        
        [JsonConstructor]
        public ObservationShiftCalculation(int? offsetDays, Enums.ObservationPeriodDates? calculationBase, BusinessCenters? additionalBusinessDays)
        {
            OffsetDays = offsetDays;
            CalculationBase = calculationBase;
            AdditionalBusinessDays = additionalBusinessDays;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationShiftCalculation> MetaData => metaData;
        
        /// <summary>
        /// The number of days of observation shift.
        /// </summary>
        public int? OffsetDays { get; }
        
        /// <summary>
        /// Whether the rate is calculated in advance, in arrears, or relative to a reset date.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.ObservationPeriodDates? CalculationBase { get; }
        
        /// <summary>
        /// Any additional business days that be applicable.
        /// </summary>
        public BusinessCenters? AdditionalBusinessDays { get; }
    }
    
    /// <summary>
    /// Class containing terms that are associated with observing a price/benchmark/index across either single or multiple observations. 
    /// </summary>
    public class ObservationTerms : AbstractRosettaModelObject<ObservationTerms>
    {
        private static readonly IRosettaMetaData<ObservationTerms> metaData = new ObservationTermsMeta();
        
        [JsonConstructor]
        public ObservationTerms(BusinessCenterTime? observationTime, Enums.TimeType? observationTimeType, FxSpotRateSource? informationSource, Rounding? precision, CalculationPeriodDates? calculationPeriodDates, ObservationDates observationDates, int? numberOfObservationDates)
        {
            ObservationTime = observationTime;
            ObservationTimeType = observationTimeType;
            InformationSource = informationSource;
            Precision = precision;
            CalculationPeriodDates = calculationPeriodDates;
            ObservationDates = observationDates;
            NumberOfObservationDates = numberOfObservationDates;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ObservationTerms> MetaData => metaData;
        
        /// <summary>
        /// Defines time in respect to a business calendar location that the price/benchmark/index is observed
        /// </summary>
        public BusinessCenterTime? ObservationTime { get; }
        
        /// <summary>
        /// The enumerated values to specify points in the day when option exercise and valuation can occur.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TimeType? ObservationTimeType { get; }
        
        /// <summary>
        /// The information source where a published or displayed market rate will be obtained, e.g. Telerate Page 3750.
        /// </summary>
        public FxSpotRateSource? InformationSource { get; }
        
        /// <summary>
        /// Defines rounding rules and precision to be used in the rounding of observations.
        /// </summary>
        public Rounding? Precision { get; }
        
        /// <summary>
        /// Defines parameters used to generate the calculation period dates schedule, including the specification of any initial or final stub calculation periods. A calculation period schedule consists of an optional initial stub calculation period, one or more regular calculation periods and an optional final stub calculation period. In the absence of any initial or final stub calculation periods, the regular part of the calculation period schedule is assumed to be between the effective date and the termination date. No implicit stubs are allowed, i.e. stubs must be explicitly specified using an appropriate combination of firstPeriodStartDate, firstRegularPeriodStartDate and lastRegularPeriodEndDate.
        /// </summary>
        public CalculationPeriodDates? CalculationPeriodDates { get; }
        
        /// <summary>
        /// Describes date details for a set of observation dates in parametric or non-parametric form.
        /// </summary>
        public ObservationDates ObservationDates { get; }
        
        /// <summary>
        /// The number of observation dates between observation start date and observation end date.
        /// </summary>
        public int? NumberOfObservationDates { get; }
    }
    
    /// <summary>
    /// A class defining an offset used in calculating a new date relative to a reference date, e.g. calendar days, business days, commodity Business days, etc.
    /// </summary>
    public class Offset : AbstractRosettaModelObject<Offset>, IOffset, IPeriod
    {
        private static readonly IRosettaMetaData<Offset> metaData = new OffsetMeta();
        
        [JsonConstructor]
        public Offset(int periodMultiplier, Enums.Period period, _MetaFields? meta, Enums.DayType? dayType)
        {
            PeriodMultiplier = periodMultiplier;
            PeriodValue = period;
            Meta = meta;
            DayType = dayType;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Offset> MetaData => metaData;
        
        /// <inheritdoc/>
        public int PeriodMultiplier { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        [JsonProperty(PropertyName = "period")]
        public Enums.Period PeriodValue { get; }
        
        public _MetaFields? Meta { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType? DayType { get; }
    }
    
    /// <summary>
    /// Defines business day shifts for daily componded or averaged rates.  This type is used for lookback and lockout rates. This type is used to represent modular computed rates in interestRatePayouts.
    /// </summary>
    public class OffsetCalculation : AbstractRosettaModelObject<OffsetCalculation>
    {
        private static readonly IRosettaMetaData<OffsetCalculation> metaData = new OffsetCalculationMeta();
        
        [JsonConstructor]
        public OffsetCalculation(int? offsetDays)
        {
            OffsetDays = offsetDays;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OffsetCalculation> MetaData => metaData;
        
        /// <summary>
        /// The number of business days offset.
        /// </summary>
        public int? OffsetDays { get; }
    }
    
    /// <summary>
    /// A class to specify whether One Way Provisions apply.
    /// </summary>
    public class OneWayProvisions : AbstractRosettaModelObject<OneWayProvisions>
    {
        private static readonly IRosettaMetaData<OneWayProvisions> metaData = new OneWayProvisionsMeta();
        
        [JsonConstructor]
        public OneWayProvisions(bool isApplicable, Enums.CounterpartyRole? postingParty)
        {
            IsApplicable = isApplicable;
            PostingParty = postingParty;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OneWayProvisions> MetaData => metaData;
        
        /// <summary>
        /// The determination of whether the One Way Provisions are applicable (true) or not applicable (false).
        /// </summary>
        public bool IsApplicable { get; }
        
        /// <summary>
        /// The Posting Party for the purposes of One Way Provisions. It is specified in the case where the One Way Provision is deemed applicable.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole? PostingParty { get; }
    }
    
    /// <summary>
    /// Defines additional optional features that can be included in an option contract.
    /// </summary>
    public class OptionFeature : AbstractRosettaModelObject<OptionFeature>
    {
        private static readonly IRosettaMetaData<OptionFeature> metaData = new OptionFeatureMeta();
        
        [JsonConstructor]
        public OptionFeature(IEnumerable<FxFeature> fxFeature, StrategyFeature? strategyFeature, AveragingFeature? averagingFeature, Barrier? barrier, Knock? knock, PassThrough? passThrough)
        {
            FxFeature = fxFeature;
            StrategyFeature = strategyFeature;
            AveragingFeature = averagingFeature;
            Barrier = barrier;
            Knock = knock;
            PassThrough = passThrough;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionFeature> MetaData => metaData;
        
        /// <summary>
        /// Describes a quanto or composite FX feature.
        /// </summary>
        public IEnumerable<FxFeature> FxFeature { get; }
        
        /// <summary>
        /// Defines a simple strategy feature.
        /// </summary>
        public StrategyFeature? StrategyFeature { get; }
        
        /// <summary>
        /// Defines an option feature in which an average market observation price is determined on valuation and compared to the strike to determine a settlement amount.
        /// </summary>
        public AveragingFeature? AveragingFeature { get; }
        
        /// <summary>
        /// Specifies a barrier feature.
        /// </summary>
        public Barrier? Barrier { get; }
        
        /// <summary>
        /// Specifies a knock in or knock out feature.
        /// </summary>
        public Knock? Knock { get; }
        
        /// <summary>
        /// Specifies the rules for pass-through payments from the underlier, such as dividends.
        /// </summary>
        public PassThrough? PassThrough { get; }
    }
    
    /// <summary>
    ///  The option payout specification terms. The associated globalKey denotes the ability to associate a hash value to the respective OptionPayout instantiation for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class OptionPayout : AbstractRosettaModelObject<OptionPayout>, IPayoutBase
    {
        private static readonly IRosettaMetaData<OptionPayout> metaData = new OptionPayoutMeta();
        
        [JsonConstructor]
        public OptionPayout(PayerReceiver payerReceiver, ResolvablePriceQuantity? priceQuantity, PrincipalPayments? principalPayment, SettlementTerms? settlementTerms, BuyerSeller buyerSeller, OptionFeature? feature, ObservationTerms? observationTerms, CalculationSchedule? schedule, AssetDeliveryInformation? delivery, Underlier underlier, Enums.OptionType? optionType, ExerciseTerms exerciseTerms, OptionStrike? strike)
        {
            PayerReceiver = payerReceiver;
            PriceQuantity = priceQuantity;
            PrincipalPayment = principalPayment;
            SettlementTerms = settlementTerms;
            BuyerSeller = buyerSeller;
            Feature = feature;
            ObservationTerms = observationTerms;
            Schedule = schedule;
            Delivery = delivery;
            Underlier = underlier;
            OptionType = optionType;
            ExerciseTerms = exerciseTerms;
            Strike = strike;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionPayout> MetaData => metaData;
        
        /// <inheritdoc/>
        public PayerReceiver PayerReceiver { get; }
        
        /// <inheritdoc/>
        public ResolvablePriceQuantity? PriceQuantity { get; }
        
        /// <inheritdoc/>
        public PrincipalPayments? PrincipalPayment { get; }
        
        /// <inheritdoc/>
        public SettlementTerms? SettlementTerms { get; }
        
        public BuyerSeller BuyerSeller { get; }
        
        /// <summary>
        /// The option feature, such as quanto, Asian, barrier, knock.
        /// </summary>
        public OptionFeature? Feature { get; }
        
        /// <summary>
        /// Class containing terms that are associated with observing a price/benchmark/index across either single or multple observations. To be used for option contracts that reference a benchmark price.
        /// </summary>
        public ObservationTerms? ObservationTerms { get; }
        
        /// <summary>
        /// Allows the full representation of a payout by defining a set of schedule periods. It supports standard schedule customization by expressing all the dates, quantities, and pricing data in a non-parametric way.
        /// </summary>
        public CalculationSchedule? Schedule { get; }
        
        /// <summary>
        /// Contains the information relative to the delivery of the asset.
        /// </summary>
        public AssetDeliveryInformation? Delivery { get; }
        
        /// <summary>
        /// The financial product underlying the option, which can be of any type including an Asset, Basket, Index or a NonTransferableProduct.
        /// </summary>
        public Underlier Underlier { get; }
        
        /// <summary>
        /// The type of option transaction. From a usage standpoint, put/call is the default option type, while payer/receiver indicator is used for options on index credit default swaps, consistently with the industry practice. Straddle is used for the case of straddle strategy, that combine a call and a put with the same strike.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.OptionType? OptionType { get; }
        
        /// <summary>
        /// The terms for exercising the option, which include the option style (e.g. American style option), the exercise procedure (e.g. manual exercise) and the settlement terms (e.g. physical vs. cash).
        /// </summary>
        public ExerciseTerms ExerciseTerms { get; }
        
        /// <summary>
        /// Specifies the strike of the option
        /// </summary>
        public OptionStrike? Strike { get; }
    }
    
    /// <summary>
    /// Defines the strike price of an option.
    /// </summary>
    public class OptionStrike : AbstractRosettaModelObject<OptionStrike>
    {
        private static readonly IRosettaMetaData<OptionStrike> metaData = new OptionStrikeMeta();
        
        [JsonConstructor]
        public OptionStrike(Price? strikePrice, ReferenceWithMetaFixedRateSpecification? strikeReference, ReferenceSwapCurve? referenceSwapCurve, AveragingStrikeFeature? averagingStrikeFeature)
        {
            StrikePrice = strikePrice;
            StrikeReference = strikeReference;
            ReferenceSwapCurve = referenceSwapCurve;
            AveragingStrikeFeature = averagingStrikeFeature;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionStrike> MetaData => metaData;
        
        /// <summary>
        /// Defines the strike of an option in the form of a price that could be a cash price, interestRate, or other types.
        /// </summary>
        public Price? StrikePrice { get; }
        
        /// <summary>
        /// Defines the strike of an option in reference to the spread of the underlying swap (typical practice in the case of an option on a credit single name swaps).
        /// </summary>
        public ReferenceWithMetaFixedRateSpecification? StrikeReference { get; }
        
        /// <summary>
        /// Defines the strike of an option when expressed by reference to a swap curve (Typically the case for a convertible bond option).
        /// </summary>
        public ReferenceSwapCurve? ReferenceSwapCurve { get; }
        
        /// <summary>
        /// Defines an  option strike that is calculated from an average of observed market prices.
        /// </summary>
        public AveragingStrikeFeature? AveragingStrikeFeature { get; }
    }
    
    /// <summary>
    /// A data defining:  an early termination provision where either or both parties have the right to exercise.
    /// </summary>
    public class OptionalEarlyTermination : AbstractRosettaModelObject<OptionalEarlyTermination>
    {
        private static readonly IRosettaMetaData<OptionalEarlyTermination> metaData = new OptionalEarlyTerminationMeta();
        
        [JsonConstructor]
        public OptionalEarlyTermination(BuyerSeller? singlePartyOption, bool? mutualEarlyTermination, IEnumerable<ExerciseNotice> exerciseNotice, bool? followUpConfirmation, CalculationAgent? calculationAgent, SettlementTerms? cashSettlement, OptionalEarlyTerminationAdjustedDates? optionalEarlyTerminationAdjustedDates, ExerciseTerms exerciseTerms)
        {
            SinglePartyOption = singlePartyOption;
            MutualEarlyTermination = mutualEarlyTermination;
            ExerciseNotice = exerciseNotice;
            FollowUpConfirmation = followUpConfirmation;
            CalculationAgent = calculationAgent;
            CashSettlement = cashSettlement;
            OptionalEarlyTerminationAdjustedDates = optionalEarlyTerminationAdjustedDates;
            ExerciseTerms = exerciseTerms;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionalEarlyTermination> MetaData => metaData;
        
        /// <summary>
        /// If optional early termination is not available to both parties then this component specifies the buyer and seller of the option. In FpML, this attribute is of type SinglePsrtyOption, which actually consists of the BuyerSeller.model.
        /// </summary>
        public BuyerSeller? SinglePartyOption { get; }
        
        /// <summary>
        /// Used for specifying whether the Mutual Early Termination Right that is detailed in the Master Confirmation will apply.
        /// </summary>
        public bool? MutualEarlyTermination { get; }
        
        /// <summary>
        /// Definition of the party to whom notice of exercise should be given.
        /// </summary>
        public IEnumerable<ExerciseNotice> ExerciseNotice { get; }
        
        /// <summary>
        /// A flag to indicate whether follow-up confirmation of exercise (written or electronic) is required following telephonic notice by the buyer to the seller or seller&apos;s agent.
        /// </summary>
        public bool? FollowUpConfirmation { get; }
        
        /// <summary>
        /// The ISDA Calculation Agent responsible for performing duties associated with an optional early termination.
        /// </summary>
        public CalculationAgent? CalculationAgent { get; }
        
        /// <summary>
        /// If specified, this means that cash settlement is applicable to the transaction and defines the parameters associated with the cash settlement procedure. If not specified, then physical settlement is applicable.
        /// </summary>
        public SettlementTerms? CashSettlement { get; }
        
        /// <summary>
        /// An early termination provision to terminate the trade at fair value where one or both parties have the right to decide on termination.
        /// </summary>
        public OptionalEarlyTerminationAdjustedDates? OptionalEarlyTerminationAdjustedDates { get; }
        
        /// <summary>
        /// The exercise terms associated with the optional early termination, including details such as exercise style, exercise fees, and any other relevant conditions or terms.
        /// </summary>
        public ExerciseTerms ExerciseTerms { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted dates associated with an optional early termination provision.
    /// </summary>
    public class OptionalEarlyTerminationAdjustedDates : AbstractRosettaModelObject<OptionalEarlyTerminationAdjustedDates>
    {
        private static readonly IRosettaMetaData<OptionalEarlyTerminationAdjustedDates> metaData = new OptionalEarlyTerminationAdjustedDatesMeta();
        
        [JsonConstructor]
        public OptionalEarlyTerminationAdjustedDates(IEnumerable<EarlyTerminationEvent> earlyTerminationEvent)
        {
            EarlyTerminationEvent = earlyTerminationEvent;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OptionalEarlyTerminationAdjustedDates> MetaData => metaData;
        
        /// <summary>
        /// The adjusted dates associated with an individual early termination date.
        /// </summary>
        public IEnumerable<EarlyTerminationEvent> EarlyTerminationEvent { get; }
    }
    
    public class OrdrTrnsmssn : AbstractRosettaModelObject<OrdrTrnsmssn>
    {
        private static readonly IRosettaMetaData<OrdrTrnsmssn> metaData = new OrdrTrnsmssnMeta();
        
        [JsonConstructor]
        public OrdrTrnsmssn(string trnsmssnInd)
        {
            TrnsmssnInd = trnsmssnInd;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OrdrTrnsmssn> MetaData => metaData;
        
        public string TrnsmssnInd { get; }
    }
    
    /// <summary>
    /// A class for defining an agreement executed between parties.
    /// </summary>
    public class OtherAgreement : AbstractRosettaModelObject<OtherAgreement>
    {
        private static readonly IRosettaMetaData<OtherAgreement> metaData = new OtherAgreementMeta();
        
        [JsonConstructor]
        public OtherAgreement(FieldWithMetaString? identifier, FieldWithMetaString otherAgreementType, FieldWithMetaString? version, LocalDate? date)
        {
            Identifier = identifier;
            OtherAgreementType = otherAgreementType;
            Version = version;
            Date = date;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OtherAgreement> MetaData => metaData;
        
        /// <summary>
        /// An identifier that has been created to identify the agreement.
        /// </summary>
        public FieldWithMetaString? Identifier { get; }
        
        /// <summary>
        /// The agreement executed between the parties and intended to govern product-specific derivatives transactions between those parties.
        /// </summary>
        public FieldWithMetaString OtherAgreementType { get; }
        
        /// <summary>
        /// The version of the agreement.
        /// </summary>
        public FieldWithMetaString? Version { get; }
        
        /// <summary>
        /// The date on which the agreement was signed.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? Date { get; }
    }
    
    /// <summary>
    /// A class to specify a related legal agreement. For example, ISDA 2016 Credit Support Annex for Initial Margin, paragraph 13, General Principles, (s): Other CSA and Japanese Law CSA (VM). | ISDA 2016 Credit Support Annex for Variation Margin, paragraph 13, (o): Other CSA.
    /// </summary>
    public class OtherAgreementTerms : AbstractRosettaModelObject<OtherAgreementTerms>
    {
        private static readonly IRosettaMetaData<OtherAgreementTerms> metaData = new OtherAgreementTermsMeta();
        
        [JsonConstructor]
        public OtherAgreementTerms(bool isSpecified, string? legalDocument)
        {
            IsSpecified = isSpecified;
            LegalDocument = legalDocument;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OtherAgreementTerms> MetaData => metaData;
        
        /// <summary>
        /// The qualification of whether some other related agreement is specified (True) or not (False).
        /// </summary>
        public bool IsSpecified { get; }
        
        /// <summary>
        /// The specification of this other agreement, when the qualification is True.
        /// </summary>
        public string? LegalDocument { get; }
    }
    
    /// <summary>
    /// The bespoke definition of other agreement terms as specified by the parties to the agreement.
    /// </summary>
    public class OtherAgreements : AbstractRosettaModelObject<OtherAgreements>
    {
        private static readonly IRosettaMetaData<OtherAgreements> metaData = new OtherAgreementsMeta();
        
        [JsonConstructor]
        public OtherAgreements(OtherAgreementTerms? otherCsa, OtherAgreementTerms? japaneseLawCsa)
        {
            OtherCsa = otherCsa;
            JapaneseLawCsa = japaneseLawCsa;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OtherAgreements> MetaData => metaData;
        
        /// <summary>
        /// The bespoke definition of Other CSA as specified by the parties to the agreement.
        /// </summary>
        public OtherAgreementTerms? OtherCsa { get; }
        
        /// <summary>
        /// The bespoke definition of whether Japanese Law CSA (VM) are specified by the parties to the agreement.
        /// </summary>
        public OtherAgreementTerms? JapaneseLawCsa { get; }
    }
    
    /// <summary>
    /// A class to specify the Other Eligible Support elections associated Initial and Variation margin agreements.
    /// </summary>
    public class OtherEligibleAndPostedSupport : AbstractRosettaModelObject<OtherEligibleAndPostedSupport>
    {
        private static readonly IRosettaMetaData<OtherEligibleAndPostedSupport> metaData = new OtherEligibleAndPostedSupportMeta();
        
        [JsonConstructor]
        public OtherEligibleAndPostedSupport(bool applicableValue, bool? applicableTransfer)
        {
            ApplicableValue = applicableValue;
            ApplicableTransfer = applicableTransfer;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OtherEligibleAndPostedSupport> MetaData => metaData;
        
        /// <summary>
        /// The definition of &apos;Value&apos; with respect to Other Eligible Support (IM) and Other Posted Support (IM).
        /// </summary>
        public bool ApplicableValue { get; }
        
        /// <summary>
        /// The definition of &apos;Transfer&apos; with respect to Other Eligible Support (IM) and Other Posted Support (IM).
        /// </summary>
        public bool? ApplicableTransfer { get; }
    }
    
    /// <summary>
    /// Specification of a user-defined index that does not meet the criteria of other Index data types.
    /// </summary>
    public class OtherIndex : AbstractRosettaModelObject<OtherIndex>, IIndexBase
    {
        private static readonly IRosettaMetaData<OtherIndex> metaData = new OtherIndexMeta();
        
        [JsonConstructor]
        public OtherIndex(IEnumerable<AssetIdentifier> identifier, IEnumerable<Taxonomy> taxonomy, bool? isExchangeListed, LegalEntity? exchange, IEnumerable<LegalEntity> relatedExchange, FieldWithMetaString? name, LegalEntity? provider, Enums.AssetClass? assetClass, string? description)
        {
            Identifier = identifier;
            Taxonomy = taxonomy;
            IsExchangeListed = isExchangeListed;
            Exchange = exchange;
            RelatedExchange = relatedExchange;
            Name = name;
            Provider = provider;
            AssetClass = assetClass;
            Description = description;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<OtherIndex> MetaData => metaData;
        
        /// <inheritdoc/>
        public IEnumerable<AssetIdentifier> Identifier { get; }
        
        /// <inheritdoc/>
        public IEnumerable<Taxonomy> Taxonomy { get; }
        
        /// <inheritdoc/>
        public bool? IsExchangeListed { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Exchange { get; }
        
        /// <inheritdoc/>
        public IEnumerable<LegalEntity> RelatedExchange { get; }
        
        /// <inheritdoc/>
        public FieldWithMetaString? Name { get; }
        
        /// <inheritdoc/>
        public LegalEntity? Provider { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.AssetClass? AssetClass { get; }
        
        /// <summary>
        /// A description that defines the OtherIndex.
        /// </summary>
        public string? Description { get; }
    }
    
    public class Othr : AbstractRosettaModelObject<Othr>
    {
        private static readonly IRosettaMetaData<Othr> metaData = new OthrMeta();
        
        [JsonConstructor]
        public Othr(FinInstrmGnlAttrbts finInstrmGnlAttrbts, DerivInstrmAttrbts derivInstrmAttrbts, string id, SchmeNm schmeNm)
        {
            FinInstrmGnlAttrbts = finInstrmGnlAttrbts;
            DerivInstrmAttrbts = derivInstrmAttrbts;
            Id = id;
            SchmeNm = schmeNm;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Othr> MetaData => metaData;
        
        public FinInstrmGnlAttrbts FinInstrmGnlAttrbts { get; }
        
        public DerivInstrmAttrbts DerivInstrmAttrbts { get; }
        
        public string Id { get; }
        
        public SchmeNm SchmeNm { get; }
    }
    
    /// <summary>
    /// A class to specify the Partial Cash Deliverable Obligation Characteristic.
    /// </summary>
    public class PCDeliverableObligationCharac : AbstractRosettaModelObject<PCDeliverableObligationCharac>, IPCDeliverableObligationCharac
    {
        private static readonly IRosettaMetaData<PCDeliverableObligationCharac> metaData = new PCDeliverableObligationCharacMeta();
        
        [JsonConstructor]
        public PCDeliverableObligationCharac(bool applicable, bool? partialCashSettlement)
        {
            Applicable = applicable;
            PartialCashSettlement = partialCashSettlement;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PCDeliverableObligationCharac> MetaData => metaData;
        
        /// <inheritdoc/>
        public bool Applicable { get; }
        
        /// <inheritdoc/>
        public bool? PartialCashSettlement { get; }
    }
    
    /// <summary>
    /// Defines rules for the dates on which the price will be determined.
    /// </summary>
    public class ParametricDates : AbstractRosettaModelObject<ParametricDates>
    {
        private static readonly IRosettaMetaData<ParametricDates> metaData = new ParametricDatesMeta();
        
        [JsonConstructor]
        public ParametricDates(Enums.DayType dayType, Enums.DayDistribution? dayDistribution, IEnumerable<Enums.DayOfWeek> dayOfWeek, decimal? dayFrequency, Lag? lag, BusinessCenters businessCenters)
        {
            DayType = dayType;
            DayDistribution = dayDistribution;
            DayOfWeek = dayOfWeek;
            DayFrequency = dayFrequency;
            Lag = lag;
            BusinessCenters = businessCenters;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<ParametricDates> MetaData => metaData;
        
        /// <summary>
        /// Denotes the enumerated values to specify the day type classification used in counting the number of days between two dates.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayType DayType { get; }
        
        /// <summary>
        /// Denotes the method by which the pricing days are distributed across the pricing period.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.DayDistribution? DayDistribution { get; }
        
        /// <summary>
        /// Indicates the days of the week on which the price will be determined.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public IEnumerable<Enums.DayOfWeek> DayOfWeek { get; }
        
        /// <summary>
        /// Defines the occurrence of the dayOfWeek within the pricing period on which pricing will take place, e.g. the 3rd Friday within each Calculation Period. If omitted, every dayOfWeek will be a pricing day.
        /// </summary>
        public decimal? DayFrequency { get; }
        
        /// <summary>
        /// The pricing period per calculation period if the pricing days do not wholly fall within the respective calculation period.
        /// </summary>
        public Lag? Lag { get; }
        
        /// <summary>
        /// The enumerated values to specify the business centers.
        /// </summary>
        public BusinessCenters BusinessCenters { get; }
    }
    
    /// <summary>
    /// A class defining partial exercise. As defined in the 2000 ISDA Definitions, Section 12.3 Partial Exercise, the buyer of the option may exercise all or less than all the notional amount of the underlying swap but may not be less than the minimum notional amount (if specified) and must be an integral multiple of the integral multiple amount if specified.
    /// </summary>
    public class PartialExercise : AbstractRosettaModelObject<PartialExercise>, IPartialExercise
    {
        private static readonly IRosettaMetaData<PartialExercise> metaData = new PartialExerciseMeta();
        
        [JsonConstructor]
        public PartialExercise(ReferenceWithMetaMoney notionalReference, decimal? integralMultipleAmount, decimal? minimumNotionalAmount, int? minimumNumberOfOptions)
        {
            NotionalReference = notionalReference;
            IntegralMultipleAmount = integralMultipleAmount;
            MinimumNotionalAmount = minimumNotionalAmount;
            MinimumNumberOfOptions = minimumNumberOfOptions;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartialExercise> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaMoney NotionalReference { get; }
        
        /// <inheritdoc/>
        public decimal? IntegralMultipleAmount { get; }
        
        /// <inheritdoc/>
        public decimal? MinimumNotionalAmount { get; }
        
        /// <inheritdoc/>
        public int? MinimumNumberOfOptions { get; }
    }
    
    /// <summary>
    /// A class to specify a party, without a qualification as to whether this party is a legal entity or a natural person, although the model provides the ability to associate a person (or set of persons) to a party, which use case would imply that such party would be a legal entity (even if not formally specified as such). 
    /// </summary>
    public class Party : AbstractRosettaModelObject<Party>
    {
        private static readonly IRosettaMetaData<Party> metaData = new PartyMeta();
        
        [JsonConstructor]
        public Party(IEnumerable<PartyIdentifier> partyId, FieldWithMetaString? name, IEnumerable<BusinessUnit> businessUnit, IEnumerable<NaturalPerson> person, IEnumerable<NaturalPersonRole> personRole, Account? account, ContactInformation? contactInformation, _MetaFields? meta)
        {
            PartyId = partyId;
            Name = name;
            BusinessUnit = businessUnit;
            Person = person;
            PersonRole = personRole;
            Account = account;
            ContactInformation = contactInformation;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<Party> MetaData => metaData;
        
        /// <summary>
        /// The identifier associated with a party, e.g. the 20 digits LEI code.
        /// </summary>
        public IEnumerable<PartyIdentifier> PartyId { get; }
        
        /// <summary>
        /// The party name.
        /// </summary>
        public FieldWithMetaString? Name { get; }
        
        /// <summary>
        /// Optional organization unit information used to describe the organization units (e.g. trading desks) involved in a transaction or business process, incl. the contact information (when relevant).
        /// </summary>
        public IEnumerable<BusinessUnit> BusinessUnit { get; }
        
        /// <summary>
        /// The person(s) who might be associated with the party as part of the execution, contract or legal document.
        /// </summary>
        public IEnumerable<NaturalPerson> Person { get; }
        
        /// <summary>
        /// The role of the person(s) 
        /// </summary>
        public IEnumerable<NaturalPersonRole> PersonRole { get; }
        
        /// <summary>
        /// The account that might be associated with the party. At most one account can be specified, as it is expected that this information is used in the context of a contract or legal document where only one account per party can be associated with such object.
        /// </summary>
        public Account? Account { get; }
        
        /// <summary>
        /// The postal/street address, telephone number, email address and/or web page. If the contact information is specific to the associated business unit(s) or person (s), it should be associated with those.
        /// </summary>
        public ContactInformation? ContactInformation { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// A class defining a legal agreement identifier issued by the indicated party.
    /// </summary>
    public class PartyAgreementIdentifier : AbstractRosettaModelObject<PartyAgreementIdentifier>
    {
        private static readonly IRosettaMetaData<PartyAgreementIdentifier> metaData = new PartyAgreementIdentifierMeta();
        
        [JsonConstructor]
        public PartyAgreementIdentifier(ReferenceWithMetaParty partyReference, IEnumerable<FieldWithMetaIdentifier> documentIdentifier, _MetaFields? meta)
        {
            PartyReference = partyReference;
            DocumentIdentifier = documentIdentifier;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyAgreementIdentifier> MetaData => metaData;
        
        /// <summary>
        /// Party that issued the document identifier.
        /// </summary>
        public ReferenceWithMetaParty PartyReference { get; }
        
        /// <summary>
        /// While FpML specifies the document identifier with a value and an associated scheme, the CDM makes use of the Identifier, which has an explicit issuer. The issuer of this identifier is not necessarily the same as the party reference.
        /// </summary>
        public IEnumerable<FieldWithMetaIdentifier> DocumentIdentifier { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies instruction to change the party on a trade. This primitive instruction is used in a number of scenarios including: clearing, allocation and novation. The instrution must include a trade identifier, because a change of party effectively results in a different trade.
    /// </summary>
    public class PartyChangeInstruction : AbstractRosettaModelObject<PartyChangeInstruction>
    {
        private static readonly IRosettaMetaData<PartyChangeInstruction> metaData = new PartyChangeInstructionMeta();
        
        [JsonConstructor]
        public PartyChangeInstruction(Counterparty counterparty, AncillaryParty? ancillaryParty, PartyRole? partyRole, IEnumerable<TradeIdentifier> tradeId)
        {
            Counterparty = counterparty;
            AncillaryParty = ancillaryParty;
            PartyRole = partyRole;
            TradeId = tradeId;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyChangeInstruction> MetaData => metaData;
        
        /// <summary>
        /// The new counterparty who is stepping into the trade. The stepping out counterparty is inferred based on the counterparty role that is being updated.
        /// </summary>
        public Counterparty Counterparty { get; }
        
        /// <summary>
        /// Specifies an ancillary party to be added onto the new transaction, e.g. the original executing party in an allocation.
        /// </summary>
        public AncillaryParty? AncillaryParty { get; }
        
        /// <summary>
        /// Specifies an additional party roles to be added on to the new transaction.
        /// </summary>
        public PartyRole? PartyRole { get; }
        
        /// <summary>
        /// The identifier to be assigned to the new trade post change of party.
        /// </summary>
        public IEnumerable<TradeIdentifier> TradeId { get; }
    }
    
    /// <summary>
    /// A class to specify contact information within a party: address and, optionally, associated business unit and person. This class also supports the ISDA CSA representation as a single string, through the address attribute.
    /// </summary>
    public class PartyContactInformation : AbstractRosettaModelObject<PartyContactInformation>
    {
        private static readonly IRosettaMetaData<PartyContactInformation> metaData = new PartyContactInformationMeta();
        
        [JsonConstructor]
        public PartyContactInformation(Enums.CounterpartyRole? party, ReferenceWithMetaParty? partyReference, ContactInformation? contactInformation, IEnumerable<BusinessUnit> businessUnit, IEnumerable<NaturalPerson> person, string? additionalInformation)
        {
            Party = party;
            PartyReference = partyReference;
            ContactInformation = contactInformation;
            BusinessUnit = businessUnit;
            Person = person;
            AdditionalInformation = additionalInformation;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyContactInformation> MetaData => metaData;
        
        /// <summary>
        /// Specifies the role of the Party to which the contact information refers to.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole? Party { get; }
        
        /// <summary>
        /// The reference to the party to which the contact information refers to.
        /// </summary>
        public ReferenceWithMetaParty? PartyReference { get; }
        
        /// <summary>
        /// The postal/street address, telephone number, email address and/or web page. If the contact information is specific to the associated business unit(s), it should be associated with those.
        /// </summary>
        public ContactInformation? ContactInformation { get; }
        
        /// <summary>
        /// Optional organization unit information used to describe the organization units (e.g. trading desks) involved in a transaction or business process, incl. the contact information (when relevant).
        /// </summary>
        public IEnumerable<BusinessUnit> BusinessUnit { get; }
        
        /// <summary>
        /// Optional information about people involved in a transaction or business process. (These are employees of the party.)
        /// </summary>
        public IEnumerable<NaturalPerson> Person { get; }
        
        /// <summary>
        /// Specification of special instructions of the relevant party.
        /// </summary>
        public string? AdditionalInformation { get; }
    }
    
    /// <summary>
    /// A class to specify a party-related, non-standardized data in a generic form.
    /// </summary>
    public class PartyCustomisedWorkflow : AbstractRosettaModelObject<PartyCustomisedWorkflow>
    {
        private static readonly IRosettaMetaData<PartyCustomisedWorkflow> metaData = new PartyCustomisedWorkflowMeta();
        
        [JsonConstructor]
        public PartyCustomisedWorkflow(ReferenceWithMetaParty? partyReference, string? partyName, IEnumerable<CustomisedWorkflow> customisedWorkflow)
        {
            PartyReference = partyReference;
            PartyName = partyName;
            CustomisedWorkflow = customisedWorkflow;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyCustomisedWorkflow> MetaData => metaData;
        
        /// <summary>
        /// Reference to the party to which the workflow pertains to.
        /// </summary>
        public ReferenceWithMetaParty? PartyReference { get; }
        
        /// <summary>
        /// The party name to which the workflow pertains to.
        /// </summary>
        public string? PartyName { get; }
        
        /// <summary>
        /// Non-standardized data in a generic form.
        /// </summary>
        public IEnumerable<CustomisedWorkflow> CustomisedWorkflow { get; }
    }
    
    /// <summary>
    /// Comprises an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the PartyIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    /// </summary>
    public class PartyIdentifier : AbstractRosettaModelObject<PartyIdentifier>
    {
        private static readonly IRosettaMetaData<PartyIdentifier> metaData = new PartyIdentifierMeta();
        
        [JsonConstructor]
        public PartyIdentifier(FieldWithMetaString identifier, Enums.PartyIdentifierType? identifierType, _MetaFields? meta)
        {
            Identifier = identifier;
            IdentifierType = identifierType;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyIdentifier> MetaData => metaData;
        
        /// <summary>
        /// Provides an identifier associated with a party. The identifier is unique within the public source specified in the source attribute.
        /// </summary>
        public FieldWithMetaString Identifier { get; }
        
        /// <summary>
        /// Defines the source of the identifier.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PartyIdentifierType? IdentifierType { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// Specifies mechanism for Termination currency to be selected by the Non-defaulting Party/party which is not the Affected Party.
    /// </summary>
    public class PartyOptionTerminationCurrency : AbstractRosettaModelObject<PartyOptionTerminationCurrency>
    {
        private static readonly IRosettaMetaData<PartyOptionTerminationCurrency> metaData = new PartyOptionTerminationCurrencyMeta();
        
        [JsonConstructor]
        public PartyOptionTerminationCurrency(string? bothAffectedTermCurrencyOption, string? terminationCurrencySpecifiedCondition, Enums.TerminationCurrencyCondition terminationCurrencyCondition)
        {
            BothAffectedTermCurrencyOption = bothAffectedTermCurrencyOption;
            TerminationCurrencySpecifiedCondition = terminationCurrencySpecifiedCondition;
            TerminationCurrencyCondition = terminationCurrencyCondition;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyOptionTerminationCurrency> MetaData => metaData;
        
        /// <summary>
        /// Specifies termination currency where there are two Affected Parties and they cannot agree on the termination currency.
        /// </summary>
        public string? BothAffectedTermCurrencyOption { get; }
        
        /// <summary>
        /// Specifies alternative conditions for selection of the termination currency.
        /// </summary>
        public string? TerminationCurrencySpecifiedCondition { get; }
        
        /// <summary>
        /// Specifies the enumerated conditions for selection of the termination currency.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.TerminationCurrencyCondition TerminationCurrencyCondition { get; }
    }
    
    /// <summary>
    /// Specifies the parties responsible for making and receiving payments defined by this structure.
    /// </summary>
    public class PartyReferencePayerReceiver : AbstractRosettaModelObject<PartyReferencePayerReceiver>, IPartyReferencePayerReceiver
    {
        private static readonly IRosettaMetaData<PartyReferencePayerReceiver> metaData = new PartyReferencePayerReceiverMeta();
        
        [JsonConstructor]
        public PartyReferencePayerReceiver(ReferenceWithMetaParty payerPartyReference, ReferenceWithMetaAccount? payerAccountReference, ReferenceWithMetaParty receiverPartyReference, ReferenceWithMetaAccount? receiverAccountReference)
        {
            PayerPartyReference = payerPartyReference;
            PayerAccountReference = payerAccountReference;
            ReceiverPartyReference = receiverPartyReference;
            ReceiverAccountReference = receiverAccountReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyReferencePayerReceiver> MetaData => metaData;
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty PayerPartyReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaAccount? PayerAccountReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaParty ReceiverPartyReference { get; }
        
        /// <inheritdoc/>
        public ReferenceWithMetaAccount? ReceiverAccountReference { get; }
    }
    
    /// <summary>
    /// A class to specify the role(s) that party(ies) may have in relation to the execution, contract or other legal agreement.
    /// </summary>
    public class PartyRole : AbstractRosettaModelObject<PartyRole>
    {
        private static readonly IRosettaMetaData<PartyRole> metaData = new PartyRoleMeta();
        
        [JsonConstructor]
        public PartyRole(ReferenceWithMetaParty partyReference, Enums.PartyRole role, ReferenceWithMetaParty? ownershipPartyReference)
        {
            PartyReference = partyReference;
            Role = role;
            OwnershipPartyReference = ownershipPartyReference;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyRole> MetaData => metaData;
        
        /// <summary>
        /// A reference to the party to which the role refers to.
        /// </summary>
        public ReferenceWithMetaParty PartyReference { get; }
        
        /// <summary>
        /// The party role.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PartyRole Role { get; }
        
        /// <summary>
        /// A reference to the party that has ownership of this party role information. FpML specifies that For shared trade information, this attribute will reference the originator of the data (for example, an execution facility or clearing house).
        /// </summary>
        public ReferenceWithMetaParty? OwnershipPartyReference { get; }
    }
    
    /// <summary>
    /// Specifies the termination currency to be used by a party when it is the Non-Defaulting Party or the Party which is not the Affected Party.
    /// </summary>
    public class PartyTerminationCurrencySelection : AbstractRosettaModelObject<PartyTerminationCurrencySelection>
    {
        private static readonly IRosettaMetaData<PartyTerminationCurrencySelection> metaData = new PartyTerminationCurrencySelectionMeta();
        
        [JsonConstructor]
        public PartyTerminationCurrencySelection(Party party, string statedPartyCurrency)
        {
            Party = party;
            StatedPartyCurrency = statedPartyCurrency;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PartyTerminationCurrencySelection> MetaData => metaData;
        
        /// <summary>
        /// The elective party.
        /// </summary>
        public Party Party { get; }
        
        /// <summary>
        /// Specifies termination Currency.
        /// </summary>
        public string StatedPartyCurrency { get; }
    }
    
    /// <summary>
    /// Type which contains pass through payments.
    /// </summary>
    public class PassThrough : AbstractRosettaModelObject<PassThrough>
    {
        private static readonly IRosettaMetaData<PassThrough> metaData = new PassThroughMeta();
        
        [JsonConstructor]
        public PassThrough(IEnumerable<PassThroughItem> passThroughItem)
        {
            PassThroughItem = passThroughItem;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PassThrough> MetaData => metaData;
        
        /// <summary>
        /// One to many pass through payment items.
        /// </summary>
        public IEnumerable<PassThroughItem> PassThroughItem { get; }
    }
    
    /// <summary>
    /// Class to represent a single pass through payment.
    /// </summary>
    public class PassThroughItem : AbstractRosettaModelObject<PassThroughItem>
    {
        private static readonly IRosettaMetaData<PassThroughItem> metaData = new PassThroughItemMeta();
        
        [JsonConstructor]
        public PassThroughItem(PayerReceiver payerReceiver, decimal passThroughPercentage)
        {
            PayerReceiver = payerReceiver;
            PassThroughPercentage = passThroughPercentage;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PassThroughItem> MetaData => metaData;
        
        /// <summary>
        /// This attribute doesn&apos;t exists in the FpML construct, which makes use of the PayerReceiver.model group.
        /// </summary>
        public PayerReceiver PayerReceiver { get; }
        
        /// <summary>
        /// Percentage of payments from the underlier which are passed through.
        /// </summary>
        public decimal PassThroughPercentage { get; }
    }
    
    /// <summary>
    /// Specifies the parties responsible for making and receiving payments defined by this structure.
    /// </summary>
    public class PayerReceiver : AbstractRosettaModelObject<PayerReceiver>, IPayerReceiver
    {
        private static readonly IRosettaMetaData<PayerReceiver> metaData = new PayerReceiverMeta();
        
        [JsonConstructor]
        public PayerReceiver(Enums.CounterpartyRole payer, Enums.CounterpartyRole receiver)
        {
            Payer = payer;
            Receiver = receiver;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PayerReceiver> MetaData => metaData;
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Payer { get; }
        
        /// <inheritdoc/>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.CounterpartyRole Receiver { get; }
    }
    
    /// <summary>
    /// A data defining:  the adjusted payment date and associated calculation period parameters required to calculate the actual or projected payment amount. This data forms:  part of the cashflow representation of a swap stream.
    /// </summary>
    public class PaymentCalculationPeriod : AbstractRosettaModelObject<PaymentCalculationPeriod>
    {
        private static readonly IRosettaMetaData<PaymentCalculationPeriod> metaData = new PaymentCalculationPeriodMeta();
        
        [JsonConstructor]
        public PaymentCalculationPeriod(LocalDate? unadjustedPaymentDate, LocalDate? adjustedPaymentDate, IEnumerable<CalculationPeriod> calculationPeriod, Money? fixedPaymentAmount, decimal? discountFactor, Money? forecastPaymentAmount, Money? presentValueAmount, _MetaFields? meta)
        {
            UnadjustedPaymentDate = unadjustedPaymentDate;
            AdjustedPaymentDate = adjustedPaymentDate;
            CalculationPeriod = calculationPeriod;
            FixedPaymentAmount = fixedPaymentAmount;
            DiscountFactor = discountFactor;
            ForecastPaymentAmount = forecastPaymentAmount;
            PresentValueAmount = presentValueAmount;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentCalculationPeriod> MetaData => metaData;
        
        /// <summary>
        /// The unadjusted payment date.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? UnadjustedPaymentDate { get; }
        
        /// <summary>
        /// The adjusted payment date. This date should already be adjusted for any applicable business day convention. This component is not intended for use in trade confirmation but may be specified to allow the fee structure to also serve as a cashflow type component.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? AdjustedPaymentDate { get; }
        
        /// <summary>
        /// The parameters used in the calculation of a fixed or floating rate calculation period amount. A list of calculation period elements may be ordered in the document by ascending start date. An FpML document which contains an unordered list of calculation periods is still regarded as a conformant document.
        /// </summary>
        public IEnumerable<CalculationPeriod> CalculationPeriod { get; }
        
        /// <summary>
        /// A known fixed payment amount.
        /// </summary>
        public Money? FixedPaymentAmount { get; }
        
        /// <summary>
        /// A decimal value representing the discount factor used to calculate the present value of cash flow.
        /// </summary>
        public decimal? DiscountFactor { get; }
        
        /// <summary>
        /// A monetary amount representing the forecast of the future value of the payment.
        /// </summary>
        public Money? ForecastPaymentAmount { get; }
        
        /// <summary>
        /// A monetary amount representing the present value of the forecast payment.
        /// </summary>
        public Money? PresentValueAmount { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// The payment dates when specified as relative to a set of dates specified somewhere else in the instance document/transaction, e.g. the valuation dates as typically the case for equity swaps, or when specified as a calculation period schedule.
    /// </summary>
    public class PaymentDateSchedule : AbstractRosettaModelObject<PaymentDateSchedule>
    {
        private static readonly IRosettaMetaData<PaymentDateSchedule> metaData = new PaymentDateScheduleMeta();
        
        [JsonConstructor]
        public PaymentDateSchedule(IEnumerable<AdjustableRelativeOrPeriodicDates> interimPaymentDates, AdjustableOrRelativeDate? finalPaymentDate)
        {
            InterimPaymentDates = interimPaymentDates;
            FinalPaymentDate = finalPaymentDate;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentDateSchedule> MetaData => metaData;
        
        public IEnumerable<AdjustableRelativeOrPeriodicDates> InterimPaymentDates { get; }
        
        /// <summary>
        /// The last payment when specified as an adjustable or relative date, as in the FpML total return construct.
        /// </summary>
        public AdjustableOrRelativeDate? FinalPaymentDate { get; }
    }
    
    /// <summary>
    /// Specifies the parameters to generate the payment date schedule, either through a parametric representation or by reference to specified dates.
    /// </summary>
    public class PaymentDates : AbstractRosettaModelObject<PaymentDates>
    {
        private static readonly IRosettaMetaData<PaymentDates> metaData = new PaymentDatesMeta();
        
        [JsonConstructor]
        public PaymentDates(Frequency? paymentFrequency, LocalDate? firstPaymentDate, LocalDate? lastRegularPaymentDate, PaymentDateSchedule? paymentDateSchedule, Enums.PayRelativeTo? payRelativeTo, Offset? paymentDaysOffset, BusinessDayAdjustments? paymentDatesAdjustments, _MetaFields? meta)
        {
            PaymentFrequency = paymentFrequency;
            FirstPaymentDate = firstPaymentDate;
            LastRegularPaymentDate = lastRegularPaymentDate;
            PaymentDateSchedule = paymentDateSchedule;
            PayRelativeTo = payRelativeTo;
            PaymentDaysOffset = paymentDaysOffset;
            PaymentDatesAdjustments = paymentDatesAdjustments;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentDates> MetaData => metaData;
        
        /// <summary>
        /// The frequency at which regular payment dates occur. If the payment frequency is equal to the frequency defined in the calculation period dates component then one calculation period contributes to each payment amount. If the payment frequency is less frequent than the frequency defined in the calculation period dates component then more than one calculation period will contribute to the payment amount. A payment frequency more frequent than the calculation period frequency or one that is not a multiple of the calculation period frequency is invalid. If the payment frequency is of value T (term), the period is defined by the effectiveDate and the terminationDate.
        /// </summary>
        public Frequency? PaymentFrequency { get; }
        
        /// <summary>
        /// The first unadjusted payment date. This day may be subject to adjustment in accordance with any business day convention specified in paymentDatesAdjustments. This element must only be included if there is an initial stub. This date will normally correspond to an unadjusted calculation period start or end date. This is true even if early or delayed payment is specified to be applicable since the actual first payment date will be the specified number of days before or after the applicable adjusted calculation period start or end date with the resulting payment date then being adjusted in accordance with any business day convention specified in paymentDatesAdjustments.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? FirstPaymentDate { get; }
        
        /// <summary>
        /// The last regular payment date when specified as a date, as in the FpML interest rate construct. FpML specifies that this date may be subject to adjustment in accordance with any business day convention specified in the paymentDatesAdjustments attribute.
        /// </summary>
        [JsonConverter(typeof(Rosetta.Lib.LocalDateConverter))]
        public LocalDate? LastRegularPaymentDate { get; }
        
        /// <summary>
        /// The payment dates when specified as relative to a set of dates specified somewhere else in the instance document/transaction, e.g. the valuation dates as typically the case for equity swaps, or when specified as a calculation period schedule.
        /// </summary>
        public PaymentDateSchedule? PaymentDateSchedule { get; }
        
        /// <summary>
        /// Specifies whether the payments occur relative to each adjusted calculation period start date or end date, each reset date, valuation date or the last pricing date. Calculation period start date means relative to the start of the first calculation period contributing to a given payment. Similarly, calculation period end date means the end of the last calculation period contributing to a given payment. The valuation date is applicable for Brazilian-CDI and equity swaps.
        /// </summary>
        [JsonConverter(typeof(StringEnumConverter))]
        public Enums.PayRelativeTo? PayRelativeTo { get; }
        
        /// <summary>
        /// If early payment or delayed payment is required, specifies the number of days offset that the payment occurs relative to what would otherwise be the unadjusted payment date. The offset can be specified in terms of either calendar or business days. Even in the case of a calendar days offset, the resulting payment date, adjusted for the specified calendar days offset, will still be adjusted in accordance with the specified payment dates adjustments. This element should only be included if early or delayed payment is applicable, i.e. if the periodMultiplier element value is not equal to zero. An early payment would be indicated by a negative periodMultiplier element value and a delayed payment (or payment lag) would be indicated by a positive periodMultiplier element value.
        /// </summary>
        public Offset? PaymentDaysOffset { get; }
        
        /// <summary>
        /// The definition of the business day convention and financial business centers used for adjusting the payment date if it would otherwise fall on a day that is not a business day in the specified business center.
        /// </summary>
        public BusinessDayAdjustments? PaymentDatesAdjustments { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    public class PaymentDetail : AbstractRosettaModelObject<PaymentDetail>
    {
        private static readonly IRosettaMetaData<PaymentDetail> metaData = new PaymentDetailMeta();
        
        [JsonConstructor]
        public PaymentDetail(AdjustableOrRelativeDate? paymentDate, PaymentRule paymentRule, Money? paymentAmount, _MetaFields? meta)
        {
            PaymentDate = paymentDate;
            PaymentRule = paymentRule;
            PaymentAmount = paymentAmount;
            Meta = meta;
        }
        
        /// <inheritdoc />
        [JsonIgnore]
        public override IRosettaMetaData<PaymentDetail> MetaData => metaData;
        
        public AdjustableOrRelativeDate? PaymentDate { get; }
        
        /// <summary>
        /// The calculation rule.
        /// </summary>
        public PaymentRule PaymentRule { get; }
        
        /// <summary>
        /// A fixed payment amount.
        /// </summary>
        public Money? PaymentAmount { get; }
        
        public _MetaFields? Meta { get; }
    }
    
    /// <summary>
    /// This class corresponds to the FpML PaymentDiscounting.model group for representing the discounting elements that can be associated with a payment.
    /// </summary>
    public class PaymentDiscoun