/*
 * Decompiled with CFR 0.152.
 */
package fpml.custom.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.consolidated.shared.Exercise;
import fpml.custom.ExerciseChoice;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ToExerciseChoiceDefault.class)
public abstract class ToExerciseChoice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public ExerciseChoice evaluate(Exercise exercise) {
        ExerciseChoice exerciseChoice;
        ExerciseChoice.ExerciseChoiceBuilder exerciseChoiceBuilder = this.doEvaluate(exercise);
        if (exerciseChoiceBuilder == null) {
            exerciseChoice = null;
        } else {
            exerciseChoice = exerciseChoiceBuilder.build();
            this.objectValidator.validate(ExerciseChoice.class, (RosettaModelObject)exerciseChoice);
        }
        return exerciseChoice;
    }

    protected abstract ExerciseChoice.ExerciseChoiceBuilder doEvaluate(Exercise var1);

    public static class ToExerciseChoiceDefault
    extends ToExerciseChoice {
        @Override
        protected ExerciseChoice.ExerciseChoiceBuilder doEvaluate(Exercise exercise) {
            ExerciseChoice.ExerciseChoiceBuilder exerciseChoice = ExerciseChoice.builder();
            return this.assignOutput(exerciseChoice, exercise);
        }

        protected ExerciseChoice.ExerciseChoiceBuilder assignOutput(ExerciseChoice.ExerciseChoiceBuilder exerciseChoice, Exercise exercise) {
            return Optional.ofNullable(exerciseChoice).map(o -> o.prune()).orElse(null);
        }
    }
}

