/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation.fpmlreporting;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.PartyTradeIdentifier;
import fpml.consolidated.shared.RelatedParty;
import fpml.consolidated.valuation.fpmlreporting.meta.TradeValuationItemSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeValuationItemSequence", builder=TradeValuationItemSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="TradeValuationItemSequence", model="fpml", builder=TradeValuationItemSequenceBuilderImpl.class, version="1.1.0")
public interface TradeValuationItemSequence
extends RosettaModelObject {
    public static final TradeValuationItemSequenceMeta metaData = new TradeValuationItemSequenceMeta();

    public List<? extends PartyTradeIdentifier> getPartyTradeIdentifier();

    public List<? extends RelatedParty> getRelatedParty();

    public TradeValuationItemSequence build();

    public TradeValuationItemSequenceBuilder toBuilder();

    public static TradeValuationItemSequenceBuilder builder() {
        return new TradeValuationItemSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeValuationItemSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeValuationItemSequence> getType() {
        return TradeValuationItemSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.class, this.getRelatedParty(), new AttributeMeta[0]);
    }

    public static class TradeValuationItemSequenceBuilderImpl
    implements TradeValuationItemSequenceBuilder {
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> partyTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected List<RelatedParty.RelatedPartyBuilder> relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier(int index) {
            if (this.partyTradeIdentifier == null) {
                this.partyTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.partyTradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newPartyTradeIdentifier = PartyTradeIdentifier.builder();
                return newPartyTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int index) {
            if (this.relatedParty == null) {
                this.relatedParty = new ArrayList<RelatedParty.RelatedPartyBuilder>();
            }
            return (RelatedParty.RelatedPartyBuilder)this.getIndex(this.relatedParty, index, () -> {
                RelatedParty.RelatedPartyBuilder newRelatedParty = RelatedParty.builder();
                return newRelatedParty;
            });
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public TradeValuationItemSequenceBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier) {
            if (_partyTradeIdentifier != null) {
                this.partyTradeIdentifier.add(_partyTradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeValuationItemSequenceBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier, int idx) {
            this.getIndex(this.partyTradeIdentifier, idx, () -> _partyTradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeValuationItemSequenceBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            if (partyTradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : partyTradeIdentifiers) {
                    this.partyTradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyTradeIdentifier")
        public TradeValuationItemSequenceBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            this.partyTradeIdentifier = partyTradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)partyTradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public TradeValuationItemSequenceBuilder addRelatedParty(RelatedParty _relatedParty) {
            if (_relatedParty != null) {
                this.relatedParty.add(_relatedParty.toBuilder());
            }
            return this;
        }

        @Override
        public TradeValuationItemSequenceBuilder addRelatedParty(RelatedParty _relatedParty, int idx) {
            this.getIndex(this.relatedParty, idx, () -> _relatedParty.toBuilder());
            return this;
        }

        @Override
        public TradeValuationItemSequenceBuilder addRelatedParty(List<? extends RelatedParty> relatedPartys) {
            if (relatedPartys != null) {
                for (RelatedParty relatedParty : relatedPartys) {
                    this.relatedParty.add(relatedParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedParty")
        public TradeValuationItemSequenceBuilder setRelatedParty(List<? extends RelatedParty> relatedPartys) {
            this.relatedParty = relatedPartys == null ? new ArrayList<RelatedParty.RelatedPartyBuilder>() : (List)relatedPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TradeValuationItemSequence build() {
            return new TradeValuationItemSequenceImpl(this);
        }

        @Override
        public TradeValuationItemSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeValuationItemSequenceBuilder prune() {
            this.partyTradeIdentifier = this.partyTradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.relatedParty = this.relatedParty.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyTradeIdentifier() != null && this.getPartyTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getRelatedParty() != null && this.getRelatedParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TradeValuationItemSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeValuationItemSequenceBuilder o = (TradeValuationItemSequenceBuilder)other;
            merger.mergeRosetta(this.getPartyTradeIdentifier(), o.getPartyTradeIdentifier(), this::getOrCreatePartyTradeIdentifier);
            merger.mergeRosetta(this.getRelatedParty(), o.getRelatedParty(), this::getOrCreateRelatedParty);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeValuationItemSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedParty, _that.getRelatedParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeValuationItemSequenceBuilder {partyTradeIdentifier=" + this.partyTradeIdentifier + ", relatedParty=" + this.relatedParty + '}';
        }
    }

    public static interface TradeValuationItemSequenceBuilder
    extends TradeValuationItemSequence,
    RosettaModelObjectBuilder {
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getPartyTradeIdentifier();

        public RelatedParty.RelatedPartyBuilder getOrCreateRelatedParty(int var1);

        public List<? extends RelatedParty.RelatedPartyBuilder> getRelatedParty();

        public TradeValuationItemSequenceBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1);

        public TradeValuationItemSequenceBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public TradeValuationItemSequenceBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeValuationItemSequenceBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeValuationItemSequenceBuilder addRelatedParty(RelatedParty var1);

        public TradeValuationItemSequenceBuilder addRelatedParty(RelatedParty var1, int var2);

        public TradeValuationItemSequenceBuilder addRelatedParty(List<? extends RelatedParty> var1);

        public TradeValuationItemSequenceBuilder setRelatedParty(List<? extends RelatedParty> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedParty"), processor, RelatedParty.RelatedPartyBuilder.class, this.getRelatedParty(), new AttributeMeta[0]);
        }

        public TradeValuationItemSequenceBuilder prune();
    }

    public static class TradeValuationItemSequenceImpl
    implements TradeValuationItemSequence {
        private final List<? extends PartyTradeIdentifier> partyTradeIdentifier;
        private final List<? extends RelatedParty> relatedParty;

        protected TradeValuationItemSequenceImpl(TradeValuationItemSequenceBuilder builder) {
            this.partyTradeIdentifier = Optional.ofNullable(builder.getPartyTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.relatedParty = Optional.ofNullable(builder.getRelatedParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier> getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="relatedParty")
        @RuneAttribute(value="relatedParty")
        public List<? extends RelatedParty> getRelatedParty() {
            return this.relatedParty;
        }

        @Override
        public TradeValuationItemSequence build() {
            return this;
        }

        @Override
        public TradeValuationItemSequenceBuilder toBuilder() {
            TradeValuationItemSequenceBuilder builder = TradeValuationItemSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeValuationItemSequenceBuilder builder) {
            Optional.ofNullable(this.getPartyTradeIdentifier()).ifPresent(builder::setPartyTradeIdentifier);
            Optional.ofNullable(this.getRelatedParty()).ifPresent(builder::setRelatedParty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeValuationItemSequence _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            return ListEquals.listEquals(this.relatedParty, _that.getRelatedParty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.relatedParty != null ? this.relatedParty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeValuationItemSequence {partyTradeIdentifier=" + this.partyTradeIdentifier + ", relatedParty=" + this.relatedParty + '}';
        }
    }
}

