/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.valuation.fpmlreporting;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.shared.AssetClass;
import fpml.consolidated.valuation.fpmlreporting.meta.ReportContentsSequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReportContentsSequence", builder=ReportContentsSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="ReportContentsSequence", model="fpml", builder=ReportContentsSequenceBuilderImpl.class, version="1.1.0")
public interface ReportContentsSequence
extends RosettaModelObject {
    public static final ReportContentsSequenceMeta metaData = new ReportContentsSequenceMeta();

    public AssetClass getPrimaryAssetClass();

    public List<? extends AssetClass> getSecondaryAssetClass();

    public ReportContentsSequence build();

    public ReportContentsSequenceBuilder toBuilder();

    public static ReportContentsSequenceBuilder builder() {
        return new ReportContentsSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportContentsSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportContentsSequence> getType() {
        return ReportContentsSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("primaryAssetClass"), processor, AssetClass.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("secondaryAssetClass"), processor, AssetClass.class, this.getSecondaryAssetClass(), new AttributeMeta[0]);
    }

    public static class ReportContentsSequenceBuilderImpl
    implements ReportContentsSequenceBuilder {
        protected AssetClass.AssetClassBuilder primaryAssetClass;
        protected List<AssetClass.AssetClassBuilder> secondaryAssetClass = new ArrayList<AssetClass.AssetClassBuilder>();

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public AssetClass.AssetClassBuilder getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        public AssetClass.AssetClassBuilder getOrCreatePrimaryAssetClass() {
            AssetClass.AssetClassBuilder result = this.primaryAssetClass != null ? this.primaryAssetClass : (this.primaryAssetClass = AssetClass.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public List<? extends AssetClass.AssetClassBuilder> getSecondaryAssetClass() {
            return this.secondaryAssetClass;
        }

        @Override
        public AssetClass.AssetClassBuilder getOrCreateSecondaryAssetClass(int index) {
            if (this.secondaryAssetClass == null) {
                this.secondaryAssetClass = new ArrayList<AssetClass.AssetClassBuilder>();
            }
            return (AssetClass.AssetClassBuilder)this.getIndex(this.secondaryAssetClass, index, () -> {
                AssetClass.AssetClassBuilder newSecondaryAssetClass = AssetClass.builder();
                return newSecondaryAssetClass;
            });
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public ReportContentsSequenceBuilder setPrimaryAssetClass(AssetClass _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public ReportContentsSequenceBuilder addSecondaryAssetClass(AssetClass _secondaryAssetClass) {
            if (_secondaryAssetClass != null) {
                this.secondaryAssetClass.add(_secondaryAssetClass.toBuilder());
            }
            return this;
        }

        @Override
        public ReportContentsSequenceBuilder addSecondaryAssetClass(AssetClass _secondaryAssetClass, int idx) {
            this.getIndex(this.secondaryAssetClass, idx, () -> _secondaryAssetClass.toBuilder());
            return this;
        }

        @Override
        public ReportContentsSequenceBuilder addSecondaryAssetClass(List<? extends AssetClass> secondaryAssetClasss) {
            if (secondaryAssetClasss != null) {
                for (AssetClass assetClass : secondaryAssetClasss) {
                    this.secondaryAssetClass.add(assetClass.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="secondaryAssetClass")
        public ReportContentsSequenceBuilder setSecondaryAssetClass(List<? extends AssetClass> secondaryAssetClasss) {
            this.secondaryAssetClass = secondaryAssetClasss == null ? new ArrayList<AssetClass.AssetClassBuilder>() : (List)secondaryAssetClasss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ReportContentsSequence build() {
            return new ReportContentsSequenceImpl(this);
        }

        @Override
        public ReportContentsSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportContentsSequenceBuilder prune() {
            if (this.primaryAssetClass != null && !this.primaryAssetClass.prune().hasData()) {
                this.primaryAssetClass = null;
            }
            this.secondaryAssetClass = this.secondaryAssetClass.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPrimaryAssetClass() != null && this.getPrimaryAssetClass().hasData()) {
                return true;
            }
            return this.getSecondaryAssetClass() != null && this.getSecondaryAssetClass().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ReportContentsSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReportContentsSequenceBuilder o = (ReportContentsSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)o.getPrimaryAssetClass(), this::setPrimaryAssetClass);
            merger.mergeRosetta(this.getSecondaryAssetClass(), o.getSecondaryAssetClass(), this::getOrCreateSecondaryAssetClass);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportContentsSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            return ListEquals.listEquals(this.secondaryAssetClass, _that.getSecondaryAssetClass());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.secondaryAssetClass != null ? this.secondaryAssetClass.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportContentsSequenceBuilder {primaryAssetClass=" + this.primaryAssetClass + ", secondaryAssetClass=" + this.secondaryAssetClass + '}';
        }
    }

    public static interface ReportContentsSequenceBuilder
    extends ReportContentsSequence,
    RosettaModelObjectBuilder {
        public AssetClass.AssetClassBuilder getOrCreatePrimaryAssetClass();

        @Override
        public AssetClass.AssetClassBuilder getPrimaryAssetClass();

        public AssetClass.AssetClassBuilder getOrCreateSecondaryAssetClass(int var1);

        public List<? extends AssetClass.AssetClassBuilder> getSecondaryAssetClass();

        public ReportContentsSequenceBuilder setPrimaryAssetClass(AssetClass var1);

        public ReportContentsSequenceBuilder addSecondaryAssetClass(AssetClass var1);

        public ReportContentsSequenceBuilder addSecondaryAssetClass(AssetClass var1, int var2);

        public ReportContentsSequenceBuilder addSecondaryAssetClass(List<? extends AssetClass> var1);

        public ReportContentsSequenceBuilder setSecondaryAssetClass(List<? extends AssetClass> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("primaryAssetClass"), processor, AssetClass.AssetClassBuilder.class, this.getPrimaryAssetClass(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("secondaryAssetClass"), processor, AssetClass.AssetClassBuilder.class, this.getSecondaryAssetClass(), new AttributeMeta[0]);
        }

        public ReportContentsSequenceBuilder prune();
    }

    public static class ReportContentsSequenceImpl
    implements ReportContentsSequence {
        private final AssetClass primaryAssetClass;
        private final List<? extends AssetClass> secondaryAssetClass;

        protected ReportContentsSequenceImpl(ReportContentsSequenceBuilder builder) {
            this.primaryAssetClass = Optional.ofNullable(builder.getPrimaryAssetClass()).map(f -> f.build()).orElse(null);
            this.secondaryAssetClass = Optional.ofNullable(builder.getSecondaryAssetClass()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass")
        @RuneAttribute(value="primaryAssetClass")
        public AssetClass getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="secondaryAssetClass")
        @RuneAttribute(value="secondaryAssetClass")
        public List<? extends AssetClass> getSecondaryAssetClass() {
            return this.secondaryAssetClass;
        }

        @Override
        public ReportContentsSequence build() {
            return this;
        }

        @Override
        public ReportContentsSequenceBuilder toBuilder() {
            ReportContentsSequenceBuilder builder = ReportContentsSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportContentsSequenceBuilder builder) {
            Optional.ofNullable(this.getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
            Optional.ofNullable(this.getSecondaryAssetClass()).ifPresent(builder::setSecondaryAssetClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReportContentsSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            return ListEquals.listEquals(this.secondaryAssetClass, _that.getSecondaryAssetClass());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.hashCode() : 0);
            _result = 31 * _result + (this.secondaryAssetClass != null ? this.secondaryAssetClass.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReportContentsSequence {primaryAssetClass=" + this.primaryAssetClass + ", secondaryAssetClass=" + this.secondaryAssetClass + '}';
        }
    }
}

