/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.shared.ProductModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ProductModelChoice")
@ImplementedBy(value=Default.class)
public interface ProductModelChoice
extends Validator<ProductModel> {
    public static final String NAME = "ProductModelChoice";
    public static final String DEFINITION = "required choice productModelSequence, productId";

    public static class NoOp
    implements ProductModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ProductModel productModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ProductModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ProductModel productModel) {
            ComparisonResult result = this.executeDataRule(productModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ProductModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductModel", (RosettaPath)path, (String)ProductModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ProductModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductModel", (RosettaPath)path, (String)ProductModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ProductModel productModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)productModel), Arrays.asList("productModelSequence", "productId"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

