/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.shared.BusinessCenter;
import fpml.consolidated.shared.meta.BusinessCenterTimeMeta;
import java.time.LocalTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BusinessCenterTime", builder=BusinessCenterTimeBuilderImpl.class, version="1.1.0")
@RuneDataType(value="BusinessCenterTime", model="fpml", builder=BusinessCenterTimeBuilderImpl.class, version="1.1.0")
public interface BusinessCenterTime
extends RosettaModelObject {
    public static final BusinessCenterTimeMeta metaData = new BusinessCenterTimeMeta();

    public LocalTime getHourMinuteTime();

    public BusinessCenter getBusinessCenter();

    public BusinessCenterTime build();

    public BusinessCenterTimeBuilder toBuilder();

    public static BusinessCenterTimeBuilder builder() {
        return new BusinessCenterTimeBuilderImpl();
    }

    default public RosettaMetaData<? extends BusinessCenterTime> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BusinessCenterTime> getType() {
        return BusinessCenterTime.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("hourMinuteTime"), LocalTime.class, (Object)this.getHourMinuteTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessCenter"), processor, BusinessCenter.class, this.getBusinessCenter(), new AttributeMeta[0]);
    }

    public static class BusinessCenterTimeBuilderImpl
    implements BusinessCenterTimeBuilder {
        protected LocalTime hourMinuteTime;
        protected BusinessCenter.BusinessCenterBuilder businessCenter;

        @Override
        @RosettaAttribute(value="hourMinuteTime", isRequired=true)
        @RuneAttribute(value="hourMinuteTime", isRequired=true)
        public LocalTime getHourMinuteTime() {
            return this.hourMinuteTime;
        }

        @Override
        @RosettaAttribute(value="businessCenter", isRequired=true)
        @RuneAttribute(value="businessCenter", isRequired=true)
        public BusinessCenter.BusinessCenterBuilder getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        public BusinessCenter.BusinessCenterBuilder getOrCreateBusinessCenter() {
            BusinessCenter.BusinessCenterBuilder result = this.businessCenter != null ? this.businessCenter : (this.businessCenter = BusinessCenter.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="hourMinuteTime", isRequired=true)
        @RuneAttribute(value="hourMinuteTime", isRequired=true)
        public BusinessCenterTimeBuilder setHourMinuteTime(LocalTime _hourMinuteTime) {
            this.hourMinuteTime = _hourMinuteTime == null ? null : _hourMinuteTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessCenter", isRequired=true)
        @RuneAttribute(value="businessCenter", isRequired=true)
        public BusinessCenterTimeBuilder setBusinessCenter(BusinessCenter _businessCenter) {
            this.businessCenter = _businessCenter == null ? null : _businessCenter.toBuilder();
            return this;
        }

        @Override
        public BusinessCenterTime build() {
            return new BusinessCenterTimeImpl(this);
        }

        @Override
        public BusinessCenterTimeBuilder toBuilder() {
            return this;
        }

        @Override
        public BusinessCenterTimeBuilder prune() {
            if (this.businessCenter != null && !this.businessCenter.prune().hasData()) {
                this.businessCenter = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getHourMinuteTime() != null) {
                return true;
            }
            return this.getBusinessCenter() != null && this.getBusinessCenter().hasData();
        }

        public BusinessCenterTimeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BusinessCenterTimeBuilder o = (BusinessCenterTimeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBusinessCenter(), (RosettaModelObjectBuilder)o.getBusinessCenter(), this::setBusinessCenter);
            merger.mergeBasic((Object)this.getHourMinuteTime(), (Object)o.getHourMinuteTime(), this::setHourMinuteTime, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BusinessCenterTime _that = this.getType().cast(o);
            if (!Objects.equals(this.hourMinuteTime, _that.getHourMinuteTime())) {
                return false;
            }
            return Objects.equals(this.businessCenter, _that.getBusinessCenter());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.hourMinuteTime != null ? this.hourMinuteTime.hashCode() : 0);
            _result = 31 * _result + (this.businessCenter != null ? this.businessCenter.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BusinessCenterTimeBuilder {hourMinuteTime=" + this.hourMinuteTime + ", businessCenter=" + this.businessCenter + '}';
        }
    }

    public static interface BusinessCenterTimeBuilder
    extends BusinessCenterTime,
    RosettaModelObjectBuilder {
        public BusinessCenter.BusinessCenterBuilder getOrCreateBusinessCenter();

        @Override
        public BusinessCenter.BusinessCenterBuilder getBusinessCenter();

        public BusinessCenterTimeBuilder setHourMinuteTime(LocalTime var1);

        public BusinessCenterTimeBuilder setBusinessCenter(BusinessCenter var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("hourMinuteTime"), LocalTime.class, (Object)this.getHourMinuteTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessCenter"), processor, BusinessCenter.BusinessCenterBuilder.class, this.getBusinessCenter(), new AttributeMeta[0]);
        }

        public BusinessCenterTimeBuilder prune();
    }

    public static class BusinessCenterTimeImpl
    implements BusinessCenterTime {
        private final LocalTime hourMinuteTime;
        private final BusinessCenter businessCenter;

        protected BusinessCenterTimeImpl(BusinessCenterTimeBuilder builder) {
            this.hourMinuteTime = builder.getHourMinuteTime();
            this.businessCenter = Optional.ofNullable(builder.getBusinessCenter()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="hourMinuteTime", isRequired=true)
        @RuneAttribute(value="hourMinuteTime", isRequired=true)
        public LocalTime getHourMinuteTime() {
            return this.hourMinuteTime;
        }

        @Override
        @RosettaAttribute(value="businessCenter", isRequired=true)
        @RuneAttribute(value="businessCenter", isRequired=true)
        public BusinessCenter getBusinessCenter() {
            return this.businessCenter;
        }

        @Override
        public BusinessCenterTime build() {
            return this;
        }

        @Override
        public BusinessCenterTimeBuilder toBuilder() {
            BusinessCenterTimeBuilder builder = BusinessCenterTime.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BusinessCenterTimeBuilder builder) {
            Optional.ofNullable(this.getHourMinuteTime()).ifPresent(builder::setHourMinuteTime);
            Optional.ofNullable(this.getBusinessCenter()).ifPresent(builder::setBusinessCenter);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BusinessCenterTime _that = this.getType().cast(o);
            if (!Objects.equals(this.hourMinuteTime, _that.getHourMinuteTime())) {
                return false;
            }
            return Objects.equals(this.businessCenter, _that.getBusinessCenter());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.hourMinuteTime != null ? this.hourMinuteTime.hashCode() : 0);
            _result = 31 * _result + (this.businessCenter != null ? this.businessCenter.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BusinessCenterTime {hourMinuteTime=" + this.hourMinuteTime + ", businessCenter=" + this.businessCenter + '}';
        }
    }
}

