/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.repo;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.repo.CollateralValuation;
import fpml.consolidated.repo.DeliveryMethod;
import fpml.consolidated.repo.meta.RepoFarLegSequenceMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RepoFarLegSequence", builder=RepoFarLegSequenceBuilderImpl.class, version="1.1.0")
@RuneDataType(value="RepoFarLegSequence", model="fpml", builder=RepoFarLegSequenceBuilderImpl.class, version="1.1.0")
public interface RepoFarLegSequence
extends RosettaModelObject {
    public static final RepoFarLegSequenceMeta metaData = new RepoFarLegSequenceMeta();

    public DeliveryMethod getDeliveryMethod();

    public AdjustableOrRelativeDate getDeliveryDate();

    public List<? extends CollateralValuation> getCollateral();

    public RepoFarLegSequence build();

    public RepoFarLegSequenceBuilder toBuilder();

    public static RepoFarLegSequenceBuilder builder() {
        return new RepoFarLegSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends RepoFarLegSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RepoFarLegSequence> getType() {
        return RepoFarLegSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("deliveryMethod"), processor, DeliveryMethod.class, this.getDeliveryMethod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryDate"), processor, AdjustableOrRelativeDate.class, this.getDeliveryDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateral"), processor, CollateralValuation.class, this.getCollateral(), new AttributeMeta[0]);
    }

    public static class RepoFarLegSequenceBuilderImpl
    implements RepoFarLegSequenceBuilder {
        protected DeliveryMethod.DeliveryMethodBuilder deliveryMethod;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder deliveryDate;
        protected List<CollateralValuation.CollateralValuationBuilder> collateral = new ArrayList<CollateralValuation.CollateralValuationBuilder>();

        @Override
        @RosettaAttribute(value="deliveryMethod")
        @RuneAttribute(value="deliveryMethod")
        public DeliveryMethod.DeliveryMethodBuilder getDeliveryMethod() {
            return this.deliveryMethod;
        }

        @Override
        public DeliveryMethod.DeliveryMethodBuilder getOrCreateDeliveryMethod() {
            DeliveryMethod.DeliveryMethodBuilder result = this.deliveryMethod != null ? this.deliveryMethod : (this.deliveryMethod = DeliveryMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryDate")
        @RuneAttribute(value="deliveryDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getDeliveryDate() {
            return this.deliveryDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateDeliveryDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.deliveryDate != null ? this.deliveryDate : (this.deliveryDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public List<? extends CollateralValuation.CollateralValuationBuilder> getCollateral() {
            return this.collateral;
        }

        @Override
        public CollateralValuation.CollateralValuationBuilder getOrCreateCollateral(int index) {
            if (this.collateral == null) {
                this.collateral = new ArrayList<CollateralValuation.CollateralValuationBuilder>();
            }
            return (CollateralValuation.CollateralValuationBuilder)this.getIndex(this.collateral, index, () -> {
                CollateralValuation.CollateralValuationBuilder newCollateral = CollateralValuation.builder();
                return newCollateral;
            });
        }

        @Override
        @RosettaAttribute(value="deliveryMethod")
        @RuneAttribute(value="deliveryMethod")
        public RepoFarLegSequenceBuilder setDeliveryMethod(DeliveryMethod _deliveryMethod) {
            this.deliveryMethod = _deliveryMethod == null ? null : _deliveryMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryDate")
        @RuneAttribute(value="deliveryDate")
        public RepoFarLegSequenceBuilder setDeliveryDate(AdjustableOrRelativeDate _deliveryDate) {
            this.deliveryDate = _deliveryDate == null ? null : _deliveryDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public RepoFarLegSequenceBuilder addCollateral(CollateralValuation _collateral) {
            if (_collateral != null) {
                this.collateral.add(_collateral.toBuilder());
            }
            return this;
        }

        @Override
        public RepoFarLegSequenceBuilder addCollateral(CollateralValuation _collateral, int idx) {
            this.getIndex(this.collateral, idx, () -> _collateral.toBuilder());
            return this;
        }

        @Override
        public RepoFarLegSequenceBuilder addCollateral(List<? extends CollateralValuation> collaterals) {
            if (collaterals != null) {
                for (CollateralValuation collateralValuation : collaterals) {
                    this.collateral.add(collateralValuation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateral")
        public RepoFarLegSequenceBuilder setCollateral(List<? extends CollateralValuation> collaterals) {
            this.collateral = collaterals == null ? new ArrayList<CollateralValuation.CollateralValuationBuilder>() : (List)collaterals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RepoFarLegSequence build() {
            return new RepoFarLegSequenceImpl(this);
        }

        @Override
        public RepoFarLegSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public RepoFarLegSequenceBuilder prune() {
            if (this.deliveryMethod != null && !this.deliveryMethod.prune().hasData()) {
                this.deliveryMethod = null;
            }
            if (this.deliveryDate != null && !this.deliveryDate.prune().hasData()) {
                this.deliveryDate = null;
            }
            this.collateral = this.collateral.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getDeliveryMethod() != null && this.getDeliveryMethod().hasData()) {
                return true;
            }
            if (this.getDeliveryDate() != null && this.getDeliveryDate().hasData()) {
                return true;
            }
            return this.getCollateral() != null && this.getCollateral().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public RepoFarLegSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RepoFarLegSequenceBuilder o = (RepoFarLegSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryMethod(), (RosettaModelObjectBuilder)o.getDeliveryMethod(), this::setDeliveryMethod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryDate(), (RosettaModelObjectBuilder)o.getDeliveryDate(), this::setDeliveryDate);
            merger.mergeRosetta(this.getCollateral(), o.getCollateral(), this::getOrCreateCollateral);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RepoFarLegSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryMethod, _that.getDeliveryMethod())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDate, _that.getDeliveryDate())) {
                return false;
            }
            return ListEquals.listEquals(this.collateral, _that.getCollateral());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryMethod != null ? this.deliveryMethod.hashCode() : 0);
            _result = 31 * _result + (this.deliveryDate != null ? this.deliveryDate.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepoFarLegSequenceBuilder {deliveryMethod=" + this.deliveryMethod + ", deliveryDate=" + this.deliveryDate + ", collateral=" + this.collateral + '}';
        }
    }

    public static interface RepoFarLegSequenceBuilder
    extends RepoFarLegSequence,
    RosettaModelObjectBuilder {
        public DeliveryMethod.DeliveryMethodBuilder getOrCreateDeliveryMethod();

        @Override
        public DeliveryMethod.DeliveryMethodBuilder getDeliveryMethod();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateDeliveryDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getDeliveryDate();

        public CollateralValuation.CollateralValuationBuilder getOrCreateCollateral(int var1);

        public List<? extends CollateralValuation.CollateralValuationBuilder> getCollateral();

        public RepoFarLegSequenceBuilder setDeliveryMethod(DeliveryMethod var1);

        public RepoFarLegSequenceBuilder setDeliveryDate(AdjustableOrRelativeDate var1);

        public RepoFarLegSequenceBuilder addCollateral(CollateralValuation var1);

        public RepoFarLegSequenceBuilder addCollateral(CollateralValuation var1, int var2);

        public RepoFarLegSequenceBuilder addCollateral(List<? extends CollateralValuation> var1);

        public RepoFarLegSequenceBuilder setCollateral(List<? extends CollateralValuation> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("deliveryMethod"), processor, DeliveryMethod.DeliveryMethodBuilder.class, this.getDeliveryMethod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getDeliveryDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateral"), processor, CollateralValuation.CollateralValuationBuilder.class, this.getCollateral(), new AttributeMeta[0]);
        }

        public RepoFarLegSequenceBuilder prune();
    }

    public static class RepoFarLegSequenceImpl
    implements RepoFarLegSequence {
        private final DeliveryMethod deliveryMethod;
        private final AdjustableOrRelativeDate deliveryDate;
        private final List<? extends CollateralValuation> collateral;

        protected RepoFarLegSequenceImpl(RepoFarLegSequenceBuilder builder) {
            this.deliveryMethod = Optional.ofNullable(builder.getDeliveryMethod()).map(f -> f.build()).orElse(null);
            this.deliveryDate = Optional.ofNullable(builder.getDeliveryDate()).map(f -> f.build()).orElse(null);
            this.collateral = Optional.ofNullable(builder.getCollateral()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deliveryMethod")
        @RuneAttribute(value="deliveryMethod")
        public DeliveryMethod getDeliveryMethod() {
            return this.deliveryMethod;
        }

        @Override
        @RosettaAttribute(value="deliveryDate")
        @RuneAttribute(value="deliveryDate")
        public AdjustableOrRelativeDate getDeliveryDate() {
            return this.deliveryDate;
        }

        @Override
        @RosettaAttribute(value="collateral")
        @RuneAttribute(value="collateral")
        public List<? extends CollateralValuation> getCollateral() {
            return this.collateral;
        }

        @Override
        public RepoFarLegSequence build() {
            return this;
        }

        @Override
        public RepoFarLegSequenceBuilder toBuilder() {
            RepoFarLegSequenceBuilder builder = RepoFarLegSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RepoFarLegSequenceBuilder builder) {
            Optional.ofNullable(this.getDeliveryMethod()).ifPresent(builder::setDeliveryMethod);
            Optional.ofNullable(this.getDeliveryDate()).ifPresent(builder::setDeliveryDate);
            Optional.ofNullable(this.getCollateral()).ifPresent(builder::setCollateral);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RepoFarLegSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryMethod, _that.getDeliveryMethod())) {
                return false;
            }
            if (!Objects.equals(this.deliveryDate, _that.getDeliveryDate())) {
                return false;
            }
            return ListEquals.listEquals(this.collateral, _that.getCollateral());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryMethod != null ? this.deliveryMethod.hashCode() : 0);
            _result = 31 * _result + (this.deliveryDate != null ? this.deliveryDate.hashCode() : 0);
            _result = 31 * _result + (this.collateral != null ? this.collateral.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RepoFarLegSequence {deliveryMethod=" + this.deliveryMethod + ", deliveryDate=" + this.deliveryDate + ", collateral=" + this.collateral + '}';
        }
    }
}

