/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractLoanAllocationEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanAllocationNoSettlePeriod;
import fpml.consolidated.loan.LoanAllocationReference;
import fpml.consolidated.loan.LoanAllocationSettlementDateAvailabilitySequence;
import fpml.consolidated.loan.meta.LoanAllocationSettlementDateAvailabilityMeta;
import fpml.consolidated.shared.DateList;
import fpml.consolidated.shared.PeriodModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanAllocationSettlementDateAvailability", builder=LoanAllocationSettlementDateAvailabilityBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanAllocationSettlementDateAvailability", model="fpml", builder=LoanAllocationSettlementDateAvailabilityBuilderImpl.class, version="1.1.0")
public interface LoanAllocationSettlementDateAvailability
extends AbstractLoanAllocationEvent {
    public static final LoanAllocationSettlementDateAvailabilityMeta metaData = new LoanAllocationSettlementDateAvailabilityMeta();

    public DateList getSpecificDates();

    public PeriodModel getPeriodModel();

    public ZonedDateTime getOnOrAfterDate();

    public LoanAllocationSettlementDateAvailabilitySequence getLoanAllocationSettlementDateAvailabilitySequence();

    public List<? extends LoanAllocationNoSettlePeriod> getNoSettlePeriod();

    @Override
    public LoanAllocationSettlementDateAvailability build();

    @Override
    public LoanAllocationSettlementDateAvailabilityBuilder toBuilder();

    public static LoanAllocationSettlementDateAvailabilityBuilder builder() {
        return new LoanAllocationSettlementDateAvailabilityBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanAllocationSettlementDateAvailability> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanAllocationSettlementDateAvailability> getType() {
        return LoanAllocationSettlementDateAvailability.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("allocationReference"), processor, LoanAllocationReference.class, this.getAllocationReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("specificDates"), processor, DateList.class, this.getSpecificDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("onOrAfterDate"), ZonedDateTime.class, (Object)this.getOnOrAfterDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanAllocationSettlementDateAvailabilitySequence"), processor, LoanAllocationSettlementDateAvailabilitySequence.class, this.getLoanAllocationSettlementDateAvailabilitySequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("noSettlePeriod"), processor, LoanAllocationNoSettlePeriod.class, this.getNoSettlePeriod(), new AttributeMeta[0]);
    }

    public static class LoanAllocationSettlementDateAvailabilityBuilderImpl
    extends AbstractLoanAllocationEvent.AbstractLoanAllocationEventBuilderImpl
    implements LoanAllocationSettlementDateAvailabilityBuilder {
        protected DateList.DateListBuilder specificDates;
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected ZonedDateTime onOrAfterDate;
        protected LoanAllocationSettlementDateAvailabilitySequence.LoanAllocationSettlementDateAvailabilitySequenceBuilder loanAllocationSettlementDateAvailabilitySequence;
        protected List<LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder> noSettlePeriod = new ArrayList<LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder>();

        @Override
        @RosettaAttribute(value="specificDates")
        @RuneAttribute(value="specificDates")
        public DateList.DateListBuilder getSpecificDates() {
            return this.specificDates;
        }

        @Override
        public DateList.DateListBuilder getOrCreateSpecificDates() {
            DateList.DateListBuilder result = this.specificDates != null ? this.specificDates : (this.specificDates = DateList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periodModel")
        @RuneAttribute(value="periodModel")
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="onOrAfterDate")
        @RuneAttribute(value="onOrAfterDate")
        public ZonedDateTime getOnOrAfterDate() {
            return this.onOrAfterDate;
        }

        @Override
        @RosettaAttribute(value="loanAllocationSettlementDateAvailabilitySequence")
        @RuneAttribute(value="loanAllocationSettlementDateAvailabilitySequence")
        public LoanAllocationSettlementDateAvailabilitySequence.LoanAllocationSettlementDateAvailabilitySequenceBuilder getLoanAllocationSettlementDateAvailabilitySequence() {
            return this.loanAllocationSettlementDateAvailabilitySequence;
        }

        @Override
        public LoanAllocationSettlementDateAvailabilitySequence.LoanAllocationSettlementDateAvailabilitySequenceBuilder getOrCreateLoanAllocationSettlementDateAvailabilitySequence() {
            LoanAllocationSettlementDateAvailabilitySequence.LoanAllocationSettlementDateAvailabilitySequenceBuilder result = this.loanAllocationSettlementDateAvailabilitySequence != null ? this.loanAllocationSettlementDateAvailabilitySequence : (this.loanAllocationSettlementDateAvailabilitySequence = LoanAllocationSettlementDateAvailabilitySequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="noSettlePeriod")
        @RuneAttribute(value="noSettlePeriod")
        public List<? extends LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder> getNoSettlePeriod() {
            return this.noSettlePeriod;
        }

        @Override
        public LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder getOrCreateNoSettlePeriod(int index) {
            if (this.noSettlePeriod == null) {
                this.noSettlePeriod = new ArrayList<LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder>();
            }
            return (LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder)this.getIndex(this.noSettlePeriod, index, () -> {
                LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder newNoSettlePeriod = LoanAllocationNoSettlePeriod.builder();
                return newNoSettlePeriod;
            });
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LoanAllocationSettlementDateAvailabilityBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LoanAllocationSettlementDateAvailabilityBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LoanAllocationSettlementDateAvailabilityBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LoanAllocationSettlementDateAvailabilityBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanAllocationSettlementDateAvailabilityBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="allocationReference", isRequired=true)
        @RuneAttribute(value="allocationReference", isRequired=true)
        public LoanAllocationSettlementDateAvailabilityBuilder setAllocationReference(LoanAllocationReference _allocationReference) {
            this.allocationReference = _allocationReference == null ? null : _allocationReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="specificDates")
        @RuneAttribute(value="specificDates")
        public LoanAllocationSettlementDateAvailabilityBuilder setSpecificDates(DateList _specificDates) {
            this.specificDates = _specificDates == null ? null : _specificDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel")
        @RuneAttribute(value="periodModel")
        public LoanAllocationSettlementDateAvailabilityBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onOrAfterDate")
        @RuneAttribute(value="onOrAfterDate")
        public LoanAllocationSettlementDateAvailabilityBuilder setOnOrAfterDate(ZonedDateTime _onOrAfterDate) {
            this.onOrAfterDate = _onOrAfterDate == null ? null : _onOrAfterDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="loanAllocationSettlementDateAvailabilitySequence")
        @RuneAttribute(value="loanAllocationSettlementDateAvailabilitySequence")
        public LoanAllocationSettlementDateAvailabilityBuilder setLoanAllocationSettlementDateAvailabilitySequence(LoanAllocationSettlementDateAvailabilitySequence _loanAllocationSettlementDateAvailabilitySequence) {
            this.loanAllocationSettlementDateAvailabilitySequence = _loanAllocationSettlementDateAvailabilitySequence == null ? null : _loanAllocationSettlementDateAvailabilitySequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noSettlePeriod")
        @RuneAttribute(value="noSettlePeriod")
        public LoanAllocationSettlementDateAvailabilityBuilder addNoSettlePeriod(LoanAllocationNoSettlePeriod _noSettlePeriod) {
            if (_noSettlePeriod != null) {
                this.noSettlePeriod.add(_noSettlePeriod.toBuilder());
            }
            return this;
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder addNoSettlePeriod(LoanAllocationNoSettlePeriod _noSettlePeriod, int idx) {
            this.getIndex(this.noSettlePeriod, idx, () -> _noSettlePeriod.toBuilder());
            return this;
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder addNoSettlePeriod(List<? extends LoanAllocationNoSettlePeriod> noSettlePeriods) {
            if (noSettlePeriods != null) {
                for (LoanAllocationNoSettlePeriod loanAllocationNoSettlePeriod : noSettlePeriods) {
                    this.noSettlePeriod.add(loanAllocationNoSettlePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="noSettlePeriod")
        public LoanAllocationSettlementDateAvailabilityBuilder setNoSettlePeriod(List<? extends LoanAllocationNoSettlePeriod> noSettlePeriods) {
            this.noSettlePeriod = noSettlePeriods == null ? new ArrayList<LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder>() : (List)noSettlePeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanAllocationSettlementDateAvailability build() {
            return new LoanAllocationSettlementDateAvailabilityImpl(this);
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder prune() {
            super.prune();
            if (this.specificDates != null && !this.specificDates.prune().hasData()) {
                this.specificDates = null;
            }
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.loanAllocationSettlementDateAvailabilitySequence != null && !this.loanAllocationSettlementDateAvailabilitySequence.prune().hasData()) {
                this.loanAllocationSettlementDateAvailabilitySequence = null;
            }
            this.noSettlePeriod = this.noSettlePeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSpecificDates() != null && this.getSpecificDates().hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getOnOrAfterDate() != null) {
                return true;
            }
            if (this.getLoanAllocationSettlementDateAvailabilitySequence() != null && this.getLoanAllocationSettlementDateAvailabilitySequence().hasData()) {
                return true;
            }
            return this.getNoSettlePeriod() != null && this.getNoSettlePeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanAllocationSettlementDateAvailabilityBuilder o = (LoanAllocationSettlementDateAvailabilityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpecificDates(), (RosettaModelObjectBuilder)o.getSpecificDates(), this::setSpecificDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanAllocationSettlementDateAvailabilitySequence(), (RosettaModelObjectBuilder)o.getLoanAllocationSettlementDateAvailabilitySequence(), this::setLoanAllocationSettlementDateAvailabilitySequence);
            merger.mergeRosetta(this.getNoSettlePeriod(), o.getNoSettlePeriod(), this::getOrCreateNoSettlePeriod);
            merger.mergeBasic((Object)this.getOnOrAfterDate(), (Object)o.getOnOrAfterDate(), this::setOnOrAfterDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationSettlementDateAvailability _that = (LoanAllocationSettlementDateAvailability)this.getType().cast(o);
            if (!Objects.equals(this.specificDates, _that.getSpecificDates())) {
                return false;
            }
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.onOrAfterDate, _that.getOnOrAfterDate())) {
                return false;
            }
            if (!Objects.equals(this.loanAllocationSettlementDateAvailabilitySequence, _that.getLoanAllocationSettlementDateAvailabilitySequence())) {
                return false;
            }
            return ListEquals.listEquals(this.noSettlePeriod, _that.getNoSettlePeriod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.specificDates != null ? this.specificDates.hashCode() : 0);
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.onOrAfterDate != null ? this.onOrAfterDate.hashCode() : 0);
            _result = 31 * _result + (this.loanAllocationSettlementDateAvailabilitySequence != null ? this.loanAllocationSettlementDateAvailabilitySequence.hashCode() : 0);
            _result = 31 * _result + (this.noSettlePeriod != null ? this.noSettlePeriod.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationSettlementDateAvailabilityBuilder {specificDates=" + this.specificDates + ", periodModel=" + this.periodModel + ", onOrAfterDate=" + this.onOrAfterDate + ", loanAllocationSettlementDateAvailabilitySequence=" + this.loanAllocationSettlementDateAvailabilitySequence + ", noSettlePeriod=" + this.noSettlePeriod + '}' + " " + super.toString();
        }
    }

    public static interface LoanAllocationSettlementDateAvailabilityBuilder
    extends LoanAllocationSettlementDateAvailability,
    AbstractLoanAllocationEvent.AbstractLoanAllocationEventBuilder {
        public DateList.DateListBuilder getOrCreateSpecificDates();

        @Override
        public DateList.DateListBuilder getSpecificDates();

        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public LoanAllocationSettlementDateAvailabilitySequence.LoanAllocationSettlementDateAvailabilitySequenceBuilder getOrCreateLoanAllocationSettlementDateAvailabilitySequence();

        @Override
        public LoanAllocationSettlementDateAvailabilitySequence.LoanAllocationSettlementDateAvailabilitySequenceBuilder getLoanAllocationSettlementDateAvailabilitySequence();

        public LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder getOrCreateNoSettlePeriod(int var1);

        public List<? extends LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder> getNoSettlePeriod();

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder setComment(String var1);

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder setAllocationReference(LoanAllocationReference var1);

        public LoanAllocationSettlementDateAvailabilityBuilder setSpecificDates(DateList var1);

        public LoanAllocationSettlementDateAvailabilityBuilder setPeriodModel(PeriodModel var1);

        public LoanAllocationSettlementDateAvailabilityBuilder setOnOrAfterDate(ZonedDateTime var1);

        public LoanAllocationSettlementDateAvailabilityBuilder setLoanAllocationSettlementDateAvailabilitySequence(LoanAllocationSettlementDateAvailabilitySequence var1);

        public LoanAllocationSettlementDateAvailabilityBuilder addNoSettlePeriod(LoanAllocationNoSettlePeriod var1);

        public LoanAllocationSettlementDateAvailabilityBuilder addNoSettlePeriod(LoanAllocationNoSettlePeriod var1, int var2);

        public LoanAllocationSettlementDateAvailabilityBuilder addNoSettlePeriod(List<? extends LoanAllocationNoSettlePeriod> var1);

        public LoanAllocationSettlementDateAvailabilityBuilder setNoSettlePeriod(List<? extends LoanAllocationNoSettlePeriod> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("allocationReference"), processor, LoanAllocationReference.LoanAllocationReferenceBuilder.class, (RosettaModelObjectBuilder)this.getAllocationReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("specificDates"), processor, DateList.DateListBuilder.class, this.getSpecificDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("onOrAfterDate"), ZonedDateTime.class, (Object)this.getOnOrAfterDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanAllocationSettlementDateAvailabilitySequence"), processor, LoanAllocationSettlementDateAvailabilitySequence.LoanAllocationSettlementDateAvailabilitySequenceBuilder.class, this.getLoanAllocationSettlementDateAvailabilitySequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("noSettlePeriod"), processor, LoanAllocationNoSettlePeriod.LoanAllocationNoSettlePeriodBuilder.class, this.getNoSettlePeriod(), new AttributeMeta[0]);
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder prune();
    }

    public static class LoanAllocationSettlementDateAvailabilityImpl
    extends AbstractLoanAllocationEvent.AbstractLoanAllocationEventImpl
    implements LoanAllocationSettlementDateAvailability {
        private final DateList specificDates;
        private final PeriodModel periodModel;
        private final ZonedDateTime onOrAfterDate;
        private final LoanAllocationSettlementDateAvailabilitySequence loanAllocationSettlementDateAvailabilitySequence;
        private final List<? extends LoanAllocationNoSettlePeriod> noSettlePeriod;

        protected LoanAllocationSettlementDateAvailabilityImpl(LoanAllocationSettlementDateAvailabilityBuilder builder) {
            super(builder);
            this.specificDates = Optional.ofNullable(builder.getSpecificDates()).map(f -> f.build()).orElse(null);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.onOrAfterDate = builder.getOnOrAfterDate();
            this.loanAllocationSettlementDateAvailabilitySequence = Optional.ofNullable(builder.getLoanAllocationSettlementDateAvailabilitySequence()).map(f -> f.build()).orElse(null);
            this.noSettlePeriod = Optional.ofNullable(builder.getNoSettlePeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="specificDates")
        @RuneAttribute(value="specificDates")
        public DateList getSpecificDates() {
            return this.specificDates;
        }

        @Override
        @RosettaAttribute(value="periodModel")
        @RuneAttribute(value="periodModel")
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="onOrAfterDate")
        @RuneAttribute(value="onOrAfterDate")
        public ZonedDateTime getOnOrAfterDate() {
            return this.onOrAfterDate;
        }

        @Override
        @RosettaAttribute(value="loanAllocationSettlementDateAvailabilitySequence")
        @RuneAttribute(value="loanAllocationSettlementDateAvailabilitySequence")
        public LoanAllocationSettlementDateAvailabilitySequence getLoanAllocationSettlementDateAvailabilitySequence() {
            return this.loanAllocationSettlementDateAvailabilitySequence;
        }

        @Override
        @RosettaAttribute(value="noSettlePeriod")
        @RuneAttribute(value="noSettlePeriod")
        public List<? extends LoanAllocationNoSettlePeriod> getNoSettlePeriod() {
            return this.noSettlePeriod;
        }

        @Override
        public LoanAllocationSettlementDateAvailability build() {
            return this;
        }

        @Override
        public LoanAllocationSettlementDateAvailabilityBuilder toBuilder() {
            LoanAllocationSettlementDateAvailabilityBuilder builder = LoanAllocationSettlementDateAvailability.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanAllocationSettlementDateAvailabilityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSpecificDates()).ifPresent(builder::setSpecificDates);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getOnOrAfterDate()).ifPresent(builder::setOnOrAfterDate);
            Optional.ofNullable(this.getLoanAllocationSettlementDateAvailabilitySequence()).ifPresent(builder::setLoanAllocationSettlementDateAvailabilitySequence);
            Optional.ofNullable(this.getNoSettlePeriod()).ifPresent(builder::setNoSettlePeriod);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationSettlementDateAvailability _that = (LoanAllocationSettlementDateAvailability)this.getType().cast(o);
            if (!Objects.equals(this.specificDates, _that.getSpecificDates())) {
                return false;
            }
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals(this.onOrAfterDate, _that.getOnOrAfterDate())) {
                return false;
            }
            if (!Objects.equals(this.loanAllocationSettlementDateAvailabilitySequence, _that.getLoanAllocationSettlementDateAvailabilitySequence())) {
                return false;
            }
            return ListEquals.listEquals(this.noSettlePeriod, _that.getNoSettlePeriod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.specificDates != null ? this.specificDates.hashCode() : 0);
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.onOrAfterDate != null ? this.onOrAfterDate.hashCode() : 0);
            _result = 31 * _result + (this.loanAllocationSettlementDateAvailabilitySequence != null ? this.loanAllocationSettlementDateAvailabilitySequence.hashCode() : 0);
            _result = 31 * _result + (this.noSettlePeriod != null ? this.noSettlePeriod.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationSettlementDateAvailability {specificDates=" + this.specificDates + ", periodModel=" + this.periodModel + ", onOrAfterDate=" + this.onOrAfterDate + ", loanAllocationSettlementDateAvailabilitySequence=" + this.loanAllocationSettlementDateAvailabilitySequence + ", noSettlePeriod=" + this.noSettlePeriod + '}' + " " + super.toString();
        }
    }
}

