/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractLoanAllocationNotification;
import fpml.consolidated.loan.DealDetailsModel;
import fpml.consolidated.loan.FacilityDetailsModel;
import fpml.consolidated.loan.LoanAllocationNotificationChoice0;
import fpml.consolidated.loan.LoanAllocationNotificationChoice1;
import fpml.consolidated.loan.LoanAllocationPayment;
import fpml.consolidated.loan.LoanTradeAllocationDetailsModel;
import fpml.consolidated.loan.LoanTradingPartyRole;
import fpml.consolidated.loan.meta.LoanAllocationNotificationMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanAllocationNotification", builder=LoanAllocationNotificationBuilderImpl.class, version="1.1.0")
@RuneDataType(value="LoanAllocationNotification", model="fpml", builder=LoanAllocationNotificationBuilderImpl.class, version="1.1.0")
public interface LoanAllocationNotification
extends AbstractLoanAllocationNotification {
    public static final LoanAllocationNotificationMeta metaData = new LoanAllocationNotificationMeta();

    public List<? extends LoanAllocationNotificationChoice0> getLoanAllocationNotificationChoice0();

    public LoanTradeAllocationDetailsModel getLoanTradeAllocationDetailsModel();

    public DealDetailsModel getDealDetailsModel();

    public FacilityDetailsModel getFacilityDetailsModel();

    public List<? extends LoanAllocationNotificationChoice1> getLoanAllocationNotificationChoice1();

    public List<? extends Party> getParty();

    @Override
    public LoanAllocationNotification build();

    @Override
    public LoanAllocationNotificationBuilder toBuilder();

    public static LoanAllocationNotificationBuilder builder() {
        return new LoanAllocationNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanAllocationNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanAllocationNotification> getType() {
        return LoanAllocationNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("role"), processor, LoanTradingPartyRole.class, this.getRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, LoanAllocationPayment.class, this.getPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanAllocationNotificationChoice0"), processor, LoanAllocationNotificationChoice0.class, this.getLoanAllocationNotificationChoice0(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradeAllocationDetailsModel"), processor, LoanTradeAllocationDetailsModel.class, this.getLoanTradeAllocationDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanAllocationNotificationChoice1"), processor, LoanAllocationNotificationChoice1.class, this.getLoanAllocationNotificationChoice1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class LoanAllocationNotificationBuilderImpl
    extends AbstractLoanAllocationNotification.AbstractLoanAllocationNotificationBuilderImpl
    implements LoanAllocationNotificationBuilder {
        protected List<LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder> loanAllocationNotificationChoice0 = new ArrayList<LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder>();
        protected LoanTradeAllocationDetailsModel.LoanTradeAllocationDetailsModelBuilder loanTradeAllocationDetailsModel;
        protected DealDetailsModel.DealDetailsModelBuilder dealDetailsModel;
        protected FacilityDetailsModel.FacilityDetailsModelBuilder facilityDetailsModel;
        protected List<LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder> loanAllocationNotificationChoice1 = new ArrayList<LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="loanAllocationNotificationChoice0", isRequired=true)
        @RuneAttribute(value="loanAllocationNotificationChoice0", isRequired=true)
        public List<? extends LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder> getLoanAllocationNotificationChoice0() {
            return this.loanAllocationNotificationChoice0;
        }

        @Override
        public LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder getOrCreateLoanAllocationNotificationChoice0(int index) {
            if (this.loanAllocationNotificationChoice0 == null) {
                this.loanAllocationNotificationChoice0 = new ArrayList<LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder>();
            }
            return (LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder)this.getIndex(this.loanAllocationNotificationChoice0, index, () -> {
                LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder newLoanAllocationNotificationChoice0 = LoanAllocationNotificationChoice0.builder();
                return newLoanAllocationNotificationChoice0;
            });
        }

        @Override
        @RosettaAttribute(value="loanTradeAllocationDetailsModel", isRequired=true)
        @RuneAttribute(value="loanTradeAllocationDetailsModel", isRequired=true)
        public LoanTradeAllocationDetailsModel.LoanTradeAllocationDetailsModelBuilder getLoanTradeAllocationDetailsModel() {
            return this.loanTradeAllocationDetailsModel;
        }

        @Override
        public LoanTradeAllocationDetailsModel.LoanTradeAllocationDetailsModelBuilder getOrCreateLoanTradeAllocationDetailsModel() {
            LoanTradeAllocationDetailsModel.LoanTradeAllocationDetailsModelBuilder result = this.loanTradeAllocationDetailsModel != null ? this.loanTradeAllocationDetailsModel : (this.loanTradeAllocationDetailsModel = LoanTradeAllocationDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel() {
            DealDetailsModel.DealDetailsModelBuilder result = this.dealDetailsModel != null ? this.dealDetailsModel : (this.dealDetailsModel = DealDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel() {
            FacilityDetailsModel.FacilityDetailsModelBuilder result = this.facilityDetailsModel != null ? this.facilityDetailsModel : (this.facilityDetailsModel = FacilityDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanAllocationNotificationChoice1")
        @RuneAttribute(value="loanAllocationNotificationChoice1")
        public List<? extends LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder> getLoanAllocationNotificationChoice1() {
            return this.loanAllocationNotificationChoice1;
        }

        @Override
        public LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder getOrCreateLoanAllocationNotificationChoice1(int index) {
            if (this.loanAllocationNotificationChoice1 == null) {
                this.loanAllocationNotificationChoice1 = new ArrayList<LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder>();
            }
            return (LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder)this.getIndex(this.loanAllocationNotificationChoice1, index, () -> {
                LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder newLoanAllocationNotificationChoice1 = LoanAllocationNotificationChoice1.builder();
                return newLoanAllocationNotificationChoice1;
            });
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public LoanAllocationNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public LoanAllocationNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public LoanAllocationNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public LoanAllocationNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public LoanAllocationNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public LoanAllocationNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public LoanAllocationNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public LoanAllocationNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public LoanAllocationNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LoanAllocationNotificationBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="role", isRequired=true)
        @RuneAttribute(value="role", isRequired=true)
        public LoanAllocationNotificationBuilder setRole(LoanTradingPartyRole _role) {
            this.role = _role == null ? null : _role.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public LoanAllocationNotificationBuilder addPayment(LoanAllocationPayment _payment) {
            if (_payment != null) {
                this.payment.add(_payment.toBuilder());
            }
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder addPayment(LoanAllocationPayment _payment, int idx) {
            this.getIndex(this.payment, idx, () -> _payment.toBuilder());
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder addPayment(List<? extends LoanAllocationPayment> payments) {
            if (payments != null) {
                for (LoanAllocationPayment loanAllocationPayment : payments) {
                    this.payment.add(loanAllocationPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payment")
        public LoanAllocationNotificationBuilder setPayment(List<? extends LoanAllocationPayment> payments) {
            this.payment = payments == null ? new ArrayList() : (List)payments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanAllocationNotificationChoice0", isRequired=true)
        @RuneAttribute(value="loanAllocationNotificationChoice0", isRequired=true)
        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice0(LoanAllocationNotificationChoice0 _loanAllocationNotificationChoice0) {
            if (_loanAllocationNotificationChoice0 != null) {
                this.loanAllocationNotificationChoice0.add(_loanAllocationNotificationChoice0.toBuilder());
            }
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice0(LoanAllocationNotificationChoice0 _loanAllocationNotificationChoice0, int idx) {
            this.getIndex(this.loanAllocationNotificationChoice0, idx, () -> _loanAllocationNotificationChoice0.toBuilder());
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice0(List<? extends LoanAllocationNotificationChoice0> loanAllocationNotificationChoice0s) {
            if (loanAllocationNotificationChoice0s != null) {
                for (LoanAllocationNotificationChoice0 loanAllocationNotificationChoice0 : loanAllocationNotificationChoice0s) {
                    this.loanAllocationNotificationChoice0.add(loanAllocationNotificationChoice0.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanAllocationNotificationChoice0")
        public LoanAllocationNotificationBuilder setLoanAllocationNotificationChoice0(List<? extends LoanAllocationNotificationChoice0> loanAllocationNotificationChoice0s) {
            this.loanAllocationNotificationChoice0 = loanAllocationNotificationChoice0s == null ? new ArrayList<LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder>() : (List)loanAllocationNotificationChoice0s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradeAllocationDetailsModel", isRequired=true)
        @RuneAttribute(value="loanTradeAllocationDetailsModel", isRequired=true)
        public LoanAllocationNotificationBuilder setLoanTradeAllocationDetailsModel(LoanTradeAllocationDetailsModel _loanTradeAllocationDetailsModel) {
            this.loanTradeAllocationDetailsModel = _loanTradeAllocationDetailsModel == null ? null : _loanTradeAllocationDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public LoanAllocationNotificationBuilder setDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            this.dealDetailsModel = _dealDetailsModel == null ? null : _dealDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public LoanAllocationNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel _facilityDetailsModel) {
            this.facilityDetailsModel = _facilityDetailsModel == null ? null : _facilityDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanAllocationNotificationChoice1")
        @RuneAttribute(value="loanAllocationNotificationChoice1")
        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice1(LoanAllocationNotificationChoice1 _loanAllocationNotificationChoice1) {
            if (_loanAllocationNotificationChoice1 != null) {
                this.loanAllocationNotificationChoice1.add(_loanAllocationNotificationChoice1.toBuilder());
            }
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice1(LoanAllocationNotificationChoice1 _loanAllocationNotificationChoice1, int idx) {
            this.getIndex(this.loanAllocationNotificationChoice1, idx, () -> _loanAllocationNotificationChoice1.toBuilder());
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice1(List<? extends LoanAllocationNotificationChoice1> loanAllocationNotificationChoice1s) {
            if (loanAllocationNotificationChoice1s != null) {
                for (LoanAllocationNotificationChoice1 loanAllocationNotificationChoice1 : loanAllocationNotificationChoice1s) {
                    this.loanAllocationNotificationChoice1.add(loanAllocationNotificationChoice1.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanAllocationNotificationChoice1")
        public LoanAllocationNotificationBuilder setLoanAllocationNotificationChoice1(List<? extends LoanAllocationNotificationChoice1> loanAllocationNotificationChoice1s) {
            this.loanAllocationNotificationChoice1 = loanAllocationNotificationChoice1s == null ? new ArrayList<LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder>() : (List)loanAllocationNotificationChoice1s.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public LoanAllocationNotificationBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public LoanAllocationNotificationBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanAllocationNotification build() {
            return new LoanAllocationNotificationImpl(this);
        }

        @Override
        public LoanAllocationNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder prune() {
            super.prune();
            this.loanAllocationNotificationChoice0 = this.loanAllocationNotificationChoice0.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.loanTradeAllocationDetailsModel != null && !this.loanTradeAllocationDetailsModel.prune().hasData()) {
                this.loanTradeAllocationDetailsModel = null;
            }
            if (this.dealDetailsModel != null && !this.dealDetailsModel.prune().hasData()) {
                this.dealDetailsModel = null;
            }
            if (this.facilityDetailsModel != null && !this.facilityDetailsModel.prune().hasData()) {
                this.facilityDetailsModel = null;
            }
            this.loanAllocationNotificationChoice1 = this.loanAllocationNotificationChoice1.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLoanAllocationNotificationChoice0() != null && this.getLoanAllocationNotificationChoice0().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLoanTradeAllocationDetailsModel() != null && this.getLoanTradeAllocationDetailsModel().hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().hasData()) {
                return true;
            }
            if (this.getFacilityDetailsModel() != null && this.getFacilityDetailsModel().hasData()) {
                return true;
            }
            if (this.getLoanAllocationNotificationChoice1() != null && this.getLoanAllocationNotificationChoice1().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public LoanAllocationNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanAllocationNotificationBuilder o = (LoanAllocationNotificationBuilder)other;
            merger.mergeRosetta(this.getLoanAllocationNotificationChoice0(), o.getLoanAllocationNotificationChoice0(), this::getOrCreateLoanAllocationNotificationChoice0);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradeAllocationDetailsModel(), (RosettaModelObjectBuilder)o.getLoanTradeAllocationDetailsModel(), this::setLoanTradeAllocationDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealDetailsModel(), (RosettaModelObjectBuilder)o.getDealDetailsModel(), this::setDealDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityDetailsModel(), (RosettaModelObjectBuilder)o.getFacilityDetailsModel(), this::setFacilityDetailsModel);
            merger.mergeRosetta(this.getLoanAllocationNotificationChoice1(), o.getLoanAllocationNotificationChoice1(), this::getOrCreateLoanAllocationNotificationChoice1);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationNotification _that = (LoanAllocationNotification)this.getType().cast(o);
            if (!ListEquals.listEquals(this.loanAllocationNotificationChoice0, _that.getLoanAllocationNotificationChoice0())) {
                return false;
            }
            if (!Objects.equals(this.loanTradeAllocationDetailsModel, _that.getLoanTradeAllocationDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanAllocationNotificationChoice1, _that.getLoanAllocationNotificationChoice1())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanAllocationNotificationChoice0 != null ? this.loanAllocationNotificationChoice0.hashCode() : 0);
            _result = 31 * _result + (this.loanTradeAllocationDetailsModel != null ? this.loanTradeAllocationDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.loanAllocationNotificationChoice1 != null ? this.loanAllocationNotificationChoice1.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationNotificationBuilder {loanAllocationNotificationChoice0=" + this.loanAllocationNotificationChoice0 + ", loanTradeAllocationDetailsModel=" + this.loanTradeAllocationDetailsModel + ", dealDetailsModel=" + this.dealDetailsModel + ", facilityDetailsModel=" + this.facilityDetailsModel + ", loanAllocationNotificationChoice1=" + this.loanAllocationNotificationChoice1 + ", party=" + this.party + '}' + " " + super.toString();
        }
    }

    public static interface LoanAllocationNotificationBuilder
    extends LoanAllocationNotification,
    AbstractLoanAllocationNotification.AbstractLoanAllocationNotificationBuilder {
        public LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder getOrCreateLoanAllocationNotificationChoice0(int var1);

        public List<? extends LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder> getLoanAllocationNotificationChoice0();

        public LoanTradeAllocationDetailsModel.LoanTradeAllocationDetailsModelBuilder getOrCreateLoanTradeAllocationDetailsModel();

        @Override
        public LoanTradeAllocationDetailsModel.LoanTradeAllocationDetailsModelBuilder getLoanTradeAllocationDetailsModel();

        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel();

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel();

        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel();

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel();

        public LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder getOrCreateLoanAllocationNotificationChoice1(int var1);

        public List<? extends LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder> getLoanAllocationNotificationChoice1();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public LoanAllocationNotificationBuilder setFpmlVersion(String var1);

        @Override
        public LoanAllocationNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public LoanAllocationNotificationBuilder setActualBuild(Integer var1);

        @Override
        public LoanAllocationNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public LoanAllocationNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public LoanAllocationNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public LoanAllocationNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public LoanAllocationNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public LoanAllocationNotificationBuilder setNoticeDate(ZonedDateTime var1);

        @Override
        public LoanAllocationNotificationBuilder setPartyReference(PartyReference var1);

        @Override
        public LoanAllocationNotificationBuilder setRole(LoanTradingPartyRole var1);

        @Override
        public LoanAllocationNotificationBuilder addPayment(LoanAllocationPayment var1);

        @Override
        public LoanAllocationNotificationBuilder addPayment(LoanAllocationPayment var1, int var2);

        @Override
        public LoanAllocationNotificationBuilder addPayment(List<? extends LoanAllocationPayment> var1);

        @Override
        public LoanAllocationNotificationBuilder setPayment(List<? extends LoanAllocationPayment> var1);

        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice0(LoanAllocationNotificationChoice0 var1);

        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice0(LoanAllocationNotificationChoice0 var1, int var2);

        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice0(List<? extends LoanAllocationNotificationChoice0> var1);

        public LoanAllocationNotificationBuilder setLoanAllocationNotificationChoice0(List<? extends LoanAllocationNotificationChoice0> var1);

        public LoanAllocationNotificationBuilder setLoanTradeAllocationDetailsModel(LoanTradeAllocationDetailsModel var1);

        public LoanAllocationNotificationBuilder setDealDetailsModel(DealDetailsModel var1);

        public LoanAllocationNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel var1);

        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice1(LoanAllocationNotificationChoice1 var1);

        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice1(LoanAllocationNotificationChoice1 var1, int var2);

        public LoanAllocationNotificationBuilder addLoanAllocationNotificationChoice1(List<? extends LoanAllocationNotificationChoice1> var1);

        public LoanAllocationNotificationBuilder setLoanAllocationNotificationChoice1(List<? extends LoanAllocationNotificationChoice1> var1);

        public LoanAllocationNotificationBuilder addParty(Party var1);

        public LoanAllocationNotificationBuilder addParty(Party var1, int var2);

        public LoanAllocationNotificationBuilder addParty(List<? extends Party> var1);

        public LoanAllocationNotificationBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("role"), processor, LoanTradingPartyRole.LoanTradingPartyRoleBuilder.class, (RosettaModelObjectBuilder)this.getRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, LoanAllocationPayment.LoanAllocationPaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanAllocationNotificationChoice0"), processor, LoanAllocationNotificationChoice0.LoanAllocationNotificationChoice0Builder.class, this.getLoanAllocationNotificationChoice0(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradeAllocationDetailsModel"), processor, LoanTradeAllocationDetailsModel.LoanTradeAllocationDetailsModelBuilder.class, this.getLoanTradeAllocationDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.FacilityDetailsModelBuilder.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanAllocationNotificationChoice1"), processor, LoanAllocationNotificationChoice1.LoanAllocationNotificationChoice1Builder.class, this.getLoanAllocationNotificationChoice1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public LoanAllocationNotificationBuilder prune();
    }

    public static class LoanAllocationNotificationImpl
    extends AbstractLoanAllocationNotification.AbstractLoanAllocationNotificationImpl
    implements LoanAllocationNotification {
        private final List<? extends LoanAllocationNotificationChoice0> loanAllocationNotificationChoice0;
        private final LoanTradeAllocationDetailsModel loanTradeAllocationDetailsModel;
        private final DealDetailsModel dealDetailsModel;
        private final FacilityDetailsModel facilityDetailsModel;
        private final List<? extends LoanAllocationNotificationChoice1> loanAllocationNotificationChoice1;
        private final List<? extends Party> party;

        protected LoanAllocationNotificationImpl(LoanAllocationNotificationBuilder builder) {
            super(builder);
            this.loanAllocationNotificationChoice0 = Optional.ofNullable(builder.getLoanAllocationNotificationChoice0()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.loanTradeAllocationDetailsModel = Optional.ofNullable(builder.getLoanTradeAllocationDetailsModel()).map(f -> f.build()).orElse(null);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).map(f -> f.build()).orElse(null);
            this.facilityDetailsModel = Optional.ofNullable(builder.getFacilityDetailsModel()).map(f -> f.build()).orElse(null);
            this.loanAllocationNotificationChoice1 = Optional.ofNullable(builder.getLoanAllocationNotificationChoice1()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanAllocationNotificationChoice0", isRequired=true)
        @RuneAttribute(value="loanAllocationNotificationChoice0", isRequired=true)
        public List<? extends LoanAllocationNotificationChoice0> getLoanAllocationNotificationChoice0() {
            return this.loanAllocationNotificationChoice0;
        }

        @Override
        @RosettaAttribute(value="loanTradeAllocationDetailsModel", isRequired=true)
        @RuneAttribute(value="loanTradeAllocationDetailsModel", isRequired=true)
        public LoanTradeAllocationDetailsModel getLoanTradeAllocationDetailsModel() {
            return this.loanTradeAllocationDetailsModel;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        @RosettaAttribute(value="loanAllocationNotificationChoice1")
        @RuneAttribute(value="loanAllocationNotificationChoice1")
        public List<? extends LoanAllocationNotificationChoice1> getLoanAllocationNotificationChoice1() {
            return this.loanAllocationNotificationChoice1;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public LoanAllocationNotification build() {
            return this;
        }

        @Override
        public LoanAllocationNotificationBuilder toBuilder() {
            LoanAllocationNotificationBuilder builder = LoanAllocationNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanAllocationNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanAllocationNotificationChoice0()).ifPresent(builder::setLoanAllocationNotificationChoice0);
            Optional.ofNullable(this.getLoanTradeAllocationDetailsModel()).ifPresent(builder::setLoanTradeAllocationDetailsModel);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getFacilityDetailsModel()).ifPresent(builder::setFacilityDetailsModel);
            Optional.ofNullable(this.getLoanAllocationNotificationChoice1()).ifPresent(builder::setLoanAllocationNotificationChoice1);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanAllocationNotification _that = (LoanAllocationNotification)this.getType().cast(o);
            if (!ListEquals.listEquals(this.loanAllocationNotificationChoice0, _that.getLoanAllocationNotificationChoice0())) {
                return false;
            }
            if (!Objects.equals(this.loanTradeAllocationDetailsModel, _that.getLoanTradeAllocationDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanAllocationNotificationChoice1, _that.getLoanAllocationNotificationChoice1())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanAllocationNotificationChoice0 != null ? this.loanAllocationNotificationChoice0.hashCode() : 0);
            _result = 31 * _result + (this.loanTradeAllocationDetailsModel != null ? this.loanTradeAllocationDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.loanAllocationNotificationChoice1 != null ? this.loanAllocationNotificationChoice1.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanAllocationNotification {loanAllocationNotificationChoice0=" + this.loanAllocationNotificationChoice0 + ", loanTradeAllocationDetailsModel=" + this.loanTradeAllocationDetailsModel + ", dealDetailsModel=" + this.dealDetailsModel + ", facilityDetailsModel=" + this.facilityDetailsModel + ", loanAllocationNotificationChoice1=" + this.loanAllocationNotificationChoice1 + ", party=" + this.party + '}' + " " + super.toString();
        }
    }
}

