/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.loan.DealRolesModel;
import fpml.consolidated.loan.DealRulesModel;
import fpml.consolidated.loan.DealSequence;
import fpml.consolidated.loan.DealSummary;
import fpml.consolidated.loan.DealSummarySequence;
import fpml.consolidated.loan.LoanCovenantObligation;
import fpml.consolidated.loan.meta.DealMeta;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.InstrumentId;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Deal", builder=DealBuilderImpl.class, version="1.1.0")
@RuneDataType(value="Deal", model="fpml", builder=DealBuilderImpl.class, version="1.1.0")
public interface Deal
extends DealSummary {
    public static final DealMeta metaData = new DealMeta();

    public DealRulesModel getDealRulesModel();

    public List<? extends LoanCovenantObligation> getCovenant();

    public List<? extends DealSequence> getDealSequence();

    @Override
    public Deal build();

    @Override
    public DealBuilder toBuilder();

    public static DealBuilder builder() {
        return new DealBuilderImpl();
    }

    default public RosettaMetaData<? extends Deal> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Deal> getType() {
        return Deal.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealRolesModel"), processor, DealRolesModel.class, this.getDealRolesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("creditAgreementDate"), ZonedDateTime.class, (Object)this.getCreditAgreementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, Currency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealSummarySequence"), processor, DealSummarySequence.class, this.getDealSummarySequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealRulesModel"), processor, DealRulesModel.class, this.getDealRulesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("covenant"), processor, LoanCovenantObligation.class, this.getCovenant(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealSequence"), processor, DealSequence.class, this.getDealSequence(), new AttributeMeta[0]);
    }

    public static class DealBuilderImpl
    extends DealSummary.DealSummaryBuilderImpl
    implements DealBuilder {
        protected DealRulesModel.DealRulesModelBuilder dealRulesModel;
        protected List<LoanCovenantObligation.LoanCovenantObligationBuilder> covenant = new ArrayList<LoanCovenantObligation.LoanCovenantObligationBuilder>();
        protected List<DealSequence.DealSequenceBuilder> dealSequence = new ArrayList<DealSequence.DealSequenceBuilder>();

        @Override
        @RosettaAttribute(value="dealRulesModel", isRequired=true)
        @RuneAttribute(value="dealRulesModel", isRequired=true)
        public DealRulesModel.DealRulesModelBuilder getDealRulesModel() {
            return this.dealRulesModel;
        }

        @Override
        public DealRulesModel.DealRulesModelBuilder getOrCreateDealRulesModel() {
            DealRulesModel.DealRulesModelBuilder result = this.dealRulesModel != null ? this.dealRulesModel : (this.dealRulesModel = DealRulesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="covenant")
        @RuneAttribute(value="covenant")
        public List<? extends LoanCovenantObligation.LoanCovenantObligationBuilder> getCovenant() {
            return this.covenant;
        }

        @Override
        public LoanCovenantObligation.LoanCovenantObligationBuilder getOrCreateCovenant(int index) {
            if (this.covenant == null) {
                this.covenant = new ArrayList<LoanCovenantObligation.LoanCovenantObligationBuilder>();
            }
            return (LoanCovenantObligation.LoanCovenantObligationBuilder)this.getIndex(this.covenant, index, () -> {
                LoanCovenantObligation.LoanCovenantObligationBuilder newCovenant = LoanCovenantObligation.builder();
                return newCovenant;
            });
        }

        @Override
        @RosettaAttribute(value="dealSequence", isRequired=true)
        @RuneAttribute(value="dealSequence", isRequired=true)
        public List<? extends DealSequence.DealSequenceBuilder> getDealSequence() {
            return this.dealSequence;
        }

        @Override
        public DealSequence.DealSequenceBuilder getOrCreateDealSequence(int index) {
            if (this.dealSequence == null) {
                this.dealSequence = new ArrayList<DealSequence.DealSequenceBuilder>();
            }
            return (DealSequence.DealSequenceBuilder)this.getIndex(this.dealSequence, index, () -> {
                DealSequence.DealSequenceBuilder newDealSequence = DealSequence.builder();
                return newDealSequence;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public DealBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public DealBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public DealBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public DealBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public DealBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public DealBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public DealBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="dealRolesModel", isRequired=true)
        @RuneAttribute(value="dealRolesModel", isRequired=true)
        public DealBuilder setDealRolesModel(DealRolesModel _dealRolesModel) {
            this.dealRolesModel = _dealRolesModel == null ? null : _dealRolesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditAgreementDate", isRequired=true)
        @RuneAttribute(value="creditAgreementDate", isRequired=true)
        public DealBuilder setCreditAgreementDate(ZonedDateTime _creditAgreementDate) {
            this.creditAgreementDate = _creditAgreementDate == null ? null : _creditAgreementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public DealBuilder setCurrency(Currency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealSummarySequence")
        @RuneAttribute(value="dealSummarySequence")
        public DealBuilder setDealSummarySequence(DealSummarySequence _dealSummarySequence) {
            this.dealSummarySequence = _dealSummarySequence == null ? null : _dealSummarySequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealRulesModel", isRequired=true)
        @RuneAttribute(value="dealRulesModel", isRequired=true)
        public DealBuilder setDealRulesModel(DealRulesModel _dealRulesModel) {
            this.dealRulesModel = _dealRulesModel == null ? null : _dealRulesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="covenant")
        @RuneAttribute(value="covenant")
        public DealBuilder addCovenant(LoanCovenantObligation _covenant) {
            if (_covenant != null) {
                this.covenant.add(_covenant.toBuilder());
            }
            return this;
        }

        @Override
        public DealBuilder addCovenant(LoanCovenantObligation _covenant, int idx) {
            this.getIndex(this.covenant, idx, () -> _covenant.toBuilder());
            return this;
        }

        @Override
        public DealBuilder addCovenant(List<? extends LoanCovenantObligation> covenants) {
            if (covenants != null) {
                for (LoanCovenantObligation loanCovenantObligation : covenants) {
                    this.covenant.add(loanCovenantObligation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="covenant")
        public DealBuilder setCovenant(List<? extends LoanCovenantObligation> covenants) {
            this.covenant = covenants == null ? new ArrayList<LoanCovenantObligation.LoanCovenantObligationBuilder>() : (List)covenants.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="dealSequence", isRequired=true)
        @RuneAttribute(value="dealSequence", isRequired=true)
        public DealBuilder addDealSequence(DealSequence _dealSequence) {
            if (_dealSequence != null) {
                this.dealSequence.add(_dealSequence.toBuilder());
            }
            return this;
        }

        @Override
        public DealBuilder addDealSequence(DealSequence _dealSequence, int idx) {
            this.getIndex(this.dealSequence, idx, () -> _dealSequence.toBuilder());
            return this;
        }

        @Override
        public DealBuilder addDealSequence(List<? extends DealSequence> dealSequences) {
            if (dealSequences != null) {
                for (DealSequence dealSequence : dealSequences) {
                    this.dealSequence.add(dealSequence.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dealSequence")
        public DealBuilder setDealSequence(List<? extends DealSequence> dealSequences) {
            this.dealSequence = dealSequences == null ? new ArrayList<DealSequence.DealSequenceBuilder>() : (List)dealSequences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Deal build() {
            return new DealImpl(this);
        }

        @Override
        public DealBuilder toBuilder() {
            return this;
        }

        @Override
        public DealBuilder prune() {
            super.prune();
            if (this.dealRulesModel != null && !this.dealRulesModel.prune().hasData()) {
                this.dealRulesModel = null;
            }
            this.covenant = this.covenant.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.dealSequence = this.dealSequence.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDealRulesModel() != null && this.getDealRulesModel().hasData()) {
                return true;
            }
            if (this.getCovenant() != null && this.getCovenant().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDealSequence() != null && this.getDealSequence().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public DealBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DealBuilder o = (DealBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealRulesModel(), (RosettaModelObjectBuilder)o.getDealRulesModel(), this::setDealRulesModel);
            merger.mergeRosetta(this.getCovenant(), o.getCovenant(), this::getOrCreateCovenant);
            merger.mergeRosetta(this.getDealSequence(), o.getDealSequence(), this::getOrCreateDealSequence);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Deal _that = (Deal)this.getType().cast(o);
            if (!Objects.equals(this.dealRulesModel, _that.getDealRulesModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.covenant, _that.getCovenant())) {
                return false;
            }
            return ListEquals.listEquals(this.dealSequence, _that.getDealSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealRulesModel != null ? this.dealRulesModel.hashCode() : 0);
            _result = 31 * _result + (this.covenant != null ? this.covenant.hashCode() : 0);
            _result = 31 * _result + (this.dealSequence != null ? this.dealSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DealBuilder {dealRulesModel=" + this.dealRulesModel + ", covenant=" + this.covenant + ", dealSequence=" + this.dealSequence + '}' + " " + super.toString();
        }
    }

    public static interface DealBuilder
    extends Deal,
    DealSummary.DealSummaryBuilder {
        public DealRulesModel.DealRulesModelBuilder getOrCreateDealRulesModel();

        @Override
        public DealRulesModel.DealRulesModelBuilder getDealRulesModel();

        public LoanCovenantObligation.LoanCovenantObligationBuilder getOrCreateCovenant(int var1);

        public List<? extends LoanCovenantObligation.LoanCovenantObligationBuilder> getCovenant();

        public DealSequence.DealSequenceBuilder getOrCreateDealSequence(int var1);

        public List<? extends DealSequence.DealSequenceBuilder> getDealSequence();

        @Override
        public DealBuilder setId(String var1);

        @Override
        public DealBuilder setPartyReference(PartyReference var1);

        @Override
        public DealBuilder addInstrumentId(InstrumentId var1);

        @Override
        public DealBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public DealBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public DealBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public DealBuilder setDescription(String var1);

        @Override
        public DealBuilder setDealRolesModel(DealRolesModel var1);

        @Override
        public DealBuilder setCreditAgreementDate(ZonedDateTime var1);

        @Override
        public DealBuilder setCurrency(Currency var1);

        @Override
        public DealBuilder setDealSummarySequence(DealSummarySequence var1);

        public DealBuilder setDealRulesModel(DealRulesModel var1);

        public DealBuilder addCovenant(LoanCovenantObligation var1);

        public DealBuilder addCovenant(LoanCovenantObligation var1, int var2);

        public DealBuilder addCovenant(List<? extends LoanCovenantObligation> var1);

        public DealBuilder setCovenant(List<? extends LoanCovenantObligation> var1);

        public DealBuilder addDealSequence(DealSequence var1);

        public DealBuilder addDealSequence(DealSequence var1, int var2);

        public DealBuilder addDealSequence(List<? extends DealSequence> var1);

        public DealBuilder setDealSequence(List<? extends DealSequence> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealRolesModel"), processor, DealRolesModel.DealRolesModelBuilder.class, (RosettaModelObjectBuilder)this.getDealRolesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("creditAgreementDate"), ZonedDateTime.class, (Object)this.getCreditAgreementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, Currency.CurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealSummarySequence"), processor, DealSummarySequence.DealSummarySequenceBuilder.class, (RosettaModelObjectBuilder)this.getDealSummarySequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealRulesModel"), processor, DealRulesModel.DealRulesModelBuilder.class, this.getDealRulesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("covenant"), processor, LoanCovenantObligation.LoanCovenantObligationBuilder.class, this.getCovenant(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealSequence"), processor, DealSequence.DealSequenceBuilder.class, this.getDealSequence(), new AttributeMeta[0]);
        }

        @Override
        public DealBuilder prune();
    }

    public static class DealImpl
    extends DealSummary.DealSummaryImpl
    implements Deal {
        private final DealRulesModel dealRulesModel;
        private final List<? extends LoanCovenantObligation> covenant;
        private final List<? extends DealSequence> dealSequence;

        protected DealImpl(DealBuilder builder) {
            super(builder);
            this.dealRulesModel = Optional.ofNullable(builder.getDealRulesModel()).map(f -> f.build()).orElse(null);
            this.covenant = Optional.ofNullable(builder.getCovenant()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.dealSequence = Optional.ofNullable(builder.getDealSequence()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="dealRulesModel", isRequired=true)
        @RuneAttribute(value="dealRulesModel", isRequired=true)
        public DealRulesModel getDealRulesModel() {
            return this.dealRulesModel;
        }

        @Override
        @RosettaAttribute(value="covenant")
        @RuneAttribute(value="covenant")
        public List<? extends LoanCovenantObligation> getCovenant() {
            return this.covenant;
        }

        @Override
        @RosettaAttribute(value="dealSequence", isRequired=true)
        @RuneAttribute(value="dealSequence", isRequired=true)
        public List<? extends DealSequence> getDealSequence() {
            return this.dealSequence;
        }

        @Override
        public Deal build() {
            return this;
        }

        @Override
        public DealBuilder toBuilder() {
            DealBuilder builder = Deal.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DealBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDealRulesModel()).ifPresent(builder::setDealRulesModel);
            Optional.ofNullable(this.getCovenant()).ifPresent(builder::setCovenant);
            Optional.ofNullable(this.getDealSequence()).ifPresent(builder::setDealSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Deal _that = (Deal)this.getType().cast(o);
            if (!Objects.equals(this.dealRulesModel, _that.getDealRulesModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.covenant, _that.getCovenant())) {
                return false;
            }
            return ListEquals.listEquals(this.dealSequence, _that.getDealSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.dealRulesModel != null ? this.dealRulesModel.hashCode() : 0);
            _result = 31 * _result + (this.covenant != null ? this.covenant.hashCode() : 0);
            _result = 31 * _result + (this.dealSequence != null ? this.dealSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Deal {dealRulesModel=" + this.dealRulesModel + ", covenant=" + this.covenant + ", dealSequence=" + this.dealSequence + '}' + " " + super.toString();
        }
    }
}

